/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class ArrayConverter
extends AbstractCollectionConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return type2.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration2, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration2, evaluator);
        if (type2.isInstance(value2)) {
            return value2;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = type2.getComponentType();
            if (value2 == null) {
                elements = this.fromChildren(lookup, configuration2, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value2 instanceof String) {
                PlexusConfiguration xml = ArrayConverter.csvToXml(configuration2, (String)value2);
                elements = this.fromChildren(lookup, xml, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value2 instanceof Collection) {
                elements = (Collection<Object>)value2;
            } else {
                this.failIfNotTypeCompatible(value2, type2, configuration2);
                elements = Collections.emptyList();
            }
            return elements.toArray((Object[])Array.newInstance(elementType, elements.size()));
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration2);
            }
            throw e;
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException(configuration2, "Cannot store value into array", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration2, Class<?> type2, ClassLoader loader) {
        return new ArrayList<Object>(configuration2.getChildCount());
    }
}

