/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.logging;

import org.apache.maven.shared.utils.logging.LoggerLevelRenderer;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.Style;
import org.fusesource.jansi.Ansi;

class AnsiMessageBuilder
implements MessageBuilder,
LoggerLevelRenderer {
    private Ansi ansi;

    AnsiMessageBuilder() {
        this(Ansi.ansi());
    }

    AnsiMessageBuilder(StringBuilder builder2) {
        this(Ansi.ansi(builder2));
    }

    AnsiMessageBuilder(int size) {
        this(Ansi.ansi(size));
    }

    AnsiMessageBuilder(Ansi ansi) {
        this.ansi = ansi;
    }

    @Override
    public String debug(String level) {
        return Style.DEBUG.apply(this.ansi).a(level).reset().toString();
    }

    @Override
    public String info(String level) {
        return Style.INFO.apply(this.ansi).a(level).reset().toString();
    }

    @Override
    public String warning(String level) {
        return Style.WARNING.apply(this.ansi).a(level).reset().toString();
    }

    @Override
    public String error(String level) {
        return Style.ERROR.apply(this.ansi).a(level).reset().toString();
    }

    @Override
    public AnsiMessageBuilder success(Object message2) {
        Style.SUCCESS.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder warning(Object message2) {
        Style.WARNING.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder failure(Object message2) {
        Style.FAILURE.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder strong(Object message2) {
        Style.STRONG.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder mojo(Object message2) {
        Style.MOJO.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder project(Object message2) {
        Style.PROJECT.apply(this.ansi).a(message2).reset();
        return this;
    }

    @Override
    public AnsiMessageBuilder a(char[] value2, int offset2, int len) {
        this.ansi.a(value2, offset2, len);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(char[] value2) {
        this.ansi.a(value2);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(CharSequence value2, int start, int end) {
        this.ansi.a(value2, start, end);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(CharSequence value2) {
        this.ansi.a(value2);
        return this;
    }

    @Override
    public AnsiMessageBuilder a(Object value2) {
        this.ansi.a(value2);
        return this;
    }

    @Override
    public AnsiMessageBuilder newline() {
        this.ansi.newline();
        return this;
    }

    @Override
    public AnsiMessageBuilder format(String pattern, Object ... args2) {
        this.ansi.format(pattern, args2);
        return this;
    }

    public String toString() {
        return this.ansi.toString();
    }
}

