/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        Settings settings2 = this.read(ReaderFactory.newXmlReader(input), options);
        return settings2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            Settings settings2 = new SettingsXpp3Reader().read(in, this.isStrict(options));
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = input;){
            Settings settings2 = new SettingsXpp3Reader().read(in, this.isStrict(options));
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value2 = options != null ? (Object)options.get("org.apache.maven.settings.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }
}

