/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.ConfigUtils;

@Named
@Singleton
public class DefaultVersionResolver
implements VersionResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT = "SNAPSHOT";
    private MetadataResolver metadataResolver;
    private SyncContextFactory syncContextFactory;
    private RepositoryEventDispatcher repositoryEventDispatcher;

    public DefaultVersionResolver() {
    }

    @Inject
    DefaultVersionResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        this.setMetadataResolver(metadataResolver);
        this.setSyncContextFactory(syncContextFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionResolver setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadataResolver cannot be null");
        return this;
    }

    public DefaultVersionResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "syncContextFactory cannot be null");
        return this;
    }

    public DefaultVersionResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session2, VersionRequest request) throws VersionResolutionException {
        DefaultMetadata metadata2;
        Object obj;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        Artifact artifact = request.getArtifact();
        String version = artifact.getVersion();
        VersionResult result2 = new VersionResult(request);
        Key cacheKey = null;
        RepositoryCache cache2 = session2.getCache();
        if (cache2 != null && !ConfigUtils.getBoolean(session2, false, "aether.versionResolver.noCache") && (obj = cache2.get(session2, cacheKey = new Key(session2, request))) instanceof Record) {
            Record record2 = (Record)obj;
            result2.setVersion(record2.version);
            result2.setRepository(this.getRepository(session2, request.getRepositories(), record2.repoClass, record2.repoId));
            return result2;
        }
        if (RELEASE.equals(version)) {
            metadata2 = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE);
        } else if (LATEST.equals(version)) {
            metadata2 = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        } else if (version.endsWith(SNAPSHOT)) {
            WorkspaceReader workspace = session2.getWorkspaceReader();
            if (workspace != null && workspace.findVersions(artifact).contains(version)) {
                metadata2 = null;
                result2.setRepository(workspace.getRepository());
            } else {
                metadata2 = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), version, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT);
            }
        } else {
            metadata2 = null;
        }
        if (metadata2 == null) {
            result2.setVersion(version);
        } else {
            ArrayList<Object> metadataReqs = new ArrayList<Object>(request.getRepositories().size());
            metadataReqs.add(new MetadataRequest(metadata2, null, request.getRequestContext()));
            for (RemoteRepository repository : request.getRepositories()) {
                MetadataRequest metadataRequest = new MetadataRequest(metadata2, repository, request.getRequestContext());
                metadataRequest.setDeleteLocalCopyIfMissing(true);
                metadataRequest.setFavorLocalRepository(true);
                metadataRequest.setTrace(trace);
                metadataReqs.add(metadataRequest);
            }
            List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session2, metadataReqs);
            HashMap<String, VersionInfo> infos2 = new HashMap<String, VersionInfo>();
            for (MetadataResult metadataResult : metadataResults) {
                result2.addException(metadataResult.getException());
                ArtifactRepository repository = metadataResult.getRequest().getRepository();
                if (repository == null) {
                    repository = session2.getLocalRepository();
                }
                Versioning v = this.readVersions(session2, trace, metadataResult.getMetadata(), repository, result2);
                this.merge(artifact, infos2, v, repository);
            }
            if (RELEASE.equals(version)) {
                this.resolve(result2, infos2, RELEASE);
            } else if (LATEST.equals(version)) {
                if (!this.resolve(result2, infos2, LATEST)) {
                    this.resolve(result2, infos2, RELEASE);
                }
                if (result2.getVersion() != null && result2.getVersion().endsWith(SNAPSHOT)) {
                    VersionRequest subRequest = new VersionRequest();
                    subRequest.setArtifact(artifact.setVersion(result2.getVersion()));
                    if (result2.getRepository() instanceof RemoteRepository) {
                        RemoteRepository r = (RemoteRepository)result2.getRepository();
                        subRequest.setRepositories(Collections.singletonList(r));
                    } else {
                        subRequest.setRepositories(request.getRepositories());
                    }
                    VersionResult subResult = this.resolveVersion(session2, subRequest);
                    result2.setVersion(subResult.getVersion());
                    result2.setRepository(subResult.getRepository());
                    for (Exception exception : subResult.getExceptions()) {
                        result2.addException(exception);
                    }
                }
            } else {
                String key = SNAPSHOT + this.getKey(artifact.getClassifier(), artifact.getExtension());
                this.merge(infos2, SNAPSHOT, key);
                if (!this.resolve(result2, infos2, key)) {
                    result2.setVersion(version);
                }
            }
            if (StringUtils.isEmpty(result2.getVersion())) {
                throw new VersionResolutionException(result2);
            }
        }
        if (cacheKey != null && metadata2 != null && this.isSafelyCacheable(session2, artifact)) {
            cache2.put(session2, cacheKey, new Record(result2.getVersion(), result2.getRepository()));
        }
        return result2;
    }

    private boolean resolve(VersionResult result2, Map<String, VersionInfo> infos2, String key) {
        VersionInfo info = infos2.get(key);
        if (info != null) {
            result2.setVersion(info.version);
            result2.setRepository(info.repository);
        }
        return info != null;
    }

    private Versioning readVersions(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, VersionResult result2) {
        Versioning versioning;
        block27: {
            versioning = null;
            try {
                if (metadata2 == null) break block27;
                try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, true);){
                    syncContext.acquire(null, Collections.singleton(metadata2));
                    if (metadata2.getFile() == null || !metadata2.getFile().exists()) break block27;
                    try (FileInputStream in = new FileInputStream(metadata2.getFile());){
                        versioning = new MetadataXpp3Reader().read(in, false).getVersioning();
                        if (versioning != null && repository instanceof LocalRepository && versioning.getSnapshot() != null && versioning.getSnapshot().getBuildNumber() > 0) {
                            Versioning repaired = new Versioning();
                            repaired.setLastUpdated(versioning.getLastUpdated());
                            repaired.setSnapshot(new Snapshot());
                            repaired.getSnapshot().setLocalCopy(true);
                            versioning = repaired;
                            throw new IOException("Snapshot information corrupted with remote repository data, please verify that no remote repository uses the id '" + repository.getId() + "'");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session2, trace, metadata2, repository, e);
                result2.addException(e);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata2);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void merge(Artifact artifact, Map<String, VersionInfo> infos2, Versioning versioning, ArtifactRepository repository) {
        if (StringUtils.isNotEmpty(versioning.getRelease())) {
            this.merge(RELEASE, infos2, versioning.getLastUpdated(), versioning.getRelease(), repository);
        }
        if (StringUtils.isNotEmpty(versioning.getLatest())) {
            this.merge(LATEST, infos2, versioning.getLastUpdated(), versioning.getLatest(), repository);
        }
        for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
            if (!StringUtils.isNotEmpty(sv.getVersion())) continue;
            String key = this.getKey(sv.getClassifier(), sv.getExtension());
            this.merge(SNAPSHOT + key, infos2, sv.getUpdated(), sv.getVersion(), repository);
        }
        Snapshot snapshot = versioning.getSnapshot();
        if (snapshot != null && versioning.getSnapshotVersions().isEmpty()) {
            String version = artifact.getVersion();
            if (snapshot.getTimestamp() != null && snapshot.getBuildNumber() > 0) {
                String qualifier = snapshot.getTimestamp() + '-' + snapshot.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            this.merge(SNAPSHOT, infos2, versioning.getLastUpdated(), version, repository);
        }
    }

    private void merge(String key, Map<String, VersionInfo> infos2, String timestamp, String version, ArtifactRepository repository) {
        VersionInfo info = infos2.get(key);
        if (info == null) {
            info = new VersionInfo(timestamp, version, repository);
            infos2.put(key, info);
        } else if (info.isOutdated(timestamp)) {
            info.version = version;
            info.repository = repository;
            info.timestamp = timestamp;
        }
    }

    private void merge(Map<String, VersionInfo> infos2, String srcKey, String dstKey) {
        VersionInfo srcInfo = infos2.get(srcKey);
        VersionInfo dstInfo = infos2.get(dstKey);
        if (dstInfo == null || srcInfo != null && dstInfo.isOutdated(srcInfo.timestamp) && srcInfo.repository != dstInfo.repository) {
            infos2.put(dstKey, srcInfo);
        }
    }

    private String getKey(String classifier2, String extension) {
        return StringUtils.clean(classifier2) + ':' + StringUtils.clean(extension);
    }

    private ArtifactRepository getRepository(RepositorySystemSession session2, List<RemoteRepository> repositories, Class<?> repoClass, String repoId) {
        if (repoClass != null) {
            if (WorkspaceRepository.class.isAssignableFrom(repoClass)) {
                return session2.getWorkspaceReader().getRepository();
            }
            if (LocalRepository.class.isAssignableFrom(repoClass)) {
                return session2.getLocalRepository();
            }
            for (RemoteRepository repository : repositories) {
                if (!repoId.equals(repository.getId())) continue;
                return repository;
            }
        }
        return null;
    }

    private boolean isSafelyCacheable(RepositorySystemSession session2, Artifact artifact) {
        WorkspaceReader workspace = session2.getWorkspaceReader();
        if (workspace == null) {
            return true;
        }
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(artifact);
        return workspace.findArtifact(pomArtifact) == null;
    }

    private static class Record {
        final String version;
        final String repoId;
        final Class<?> repoClass;

        Record(String version, ArtifactRepository repository) {
            this.version = version;
            if (repository != null) {
                this.repoId = repository.getId();
                this.repoClass = repository.getClass();
            } else {
                this.repoId = null;
                this.repoClass = null;
            }
        }
    }

    private static class Key {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;
        private final String version;
        private final String context;
        private final File localRepo;
        private final WorkspaceRepository workspace;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        Key(RepositorySystemSession session2, VersionRequest request) {
            Artifact artifact = request.getArtifact();
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.classifier = artifact.getClassifier();
            this.extension = artifact.getExtension();
            this.version = artifact.getVersion();
            this.localRepo = session2.getLocalRepository().getBasedir();
            WorkspaceReader reader = session2.getWorkspaceReader();
            this.workspace = reader != null ? reader.getRepository() : null;
            this.repositories = new ArrayList<RemoteRepository>(request.getRepositories().size());
            boolean repoMan = false;
            for (RemoteRepository repository : request.getRepositories()) {
                if (repository.isRepositoryManager()) {
                    repoMan = true;
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.context = repoMan ? request.getRequestContext() : "";
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.classifier.hashCode();
            hash = hash * 31 + this.extension.hashCode();
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + this.localRepo.hashCode();
            this.hashCode = hash = hash * 31 + this.repositories.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.classifier.equals(that.classifier) && this.extension.equals(that.extension) && this.version.equals(that.version) && this.context.equals(that.context) && this.localRepo.equals(that.localRepo) && Objects.equals(this.workspace, that.workspace) && this.repositories.equals(that.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class VersionInfo {
        String timestamp;
        String version;
        ArtifactRepository repository;

        VersionInfo(String timestamp, String version, ArtifactRepository repository) {
            this.timestamp = timestamp != null ? timestamp : "";
            this.version = version;
            this.repository = repository;
        }

        boolean isOutdated(String timestamp) {
            return timestamp != null && timestamp.compareTo(this.timestamp) > 0;
        }
    }
}

