/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.State;
import com.google.inject.internal.WeakKeySet;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class InheritingState
implements State {
    private final State parent;
    private final Map<Key<?>, Binding<?>> explicitBindingsMutable = Maps.newLinkedHashMap();
    private final Map<Key<?>, Binding<?>> explicitBindings = Collections.unmodifiableMap(this.explicitBindingsMutable);
    private final Map<Class<? extends Annotation>, ScopeBinding> scopes = Maps.newHashMap();
    private final List<TypeConverterBinding> converters = Lists.newArrayList();
    private final List<TypeListenerBinding> typeListenerBindings = Lists.newArrayList();
    private final List<ProvisionListenerBinding> provisionListenerBindings = Lists.newArrayList();
    private final List<ModuleAnnotatedMethodScannerBinding> scannerBindings = Lists.newArrayList();
    private final WeakKeySet blacklistedKeys;
    private final Object lock;

    InheritingState(State parent2) {
        this.parent = Preconditions.checkNotNull(parent2, "parent");
        this.lock = parent2 == State.NONE ? this : parent2.lock();
        this.blacklistedKeys = new WeakKeySet(this.lock);
    }

    @Override
    public State parent() {
        return this.parent;
    }

    @Override
    public <T> BindingImpl<T> getExplicitBinding(Key<T> key) {
        Binding<?> binding = this.explicitBindings.get(key);
        return binding != null ? (BindingImpl<T>)binding : this.parent.getExplicitBinding(key);
    }

    @Override
    public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
        return this.explicitBindings;
    }

    @Override
    public void putBinding(Key<?> key, BindingImpl<?> binding) {
        this.explicitBindingsMutable.put(key, binding);
    }

    @Override
    public ScopeBinding getScopeBinding(Class<? extends Annotation> annotationType) {
        ScopeBinding scopeBinding = this.scopes.get(annotationType);
        return scopeBinding != null ? scopeBinding : this.parent.getScopeBinding(annotationType);
    }

    @Override
    public void putScopeBinding(Class<? extends Annotation> annotationType, ScopeBinding scope2) {
        this.scopes.put(annotationType, scope2);
    }

    @Override
    public Iterable<TypeConverterBinding> getConvertersThisLevel() {
        return this.converters;
    }

    @Override
    public void addConverter(TypeConverterBinding typeConverterBinding) {
        this.converters.add(typeConverterBinding);
    }

    @Override
    public TypeConverterBinding getConverter(String stringValue, TypeLiteral<?> type2, Errors errors, Object source) {
        TypeConverterBinding matchingConverter = null;
        for (State s = this; s != State.NONE; s = s.parent()) {
            for (TypeConverterBinding converter : s.getConvertersThisLevel()) {
                if (!converter.getTypeMatcher().matches(type2)) continue;
                if (matchingConverter != null) {
                    errors.ambiguousTypeConversion(stringValue, source, type2, matchingConverter, converter);
                }
                matchingConverter = converter;
            }
        }
        return matchingConverter;
    }

    @Override
    public void addTypeListener(TypeListenerBinding listenerBinding) {
        this.typeListenerBindings.add(listenerBinding);
    }

    @Override
    public List<TypeListenerBinding> getTypeListenerBindings() {
        List<TypeListenerBinding> parentBindings = this.parent.getTypeListenerBindings();
        ArrayList<TypeListenerBinding> result2 = Lists.newArrayListWithCapacity(parentBindings.size() + this.typeListenerBindings.size());
        result2.addAll(parentBindings);
        result2.addAll(this.typeListenerBindings);
        return result2;
    }

    @Override
    public void addProvisionListener(ProvisionListenerBinding listenerBinding) {
        this.provisionListenerBindings.add(listenerBinding);
    }

    @Override
    public List<ProvisionListenerBinding> getProvisionListenerBindings() {
        List<ProvisionListenerBinding> parentBindings = this.parent.getProvisionListenerBindings();
        ArrayList<ProvisionListenerBinding> result2 = Lists.newArrayListWithCapacity(parentBindings.size() + this.provisionListenerBindings.size());
        result2.addAll(parentBindings);
        result2.addAll(this.provisionListenerBindings);
        return result2;
    }

    @Override
    public void addScanner(ModuleAnnotatedMethodScannerBinding scanner) {
        this.scannerBindings.add(scanner);
    }

    @Override
    public List<ModuleAnnotatedMethodScannerBinding> getScannerBindings() {
        List<ModuleAnnotatedMethodScannerBinding> parentBindings = this.parent.getScannerBindings();
        ArrayList<ModuleAnnotatedMethodScannerBinding> result2 = Lists.newArrayListWithCapacity(parentBindings.size() + this.scannerBindings.size());
        result2.addAll(parentBindings);
        result2.addAll(this.scannerBindings);
        return result2;
    }

    @Override
    public void blacklist(Key<?> key, State state2, Object source) {
        this.parent.blacklist(key, state2, source);
        this.blacklistedKeys.add(key, state2, source);
    }

    @Override
    public boolean isBlacklisted(Key<?> key) {
        return this.blacklistedKeys.contains(key);
    }

    @Override
    public Set<Object> getSourcesForBlacklistedKey(Key<?> key) {
        return this.blacklistedKeys.getSources(key);
    }

    @Override
    public Object lock() {
        return this.lock;
    }

    @Override
    public Map<Class<? extends Annotation>, Scope> getScopes() {
        ImmutableMap.Builder<Class<? extends Annotation>, Scope> builder2 = ImmutableMap.builder();
        for (Map.Entry<Class<? extends Annotation>, ScopeBinding> entry : this.scopes.entrySet()) {
            builder2.put(entry.getKey(), entry.getValue().getScope());
        }
        return builder2.build();
    }
}

