/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.vappearances.VAppearance;

public class SliderCircularIndicatorPainter {
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final double p;
    @NotNull
    protected final Colors colors;

    public SliderCircularIndicatorPainter(double d, double d2, double d3, double d4, double d5, @Nullable VAppearance vAppearance) {
        this.x = d;
        this.y = d2;
        this.radius = d3;
        this.zeroAngle = d4;
        this.p = d5;
        this.colors = Colors.getColors(vAppearance);
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        int n;
        double d = 6.0;
        double d2 = this.zeroAngle - this.p * 2.0 * Math.PI;
        double d3 = this.x + Math.cos(d2) * this.radius;
        double d4 = this.y - Math.sin(d2) * this.radius;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d3 - d / 2.0, d4 - d / 2.0, d, d);
        graphics2D.setColor(this.colors.get("circularSliderDimple"));
        graphics2D.fill(double_);
        Color color = this.colors.getOptional("circularSliderDimpleTop");
        if (color != null && (n = JNRPlatformUtils.getPlatformVersion()) < 101400) {
            double_ = new Ellipse2D.Double(d3 - d / 4.0, d4 - d / 2.0, d / 2.0, d / 2.0);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        }
    }
}

