/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;

public class AquaLineBorder
implements Border {
    private static final Insets borderInsets = new Insets(1, 1, 1, 1);
    private final String colorName;

    public AquaLineBorder(@NotNull String string) {
        this.colorName = string;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getColor(component);
        if (color == null) {
            color = Color.gray;
        }
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, 1);
        graphics.fillRect(n, n2 + 1, 1, n4 - 2);
        graphics.fillRect(n, n2 + n4 - 1, n3, 1);
        graphics.fillRect(n + n3 - 1, n2 + 1, 1, n4 - 2);
    }

    @Nullable
    protected Color getColor(@NotNull Component component) {
        AquaAppearance aquaAppearance = AppearanceManager.getAppearance(component);
        return aquaAppearance.getColor(this.colorName);
    }

    @Override
    @NotNull
    public Insets getBorderInsets(Component component) {
        return borderInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

