package gopass

import (
	"errors"
	"os"
)

var ErrInterrupted = errors.New("Interrupted")

// getPasswd returns the input read from terminal.
// If masked is true, typing will be matched by asterisks on the screen.
// Otherwise, typing will echo nothing.
func getPasswd(termDescriptor int, masked bool) ([]byte, error) {
	var pass, bs, mask []byte
	if masked {
		bs = []byte("\b \b")
		mask = []byte("*")
	}

	var err error
	for {
		if v := getch(termDescriptor); v == 127 || v == 8 {
			if l := len(pass); l > 0 {
				pass = pass[:l-1]
				os.Stdout.Write(bs)
			}
		} else if v == 13 || v == 10 || v == 4 {
			break
		} else if v == 3 {
			err = ErrInterrupted
			break
		} else if v != 0 {
			pass = append(pass, v)
			os.Stdout.Write(mask)
		}
	}
	println()
	if err != nil {
		return nil, err
	}
	return pass, nil
}

// GetPasswd returns the password read from the terminal without echoing input.
// The returned byte array does not include end-of-line characters.
func GetPasswd(termDescriptor int) ([]byte, error) {
	return getPasswd(termDescriptor, false)
}

// GetPasswdMasked returns the password read from the terminal, echoing asterisks.
// The returned byte array does not include end-of-line characters.
func GetPasswdMasked(termDescriptor int) ([]byte, error) {
	return getPasswd(termDescriptor, true)
}
