/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.jobtracker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

public class TaskTracker {
    static final Log LOG = LogFactory.getLog(TaskTracker.class);
    private final String trackerName;
    private TaskTrackerStatus status;
    private JobInProgress jobForFallowMapSlot;
    private JobInProgress jobForFallowReduceSlot;

    public TaskTracker(String trackerName) {
        this.trackerName = trackerName;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public TaskTrackerStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskTrackerStatus status) {
        this.status = status;
    }

    public int getAvailableSlots(TaskType taskType) {
        int availableSlots = 0;
        if (taskType == TaskType.MAP) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.trackerName + " getAvailSlots:" + " max(m)=" + this.status.getMaxMapSlots() + " occupied(m)=" + this.status.countOccupiedMapSlots());
            }
            availableSlots = this.status.getAvailableMapSlots();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.trackerName + " getAvailSlots:" + " max(r)=" + this.status.getMaxReduceSlots() + " occupied(r)=" + this.status.countOccupiedReduceSlots());
            }
            availableSlots = this.status.getAvailableReduceSlots();
        }
        return availableSlots;
    }

    public JobInProgress getJobForFallowSlot(TaskType taskType) {
        return taskType == TaskType.MAP ? this.jobForFallowMapSlot : this.jobForFallowReduceSlot;
    }

    public void reserveSlots(TaskType taskType, JobInProgress job, int numSlots) {
        JobID jobId = job.getJobID();
        if (taskType == TaskType.MAP) {
            if (this.jobForFallowMapSlot != null && !this.jobForFallowMapSlot.getJobID().equals(jobId)) {
                throw new RuntimeException(this.trackerName + " already has " + "slots reserved for " + this.jobForFallowMapSlot + "; being" + " asked to reserve " + numSlots + " for " + jobId);
            }
            this.jobForFallowMapSlot = job;
        } else if (taskType == TaskType.REDUCE) {
            if (this.jobForFallowReduceSlot != null && !this.jobForFallowReduceSlot.getJobID().equals(jobId)) {
                throw new RuntimeException(this.trackerName + " already has " + "slots reserved for " + this.jobForFallowReduceSlot + "; being" + " asked to reserve " + numSlots + " for " + jobId);
            }
            this.jobForFallowReduceSlot = job;
        }
        job.reserveTaskTracker(this, taskType, numSlots);
        LOG.info(this.trackerName + ": Reserved " + numSlots + " " + (Object)((Object)taskType) + " slots for " + jobId);
    }

    public void unreserveSlots(TaskType taskType, JobInProgress job) {
        JobID jobId = job.getJobID();
        if (taskType == TaskType.MAP) {
            if (this.jobForFallowMapSlot == null || !this.jobForFallowMapSlot.getJobID().equals(jobId)) {
                throw new RuntimeException(this.trackerName + " already has " + "slots reserved for " + this.jobForFallowMapSlot + "; being" + " asked to un-reserve for " + jobId);
            }
            this.jobForFallowMapSlot = null;
        } else {
            if (this.jobForFallowReduceSlot == null || !this.jobForFallowReduceSlot.getJobID().equals(jobId)) {
                throw new RuntimeException(this.trackerName + " already has " + "slots reserved for " + this.jobForFallowReduceSlot + "; being" + " asked to un-reserve for " + jobId);
            }
            this.jobForFallowReduceSlot = null;
        }
        job.unreserveTaskTracker(this, taskType);
        LOG.info(this.trackerName + ": Unreserved " + (Object)((Object)taskType) + " slots for " + jobId);
    }

    public void cancelAllReservations() {
        if (this.jobForFallowMapSlot != null) {
            this.unreserveSlots(TaskType.MAP, this.jobForFallowMapSlot);
        }
        if (this.jobForFallowReduceSlot != null) {
            this.unreserveSlots(TaskType.REDUCE, this.jobForFallowReduceSlot);
        }
    }
}

