/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.avro.ipc.stats.FloatHistogram;
import org.apache.avro.ipc.stats.Histogram;
import org.junit.Assert;
import org.junit.Test;

public class TestHistogram {
    @Test
    public void testBasicOperation() {
        Histogram.TreeMapSegmenter<Integer> s = new Histogram.TreeMapSegmenter<Integer>(new TreeSet<Integer>(Arrays.asList(0, 1, 2, 4, 8, 16)));
        Histogram h = new Histogram(s);
        for (int i = 0; i < 20; ++i) {
            h.add(i);
        }
        Assert.assertEquals((long)20L, (long)h.getCount());
        Assert.assertArrayEquals((int[])new int[]{1, 1, 2, 4, 8, 4}, (int[])h.getHistogram());
        Assert.assertEquals((Object)"[0,1)=1;[1,2)=1;[2,4)=2;[4,8)=4;[8,16)=8;[16,infinity)=4", (Object)h.toString());
        String[] correctBucketLabels = new String[]{"[0,1)", "[1,2)", "[2,4)", "[4,8)", "[8,16)", "[16,infinity)"};
        int pos = 0;
        Iterator it = h.getSegmenter().getBuckets();
        while (it.hasNext()) {
            Assert.assertEquals((Object)correctBucketLabels[pos], it.next());
            ++pos;
        }
        Assert.assertEquals((long)correctBucketLabels.length, (long)pos);
        List<String> labels = h.getSegmenter().getBucketLabels();
        Assert.assertEquals((long)correctBucketLabels.length, (long)labels.size());
        if (labels.size() == correctBucketLabels.length) {
            for (int i = 0; i < labels.size(); ++i) {
                Assert.assertEquals((Object)correctBucketLabels[i], (Object)labels.get(i));
            }
        }
        String[] correctBoundryLabels = new String[]{"0", "1", "2", "4", "8", "16"};
        List<String> boundryLabels = h.getSegmenter().getBoundaryLabels();
        Assert.assertEquals((long)correctBoundryLabels.length, (long)boundryLabels.size());
        if (boundryLabels.size() == correctBoundryLabels.length) {
            for (int i = 0; i < boundryLabels.size(); ++i) {
                Assert.assertEquals((Object)correctBoundryLabels[i], (Object)boundryLabels.get(i));
            }
        }
        ArrayList entries = new ArrayList();
        for (Histogram.Entry entry : h.entries()) {
            entries.add(entry);
        }
        Assert.assertEquals((Object)"[0,1)", ((Histogram.Entry)entries.get((int)0)).bucket);
        Assert.assertEquals((long)4L, (long)((Histogram.Entry)entries.get((int)5)).count);
        Assert.assertEquals((long)6L, (long)entries.size());
        h.add(1010);
        h.add(9191);
        List recent = h.getRecentAdditions();
        Assert.assertTrue((boolean)recent.contains(1010));
        Assert.assertTrue((boolean)recent.contains(9191));
    }

    @Test(expected=Histogram.SegmenterException.class)
    public void testBadValue() {
        Histogram.TreeMapSegmenter<Long> s = new Histogram.TreeMapSegmenter<Long>(new TreeSet<Long>(Arrays.asList(0L, 1L, 2L, 4L, 8L, 16L)));
        Histogram h = new Histogram(s);
        h.add(-1L);
    }

    @Test
    public void testFloatHistogram() {
        FloatHistogram<String> h = new FloatHistogram<String>(new SingleBucketSegmenter());
        h.add(Float.valueOf(12.0f));
        h.add(Float.valueOf(10.0f));
        h.add(Float.valueOf(20.0f));
        Assert.assertEquals((long)3L, (long)h.getCount());
        Assert.assertEquals((double)14.0, (double)h.getMean(), (double)1.0E-4);
        Assert.assertEquals((double)5.291f, (double)h.getUnbiasedStdDev(), (double)0.001);
    }

    static class SingleBucketSegmenter
    implements Histogram.Segmenter<String, Float> {
        SingleBucketSegmenter() {
        }

        @Override
        public Iterator<String> getBuckets() {
            return Arrays.asList("X").iterator();
        }

        @Override
        public List<String> getBoundaryLabels() {
            return Arrays.asList("X");
        }

        @Override
        public List<String> getBucketLabels() {
            return Arrays.asList("X");
        }

        @Override
        public int segment(Float value) {
            return 0;
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

