// @flow
/* eslint-disable */

// This file is auto-generated by client/protocol/Makefile.
import * as gregor1 from './flow-types-gregor'
import * as keybase1 from './flow-types'
import engine, {EngineChannel} from '../../engine'
import {RPCError} from '../../util/errors'
import {putOnChannelMap, createChannelMap, closeChannelMap} from '../../util/saga'
import {Buffer} from 'buffer'

import type {ChannelConfig, ChannelMap} from './saga'
import type {Exact} from './more'
export type int = number
export type int64 = number
export type uint = number
export type uint64 = number
export type long = number
export type double = number
export type bytes = Buffer
export type WaitingHandlerType = (waiting: boolean) => void

const engineRpcOutgoing = (method: string, params: any, callbackOverride: any, incomingCallMapOverride: any) => engine()._rpcOutgoing(method, params, callbackOverride, incomingCallMapOverride)

type requestCommon = {
  waitingHandler?: WaitingHandlerType,
  incomingCallMap?: incomingCallMapType,
}

type requestErrorCallback = {
  callback?: ?(err: ?RPCError) => void
}

type RPCErrorHandler = (err: RPCError) => void

type CommonResponseHandler = {
  error: RPCErrorHandler,
  result: (...rest: Array<void>) => void,
}

function _channelMapRpcHelper(channelConfig: ChannelConfig<*>, partialRpcCall: (incomingCallMap: any, callback: Function) => void): ChannelMap<*> {
  const channelMap = createChannelMap(channelConfig)
  const incomingCallMap = Object.keys(channelMap).reduce((acc, k) => {
    acc[k] = (params, response) => {
      putOnChannelMap(channelMap, k, {params, response})
    }
    return acc
  }, {})
  const callback = (error, params) => {
    channelMap['finished'] && putOnChannelMap(channelMap, 'finished', {error, params})
    closeChannelMap(channelMap)
  }
  partialRpcCall(incomingCallMap, callback)
  return channelMap
}


export const ChatUiMessageUnboxedState = {
  valid: 1,
  error: 2,
  outbox: 3,
  placeholder: 4,
}

export const CommonConversationExistence = {
  active: 0,
  archived: 1,
  deleted: 2,
}

export const CommonConversationMemberStatus = {
  active: 0,
  removed: 1,
  left: 2,
  preview: 3,
}

export const CommonConversationMembersType = {
  kbfs: 0,
  team: 1,
  impteam: 2,
}

export const CommonConversationStatus = {
  unfiled: 0,
  favorite: 1,
  ignored: 2,
  blocked: 3,
  muted: 4,
  reported: 5,
}

export const CommonGlobalAppNotificationSetting = {
  newmessages: 0,
  plaintextmobile: 1,
  plaintextdesktop: 2,
}

export const CommonInboxResType = {
  versionhit: 0,
  full: 1,
}

export const CommonMessageType = {
  none: 0,
  text: 1,
  attachment: 2,
  edit: 3,
  delete: 4,
  metadata: 5,
  tlfname: 6,
  headline: 7,
  attachmentuploaded: 8,
  join: 9,
  leave: 10,
}

export const CommonNotificationKind = {
  generic: 0,
  atmention: 1,
}

export const CommonTeamType = {
  none: 0,
  simple: 1,
  complex: 2,
}

export const CommonTopicType = {
  none: 0,
  chat: 1,
  dev: 2,
}

export const LocalAssetMetadataType = {
  none: 0,
  image: 1,
  video: 2,
  audio: 3,
}

export const LocalAssetTag = {
  primary: 0,
}

export const LocalBodyPlaintextVersion = {
  v1: 1,
  v2: 2,
  v3: 3,
  v4: 4,
  v5: 5,
  v6: 6,
  v7: 7,
  v8: 8,
  v9: 9,
  v10: 10,
}

export const LocalConversationErrorType = {
  permanent: 0,
  missinginfo: 1,
  selfrekeyneeded: 2,
  otherrekeyneeded: 3,
  identify: 4,
  transient: 5,
  none: 6,
}

export const LocalHeaderPlaintextVersion = {
  v1: 1,
  v2: 2,
  v3: 3,
  v4: 4,
  v5: 5,
  v6: 6,
  v7: 7,
  v8: 8,
  v9: 9,
  v10: 10,
}

export const LocalMessageUnboxedErrorType = {
  misc: 0,
  badversionCritical: 1,
  badversion: 2,
  identify: 3,
}

export const LocalOutboxErrorType = {
  misc: 0,
  offline: 1,
  identify: 2,
  toolong: 3,
  duplicate: 4,
}

export const LocalOutboxStateType = {
  sending: 0,
  error: 1,
}

export const NotifyChatChatActivityType = {
  reserved: 0,
  incomingMessage: 1,
  readMessage: 2,
  newConversation: 3,
  setStatus: 4,
  failedMessage: 5,
  membersUpdate: 6,
  setAppNotificationSettings: 7,
  teamtype: 8,
}

export const NotifyChatStaleUpdateType = {
  clear: 0,
  newactivity: 1,
}

export const RemoteChannelMention = {
  none: 0,
  all: 1,
  here: 2,
}

export const RemoteMessageBoxedVersion = {
  vnone: 0,
  v1: 1,
  v2: 2,
}

export const RemoteSyncAllNotificationType = {
  state: 0,
  incremental: 1,
}

export const RemoteSyncInboxResType = {
  current: 0,
  incremental: 1,
  clear: 2,
}

export function localCancelPostRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: localCancelPostRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.CancelPost', request)
}

export function localCancelPostRpcPromise (request: (requestCommon & requestErrorCallback & {param: localCancelPostRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.CancelPost', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localDeleteConversationLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localDeleteConversationLocalResult) => void} & {param: localDeleteConversationLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.deleteConversationLocal', request)
}

export function localDeleteConversationLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localDeleteConversationLocalResult) => void} & {param: localDeleteConversationLocalRpcParam})): Promise<localDeleteConversationLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.deleteConversationLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localDownloadAttachmentLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localDownloadAttachmentLocalResult) => void} & {param: localDownloadAttachmentLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.DownloadAttachmentLocal', request)
}

export function localDownloadAttachmentLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localDownloadAttachmentLocalResult) => void} & {param: localDownloadAttachmentLocalRpcParam})): Promise<localDownloadAttachmentLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.DownloadAttachmentLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localDownloadFileAttachmentLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localDownloadFileAttachmentLocalResult) => void} & {param: localDownloadFileAttachmentLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.DownloadFileAttachmentLocal', request)
}

export function localDownloadFileAttachmentLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localDownloadFileAttachmentLocalResult) => void} & {param: localDownloadFileAttachmentLocalRpcParam})): Promise<localDownloadFileAttachmentLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.DownloadFileAttachmentLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localFindConversationsLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localFindConversationsLocalResult) => void} & {param: localFindConversationsLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.findConversationsLocal', request)
}

export function localFindConversationsLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localFindConversationsLocalResult) => void} & {param: localFindConversationsLocalRpcParam})): Promise<localFindConversationsLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.findConversationsLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGenerateOutboxIDRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGenerateOutboxIDResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.generateOutboxID', request)
}

export function localGenerateOutboxIDRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: localGenerateOutboxIDResult) => void})): Promise<localGenerateOutboxIDResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.generateOutboxID', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetCachedThreadRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetCachedThreadResult) => void} & {param: localGetCachedThreadRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getCachedThread', request)
}

export function localGetCachedThreadRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetCachedThreadResult) => void} & {param: localGetCachedThreadRpcParam})): Promise<localGetCachedThreadResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getCachedThread', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetConversationForCLILocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetConversationForCLILocalResult) => void} & {param: localGetConversationForCLILocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getConversationForCLILocal', request)
}

export function localGetConversationForCLILocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetConversationForCLILocalResult) => void} & {param: localGetConversationForCLILocalRpcParam})): Promise<localGetConversationForCLILocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getConversationForCLILocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetGlobalAppNotificationSettingsLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetGlobalAppNotificationSettingsLocalResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getGlobalAppNotificationSettingsLocal', request)
}

export function localGetGlobalAppNotificationSettingsLocalRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: localGetGlobalAppNotificationSettingsLocalResult) => void})): Promise<localGetGlobalAppNotificationSettingsLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getGlobalAppNotificationSettingsLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetInboxAndUnboxLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetInboxAndUnboxLocalResult) => void} & {param: localGetInboxAndUnboxLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getInboxAndUnboxLocal', request)
}

export function localGetInboxAndUnboxLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetInboxAndUnboxLocalResult) => void} & {param: localGetInboxAndUnboxLocalRpcParam})): Promise<localGetInboxAndUnboxLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getInboxAndUnboxLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetInboxNonblockLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetInboxNonblockLocalResult) => void} & {param: localGetInboxNonblockLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getInboxNonblockLocal', request)
}

export function localGetInboxNonblockLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetInboxNonblockLocalResult) => void} & {param: localGetInboxNonblockLocalRpcParam})): Promise<localGetInboxNonblockLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getInboxNonblockLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetInboxSummaryForCLILocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetInboxSummaryForCLILocalResult) => void} & {param: localGetInboxSummaryForCLILocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getInboxSummaryForCLILocal', request)
}

export function localGetInboxSummaryForCLILocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetInboxSummaryForCLILocalResult) => void} & {param: localGetInboxSummaryForCLILocalRpcParam})): Promise<localGetInboxSummaryForCLILocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getInboxSummaryForCLILocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetMessagesLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetMessagesLocalResult) => void} & {param: localGetMessagesLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.GetMessagesLocal', request)
}

export function localGetMessagesLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetMessagesLocalResult) => void} & {param: localGetMessagesLocalRpcParam})): Promise<localGetMessagesLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.GetMessagesLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetTLFConversationsLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetTLFConversationsLocalResult) => void} & {param: localGetTLFConversationsLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getTLFConversationsLocal', request)
}

export function localGetTLFConversationsLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetTLFConversationsLocalResult) => void} & {param: localGetTLFConversationsLocalRpcParam})): Promise<localGetTLFConversationsLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getTLFConversationsLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetThreadLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetThreadLocalResult) => void} & {param: localGetThreadLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getThreadLocal', request)
}

export function localGetThreadLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetThreadLocalResult) => void} & {param: localGetThreadLocalRpcParam})): Promise<localGetThreadLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getThreadLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localGetThreadNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localGetThreadNonblockResult) => void} & {param: localGetThreadNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.getThreadNonblock', request)
}

export function localGetThreadNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localGetThreadNonblockResult) => void} & {param: localGetThreadNonblockRpcParam})): Promise<localGetThreadNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.getThreadNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localJoinConversationByIDLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localJoinConversationByIDLocalResult) => void} & {param: localJoinConversationByIDLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.joinConversationByIDLocal', request)
}

export function localJoinConversationByIDLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localJoinConversationByIDLocalResult) => void} & {param: localJoinConversationByIDLocalRpcParam})): Promise<localJoinConversationByIDLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.joinConversationByIDLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localJoinConversationLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localJoinConversationLocalResult) => void} & {param: localJoinConversationLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.joinConversationLocal', request)
}

export function localJoinConversationLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localJoinConversationLocalResult) => void} & {param: localJoinConversationLocalRpcParam})): Promise<localJoinConversationLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.joinConversationLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localLeaveConversationLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localLeaveConversationLocalResult) => void} & {param: localLeaveConversationLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.leaveConversationLocal', request)
}

export function localLeaveConversationLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localLeaveConversationLocalResult) => void} & {param: localLeaveConversationLocalRpcParam})): Promise<localLeaveConversationLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.leaveConversationLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localMakePreviewRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localMakePreviewResult) => void} & {param: localMakePreviewRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.makePreview', request)
}

export function localMakePreviewRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localMakePreviewResult) => void} & {param: localMakePreviewRpcParam})): Promise<localMakePreviewResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.makePreview', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localMarkAsReadLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localMarkAsReadLocalResult) => void} & {param: localMarkAsReadLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.markAsReadLocal', request)
}

export function localMarkAsReadLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localMarkAsReadLocalResult) => void} & {param: localMarkAsReadLocalRpcParam})): Promise<localMarkAsReadLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.markAsReadLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localNewConversationLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localNewConversationLocalResult) => void} & {param: localNewConversationLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.newConversationLocal', request)
}

export function localNewConversationLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localNewConversationLocalResult) => void} & {param: localNewConversationLocalRpcParam})): Promise<localNewConversationLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.newConversationLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostAttachmentLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostAttachmentLocalResult) => void} & {param: localPostAttachmentLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postAttachmentLocal', request)
}

export function localPostAttachmentLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostAttachmentLocalResult) => void} & {param: localPostAttachmentLocalRpcParam})): Promise<localPostAttachmentLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postAttachmentLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostDeleteNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostDeleteNonblockResult) => void} & {param: localPostDeleteNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postDeleteNonblock', request)
}

export function localPostDeleteNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostDeleteNonblockResult) => void} & {param: localPostDeleteNonblockRpcParam})): Promise<localPostDeleteNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postDeleteNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostEditNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostEditNonblockResult) => void} & {param: localPostEditNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postEditNonblock', request)
}

export function localPostEditNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostEditNonblockResult) => void} & {param: localPostEditNonblockRpcParam})): Promise<localPostEditNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postEditNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostFileAttachmentLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostFileAttachmentLocalResult) => void} & {param: localPostFileAttachmentLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postFileAttachmentLocal', request)
}

export function localPostFileAttachmentLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostFileAttachmentLocalResult) => void} & {param: localPostFileAttachmentLocalRpcParam})): Promise<localPostFileAttachmentLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postFileAttachmentLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostHeadlineNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostHeadlineNonblockResult) => void} & {param: localPostHeadlineNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postHeadlineNonblock', request)
}

export function localPostHeadlineNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostHeadlineNonblockResult) => void} & {param: localPostHeadlineNonblockRpcParam})): Promise<localPostHeadlineNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postHeadlineNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostHeadlineRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostHeadlineResult) => void} & {param: localPostHeadlineRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postHeadline', request)
}

export function localPostHeadlineRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostHeadlineResult) => void} & {param: localPostHeadlineRpcParam})): Promise<localPostHeadlineResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postHeadline', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostLocalNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostLocalNonblockResult) => void} & {param: localPostLocalNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postLocalNonblock', request)
}

export function localPostLocalNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostLocalNonblockResult) => void} & {param: localPostLocalNonblockRpcParam})): Promise<localPostLocalNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postLocalNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostLocalResult) => void} & {param: localPostLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postLocal', request)
}

export function localPostLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostLocalResult) => void} & {param: localPostLocalRpcParam})): Promise<localPostLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localPostTextNonblockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localPostTextNonblockResult) => void} & {param: localPostTextNonblockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.postTextNonblock', request)
}

export function localPostTextNonblockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localPostTextNonblockResult) => void} & {param: localPostTextNonblockRpcParam})): Promise<localPostTextNonblockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.postTextNonblock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localRetryPostRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: localRetryPostRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.RetryPost', request)
}

export function localRetryPostRpcPromise (request: (requestCommon & requestErrorCallback & {param: localRetryPostRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.RetryPost', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localSetAppNotificationSettingsLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localSetAppNotificationSettingsLocalResult) => void} & {param: localSetAppNotificationSettingsLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.setAppNotificationSettingsLocal', request)
}

export function localSetAppNotificationSettingsLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localSetAppNotificationSettingsLocalResult) => void} & {param: localSetAppNotificationSettingsLocalRpcParam})): Promise<localSetAppNotificationSettingsLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.setAppNotificationSettingsLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localSetConversationStatusLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localSetConversationStatusLocalResult) => void} & {param: localSetConversationStatusLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.SetConversationStatusLocal', request)
}

export function localSetConversationStatusLocalRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localSetConversationStatusLocalResult) => void} & {param: localSetConversationStatusLocalRpcParam})): Promise<localSetConversationStatusLocalResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.SetConversationStatusLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localSetGlobalAppNotificationSettingsLocalRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: localSetGlobalAppNotificationSettingsLocalRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.setGlobalAppNotificationSettingsLocal', request)
}

export function localSetGlobalAppNotificationSettingsLocalRpcPromise (request: (requestCommon & requestErrorCallback & {param: localSetGlobalAppNotificationSettingsLocalRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.setGlobalAppNotificationSettingsLocal', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localUnboxMobilePushNotificationRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: localUnboxMobilePushNotificationResult) => void} & {param: localUnboxMobilePushNotificationRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.unboxMobilePushNotification', request)
}

export function localUnboxMobilePushNotificationRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: localUnboxMobilePushNotificationResult) => void} & {param: localUnboxMobilePushNotificationRpcParam})): Promise<localUnboxMobilePushNotificationResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.unboxMobilePushNotification', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function localUpdateTypingRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: localUpdateTypingRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.local.updateTyping', request)
}

export function localUpdateTypingRpcPromise (request: (requestCommon & requestErrorCallback & {param: localUpdateTypingRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.local.updateTyping', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteDeleteConversationRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteDeleteConversationResult) => void} & {param: remoteDeleteConversationRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.deleteConversation', request)
}

export function remoteDeleteConversationRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteDeleteConversationResult) => void} & {param: remoteDeleteConversationRpcParam})): Promise<remoteDeleteConversationResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.deleteConversation', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetGlobalAppNotificationSettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetGlobalAppNotificationSettingsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getGlobalAppNotificationSettings', request)
}

export function remoteGetGlobalAppNotificationSettingsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: remoteGetGlobalAppNotificationSettingsResult) => void})): Promise<remoteGetGlobalAppNotificationSettingsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getGlobalAppNotificationSettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetInboxRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetInboxRemoteResult) => void} & {param: remoteGetInboxRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getInboxRemote', request)
}

export function remoteGetInboxRemoteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetInboxRemoteResult) => void} & {param: remoteGetInboxRemoteRpcParam})): Promise<remoteGetInboxRemoteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getInboxRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetInboxVersionRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetInboxVersionResult) => void} & {param: remoteGetInboxVersionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getInboxVersion', request)
}

export function remoteGetInboxVersionRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetInboxVersionResult) => void} & {param: remoteGetInboxVersionRpcParam})): Promise<remoteGetInboxVersionResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getInboxVersion', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetMessagesRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetMessagesRemoteResult) => void} & {param: remoteGetMessagesRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getMessagesRemote', request)
}

export function remoteGetMessagesRemoteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetMessagesRemoteResult) => void} & {param: remoteGetMessagesRemoteRpcParam})): Promise<remoteGetMessagesRemoteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getMessagesRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetPublicConversationsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetPublicConversationsResult) => void} & {param: remoteGetPublicConversationsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getPublicConversations', request)
}

export function remoteGetPublicConversationsRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetPublicConversationsResult) => void} & {param: remoteGetPublicConversationsRpcParam})): Promise<remoteGetPublicConversationsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getPublicConversations', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetS3ParamsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetS3ParamsResult) => void} & {param: remoteGetS3ParamsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getS3Params', request)
}

export function remoteGetS3ParamsRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetS3ParamsResult) => void} & {param: remoteGetS3ParamsRpcParam})): Promise<remoteGetS3ParamsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getS3Params', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetTLFConversationsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetTLFConversationsResult) => void} & {param: remoteGetTLFConversationsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getTLFConversations', request)
}

export function remoteGetTLFConversationsRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetTLFConversationsResult) => void} & {param: remoteGetTLFConversationsRpcParam})): Promise<remoteGetTLFConversationsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getTLFConversations', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetThreadRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetThreadRemoteResult) => void} & {param: remoteGetThreadRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.getThreadRemote', request)
}

export function remoteGetThreadRemoteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetThreadRemoteResult) => void} & {param: remoteGetThreadRemoteRpcParam})): Promise<remoteGetThreadRemoteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.getThreadRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteGetUnreadUpdateFullRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteGetUnreadUpdateFullResult) => void} & {param: remoteGetUnreadUpdateFullRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.GetUnreadUpdateFull', request)
}

export function remoteGetUnreadUpdateFullRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteGetUnreadUpdateFullResult) => void} & {param: remoteGetUnreadUpdateFullRpcParam})): Promise<remoteGetUnreadUpdateFullResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.GetUnreadUpdateFull', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteJoinConversationRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteJoinConversationResult) => void} & {param: remoteJoinConversationRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.joinConversation', request)
}

export function remoteJoinConversationRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteJoinConversationResult) => void} & {param: remoteJoinConversationRpcParam})): Promise<remoteJoinConversationResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.joinConversation', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteLeaveConversationRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteLeaveConversationResult) => void} & {param: remoteLeaveConversationRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.leaveConversation', request)
}

export function remoteLeaveConversationRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteLeaveConversationResult) => void} & {param: remoteLeaveConversationRpcParam})): Promise<remoteLeaveConversationResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.leaveConversation', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteMarkAsReadRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteMarkAsReadResult) => void} & {param: remoteMarkAsReadRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.markAsRead', request)
}

export function remoteMarkAsReadRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteMarkAsReadResult) => void} & {param: remoteMarkAsReadRpcParam})): Promise<remoteMarkAsReadResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.markAsRead', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteNewConversationRemote2RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteNewConversationRemote2Result) => void} & {param: remoteNewConversationRemote2RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.newConversationRemote2', request)
}

export function remoteNewConversationRemote2RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteNewConversationRemote2Result) => void} & {param: remoteNewConversationRemote2RpcParam})): Promise<remoteNewConversationRemote2Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.newConversationRemote2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteNewConversationRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteNewConversationRemoteResult) => void} & {param: remoteNewConversationRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.newConversationRemote', request)
}

export function remoteNewConversationRemoteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteNewConversationRemoteResult) => void} & {param: remoteNewConversationRemoteRpcParam})): Promise<remoteNewConversationRemoteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.newConversationRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remotePostRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remotePostRemoteResult) => void} & {param: remotePostRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.postRemote', request)
}

export function remotePostRemoteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remotePostRemoteResult) => void} & {param: remotePostRemoteRpcParam})): Promise<remotePostRemoteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.postRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remotePublishReadMessageRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remotePublishReadMessageRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.publishReadMessage', request)
}

export function remotePublishReadMessageRpcPromise (request: (requestCommon & requestErrorCallback & {param: remotePublishReadMessageRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.publishReadMessage', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remotePublishSetConversationStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remotePublishSetConversationStatusRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.publishSetConversationStatus', request)
}

export function remotePublishSetConversationStatusRpcPromise (request: (requestCommon & requestErrorCallback & {param: remotePublishSetConversationStatusRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.publishSetConversationStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteRemoteNotificationSuccessfulRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remoteRemoteNotificationSuccessfulRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.remoteNotificationSuccessful', request)
}

export function remoteRemoteNotificationSuccessfulRpcPromise (request: (requestCommon & requestErrorCallback & {param: remoteRemoteNotificationSuccessfulRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.remoteNotificationSuccessful', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteS3SignRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteS3SignResult) => void} & {param: remoteS3SignRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.s3Sign', request)
}

export function remoteS3SignRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteS3SignResult) => void} & {param: remoteS3SignRpcParam})): Promise<remoteS3SignResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.s3Sign', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSetAppNotificationSettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteSetAppNotificationSettingsResult) => void} & {param: remoteSetAppNotificationSettingsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.setAppNotificationSettings', request)
}

export function remoteSetAppNotificationSettingsRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteSetAppNotificationSettingsResult) => void} & {param: remoteSetAppNotificationSettingsRpcParam})): Promise<remoteSetAppNotificationSettingsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.setAppNotificationSettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSetConversationStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteSetConversationStatusResult) => void} & {param: remoteSetConversationStatusRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.SetConversationStatus', request)
}

export function remoteSetConversationStatusRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteSetConversationStatusResult) => void} & {param: remoteSetConversationStatusRpcParam})): Promise<remoteSetConversationStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.SetConversationStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSetGlobalAppNotificationSettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remoteSetGlobalAppNotificationSettingsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.setGlobalAppNotificationSettings', request)
}

export function remoteSetGlobalAppNotificationSettingsRpcPromise (request: (requestCommon & requestErrorCallback & {param: remoteSetGlobalAppNotificationSettingsRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.setGlobalAppNotificationSettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSyncAllRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteSyncAllResult) => void} & {param: remoteSyncAllRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.syncAll', request)
}

export function remoteSyncAllRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteSyncAllResult) => void} & {param: remoteSyncAllRpcParam})): Promise<remoteSyncAllResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.syncAll', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSyncChatRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteSyncChatResult) => void} & {param: remoteSyncChatRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.syncChat', request)
}

export function remoteSyncChatRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteSyncChatResult) => void} & {param: remoteSyncChatRpcParam})): Promise<remoteSyncChatResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.syncChat', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteSyncInboxRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: remoteSyncInboxResult) => void} & {param: remoteSyncInboxRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.syncInbox', request)
}

export function remoteSyncInboxRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: remoteSyncInboxResult) => void} & {param: remoteSyncInboxRpcParam})): Promise<remoteSyncInboxResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.syncInbox', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteTlfFinalizeRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remoteTlfFinalizeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.tlfFinalize', request)
}

export function remoteTlfFinalizeRpcPromise (request: (requestCommon & requestErrorCallback & {param: remoteTlfFinalizeRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.tlfFinalize', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteTlfResolveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remoteTlfResolveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.tlfResolve', request)
}

export function remoteTlfResolveRpcPromise (request: (requestCommon & requestErrorCallback & {param: remoteTlfResolveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.tlfResolve', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function remoteUpdateTypingRemoteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: remoteUpdateTypingRemoteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'chat.1.remote.updateTypingRemote', request)
}

export function remoteUpdateTypingRemoteRpcPromise (request: (requestCommon & requestErrorCallback & {param: remoteUpdateTypingRemoteRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('chat.1.remote.updateTypingRemote', request, (error, result) => error ? reject(error) : resolve(result)))
}

export type AppNotificationSettingLocal = {
  deviceType: keybase1.DeviceType,
  kind: NotificationKind,
  enabled: boolean,
}

export type Asset = {
  filename: string,
  region: string,
  endpoint: string,
  bucket: string,
  path: string,
  size: long,
  mimeType: string,
  encHash: Hash,
  key: bytes,
  verifyKey: bytes,
  title: string,
  nonce: bytes,
  metadata: AssetMetadata,
  tag: AssetTag,
}

export type AssetMetadata =
    { assetType: 1, image: ?AssetMetadataImage }
  | { assetType: 2, video: ?AssetMetadataVideo }
  | { assetType: 3, audio: ?AssetMetadataAudio }

export type AssetMetadataAudio = {
  durationMs: int,
}

export type AssetMetadataImage = {
  width: int,
  height: int,
}

export type AssetMetadataType =
    0 // NONE_0
  | 1 // IMAGE_1
  | 2 // VIDEO_2
  | 3 // AUDIO_3

export type AssetMetadataVideo = {
  width: int,
  height: int,
  durationMs: int,
}

export type AssetTag =
    0 // PRIMARY_0

export type BodyPlaintext =
    { version: 1, v1: ?BodyPlaintextV1 }
  | { version: 2, v2: ?BodyPlaintextUnsupported }
  | { version: 3, v3: ?BodyPlaintextUnsupported }
  | { version: 4, v4: ?BodyPlaintextUnsupported }
  | { version: 5, v5: ?BodyPlaintextUnsupported }
  | { version: 6, v6: ?BodyPlaintextUnsupported }
  | { version: 7, v7: ?BodyPlaintextUnsupported }
  | { version: 8, v8: ?BodyPlaintextUnsupported }
  | { version: 9, v9: ?BodyPlaintextUnsupported }
  | { version: 10, v10: ?BodyPlaintextUnsupported }

export type BodyPlaintextMetaInfo = {
  crit: boolean,
}

export type BodyPlaintextUnsupported = {
  mi: BodyPlaintextMetaInfo,
}

export type BodyPlaintextV1 = {
  messageBody: MessageBody,
}

export type BodyPlaintextVersion =
    1 // V1_1
  | 2 // V2_2
  | 3 // V3_3
  | 4 // V4_4
  | 5 // V5_5
  | 6 // V6_6
  | 7 // V7_7
  | 8 // V8_8
  | 9 // V9_9
  | 10 // V10_10

export type ChannelMention =
    0 // NONE_0
  | 1 // ALL_1
  | 2 // HERE_2

export type ChatActivity =
    { activityType: 1, incomingMessage: ?IncomingMessage }
  | { activityType: 2, readMessage: ?ReadMessageInfo }
  | { activityType: 3, newConversation: ?NewConversationInfo }
  | { activityType: 4, setStatus: ?SetStatusInfo }
  | { activityType: 5, failedMessage: ?FailedMessageInfo }
  | { activityType: 6, membersUpdate: ?MembersUpdateInfo }
  | { activityType: 7, setAppNotificationSettings: ?SetAppNotificationSettingsInfo }
  | { activityType: 8, teamtype: ?TeamTypeInfo }

export type ChatActivityType =
    0 // RESERVED_0
  | 1 // INCOMING_MESSAGE_1
  | 2 // READ_MESSAGE_2
  | 3 // NEW_CONVERSATION_3
  | 4 // SET_STATUS_4
  | 5 // FAILED_MESSAGE_5
  | 6 // MEMBERS_UPDATE_6
  | 7 // SET_APP_NOTIFICATION_SETTINGS_7
  | 8 // TEAMTYPE_8

export type ConvTypingUpdate = {
  convID: ConversationID,
  typers?: ?Array<TyperInfo>,
}

export type Conversation = {
  metadata: ConversationMetadata,
  readerInfo?: ?ConversationReaderInfo,
  notifications?: ?ConversationNotificationInfo,
  maxMsgs?: ?Array<MessageBoxed>,
  maxMsgSummaries?: ?Array<MessageSummary>,
  creatorInfo?: ?ConversationCreatorInfo,
}

export type ConversationCreatorInfo = {
  ctime: gregor1.Time,
  uid: gregor1.UID,
}

export type ConversationCreatorInfoLocal = {
  ctime: gregor1.Time,
  username: string,
}

export type ConversationErrorLocal = {
  typ: ConversationErrorType,
  message: string,
  remoteConv: Conversation,
  unverifiedTLFName: string,
  rekeyInfo?: ?ConversationErrorRekey,
}

export type ConversationErrorRekey = {
  tlfName: string,
  tlfPublic: boolean,
  rekeyers?: ?Array<string>,
  writerNames?: ?Array<string>,
  readerNames?: ?Array<string>,
}

export type ConversationErrorType =
    0 // PERMANENT_0
  | 1 // MISSINGINFO_1
  | 2 // SELFREKEYNEEDED_2
  | 3 // OTHERREKEYNEEDED_3
  | 4 // IDENTIFY_4
  | 5 // TRANSIENT_5
  | 6 // NONE_6

export type ConversationExistence =
    0 // ACTIVE_0
  | 1 // ARCHIVED_1
  | 2 // DELETED_2

export type ConversationFinalizeInfo = {
  resetUser: string,
  resetDate: string,
  resetFull: string,
  resetTimestamp: gregor1.Time,
}

export type ConversationID = bytes

export type ConversationIDMessageIDPair = {
  convID: ConversationID,
  msgID: MessageID,
}

export type ConversationIDMessageIDPairs = {
  pairs?: ?Array<ConversationIDMessageIDPair>,
}

export type ConversationIDTriple = {
  tlfid: TLFID,
  topicType: TopicType,
  topicID: TopicID,
}

export type ConversationInfoLocal = {
  id: ConversationID,
  triple: ConversationIDTriple,
  tlfName: string,
  topicName: string,
  visibility: keybase1.TLFVisibility,
  status: ConversationStatus,
  membersType: ConversationMembersType,
  teamType: TeamType,
  existence: ConversationExistence,
  version: ConversationVers,
  writerNames?: ?Array<string>,
  readerNames?: ?Array<string>,
  finalizeInfo?: ?ConversationFinalizeInfo,
}

export type ConversationLocal = {
  error?: ?ConversationErrorLocal,
  info: ConversationInfoLocal,
  readerInfo: ConversationReaderInfo,
  creatorInfo?: ?ConversationCreatorInfoLocal,
  notifications?: ?ConversationNotificationInfo,
  supersedes?: ?Array<ConversationMetadata>,
  supersededBy?: ?Array<ConversationMetadata>,
  maxMessages?: ?Array<MessageUnboxed>,
  isEmpty: boolean,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type ConversationMember = {
  uid: gregor1.UID,
  convID: ConversationID,
}

export type ConversationMemberStatus =
    0 // ACTIVE_0
  | 1 // REMOVED_1
  | 2 // LEFT_2
  | 3 // PREVIEW_3

export type ConversationMembersType =
    0 // KBFS_0
  | 1 // TEAM_1
  | 2 // IMPTEAM_2

export type ConversationMetadata = {
  idTriple: ConversationIDTriple,
  conversationID: ConversationID,
  visibility: keybase1.TLFVisibility,
  status: ConversationStatus,
  membersType: ConversationMembersType,
  teamType: TeamType,
  existence: ConversationExistence,
  version: ConversationVers,
  finalizeInfo?: ?ConversationFinalizeInfo,
  supersedes?: ?Array<ConversationMetadata>,
  supersededBy?: ?Array<ConversationMetadata>,
  activeList?: ?Array<gregor1.UID>,
  allList?: ?Array<gregor1.UID>,
}

export type ConversationNotificationInfo = {
  channelWide: boolean,
  settings: {[key: string]: {[key: string]: boolean}},
}

export type ConversationReaderInfo = {
  mtime: gregor1.Time,
  readMsgid: MessageID,
  maxMsgid: MessageID,
  status: ConversationMemberStatus,
}

export type ConversationResolveInfo = {
  newTLFName: string,
}

export type ConversationStaleUpdate = {
  convID: ConversationID,
  updateType: StaleUpdateType,
}

export type ConversationStatus =
    0 // UNFILED_0
  | 1 // FAVORITE_1
  | 2 // IGNORED_2
  | 3 // BLOCKED_3
  | 4 // MUTED_4
  | 5 // REPORTED_5

export type ConversationVers = uint64

export type DeleteConversationLocalRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type DeleteConversationRemoteRes = {
  rateLimit?: ?RateLimit,
}

export type DownloadAttachmentLocalRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type EncryptedData = {
  v: int,
  e: bytes,
  n: bytes,
}

export type FailedMessageInfo = {
  outboxRecords?: ?Array<OutboxRecord>,
}

export type FindConversationsLocalRes = {
  conversations?: ?Array<ConversationLocal>,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type GenericPayload = {
  Action: string,
  inboxVers: InboxVers,
  convID: ConversationID,
}

export type GetConversationForCLILocalQuery = {
  markAsRead: boolean,
  MessageTypes?: ?Array<MessageType>,
  Since?: ?string,
  limit: UnreadFirstNumLimit,
  conv: ConversationLocal,
}

export type GetConversationForCLILocalRes = {
  conversation: ConversationLocal,
  messages?: ?Array<MessageUnboxed>,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type GetConversationMetadataRemoteRes = {
  conv: Conversation,
  rateLimit?: ?RateLimit,
}

export type GetInboxAndUnboxLocalRes = {
  conversations?: ?Array<ConversationLocal>,
  pagination?: ?Pagination,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type GetInboxByTLFIDRemoteRes = {
  convs?: ?Array<Conversation>,
  rateLimit?: ?RateLimit,
}

export type GetInboxLocalQuery = {
  name?: ?NameQuery,
  topicName?: ?string,
  convIDs?: ?Array<ConversationID>,
  topicType?: ?TopicType,
  tlfVisibility?: ?keybase1.TLFVisibility,
  before?: ?gregor1.Time,
  after?: ?gregor1.Time,
  oneChatTypePerTLF?: ?boolean,
  status?: ?Array<ConversationStatus>,
  unreadOnly: boolean,
  readOnly: boolean,
  computeActiveList: boolean,
}

export type GetInboxLocalRes = {
  conversationsUnverified?: ?Array<Conversation>,
  pagination?: ?Pagination,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type GetInboxQuery = {
  convID?: ?ConversationID,
  topicType?: ?TopicType,
  tlfID?: ?TLFID,
  tlfVisibility?: ?keybase1.TLFVisibility,
  before?: ?gregor1.Time,
  after?: ?gregor1.Time,
  oneChatTypePerTLF?: ?boolean,
  status?: ?Array<ConversationStatus>,
  memberStatus?: ?Array<ConversationMemberStatus>,
  existences?: ?Array<ConversationExistence>,
  convIDs?: ?Array<ConversationID>,
  unreadOnly: boolean,
  readOnly: boolean,
  computeActiveList: boolean,
  summarizeMaxMsgs: boolean,
}

export type GetInboxRemoteRes = {
  inbox: InboxView,
  rateLimit?: ?RateLimit,
}

export type GetInboxSummaryForCLILocalQuery = {
  topicType: TopicType,
  after: string,
  before: string,
  visibility: keybase1.TLFVisibility,
  status?: ?Array<ConversationStatus>,
  unreadFirst: boolean,
  unreadFirstLimit: UnreadFirstNumLimit,
  activitySortedLimit: int,
}

export type GetInboxSummaryForCLILocalRes = {
  conversations?: ?Array<ConversationLocal>,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type GetMessagesLocalRes = {
  messages?: ?Array<MessageUnboxed>,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type GetMessagesRemoteRes = {
  msgs?: ?Array<MessageBoxed>,
  rateLimit?: ?RateLimit,
}

export type GetPublicConversationsRes = {
  conversations?: ?Array<Conversation>,
  rateLimit?: ?RateLimit,
}

export type GetTLFConversationsLocalRes = {
  convs?: ?Array<InboxUIItem>,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type GetTLFConversationsRes = {
  conversations?: ?Array<Conversation>,
  rateLimit?: ?RateLimit,
}

export type GetThreadLocalRes = {
  thread: ThreadView,
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type GetThreadQuery = {
  markAsRead: boolean,
  messageTypes?: ?Array<MessageType>,
  disableResolveSupersedes: boolean,
  before?: ?gregor1.Time,
  after?: ?gregor1.Time,
}

export type GetThreadRemoteRes = {
  thread: ThreadViewBoxed,
  rateLimit?: ?RateLimit,
}

export type GlobalAppNotificationSetting =
    0 // NEWMESSAGES_0
  | 1 // PLAINTEXTMOBILE_1
  | 2 // PLAINTEXTDESKTOP_2

export type GlobalAppNotificationSettings = {
  settings: {[key: string]: bool},
}

export type Hash = bytes

export type HeaderPlaintext =
    { version: 1, v1: ?HeaderPlaintextV1 }
  | { version: 2, v2: ?HeaderPlaintextUnsupported }
  | { version: 3, v3: ?HeaderPlaintextUnsupported }
  | { version: 4, v4: ?HeaderPlaintextUnsupported }
  | { version: 5, v5: ?HeaderPlaintextUnsupported }
  | { version: 6, v6: ?HeaderPlaintextUnsupported }
  | { version: 7, v7: ?HeaderPlaintextUnsupported }
  | { version: 8, v8: ?HeaderPlaintextUnsupported }
  | { version: 9, v9: ?HeaderPlaintextUnsupported }
  | { version: 10, v10: ?HeaderPlaintextUnsupported }

export type HeaderPlaintextMetaInfo = {
  crit: boolean,
}

export type HeaderPlaintextUnsupported = {
  mi: HeaderPlaintextMetaInfo,
}

export type HeaderPlaintextV1 = {
  conv: ConversationIDTriple,
  tlfName: string,
  tlfPublic: boolean,
  messageType: MessageType,
  prev?: ?Array<MessagePreviousPointer>,
  sender: gregor1.UID,
  senderDevice: gregor1.DeviceID,
  bodyHash: Hash,
  outboxInfo?: ?OutboxInfo,
  outboxID?: ?OutboxID,
  headerSignature?: ?SignatureInfo,
  merkleRoot?: ?MerkleRoot,
}

export type HeaderPlaintextVersion =
    1 // V1_1
  | 2 // V2_2
  | 3 // V3_3
  | 4 // V4_4
  | 5 // V5_5
  | 6 // V6_6
  | 7 // V7_7
  | 8 // V8_8
  | 9 // V9_9
  | 10 // V10_10

export type InboxResType =
    0 // VERSIONHIT_0
  | 1 // FULL_1

export type InboxUIItem = {
  convID: string,
  isEmpty: boolean,
  name: string,
  snippet: string,
  channel: string,
  headline: string,
  visibility: keybase1.TLFVisibility,
  participants?: ?Array<string>,
  status: ConversationStatus,
  membersType: ConversationMembersType,
  teamType: TeamType,
  time: gregor1.Time,
  notifications?: ?ConversationNotificationInfo,
  creatorInfo?: ?ConversationCreatorInfoLocal,
  version: ConversationVers,
  finalizeInfo?: ?ConversationFinalizeInfo,
  supersedes?: ?Array<ConversationMetadata>,
  supersededBy?: ?Array<ConversationMetadata>,
}

export type InboxUIItems = {
  items?: ?Array<InboxUIItem>,
  pagination?: ?UIPagination,
  offline: boolean,
}

export type InboxVers = uint64

export type InboxView =
    { rtype: 0 }
  | { rtype: 1, full: ?InboxViewFull }

export type InboxViewFull = {
  vers: InboxVers,
  conversations?: ?Array<Conversation>,
  pagination?: ?Pagination,
}

export type IncomingMessage = {
  message: UIMessage,
  convID: ConversationID,
  displayDesktopNotification: boolean,
  conv?: ?InboxUIItem,
  pagination?: ?UIPagination,
}

export type JoinLeaveConversationLocalRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type JoinLeaveConversationRemoteRes = {
  rateLimit?: ?RateLimit,
}

export type LocalFileSource = {
  filename: string,
}

export type LocalSource = {
  source: keybase1.Stream,
  filename: string,
  size: int,
}

export type MakePreviewRes = {
  mimeType: string,
  filename?: ?string,
  metadata?: ?AssetMetadata,
  baseMetadata?: ?AssetMetadata,
}

export type MarkAsReadLocalRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type MarkAsReadRes = {
  rateLimit?: ?RateLimit,
}

export type MembersUpdateInfo = {
  convID: ConversationID,
  member: string,
  joined: boolean,
}

export type MerkleRoot = {
  seqno: long,
  hash: bytes,
}

export type MessageAttachment = {
  object: Asset,
  preview?: ?Asset,
  previews?: ?Array<Asset>,
  metadata: bytes,
  uploaded: boolean,
}

export type MessageAttachmentUploaded = {
  messageID: MessageID,
  object: Asset,
  previews?: ?Array<Asset>,
  metadata: bytes,
}

export type MessageBody =
    { messageType: 1, text: ?MessageText }
  | { messageType: 2, attachment: ?MessageAttachment }
  | { messageType: 3, edit: ?MessageEdit }
  | { messageType: 4, delete: ?MessageDelete }
  | { messageType: 5, metadata: ?MessageConversationMetadata }
  | { messageType: 7, headline: ?MessageHeadline }
  | { messageType: 8, attachmentuploaded: ?MessageAttachmentUploaded }
  | { messageType: 9, join: ?MessageJoin }
  | { messageType: 10, leave: ?MessageLeave }

export type MessageBoxed = {
  version: MessageBoxedVersion,
  serverHeader?: ?MessageServerHeader,
  clientHeader: MessageClientHeader,
  headerCiphertext: SealedData,
  bodyCiphertext: EncryptedData,
  verifyKey: bytes,
  keyGeneration: int,
}

export type MessageBoxedVersion =
    0 // VNONE_0
  | 1 // V1_1
  | 2 // V2_2

export type MessageClientHeader = {
  conv: ConversationIDTriple,
  tlfName: string,
  tlfPublic: boolean,
  messageType: MessageType,
  supersedes: MessageID,
  deletes?: ?Array<MessageID>,
  prev?: ?Array<MessagePreviousPointer>,
  sender: gregor1.UID,
  senderDevice: gregor1.DeviceID,
  merkleRoot?: ?MerkleRoot,
  outboxID?: ?OutboxID,
  outboxInfo?: ?OutboxInfo,
}

export type MessageClientHeaderVerified = {
  conv: ConversationIDTriple,
  tlfName: string,
  tlfPublic: boolean,
  messageType: MessageType,
  prev?: ?Array<MessagePreviousPointer>,
  sender: gregor1.UID,
  senderDevice: gregor1.DeviceID,
  merkleRoot?: ?MerkleRoot,
  outboxID?: ?OutboxID,
  outboxInfo?: ?OutboxInfo,
}

export type MessageConversationMetadata = {
  conversationTitle: string,
}

export type MessageDelete = {
  messageIDs?: ?Array<MessageID>,
}

export type MessageEdit = {
  messageID: MessageID,
  body: string,
}

export type MessageHeadline = {
  headline: string,
}

export type MessageID = uint

export type MessageJoin = {}

export type MessageLeave = {}

export type MessagePlaintext = {
  clientHeader: MessageClientHeader,
  messageBody: MessageBody,
}

export type MessagePreviousPointer = {
  id: MessageID,
  hash: Hash,
}

export type MessageServerHeader = {
  messageID: MessageID,
  supersededBy: MessageID,
  ctime: gregor1.Time,
}

export type MessageSummary = {
  msgID: MessageID,
  messageType: MessageType,
  tlfName: string,
  tlfPublic: boolean,
  ctime: gregor1.Time,
}

export type MessageText = {
  body: string,
}

export type MessageType =
    0 // NONE_0
  | 1 // TEXT_1
  | 2 // ATTACHMENT_2
  | 3 // EDIT_3
  | 4 // DELETE_4
  | 5 // METADATA_5
  | 6 // TLFNAME_6
  | 7 // HEADLINE_7
  | 8 // ATTACHMENTUPLOADED_8
  | 9 // JOIN_9
  | 10 // LEAVE_10

export type MessageUnboxed =
    { state: 1, valid: ?MessageUnboxedValid }
  | { state: 2, error: ?MessageUnboxedError }
  | { state: 3, outbox: ?OutboxRecord }
  | { state: 4, placeholder: ?MessageUnboxedPlaceholder }

export type MessageUnboxedError = {
  errType: MessageUnboxedErrorType,
  errMsg: string,
  messageID: MessageID,
  messageType: MessageType,
  ctime: gregor1.Time,
}

export type MessageUnboxedErrorType =
    0 // MISC_0
  | 1 // BADVERSION_CRITICAL_1
  | 2 // BADVERSION_2
  | 3 // IDENTIFY_3

export type MessageUnboxedPlaceholder = {
  messageID: MessageID,
}

export type MessageUnboxedState =
    1 // VALID_1
  | 2 // ERROR_2
  | 3 // OUTBOX_3
  | 4 // PLACEHOLDER_4

export type MessageUnboxedValid = {
  clientHeader: MessageClientHeaderVerified,
  serverHeader: MessageServerHeader,
  messageBody: MessageBody,
  senderUsername: string,
  senderDeviceName: string,
  senderDeviceType: string,
  bodyHash: Hash,
  headerHash: Hash,
  headerSignature?: ?SignatureInfo,
  verificationKey?: ?bytes,
  senderDeviceRevokedAt?: ?gregor1.Time,
  atMentionUsernames?: ?Array<string>,
  atMentions?: ?Array<gregor1.UID>,
  channelMention: ChannelMention,
}

export type NameQuery = {
  name: string,
  membersType: ConversationMembersType,
}

export type NewConversationInfo = {
  conv: InboxUIItem,
}

export type NewConversationLocalRes = {
  conv: ConversationLocal,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type NewConversationPayload = {
  Action: string,
  convID: ConversationID,
  inboxVers: InboxVers,
  unreadUpdate?: ?UnreadUpdate,
}

export type NewConversationRemoteRes = {
  convID: ConversationID,
  createdComplexTeam: boolean,
  rateLimit?: ?RateLimit,
}

export type NewMessagePayload = {
  Action: string,
  convID: ConversationID,
  message: MessageBoxed,
  inboxVers: InboxVers,
  unreadUpdate?: ?UnreadUpdate,
}

export type NonblockFetchRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type NotificationKind =
    0 // GENERIC_0
  | 1 // ATMENTION_1

export type NotifyChatChatIdentifyUpdateRpcParam = Exact<{
  update: keybase1.CanonicalTLFNameAndIDWithBreaks
}>

export type NotifyChatChatInboxStaleRpcParam = Exact<{
  uid: keybase1.UID
}>

export type NotifyChatChatJoinedConversationRpcParam = Exact<{
  uid: keybase1.UID,
  conv: InboxUIItem
}>

export type NotifyChatChatLeftConversationRpcParam = Exact<{
  uid: keybase1.UID,
  convID: ConversationID
}>

export type NotifyChatChatTLFFinalizeRpcParam = Exact<{
  uid: keybase1.UID,
  convID: ConversationID,
  finalizeInfo: ConversationFinalizeInfo,
  conv?: ?InboxUIItem
}>

export type NotifyChatChatTLFResolveRpcParam = Exact<{
  uid: keybase1.UID,
  convID: ConversationID,
  resolveInfo: ConversationResolveInfo
}>

export type NotifyChatChatThreadsStaleRpcParam = Exact<{
  uid: keybase1.UID,
  updates?: ?Array<ConversationStaleUpdate>
}>

export type NotifyChatChatTypingUpdateRpcParam = Exact<{
  typingUpdates?: ?Array<ConvTypingUpdate>
}>

export type NotifyChatNewChatActivityRpcParam = Exact<{
  uid: keybase1.UID,
  activity: ChatActivity
}>

export type OutboxErrorType =
    0 // MISC_0
  | 1 // OFFLINE_1
  | 2 // IDENTIFY_2
  | 3 // TOOLONG_3
  | 4 // DUPLICATE_4

export type OutboxID = bytes

export type OutboxInfo = {
  prev: MessageID,
  composeTime: gregor1.Time,
}

export type OutboxRecord = {
  state: OutboxState,
  outboxID: OutboxID,
  convID: ConversationID,
  ctime: gregor1.Time,
  Msg: MessagePlaintext,
  identifyBehavior: keybase1.TLFIdentifyBehavior,
}

export type OutboxState =
    { state: 0, sending: ?int }
  | { state: 1, error: ?OutboxStateError }

export type OutboxStateError = {
  message: string,
  typ: OutboxErrorType,
}

export type OutboxStateType =
    0 // SENDING_0
  | 1 // ERROR_1

export type Pagination = {
  next: bytes,
  previous: bytes,
  num: int,
  last: boolean,
}

export type PostLocalNonblockRes = {
  rateLimits?: ?Array<RateLimit>,
  outboxID: OutboxID,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type PostLocalRes = {
  rateLimits?: ?Array<RateLimit>,
  messageID: MessageID,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type PostRemoteRes = {
  msgHeader: MessageServerHeader,
  rateLimit?: ?RateLimit,
}

export type RateLimit = {
  name: string,
  callsRemaining: int,
  windowReset: int,
  maxCalls: int,
}

export type ReadMessageInfo = {
  convID: ConversationID,
  msgID: MessageID,
  conv?: ?InboxUIItem,
}

export type ReadMessagePayload = {
  Action: string,
  convID: ConversationID,
  msgID: MessageID,
  inboxVers: InboxVers,
  unreadUpdate?: ?UnreadUpdate,
}

export type RemoteUserTypingUpdate = {
  uid: gregor1.UID,
  deviceID: gregor1.DeviceID,
  convID: ConversationID,
  typing: boolean,
}

export type S3Params = {
  bucket: string,
  objectKey: string,
  accessKey: string,
  acl: string,
  regionName: string,
  regionEndpoint: string,
  regionBucketEndpoint: string,
}

export type SealedData = {
  v: int,
  e: bytes,
  n: bytes,
}

export type ServerCacheVers = {
  inboxVers: int,
  bodiesVers: int,
}

export type SetAppNotificationSettingsInfo = {
  convID: ConversationID,
  settings: ConversationNotificationInfo,
}

export type SetAppNotificationSettingsLocalRes = {
  offline: boolean,
  rateLimits?: ?Array<RateLimit>,
}

export type SetAppNotificationSettingsPayload = {
  Action: string,
  convID: ConversationID,
  inboxVers: InboxVers,
  settings: ConversationNotificationInfo,
}

export type SetAppNotificationSettingsRes = {
  rateLimit?: ?RateLimit,
}

export type SetConversationStatusLocalRes = {
  rateLimits?: ?Array<RateLimit>,
  identifyFailures?: ?Array<keybase1.TLFIdentifyFailure>,
}

export type SetConversationStatusRes = {
  rateLimit?: ?RateLimit,
}

export type SetStatusInfo = {
  convID: ConversationID,
  status: ConversationStatus,
  conv?: ?InboxUIItem,
}

export type SetStatusPayload = {
  Action: string,
  convID: ConversationID,
  status: ConversationStatus,
  inboxVers: InboxVers,
  unreadUpdate?: ?UnreadUpdate,
}

export type SignEncryptedData = {
  v: int,
  e: bytes,
  n: bytes,
}

export type SignatureInfo = {
  v: int,
  s: bytes,
  k: bytes,
}

export type StaleUpdateType =
    0 // CLEAR_0
  | 1 // NEWACTIVITY_1

export type SyncAllNotificationRes =
    { typ: 0, state: ?gregor1.State }
  | { typ: 1, incremental: ?gregor1.SyncResult }

export type SyncAllNotificationType =
    0 // STATE_0
  | 1 // INCREMENTAL_1

export type SyncAllResult = {
  auth: gregor1.AuthResult,
  chat: SyncChatRes,
  notification: SyncAllNotificationRes,
  badge: UnreadUpdateFull,
}

export type SyncChatRes = {
  cacheVers: ServerCacheVers,
  inboxRes: SyncInboxRes,
}

export type SyncInboxRes =
    { typ: 0 }
  | { typ: 1, incremental: ?SyncIncrementalRes }
  | { typ: 2 }

export type SyncInboxResType =
    0 // CURRENT_0
  | 1 // INCREMENTAL_1
  | 2 // CLEAR_2

export type SyncIncrementalRes = {
  vers: InboxVers,
  convs?: ?Array<Conversation>,
}

export type TLFConvOrdinal = uint

export type TLFFinalizeUpdate = {
  finalizeInfo: ConversationFinalizeInfo,
  convIDs?: ?Array<ConversationID>,
  inboxVers: InboxVers,
}

export type TLFID = bytes

export type TLFResolveUpdate = {
  convID: ConversationID,
  inboxVers: InboxVers,
}

export type TeamType =
    0 // NONE_0
  | 1 // SIMPLE_1
  | 2 // COMPLEX_2

export type TeamTypeInfo = {
  convID: ConversationID,
  teamType: TeamType,
  conv?: ?InboxUIItem,
}

export type TeamTypePayload = {
  Action: string,
  convID: ConversationID,
  teamType: TeamType,
  inboxVers: InboxVers,
  unreadUpdate?: ?UnreadUpdate,
}

export type ThreadID = bytes

export type ThreadView = {
  messages?: ?Array<MessageUnboxed>,
  pagination?: ?Pagination,
}

export type ThreadViewBoxed = {
  messages?: ?Array<MessageBoxed>,
  pagination?: ?Pagination,
}

export type TopicID = bytes

export type TopicNameState = bytes

export type TopicType =
    0 // NONE_0
  | 1 // CHAT_1
  | 2 // DEV_2

export type TyperInfo = {
  uid: keybase1.UID,
  username: string,
  deviceID: keybase1.DeviceID,
  deviceName: string,
  deviceType: string,
}

export type UIMessage =
    { state: 1, valid: ?UIMessageValid }
  | { state: 2, error: ?MessageUnboxedError }
  | { state: 3, outbox: ?UIMessageOutbox }
  | { state: 4, placeholder: ?MessageUnboxedPlaceholder }

export type UIMessageOutbox = {
  state: OutboxState,
  outboxID: string,
  messageType: MessageType,
  body: string,
  ctime: gregor1.Time,
}

export type UIMessageValid = {
  messageID: MessageID,
  ctime: gregor1.Time,
  outboxID?: ?string,
  messageBody: MessageBody,
  senderUsername: string,
  senderDeviceName: string,
  senderDeviceType: string,
  superseded: boolean,
  senderDeviceRevokedAt?: ?gregor1.Time,
  atMentions?: ?Array<string>,
  channelMention: ChannelMention,
}

export type UIMessages = {
  messages?: ?Array<UIMessage>,
  pagination?: ?UIPagination,
}

export type UIPagination = {
  next: string,
  previous: string,
  num: int,
  last: boolean,
}

export type UnreadFirstNumLimit = {
  NumRead: int,
  AtLeast: int,
  AtMost: int,
}

export type UnreadUpdate = {
  convID: ConversationID,
  unreadMessages: int,
  unreadNotifyingMessages: {[key: string]: int},
}

export type UnreadUpdateFull = {
  ignore: boolean,
  inboxVers: InboxVers,
  updates?: ?Array<UnreadUpdate>,
}

export type UnverifiedInboxUIItem = {
  convID: string,
  name: string,
  visibility: keybase1.TLFVisibility,
  status: ConversationStatus,
  membersType: ConversationMembersType,
  teamType: TeamType,
  notifications?: ?ConversationNotificationInfo,
  time: gregor1.Time,
  version: ConversationVers,
  localMetadata?: ?UnverifiedInboxUIItemMetadata,
}

export type UnverifiedInboxUIItemMetadata = {
  channelName: string,
  headline: string,
  snippet: string,
  writerNames?: ?Array<string>,
}

export type UnverifiedInboxUIItems = {
  items?: ?Array<UnverifiedInboxUIItem>,
  pagination?: ?UIPagination,
  offline: boolean,
}

export type UpdateConversationMembership = {
  inboxVers: InboxVers,
  joined?: ?Array<ConversationMember>,
  removed?: ?Array<ConversationMember>,
  unreadUpdate?: ?UnreadUpdate,
}

export type chatUiChatAttachmentDownloadProgressRpcParam = Exact<{
  bytesComplete: long,
  bytesTotal: long
}>

export type chatUiChatAttachmentPreviewUploadStartRpcParam = Exact<{
  metadata: AssetMetadata
}>

export type chatUiChatAttachmentUploadOutboxIDRpcParam = Exact<{
  outboxID: OutboxID
}>

export type chatUiChatAttachmentUploadProgressRpcParam = Exact<{
  bytesComplete: long,
  bytesTotal: long
}>

export type chatUiChatAttachmentUploadStartRpcParam = Exact<{
  metadata: AssetMetadata,
  placeholderMsgID: MessageID
}>

export type chatUiChatConfirmChannelDeleteRpcParam = Exact<{
  channel: string
}>

export type chatUiChatInboxConversationRpcParam = Exact<{
  conv: InboxUIItem
}>

export type chatUiChatInboxFailedRpcParam = Exact<{
  convID: ConversationID,
  error: ConversationErrorLocal
}>

export type chatUiChatInboxUnverifiedRpcParam = Exact<{
  inbox: string
}>

export type chatUiChatThreadCachedRpcParam = Exact<{
  thread?: ?string
}>

export type chatUiChatThreadFullRpcParam = Exact<{
  thread: string
}>

export type localCancelPostRpcParam = Exact<{
  outboxID: OutboxID
}>

export type localDeleteConversationLocalRpcParam = Exact<{
  convID: ConversationID,
  channelName: string
}>

export type localDownloadAttachmentLocalRpcParam = Exact<{
  conversationID: ConversationID,
  messageID: MessageID,
  sink: keybase1.Stream,
  preview: boolean,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localDownloadFileAttachmentLocalRpcParam = Exact<{
  conversationID: ConversationID,
  messageID: MessageID,
  filename: string,
  preview: boolean,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localFindConversationsLocalRpcParam = Exact<{
  tlfName: string,
  membersType: ConversationMembersType,
  visibility: keybase1.TLFVisibility,
  topicType: TopicType,
  topicName: string,
  oneChatPerTLF?: ?boolean,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetCachedThreadRpcParam = Exact<{
  conversationID: ConversationID,
  query?: ?GetThreadQuery,
  pagination?: ?Pagination,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetConversationForCLILocalRpcParam = Exact<{
  query: GetConversationForCLILocalQuery
}>

export type localGetInboxAndUnboxLocalRpcParam = Exact<{
  query?: ?GetInboxLocalQuery,
  pagination?: ?Pagination,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetInboxNonblockLocalRpcParam = Exact<{
  maxUnbox?: ?int,
  query?: ?GetInboxLocalQuery,
  pagination?: ?Pagination,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetInboxSummaryForCLILocalRpcParam = Exact<{
  query: GetInboxSummaryForCLILocalQuery
}>

export type localGetMessagesLocalRpcParam = Exact<{
  conversationID: ConversationID,
  messageIDs?: ?Array<MessageID>,
  disableResolveSupersedes: boolean,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetTLFConversationsLocalRpcParam = Exact<{
  tlfName: string,
  topicType: TopicType,
  membersType: ConversationMembersType
}>

export type localGetThreadLocalRpcParam = Exact<{
  conversationID: ConversationID,
  query?: ?GetThreadQuery,
  pagination?: ?Pagination,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localGetThreadNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  query?: ?GetThreadQuery,
  pagination?: ?UIPagination,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localJoinConversationByIDLocalRpcParam = Exact<{
  convID: ConversationID
}>

export type localJoinConversationLocalRpcParam = Exact<{
  tlfName: string,
  topicType: TopicType,
  visibility: keybase1.TLFVisibility,
  topicName: string
}>

export type localLeaveConversationLocalRpcParam = Exact<{
  convID: ConversationID
}>

export type localMakePreviewRpcParam = Exact<{
  attachment: LocalFileSource,
  outputDir: string
}>

export type localMarkAsReadLocalRpcParam = Exact<{
  conversationID: ConversationID,
  msgID: MessageID
}>

export type localNewConversationLocalRpcParam = Exact<{
  tlfName: string,
  topicType: TopicType,
  tlfVisibility: keybase1.TLFVisibility,
  topicName?: ?string,
  membersType: ConversationMembersType,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostAttachmentLocalRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  visibility: keybase1.TLFVisibility,
  attachment: LocalSource,
  preview?: ?MakePreviewRes,
  title: string,
  metadata: bytes,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostDeleteNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  tlfPublic: boolean,
  supersedes: MessageID,
  clientPrev: MessageID,
  outboxID?: ?OutboxID,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostEditNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  tlfPublic: boolean,
  supersedes: MessageID,
  body: string,
  outboxID?: ?OutboxID,
  clientPrev: MessageID,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostFileAttachmentLocalRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  visibility: keybase1.TLFVisibility,
  attachment: LocalFileSource,
  preview?: ?MakePreviewRes,
  title: string,
  metadata: bytes,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostHeadlineNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  tlfPublic: boolean,
  headline: string,
  outboxID?: ?OutboxID,
  clientPrev: MessageID,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostHeadlineRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  tlfPublic: boolean,
  headline: string,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostLocalNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  msg: MessagePlaintext,
  clientPrev: MessageID,
  outboxID?: ?OutboxID,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostLocalRpcParam = Exact<{
  conversationID: ConversationID,
  msg: MessagePlaintext,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localPostTextNonblockRpcParam = Exact<{
  conversationID: ConversationID,
  tlfName: string,
  tlfPublic: boolean,
  body: string,
  clientPrev: MessageID,
  outboxID?: ?OutboxID,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localRetryPostRpcParam = Exact<{
  outboxID: OutboxID
}>

export type localSetAppNotificationSettingsLocalRpcParam = Exact<{
  convID: ConversationID,
  channelWide: boolean,
  settings?: ?Array<AppNotificationSettingLocal>
}>

export type localSetConversationStatusLocalRpcParam = Exact<{
  conversationID: ConversationID,
  status: ConversationStatus,
  identifyBehavior: keybase1.TLFIdentifyBehavior
}>

export type localSetGlobalAppNotificationSettingsLocalRpcParam = Exact<{
  settings: {[key: string]: bool}
}>

export type localUnboxMobilePushNotificationRpcParam = Exact<{
  payload: string,
  convID: string,
  membersType: ConversationMembersType,
  pushIDs?: ?Array<string>
}>

export type localUpdateTypingRpcParam = Exact<{
  conversationID: ConversationID,
  typing: boolean
}>

export type remoteDeleteConversationRpcParam = Exact<{
  convID: ConversationID
}>

export type remoteGetInboxRemoteRpcParam = Exact<{
  vers: InboxVers,
  query?: ?GetInboxQuery,
  pagination?: ?Pagination
}>

export type remoteGetInboxVersionRpcParam = Exact<{
  uid: gregor1.UID
}>

export type remoteGetMessagesRemoteRpcParam = Exact<{
  conversationID: ConversationID,
  messageIDs?: ?Array<MessageID>
}>

export type remoteGetPublicConversationsRpcParam = Exact<{
  tlfID: TLFID,
  topicType: TopicType,
  summarizeMaxMsgs: boolean
}>

export type remoteGetS3ParamsRpcParam = Exact<{
  conversationID: ConversationID
}>

export type remoteGetTLFConversationsRpcParam = Exact<{
  tlfID: TLFID,
  topicType: TopicType,
  membersType: ConversationMembersType,
  summarizeMaxMsgs: boolean
}>

export type remoteGetThreadRemoteRpcParam = Exact<{
  conversationID: ConversationID,
  query?: ?GetThreadQuery,
  pagination?: ?Pagination
}>

export type remoteGetUnreadUpdateFullRpcParam = Exact<{
  inboxVers: InboxVers
}>

export type remoteJoinConversationRpcParam = Exact<{
  convID: ConversationID
}>

export type remoteLeaveConversationRpcParam = Exact<{
  convID: ConversationID
}>

export type remoteMarkAsReadRpcParam = Exact<{
  conversationID: ConversationID,
  msgID: MessageID
}>

export type remoteNewConversationRemote2RpcParam = Exact<{
  idTriple: ConversationIDTriple,
  TLFMessage: MessageBoxed,
  membersType: ConversationMembersType,
  topicNameState?: ?TopicNameState
}>

export type remoteNewConversationRemoteRpcParam = Exact<{
  idTriple: ConversationIDTriple
}>

export type remotePostRemoteRpcParam = Exact<{
  conversationID: ConversationID,
  messageBoxed: MessageBoxed,
  atMentions?: ?Array<gregor1.UID>,
  channelMention: ChannelMention,
  topicNameState?: ?TopicNameState
}>

export type remotePublishReadMessageRpcParam = Exact<{
  uid: gregor1.UID,
  convID: ConversationID,
  msgID: MessageID
}>

export type remotePublishSetConversationStatusRpcParam = Exact<{
  uid: gregor1.UID,
  convID: ConversationID,
  status: ConversationStatus
}>

export type remoteRemoteNotificationSuccessfulRpcParam = Exact<{
  authToken: gregor1.SessionToken,
  companionPushIDs?: ?Array<string>
}>

export type remoteS3SignRpcParam = Exact<{
  version: int,
  payload: bytes
}>

export type remoteSetAppNotificationSettingsRpcParam = Exact<{
  convID: ConversationID,
  settings: ConversationNotificationInfo
}>

export type remoteSetConversationStatusRpcParam = Exact<{
  conversationID: ConversationID,
  status: ConversationStatus
}>

export type remoteSetGlobalAppNotificationSettingsRpcParam = Exact<{
  settings: GlobalAppNotificationSettings
}>

export type remoteSyncAllRpcParam = Exact<{
  uid: gregor1.UID,
  deviceID: gregor1.DeviceID,
  session: gregor1.SessionToken,
  inboxVers: InboxVers,
  ctime: gregor1.Time,
  fresh: boolean
}>

export type remoteSyncChatRpcParam = Exact<{
  vers: InboxVers
}>

export type remoteSyncInboxRpcParam = Exact<{
  vers: InboxVers
}>

export type remoteTlfFinalizeRpcParam = Exact<{
  tlfID: TLFID,
  resetUser: string,
  resetDate: string,
  resetTimestamp: gregor1.Time,
  resetFull: string
}>

export type remoteTlfResolveRpcParam = Exact<{
  tlfID: TLFID,
  resolvedWriters?: ?Array<gregor1.UID>,
  resolvedReaders?: ?Array<gregor1.UID>
}>

export type remoteUpdateTypingRemoteRpcParam = Exact<{
  uid: gregor1.UID,
  deviceID: gregor1.DeviceID,
  convID: ConversationID,
  typing: boolean
}>
type chatUiChatConfirmChannelDeleteResult = boolean
type localDeleteConversationLocalResult = DeleteConversationLocalRes
type localDownloadAttachmentLocalResult = DownloadAttachmentLocalRes
type localDownloadFileAttachmentLocalResult = DownloadAttachmentLocalRes
type localFindConversationsLocalResult = FindConversationsLocalRes
type localGenerateOutboxIDResult = OutboxID
type localGetCachedThreadResult = GetThreadLocalRes
type localGetConversationForCLILocalResult = GetConversationForCLILocalRes
type localGetGlobalAppNotificationSettingsLocalResult = GlobalAppNotificationSettings
type localGetInboxAndUnboxLocalResult = GetInboxAndUnboxLocalRes
type localGetInboxNonblockLocalResult = NonblockFetchRes
type localGetInboxSummaryForCLILocalResult = GetInboxSummaryForCLILocalRes
type localGetMessagesLocalResult = GetMessagesLocalRes
type localGetTLFConversationsLocalResult = GetTLFConversationsLocalRes
type localGetThreadLocalResult = GetThreadLocalRes
type localGetThreadNonblockResult = NonblockFetchRes
type localJoinConversationByIDLocalResult = JoinLeaveConversationLocalRes
type localJoinConversationLocalResult = JoinLeaveConversationLocalRes
type localLeaveConversationLocalResult = JoinLeaveConversationLocalRes
type localMakePreviewResult = MakePreviewRes
type localMarkAsReadLocalResult = MarkAsReadLocalRes
type localNewConversationLocalResult = NewConversationLocalRes
type localPostAttachmentLocalResult = PostLocalRes
type localPostDeleteNonblockResult = PostLocalNonblockRes
type localPostEditNonblockResult = PostLocalNonblockRes
type localPostFileAttachmentLocalResult = PostLocalRes
type localPostHeadlineNonblockResult = PostLocalNonblockRes
type localPostHeadlineResult = PostLocalRes
type localPostLocalNonblockResult = PostLocalNonblockRes
type localPostLocalResult = PostLocalRes
type localPostTextNonblockResult = PostLocalNonblockRes
type localSetAppNotificationSettingsLocalResult = SetAppNotificationSettingsLocalRes
type localSetConversationStatusLocalResult = SetConversationStatusLocalRes
type localUnboxMobilePushNotificationResult = string
type remoteDeleteConversationResult = DeleteConversationRemoteRes
type remoteGetGlobalAppNotificationSettingsResult = GlobalAppNotificationSettings
type remoteGetInboxRemoteResult = GetInboxRemoteRes
type remoteGetInboxVersionResult = InboxVers
type remoteGetMessagesRemoteResult = GetMessagesRemoteRes
type remoteGetPublicConversationsResult = GetPublicConversationsRes
type remoteGetS3ParamsResult = S3Params
type remoteGetTLFConversationsResult = GetTLFConversationsRes
type remoteGetThreadRemoteResult = GetThreadRemoteRes
type remoteGetUnreadUpdateFullResult = UnreadUpdateFull
type remoteJoinConversationResult = JoinLeaveConversationRemoteRes
type remoteLeaveConversationResult = JoinLeaveConversationRemoteRes
type remoteMarkAsReadResult = MarkAsReadRes
type remoteNewConversationRemote2Result = NewConversationRemoteRes
type remoteNewConversationRemoteResult = NewConversationRemoteRes
type remotePostRemoteResult = PostRemoteRes
type remoteS3SignResult = bytes
type remoteSetAppNotificationSettingsResult = SetAppNotificationSettingsRes
type remoteSetConversationStatusResult = SetConversationStatusRes
type remoteSyncAllResult = SyncAllResult
type remoteSyncChatResult = SyncChatRes
type remoteSyncInboxResult = SyncInboxRes

export type incomingCallMapType = Exact<{
  'keybase.1.chatUi.chatAttachmentUploadOutboxID'?: (
    params: Exact<{
      sessionID: int,
      outboxID: OutboxID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentUploadStart'?: (
    params: Exact<{
      sessionID: int,
      metadata: AssetMetadata,
      placeholderMsgID: MessageID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentUploadProgress'?: (
    params: Exact<{
      sessionID: int,
      bytesComplete: long,
      bytesTotal: long
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentUploadDone'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentPreviewUploadStart'?: (
    params: Exact<{
      sessionID: int,
      metadata: AssetMetadata
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentPreviewUploadDone'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentDownloadStart'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentDownloadProgress'?: (
    params: Exact<{
      sessionID: int,
      bytesComplete: long,
      bytesTotal: long
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatAttachmentDownloadDone'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatInboxUnverified'?: (
    params: Exact<{
      sessionID: int,
      inbox: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatInboxConversation'?: (
    params: Exact<{
      sessionID: int,
      conv: InboxUIItem
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatInboxFailed'?: (
    params: Exact<{
      sessionID: int,
      convID: ConversationID,
      error: ConversationErrorLocal
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatThreadCached'?: (
    params: Exact<{
      sessionID: int,
      thread?: ?string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatThreadFull'?: (
    params: Exact<{
      sessionID: int,
      thread: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.chatUi.chatConfirmChannelDelete'?: (
    params: Exact<{
      sessionID: int,
      channel: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: chatUiChatConfirmChannelDeleteResult) => void,
    }
  ) => void,
  'keybase.1.NotifyChat.NewChatActivity'?: (
    params: Exact<{
      uid: keybase1.UID,
      activity: ChatActivity
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatIdentifyUpdate'?: (
    params: Exact<{
      update: keybase1.CanonicalTLFNameAndIDWithBreaks
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatTLFFinalize'?: (
    params: Exact<{
      uid: keybase1.UID,
      convID: ConversationID,
      finalizeInfo: ConversationFinalizeInfo,
      conv?: ?InboxUIItem
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatTLFResolve'?: (
    params: Exact<{
      uid: keybase1.UID,
      convID: ConversationID,
      resolveInfo: ConversationResolveInfo
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatInboxStale'?: (
    params: Exact<{
      uid: keybase1.UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatThreadsStale'?: (
    params: Exact<{
      uid: keybase1.UID,
      updates?: ?Array<ConversationStaleUpdate>
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatTypingUpdate'?: (
    params: Exact<{
      typingUpdates?: ?Array<ConvTypingUpdate>
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatJoinedConversation'?: (
    params: Exact<{
      uid: keybase1.UID,
      conv: InboxUIItem
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyChat.ChatLeftConversation'?: (
    params: Exact<{
      uid: keybase1.UID,
      convID: ConversationID
    }> /* ,
    response: {} // Notify call
    */
  ) => void
}>
