// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/keybase1/kbfs_git.avdl

package keybase1

import (
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type CreateRepoArg struct {
	Folder Folder      `codec:"folder" json:"folder"`
	Name   GitRepoName `codec:"name" json:"name"`
}

func (o CreateRepoArg) DeepCopy() CreateRepoArg {
	return CreateRepoArg{
		Folder: o.Folder.DeepCopy(),
		Name:   o.Name.DeepCopy(),
	}
}

type DeleteRepoArg struct {
	Folder Folder      `codec:"folder" json:"folder"`
	Name   GitRepoName `codec:"name" json:"name"`
}

func (o DeleteRepoArg) DeepCopy() DeleteRepoArg {
	return DeleteRepoArg{
		Folder: o.Folder.DeepCopy(),
		Name:   o.Name.DeepCopy(),
	}
}

type KBFSGitInterface interface {
	// * createRepo creates a bare empty repo on KBFS under the given name in the given TLF.
	// * It returns the ID of the repo created.
	CreateRepo(context.Context, CreateRepoArg) (RepoID, error)
	// * deleteRepo deletes repo on KBFS under the given name in the given TLF.
	DeleteRepo(context.Context, DeleteRepoArg) error
}

func KBFSGitProtocol(i KBFSGitInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "keybase.1.KBFSGit",
		Methods: map[string]rpc.ServeHandlerDescription{
			"createRepo": {
				MakeArg: func() interface{} {
					ret := make([]CreateRepoArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]CreateRepoArg)
					if !ok {
						err = rpc.NewTypeError((*[]CreateRepoArg)(nil), args)
						return
					}
					ret, err = i.CreateRepo(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"deleteRepo": {
				MakeArg: func() interface{} {
					ret := make([]DeleteRepoArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DeleteRepoArg)
					if !ok {
						err = rpc.NewTypeError((*[]DeleteRepoArg)(nil), args)
						return
					}
					err = i.DeleteRepo(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type KBFSGitClient struct {
	Cli rpc.GenericClient
}

// * createRepo creates a bare empty repo on KBFS under the given name in the given TLF.
// * It returns the ID of the repo created.
func (c KBFSGitClient) CreateRepo(ctx context.Context, __arg CreateRepoArg) (res RepoID, err error) {
	err = c.Cli.Call(ctx, "keybase.1.KBFSGit.createRepo", []interface{}{__arg}, &res)
	return
}

// * deleteRepo deletes repo on KBFS under the given name in the given TLF.
func (c KBFSGitClient) DeleteRepo(ctx context.Context, __arg DeleteRepoArg) (err error) {
	err = c.Cli.Call(ctx, "keybase.1.KBFSGit.deleteRepo", []interface{}{__arg}, nil)
	return
}
