// Auto-generated by avdl-compiler v1.3.20 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/chat1/local.avdl

package chat1

import (
	"errors"
	gregor1 "github.com/keybase/client/go/protocol/gregor1"
	keybase1 "github.com/keybase/client/go/protocol/keybase1"
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type MessageText struct {
	Body string `codec:"body" json:"body"`
}

func (o MessageText) DeepCopy() MessageText {
	return MessageText{
		Body: o.Body,
	}
}

type MessageConversationMetadata struct {
	ConversationTitle string `codec:"conversationTitle" json:"conversationTitle"`
}

func (o MessageConversationMetadata) DeepCopy() MessageConversationMetadata {
	return MessageConversationMetadata{
		ConversationTitle: o.ConversationTitle,
	}
}

type MessageEdit struct {
	MessageID MessageID `codec:"messageID" json:"messageID"`
	Body      string    `codec:"body" json:"body"`
}

func (o MessageEdit) DeepCopy() MessageEdit {
	return MessageEdit{
		MessageID: o.MessageID.DeepCopy(),
		Body:      o.Body,
	}
}

type MessageDelete struct {
	MessageIDs []MessageID `codec:"messageIDs" json:"messageIDs"`
}

func (o MessageDelete) DeepCopy() MessageDelete {
	return MessageDelete{
		MessageIDs: (func(x []MessageID) []MessageID {
			if x == nil {
				return nil
			}
			var ret []MessageID
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.MessageIDs),
	}
}

type MessageHeadline struct {
	Headline string `codec:"headline" json:"headline"`
}

func (o MessageHeadline) DeepCopy() MessageHeadline {
	return MessageHeadline{
		Headline: o.Headline,
	}
}

type AssetMetadataImage struct {
	Width  int `codec:"width" json:"width"`
	Height int `codec:"height" json:"height"`
}

func (o AssetMetadataImage) DeepCopy() AssetMetadataImage {
	return AssetMetadataImage{
		Width:  o.Width,
		Height: o.Height,
	}
}

type AssetMetadataVideo struct {
	Width      int `codec:"width" json:"width"`
	Height     int `codec:"height" json:"height"`
	DurationMs int `codec:"durationMs" json:"durationMs"`
}

func (o AssetMetadataVideo) DeepCopy() AssetMetadataVideo {
	return AssetMetadataVideo{
		Width:      o.Width,
		Height:     o.Height,
		DurationMs: o.DurationMs,
	}
}

type AssetMetadataAudio struct {
	DurationMs int `codec:"durationMs" json:"durationMs"`
}

func (o AssetMetadataAudio) DeepCopy() AssetMetadataAudio {
	return AssetMetadataAudio{
		DurationMs: o.DurationMs,
	}
}

type AssetMetadataType int

const (
	AssetMetadataType_NONE  AssetMetadataType = 0
	AssetMetadataType_IMAGE AssetMetadataType = 1
	AssetMetadataType_VIDEO AssetMetadataType = 2
	AssetMetadataType_AUDIO AssetMetadataType = 3
)

func (o AssetMetadataType) DeepCopy() AssetMetadataType { return o }

var AssetMetadataTypeMap = map[string]AssetMetadataType{
	"NONE":  0,
	"IMAGE": 1,
	"VIDEO": 2,
	"AUDIO": 3,
}

var AssetMetadataTypeRevMap = map[AssetMetadataType]string{
	0: "NONE",
	1: "IMAGE",
	2: "VIDEO",
	3: "AUDIO",
}

type AssetMetadata struct {
	AssetType__ AssetMetadataType   `codec:"assetType" json:"assetType"`
	Image__     *AssetMetadataImage `codec:"image,omitempty" json:"image,omitempty"`
	Video__     *AssetMetadataVideo `codec:"video,omitempty" json:"video,omitempty"`
	Audio__     *AssetMetadataAudio `codec:"audio,omitempty" json:"audio,omitempty"`
}

func (o *AssetMetadata) AssetType() (ret AssetMetadataType, err error) {
	switch o.AssetType__ {
	case AssetMetadataType_IMAGE:
		if o.Image__ == nil {
			err = errors.New("unexpected nil value for Image__")
			return ret, err
		}
	case AssetMetadataType_VIDEO:
		if o.Video__ == nil {
			err = errors.New("unexpected nil value for Video__")
			return ret, err
		}
	case AssetMetadataType_AUDIO:
		if o.Audio__ == nil {
			err = errors.New("unexpected nil value for Audio__")
			return ret, err
		}
	}
	return o.AssetType__, nil
}

func (o AssetMetadata) Image() (res AssetMetadataImage) {
	if o.AssetType__ != AssetMetadataType_IMAGE {
		panic("wrong case accessed")
	}
	if o.Image__ == nil {
		return
	}
	return *o.Image__
}

func (o AssetMetadata) Video() (res AssetMetadataVideo) {
	if o.AssetType__ != AssetMetadataType_VIDEO {
		panic("wrong case accessed")
	}
	if o.Video__ == nil {
		return
	}
	return *o.Video__
}

func (o AssetMetadata) Audio() (res AssetMetadataAudio) {
	if o.AssetType__ != AssetMetadataType_AUDIO {
		panic("wrong case accessed")
	}
	if o.Audio__ == nil {
		return
	}
	return *o.Audio__
}

func NewAssetMetadataWithImage(v AssetMetadataImage) AssetMetadata {
	return AssetMetadata{
		AssetType__: AssetMetadataType_IMAGE,
		Image__:     &v,
	}
}

func NewAssetMetadataWithVideo(v AssetMetadataVideo) AssetMetadata {
	return AssetMetadata{
		AssetType__: AssetMetadataType_VIDEO,
		Video__:     &v,
	}
}

func NewAssetMetadataWithAudio(v AssetMetadataAudio) AssetMetadata {
	return AssetMetadata{
		AssetType__: AssetMetadataType_AUDIO,
		Audio__:     &v,
	}
}

func (o AssetMetadata) DeepCopy() AssetMetadata {
	return AssetMetadata{
		AssetType__: o.AssetType__.DeepCopy(),
		Image__: (func(x *AssetMetadataImage) *AssetMetadataImage {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Image__),
		Video__: (func(x *AssetMetadataVideo) *AssetMetadataVideo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Video__),
		Audio__: (func(x *AssetMetadataAudio) *AssetMetadataAudio {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Audio__),
	}
}

type AssetTag int

const (
	AssetTag_PRIMARY AssetTag = 0
)

func (o AssetTag) DeepCopy() AssetTag { return o }

var AssetTagMap = map[string]AssetTag{
	"PRIMARY": 0,
}

var AssetTagRevMap = map[AssetTag]string{
	0: "PRIMARY",
}

type Asset struct {
	Filename  string        `codec:"filename" json:"filename"`
	Region    string        `codec:"region" json:"region"`
	Endpoint  string        `codec:"endpoint" json:"endpoint"`
	Bucket    string        `codec:"bucket" json:"bucket"`
	Path      string        `codec:"path" json:"path"`
	Size      int64         `codec:"size" json:"size"`
	MimeType  string        `codec:"mimeType" json:"mimeType"`
	EncHash   Hash          `codec:"encHash" json:"encHash"`
	Key       []byte        `codec:"key" json:"key"`
	VerifyKey []byte        `codec:"verifyKey" json:"verifyKey"`
	Title     string        `codec:"title" json:"title"`
	Nonce     []byte        `codec:"nonce" json:"nonce"`
	Metadata  AssetMetadata `codec:"metadata" json:"metadata"`
	Tag       AssetTag      `codec:"tag" json:"tag"`
}

func (o Asset) DeepCopy() Asset {
	return Asset{
		Filename: o.Filename,
		Region:   o.Region,
		Endpoint: o.Endpoint,
		Bucket:   o.Bucket,
		Path:     o.Path,
		Size:     o.Size,
		MimeType: o.MimeType,
		EncHash:  o.EncHash.DeepCopy(),
		Key: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Key),
		VerifyKey: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.VerifyKey),
		Title: o.Title,
		Nonce: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Nonce),
		Metadata: o.Metadata.DeepCopy(),
		Tag:      o.Tag.DeepCopy(),
	}
}

type MessageAttachment struct {
	Object   Asset   `codec:"object" json:"object"`
	Preview  *Asset  `codec:"preview,omitempty" json:"preview,omitempty"`
	Previews []Asset `codec:"previews" json:"previews"`
	Metadata []byte  `codec:"metadata" json:"metadata"`
	Uploaded bool    `codec:"uploaded" json:"uploaded"`
}

func (o MessageAttachment) DeepCopy() MessageAttachment {
	return MessageAttachment{
		Object: o.Object.DeepCopy(),
		Preview: (func(x *Asset) *Asset {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Preview),
		Previews: (func(x []Asset) []Asset {
			if x == nil {
				return nil
			}
			var ret []Asset
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Previews),
		Metadata: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Metadata),
		Uploaded: o.Uploaded,
	}
}

type MessageAttachmentUploaded struct {
	MessageID MessageID `codec:"messageID" json:"messageID"`
	Object    Asset     `codec:"object" json:"object"`
	Previews  []Asset   `codec:"previews" json:"previews"`
	Metadata  []byte    `codec:"metadata" json:"metadata"`
}

func (o MessageAttachmentUploaded) DeepCopy() MessageAttachmentUploaded {
	return MessageAttachmentUploaded{
		MessageID: o.MessageID.DeepCopy(),
		Object:    o.Object.DeepCopy(),
		Previews: (func(x []Asset) []Asset {
			if x == nil {
				return nil
			}
			var ret []Asset
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Previews),
		Metadata: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Metadata),
	}
}

type MessageJoin struct {
}

func (o MessageJoin) DeepCopy() MessageJoin {
	return MessageJoin{}
}

type MessageLeave struct {
}

func (o MessageLeave) DeepCopy() MessageLeave {
	return MessageLeave{}
}

type MessageBody struct {
	MessageType__        MessageType                  `codec:"messageType" json:"messageType"`
	Text__               *MessageText                 `codec:"text,omitempty" json:"text,omitempty"`
	Attachment__         *MessageAttachment           `codec:"attachment,omitempty" json:"attachment,omitempty"`
	Edit__               *MessageEdit                 `codec:"edit,omitempty" json:"edit,omitempty"`
	Delete__             *MessageDelete               `codec:"delete,omitempty" json:"delete,omitempty"`
	Metadata__           *MessageConversationMetadata `codec:"metadata,omitempty" json:"metadata,omitempty"`
	Headline__           *MessageHeadline             `codec:"headline,omitempty" json:"headline,omitempty"`
	Attachmentuploaded__ *MessageAttachmentUploaded   `codec:"attachmentuploaded,omitempty" json:"attachmentuploaded,omitempty"`
	Join__               *MessageJoin                 `codec:"join,omitempty" json:"join,omitempty"`
	Leave__              *MessageLeave                `codec:"leave,omitempty" json:"leave,omitempty"`
}

func (o *MessageBody) MessageType() (ret MessageType, err error) {
	switch o.MessageType__ {
	case MessageType_TEXT:
		if o.Text__ == nil {
			err = errors.New("unexpected nil value for Text__")
			return ret, err
		}
	case MessageType_ATTACHMENT:
		if o.Attachment__ == nil {
			err = errors.New("unexpected nil value for Attachment__")
			return ret, err
		}
	case MessageType_EDIT:
		if o.Edit__ == nil {
			err = errors.New("unexpected nil value for Edit__")
			return ret, err
		}
	case MessageType_DELETE:
		if o.Delete__ == nil {
			err = errors.New("unexpected nil value for Delete__")
			return ret, err
		}
	case MessageType_METADATA:
		if o.Metadata__ == nil {
			err = errors.New("unexpected nil value for Metadata__")
			return ret, err
		}
	case MessageType_HEADLINE:
		if o.Headline__ == nil {
			err = errors.New("unexpected nil value for Headline__")
			return ret, err
		}
	case MessageType_ATTACHMENTUPLOADED:
		if o.Attachmentuploaded__ == nil {
			err = errors.New("unexpected nil value for Attachmentuploaded__")
			return ret, err
		}
	case MessageType_JOIN:
		if o.Join__ == nil {
			err = errors.New("unexpected nil value for Join__")
			return ret, err
		}
	case MessageType_LEAVE:
		if o.Leave__ == nil {
			err = errors.New("unexpected nil value for Leave__")
			return ret, err
		}
	}
	return o.MessageType__, nil
}

func (o MessageBody) Text() (res MessageText) {
	if o.MessageType__ != MessageType_TEXT {
		panic("wrong case accessed")
	}
	if o.Text__ == nil {
		return
	}
	return *o.Text__
}

func (o MessageBody) Attachment() (res MessageAttachment) {
	if o.MessageType__ != MessageType_ATTACHMENT {
		panic("wrong case accessed")
	}
	if o.Attachment__ == nil {
		return
	}
	return *o.Attachment__
}

func (o MessageBody) Edit() (res MessageEdit) {
	if o.MessageType__ != MessageType_EDIT {
		panic("wrong case accessed")
	}
	if o.Edit__ == nil {
		return
	}
	return *o.Edit__
}

func (o MessageBody) Delete() (res MessageDelete) {
	if o.MessageType__ != MessageType_DELETE {
		panic("wrong case accessed")
	}
	if o.Delete__ == nil {
		return
	}
	return *o.Delete__
}

func (o MessageBody) Metadata() (res MessageConversationMetadata) {
	if o.MessageType__ != MessageType_METADATA {
		panic("wrong case accessed")
	}
	if o.Metadata__ == nil {
		return
	}
	return *o.Metadata__
}

func (o MessageBody) Headline() (res MessageHeadline) {
	if o.MessageType__ != MessageType_HEADLINE {
		panic("wrong case accessed")
	}
	if o.Headline__ == nil {
		return
	}
	return *o.Headline__
}

func (o MessageBody) Attachmentuploaded() (res MessageAttachmentUploaded) {
	if o.MessageType__ != MessageType_ATTACHMENTUPLOADED {
		panic("wrong case accessed")
	}
	if o.Attachmentuploaded__ == nil {
		return
	}
	return *o.Attachmentuploaded__
}

func (o MessageBody) Join() (res MessageJoin) {
	if o.MessageType__ != MessageType_JOIN {
		panic("wrong case accessed")
	}
	if o.Join__ == nil {
		return
	}
	return *o.Join__
}

func (o MessageBody) Leave() (res MessageLeave) {
	if o.MessageType__ != MessageType_LEAVE {
		panic("wrong case accessed")
	}
	if o.Leave__ == nil {
		return
	}
	return *o.Leave__
}

func NewMessageBodyWithText(v MessageText) MessageBody {
	return MessageBody{
		MessageType__: MessageType_TEXT,
		Text__:        &v,
	}
}

func NewMessageBodyWithAttachment(v MessageAttachment) MessageBody {
	return MessageBody{
		MessageType__: MessageType_ATTACHMENT,
		Attachment__:  &v,
	}
}

func NewMessageBodyWithEdit(v MessageEdit) MessageBody {
	return MessageBody{
		MessageType__: MessageType_EDIT,
		Edit__:        &v,
	}
}

func NewMessageBodyWithDelete(v MessageDelete) MessageBody {
	return MessageBody{
		MessageType__: MessageType_DELETE,
		Delete__:      &v,
	}
}

func NewMessageBodyWithMetadata(v MessageConversationMetadata) MessageBody {
	return MessageBody{
		MessageType__: MessageType_METADATA,
		Metadata__:    &v,
	}
}

func NewMessageBodyWithHeadline(v MessageHeadline) MessageBody {
	return MessageBody{
		MessageType__: MessageType_HEADLINE,
		Headline__:    &v,
	}
}

func NewMessageBodyWithAttachmentuploaded(v MessageAttachmentUploaded) MessageBody {
	return MessageBody{
		MessageType__:        MessageType_ATTACHMENTUPLOADED,
		Attachmentuploaded__: &v,
	}
}

func NewMessageBodyWithJoin(v MessageJoin) MessageBody {
	return MessageBody{
		MessageType__: MessageType_JOIN,
		Join__:        &v,
	}
}

func NewMessageBodyWithLeave(v MessageLeave) MessageBody {
	return MessageBody{
		MessageType__: MessageType_LEAVE,
		Leave__:       &v,
	}
}

func (o MessageBody) DeepCopy() MessageBody {
	return MessageBody{
		MessageType__: o.MessageType__.DeepCopy(),
		Text__: (func(x *MessageText) *MessageText {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Text__),
		Attachment__: (func(x *MessageAttachment) *MessageAttachment {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Attachment__),
		Edit__: (func(x *MessageEdit) *MessageEdit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Edit__),
		Delete__: (func(x *MessageDelete) *MessageDelete {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Delete__),
		Metadata__: (func(x *MessageConversationMetadata) *MessageConversationMetadata {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Metadata__),
		Headline__: (func(x *MessageHeadline) *MessageHeadline {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Headline__),
		Attachmentuploaded__: (func(x *MessageAttachmentUploaded) *MessageAttachmentUploaded {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Attachmentuploaded__),
		Join__: (func(x *MessageJoin) *MessageJoin {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Join__),
		Leave__: (func(x *MessageLeave) *MessageLeave {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Leave__),
	}
}

type OutboxStateType int

const (
	OutboxStateType_SENDING OutboxStateType = 0
	OutboxStateType_ERROR   OutboxStateType = 1
)

func (o OutboxStateType) DeepCopy() OutboxStateType { return o }

var OutboxStateTypeMap = map[string]OutboxStateType{
	"SENDING": 0,
	"ERROR":   1,
}

var OutboxStateTypeRevMap = map[OutboxStateType]string{
	0: "SENDING",
	1: "ERROR",
}

func (e OutboxStateType) String() string {
	if v, ok := OutboxStateTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type OutboxErrorType int

const (
	OutboxErrorType_MISC      OutboxErrorType = 0
	OutboxErrorType_OFFLINE   OutboxErrorType = 1
	OutboxErrorType_IDENTIFY  OutboxErrorType = 2
	OutboxErrorType_TOOLONG   OutboxErrorType = 3
	OutboxErrorType_DUPLICATE OutboxErrorType = 4
)

func (o OutboxErrorType) DeepCopy() OutboxErrorType { return o }

var OutboxErrorTypeMap = map[string]OutboxErrorType{
	"MISC":      0,
	"OFFLINE":   1,
	"IDENTIFY":  2,
	"TOOLONG":   3,
	"DUPLICATE": 4,
}

var OutboxErrorTypeRevMap = map[OutboxErrorType]string{
	0: "MISC",
	1: "OFFLINE",
	2: "IDENTIFY",
	3: "TOOLONG",
	4: "DUPLICATE",
}

func (e OutboxErrorType) String() string {
	if v, ok := OutboxErrorTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type OutboxStateError struct {
	Message string          `codec:"message" json:"message"`
	Typ     OutboxErrorType `codec:"typ" json:"typ"`
}

func (o OutboxStateError) DeepCopy() OutboxStateError {
	return OutboxStateError{
		Message: o.Message,
		Typ:     o.Typ.DeepCopy(),
	}
}

type OutboxState struct {
	State__   OutboxStateType   `codec:"state" json:"state"`
	Sending__ *int              `codec:"sending,omitempty" json:"sending,omitempty"`
	Error__   *OutboxStateError `codec:"error,omitempty" json:"error,omitempty"`
}

func (o *OutboxState) State() (ret OutboxStateType, err error) {
	switch o.State__ {
	case OutboxStateType_SENDING:
		if o.Sending__ == nil {
			err = errors.New("unexpected nil value for Sending__")
			return ret, err
		}
	case OutboxStateType_ERROR:
		if o.Error__ == nil {
			err = errors.New("unexpected nil value for Error__")
			return ret, err
		}
	}
	return o.State__, nil
}

func (o OutboxState) Sending() (res int) {
	if o.State__ != OutboxStateType_SENDING {
		panic("wrong case accessed")
	}
	if o.Sending__ == nil {
		return
	}
	return *o.Sending__
}

func (o OutboxState) Error() (res OutboxStateError) {
	if o.State__ != OutboxStateType_ERROR {
		panic("wrong case accessed")
	}
	if o.Error__ == nil {
		return
	}
	return *o.Error__
}

func NewOutboxStateWithSending(v int) OutboxState {
	return OutboxState{
		State__:   OutboxStateType_SENDING,
		Sending__: &v,
	}
}

func NewOutboxStateWithError(v OutboxStateError) OutboxState {
	return OutboxState{
		State__: OutboxStateType_ERROR,
		Error__: &v,
	}
}

func (o OutboxState) DeepCopy() OutboxState {
	return OutboxState{
		State__: o.State__.DeepCopy(),
		Sending__: (func(x *int) *int {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Sending__),
		Error__: (func(x *OutboxStateError) *OutboxStateError {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Error__),
	}
}

type OutboxRecord struct {
	State            OutboxState                  `codec:"state" json:"state"`
	OutboxID         OutboxID                     `codec:"outboxID" json:"outboxID"`
	ConvID           ConversationID               `codec:"convID" json:"convID"`
	Ctime            gregor1.Time                 `codec:"ctime" json:"ctime"`
	Msg              MessagePlaintext             `codec:"Msg" json:"Msg"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o OutboxRecord) DeepCopy() OutboxRecord {
	return OutboxRecord{
		State:            o.State.DeepCopy(),
		OutboxID:         o.OutboxID.DeepCopy(),
		ConvID:           o.ConvID.DeepCopy(),
		Ctime:            o.Ctime.DeepCopy(),
		Msg:              o.Msg.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type HeaderPlaintextVersion int

const (
	HeaderPlaintextVersion_V1  HeaderPlaintextVersion = 1
	HeaderPlaintextVersion_V2  HeaderPlaintextVersion = 2
	HeaderPlaintextVersion_V3  HeaderPlaintextVersion = 3
	HeaderPlaintextVersion_V4  HeaderPlaintextVersion = 4
	HeaderPlaintextVersion_V5  HeaderPlaintextVersion = 5
	HeaderPlaintextVersion_V6  HeaderPlaintextVersion = 6
	HeaderPlaintextVersion_V7  HeaderPlaintextVersion = 7
	HeaderPlaintextVersion_V8  HeaderPlaintextVersion = 8
	HeaderPlaintextVersion_V9  HeaderPlaintextVersion = 9
	HeaderPlaintextVersion_V10 HeaderPlaintextVersion = 10
)

func (o HeaderPlaintextVersion) DeepCopy() HeaderPlaintextVersion { return o }

var HeaderPlaintextVersionMap = map[string]HeaderPlaintextVersion{
	"V1":  1,
	"V2":  2,
	"V3":  3,
	"V4":  4,
	"V5":  5,
	"V6":  6,
	"V7":  7,
	"V8":  8,
	"V9":  9,
	"V10": 10,
}

var HeaderPlaintextVersionRevMap = map[HeaderPlaintextVersion]string{
	1:  "V1",
	2:  "V2",
	3:  "V3",
	4:  "V4",
	5:  "V5",
	6:  "V6",
	7:  "V7",
	8:  "V8",
	9:  "V9",
	10: "V10",
}

func (e HeaderPlaintextVersion) String() string {
	if v, ok := HeaderPlaintextVersionRevMap[e]; ok {
		return v
	}
	return ""
}

type HeaderPlaintextMetaInfo struct {
	Crit bool `codec:"crit" json:"crit"`
}

func (o HeaderPlaintextMetaInfo) DeepCopy() HeaderPlaintextMetaInfo {
	return HeaderPlaintextMetaInfo{
		Crit: o.Crit,
	}
}

type HeaderPlaintextUnsupported struct {
	Mi HeaderPlaintextMetaInfo `codec:"mi" json:"mi"`
}

func (o HeaderPlaintextUnsupported) DeepCopy() HeaderPlaintextUnsupported {
	return HeaderPlaintextUnsupported{
		Mi: o.Mi.DeepCopy(),
	}
}

type HeaderPlaintextV1 struct {
	Conv            ConversationIDTriple     `codec:"conv" json:"conv"`
	TlfName         string                   `codec:"tlfName" json:"tlfName"`
	TlfPublic       bool                     `codec:"tlfPublic" json:"tlfPublic"`
	MessageType     MessageType              `codec:"messageType" json:"messageType"`
	Prev            []MessagePreviousPointer `codec:"prev" json:"prev"`
	Sender          gregor1.UID              `codec:"sender" json:"sender"`
	SenderDevice    gregor1.DeviceID         `codec:"senderDevice" json:"senderDevice"`
	BodyHash        Hash                     `codec:"bodyHash" json:"bodyHash"`
	OutboxInfo      *OutboxInfo              `codec:"outboxInfo,omitempty" json:"outboxInfo,omitempty"`
	OutboxID        *OutboxID                `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	HeaderSignature *SignatureInfo           `codec:"headerSignature,omitempty" json:"headerSignature,omitempty"`
	MerkleRoot      *MerkleRoot              `codec:"merkleRoot,omitempty" json:"merkleRoot,omitempty"`
}

func (o HeaderPlaintextV1) DeepCopy() HeaderPlaintextV1 {
	return HeaderPlaintextV1{
		Conv:        o.Conv.DeepCopy(),
		TlfName:     o.TlfName,
		TlfPublic:   o.TlfPublic,
		MessageType: o.MessageType.DeepCopy(),
		Prev: (func(x []MessagePreviousPointer) []MessagePreviousPointer {
			if x == nil {
				return nil
			}
			var ret []MessagePreviousPointer
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Prev),
		Sender:       o.Sender.DeepCopy(),
		SenderDevice: o.SenderDevice.DeepCopy(),
		BodyHash:     o.BodyHash.DeepCopy(),
		OutboxInfo: (func(x *OutboxInfo) *OutboxInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxInfo),
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		HeaderSignature: (func(x *SignatureInfo) *SignatureInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.HeaderSignature),
		MerkleRoot: (func(x *MerkleRoot) *MerkleRoot {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.MerkleRoot),
	}
}

type HeaderPlaintext struct {
	Version__ HeaderPlaintextVersion      `codec:"version" json:"version"`
	V1__      *HeaderPlaintextV1          `codec:"v1,omitempty" json:"v1,omitempty"`
	V2__      *HeaderPlaintextUnsupported `codec:"v2,omitempty" json:"v2,omitempty"`
	V3__      *HeaderPlaintextUnsupported `codec:"v3,omitempty" json:"v3,omitempty"`
	V4__      *HeaderPlaintextUnsupported `codec:"v4,omitempty" json:"v4,omitempty"`
	V5__      *HeaderPlaintextUnsupported `codec:"v5,omitempty" json:"v5,omitempty"`
	V6__      *HeaderPlaintextUnsupported `codec:"v6,omitempty" json:"v6,omitempty"`
	V7__      *HeaderPlaintextUnsupported `codec:"v7,omitempty" json:"v7,omitempty"`
	V8__      *HeaderPlaintextUnsupported `codec:"v8,omitempty" json:"v8,omitempty"`
	V9__      *HeaderPlaintextUnsupported `codec:"v9,omitempty" json:"v9,omitempty"`
	V10__     *HeaderPlaintextUnsupported `codec:"v10,omitempty" json:"v10,omitempty"`
}

func (o *HeaderPlaintext) Version() (ret HeaderPlaintextVersion, err error) {
	switch o.Version__ {
	case HeaderPlaintextVersion_V1:
		if o.V1__ == nil {
			err = errors.New("unexpected nil value for V1__")
			return ret, err
		}
	case HeaderPlaintextVersion_V2:
		if o.V2__ == nil {
			err = errors.New("unexpected nil value for V2__")
			return ret, err
		}
	case HeaderPlaintextVersion_V3:
		if o.V3__ == nil {
			err = errors.New("unexpected nil value for V3__")
			return ret, err
		}
	case HeaderPlaintextVersion_V4:
		if o.V4__ == nil {
			err = errors.New("unexpected nil value for V4__")
			return ret, err
		}
	case HeaderPlaintextVersion_V5:
		if o.V5__ == nil {
			err = errors.New("unexpected nil value for V5__")
			return ret, err
		}
	case HeaderPlaintextVersion_V6:
		if o.V6__ == nil {
			err = errors.New("unexpected nil value for V6__")
			return ret, err
		}
	case HeaderPlaintextVersion_V7:
		if o.V7__ == nil {
			err = errors.New("unexpected nil value for V7__")
			return ret, err
		}
	case HeaderPlaintextVersion_V8:
		if o.V8__ == nil {
			err = errors.New("unexpected nil value for V8__")
			return ret, err
		}
	case HeaderPlaintextVersion_V9:
		if o.V9__ == nil {
			err = errors.New("unexpected nil value for V9__")
			return ret, err
		}
	case HeaderPlaintextVersion_V10:
		if o.V10__ == nil {
			err = errors.New("unexpected nil value for V10__")
			return ret, err
		}
	}
	return o.Version__, nil
}

func (o HeaderPlaintext) V1() (res HeaderPlaintextV1) {
	if o.Version__ != HeaderPlaintextVersion_V1 {
		panic("wrong case accessed")
	}
	if o.V1__ == nil {
		return
	}
	return *o.V1__
}

func (o HeaderPlaintext) V2() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V2 {
		panic("wrong case accessed")
	}
	if o.V2__ == nil {
		return
	}
	return *o.V2__
}

func (o HeaderPlaintext) V3() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V3 {
		panic("wrong case accessed")
	}
	if o.V3__ == nil {
		return
	}
	return *o.V3__
}

func (o HeaderPlaintext) V4() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V4 {
		panic("wrong case accessed")
	}
	if o.V4__ == nil {
		return
	}
	return *o.V4__
}

func (o HeaderPlaintext) V5() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V5 {
		panic("wrong case accessed")
	}
	if o.V5__ == nil {
		return
	}
	return *o.V5__
}

func (o HeaderPlaintext) V6() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V6 {
		panic("wrong case accessed")
	}
	if o.V6__ == nil {
		return
	}
	return *o.V6__
}

func (o HeaderPlaintext) V7() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V7 {
		panic("wrong case accessed")
	}
	if o.V7__ == nil {
		return
	}
	return *o.V7__
}

func (o HeaderPlaintext) V8() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V8 {
		panic("wrong case accessed")
	}
	if o.V8__ == nil {
		return
	}
	return *o.V8__
}

func (o HeaderPlaintext) V9() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V9 {
		panic("wrong case accessed")
	}
	if o.V9__ == nil {
		return
	}
	return *o.V9__
}

func (o HeaderPlaintext) V10() (res HeaderPlaintextUnsupported) {
	if o.Version__ != HeaderPlaintextVersion_V10 {
		panic("wrong case accessed")
	}
	if o.V10__ == nil {
		return
	}
	return *o.V10__
}

func NewHeaderPlaintextWithV1(v HeaderPlaintextV1) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V1,
		V1__:      &v,
	}
}

func NewHeaderPlaintextWithV2(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V2,
		V2__:      &v,
	}
}

func NewHeaderPlaintextWithV3(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V3,
		V3__:      &v,
	}
}

func NewHeaderPlaintextWithV4(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V4,
		V4__:      &v,
	}
}

func NewHeaderPlaintextWithV5(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V5,
		V5__:      &v,
	}
}

func NewHeaderPlaintextWithV6(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V6,
		V6__:      &v,
	}
}

func NewHeaderPlaintextWithV7(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V7,
		V7__:      &v,
	}
}

func NewHeaderPlaintextWithV8(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V8,
		V8__:      &v,
	}
}

func NewHeaderPlaintextWithV9(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V9,
		V9__:      &v,
	}
}

func NewHeaderPlaintextWithV10(v HeaderPlaintextUnsupported) HeaderPlaintext {
	return HeaderPlaintext{
		Version__: HeaderPlaintextVersion_V10,
		V10__:     &v,
	}
}

func (o HeaderPlaintext) DeepCopy() HeaderPlaintext {
	return HeaderPlaintext{
		Version__: o.Version__.DeepCopy(),
		V1__: (func(x *HeaderPlaintextV1) *HeaderPlaintextV1 {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V1__),
		V2__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V2__),
		V3__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V3__),
		V4__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V4__),
		V5__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V5__),
		V6__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V6__),
		V7__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V7__),
		V8__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V8__),
		V9__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V9__),
		V10__: (func(x *HeaderPlaintextUnsupported) *HeaderPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V10__),
	}
}

type BodyPlaintextVersion int

const (
	BodyPlaintextVersion_V1  BodyPlaintextVersion = 1
	BodyPlaintextVersion_V2  BodyPlaintextVersion = 2
	BodyPlaintextVersion_V3  BodyPlaintextVersion = 3
	BodyPlaintextVersion_V4  BodyPlaintextVersion = 4
	BodyPlaintextVersion_V5  BodyPlaintextVersion = 5
	BodyPlaintextVersion_V6  BodyPlaintextVersion = 6
	BodyPlaintextVersion_V7  BodyPlaintextVersion = 7
	BodyPlaintextVersion_V8  BodyPlaintextVersion = 8
	BodyPlaintextVersion_V9  BodyPlaintextVersion = 9
	BodyPlaintextVersion_V10 BodyPlaintextVersion = 10
)

func (o BodyPlaintextVersion) DeepCopy() BodyPlaintextVersion { return o }

var BodyPlaintextVersionMap = map[string]BodyPlaintextVersion{
	"V1":  1,
	"V2":  2,
	"V3":  3,
	"V4":  4,
	"V5":  5,
	"V6":  6,
	"V7":  7,
	"V8":  8,
	"V9":  9,
	"V10": 10,
}

var BodyPlaintextVersionRevMap = map[BodyPlaintextVersion]string{
	1:  "V1",
	2:  "V2",
	3:  "V3",
	4:  "V4",
	5:  "V5",
	6:  "V6",
	7:  "V7",
	8:  "V8",
	9:  "V9",
	10: "V10",
}

func (e BodyPlaintextVersion) String() string {
	if v, ok := BodyPlaintextVersionRevMap[e]; ok {
		return v
	}
	return ""
}

type BodyPlaintextMetaInfo struct {
	Crit bool `codec:"crit" json:"crit"`
}

func (o BodyPlaintextMetaInfo) DeepCopy() BodyPlaintextMetaInfo {
	return BodyPlaintextMetaInfo{
		Crit: o.Crit,
	}
}

type BodyPlaintextUnsupported struct {
	Mi BodyPlaintextMetaInfo `codec:"mi" json:"mi"`
}

func (o BodyPlaintextUnsupported) DeepCopy() BodyPlaintextUnsupported {
	return BodyPlaintextUnsupported{
		Mi: o.Mi.DeepCopy(),
	}
}

type BodyPlaintextV1 struct {
	MessageBody MessageBody `codec:"messageBody" json:"messageBody"`
}

func (o BodyPlaintextV1) DeepCopy() BodyPlaintextV1 {
	return BodyPlaintextV1{
		MessageBody: o.MessageBody.DeepCopy(),
	}
}

type BodyPlaintext struct {
	Version__ BodyPlaintextVersion      `codec:"version" json:"version"`
	V1__      *BodyPlaintextV1          `codec:"v1,omitempty" json:"v1,omitempty"`
	V2__      *BodyPlaintextUnsupported `codec:"v2,omitempty" json:"v2,omitempty"`
	V3__      *BodyPlaintextUnsupported `codec:"v3,omitempty" json:"v3,omitempty"`
	V4__      *BodyPlaintextUnsupported `codec:"v4,omitempty" json:"v4,omitempty"`
	V5__      *BodyPlaintextUnsupported `codec:"v5,omitempty" json:"v5,omitempty"`
	V6__      *BodyPlaintextUnsupported `codec:"v6,omitempty" json:"v6,omitempty"`
	V7__      *BodyPlaintextUnsupported `codec:"v7,omitempty" json:"v7,omitempty"`
	V8__      *BodyPlaintextUnsupported `codec:"v8,omitempty" json:"v8,omitempty"`
	V9__      *BodyPlaintextUnsupported `codec:"v9,omitempty" json:"v9,omitempty"`
	V10__     *BodyPlaintextUnsupported `codec:"v10,omitempty" json:"v10,omitempty"`
}

func (o *BodyPlaintext) Version() (ret BodyPlaintextVersion, err error) {
	switch o.Version__ {
	case BodyPlaintextVersion_V1:
		if o.V1__ == nil {
			err = errors.New("unexpected nil value for V1__")
			return ret, err
		}
	case BodyPlaintextVersion_V2:
		if o.V2__ == nil {
			err = errors.New("unexpected nil value for V2__")
			return ret, err
		}
	case BodyPlaintextVersion_V3:
		if o.V3__ == nil {
			err = errors.New("unexpected nil value for V3__")
			return ret, err
		}
	case BodyPlaintextVersion_V4:
		if o.V4__ == nil {
			err = errors.New("unexpected nil value for V4__")
			return ret, err
		}
	case BodyPlaintextVersion_V5:
		if o.V5__ == nil {
			err = errors.New("unexpected nil value for V5__")
			return ret, err
		}
	case BodyPlaintextVersion_V6:
		if o.V6__ == nil {
			err = errors.New("unexpected nil value for V6__")
			return ret, err
		}
	case BodyPlaintextVersion_V7:
		if o.V7__ == nil {
			err = errors.New("unexpected nil value for V7__")
			return ret, err
		}
	case BodyPlaintextVersion_V8:
		if o.V8__ == nil {
			err = errors.New("unexpected nil value for V8__")
			return ret, err
		}
	case BodyPlaintextVersion_V9:
		if o.V9__ == nil {
			err = errors.New("unexpected nil value for V9__")
			return ret, err
		}
	case BodyPlaintextVersion_V10:
		if o.V10__ == nil {
			err = errors.New("unexpected nil value for V10__")
			return ret, err
		}
	}
	return o.Version__, nil
}

func (o BodyPlaintext) V1() (res BodyPlaintextV1) {
	if o.Version__ != BodyPlaintextVersion_V1 {
		panic("wrong case accessed")
	}
	if o.V1__ == nil {
		return
	}
	return *o.V1__
}

func (o BodyPlaintext) V2() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V2 {
		panic("wrong case accessed")
	}
	if o.V2__ == nil {
		return
	}
	return *o.V2__
}

func (o BodyPlaintext) V3() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V3 {
		panic("wrong case accessed")
	}
	if o.V3__ == nil {
		return
	}
	return *o.V3__
}

func (o BodyPlaintext) V4() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V4 {
		panic("wrong case accessed")
	}
	if o.V4__ == nil {
		return
	}
	return *o.V4__
}

func (o BodyPlaintext) V5() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V5 {
		panic("wrong case accessed")
	}
	if o.V5__ == nil {
		return
	}
	return *o.V5__
}

func (o BodyPlaintext) V6() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V6 {
		panic("wrong case accessed")
	}
	if o.V6__ == nil {
		return
	}
	return *o.V6__
}

func (o BodyPlaintext) V7() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V7 {
		panic("wrong case accessed")
	}
	if o.V7__ == nil {
		return
	}
	return *o.V7__
}

func (o BodyPlaintext) V8() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V8 {
		panic("wrong case accessed")
	}
	if o.V8__ == nil {
		return
	}
	return *o.V8__
}

func (o BodyPlaintext) V9() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V9 {
		panic("wrong case accessed")
	}
	if o.V9__ == nil {
		return
	}
	return *o.V9__
}

func (o BodyPlaintext) V10() (res BodyPlaintextUnsupported) {
	if o.Version__ != BodyPlaintextVersion_V10 {
		panic("wrong case accessed")
	}
	if o.V10__ == nil {
		return
	}
	return *o.V10__
}

func NewBodyPlaintextWithV1(v BodyPlaintextV1) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V1,
		V1__:      &v,
	}
}

func NewBodyPlaintextWithV2(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V2,
		V2__:      &v,
	}
}

func NewBodyPlaintextWithV3(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V3,
		V3__:      &v,
	}
}

func NewBodyPlaintextWithV4(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V4,
		V4__:      &v,
	}
}

func NewBodyPlaintextWithV5(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V5,
		V5__:      &v,
	}
}

func NewBodyPlaintextWithV6(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V6,
		V6__:      &v,
	}
}

func NewBodyPlaintextWithV7(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V7,
		V7__:      &v,
	}
}

func NewBodyPlaintextWithV8(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V8,
		V8__:      &v,
	}
}

func NewBodyPlaintextWithV9(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V9,
		V9__:      &v,
	}
}

func NewBodyPlaintextWithV10(v BodyPlaintextUnsupported) BodyPlaintext {
	return BodyPlaintext{
		Version__: BodyPlaintextVersion_V10,
		V10__:     &v,
	}
}

func (o BodyPlaintext) DeepCopy() BodyPlaintext {
	return BodyPlaintext{
		Version__: o.Version__.DeepCopy(),
		V1__: (func(x *BodyPlaintextV1) *BodyPlaintextV1 {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V1__),
		V2__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V2__),
		V3__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V3__),
		V4__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V4__),
		V5__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V5__),
		V6__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V6__),
		V7__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V7__),
		V8__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V8__),
		V9__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V9__),
		V10__: (func(x *BodyPlaintextUnsupported) *BodyPlaintextUnsupported {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V10__),
	}
}

type MessagePlaintext struct {
	ClientHeader MessageClientHeader `codec:"clientHeader" json:"clientHeader"`
	MessageBody  MessageBody         `codec:"messageBody" json:"messageBody"`
}

func (o MessagePlaintext) DeepCopy() MessagePlaintext {
	return MessagePlaintext{
		ClientHeader: o.ClientHeader.DeepCopy(),
		MessageBody:  o.MessageBody.DeepCopy(),
	}
}

type MessageUnboxedValid struct {
	ClientHeader          MessageClientHeaderVerified `codec:"clientHeader" json:"clientHeader"`
	ServerHeader          MessageServerHeader         `codec:"serverHeader" json:"serverHeader"`
	MessageBody           MessageBody                 `codec:"messageBody" json:"messageBody"`
	SenderUsername        string                      `codec:"senderUsername" json:"senderUsername"`
	SenderDeviceName      string                      `codec:"senderDeviceName" json:"senderDeviceName"`
	SenderDeviceType      string                      `codec:"senderDeviceType" json:"senderDeviceType"`
	BodyHash              Hash                        `codec:"bodyHash" json:"bodyHash"`
	HeaderHash            Hash                        `codec:"headerHash" json:"headerHash"`
	HeaderSignature       *SignatureInfo              `codec:"headerSignature,omitempty" json:"headerSignature,omitempty"`
	VerificationKey       *[]byte                     `codec:"verificationKey,omitempty" json:"verificationKey,omitempty"`
	SenderDeviceRevokedAt *gregor1.Time               `codec:"senderDeviceRevokedAt,omitempty" json:"senderDeviceRevokedAt,omitempty"`
	AtMentionUsernames    []string                    `codec:"atMentionUsernames" json:"atMentionUsernames"`
	AtMentions            []gregor1.UID               `codec:"atMentions" json:"atMentions"`
	ChannelMention        ChannelMention              `codec:"channelMention" json:"channelMention"`
}

func (o MessageUnboxedValid) DeepCopy() MessageUnboxedValid {
	return MessageUnboxedValid{
		ClientHeader:     o.ClientHeader.DeepCopy(),
		ServerHeader:     o.ServerHeader.DeepCopy(),
		MessageBody:      o.MessageBody.DeepCopy(),
		SenderUsername:   o.SenderUsername,
		SenderDeviceName: o.SenderDeviceName,
		SenderDeviceType: o.SenderDeviceType,
		BodyHash:         o.BodyHash.DeepCopy(),
		HeaderHash:       o.HeaderHash.DeepCopy(),
		HeaderSignature: (func(x *SignatureInfo) *SignatureInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.HeaderSignature),
		VerificationKey: (func(x *[]byte) *[]byte {
			if x == nil {
				return nil
			}
			tmp := (func(x []byte) []byte {
				if x == nil {
					return nil
				}
				return append([]byte{}, x...)
			})((*x))
			return &tmp
		})(o.VerificationKey),
		SenderDeviceRevokedAt: (func(x *gregor1.Time) *gregor1.Time {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.SenderDeviceRevokedAt),
		AtMentionUsernames: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.AtMentionUsernames),
		AtMentions: (func(x []gregor1.UID) []gregor1.UID {
			if x == nil {
				return nil
			}
			var ret []gregor1.UID
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.AtMentions),
		ChannelMention: o.ChannelMention.DeepCopy(),
	}
}

type MessageUnboxedErrorType int

const (
	MessageUnboxedErrorType_MISC                MessageUnboxedErrorType = 0
	MessageUnboxedErrorType_BADVERSION_CRITICAL MessageUnboxedErrorType = 1
	MessageUnboxedErrorType_BADVERSION          MessageUnboxedErrorType = 2
	MessageUnboxedErrorType_IDENTIFY            MessageUnboxedErrorType = 3
)

func (o MessageUnboxedErrorType) DeepCopy() MessageUnboxedErrorType { return o }

var MessageUnboxedErrorTypeMap = map[string]MessageUnboxedErrorType{
	"MISC":                0,
	"BADVERSION_CRITICAL": 1,
	"BADVERSION":          2,
	"IDENTIFY":            3,
}

var MessageUnboxedErrorTypeRevMap = map[MessageUnboxedErrorType]string{
	0: "MISC",
	1: "BADVERSION_CRITICAL",
	2: "BADVERSION",
	3: "IDENTIFY",
}

func (e MessageUnboxedErrorType) String() string {
	if v, ok := MessageUnboxedErrorTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type MessageUnboxedError struct {
	ErrType     MessageUnboxedErrorType `codec:"errType" json:"errType"`
	ErrMsg      string                  `codec:"errMsg" json:"errMsg"`
	MessageID   MessageID               `codec:"messageID" json:"messageID"`
	MessageType MessageType             `codec:"messageType" json:"messageType"`
	Ctime       gregor1.Time            `codec:"ctime" json:"ctime"`
}

func (o MessageUnboxedError) DeepCopy() MessageUnboxedError {
	return MessageUnboxedError{
		ErrType:     o.ErrType.DeepCopy(),
		ErrMsg:      o.ErrMsg,
		MessageID:   o.MessageID.DeepCopy(),
		MessageType: o.MessageType.DeepCopy(),
		Ctime:       o.Ctime.DeepCopy(),
	}
}

type MessageUnboxedPlaceholder struct {
	MessageID MessageID `codec:"messageID" json:"messageID"`
}

func (o MessageUnboxedPlaceholder) DeepCopy() MessageUnboxedPlaceholder {
	return MessageUnboxedPlaceholder{
		MessageID: o.MessageID.DeepCopy(),
	}
}

type MessageUnboxed struct {
	State__       MessageUnboxedState        `codec:"state" json:"state"`
	Valid__       *MessageUnboxedValid       `codec:"valid,omitempty" json:"valid,omitempty"`
	Error__       *MessageUnboxedError       `codec:"error,omitempty" json:"error,omitempty"`
	Outbox__      *OutboxRecord              `codec:"outbox,omitempty" json:"outbox,omitempty"`
	Placeholder__ *MessageUnboxedPlaceholder `codec:"placeholder,omitempty" json:"placeholder,omitempty"`
}

func (o *MessageUnboxed) State() (ret MessageUnboxedState, err error) {
	switch o.State__ {
	case MessageUnboxedState_VALID:
		if o.Valid__ == nil {
			err = errors.New("unexpected nil value for Valid__")
			return ret, err
		}
	case MessageUnboxedState_ERROR:
		if o.Error__ == nil {
			err = errors.New("unexpected nil value for Error__")
			return ret, err
		}
	case MessageUnboxedState_OUTBOX:
		if o.Outbox__ == nil {
			err = errors.New("unexpected nil value for Outbox__")
			return ret, err
		}
	case MessageUnboxedState_PLACEHOLDER:
		if o.Placeholder__ == nil {
			err = errors.New("unexpected nil value for Placeholder__")
			return ret, err
		}
	}
	return o.State__, nil
}

func (o MessageUnboxed) Valid() (res MessageUnboxedValid) {
	if o.State__ != MessageUnboxedState_VALID {
		panic("wrong case accessed")
	}
	if o.Valid__ == nil {
		return
	}
	return *o.Valid__
}

func (o MessageUnboxed) Error() (res MessageUnboxedError) {
	if o.State__ != MessageUnboxedState_ERROR {
		panic("wrong case accessed")
	}
	if o.Error__ == nil {
		return
	}
	return *o.Error__
}

func (o MessageUnboxed) Outbox() (res OutboxRecord) {
	if o.State__ != MessageUnboxedState_OUTBOX {
		panic("wrong case accessed")
	}
	if o.Outbox__ == nil {
		return
	}
	return *o.Outbox__
}

func (o MessageUnboxed) Placeholder() (res MessageUnboxedPlaceholder) {
	if o.State__ != MessageUnboxedState_PLACEHOLDER {
		panic("wrong case accessed")
	}
	if o.Placeholder__ == nil {
		return
	}
	return *o.Placeholder__
}

func NewMessageUnboxedWithValid(v MessageUnboxedValid) MessageUnboxed {
	return MessageUnboxed{
		State__: MessageUnboxedState_VALID,
		Valid__: &v,
	}
}

func NewMessageUnboxedWithError(v MessageUnboxedError) MessageUnboxed {
	return MessageUnboxed{
		State__: MessageUnboxedState_ERROR,
		Error__: &v,
	}
}

func NewMessageUnboxedWithOutbox(v OutboxRecord) MessageUnboxed {
	return MessageUnboxed{
		State__:  MessageUnboxedState_OUTBOX,
		Outbox__: &v,
	}
}

func NewMessageUnboxedWithPlaceholder(v MessageUnboxedPlaceholder) MessageUnboxed {
	return MessageUnboxed{
		State__:       MessageUnboxedState_PLACEHOLDER,
		Placeholder__: &v,
	}
}

func (o MessageUnboxed) DeepCopy() MessageUnboxed {
	return MessageUnboxed{
		State__: o.State__.DeepCopy(),
		Valid__: (func(x *MessageUnboxedValid) *MessageUnboxedValid {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Valid__),
		Error__: (func(x *MessageUnboxedError) *MessageUnboxedError {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Error__),
		Outbox__: (func(x *OutboxRecord) *OutboxRecord {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Outbox__),
		Placeholder__: (func(x *MessageUnboxedPlaceholder) *MessageUnboxedPlaceholder {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Placeholder__),
	}
}

type UnreadFirstNumLimit struct {
	NumRead int `codec:"NumRead" json:"NumRead"`
	AtLeast int `codec:"AtLeast" json:"AtLeast"`
	AtMost  int `codec:"AtMost" json:"AtMost"`
}

func (o UnreadFirstNumLimit) DeepCopy() UnreadFirstNumLimit {
	return UnreadFirstNumLimit{
		NumRead: o.NumRead,
		AtLeast: o.AtLeast,
		AtMost:  o.AtMost,
	}
}

type ConversationInfoLocal struct {
	Id           ConversationID            `codec:"id" json:"id"`
	Triple       ConversationIDTriple      `codec:"triple" json:"triple"`
	TlfName      string                    `codec:"tlfName" json:"tlfName"`
	TopicName    string                    `codec:"topicName" json:"topicName"`
	Visibility   keybase1.TLFVisibility    `codec:"visibility" json:"visibility"`
	Status       ConversationStatus        `codec:"status" json:"status"`
	MembersType  ConversationMembersType   `codec:"membersType" json:"membersType"`
	TeamType     TeamType                  `codec:"teamType" json:"teamType"`
	Existence    ConversationExistence     `codec:"existence" json:"existence"`
	Version      ConversationVers          `codec:"version" json:"version"`
	WriterNames  []string                  `codec:"writerNames" json:"writerNames"`
	ReaderNames  []string                  `codec:"readerNames" json:"readerNames"`
	FinalizeInfo *ConversationFinalizeInfo `codec:"finalizeInfo,omitempty" json:"finalizeInfo,omitempty"`
}

func (o ConversationInfoLocal) DeepCopy() ConversationInfoLocal {
	return ConversationInfoLocal{
		Id:          o.Id.DeepCopy(),
		Triple:      o.Triple.DeepCopy(),
		TlfName:     o.TlfName,
		TopicName:   o.TopicName,
		Visibility:  o.Visibility.DeepCopy(),
		Status:      o.Status.DeepCopy(),
		MembersType: o.MembersType.DeepCopy(),
		TeamType:    o.TeamType.DeepCopy(),
		Existence:   o.Existence.DeepCopy(),
		Version:     o.Version.DeepCopy(),
		WriterNames: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.WriterNames),
		ReaderNames: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ReaderNames),
		FinalizeInfo: (func(x *ConversationFinalizeInfo) *ConversationFinalizeInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.FinalizeInfo),
	}
}

type ConversationErrorType int

const (
	ConversationErrorType_PERMANENT        ConversationErrorType = 0
	ConversationErrorType_MISSINGINFO      ConversationErrorType = 1
	ConversationErrorType_SELFREKEYNEEDED  ConversationErrorType = 2
	ConversationErrorType_OTHERREKEYNEEDED ConversationErrorType = 3
	ConversationErrorType_IDENTIFY         ConversationErrorType = 4
	ConversationErrorType_TRANSIENT        ConversationErrorType = 5
	ConversationErrorType_NONE             ConversationErrorType = 6
)

func (o ConversationErrorType) DeepCopy() ConversationErrorType { return o }

var ConversationErrorTypeMap = map[string]ConversationErrorType{
	"PERMANENT":        0,
	"MISSINGINFO":      1,
	"SELFREKEYNEEDED":  2,
	"OTHERREKEYNEEDED": 3,
	"IDENTIFY":         4,
	"TRANSIENT":        5,
	"NONE":             6,
}

var ConversationErrorTypeRevMap = map[ConversationErrorType]string{
	0: "PERMANENT",
	1: "MISSINGINFO",
	2: "SELFREKEYNEEDED",
	3: "OTHERREKEYNEEDED",
	4: "IDENTIFY",
	5: "TRANSIENT",
	6: "NONE",
}

func (e ConversationErrorType) String() string {
	if v, ok := ConversationErrorTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type ConversationErrorLocal struct {
	Typ               ConversationErrorType   `codec:"typ" json:"typ"`
	Message           string                  `codec:"message" json:"message"`
	RemoteConv        Conversation            `codec:"remoteConv" json:"remoteConv"`
	UnverifiedTLFName string                  `codec:"unverifiedTLFName" json:"unverifiedTLFName"`
	RekeyInfo         *ConversationErrorRekey `codec:"rekeyInfo,omitempty" json:"rekeyInfo,omitempty"`
}

func (o ConversationErrorLocal) DeepCopy() ConversationErrorLocal {
	return ConversationErrorLocal{
		Typ:               o.Typ.DeepCopy(),
		Message:           o.Message,
		RemoteConv:        o.RemoteConv.DeepCopy(),
		UnverifiedTLFName: o.UnverifiedTLFName,
		RekeyInfo: (func(x *ConversationErrorRekey) *ConversationErrorRekey {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RekeyInfo),
	}
}

type ConversationErrorRekey struct {
	TlfName     string   `codec:"tlfName" json:"tlfName"`
	TlfPublic   bool     `codec:"tlfPublic" json:"tlfPublic"`
	Rekeyers    []string `codec:"rekeyers" json:"rekeyers"`
	WriterNames []string `codec:"writerNames" json:"writerNames"`
	ReaderNames []string `codec:"readerNames" json:"readerNames"`
}

func (o ConversationErrorRekey) DeepCopy() ConversationErrorRekey {
	return ConversationErrorRekey{
		TlfName:   o.TlfName,
		TlfPublic: o.TlfPublic,
		Rekeyers: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Rekeyers),
		WriterNames: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.WriterNames),
		ReaderNames: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ReaderNames),
	}
}

type ConversationLocal struct {
	Error            *ConversationErrorLocal       `codec:"error,omitempty" json:"error,omitempty"`
	Info             ConversationInfoLocal         `codec:"info" json:"info"`
	ReaderInfo       ConversationReaderInfo        `codec:"readerInfo" json:"readerInfo"`
	CreatorInfo      *ConversationCreatorInfoLocal `codec:"creatorInfo,omitempty" json:"creatorInfo,omitempty"`
	Notifications    *ConversationNotificationInfo `codec:"notifications,omitempty" json:"notifications,omitempty"`
	Supersedes       []ConversationMetadata        `codec:"supersedes" json:"supersedes"`
	SupersededBy     []ConversationMetadata        `codec:"supersededBy" json:"supersededBy"`
	MaxMessages      []MessageUnboxed              `codec:"maxMessages" json:"maxMessages"`
	IsEmpty          bool                          `codec:"isEmpty" json:"isEmpty"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o ConversationLocal) DeepCopy() ConversationLocal {
	return ConversationLocal{
		Error: (func(x *ConversationErrorLocal) *ConversationErrorLocal {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Error),
		Info:       o.Info.DeepCopy(),
		ReaderInfo: o.ReaderInfo.DeepCopy(),
		CreatorInfo: (func(x *ConversationCreatorInfoLocal) *ConversationCreatorInfoLocal {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.CreatorInfo),
		Notifications: (func(x *ConversationNotificationInfo) *ConversationNotificationInfo {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Notifications),
		Supersedes: (func(x []ConversationMetadata) []ConversationMetadata {
			if x == nil {
				return nil
			}
			var ret []ConversationMetadata
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Supersedes),
		SupersededBy: (func(x []ConversationMetadata) []ConversationMetadata {
			if x == nil {
				return nil
			}
			var ret []ConversationMetadata
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.SupersededBy),
		MaxMessages: (func(x []MessageUnboxed) []MessageUnboxed {
			if x == nil {
				return nil
			}
			var ret []MessageUnboxed
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.MaxMessages),
		IsEmpty: o.IsEmpty,
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type NonblockFetchRes struct {
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o NonblockFetchRes) DeepCopy() NonblockFetchRes {
	return NonblockFetchRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type ThreadView struct {
	Messages   []MessageUnboxed `codec:"messages" json:"messages"`
	Pagination *Pagination      `codec:"pagination,omitempty" json:"pagination,omitempty"`
}

func (o ThreadView) DeepCopy() ThreadView {
	return ThreadView{
		Messages: (func(x []MessageUnboxed) []MessageUnboxed {
			if x == nil {
				return nil
			}
			var ret []MessageUnboxed
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Messages),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
	}
}

type GetThreadQuery struct {
	MarkAsRead               bool          `codec:"markAsRead" json:"markAsRead"`
	MessageTypes             []MessageType `codec:"messageTypes" json:"messageTypes"`
	DisableResolveSupersedes bool          `codec:"disableResolveSupersedes" json:"disableResolveSupersedes"`
	Before                   *gregor1.Time `codec:"before,omitempty" json:"before,omitempty"`
	After                    *gregor1.Time `codec:"after,omitempty" json:"after,omitempty"`
}

func (o GetThreadQuery) DeepCopy() GetThreadQuery {
	return GetThreadQuery{
		MarkAsRead: o.MarkAsRead,
		MessageTypes: (func(x []MessageType) []MessageType {
			if x == nil {
				return nil
			}
			var ret []MessageType
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.MessageTypes),
		DisableResolveSupersedes: o.DisableResolveSupersedes,
		Before: (func(x *gregor1.Time) *gregor1.Time {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Before),
		After: (func(x *gregor1.Time) *gregor1.Time {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.After),
	}
}

type GetThreadLocalRes struct {
	Thread           ThreadView                    `codec:"thread" json:"thread"`
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o GetThreadLocalRes) DeepCopy() GetThreadLocalRes {
	return GetThreadLocalRes{
		Thread:  o.Thread.DeepCopy(),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type GetInboxLocalRes struct {
	ConversationsUnverified []Conversation                `codec:"conversationsUnverified" json:"conversationsUnverified"`
	Pagination              *Pagination                   `codec:"pagination,omitempty" json:"pagination,omitempty"`
	Offline                 bool                          `codec:"offline" json:"offline"`
	RateLimits              []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures        []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o GetInboxLocalRes) DeepCopy() GetInboxLocalRes {
	return GetInboxLocalRes{
		ConversationsUnverified: (func(x []Conversation) []Conversation {
			if x == nil {
				return nil
			}
			var ret []Conversation
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ConversationsUnverified),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type NameQuery struct {
	Name        string                  `codec:"name" json:"name"`
	MembersType ConversationMembersType `codec:"membersType" json:"membersType"`
}

func (o NameQuery) DeepCopy() NameQuery {
	return NameQuery{
		Name:        o.Name,
		MembersType: o.MembersType.DeepCopy(),
	}
}

type GetInboxLocalQuery struct {
	Name              *NameQuery              `codec:"name,omitempty" json:"name,omitempty"`
	TopicName         *string                 `codec:"topicName,omitempty" json:"topicName,omitempty"`
	ConvIDs           []ConversationID        `codec:"convIDs" json:"convIDs"`
	TopicType         *TopicType              `codec:"topicType,omitempty" json:"topicType,omitempty"`
	TlfVisibility     *keybase1.TLFVisibility `codec:"tlfVisibility,omitempty" json:"tlfVisibility,omitempty"`
	Before            *gregor1.Time           `codec:"before,omitempty" json:"before,omitempty"`
	After             *gregor1.Time           `codec:"after,omitempty" json:"after,omitempty"`
	OneChatTypePerTLF *bool                   `codec:"oneChatTypePerTLF,omitempty" json:"oneChatTypePerTLF,omitempty"`
	Status            []ConversationStatus    `codec:"status" json:"status"`
	UnreadOnly        bool                    `codec:"unreadOnly" json:"unreadOnly"`
	ReadOnly          bool                    `codec:"readOnly" json:"readOnly"`
	ComputeActiveList bool                    `codec:"computeActiveList" json:"computeActiveList"`
}

func (o GetInboxLocalQuery) DeepCopy() GetInboxLocalQuery {
	return GetInboxLocalQuery{
		Name: (func(x *NameQuery) *NameQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Name),
		TopicName: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.TopicName),
		ConvIDs: (func(x []ConversationID) []ConversationID {
			if x == nil {
				return nil
			}
			var ret []ConversationID
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.ConvIDs),
		TopicType: (func(x *TopicType) *TopicType {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.TopicType),
		TlfVisibility: (func(x *keybase1.TLFVisibility) *keybase1.TLFVisibility {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.TlfVisibility),
		Before: (func(x *gregor1.Time) *gregor1.Time {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Before),
		After: (func(x *gregor1.Time) *gregor1.Time {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.After),
		OneChatTypePerTLF: (func(x *bool) *bool {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.OneChatTypePerTLF),
		Status: (func(x []ConversationStatus) []ConversationStatus {
			if x == nil {
				return nil
			}
			var ret []ConversationStatus
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Status),
		UnreadOnly:        o.UnreadOnly,
		ReadOnly:          o.ReadOnly,
		ComputeActiveList: o.ComputeActiveList,
	}
}

type GetInboxAndUnboxLocalRes struct {
	Conversations    []ConversationLocal           `codec:"conversations" json:"conversations"`
	Pagination       *Pagination                   `codec:"pagination,omitempty" json:"pagination,omitempty"`
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o GetInboxAndUnboxLocalRes) DeepCopy() GetInboxAndUnboxLocalRes {
	return GetInboxAndUnboxLocalRes{
		Conversations: (func(x []ConversationLocal) []ConversationLocal {
			if x == nil {
				return nil
			}
			var ret []ConversationLocal
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Conversations),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type PostLocalRes struct {
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	MessageID        MessageID                     `codec:"messageID" json:"messageID"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o PostLocalRes) DeepCopy() PostLocalRes {
	return PostLocalRes{
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		MessageID: o.MessageID.DeepCopy(),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type PostLocalNonblockRes struct {
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	OutboxID         OutboxID                      `codec:"outboxID" json:"outboxID"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o PostLocalNonblockRes) DeepCopy() PostLocalNonblockRes {
	return PostLocalNonblockRes{
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		OutboxID: o.OutboxID.DeepCopy(),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type SetConversationStatusLocalRes struct {
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o SetConversationStatusLocalRes) DeepCopy() SetConversationStatusLocalRes {
	return SetConversationStatusLocalRes{
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type NewConversationLocalRes struct {
	Conv             ConversationLocal             `codec:"conv" json:"conv"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o NewConversationLocalRes) DeepCopy() NewConversationLocalRes {
	return NewConversationLocalRes{
		Conv: o.Conv.DeepCopy(),
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type GetInboxSummaryForCLILocalQuery struct {
	TopicType           TopicType              `codec:"topicType" json:"topicType"`
	After               string                 `codec:"after" json:"after"`
	Before              string                 `codec:"before" json:"before"`
	Visibility          keybase1.TLFVisibility `codec:"visibility" json:"visibility"`
	Status              []ConversationStatus   `codec:"status" json:"status"`
	UnreadFirst         bool                   `codec:"unreadFirst" json:"unreadFirst"`
	UnreadFirstLimit    UnreadFirstNumLimit    `codec:"unreadFirstLimit" json:"unreadFirstLimit"`
	ActivitySortedLimit int                    `codec:"activitySortedLimit" json:"activitySortedLimit"`
}

func (o GetInboxSummaryForCLILocalQuery) DeepCopy() GetInboxSummaryForCLILocalQuery {
	return GetInboxSummaryForCLILocalQuery{
		TopicType:  o.TopicType.DeepCopy(),
		After:      o.After,
		Before:     o.Before,
		Visibility: o.Visibility.DeepCopy(),
		Status: (func(x []ConversationStatus) []ConversationStatus {
			if x == nil {
				return nil
			}
			var ret []ConversationStatus
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Status),
		UnreadFirst:         o.UnreadFirst,
		UnreadFirstLimit:    o.UnreadFirstLimit.DeepCopy(),
		ActivitySortedLimit: o.ActivitySortedLimit,
	}
}

type GetInboxSummaryForCLILocalRes struct {
	Conversations []ConversationLocal `codec:"conversations" json:"conversations"`
	Offline       bool                `codec:"offline" json:"offline"`
	RateLimits    []RateLimit         `codec:"rateLimits" json:"rateLimits"`
}

func (o GetInboxSummaryForCLILocalRes) DeepCopy() GetInboxSummaryForCLILocalRes {
	return GetInboxSummaryForCLILocalRes{
		Conversations: (func(x []ConversationLocal) []ConversationLocal {
			if x == nil {
				return nil
			}
			var ret []ConversationLocal
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Conversations),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type GetConversationForCLILocalQuery struct {
	MarkAsRead   bool                `codec:"markAsRead" json:"markAsRead"`
	MessageTypes []MessageType       `codec:"MessageTypes" json:"MessageTypes"`
	Since        *string             `codec:"Since,omitempty" json:"Since,omitempty"`
	Limit        UnreadFirstNumLimit `codec:"limit" json:"limit"`
	Conv         ConversationLocal   `codec:"conv" json:"conv"`
}

func (o GetConversationForCLILocalQuery) DeepCopy() GetConversationForCLILocalQuery {
	return GetConversationForCLILocalQuery{
		MarkAsRead: o.MarkAsRead,
		MessageTypes: (func(x []MessageType) []MessageType {
			if x == nil {
				return nil
			}
			var ret []MessageType
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.MessageTypes),
		Since: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Since),
		Limit: o.Limit.DeepCopy(),
		Conv:  o.Conv.DeepCopy(),
	}
}

type GetConversationForCLILocalRes struct {
	Conversation ConversationLocal `codec:"conversation" json:"conversation"`
	Messages     []MessageUnboxed  `codec:"messages" json:"messages"`
	Offline      bool              `codec:"offline" json:"offline"`
	RateLimits   []RateLimit       `codec:"rateLimits" json:"rateLimits"`
}

func (o GetConversationForCLILocalRes) DeepCopy() GetConversationForCLILocalRes {
	return GetConversationForCLILocalRes{
		Conversation: o.Conversation.DeepCopy(),
		Messages: (func(x []MessageUnboxed) []MessageUnboxed {
			if x == nil {
				return nil
			}
			var ret []MessageUnboxed
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Messages),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type GetMessagesLocalRes struct {
	Messages         []MessageUnboxed              `codec:"messages" json:"messages"`
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o GetMessagesLocalRes) DeepCopy() GetMessagesLocalRes {
	return GetMessagesLocalRes{
		Messages: (func(x []MessageUnboxed) []MessageUnboxed {
			if x == nil {
				return nil
			}
			var ret []MessageUnboxed
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Messages),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type LocalSource struct {
	Source   keybase1.Stream `codec:"source" json:"source"`
	Filename string          `codec:"filename" json:"filename"`
	Size     int             `codec:"size" json:"size"`
}

func (o LocalSource) DeepCopy() LocalSource {
	return LocalSource{
		Source:   o.Source.DeepCopy(),
		Filename: o.Filename,
		Size:     o.Size,
	}
}

type LocalFileSource struct {
	Filename string `codec:"filename" json:"filename"`
}

func (o LocalFileSource) DeepCopy() LocalFileSource {
	return LocalFileSource{
		Filename: o.Filename,
	}
}

type DownloadAttachmentLocalRes struct {
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o DownloadAttachmentLocalRes) DeepCopy() DownloadAttachmentLocalRes {
	return DownloadAttachmentLocalRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type MakePreviewRes struct {
	MimeType     string         `codec:"mimeType" json:"mimeType"`
	Filename     *string        `codec:"filename,omitempty" json:"filename,omitempty"`
	Metadata     *AssetMetadata `codec:"metadata,omitempty" json:"metadata,omitempty"`
	BaseMetadata *AssetMetadata `codec:"baseMetadata,omitempty" json:"baseMetadata,omitempty"`
}

func (o MakePreviewRes) DeepCopy() MakePreviewRes {
	return MakePreviewRes{
		MimeType: o.MimeType,
		Filename: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.Filename),
		Metadata: (func(x *AssetMetadata) *AssetMetadata {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Metadata),
		BaseMetadata: (func(x *AssetMetadata) *AssetMetadata {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.BaseMetadata),
	}
}

type MarkAsReadLocalRes struct {
	Offline    bool        `codec:"offline" json:"offline"`
	RateLimits []RateLimit `codec:"rateLimits" json:"rateLimits"`
}

func (o MarkAsReadLocalRes) DeepCopy() MarkAsReadLocalRes {
	return MarkAsReadLocalRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type FindConversationsLocalRes struct {
	Conversations    []ConversationLocal           `codec:"conversations" json:"conversations"`
	Offline          bool                          `codec:"offline" json:"offline"`
	RateLimits       []RateLimit                   `codec:"rateLimits" json:"rateLimits"`
	IdentifyFailures []keybase1.TLFIdentifyFailure `codec:"identifyFailures" json:"identifyFailures"`
}

func (o FindConversationsLocalRes) DeepCopy() FindConversationsLocalRes {
	return FindConversationsLocalRes{
		Conversations: (func(x []ConversationLocal) []ConversationLocal {
			if x == nil {
				return nil
			}
			var ret []ConversationLocal
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Conversations),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
		IdentifyFailures: (func(x []keybase1.TLFIdentifyFailure) []keybase1.TLFIdentifyFailure {
			if x == nil {
				return nil
			}
			var ret []keybase1.TLFIdentifyFailure
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.IdentifyFailures),
	}
}

type JoinLeaveConversationLocalRes struct {
	Offline    bool        `codec:"offline" json:"offline"`
	RateLimits []RateLimit `codec:"rateLimits" json:"rateLimits"`
}

func (o JoinLeaveConversationLocalRes) DeepCopy() JoinLeaveConversationLocalRes {
	return JoinLeaveConversationLocalRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type DeleteConversationLocalRes struct {
	Offline    bool        `codec:"offline" json:"offline"`
	RateLimits []RateLimit `codec:"rateLimits" json:"rateLimits"`
}

func (o DeleteConversationLocalRes) DeepCopy() DeleteConversationLocalRes {
	return DeleteConversationLocalRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type GetTLFConversationsLocalRes struct {
	Convs      []InboxUIItem `codec:"convs" json:"convs"`
	Offline    bool          `codec:"offline" json:"offline"`
	RateLimits []RateLimit   `codec:"rateLimits" json:"rateLimits"`
}

func (o GetTLFConversationsLocalRes) DeepCopy() GetTLFConversationsLocalRes {
	return GetTLFConversationsLocalRes{
		Convs: (func(x []InboxUIItem) []InboxUIItem {
			if x == nil {
				return nil
			}
			var ret []InboxUIItem
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Convs),
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type SetAppNotificationSettingsLocalRes struct {
	Offline    bool        `codec:"offline" json:"offline"`
	RateLimits []RateLimit `codec:"rateLimits" json:"rateLimits"`
}

func (o SetAppNotificationSettingsLocalRes) DeepCopy() SetAppNotificationSettingsLocalRes {
	return SetAppNotificationSettingsLocalRes{
		Offline: o.Offline,
		RateLimits: (func(x []RateLimit) []RateLimit {
			if x == nil {
				return nil
			}
			var ret []RateLimit
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.RateLimits),
	}
}

type AppNotificationSettingLocal struct {
	DeviceType keybase1.DeviceType `codec:"deviceType" json:"deviceType"`
	Kind       NotificationKind    `codec:"kind" json:"kind"`
	Enabled    bool                `codec:"enabled" json:"enabled"`
}

func (o AppNotificationSettingLocal) DeepCopy() AppNotificationSettingLocal {
	return AppNotificationSettingLocal{
		DeviceType: o.DeviceType.DeepCopy(),
		Kind:       o.Kind.DeepCopy(),
		Enabled:    o.Enabled,
	}
}

type GetThreadLocalArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Query            *GetThreadQuery              `codec:"query,omitempty" json:"query,omitempty"`
	Pagination       *Pagination                  `codec:"pagination,omitempty" json:"pagination,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetThreadLocalArg) DeepCopy() GetThreadLocalArg {
	return GetThreadLocalArg{
		ConversationID: o.ConversationID.DeepCopy(),
		Query: (func(x *GetThreadQuery) *GetThreadQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Query),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GetCachedThreadArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Query            *GetThreadQuery              `codec:"query,omitempty" json:"query,omitempty"`
	Pagination       *Pagination                  `codec:"pagination,omitempty" json:"pagination,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetCachedThreadArg) DeepCopy() GetCachedThreadArg {
	return GetCachedThreadArg{
		ConversationID: o.ConversationID.DeepCopy(),
		Query: (func(x *GetThreadQuery) *GetThreadQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Query),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GetThreadNonblockArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Query            *GetThreadQuery              `codec:"query,omitempty" json:"query,omitempty"`
	Pagination       *UIPagination                `codec:"pagination,omitempty" json:"pagination,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetThreadNonblockArg) DeepCopy() GetThreadNonblockArg {
	return GetThreadNonblockArg{
		SessionID:      o.SessionID,
		ConversationID: o.ConversationID.DeepCopy(),
		Query: (func(x *GetThreadQuery) *GetThreadQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Query),
		Pagination: (func(x *UIPagination) *UIPagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GetInboxAndUnboxLocalArg struct {
	Query            *GetInboxLocalQuery          `codec:"query,omitempty" json:"query,omitempty"`
	Pagination       *Pagination                  `codec:"pagination,omitempty" json:"pagination,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetInboxAndUnboxLocalArg) DeepCopy() GetInboxAndUnboxLocalArg {
	return GetInboxAndUnboxLocalArg{
		Query: (func(x *GetInboxLocalQuery) *GetInboxLocalQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Query),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GetInboxNonblockLocalArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	MaxUnbox         *int                         `codec:"maxUnbox,omitempty" json:"maxUnbox,omitempty"`
	Query            *GetInboxLocalQuery          `codec:"query,omitempty" json:"query,omitempty"`
	Pagination       *Pagination                  `codec:"pagination,omitempty" json:"pagination,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetInboxNonblockLocalArg) DeepCopy() GetInboxNonblockLocalArg {
	return GetInboxNonblockLocalArg{
		SessionID: o.SessionID,
		MaxUnbox: (func(x *int) *int {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.MaxUnbox),
		Query: (func(x *GetInboxLocalQuery) *GetInboxLocalQuery {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Query),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostLocalArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Msg              MessagePlaintext             `codec:"msg" json:"msg"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostLocalArg) DeepCopy() PostLocalArg {
	return PostLocalArg{
		ConversationID:   o.ConversationID.DeepCopy(),
		Msg:              o.Msg.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GenerateOutboxIDArg struct {
}

func (o GenerateOutboxIDArg) DeepCopy() GenerateOutboxIDArg {
	return GenerateOutboxIDArg{}
}

type PostLocalNonblockArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Msg              MessagePlaintext             `codec:"msg" json:"msg"`
	ClientPrev       MessageID                    `codec:"clientPrev" json:"clientPrev"`
	OutboxID         *OutboxID                    `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostLocalNonblockArg) DeepCopy() PostLocalNonblockArg {
	return PostLocalNonblockArg{
		ConversationID: o.ConversationID.DeepCopy(),
		Msg:            o.Msg.DeepCopy(),
		ClientPrev:     o.ClientPrev.DeepCopy(),
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostTextNonblockArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TlfPublic        bool                         `codec:"tlfPublic" json:"tlfPublic"`
	Body             string                       `codec:"body" json:"body"`
	ClientPrev       MessageID                    `codec:"clientPrev" json:"clientPrev"`
	OutboxID         *OutboxID                    `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostTextNonblockArg) DeepCopy() PostTextNonblockArg {
	return PostTextNonblockArg{
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		TlfPublic:      o.TlfPublic,
		Body:           o.Body,
		ClientPrev:     o.ClientPrev.DeepCopy(),
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostDeleteNonblockArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TlfPublic        bool                         `codec:"tlfPublic" json:"tlfPublic"`
	Supersedes       MessageID                    `codec:"supersedes" json:"supersedes"`
	ClientPrev       MessageID                    `codec:"clientPrev" json:"clientPrev"`
	OutboxID         *OutboxID                    `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostDeleteNonblockArg) DeepCopy() PostDeleteNonblockArg {
	return PostDeleteNonblockArg{
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		TlfPublic:      o.TlfPublic,
		Supersedes:     o.Supersedes.DeepCopy(),
		ClientPrev:     o.ClientPrev.DeepCopy(),
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostEditNonblockArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TlfPublic        bool                         `codec:"tlfPublic" json:"tlfPublic"`
	Supersedes       MessageID                    `codec:"supersedes" json:"supersedes"`
	Body             string                       `codec:"body" json:"body"`
	OutboxID         *OutboxID                    `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	ClientPrev       MessageID                    `codec:"clientPrev" json:"clientPrev"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostEditNonblockArg) DeepCopy() PostEditNonblockArg {
	return PostEditNonblockArg{
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		TlfPublic:      o.TlfPublic,
		Supersedes:     o.Supersedes.DeepCopy(),
		Body:           o.Body,
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		ClientPrev:       o.ClientPrev.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostHeadlineNonblockArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TlfPublic        bool                         `codec:"tlfPublic" json:"tlfPublic"`
	Headline         string                       `codec:"headline" json:"headline"`
	OutboxID         *OutboxID                    `codec:"outboxID,omitempty" json:"outboxID,omitempty"`
	ClientPrev       MessageID                    `codec:"clientPrev" json:"clientPrev"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostHeadlineNonblockArg) DeepCopy() PostHeadlineNonblockArg {
	return PostHeadlineNonblockArg{
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		TlfPublic:      o.TlfPublic,
		Headline:       o.Headline,
		OutboxID: (func(x *OutboxID) *OutboxID {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.OutboxID),
		ClientPrev:       o.ClientPrev.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostHeadlineArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TlfPublic        bool                         `codec:"tlfPublic" json:"tlfPublic"`
	Headline         string                       `codec:"headline" json:"headline"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostHeadlineArg) DeepCopy() PostHeadlineArg {
	return PostHeadlineArg{
		ConversationID:   o.ConversationID.DeepCopy(),
		TlfName:          o.TlfName,
		TlfPublic:        o.TlfPublic,
		Headline:         o.Headline,
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type SetConversationStatusLocalArg struct {
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	Status           ConversationStatus           `codec:"status" json:"status"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o SetConversationStatusLocalArg) DeepCopy() SetConversationStatusLocalArg {
	return SetConversationStatusLocalArg{
		ConversationID:   o.ConversationID.DeepCopy(),
		Status:           o.Status.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type NewConversationLocalArg struct {
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	TopicType        TopicType                    `codec:"topicType" json:"topicType"`
	TlfVisibility    keybase1.TLFVisibility       `codec:"tlfVisibility" json:"tlfVisibility"`
	TopicName        *string                      `codec:"topicName,omitempty" json:"topicName,omitempty"`
	MembersType      ConversationMembersType      `codec:"membersType" json:"membersType"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o NewConversationLocalArg) DeepCopy() NewConversationLocalArg {
	return NewConversationLocalArg{
		TlfName:       o.TlfName,
		TopicType:     o.TopicType.DeepCopy(),
		TlfVisibility: o.TlfVisibility.DeepCopy(),
		TopicName: (func(x *string) *string {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.TopicName),
		MembersType:      o.MembersType.DeepCopy(),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type GetInboxSummaryForCLILocalArg struct {
	Query GetInboxSummaryForCLILocalQuery `codec:"query" json:"query"`
}

func (o GetInboxSummaryForCLILocalArg) DeepCopy() GetInboxSummaryForCLILocalArg {
	return GetInboxSummaryForCLILocalArg{
		Query: o.Query.DeepCopy(),
	}
}

type GetConversationForCLILocalArg struct {
	Query GetConversationForCLILocalQuery `codec:"query" json:"query"`
}

func (o GetConversationForCLILocalArg) DeepCopy() GetConversationForCLILocalArg {
	return GetConversationForCLILocalArg{
		Query: o.Query.DeepCopy(),
	}
}

type GetMessagesLocalArg struct {
	ConversationID           ConversationID               `codec:"conversationID" json:"conversationID"`
	MessageIDs               []MessageID                  `codec:"messageIDs" json:"messageIDs"`
	DisableResolveSupersedes bool                         `codec:"disableResolveSupersedes" json:"disableResolveSupersedes"`
	IdentifyBehavior         keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o GetMessagesLocalArg) DeepCopy() GetMessagesLocalArg {
	return GetMessagesLocalArg{
		ConversationID: o.ConversationID.DeepCopy(),
		MessageIDs: (func(x []MessageID) []MessageID {
			if x == nil {
				return nil
			}
			var ret []MessageID
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.MessageIDs),
		DisableResolveSupersedes: o.DisableResolveSupersedes,
		IdentifyBehavior:         o.IdentifyBehavior.DeepCopy(),
	}
}

type PostAttachmentLocalArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	Visibility       keybase1.TLFVisibility       `codec:"visibility" json:"visibility"`
	Attachment       LocalSource                  `codec:"attachment" json:"attachment"`
	Preview          *MakePreviewRes              `codec:"preview,omitempty" json:"preview,omitempty"`
	Title            string                       `codec:"title" json:"title"`
	Metadata         []byte                       `codec:"metadata" json:"metadata"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostAttachmentLocalArg) DeepCopy() PostAttachmentLocalArg {
	return PostAttachmentLocalArg{
		SessionID:      o.SessionID,
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		Visibility:     o.Visibility.DeepCopy(),
		Attachment:     o.Attachment.DeepCopy(),
		Preview: (func(x *MakePreviewRes) *MakePreviewRes {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Preview),
		Title: o.Title,
		Metadata: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Metadata),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type PostFileAttachmentLocalArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	Visibility       keybase1.TLFVisibility       `codec:"visibility" json:"visibility"`
	Attachment       LocalFileSource              `codec:"attachment" json:"attachment"`
	Preview          *MakePreviewRes              `codec:"preview,omitempty" json:"preview,omitempty"`
	Title            string                       `codec:"title" json:"title"`
	Metadata         []byte                       `codec:"metadata" json:"metadata"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o PostFileAttachmentLocalArg) DeepCopy() PostFileAttachmentLocalArg {
	return PostFileAttachmentLocalArg{
		SessionID:      o.SessionID,
		ConversationID: o.ConversationID.DeepCopy(),
		TlfName:        o.TlfName,
		Visibility:     o.Visibility.DeepCopy(),
		Attachment:     o.Attachment.DeepCopy(),
		Preview: (func(x *MakePreviewRes) *MakePreviewRes {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Preview),
		Title: o.Title,
		Metadata: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.Metadata),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type DownloadAttachmentLocalArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	MessageID        MessageID                    `codec:"messageID" json:"messageID"`
	Sink             keybase1.Stream              `codec:"sink" json:"sink"`
	Preview          bool                         `codec:"preview" json:"preview"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o DownloadAttachmentLocalArg) DeepCopy() DownloadAttachmentLocalArg {
	return DownloadAttachmentLocalArg{
		SessionID:        o.SessionID,
		ConversationID:   o.ConversationID.DeepCopy(),
		MessageID:        o.MessageID.DeepCopy(),
		Sink:             o.Sink.DeepCopy(),
		Preview:          o.Preview,
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type DownloadFileAttachmentLocalArg struct {
	SessionID        int                          `codec:"sessionID" json:"sessionID"`
	ConversationID   ConversationID               `codec:"conversationID" json:"conversationID"`
	MessageID        MessageID                    `codec:"messageID" json:"messageID"`
	Filename         string                       `codec:"filename" json:"filename"`
	Preview          bool                         `codec:"preview" json:"preview"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o DownloadFileAttachmentLocalArg) DeepCopy() DownloadFileAttachmentLocalArg {
	return DownloadFileAttachmentLocalArg{
		SessionID:        o.SessionID,
		ConversationID:   o.ConversationID.DeepCopy(),
		MessageID:        o.MessageID.DeepCopy(),
		Filename:         o.Filename,
		Preview:          o.Preview,
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type MakePreviewArg struct {
	SessionID  int             `codec:"sessionID" json:"sessionID"`
	Attachment LocalFileSource `codec:"attachment" json:"attachment"`
	OutputDir  string          `codec:"outputDir" json:"outputDir"`
}

func (o MakePreviewArg) DeepCopy() MakePreviewArg {
	return MakePreviewArg{
		SessionID:  o.SessionID,
		Attachment: o.Attachment.DeepCopy(),
		OutputDir:  o.OutputDir,
	}
}

type CancelPostArg struct {
	OutboxID OutboxID `codec:"outboxID" json:"outboxID"`
}

func (o CancelPostArg) DeepCopy() CancelPostArg {
	return CancelPostArg{
		OutboxID: o.OutboxID.DeepCopy(),
	}
}

type RetryPostArg struct {
	OutboxID OutboxID `codec:"outboxID" json:"outboxID"`
}

func (o RetryPostArg) DeepCopy() RetryPostArg {
	return RetryPostArg{
		OutboxID: o.OutboxID.DeepCopy(),
	}
}

type MarkAsReadLocalArg struct {
	SessionID      int            `codec:"sessionID" json:"sessionID"`
	ConversationID ConversationID `codec:"conversationID" json:"conversationID"`
	MsgID          MessageID      `codec:"msgID" json:"msgID"`
}

func (o MarkAsReadLocalArg) DeepCopy() MarkAsReadLocalArg {
	return MarkAsReadLocalArg{
		SessionID:      o.SessionID,
		ConversationID: o.ConversationID.DeepCopy(),
		MsgID:          o.MsgID.DeepCopy(),
	}
}

type FindConversationsLocalArg struct {
	TlfName          string                       `codec:"tlfName" json:"tlfName"`
	MembersType      ConversationMembersType      `codec:"membersType" json:"membersType"`
	Visibility       keybase1.TLFVisibility       `codec:"visibility" json:"visibility"`
	TopicType        TopicType                    `codec:"topicType" json:"topicType"`
	TopicName        string                       `codec:"topicName" json:"topicName"`
	OneChatPerTLF    *bool                        `codec:"oneChatPerTLF,omitempty" json:"oneChatPerTLF,omitempty"`
	IdentifyBehavior keybase1.TLFIdentifyBehavior `codec:"identifyBehavior" json:"identifyBehavior"`
}

func (o FindConversationsLocalArg) DeepCopy() FindConversationsLocalArg {
	return FindConversationsLocalArg{
		TlfName:     o.TlfName,
		MembersType: o.MembersType.DeepCopy(),
		Visibility:  o.Visibility.DeepCopy(),
		TopicType:   o.TopicType.DeepCopy(),
		TopicName:   o.TopicName,
		OneChatPerTLF: (func(x *bool) *bool {
			if x == nil {
				return nil
			}
			tmp := (*x)
			return &tmp
		})(o.OneChatPerTLF),
		IdentifyBehavior: o.IdentifyBehavior.DeepCopy(),
	}
}

type UpdateTypingArg struct {
	ConversationID ConversationID `codec:"conversationID" json:"conversationID"`
	Typing         bool           `codec:"typing" json:"typing"`
}

func (o UpdateTypingArg) DeepCopy() UpdateTypingArg {
	return UpdateTypingArg{
		ConversationID: o.ConversationID.DeepCopy(),
		Typing:         o.Typing,
	}
}

type JoinConversationLocalArg struct {
	TlfName    string                 `codec:"tlfName" json:"tlfName"`
	TopicType  TopicType              `codec:"topicType" json:"topicType"`
	Visibility keybase1.TLFVisibility `codec:"visibility" json:"visibility"`
	TopicName  string                 `codec:"topicName" json:"topicName"`
}

func (o JoinConversationLocalArg) DeepCopy() JoinConversationLocalArg {
	return JoinConversationLocalArg{
		TlfName:    o.TlfName,
		TopicType:  o.TopicType.DeepCopy(),
		Visibility: o.Visibility.DeepCopy(),
		TopicName:  o.TopicName,
	}
}

type JoinConversationByIDLocalArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

func (o JoinConversationByIDLocalArg) DeepCopy() JoinConversationByIDLocalArg {
	return JoinConversationByIDLocalArg{
		ConvID: o.ConvID.DeepCopy(),
	}
}

type LeaveConversationLocalArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

func (o LeaveConversationLocalArg) DeepCopy() LeaveConversationLocalArg {
	return LeaveConversationLocalArg{
		ConvID: o.ConvID.DeepCopy(),
	}
}

type DeleteConversationLocalArg struct {
	SessionID   int            `codec:"sessionID" json:"sessionID"`
	ConvID      ConversationID `codec:"convID" json:"convID"`
	ChannelName string         `codec:"channelName" json:"channelName"`
}

func (o DeleteConversationLocalArg) DeepCopy() DeleteConversationLocalArg {
	return DeleteConversationLocalArg{
		SessionID:   o.SessionID,
		ConvID:      o.ConvID.DeepCopy(),
		ChannelName: o.ChannelName,
	}
}

type GetTLFConversationsLocalArg struct {
	TlfName     string                  `codec:"tlfName" json:"tlfName"`
	TopicType   TopicType               `codec:"topicType" json:"topicType"`
	MembersType ConversationMembersType `codec:"membersType" json:"membersType"`
}

func (o GetTLFConversationsLocalArg) DeepCopy() GetTLFConversationsLocalArg {
	return GetTLFConversationsLocalArg{
		TlfName:     o.TlfName,
		TopicType:   o.TopicType.DeepCopy(),
		MembersType: o.MembersType.DeepCopy(),
	}
}

type SetAppNotificationSettingsLocalArg struct {
	ConvID      ConversationID                `codec:"convID" json:"convID"`
	ChannelWide bool                          `codec:"channelWide" json:"channelWide"`
	Settings    []AppNotificationSettingLocal `codec:"settings" json:"settings"`
}

func (o SetAppNotificationSettingsLocalArg) DeepCopy() SetAppNotificationSettingsLocalArg {
	return SetAppNotificationSettingsLocalArg{
		ConvID:      o.ConvID.DeepCopy(),
		ChannelWide: o.ChannelWide,
		Settings: (func(x []AppNotificationSettingLocal) []AppNotificationSettingLocal {
			if x == nil {
				return nil
			}
			var ret []AppNotificationSettingLocal
			for _, v := range x {
				vCopy := v.DeepCopy()
				ret = append(ret, vCopy)
			}
			return ret
		})(o.Settings),
	}
}

type SetGlobalAppNotificationSettingsLocalArg struct {
	Settings map[string]bool `codec:"settings" json:"settings"`
}

func (o SetGlobalAppNotificationSettingsLocalArg) DeepCopy() SetGlobalAppNotificationSettingsLocalArg {
	return SetGlobalAppNotificationSettingsLocalArg{
		Settings: (func(x map[string]bool) map[string]bool {
			if x == nil {
				return nil
			}
			ret := make(map[string]bool)
			for k, v := range x {
				kCopy := k
				vCopy := v
				ret[kCopy] = vCopy
			}
			return ret
		})(o.Settings),
	}
}

type GetGlobalAppNotificationSettingsLocalArg struct {
}

func (o GetGlobalAppNotificationSettingsLocalArg) DeepCopy() GetGlobalAppNotificationSettingsLocalArg {
	return GetGlobalAppNotificationSettingsLocalArg{}
}

type UnboxMobilePushNotificationArg struct {
	Payload     string                  `codec:"payload" json:"payload"`
	ConvID      string                  `codec:"convID" json:"convID"`
	MembersType ConversationMembersType `codec:"membersType" json:"membersType"`
	PushIDs     []string                `codec:"pushIDs" json:"pushIDs"`
}

func (o UnboxMobilePushNotificationArg) DeepCopy() UnboxMobilePushNotificationArg {
	return UnboxMobilePushNotificationArg{
		Payload:     o.Payload,
		ConvID:      o.ConvID,
		MembersType: o.MembersType.DeepCopy(),
		PushIDs: (func(x []string) []string {
			if x == nil {
				return nil
			}
			var ret []string
			for _, v := range x {
				vCopy := v
				ret = append(ret, vCopy)
			}
			return ret
		})(o.PushIDs),
	}
}

type LocalInterface interface {
	GetThreadLocal(context.Context, GetThreadLocalArg) (GetThreadLocalRes, error)
	GetCachedThread(context.Context, GetCachedThreadArg) (GetThreadLocalRes, error)
	GetThreadNonblock(context.Context, GetThreadNonblockArg) (NonblockFetchRes, error)
	GetInboxAndUnboxLocal(context.Context, GetInboxAndUnboxLocalArg) (GetInboxAndUnboxLocalRes, error)
	GetInboxNonblockLocal(context.Context, GetInboxNonblockLocalArg) (NonblockFetchRes, error)
	PostLocal(context.Context, PostLocalArg) (PostLocalRes, error)
	GenerateOutboxID(context.Context) (OutboxID, error)
	PostLocalNonblock(context.Context, PostLocalNonblockArg) (PostLocalNonblockRes, error)
	PostTextNonblock(context.Context, PostTextNonblockArg) (PostLocalNonblockRes, error)
	PostDeleteNonblock(context.Context, PostDeleteNonblockArg) (PostLocalNonblockRes, error)
	PostEditNonblock(context.Context, PostEditNonblockArg) (PostLocalNonblockRes, error)
	PostHeadlineNonblock(context.Context, PostHeadlineNonblockArg) (PostLocalNonblockRes, error)
	PostHeadline(context.Context, PostHeadlineArg) (PostLocalRes, error)
	SetConversationStatusLocal(context.Context, SetConversationStatusLocalArg) (SetConversationStatusLocalRes, error)
	NewConversationLocal(context.Context, NewConversationLocalArg) (NewConversationLocalRes, error)
	GetInboxSummaryForCLILocal(context.Context, GetInboxSummaryForCLILocalQuery) (GetInboxSummaryForCLILocalRes, error)
	GetConversationForCLILocal(context.Context, GetConversationForCLILocalQuery) (GetConversationForCLILocalRes, error)
	GetMessagesLocal(context.Context, GetMessagesLocalArg) (GetMessagesLocalRes, error)
	PostAttachmentLocal(context.Context, PostAttachmentLocalArg) (PostLocalRes, error)
	PostFileAttachmentLocal(context.Context, PostFileAttachmentLocalArg) (PostLocalRes, error)
	DownloadAttachmentLocal(context.Context, DownloadAttachmentLocalArg) (DownloadAttachmentLocalRes, error)
	DownloadFileAttachmentLocal(context.Context, DownloadFileAttachmentLocalArg) (DownloadAttachmentLocalRes, error)
	MakePreview(context.Context, MakePreviewArg) (MakePreviewRes, error)
	CancelPost(context.Context, OutboxID) error
	RetryPost(context.Context, OutboxID) error
	MarkAsReadLocal(context.Context, MarkAsReadLocalArg) (MarkAsReadLocalRes, error)
	FindConversationsLocal(context.Context, FindConversationsLocalArg) (FindConversationsLocalRes, error)
	UpdateTyping(context.Context, UpdateTypingArg) error
	JoinConversationLocal(context.Context, JoinConversationLocalArg) (JoinLeaveConversationLocalRes, error)
	JoinConversationByIDLocal(context.Context, ConversationID) (JoinLeaveConversationLocalRes, error)
	LeaveConversationLocal(context.Context, ConversationID) (JoinLeaveConversationLocalRes, error)
	DeleteConversationLocal(context.Context, DeleteConversationLocalArg) (DeleteConversationLocalRes, error)
	GetTLFConversationsLocal(context.Context, GetTLFConversationsLocalArg) (GetTLFConversationsLocalRes, error)
	SetAppNotificationSettingsLocal(context.Context, SetAppNotificationSettingsLocalArg) (SetAppNotificationSettingsLocalRes, error)
	SetGlobalAppNotificationSettingsLocal(context.Context, map[string]bool) error
	GetGlobalAppNotificationSettingsLocal(context.Context) (GlobalAppNotificationSettings, error)
	UnboxMobilePushNotification(context.Context, UnboxMobilePushNotificationArg) (string, error)
}

func LocalProtocol(i LocalInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "chat.1.local",
		Methods: map[string]rpc.ServeHandlerDescription{
			"getThreadLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetThreadLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetThreadLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetThreadLocalArg)(nil), args)
						return
					}
					ret, err = i.GetThreadLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getCachedThread": {
				MakeArg: func() interface{} {
					ret := make([]GetCachedThreadArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetCachedThreadArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetCachedThreadArg)(nil), args)
						return
					}
					ret, err = i.GetCachedThread(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getThreadNonblock": {
				MakeArg: func() interface{} {
					ret := make([]GetThreadNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetThreadNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetThreadNonblockArg)(nil), args)
						return
					}
					ret, err = i.GetThreadNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getInboxAndUnboxLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetInboxAndUnboxLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetInboxAndUnboxLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetInboxAndUnboxLocalArg)(nil), args)
						return
					}
					ret, err = i.GetInboxAndUnboxLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getInboxNonblockLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetInboxNonblockLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetInboxNonblockLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetInboxNonblockLocalArg)(nil), args)
						return
					}
					ret, err = i.GetInboxNonblockLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postLocal": {
				MakeArg: func() interface{} {
					ret := make([]PostLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostLocalArg)(nil), args)
						return
					}
					ret, err = i.PostLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"generateOutboxID": {
				MakeArg: func() interface{} {
					ret := make([]GenerateOutboxIDArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.GenerateOutboxID(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postLocalNonblock": {
				MakeArg: func() interface{} {
					ret := make([]PostLocalNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostLocalNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostLocalNonblockArg)(nil), args)
						return
					}
					ret, err = i.PostLocalNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postTextNonblock": {
				MakeArg: func() interface{} {
					ret := make([]PostTextNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostTextNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostTextNonblockArg)(nil), args)
						return
					}
					ret, err = i.PostTextNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postDeleteNonblock": {
				MakeArg: func() interface{} {
					ret := make([]PostDeleteNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostDeleteNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostDeleteNonblockArg)(nil), args)
						return
					}
					ret, err = i.PostDeleteNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postEditNonblock": {
				MakeArg: func() interface{} {
					ret := make([]PostEditNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostEditNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostEditNonblockArg)(nil), args)
						return
					}
					ret, err = i.PostEditNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postHeadlineNonblock": {
				MakeArg: func() interface{} {
					ret := make([]PostHeadlineNonblockArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostHeadlineNonblockArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostHeadlineNonblockArg)(nil), args)
						return
					}
					ret, err = i.PostHeadlineNonblock(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postHeadline": {
				MakeArg: func() interface{} {
					ret := make([]PostHeadlineArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostHeadlineArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostHeadlineArg)(nil), args)
						return
					}
					ret, err = i.PostHeadline(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"SetConversationStatusLocal": {
				MakeArg: func() interface{} {
					ret := make([]SetConversationStatusLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]SetConversationStatusLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]SetConversationStatusLocalArg)(nil), args)
						return
					}
					ret, err = i.SetConversationStatusLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"newConversationLocal": {
				MakeArg: func() interface{} {
					ret := make([]NewConversationLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]NewConversationLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]NewConversationLocalArg)(nil), args)
						return
					}
					ret, err = i.NewConversationLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getInboxSummaryForCLILocal": {
				MakeArg: func() interface{} {
					ret := make([]GetInboxSummaryForCLILocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetInboxSummaryForCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetInboxSummaryForCLILocalArg)(nil), args)
						return
					}
					ret, err = i.GetInboxSummaryForCLILocal(ctx, (*typedArgs)[0].Query)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getConversationForCLILocal": {
				MakeArg: func() interface{} {
					ret := make([]GetConversationForCLILocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetConversationForCLILocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetConversationForCLILocalArg)(nil), args)
						return
					}
					ret, err = i.GetConversationForCLILocal(ctx, (*typedArgs)[0].Query)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"GetMessagesLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetMessagesLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetMessagesLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetMessagesLocalArg)(nil), args)
						return
					}
					ret, err = i.GetMessagesLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postAttachmentLocal": {
				MakeArg: func() interface{} {
					ret := make([]PostAttachmentLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostAttachmentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostAttachmentLocalArg)(nil), args)
						return
					}
					ret, err = i.PostAttachmentLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postFileAttachmentLocal": {
				MakeArg: func() interface{} {
					ret := make([]PostFileAttachmentLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]PostFileAttachmentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]PostFileAttachmentLocalArg)(nil), args)
						return
					}
					ret, err = i.PostFileAttachmentLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"DownloadAttachmentLocal": {
				MakeArg: func() interface{} {
					ret := make([]DownloadAttachmentLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DownloadAttachmentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]DownloadAttachmentLocalArg)(nil), args)
						return
					}
					ret, err = i.DownloadAttachmentLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"DownloadFileAttachmentLocal": {
				MakeArg: func() interface{} {
					ret := make([]DownloadFileAttachmentLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DownloadFileAttachmentLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]DownloadFileAttachmentLocalArg)(nil), args)
						return
					}
					ret, err = i.DownloadFileAttachmentLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"makePreview": {
				MakeArg: func() interface{} {
					ret := make([]MakePreviewArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]MakePreviewArg)
					if !ok {
						err = rpc.NewTypeError((*[]MakePreviewArg)(nil), args)
						return
					}
					ret, err = i.MakePreview(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"CancelPost": {
				MakeArg: func() interface{} {
					ret := make([]CancelPostArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]CancelPostArg)
					if !ok {
						err = rpc.NewTypeError((*[]CancelPostArg)(nil), args)
						return
					}
					err = i.CancelPost(ctx, (*typedArgs)[0].OutboxID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"RetryPost": {
				MakeArg: func() interface{} {
					ret := make([]RetryPostArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]RetryPostArg)
					if !ok {
						err = rpc.NewTypeError((*[]RetryPostArg)(nil), args)
						return
					}
					err = i.RetryPost(ctx, (*typedArgs)[0].OutboxID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"markAsReadLocal": {
				MakeArg: func() interface{} {
					ret := make([]MarkAsReadLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]MarkAsReadLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]MarkAsReadLocalArg)(nil), args)
						return
					}
					ret, err = i.MarkAsReadLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"findConversationsLocal": {
				MakeArg: func() interface{} {
					ret := make([]FindConversationsLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]FindConversationsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]FindConversationsLocalArg)(nil), args)
						return
					}
					ret, err = i.FindConversationsLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"updateTyping": {
				MakeArg: func() interface{} {
					ret := make([]UpdateTypingArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]UpdateTypingArg)
					if !ok {
						err = rpc.NewTypeError((*[]UpdateTypingArg)(nil), args)
						return
					}
					err = i.UpdateTyping(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"joinConversationLocal": {
				MakeArg: func() interface{} {
					ret := make([]JoinConversationLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]JoinConversationLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]JoinConversationLocalArg)(nil), args)
						return
					}
					ret, err = i.JoinConversationLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"joinConversationByIDLocal": {
				MakeArg: func() interface{} {
					ret := make([]JoinConversationByIDLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]JoinConversationByIDLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]JoinConversationByIDLocalArg)(nil), args)
						return
					}
					ret, err = i.JoinConversationByIDLocal(ctx, (*typedArgs)[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"leaveConversationLocal": {
				MakeArg: func() interface{} {
					ret := make([]LeaveConversationLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]LeaveConversationLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]LeaveConversationLocalArg)(nil), args)
						return
					}
					ret, err = i.LeaveConversationLocal(ctx, (*typedArgs)[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"deleteConversationLocal": {
				MakeArg: func() interface{} {
					ret := make([]DeleteConversationLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]DeleteConversationLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]DeleteConversationLocalArg)(nil), args)
						return
					}
					ret, err = i.DeleteConversationLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getTLFConversationsLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetTLFConversationsLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]GetTLFConversationsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]GetTLFConversationsLocalArg)(nil), args)
						return
					}
					ret, err = i.GetTLFConversationsLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setAppNotificationSettingsLocal": {
				MakeArg: func() interface{} {
					ret := make([]SetAppNotificationSettingsLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]SetAppNotificationSettingsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]SetAppNotificationSettingsLocalArg)(nil), args)
						return
					}
					ret, err = i.SetAppNotificationSettingsLocal(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setGlobalAppNotificationSettingsLocal": {
				MakeArg: func() interface{} {
					ret := make([]SetGlobalAppNotificationSettingsLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]SetGlobalAppNotificationSettingsLocalArg)
					if !ok {
						err = rpc.NewTypeError((*[]SetGlobalAppNotificationSettingsLocalArg)(nil), args)
						return
					}
					err = i.SetGlobalAppNotificationSettingsLocal(ctx, (*typedArgs)[0].Settings)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getGlobalAppNotificationSettingsLocal": {
				MakeArg: func() interface{} {
					ret := make([]GetGlobalAppNotificationSettingsLocalArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.GetGlobalAppNotificationSettingsLocal(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"unboxMobilePushNotification": {
				MakeArg: func() interface{} {
					ret := make([]UnboxMobilePushNotificationArg, 1)
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[]UnboxMobilePushNotificationArg)
					if !ok {
						err = rpc.NewTypeError((*[]UnboxMobilePushNotificationArg)(nil), args)
						return
					}
					ret, err = i.UnboxMobilePushNotification(ctx, (*typedArgs)[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type LocalClient struct {
	Cli rpc.GenericClient
}

func (c LocalClient) GetThreadLocal(ctx context.Context, __arg GetThreadLocalArg) (res GetThreadLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getThreadLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetCachedThread(ctx context.Context, __arg GetCachedThreadArg) (res GetThreadLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getCachedThread", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetThreadNonblock(ctx context.Context, __arg GetThreadNonblockArg) (res NonblockFetchRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getThreadNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetInboxAndUnboxLocal(ctx context.Context, __arg GetInboxAndUnboxLocalArg) (res GetInboxAndUnboxLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getInboxAndUnboxLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetInboxNonblockLocal(ctx context.Context, __arg GetInboxNonblockLocalArg) (res NonblockFetchRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getInboxNonblockLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostLocal(ctx context.Context, __arg PostLocalArg) (res PostLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GenerateOutboxID(ctx context.Context) (res OutboxID, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.generateOutboxID", []interface{}{GenerateOutboxIDArg{}}, &res)
	return
}

func (c LocalClient) PostLocalNonblock(ctx context.Context, __arg PostLocalNonblockArg) (res PostLocalNonblockRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postLocalNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostTextNonblock(ctx context.Context, __arg PostTextNonblockArg) (res PostLocalNonblockRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postTextNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostDeleteNonblock(ctx context.Context, __arg PostDeleteNonblockArg) (res PostLocalNonblockRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postDeleteNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostEditNonblock(ctx context.Context, __arg PostEditNonblockArg) (res PostLocalNonblockRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postEditNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostHeadlineNonblock(ctx context.Context, __arg PostHeadlineNonblockArg) (res PostLocalNonblockRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postHeadlineNonblock", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostHeadline(ctx context.Context, __arg PostHeadlineArg) (res PostLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postHeadline", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetConversationStatusLocal(ctx context.Context, __arg SetConversationStatusLocalArg) (res SetConversationStatusLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.SetConversationStatusLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) NewConversationLocal(ctx context.Context, __arg NewConversationLocalArg) (res NewConversationLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.newConversationLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetInboxSummaryForCLILocal(ctx context.Context, query GetInboxSummaryForCLILocalQuery) (res GetInboxSummaryForCLILocalRes, err error) {
	__arg := GetInboxSummaryForCLILocalArg{Query: query}
	err = c.Cli.Call(ctx, "chat.1.local.getInboxSummaryForCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetConversationForCLILocal(ctx context.Context, query GetConversationForCLILocalQuery) (res GetConversationForCLILocalRes, err error) {
	__arg := GetConversationForCLILocalArg{Query: query}
	err = c.Cli.Call(ctx, "chat.1.local.getConversationForCLILocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetMessagesLocal(ctx context.Context, __arg GetMessagesLocalArg) (res GetMessagesLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.GetMessagesLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostAttachmentLocal(ctx context.Context, __arg PostAttachmentLocalArg) (res PostLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postAttachmentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) PostFileAttachmentLocal(ctx context.Context, __arg PostFileAttachmentLocalArg) (res PostLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.postFileAttachmentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) DownloadAttachmentLocal(ctx context.Context, __arg DownloadAttachmentLocalArg) (res DownloadAttachmentLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.DownloadAttachmentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) DownloadFileAttachmentLocal(ctx context.Context, __arg DownloadFileAttachmentLocalArg) (res DownloadAttachmentLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.DownloadFileAttachmentLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) MakePreview(ctx context.Context, __arg MakePreviewArg) (res MakePreviewRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.makePreview", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) CancelPost(ctx context.Context, outboxID OutboxID) (err error) {
	__arg := CancelPostArg{OutboxID: outboxID}
	err = c.Cli.Call(ctx, "chat.1.local.CancelPost", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) RetryPost(ctx context.Context, outboxID OutboxID) (err error) {
	__arg := RetryPostArg{OutboxID: outboxID}
	err = c.Cli.Call(ctx, "chat.1.local.RetryPost", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) MarkAsReadLocal(ctx context.Context, __arg MarkAsReadLocalArg) (res MarkAsReadLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.markAsReadLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) FindConversationsLocal(ctx context.Context, __arg FindConversationsLocalArg) (res FindConversationsLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.findConversationsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) UpdateTyping(ctx context.Context, __arg UpdateTypingArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.local.updateTyping", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) JoinConversationLocal(ctx context.Context, __arg JoinConversationLocalArg) (res JoinLeaveConversationLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.joinConversationLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) JoinConversationByIDLocal(ctx context.Context, convID ConversationID) (res JoinLeaveConversationLocalRes, err error) {
	__arg := JoinConversationByIDLocalArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.local.joinConversationByIDLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) LeaveConversationLocal(ctx context.Context, convID ConversationID) (res JoinLeaveConversationLocalRes, err error) {
	__arg := LeaveConversationLocalArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.local.leaveConversationLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) DeleteConversationLocal(ctx context.Context, __arg DeleteConversationLocalArg) (res DeleteConversationLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.deleteConversationLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) GetTLFConversationsLocal(ctx context.Context, __arg GetTLFConversationsLocalArg) (res GetTLFConversationsLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getTLFConversationsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetAppNotificationSettingsLocal(ctx context.Context, __arg SetAppNotificationSettingsLocalArg) (res SetAppNotificationSettingsLocalRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.setAppNotificationSettingsLocal", []interface{}{__arg}, &res)
	return
}

func (c LocalClient) SetGlobalAppNotificationSettingsLocal(ctx context.Context, settings map[string]bool) (err error) {
	__arg := SetGlobalAppNotificationSettingsLocalArg{Settings: settings}
	err = c.Cli.Call(ctx, "chat.1.local.setGlobalAppNotificationSettingsLocal", []interface{}{__arg}, nil)
	return
}

func (c LocalClient) GetGlobalAppNotificationSettingsLocal(ctx context.Context) (res GlobalAppNotificationSettings, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.getGlobalAppNotificationSettingsLocal", []interface{}{GetGlobalAppNotificationSettingsLocalArg{}}, &res)
	return
}

func (c LocalClient) UnboxMobilePushNotification(ctx context.Context, __arg UnboxMobilePushNotificationArg) (res string, err error) {
	err = c.Cli.Call(ctx, "chat.1.local.unboxMobilePushNotification", []interface{}{__arg}, &res)
	return
}
