// @flow

// This file is auto-generated by client/protocol/Makefile.
import * as gregor1 from './flow-types-gregor'

import engine from '../../engine'
import {putOnChannelMap, createChannelMap, closeChannelMap} from '../../util/saga'
import type {Exact} from './more'
import type {ChannelConfig, ChannelMap} from './saga'
export type int = number
export type int64 = number
export type uint = number
export type uint64 = number
export type long = number
export type double = number
export type bytes = any
export type RPCError = {
  code: number,
  desc: string
}
export type WaitingHandlerType = (waiting: boolean, method: string, sessionID: number) => void

// $FlowIssue we're calling an internal method on engine that's there just for us
const engineRpcOutgoing = (...args) => engine()._rpcOutgoing(...args)

type requestCommon = {
  waitingHandler?: WaitingHandlerType,
  incomingCallMap?: incomingCallMapType,
}

type requestErrorCallback = {
  callback?: ?(err: ?any) => void
}

type RPCErrorHandler = (err: RPCError) => void

type CommonResponseHandler = {
  error: RPCErrorHandler,
  result: (...rest: Array<void>) => void,
}
function _channelMapRpcHelper(channelConfig: ChannelConfig<*>, partialRpcCall: (incomingCallMap: any, callback: Function) => void): ChannelMap<*> {
  const channelMap = createChannelMap(channelConfig)
  const incomingCallMap = Object.keys(channelMap).reduce((acc, k) => {
    acc[k] = (params, response) => {
      putOnChannelMap(channelMap, k, {params, response})
    }
    return acc
  }, {})
  const callback = (error, params) => {
    channelMap['finished'] && putOnChannelMap(channelMap, 'finished', {error, params})
    closeChannelMap(channelMap)
  }
  partialRpcCall(incomingCallMap, callback)
  return channelMap
}

export const CommonClientType = {
  none: 0,
  cli: 1,
  gui: 2,
  kbfs: 3,
}

export const CommonDeviceType = {
  desktop: 0,
  mobile: 1,
}

export const CommonLogLevel = {
  none: 0,
  debug: 1,
  info: 2,
  notice: 3,
  warn: 4,
  error: 5,
  critical: 6,
  fatal: 7,
}

export const CommonMerkleTreeID = {
  master: 0,
  kbfsPublic: 1,
  kbfsPrivate: 2,
}

export const ConfigForkType = {
  none: 0,
  auto: 1,
  watchdog: 2,
  launchd: 3,
}

export const ConstantsStatusCode = {
  scok: 0,
  scinputerror: 100,
  scloginrequired: 201,
  scbadsession: 202,
  scbadloginusernotfound: 203,
  scbadloginpassword: 204,
  scnotfound: 205,
  scthrottlecontrol: 210,
  scdeleted: 216,
  scgeneric: 218,
  scalreadyloggedin: 235,
  sccanceled: 237,
  scinputcanceled: 239,
  screloginrequired: 274,
  scresolutionfailed: 275,
  scprofilenotpublic: 276,
  scidentifyfailed: 277,
  sctrackingbroke: 278,
  scwrongcryptoformat: 279,
  scdecryptionerror: 280,
  scbademail: 472,
  scbadsignupusernametaken: 701,
  scbadinvitationcode: 707,
  scmissingresult: 801,
  sckeynotfound: 901,
  sckeyinuse: 907,
  sckeybadgen: 913,
  sckeynosecret: 914,
  sckeybaduids: 915,
  sckeynoactive: 916,
  sckeynosig: 917,
  sckeybadsig: 918,
  sckeybadeldest: 919,
  sckeynoeldest: 920,
  sckeyduplicateupdate: 921,
  scsibkeyalreadyexists: 922,
  scdecryptionkeynotfound: 924,
  sckeynopgpencryption: 927,
  sckeynonaclencryption: 928,
  sckeysyncedpgpnotfound: 929,
  sckeynomatchinggpg: 930,
  sckeyrevoked: 931,
  scbadtracksession: 1301,
  scdevicebadname: 1404,
  scdevicenameinuse: 1408,
  scdevicenotfound: 1409,
  scdevicemismatch: 1410,
  scdevicerequired: 1411,
  scdeviceprevprovisioned: 1413,
  scdevicenoprovision: 1414,
  scstreamexists: 1501,
  scstreamnotfound: 1502,
  scstreamwrongkind: 1503,
  scstreameof: 1504,
  scgenericapierror: 1600,
  scapinetworkerror: 1601,
  sctimeout: 1602,
  scprooferror: 1701,
  scidentificationexpired: 1702,
  scselfnotfound: 1703,
  scbadkexphrase: 1704,
  scnouidelegation: 1705,
  scnoui: 1706,
  scgpgunavailable: 1707,
  scinvalidversionerror: 1800,
  scoldversionerror: 1801,
  scinvalidlocationerror: 1802,
  scservicestatuserror: 1803,
  scinstallerror: 1804,
  scchatinternal: 2500,
  scchatratelimit: 2501,
  scchatconvexists: 2502,
  scchatunknowntlfid: 2503,
  scchatnotinconv: 2504,
  scchatbadmsg: 2505,
  scchatbroadcast: 2506,
  scchatalreadysuperseded: 2507,
  scchatalreadydeleted: 2508,
  scchattlffinalized: 2509,
}

export const CtlExitCode = {
  ok: 0,
  notok: 2,
  restart: 4,
}

export const GregorUIPushReason = {
  none: 0,
  reconnected: 1,
  newData: 2,
}

export const IdentifyCommonIdentifyReasonType = {
  none: 0,
  id: 1,
  track: 2,
  encrypt: 3,
  decrypt: 4,
  verify: 5,
  resource: 6,
}

export const IdentifyCommonTrackDiffType = {
  none: 0,
  error: 1,
  clash: 2,
  revoked: 3,
  upgraded: 4,
  new: 5,
  remoteFail: 6,
  remoteWorking: 7,
  remoteChanged: 8,
  newEldest: 9,
  noneViaTemporary: 10,
}

export const IdentifyCommonTrackStatus = {
  newOk: 1,
  newZeroProofs: 2,
  newFailProofs: 3,
  updateBrokenFailedProofs: 4,
  updateNewProofs: 5,
  updateOk: 6,
  updateBrokenRevoked: 7,
}

export const IdentifyUiCheckResultFreshness = {
  fresh: 0,
  aged: 1,
  rancid: 2,
}

export const IdentifyUiDismissReasonType = {
  none: 0,
  handledElsewhere: 1,
}

export const InstallInstallAction = {
  unknown: 0,
  none: 1,
  upgrade: 2,
  reinstall: 3,
  install: 4,
}

export const InstallInstallStatus = {
  unknown: 0,
  error: 1,
  notInstalled: 2,
  installed: 4,
}

export const KbfsCommonFSErrorType = {
  accessDenied: 0,
  userNotFound: 1,
  revokedDataDetected: 2,
  notLoggedIn: 3,
  timeout: 4,
  rekeyNeeded: 5,
  badFolder: 6,
  notImplemented: 7,
  oldVersion: 8,
  overQuota: 9,
  noSigChain: 10,
  tooManyFolders: 11,
}

export const KbfsCommonFSNotificationType = {
  encrypting: 0,
  decrypting: 1,
  signing: 2,
  verifying: 3,
  rekeying: 4,
  connection: 5,
  mdReadSuccess: 6,
  fileCreated: 7,
  fileModified: 8,
  fileDeleted: 9,
  fileRenamed: 10,
}

export const KbfsCommonFSStatusCode = {
  start: 0,
  finish: 1,
  error: 2,
}

export const PassphraseCommonPassphraseType = {
  none: 0,
  paperKey: 1,
  passPhrase: 2,
  verifyPassPhrase: 3,
}

export const PgpSignMode = {
  attached: 0,
  detached: 1,
  clear: 2,
}

export const ProcessFileType = {
  unknown: 0,
  directory: 1,
  file: 2,
}

export const ProveCommonProofState = {
  none: 0,
  ok: 1,
  tempFailure: 2,
  permFailure: 3,
  looking: 4,
  superseded: 5,
  posted: 6,
  revoked: 7,
  deleted: 8,
}

export const ProveCommonProofStatus = {
  none: 0,
  ok: 1,
  local: 2,
  found: 3,
  baseError: 100,
  hostUnreachable: 101,
  permissionDenied: 103,
  failedParse: 106,
  dnsError: 107,
  authFailed: 108,
  http429: 129,
  http500: 150,
  timeout: 160,
  internalError: 170,
  baseHardError: 200,
  notFound: 201,
  contentFailure: 202,
  badUsername: 203,
  badRemoteId: 204,
  textNotFound: 205,
  badArgs: 206,
  contentMissing: 207,
  titleNotFound: 208,
  serviceError: 209,
  torSkipped: 210,
  torIncompatible: 211,
  http300: 230,
  http400: 240,
  httpOther: 260,
  emptyJson: 270,
  deleted: 301,
  serviceDead: 302,
  badSignature: 303,
  badApiUrl: 304,
  unknownType: 305,
  noHint: 306,
  badHintText: 307,
  invalidPvl: 308,
}

export const ProveCommonProofType = {
  none: 0,
  keybase: 1,
  twitter: 2,
  github: 3,
  reddit: 4,
  coinbase: 5,
  hackernews: 6,
  facebook: 8,
  genericWebSite: 1000,
  dns: 1001,
  pgp: 1002,
  rooter: 100001,
}

export const ProveUiPromptOverwriteType = {
  social: 0,
  site: 1,
}

export const ProvisionUiChooseType = {
  existingDevice: 0,
  newDevice: 1,
}

export const ProvisionUiGPGMethod = {
  gpgNone: 0,
  gpgImport: 1,
  gpgSign: 2,
}

export const ProvisionUiProvisionMethod = {
  device: 0,
  paperKey: 1,
  passphrase: 2,
  gpgImport: 3,
  gpgSign: 4,
}

export const RekeyOutcome = {
  none: 0,
  fixed: 1,
  ignored: 2,
}

export const RekeyUIRekeyEventType = {
  none: 0,
  notLoggedIn: 1,
  apiError: 2,
  noProblems: 3,
  loadMeError: 4,
  currentDeviceCanRekey: 5,
  deviceLoadError: 6,
  harass: 7,
  noGregorMessages: 8,
}

export const SaltpackUiSaltpackSenderType = {
  notTracked: 0,
  unknown: 1,
  anonymous: 2,
  trackingBroke: 3,
  trackingOk: 4,
  self: 5,
}

export const TlfKeysTLFIdentifyBehavior = {
  defaultKbfs: 0,
  chatCli: 1,
  chatGui: 2,
}

export const UiPromptDefault = {
  none: 0,
  yes: 1,
  no: 2,
}

export function BTCRegisterBTCRpc (request: Exact<requestCommon & requestErrorCallback & {param: BTCRegisterBTCRpcParam}>) {
  engineRpcOutgoing({...request, method: 'BTC.registerBTC'})
}

export function BTCRegisterBTCRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: BTCRegisterBTCRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => BTCRegisterBTCRpc({...request, incomingCallMap, callback}))
}

export function BTCRegisterBTCRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: BTCRegisterBTCRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { BTCRegisterBTCRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function Kex2Provisionee2DidCounterSign2Rpc (request: Exact<requestCommon & requestErrorCallback & {param: Kex2Provisionee2DidCounterSign2RpcParam}>) {
  engineRpcOutgoing({...request, method: 'Kex2Provisionee2.didCounterSign2'})
}

export function Kex2Provisionee2DidCounterSign2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: Kex2Provisionee2DidCounterSign2RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => Kex2Provisionee2DidCounterSign2Rpc({...request, incomingCallMap, callback}))
}

export function Kex2Provisionee2DidCounterSign2RpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: Kex2Provisionee2DidCounterSign2RpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { Kex2Provisionee2DidCounterSign2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function Kex2Provisionee2Hello2Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2Provisionee2Hello2Result) => void} & {param: Kex2Provisionee2Hello2RpcParam}>) {
  engineRpcOutgoing({...request, method: 'Kex2Provisionee2.hello2'})
}

export function Kex2Provisionee2Hello2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2Provisionee2Hello2Result) => void} & {param: Kex2Provisionee2Hello2RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => Kex2Provisionee2Hello2Rpc({...request, incomingCallMap, callback}))
}

export function Kex2Provisionee2Hello2RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2Provisionee2Hello2Result) => void} & {param: Kex2Provisionee2Hello2RpcParam}>): Promise<Kex2Provisionee2Hello2Result> {
  return new Promise((resolve, reject) => { Kex2Provisionee2Hello2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function Kex2ProvisioneeDidCounterSignRpc (request: Exact<requestCommon & requestErrorCallback & {param: Kex2ProvisioneeDidCounterSignRpcParam}>) {
  engineRpcOutgoing({...request, method: 'Kex2Provisionee.didCounterSign'})
}

export function Kex2ProvisioneeDidCounterSignRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: Kex2ProvisioneeDidCounterSignRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => Kex2ProvisioneeDidCounterSignRpc({...request, incomingCallMap, callback}))
}

export function Kex2ProvisioneeDidCounterSignRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: Kex2ProvisioneeDidCounterSignRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { Kex2ProvisioneeDidCounterSignRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function Kex2ProvisioneeHelloRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2ProvisioneeHelloResult) => void} & {param: Kex2ProvisioneeHelloRpcParam}>) {
  engineRpcOutgoing({...request, method: 'Kex2Provisionee.hello'})
}

export function Kex2ProvisioneeHelloRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2ProvisioneeHelloResult) => void} & {param: Kex2ProvisioneeHelloRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => Kex2ProvisioneeHelloRpc({...request, incomingCallMap, callback}))
}

export function Kex2ProvisioneeHelloRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: Kex2ProvisioneeHelloResult) => void} & {param: Kex2ProvisioneeHelloRpcParam}>): Promise<Kex2ProvisioneeHelloResult> {
  return new Promise((resolve, reject) => { Kex2ProvisioneeHelloRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function Kex2ProvisionerKexStartRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'Kex2Provisioner.kexStart'})
}

export function Kex2ProvisionerKexStartRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => Kex2ProvisionerKexStartRpc({...request, incomingCallMap, callback}))
}

export function Kex2ProvisionerKexStartRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { Kex2ProvisionerKexStartRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ScanProofsScanProofsRpc (request: Exact<requestCommon & requestErrorCallback & {param: ScanProofsScanProofsRpcParam}>) {
  engineRpcOutgoing({...request, method: 'ScanProofs.scanProofs'})
}

export function ScanProofsScanProofsRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: ScanProofsScanProofsRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ScanProofsScanProofsRpc({...request, incomingCallMap, callback}))
}

export function ScanProofsScanProofsRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: ScanProofsScanProofsRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { ScanProofsScanProofsRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function SecretKeysGetSecretKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: SecretKeysGetSecretKeysResult) => void}>) {
  engineRpcOutgoing({...request, method: 'SecretKeys.getSecretKeys'})
}

export function SecretKeysGetSecretKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: SecretKeysGetSecretKeysResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => SecretKeysGetSecretKeysRpc({...request, incomingCallMap, callback}))
}

export function SecretKeysGetSecretKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: SecretKeysGetSecretKeysResult) => void}>): Promise<SecretKeysGetSecretKeysResult> {
  return new Promise((resolve, reject) => { SecretKeysGetSecretKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function accountEmailChangeRpc (request: Exact<requestCommon & requestErrorCallback & {param: accountEmailChangeRpcParam}>) {
  engineRpcOutgoing({...request, method: 'account.emailChange'})
}

export function accountEmailChangeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: accountEmailChangeRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => accountEmailChangeRpc({...request, incomingCallMap, callback}))
}

export function accountEmailChangeRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: accountEmailChangeRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { accountEmailChangeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function accountHasServerKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: accountHasServerKeysResult) => void}>) {
  engineRpcOutgoing({...request, method: 'account.hasServerKeys'})
}

export function accountHasServerKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: accountHasServerKeysResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => accountHasServerKeysRpc({...request, incomingCallMap, callback}))
}

export function accountHasServerKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: accountHasServerKeysResult) => void}>): Promise<accountHasServerKeysResult> {
  return new Promise((resolve, reject) => { accountHasServerKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function accountPassphraseChangeRpc (request: Exact<requestCommon & requestErrorCallback & {param: accountPassphraseChangeRpcParam}>) {
  engineRpcOutgoing({...request, method: 'account.passphraseChange'})
}

export function accountPassphraseChangeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: accountPassphraseChangeRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => accountPassphraseChangeRpc({...request, incomingCallMap, callback}))
}

export function accountPassphraseChangeRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: accountPassphraseChangeRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { accountPassphraseChangeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function accountPassphrasePromptRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: accountPassphrasePromptResult) => void} & {param: accountPassphrasePromptRpcParam}>) {
  engineRpcOutgoing({...request, method: 'account.passphrasePrompt'})
}

export function accountPassphrasePromptRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: accountPassphrasePromptResult) => void} & {param: accountPassphrasePromptRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => accountPassphrasePromptRpc({...request, incomingCallMap, callback}))
}

export function accountPassphrasePromptRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: accountPassphrasePromptResult) => void} & {param: accountPassphrasePromptRpcParam}>): Promise<accountPassphrasePromptResult> {
  return new Promise((resolve, reject) => { accountPassphrasePromptRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function apiserverGetRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverGetResult) => void} & {param: apiserverGetRpcParam}>) {
  engineRpcOutgoing({...request, method: 'apiserver.Get'})
}

export function apiserverGetRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverGetResult) => void} & {param: apiserverGetRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => apiserverGetRpc({...request, incomingCallMap, callback}))
}

export function apiserverGetRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverGetResult) => void} & {param: apiserverGetRpcParam}>): Promise<apiserverGetResult> {
  return new Promise((resolve, reject) => { apiserverGetRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function apiserverPostJSONRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostJSONResult) => void} & {param: apiserverPostJSONRpcParam}>) {
  engineRpcOutgoing({...request, method: 'apiserver.PostJSON'})
}

export function apiserverPostJSONRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostJSONResult) => void} & {param: apiserverPostJSONRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => apiserverPostJSONRpc({...request, incomingCallMap, callback}))
}

export function apiserverPostJSONRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostJSONResult) => void} & {param: apiserverPostJSONRpcParam}>): Promise<apiserverPostJSONResult> {
  return new Promise((resolve, reject) => { apiserverPostJSONRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function apiserverPostRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostResult) => void} & {param: apiserverPostRpcParam}>) {
  engineRpcOutgoing({...request, method: 'apiserver.Post'})
}

export function apiserverPostRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostResult) => void} & {param: apiserverPostRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => apiserverPostRpc({...request, incomingCallMap, callback}))
}

export function apiserverPostRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: apiserverPostResult) => void} & {param: apiserverPostRpcParam}>): Promise<apiserverPostResult> {
  return new Promise((resolve, reject) => { apiserverPostRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockAddReferenceRpc (request: Exact<requestCommon & requestErrorCallback & {param: blockAddReferenceRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.addReference'})
}

export function blockAddReferenceRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: blockAddReferenceRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockAddReferenceRpc({...request, incomingCallMap, callback}))
}

export function blockAddReferenceRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: blockAddReferenceRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { blockAddReferenceRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockArchiveReferenceRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceResult) => void} & {param: blockArchiveReferenceRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.archiveReference'})
}

export function blockArchiveReferenceRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceResult) => void} & {param: blockArchiveReferenceRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockArchiveReferenceRpc({...request, incomingCallMap, callback}))
}

export function blockArchiveReferenceRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceResult) => void} & {param: blockArchiveReferenceRpcParam}>): Promise<blockArchiveReferenceResult> {
  return new Promise((resolve, reject) => { blockArchiveReferenceRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockArchiveReferenceWithCountRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceWithCountResult) => void} & {param: blockArchiveReferenceWithCountRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.archiveReferenceWithCount'})
}

export function blockArchiveReferenceWithCountRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceWithCountResult) => void} & {param: blockArchiveReferenceWithCountRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockArchiveReferenceWithCountRpc({...request, incomingCallMap, callback}))
}

export function blockArchiveReferenceWithCountRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceWithCountResult) => void} & {param: blockArchiveReferenceWithCountRpcParam}>): Promise<blockArchiveReferenceWithCountResult> {
  return new Promise((resolve, reject) => { blockArchiveReferenceWithCountRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockAuthenticateSessionRpc (request: Exact<requestCommon & requestErrorCallback & {param: blockAuthenticateSessionRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.authenticateSession'})
}

export function blockAuthenticateSessionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: blockAuthenticateSessionRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockAuthenticateSessionRpc({...request, incomingCallMap, callback}))
}

export function blockAuthenticateSessionRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: blockAuthenticateSessionRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { blockAuthenticateSessionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockDelReferenceRpc (request: Exact<requestCommon & requestErrorCallback & {param: blockDelReferenceRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.delReference'})
}

export function blockDelReferenceRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: blockDelReferenceRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockDelReferenceRpc({...request, incomingCallMap, callback}))
}

export function blockDelReferenceRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: blockDelReferenceRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { blockDelReferenceRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockDelReferenceWithCountRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockDelReferenceWithCountResult) => void} & {param: blockDelReferenceWithCountRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.delReferenceWithCount'})
}

export function blockDelReferenceWithCountRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockDelReferenceWithCountResult) => void} & {param: blockDelReferenceWithCountRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockDelReferenceWithCountRpc({...request, incomingCallMap, callback}))
}

export function blockDelReferenceWithCountRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockDelReferenceWithCountResult) => void} & {param: blockDelReferenceWithCountRpcParam}>): Promise<blockDelReferenceWithCountResult> {
  return new Promise((resolve, reject) => { blockDelReferenceWithCountRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockGetBlockRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetBlockResult) => void} & {param: blockGetBlockRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.getBlock'})
}

export function blockGetBlockRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetBlockResult) => void} & {param: blockGetBlockRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockGetBlockRpc({...request, incomingCallMap, callback}))
}

export function blockGetBlockRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetBlockResult) => void} & {param: blockGetBlockRpcParam}>): Promise<blockGetBlockResult> {
  return new Promise((resolve, reject) => { blockGetBlockRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockGetSessionChallengeRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetSessionChallengeResult) => void}>) {
  engineRpcOutgoing({...request, method: 'block.getSessionChallenge'})
}

export function blockGetSessionChallengeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetSessionChallengeResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockGetSessionChallengeRpc({...request, incomingCallMap, callback}))
}

export function blockGetSessionChallengeRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetSessionChallengeResult) => void}>): Promise<blockGetSessionChallengeResult> {
  return new Promise((resolve, reject) => { blockGetSessionChallengeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockGetUserQuotaInfoRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetUserQuotaInfoResult) => void}>) {
  engineRpcOutgoing({...request, method: 'block.getUserQuotaInfo'})
}

export function blockGetUserQuotaInfoRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetUserQuotaInfoResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockGetUserQuotaInfoRpc({...request, incomingCallMap, callback}))
}

export function blockGetUserQuotaInfoRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: blockGetUserQuotaInfoResult) => void}>): Promise<blockGetUserQuotaInfoResult> {
  return new Promise((resolve, reject) => { blockGetUserQuotaInfoRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function blockPutBlockRpc (request: Exact<requestCommon & requestErrorCallback & {param: blockPutBlockRpcParam}>) {
  engineRpcOutgoing({...request, method: 'block.putBlock'})
}

export function blockPutBlockRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: blockPutBlockRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => blockPutBlockRpc({...request, incomingCallMap, callback}))
}

export function blockPutBlockRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: blockPutBlockRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { blockPutBlockRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configCheckAPIServerOutOfDateWarningRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void}>) {
  engineRpcOutgoing({...request, method: 'config.checkAPIServerOutOfDateWarning'})
}

export function configCheckAPIServerOutOfDateWarningRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configCheckAPIServerOutOfDateWarningRpc({...request, incomingCallMap, callback}))
}

export function configCheckAPIServerOutOfDateWarningRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void}>): Promise<configCheckAPIServerOutOfDateWarningResult> {
  return new Promise((resolve, reject) => { configCheckAPIServerOutOfDateWarningRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configClearValueRpc (request: Exact<requestCommon & requestErrorCallback & {param: configClearValueRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.clearValue'})
}

export function configClearValueRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: configClearValueRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configClearValueRpc({...request, incomingCallMap, callback}))
}

export function configClearValueRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: configClearValueRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { configClearValueRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configGetConfigRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: configGetConfigResult) => void}>) {
  engineRpcOutgoing({...request, method: 'config.getConfig'})
}

export function configGetConfigRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetConfigResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configGetConfigRpc({...request, incomingCallMap, callback}))
}

export function configGetConfigRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetConfigResult) => void}>): Promise<configGetConfigResult> {
  return new Promise((resolve, reject) => { configGetConfigRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configGetCurrentStatusRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: configGetCurrentStatusResult) => void}>) {
  engineRpcOutgoing({...request, method: 'config.getCurrentStatus'})
}

export function configGetCurrentStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetCurrentStatusResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configGetCurrentStatusRpc({...request, incomingCallMap, callback}))
}

export function configGetCurrentStatusRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetCurrentStatusResult) => void}>): Promise<configGetCurrentStatusResult> {
  return new Promise((resolve, reject) => { configGetCurrentStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configGetExtendedStatusRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: configGetExtendedStatusResult) => void}>) {
  engineRpcOutgoing({...request, method: 'config.getExtendedStatus'})
}

export function configGetExtendedStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetExtendedStatusResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configGetExtendedStatusRpc({...request, incomingCallMap, callback}))
}

export function configGetExtendedStatusRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetExtendedStatusResult) => void}>): Promise<configGetExtendedStatusResult> {
  return new Promise((resolve, reject) => { configGetExtendedStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configGetValueRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: configGetValueResult) => void} & {param: configGetValueRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.getValue'})
}

export function configGetValueRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetValueResult) => void} & {param: configGetValueRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configGetValueRpc({...request, incomingCallMap, callback}))
}

export function configGetValueRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: configGetValueResult) => void} & {param: configGetValueRpcParam}>): Promise<configGetValueResult> {
  return new Promise((resolve, reject) => { configGetValueRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configHelloIAmRpc (request: Exact<requestCommon & requestErrorCallback & {param: configHelloIAmRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.helloIAm'})
}

export function configHelloIAmRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: configHelloIAmRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configHelloIAmRpc({...request, incomingCallMap, callback}))
}

export function configHelloIAmRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: configHelloIAmRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { configHelloIAmRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configSetPathRpc (request: Exact<requestCommon & requestErrorCallback & {param: configSetPathRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.setPath'})
}

export function configSetPathRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: configSetPathRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configSetPathRpc({...request, incomingCallMap, callback}))
}

export function configSetPathRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: configSetPathRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { configSetPathRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configSetUserConfigRpc (request: Exact<requestCommon & requestErrorCallback & {param: configSetUserConfigRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.setUserConfig'})
}

export function configSetUserConfigRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: configSetUserConfigRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configSetUserConfigRpc({...request, incomingCallMap, callback}))
}

export function configSetUserConfigRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: configSetUserConfigRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { configSetUserConfigRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function configSetValueRpc (request: Exact<requestCommon & requestErrorCallback & {param: configSetValueRpcParam}>) {
  engineRpcOutgoing({...request, method: 'config.setValue'})
}

export function configSetValueRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: configSetValueRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => configSetValueRpc({...request, incomingCallMap, callback}))
}

export function configSetValueRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: configSetValueRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { configSetValueRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function cryptoSignED25519Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519Result) => void} & {param: cryptoSignED25519RpcParam}>) {
  engineRpcOutgoing({...request, method: 'crypto.signED25519'})
}

export function cryptoSignED25519RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519Result) => void} & {param: cryptoSignED25519RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => cryptoSignED25519Rpc({...request, incomingCallMap, callback}))
}

export function cryptoSignED25519RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519Result) => void} & {param: cryptoSignED25519RpcParam}>): Promise<cryptoSignED25519Result> {
  return new Promise((resolve, reject) => { cryptoSignED25519Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function cryptoSignToStringRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignToStringResult) => void} & {param: cryptoSignToStringRpcParam}>) {
  engineRpcOutgoing({...request, method: 'crypto.signToString'})
}

export function cryptoSignToStringRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignToStringResult) => void} & {param: cryptoSignToStringRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => cryptoSignToStringRpc({...request, incomingCallMap, callback}))
}

export function cryptoSignToStringRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoSignToStringResult) => void} & {param: cryptoSignToStringRpcParam}>): Promise<cryptoSignToStringResult> {
  return new Promise((resolve, reject) => { cryptoSignToStringRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function cryptoUnboxBytes32AnyRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32AnyResult) => void} & {param: cryptoUnboxBytes32AnyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'crypto.unboxBytes32Any'})
}

export function cryptoUnboxBytes32AnyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32AnyResult) => void} & {param: cryptoUnboxBytes32AnyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => cryptoUnboxBytes32AnyRpc({...request, incomingCallMap, callback}))
}

export function cryptoUnboxBytes32AnyRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32AnyResult) => void} & {param: cryptoUnboxBytes32AnyRpcParam}>): Promise<cryptoUnboxBytes32AnyResult> {
  return new Promise((resolve, reject) => { cryptoUnboxBytes32AnyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function cryptoUnboxBytes32Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32Result) => void} & {param: cryptoUnboxBytes32RpcParam}>) {
  engineRpcOutgoing({...request, method: 'crypto.unboxBytes32'})
}

export function cryptoUnboxBytes32RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32Result) => void} & {param: cryptoUnboxBytes32RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => cryptoUnboxBytes32Rpc({...request, incomingCallMap, callback}))
}

export function cryptoUnboxBytes32RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32Result) => void} & {param: cryptoUnboxBytes32RpcParam}>): Promise<cryptoUnboxBytes32Result> {
  return new Promise((resolve, reject) => { cryptoUnboxBytes32Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ctlAppExitRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'ctl.appExit'})
}

export function ctlAppExitRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ctlAppExitRpc({...request, incomingCallMap, callback}))
}

export function ctlAppExitRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { ctlAppExitRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ctlDbNukeRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'ctl.dbNuke'})
}

export function ctlDbNukeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ctlDbNukeRpc({...request, incomingCallMap, callback}))
}

export function ctlDbNukeRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { ctlDbNukeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ctlLogRotateRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'ctl.logRotate'})
}

export function ctlLogRotateRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ctlLogRotateRpc({...request, incomingCallMap, callback}))
}

export function ctlLogRotateRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { ctlLogRotateRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ctlReloadRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'ctl.reload'})
}

export function ctlReloadRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ctlReloadRpc({...request, incomingCallMap, callback}))
}

export function ctlReloadRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { ctlReloadRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function ctlStopRpc (request: Exact<requestCommon & requestErrorCallback & {param: ctlStopRpcParam}>) {
  engineRpcOutgoing({...request, method: 'ctl.stop'})
}

export function ctlStopRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: ctlStopRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => ctlStopRpc({...request, incomingCallMap, callback}))
}

export function ctlStopRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: ctlStopRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { ctlStopRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function debuggingFirstStepRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingFirstStepResult) => void} & {param: debuggingFirstStepRpcParam}>) {
  engineRpcOutgoing({...request, method: 'debugging.firstStep'})
}

export function debuggingFirstStepRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingFirstStepResult) => void} & {param: debuggingFirstStepRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => debuggingFirstStepRpc({...request, incomingCallMap, callback}))
}

export function debuggingFirstStepRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingFirstStepResult) => void} & {param: debuggingFirstStepRpcParam}>): Promise<debuggingFirstStepResult> {
  return new Promise((resolve, reject) => { debuggingFirstStepRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function debuggingIncrementRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingIncrementResult) => void} & {param: debuggingIncrementRpcParam}>) {
  engineRpcOutgoing({...request, method: 'debugging.increment'})
}

export function debuggingIncrementRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingIncrementResult) => void} & {param: debuggingIncrementRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => debuggingIncrementRpc({...request, incomingCallMap, callback}))
}

export function debuggingIncrementRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingIncrementResult) => void} & {param: debuggingIncrementRpcParam}>): Promise<debuggingIncrementResult> {
  return new Promise((resolve, reject) => { debuggingIncrementRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function debuggingSecondStepRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingSecondStepResult) => void} & {param: debuggingSecondStepRpcParam}>) {
  engineRpcOutgoing({...request, method: 'debugging.secondStep'})
}

export function debuggingSecondStepRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingSecondStepResult) => void} & {param: debuggingSecondStepRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => debuggingSecondStepRpc({...request, incomingCallMap, callback}))
}

export function debuggingSecondStepRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: debuggingSecondStepResult) => void} & {param: debuggingSecondStepRpcParam}>): Promise<debuggingSecondStepResult> {
  return new Promise((resolve, reject) => { debuggingSecondStepRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function delegateUiCtlRegisterGregorFirehoseRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'delegateUiCtl.registerGregorFirehose'})
}

export function delegateUiCtlRegisterGregorFirehoseRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => delegateUiCtlRegisterGregorFirehoseRpc({...request, incomingCallMap, callback}))
}

export function delegateUiCtlRegisterGregorFirehoseRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { delegateUiCtlRegisterGregorFirehoseRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function delegateUiCtlRegisterIdentifyUIRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'delegateUiCtl.registerIdentifyUI'})
}

export function delegateUiCtlRegisterIdentifyUIRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => delegateUiCtlRegisterIdentifyUIRpc({...request, incomingCallMap, callback}))
}

export function delegateUiCtlRegisterIdentifyUIRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { delegateUiCtlRegisterIdentifyUIRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function delegateUiCtlRegisterRekeyUIRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'delegateUiCtl.registerRekeyUI'})
}

export function delegateUiCtlRegisterRekeyUIRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => delegateUiCtlRegisterRekeyUIRpc({...request, incomingCallMap, callback}))
}

export function delegateUiCtlRegisterRekeyUIRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { delegateUiCtlRegisterRekeyUIRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function delegateUiCtlRegisterSecretUIRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'delegateUiCtl.registerSecretUI'})
}

export function delegateUiCtlRegisterSecretUIRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => delegateUiCtlRegisterSecretUIRpc({...request, incomingCallMap, callback}))
}

export function delegateUiCtlRegisterSecretUIRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { delegateUiCtlRegisterSecretUIRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function delegateUiCtlRegisterUpdateUIRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'delegateUiCtl.registerUpdateUI'})
}

export function delegateUiCtlRegisterUpdateUIRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => delegateUiCtlRegisterUpdateUIRpc({...request, incomingCallMap, callback}))
}

export function delegateUiCtlRegisterUpdateUIRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { delegateUiCtlRegisterUpdateUIRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function deviceCheckDeviceNameForUserRpc (request: Exact<requestCommon & requestErrorCallback & {param: deviceCheckDeviceNameForUserRpcParam}>) {
  engineRpcOutgoing({...request, method: 'device.checkDeviceNameForUser'})
}

export function deviceCheckDeviceNameForUserRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: deviceCheckDeviceNameForUserRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => deviceCheckDeviceNameForUserRpc({...request, incomingCallMap, callback}))
}

export function deviceCheckDeviceNameForUserRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: deviceCheckDeviceNameForUserRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { deviceCheckDeviceNameForUserRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function deviceCheckDeviceNameFormatRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: deviceCheckDeviceNameFormatResult) => void} & {param: deviceCheckDeviceNameFormatRpcParam}>) {
  engineRpcOutgoing({...request, method: 'device.checkDeviceNameFormat'})
}

export function deviceCheckDeviceNameFormatRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceCheckDeviceNameFormatResult) => void} & {param: deviceCheckDeviceNameFormatRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => deviceCheckDeviceNameFormatRpc({...request, incomingCallMap, callback}))
}

export function deviceCheckDeviceNameFormatRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceCheckDeviceNameFormatResult) => void} & {param: deviceCheckDeviceNameFormatRpcParam}>): Promise<deviceCheckDeviceNameFormatResult> {
  return new Promise((resolve, reject) => { deviceCheckDeviceNameFormatRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function deviceDeviceAddRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'device.deviceAdd'})
}

export function deviceDeviceAddRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => deviceDeviceAddRpc({...request, incomingCallMap, callback}))
}

export function deviceDeviceAddRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { deviceDeviceAddRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function deviceDeviceHistoryListRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceHistoryListResult) => void}>) {
  engineRpcOutgoing({...request, method: 'device.deviceHistoryList'})
}

export function deviceDeviceHistoryListRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceHistoryListResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => deviceDeviceHistoryListRpc({...request, incomingCallMap, callback}))
}

export function deviceDeviceHistoryListRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceHistoryListResult) => void}>): Promise<deviceDeviceHistoryListResult> {
  return new Promise((resolve, reject) => { deviceDeviceHistoryListRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function deviceDeviceListRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceListResult) => void}>) {
  engineRpcOutgoing({...request, method: 'device.deviceList'})
}

export function deviceDeviceListRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceListResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => deviceDeviceListRpc({...request, incomingCallMap, callback}))
}

export function deviceDeviceListRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: deviceDeviceListResult) => void}>): Promise<deviceDeviceListResult> {
  return new Promise((resolve, reject) => { deviceDeviceListRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function favoriteFavoriteAddRpc (request: Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteAddRpcParam}>) {
  engineRpcOutgoing({...request, method: 'favorite.favoriteAdd'})
}

export function favoriteFavoriteAddRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteAddRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => favoriteFavoriteAddRpc({...request, incomingCallMap, callback}))
}

export function favoriteFavoriteAddRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteAddRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { favoriteFavoriteAddRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function favoriteFavoriteIgnoreRpc (request: Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteIgnoreRpcParam}>) {
  engineRpcOutgoing({...request, method: 'favorite.favoriteIgnore'})
}

export function favoriteFavoriteIgnoreRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteIgnoreRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => favoriteFavoriteIgnoreRpc({...request, incomingCallMap, callback}))
}

export function favoriteFavoriteIgnoreRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: favoriteFavoriteIgnoreRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { favoriteFavoriteIgnoreRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function favoriteGetFavoritesRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: favoriteGetFavoritesResult) => void}>) {
  engineRpcOutgoing({...request, method: 'favorite.getFavorites'})
}

export function favoriteGetFavoritesRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: favoriteGetFavoritesResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => favoriteGetFavoritesRpc({...request, incomingCallMap, callback}))
}

export function favoriteGetFavoritesRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: favoriteGetFavoritesResult) => void}>): Promise<favoriteGetFavoritesResult> {
  return new Promise((resolve, reject) => { favoriteGetFavoritesRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function fsListRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: fsListResult) => void} & {param: fsListRpcParam}>) {
  engineRpcOutgoing({...request, method: 'fs.List'})
}

export function fsListRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: fsListResult) => void} & {param: fsListRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => fsListRpc({...request, incomingCallMap, callback}))
}

export function fsListRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: fsListResult) => void} & {param: fsListRpcParam}>): Promise<fsListResult> {
  return new Promise((resolve, reject) => { fsListRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function gregorGetStateRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: gregorGetStateResult) => void}>) {
  engineRpcOutgoing({...request, method: 'gregor.getState'})
}

export function gregorGetStateRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: gregorGetStateResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => gregorGetStateRpc({...request, incomingCallMap, callback}))
}

export function gregorGetStateRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: gregorGetStateResult) => void}>): Promise<gregorGetStateResult> {
  return new Promise((resolve, reject) => { gregorGetStateRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function identifyIdentify2Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentify2Result) => void} & {param: identifyIdentify2RpcParam}>) {
  engineRpcOutgoing({...request, method: 'identify.identify2'})
}

export function identifyIdentify2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentify2Result) => void} & {param: identifyIdentify2RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => identifyIdentify2Rpc({...request, incomingCallMap, callback}))
}

export function identifyIdentify2RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentify2Result) => void} & {param: identifyIdentify2RpcParam}>): Promise<identifyIdentify2Result> {
  return new Promise((resolve, reject) => { identifyIdentify2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function identifyIdentifyRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentifyResult) => void} & {param: identifyIdentifyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'identify.identify'})
}

export function identifyIdentifyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentifyResult) => void} & {param: identifyIdentifyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => identifyIdentifyRpc({...request, incomingCallMap, callback}))
}

export function identifyIdentifyRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyIdentifyResult) => void} & {param: identifyIdentifyRpcParam}>): Promise<identifyIdentifyResult> {
  return new Promise((resolve, reject) => { identifyIdentifyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function identifyResolve2Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolve2Result) => void} & {param: identifyResolve2RpcParam}>) {
  engineRpcOutgoing({...request, method: 'identify.Resolve2'})
}

export function identifyResolve2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolve2Result) => void} & {param: identifyResolve2RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => identifyResolve2Rpc({...request, incomingCallMap, callback}))
}

export function identifyResolve2RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolve2Result) => void} & {param: identifyResolve2RpcParam}>): Promise<identifyResolve2Result> {
  return new Promise((resolve, reject) => { identifyResolve2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function identifyResolveRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolveResult) => void} & {param: identifyResolveRpcParam}>) {
  engineRpcOutgoing({...request, method: 'identify.Resolve'})
}

export function identifyResolveRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolveResult) => void} & {param: identifyResolveRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => identifyResolveRpc({...request, incomingCallMap, callback}))
}

export function identifyResolveRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: identifyResolveResult) => void} & {param: identifyResolveRpcParam}>): Promise<identifyResolveResult> {
  return new Promise((resolve, reject) => { identifyResolveRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function kbfsFSEditListRpc (request: Exact<requestCommon & requestErrorCallback & {param: kbfsFSEditListRpcParam}>) {
  engineRpcOutgoing({...request, method: 'kbfs.FSEditList'})
}

export function kbfsFSEditListRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSEditListRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => kbfsFSEditListRpc({...request, incomingCallMap, callback}))
}

export function kbfsFSEditListRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSEditListRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { kbfsFSEditListRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function kbfsFSEventRpc (request: Exact<requestCommon & requestErrorCallback & {param: kbfsFSEventRpcParam}>) {
  engineRpcOutgoing({...request, method: 'kbfs.FSEvent'})
}

export function kbfsFSEventRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSEventRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => kbfsFSEventRpc({...request, incomingCallMap, callback}))
}

export function kbfsFSEventRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSEventRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { kbfsFSEventRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function kbfsFSSyncEventRpc (request: Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncEventRpcParam}>) {
  engineRpcOutgoing({...request, method: 'kbfs.FSSyncEvent'})
}

export function kbfsFSSyncEventRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncEventRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => kbfsFSSyncEventRpc({...request, incomingCallMap, callback}))
}

export function kbfsFSSyncEventRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncEventRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { kbfsFSSyncEventRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function kbfsFSSyncStatusRpc (request: Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncStatusRpcParam}>) {
  engineRpcOutgoing({...request, method: 'kbfs.FSSyncStatus'})
}

export function kbfsFSSyncStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncStatusRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => kbfsFSSyncStatusRpc({...request, incomingCallMap, callback}))
}

export function kbfsFSSyncStatusRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: kbfsFSSyncStatusRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { kbfsFSSyncStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function logRegisterLoggerRpc (request: Exact<requestCommon & requestErrorCallback & {param: logRegisterLoggerRpcParam}>) {
  engineRpcOutgoing({...request, method: 'log.registerLogger'})
}

export function logRegisterLoggerRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: logRegisterLoggerRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => logRegisterLoggerRpc({...request, incomingCallMap, callback}))
}

export function logRegisterLoggerRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: logRegisterLoggerRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { logRegisterLoggerRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginAccountDeleteRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'login.accountDelete'})
}

export function loginAccountDeleteRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginAccountDeleteRpc({...request, incomingCallMap, callback}))
}

export function loginAccountDeleteRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { loginAccountDeleteRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginClearStoredSecretRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginClearStoredSecretRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.clearStoredSecret'})
}

export function loginClearStoredSecretRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginClearStoredSecretRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginClearStoredSecretRpc({...request, incomingCallMap, callback}))
}

export function loginClearStoredSecretRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginClearStoredSecretRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginClearStoredSecretRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginDeprovisionRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginDeprovisionRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.deprovision'})
}

export function loginDeprovisionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginDeprovisionRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginDeprovisionRpc({...request, incomingCallMap, callback}))
}

export function loginDeprovisionRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginDeprovisionRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginDeprovisionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginGetConfiguredAccountsRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: loginGetConfiguredAccountsResult) => void}>) {
  engineRpcOutgoing({...request, method: 'login.getConfiguredAccounts'})
}

export function loginGetConfiguredAccountsRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: loginGetConfiguredAccountsResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginGetConfiguredAccountsRpc({...request, incomingCallMap, callback}))
}

export function loginGetConfiguredAccountsRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: loginGetConfiguredAccountsResult) => void}>): Promise<loginGetConfiguredAccountsResult> {
  return new Promise((resolve, reject) => { loginGetConfiguredAccountsRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginLoginRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginLoginRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.login'})
}

export function loginLoginRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginLoginRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginLoginRpc({...request, incomingCallMap, callback}))
}

export function loginLoginRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginLoginRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginLoginRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginLogoutRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'login.logout'})
}

export function loginLogoutRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginLogoutRpc({...request, incomingCallMap, callback}))
}

export function loginLogoutRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { loginLogoutRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginPaperKeyRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'login.paperKey'})
}

export function loginPaperKeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginPaperKeyRpc({...request, incomingCallMap, callback}))
}

export function loginPaperKeyRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { loginPaperKeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginPaperKeySubmitRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginPaperKeySubmitRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.paperKeySubmit'})
}

export function loginPaperKeySubmitRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginPaperKeySubmitRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginPaperKeySubmitRpc({...request, incomingCallMap, callback}))
}

export function loginPaperKeySubmitRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginPaperKeySubmitRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginPaperKeySubmitRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginPgpProvisionRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginPgpProvisionRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.pgpProvision'})
}

export function loginPgpProvisionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginPgpProvisionRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginPgpProvisionRpc({...request, incomingCallMap, callback}))
}

export function loginPgpProvisionRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginPgpProvisionRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginPgpProvisionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginRecoverAccountFromEmailAddressRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginRecoverAccountFromEmailAddressRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.recoverAccountFromEmailAddress'})
}

export function loginRecoverAccountFromEmailAddressRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginRecoverAccountFromEmailAddressRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginRecoverAccountFromEmailAddressRpc({...request, incomingCallMap, callback}))
}

export function loginRecoverAccountFromEmailAddressRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginRecoverAccountFromEmailAddressRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginRecoverAccountFromEmailAddressRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginUnlockRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'login.unlock'})
}

export function loginUnlockRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginUnlockRpc({...request, incomingCallMap, callback}))
}

export function loginUnlockRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { loginUnlockRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function loginUnlockWithPassphraseRpc (request: Exact<requestCommon & requestErrorCallback & {param: loginUnlockWithPassphraseRpcParam}>) {
  engineRpcOutgoing({...request, method: 'login.unlockWithPassphrase'})
}

export function loginUnlockWithPassphraseRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: loginUnlockWithPassphraseRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => loginUnlockWithPassphraseRpc({...request, incomingCallMap, callback}))
}

export function loginUnlockWithPassphraseRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: loginUnlockWithPassphraseRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { loginUnlockWithPassphraseRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataAuthenticateRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataAuthenticateResult) => void} & {param: metadataAuthenticateRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.authenticate'})
}

export function metadataAuthenticateRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataAuthenticateResult) => void} & {param: metadataAuthenticateRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataAuthenticateRpc({...request, incomingCallMap, callback}))
}

export function metadataAuthenticateRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataAuthenticateResult) => void} & {param: metadataAuthenticateRpcParam}>): Promise<metadataAuthenticateResult> {
  return new Promise((resolve, reject) => { metadataAuthenticateRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataDeleteKeyRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataDeleteKeyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.deleteKey'})
}

export function metadataDeleteKeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataDeleteKeyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataDeleteKeyRpc({...request, incomingCallMap, callback}))
}

export function metadataDeleteKeyRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataDeleteKeyRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataDeleteKeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetChallengeRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetChallengeResult) => void}>) {
  engineRpcOutgoing({...request, method: 'metadata.getChallenge'})
}

export function metadataGetChallengeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetChallengeResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetChallengeRpc({...request, incomingCallMap, callback}))
}

export function metadataGetChallengeRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetChallengeResult) => void}>): Promise<metadataGetChallengeResult> {
  return new Promise((resolve, reject) => { metadataGetChallengeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetFolderHandleRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetFolderHandleResult) => void} & {param: metadataGetFolderHandleRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getFolderHandle'})
}

export function metadataGetFolderHandleRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetFolderHandleResult) => void} & {param: metadataGetFolderHandleRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetFolderHandleRpc({...request, incomingCallMap, callback}))
}

export function metadataGetFolderHandleRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetFolderHandleResult) => void} & {param: metadataGetFolderHandleRpcParam}>): Promise<metadataGetFolderHandleResult> {
  return new Promise((resolve, reject) => { metadataGetFolderHandleRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetFoldersForRekeyRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataGetFoldersForRekeyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getFoldersForRekey'})
}

export function metadataGetFoldersForRekeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataGetFoldersForRekeyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetFoldersForRekeyRpc({...request, incomingCallMap, callback}))
}

export function metadataGetFoldersForRekeyRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataGetFoldersForRekeyRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataGetFoldersForRekeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetKeyBundlesRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyBundlesResult) => void} & {param: metadataGetKeyBundlesRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getKeyBundles'})
}

export function metadataGetKeyBundlesRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyBundlesResult) => void} & {param: metadataGetKeyBundlesRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetKeyBundlesRpc({...request, incomingCallMap, callback}))
}

export function metadataGetKeyBundlesRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyBundlesResult) => void} & {param: metadataGetKeyBundlesRpcParam}>): Promise<metadataGetKeyBundlesResult> {
  return new Promise((resolve, reject) => { metadataGetKeyBundlesRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetKeyRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyResult) => void} & {param: metadataGetKeyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getKey'})
}

export function metadataGetKeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyResult) => void} & {param: metadataGetKeyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetKeyRpc({...request, incomingCallMap, callback}))
}

export function metadataGetKeyRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyResult) => void} & {param: metadataGetKeyRpcParam}>): Promise<metadataGetKeyResult> {
  return new Promise((resolve, reject) => { metadataGetKeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetLatestFolderHandleRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetLatestFolderHandleResult) => void} & {param: metadataGetLatestFolderHandleRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getLatestFolderHandle'})
}

export function metadataGetLatestFolderHandleRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetLatestFolderHandleResult) => void} & {param: metadataGetLatestFolderHandleRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetLatestFolderHandleRpc({...request, incomingCallMap, callback}))
}

export function metadataGetLatestFolderHandleRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetLatestFolderHandleResult) => void} & {param: metadataGetLatestFolderHandleRpcParam}>): Promise<metadataGetLatestFolderHandleResult> {
  return new Promise((resolve, reject) => { metadataGetLatestFolderHandleRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetMerkleNodeRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleNodeResult) => void} & {param: metadataGetMerkleNodeRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getMerkleNode'})
}

export function metadataGetMerkleNodeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleNodeResult) => void} & {param: metadataGetMerkleNodeRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetMerkleNodeRpc({...request, incomingCallMap, callback}))
}

export function metadataGetMerkleNodeRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleNodeResult) => void} & {param: metadataGetMerkleNodeRpcParam}>): Promise<metadataGetMerkleNodeResult> {
  return new Promise((resolve, reject) => { metadataGetMerkleNodeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetMerkleRootLatestRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootLatestResult) => void} & {param: metadataGetMerkleRootLatestRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getMerkleRootLatest'})
}

export function metadataGetMerkleRootLatestRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootLatestResult) => void} & {param: metadataGetMerkleRootLatestRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetMerkleRootLatestRpc({...request, incomingCallMap, callback}))
}

export function metadataGetMerkleRootLatestRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootLatestResult) => void} & {param: metadataGetMerkleRootLatestRpcParam}>): Promise<metadataGetMerkleRootLatestResult> {
  return new Promise((resolve, reject) => { metadataGetMerkleRootLatestRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetMerkleRootRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootResult) => void} & {param: metadataGetMerkleRootRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getMerkleRoot'})
}

export function metadataGetMerkleRootRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootResult) => void} & {param: metadataGetMerkleRootRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetMerkleRootRpc({...request, incomingCallMap, callback}))
}

export function metadataGetMerkleRootRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootResult) => void} & {param: metadataGetMerkleRootRpcParam}>): Promise<metadataGetMerkleRootResult> {
  return new Promise((resolve, reject) => { metadataGetMerkleRootRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetMerkleRootSinceRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootSinceResult) => void} & {param: metadataGetMerkleRootSinceRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getMerkleRootSince'})
}

export function metadataGetMerkleRootSinceRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootSinceResult) => void} & {param: metadataGetMerkleRootSinceRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetMerkleRootSinceRpc({...request, incomingCallMap, callback}))
}

export function metadataGetMerkleRootSinceRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootSinceResult) => void} & {param: metadataGetMerkleRootSinceRpcParam}>): Promise<metadataGetMerkleRootSinceResult> {
  return new Promise((resolve, reject) => { metadataGetMerkleRootSinceRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataGetMetadataRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMetadataResult) => void} & {param: metadataGetMetadataRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.getMetadata'})
}

export function metadataGetMetadataRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMetadataResult) => void} & {param: metadataGetMetadataRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataGetMetadataRpc({...request, incomingCallMap, callback}))
}

export function metadataGetMetadataRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataGetMetadataResult) => void} & {param: metadataGetMetadataRpcParam}>): Promise<metadataGetMetadataResult> {
  return new Promise((resolve, reject) => { metadataGetMetadataRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataPing2Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataPing2Result) => void}>) {
  engineRpcOutgoing({...request, method: 'metadata.ping2'})
}

export function metadataPing2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataPing2Result) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataPing2Rpc({...request, incomingCallMap, callback}))
}

export function metadataPing2RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataPing2Result) => void}>): Promise<metadataPing2Result> {
  return new Promise((resolve, reject) => { metadataPing2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataPingRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'metadata.ping'})
}

export function metadataPingRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataPingRpc({...request, incomingCallMap, callback}))
}

export function metadataPingRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { metadataPingRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataPruneBranchRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataPruneBranchRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.pruneBranch'})
}

export function metadataPruneBranchRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataPruneBranchRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataPruneBranchRpc({...request, incomingCallMap, callback}))
}

export function metadataPruneBranchRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataPruneBranchRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataPruneBranchRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataPutKeysRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataPutKeysRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.putKeys'})
}

export function metadataPutKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataPutKeysRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataPutKeysRpc({...request, incomingCallMap, callback}))
}

export function metadataPutKeysRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataPutKeysRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataPutKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataPutMetadataRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataPutMetadataRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.putMetadata'})
}

export function metadataPutMetadataRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataPutMetadataRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataPutMetadataRpc({...request, incomingCallMap, callback}))
}

export function metadataPutMetadataRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataPutMetadataRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataPutMetadataRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataRegisterForUpdatesRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataRegisterForUpdatesRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.registerForUpdates'})
}

export function metadataRegisterForUpdatesRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataRegisterForUpdatesRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataRegisterForUpdatesRpc({...request, incomingCallMap, callback}))
}

export function metadataRegisterForUpdatesRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataRegisterForUpdatesRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataRegisterForUpdatesRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataTruncateLockRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateLockResult) => void} & {param: metadataTruncateLockRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.truncateLock'})
}

export function metadataTruncateLockRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateLockResult) => void} & {param: metadataTruncateLockRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataTruncateLockRpc({...request, incomingCallMap, callback}))
}

export function metadataTruncateLockRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateLockResult) => void} & {param: metadataTruncateLockRpcParam}>): Promise<metadataTruncateLockResult> {
  return new Promise((resolve, reject) => { metadataTruncateLockRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataTruncateUnlockRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateUnlockResult) => void} & {param: metadataTruncateUnlockRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadata.truncateUnlock'})
}

export function metadataTruncateUnlockRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateUnlockResult) => void} & {param: metadataTruncateUnlockRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataTruncateUnlockRpc({...request, incomingCallMap, callback}))
}

export function metadataTruncateUnlockRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: metadataTruncateUnlockResult) => void} & {param: metadataTruncateUnlockRpcParam}>): Promise<metadataTruncateUnlockResult> {
  return new Promise((resolve, reject) => { metadataTruncateUnlockRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataUpdateFolderNeedsRekeyRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataUpdateFolderNeedsRekeyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadataUpdate.folderNeedsRekey'})
}

export function metadataUpdateFolderNeedsRekeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataUpdateFolderNeedsRekeyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataUpdateFolderNeedsRekeyRpc({...request, incomingCallMap, callback}))
}

export function metadataUpdateFolderNeedsRekeyRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataUpdateFolderNeedsRekeyRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataUpdateFolderNeedsRekeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function metadataUpdateMetadataUpdateRpc (request: Exact<requestCommon & requestErrorCallback & {param: metadataUpdateMetadataUpdateRpcParam}>) {
  engineRpcOutgoing({...request, method: 'metadataUpdate.metadataUpdate'})
}

export function metadataUpdateMetadataUpdateRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: metadataUpdateMetadataUpdateRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => metadataUpdateMetadataUpdateRpc({...request, incomingCallMap, callback}))
}

export function metadataUpdateMetadataUpdateRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: metadataUpdateMetadataUpdateRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { metadataUpdateMetadataUpdateRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function notifyCtlSetNotificationsRpc (request: Exact<requestCommon & requestErrorCallback & {param: notifyCtlSetNotificationsRpcParam}>) {
  engineRpcOutgoing({...request, method: 'notifyCtl.setNotifications'})
}

export function notifyCtlSetNotificationsRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: notifyCtlSetNotificationsRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => notifyCtlSetNotificationsRpc({...request, incomingCallMap, callback}))
}

export function notifyCtlSetNotificationsRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: notifyCtlSetNotificationsRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { notifyCtlSetNotificationsRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function paperprovisionPaperProvisionRpc (request: Exact<requestCommon & requestErrorCallback & {param: paperprovisionPaperProvisionRpcParam}>) {
  engineRpcOutgoing({...request, method: 'paperprovision.paperProvision'})
}

export function paperprovisionPaperProvisionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: paperprovisionPaperProvisionRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => paperprovisionPaperProvisionRpc({...request, incomingCallMap, callback}))
}

export function paperprovisionPaperProvisionRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: paperprovisionPaperProvisionRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { paperprovisionPaperProvisionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpDecryptRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpDecryptResult) => void} & {param: pgpPgpDecryptRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpDecrypt'})
}

export function pgpPgpDecryptRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpDecryptResult) => void} & {param: pgpPgpDecryptRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpDecryptRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpDecryptRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpDecryptResult) => void} & {param: pgpPgpDecryptRpcParam}>): Promise<pgpPgpDecryptResult> {
  return new Promise((resolve, reject) => { pgpPgpDecryptRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpDeletePrimaryRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpDeletePrimary'})
}

export function pgpPgpDeletePrimaryRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpDeletePrimaryRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpDeletePrimaryRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpDeletePrimaryRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpEncryptRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpEncryptRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpEncrypt'})
}

export function pgpPgpEncryptRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpEncryptRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpEncryptRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpEncryptRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpEncryptRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpEncryptRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpExportByFingerprintRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByFingerprintResult) => void} & {param: pgpPgpExportByFingerprintRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpExportByFingerprint'})
}

export function pgpPgpExportByFingerprintRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByFingerprintResult) => void} & {param: pgpPgpExportByFingerprintRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpExportByFingerprintRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpExportByFingerprintRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByFingerprintResult) => void} & {param: pgpPgpExportByFingerprintRpcParam}>): Promise<pgpPgpExportByFingerprintResult> {
  return new Promise((resolve, reject) => { pgpPgpExportByFingerprintRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpExportByKIDRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByKIDResult) => void} & {param: pgpPgpExportByKIDRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpExportByKID'})
}

export function pgpPgpExportByKIDRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByKIDResult) => void} & {param: pgpPgpExportByKIDRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpExportByKIDRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpExportByKIDRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByKIDResult) => void} & {param: pgpPgpExportByKIDRpcParam}>): Promise<pgpPgpExportByKIDResult> {
  return new Promise((resolve, reject) => { pgpPgpExportByKIDRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpExportRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportResult) => void} & {param: pgpPgpExportRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpExport'})
}

export function pgpPgpExportRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportResult) => void} & {param: pgpPgpExportRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpExportRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpExportRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportResult) => void} & {param: pgpPgpExportRpcParam}>): Promise<pgpPgpExportResult> {
  return new Promise((resolve, reject) => { pgpPgpExportRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpImportRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpImportRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpImport'})
}

export function pgpPgpImportRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpImportRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpImportRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpImportRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpImportRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpImportRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpKeyGenDefaultRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenDefaultRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpKeyGenDefault'})
}

export function pgpPgpKeyGenDefaultRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenDefaultRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpKeyGenDefaultRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpKeyGenDefaultRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenDefaultRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpKeyGenDefaultRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpKeyGenRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpKeyGen'})
}

export function pgpPgpKeyGenRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpKeyGenRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpKeyGenRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpKeyGenRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpKeyGenRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpPullRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpPullRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpPull'})
}

export function pgpPgpPullRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpPullRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpPullRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpPullRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpPullRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpPullRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpPurgeRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpPurgeResult) => void} & {param: pgpPgpPurgeRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpPurge'})
}

export function pgpPgpPurgeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpPurgeResult) => void} & {param: pgpPgpPurgeRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpPurgeRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpPurgeRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpPurgeResult) => void} & {param: pgpPgpPurgeRpcParam}>): Promise<pgpPgpPurgeResult> {
  return new Promise((resolve, reject) => { pgpPgpPurgeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpSelectRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpSelectRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpSelect'})
}

export function pgpPgpSelectRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpSelectRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpSelectRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpSelectRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpSelectRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpSelectRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpSignRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpSignRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpSign'})
}

export function pgpPgpSignRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpSignRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpSignRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpSignRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpSignRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpSignRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpStorageDismissRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpStorageDismiss'})
}

export function pgpPgpStorageDismissRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpStorageDismissRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpStorageDismissRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpStorageDismissRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpUpdateRpc (request: Exact<requestCommon & requestErrorCallback & {param: pgpPgpUpdateRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpUpdate'})
}

export function pgpPgpUpdateRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpUpdateRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpUpdateRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpUpdateRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: pgpPgpUpdateRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { pgpPgpUpdateRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function pgpPgpVerifyRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpVerifyResult) => void} & {param: pgpPgpVerifyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'pgp.pgpVerify'})
}

export function pgpPgpVerifyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpVerifyResult) => void} & {param: pgpPgpVerifyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => pgpPgpVerifyRpc({...request, incomingCallMap, callback}))
}

export function pgpPgpVerifyRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: pgpPgpVerifyResult) => void} & {param: pgpPgpVerifyRpcParam}>): Promise<pgpPgpVerifyResult> {
  return new Promise((resolve, reject) => { pgpPgpVerifyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function proveCheckProofRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: proveCheckProofResult) => void} & {param: proveCheckProofRpcParam}>) {
  engineRpcOutgoing({...request, method: 'prove.checkProof'})
}

export function proveCheckProofRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: proveCheckProofResult) => void} & {param: proveCheckProofRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => proveCheckProofRpc({...request, incomingCallMap, callback}))
}

export function proveCheckProofRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: proveCheckProofResult) => void} & {param: proveCheckProofRpcParam}>): Promise<proveCheckProofResult> {
  return new Promise((resolve, reject) => { proveCheckProofRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function proveStartProofRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: proveStartProofResult) => void} & {param: proveStartProofRpcParam}>) {
  engineRpcOutgoing({...request, method: 'prove.startProof'})
}

export function proveStartProofRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: proveStartProofResult) => void} & {param: proveStartProofRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => proveStartProofRpc({...request, incomingCallMap, callback}))
}

export function proveStartProofRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: proveStartProofResult) => void} & {param: proveStartProofRpcParam}>): Promise<proveStartProofResult> {
  return new Promise((resolve, reject) => { proveStartProofRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function quotaVerifySessionRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: quotaVerifySessionResult) => void} & {param: quotaVerifySessionRpcParam}>) {
  engineRpcOutgoing({...request, method: 'quota.verifySession'})
}

export function quotaVerifySessionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: quotaVerifySessionResult) => void} & {param: quotaVerifySessionRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => quotaVerifySessionRpc({...request, incomingCallMap, callback}))
}

export function quotaVerifySessionRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: quotaVerifySessionResult) => void} & {param: quotaVerifySessionRpcParam}>): Promise<quotaVerifySessionResult> {
  return new Promise((resolve, reject) => { quotaVerifySessionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyDebugShowRekeyStatusRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'rekey.debugShowRekeyStatus'})
}

export function rekeyDebugShowRekeyStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyDebugShowRekeyStatusRpc({...request, incomingCallMap, callback}))
}

export function rekeyDebugShowRekeyStatusRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { rekeyDebugShowRekeyStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyGetPendingRekeyStatusRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetPendingRekeyStatusResult) => void}>) {
  engineRpcOutgoing({...request, method: 'rekey.getPendingRekeyStatus'})
}

export function rekeyGetPendingRekeyStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetPendingRekeyStatusResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyGetPendingRekeyStatusRpc({...request, incomingCallMap, callback}))
}

export function rekeyGetPendingRekeyStatusRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetPendingRekeyStatusResult) => void}>): Promise<rekeyGetPendingRekeyStatusResult> {
  return new Promise((resolve, reject) => { rekeyGetPendingRekeyStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyGetRevokeWarningRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetRevokeWarningResult) => void} & {param: rekeyGetRevokeWarningRpcParam}>) {
  engineRpcOutgoing({...request, method: 'rekey.getRevokeWarning'})
}

export function rekeyGetRevokeWarningRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetRevokeWarningResult) => void} & {param: rekeyGetRevokeWarningRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyGetRevokeWarningRpc({...request, incomingCallMap, callback}))
}

export function rekeyGetRevokeWarningRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyGetRevokeWarningResult) => void} & {param: rekeyGetRevokeWarningRpcParam}>): Promise<rekeyGetRevokeWarningResult> {
  return new Promise((resolve, reject) => { rekeyGetRevokeWarningRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyRekeyStatusFinishRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyRekeyStatusFinishResult) => void}>) {
  engineRpcOutgoing({...request, method: 'rekey.rekeyStatusFinish'})
}

export function rekeyRekeyStatusFinishRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyRekeyStatusFinishResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyRekeyStatusFinishRpc({...request, incomingCallMap, callback}))
}

export function rekeyRekeyStatusFinishRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: rekeyRekeyStatusFinishResult) => void}>): Promise<rekeyRekeyStatusFinishResult> {
  return new Promise((resolve, reject) => { rekeyRekeyStatusFinishRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyRekeySyncRpc (request: Exact<requestCommon & requestErrorCallback & {param: rekeyRekeySyncRpcParam}>) {
  engineRpcOutgoing({...request, method: 'rekey.rekeySync'})
}

export function rekeyRekeySyncRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: rekeyRekeySyncRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyRekeySyncRpc({...request, incomingCallMap, callback}))
}

export function rekeyRekeySyncRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: rekeyRekeySyncRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { rekeyRekeySyncRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function rekeyShowPendingRekeyStatusRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'rekey.showPendingRekeyStatus'})
}

export function rekeyShowPendingRekeyStatusRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => rekeyShowPendingRekeyStatusRpc({...request, incomingCallMap, callback}))
}

export function rekeyShowPendingRekeyStatusRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { rekeyShowPendingRekeyStatusRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function revokeRevokeDeviceRpc (request: Exact<requestCommon & requestErrorCallback & {param: revokeRevokeDeviceRpcParam}>) {
  engineRpcOutgoing({...request, method: 'revoke.revokeDevice'})
}

export function revokeRevokeDeviceRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeDeviceRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => revokeRevokeDeviceRpc({...request, incomingCallMap, callback}))
}

export function revokeRevokeDeviceRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeDeviceRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { revokeRevokeDeviceRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function revokeRevokeKeyRpc (request: Exact<requestCommon & requestErrorCallback & {param: revokeRevokeKeyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'revoke.revokeKey'})
}

export function revokeRevokeKeyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeKeyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => revokeRevokeKeyRpc({...request, incomingCallMap, callback}))
}

export function revokeRevokeKeyRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeKeyRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { revokeRevokeKeyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function revokeRevokeSigsRpc (request: Exact<requestCommon & requestErrorCallback & {param: revokeRevokeSigsRpcParam}>) {
  engineRpcOutgoing({...request, method: 'revoke.revokeSigs'})
}

export function revokeRevokeSigsRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeSigsRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => revokeRevokeSigsRpc({...request, incomingCallMap, callback}))
}

export function revokeRevokeSigsRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: revokeRevokeSigsRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { revokeRevokeSigsRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function saltpackSaltpackDecryptRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: saltpackSaltpackDecryptResult) => void} & {param: saltpackSaltpackDecryptRpcParam}>) {
  engineRpcOutgoing({...request, method: 'saltpack.saltpackDecrypt'})
}

export function saltpackSaltpackDecryptRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: saltpackSaltpackDecryptResult) => void} & {param: saltpackSaltpackDecryptRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => saltpackSaltpackDecryptRpc({...request, incomingCallMap, callback}))
}

export function saltpackSaltpackDecryptRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: saltpackSaltpackDecryptResult) => void} & {param: saltpackSaltpackDecryptRpcParam}>): Promise<saltpackSaltpackDecryptResult> {
  return new Promise((resolve, reject) => { saltpackSaltpackDecryptRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function saltpackSaltpackEncryptRpc (request: Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackEncryptRpcParam}>) {
  engineRpcOutgoing({...request, method: 'saltpack.saltpackEncrypt'})
}

export function saltpackSaltpackEncryptRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackEncryptRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => saltpackSaltpackEncryptRpc({...request, incomingCallMap, callback}))
}

export function saltpackSaltpackEncryptRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackEncryptRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { saltpackSaltpackEncryptRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function saltpackSaltpackSignRpc (request: Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackSignRpcParam}>) {
  engineRpcOutgoing({...request, method: 'saltpack.saltpackSign'})
}

export function saltpackSaltpackSignRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackSignRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => saltpackSaltpackSignRpc({...request, incomingCallMap, callback}))
}

export function saltpackSaltpackSignRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackSignRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { saltpackSaltpackSignRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function saltpackSaltpackVerifyRpc (request: Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackVerifyRpcParam}>) {
  engineRpcOutgoing({...request, method: 'saltpack.saltpackVerify'})
}

export function saltpackSaltpackVerifyRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackVerifyRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => saltpackSaltpackVerifyRpc({...request, incomingCallMap, callback}))
}

export function saltpackSaltpackVerifyRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: saltpackSaltpackVerifyRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { saltpackSaltpackVerifyRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function sessionCurrentSessionRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: sessionCurrentSessionResult) => void}>) {
  engineRpcOutgoing({...request, method: 'session.currentSession'})
}

export function sessionCurrentSessionRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sessionCurrentSessionResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => sessionCurrentSessionRpc({...request, incomingCallMap, callback}))
}

export function sessionCurrentSessionRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sessionCurrentSessionResult) => void}>): Promise<sessionCurrentSessionResult> {
  return new Promise((resolve, reject) => { sessionCurrentSessionRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function signupCheckInvitationCodeRpc (request: Exact<requestCommon & requestErrorCallback & {param: signupCheckInvitationCodeRpcParam}>) {
  engineRpcOutgoing({...request, method: 'signup.checkInvitationCode'})
}

export function signupCheckInvitationCodeRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: signupCheckInvitationCodeRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => signupCheckInvitationCodeRpc({...request, incomingCallMap, callback}))
}

export function signupCheckInvitationCodeRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: signupCheckInvitationCodeRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { signupCheckInvitationCodeRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function signupCheckUsernameAvailableRpc (request: Exact<requestCommon & requestErrorCallback & {param: signupCheckUsernameAvailableRpcParam}>) {
  engineRpcOutgoing({...request, method: 'signup.checkUsernameAvailable'})
}

export function signupCheckUsernameAvailableRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: signupCheckUsernameAvailableRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => signupCheckUsernameAvailableRpc({...request, incomingCallMap, callback}))
}

export function signupCheckUsernameAvailableRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: signupCheckUsernameAvailableRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { signupCheckUsernameAvailableRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function signupInviteRequestRpc (request: Exact<requestCommon & requestErrorCallback & {param: signupInviteRequestRpcParam}>) {
  engineRpcOutgoing({...request, method: 'signup.inviteRequest'})
}

export function signupInviteRequestRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: signupInviteRequestRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => signupInviteRequestRpc({...request, incomingCallMap, callback}))
}

export function signupInviteRequestRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: signupInviteRequestRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { signupInviteRequestRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function signupSignupRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: signupSignupResult) => void} & {param: signupSignupRpcParam}>) {
  engineRpcOutgoing({...request, method: 'signup.signup'})
}

export function signupSignupRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: signupSignupResult) => void} & {param: signupSignupRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => signupSignupRpc({...request, incomingCallMap, callback}))
}

export function signupSignupRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: signupSignupResult) => void} & {param: signupSignupRpcParam}>): Promise<signupSignupResult> {
  return new Promise((resolve, reject) => { signupSignupRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function sigsSigListJSONRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListJSONResult) => void} & {param: sigsSigListJSONRpcParam}>) {
  engineRpcOutgoing({...request, method: 'sigs.sigListJSON'})
}

export function sigsSigListJSONRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListJSONResult) => void} & {param: sigsSigListJSONRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => sigsSigListJSONRpc({...request, incomingCallMap, callback}))
}

export function sigsSigListJSONRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListJSONResult) => void} & {param: sigsSigListJSONRpcParam}>): Promise<sigsSigListJSONResult> {
  return new Promise((resolve, reject) => { sigsSigListJSONRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function sigsSigListRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListResult) => void} & {param: sigsSigListRpcParam}>) {
  engineRpcOutgoing({...request, method: 'sigs.sigList'})
}

export function sigsSigListRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListResult) => void} & {param: sigsSigListRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => sigsSigListRpc({...request, incomingCallMap, callback}))
}

export function sigsSigListRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: sigsSigListResult) => void} & {param: sigsSigListRpcParam}>): Promise<sigsSigListResult> {
  return new Promise((resolve, reject) => { sigsSigListRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function testPanicRpc (request: Exact<requestCommon & requestErrorCallback & {param: testPanicRpcParam}>) {
  engineRpcOutgoing({...request, method: 'test.panic'})
}

export function testPanicRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: testPanicRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => testPanicRpc({...request, incomingCallMap, callback}))
}

export function testPanicRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: testPanicRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { testPanicRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function testTestCallbackRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: testTestCallbackResult) => void} & {param: testTestCallbackRpcParam}>) {
  engineRpcOutgoing({...request, method: 'test.testCallback'})
}

export function testTestCallbackRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: testTestCallbackResult) => void} & {param: testTestCallbackRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => testTestCallbackRpc({...request, incomingCallMap, callback}))
}

export function testTestCallbackRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: testTestCallbackResult) => void} & {param: testTestCallbackRpcParam}>): Promise<testTestCallbackResult> {
  return new Promise((resolve, reject) => { testTestCallbackRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function testTestRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: testTestResult) => void} & {param: testTestRpcParam}>) {
  engineRpcOutgoing({...request, method: 'test.test'})
}

export function testTestRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: testTestResult) => void} & {param: testTestRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => testTestRpc({...request, incomingCallMap, callback}))
}

export function testTestRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: testTestResult) => void} & {param: testTestRpcParam}>): Promise<testTestResult> {
  return new Promise((resolve, reject) => { testTestRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function tlfCompleteAndCanonicalizePrivateTlfNameRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCompleteAndCanonicalizePrivateTlfNameResult) => void} & {param: tlfCompleteAndCanonicalizePrivateTlfNameRpcParam}>) {
  engineRpcOutgoing({...request, method: 'tlf.completeAndCanonicalizePrivateTlfName'})
}

export function tlfCompleteAndCanonicalizePrivateTlfNameRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCompleteAndCanonicalizePrivateTlfNameResult) => void} & {param: tlfCompleteAndCanonicalizePrivateTlfNameRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => tlfCompleteAndCanonicalizePrivateTlfNameRpc({...request, incomingCallMap, callback}))
}

export function tlfCompleteAndCanonicalizePrivateTlfNameRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCompleteAndCanonicalizePrivateTlfNameResult) => void} & {param: tlfCompleteAndCanonicalizePrivateTlfNameRpcParam}>): Promise<tlfCompleteAndCanonicalizePrivateTlfNameResult> {
  return new Promise((resolve, reject) => { tlfCompleteAndCanonicalizePrivateTlfNameRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function tlfCryptKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCryptKeysResult) => void} & {param: tlfCryptKeysRpcParam}>) {
  engineRpcOutgoing({...request, method: 'tlf.CryptKeys'})
}

export function tlfCryptKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCryptKeysResult) => void} & {param: tlfCryptKeysRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => tlfCryptKeysRpc({...request, incomingCallMap, callback}))
}

export function tlfCryptKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfCryptKeysResult) => void} & {param: tlfCryptKeysRpcParam}>): Promise<tlfCryptKeysResult> {
  return new Promise((resolve, reject) => { tlfCryptKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function tlfKeysGetPublicCanonicalTLFNameAndIDRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam}>) {
  engineRpcOutgoing({...request, method: 'tlfKeys.getPublicCanonicalTLFNameAndID'})
}

export function tlfKeysGetPublicCanonicalTLFNameAndIDRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => tlfKeysGetPublicCanonicalTLFNameAndIDRpc({...request, incomingCallMap, callback}))
}

export function tlfKeysGetPublicCanonicalTLFNameAndIDRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam}>): Promise<tlfKeysGetPublicCanonicalTLFNameAndIDResult> {
  return new Promise((resolve, reject) => { tlfKeysGetPublicCanonicalTLFNameAndIDRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function tlfKeysGetTLFCryptKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetTLFCryptKeysResult) => void} & {param: tlfKeysGetTLFCryptKeysRpcParam}>) {
  engineRpcOutgoing({...request, method: 'tlfKeys.getTLFCryptKeys'})
}

export function tlfKeysGetTLFCryptKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetTLFCryptKeysResult) => void} & {param: tlfKeysGetTLFCryptKeysRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => tlfKeysGetTLFCryptKeysRpc({...request, incomingCallMap, callback}))
}

export function tlfKeysGetTLFCryptKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetTLFCryptKeysResult) => void} & {param: tlfKeysGetTLFCryptKeysRpcParam}>): Promise<tlfKeysGetTLFCryptKeysResult> {
  return new Promise((resolve, reject) => { tlfKeysGetTLFCryptKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function tlfPublicCanonicalTLFNameAndIDRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: tlfPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfPublicCanonicalTLFNameAndIDRpcParam}>) {
  engineRpcOutgoing({...request, method: 'tlf.publicCanonicalTLFNameAndID'})
}

export function tlfPublicCanonicalTLFNameAndIDRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfPublicCanonicalTLFNameAndIDRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => tlfPublicCanonicalTLFNameAndIDRpc({...request, incomingCallMap, callback}))
}

export function tlfPublicCanonicalTLFNameAndIDRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: tlfPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfPublicCanonicalTLFNameAndIDRpcParam}>): Promise<tlfPublicCanonicalTLFNameAndIDResult> {
  return new Promise((resolve, reject) => { tlfPublicCanonicalTLFNameAndIDRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackCheckTrackingRpc (request: Exact<requestCommon & requestErrorCallback>) {
  engineRpcOutgoing({...request, method: 'track.checkTracking'})
}

export function trackCheckTrackingRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackCheckTrackingRpc({...request, incomingCallMap, callback}))
}

export function trackCheckTrackingRpcPromise (request: $Exact<requestCommon & requestErrorCallback>): Promise<any> {
  return new Promise((resolve, reject) => { trackCheckTrackingRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackDismissWithTokenRpc (request: Exact<requestCommon & requestErrorCallback & {param: trackDismissWithTokenRpcParam}>) {
  engineRpcOutgoing({...request, method: 'track.dismissWithToken'})
}

export function trackDismissWithTokenRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: trackDismissWithTokenRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackDismissWithTokenRpc({...request, incomingCallMap, callback}))
}

export function trackDismissWithTokenRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: trackDismissWithTokenRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { trackDismissWithTokenRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackFakeTrackingChangedRpc (request: Exact<requestCommon & requestErrorCallback & {param: trackFakeTrackingChangedRpcParam}>) {
  engineRpcOutgoing({...request, method: 'track.fakeTrackingChanged'})
}

export function trackFakeTrackingChangedRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: trackFakeTrackingChangedRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackFakeTrackingChangedRpc({...request, incomingCallMap, callback}))
}

export function trackFakeTrackingChangedRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: trackFakeTrackingChangedRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { trackFakeTrackingChangedRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackTrackRpc (request: Exact<requestCommon & requestErrorCallback & {param: trackTrackRpcParam}>) {
  engineRpcOutgoing({...request, method: 'track.track'})
}

export function trackTrackRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: trackTrackRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackTrackRpc({...request, incomingCallMap, callback}))
}

export function trackTrackRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: trackTrackRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { trackTrackRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackTrackWithTokenRpc (request: Exact<requestCommon & requestErrorCallback & {param: trackTrackWithTokenRpcParam}>) {
  engineRpcOutgoing({...request, method: 'track.trackWithToken'})
}

export function trackTrackWithTokenRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: trackTrackWithTokenRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackTrackWithTokenRpc({...request, incomingCallMap, callback}))
}

export function trackTrackWithTokenRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: trackTrackWithTokenRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { trackTrackWithTokenRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function trackUntrackRpc (request: Exact<requestCommon & requestErrorCallback & {param: trackUntrackRpcParam}>) {
  engineRpcOutgoing({...request, method: 'track.untrack'})
}

export function trackUntrackRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & requestErrorCallback & {param: trackUntrackRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => trackUntrackRpc({...request, incomingCallMap, callback}))
}

export function trackUntrackRpcPromise (request: $Exact<requestCommon & requestErrorCallback & {param: trackUntrackRpcParam}>): Promise<any> {
  return new Promise((resolve, reject) => { trackUntrackRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackers2Rpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackers2Result) => void} & {param: userListTrackers2RpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.listTrackers2'})
}

export function userListTrackers2RpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackers2Result) => void} & {param: userListTrackers2RpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackers2Rpc({...request, incomingCallMap, callback}))
}

export function userListTrackers2RpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackers2Result) => void} & {param: userListTrackers2RpcParam}>): Promise<userListTrackers2Result> {
  return new Promise((resolve, reject) => { userListTrackers2Rpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackersByNameRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersByNameResult) => void} & {param: userListTrackersByNameRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.listTrackersByName'})
}

export function userListTrackersByNameRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersByNameResult) => void} & {param: userListTrackersByNameRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackersByNameRpc({...request, incomingCallMap, callback}))
}

export function userListTrackersByNameRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersByNameResult) => void} & {param: userListTrackersByNameRpcParam}>): Promise<userListTrackersByNameResult> {
  return new Promise((resolve, reject) => { userListTrackersByNameRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackersRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersResult) => void} & {param: userListTrackersRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.listTrackers'})
}

export function userListTrackersRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersResult) => void} & {param: userListTrackersRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackersRpc({...request, incomingCallMap, callback}))
}

export function userListTrackersRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersResult) => void} & {param: userListTrackersRpcParam}>): Promise<userListTrackersResult> {
  return new Promise((resolve, reject) => { userListTrackersRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackersSelfRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersSelfResult) => void}>) {
  engineRpcOutgoing({...request, method: 'user.listTrackersSelf'})
}

export function userListTrackersSelfRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersSelfResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackersSelfRpc({...request, incomingCallMap, callback}))
}

export function userListTrackersSelfRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackersSelfResult) => void}>): Promise<userListTrackersSelfResult> {
  return new Promise((resolve, reject) => { userListTrackersSelfRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackingJSONRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingJSONResult) => void} & {param: userListTrackingJSONRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.listTrackingJSON'})
}

export function userListTrackingJSONRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingJSONResult) => void} & {param: userListTrackingJSONRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackingJSONRpc({...request, incomingCallMap, callback}))
}

export function userListTrackingJSONRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingJSONResult) => void} & {param: userListTrackingJSONRpcParam}>): Promise<userListTrackingJSONResult> {
  return new Promise((resolve, reject) => { userListTrackingJSONRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userListTrackingRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingResult) => void} & {param: userListTrackingRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.listTracking'})
}

export function userListTrackingRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingResult) => void} & {param: userListTrackingRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userListTrackingRpc({...request, incomingCallMap, callback}))
}

export function userListTrackingRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userListTrackingResult) => void} & {param: userListTrackingRpcParam}>): Promise<userListTrackingResult> {
  return new Promise((resolve, reject) => { userListTrackingRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadAllPublicKeysUnverifiedRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void} & {param: userLoadAllPublicKeysUnverifiedRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadAllPublicKeysUnverified'})
}

export function userLoadAllPublicKeysUnverifiedRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void} & {param: userLoadAllPublicKeysUnverifiedRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadAllPublicKeysUnverifiedRpc({...request, incomingCallMap, callback}))
}

export function userLoadAllPublicKeysUnverifiedRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void} & {param: userLoadAllPublicKeysUnverifiedRpcParam}>): Promise<userLoadAllPublicKeysUnverifiedResult> {
  return new Promise((resolve, reject) => { userLoadAllPublicKeysUnverifiedRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadMyPublicKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadMyPublicKeysResult) => void}>) {
  engineRpcOutgoing({...request, method: 'user.loadMyPublicKeys'})
}

export function userLoadMyPublicKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadMyPublicKeysResult) => void}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadMyPublicKeysRpc({...request, incomingCallMap, callback}))
}

export function userLoadMyPublicKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadMyPublicKeysResult) => void}>): Promise<userLoadMyPublicKeysResult> {
  return new Promise((resolve, reject) => { userLoadMyPublicKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadPublicKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadPublicKeysResult) => void} & {param: userLoadPublicKeysRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadPublicKeys'})
}

export function userLoadPublicKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadPublicKeysResult) => void} & {param: userLoadPublicKeysRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadPublicKeysRpc({...request, incomingCallMap, callback}))
}

export function userLoadPublicKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadPublicKeysResult) => void} & {param: userLoadPublicKeysRpcParam}>): Promise<userLoadPublicKeysResult> {
  return new Promise((resolve, reject) => { userLoadPublicKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadUncheckedUserSummariesRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUncheckedUserSummariesResult) => void} & {param: userLoadUncheckedUserSummariesRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadUncheckedUserSummaries'})
}

export function userLoadUncheckedUserSummariesRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUncheckedUserSummariesResult) => void} & {param: userLoadUncheckedUserSummariesRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadUncheckedUserSummariesRpc({...request, incomingCallMap, callback}))
}

export function userLoadUncheckedUserSummariesRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUncheckedUserSummariesResult) => void} & {param: userLoadUncheckedUserSummariesRpcParam}>): Promise<userLoadUncheckedUserSummariesResult> {
  return new Promise((resolve, reject) => { userLoadUncheckedUserSummariesRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadUserByNameRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserByNameResult) => void} & {param: userLoadUserByNameRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadUserByName'})
}

export function userLoadUserByNameRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserByNameResult) => void} & {param: userLoadUserByNameRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadUserByNameRpc({...request, incomingCallMap, callback}))
}

export function userLoadUserByNameRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserByNameResult) => void} & {param: userLoadUserByNameRpcParam}>): Promise<userLoadUserByNameResult> {
  return new Promise((resolve, reject) => { userLoadUserByNameRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadUserPlusKeysRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserPlusKeysResult) => void} & {param: userLoadUserPlusKeysRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadUserPlusKeys'})
}

export function userLoadUserPlusKeysRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserPlusKeysResult) => void} & {param: userLoadUserPlusKeysRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadUserPlusKeysRpc({...request, incomingCallMap, callback}))
}

export function userLoadUserPlusKeysRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserPlusKeysResult) => void} & {param: userLoadUserPlusKeysRpcParam}>): Promise<userLoadUserPlusKeysResult> {
  return new Promise((resolve, reject) => { userLoadUserPlusKeysRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userLoadUserRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserResult) => void} & {param: userLoadUserRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.loadUser'})
}

export function userLoadUserRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserResult) => void} & {param: userLoadUserRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userLoadUserRpc({...request, incomingCallMap, callback}))
}

export function userLoadUserRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userLoadUserResult) => void} & {param: userLoadUserRpcParam}>): Promise<userLoadUserResult> {
  return new Promise((resolve, reject) => { userLoadUserRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export function userSearchRpc (request: Exact<requestCommon & {callback?: ?(err: ?any, response: userSearchResult) => void} & {param: userSearchRpcParam}>) {
  engineRpcOutgoing({...request, method: 'user.search'})
}

export function userSearchRpcChannelMap (channelConfig: ChannelConfig<*>, request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userSearchResult) => void} & {param: userSearchRpcParam}>): ChannelMap<*> {
  return _channelMapRpcHelper(channelConfig, (incomingCallMap, callback) => userSearchRpc({...request, incomingCallMap, callback}))
}

export function userSearchRpcPromise (request: $Exact<requestCommon & {callback?: ?(err: ?any, response: userSearchResult) => void} & {param: userSearchRpcParam}>): Promise<userSearchResult> {
  return new Promise((resolve, reject) => { userSearchRpc({...request, callback: (error, result) => { if (error) { reject(error) } else { resolve(result) } }}) })
}

export type APIRes = {
  status: string,
  body: string,
  httpStatus: int,
  appStatus: string,
}

export type BTCRegisterBTCRpcParam = Exact<{
  address: string,
  force: boolean
}>

export type BinaryKID = bytes

export type BlockIdCombo = {
  blockHash: string,
  chargedTo: UID,
}

export type BlockRefNonce = any

export type BlockReference = {
  bid: BlockIdCombo,
  nonce: BlockRefNonce,
  chargedTo: UID,
}

export type BlockReferenceCount = {
  ref: BlockReference,
  liveCount: int,
}

export type BoxNonce = any

export type BoxPublicKey = any

export type Bytes32 = any

export type CanonicalTLFNameAndIDWithBreaks = {
  tlfID: TLFID,
  CanonicalName: CanonicalTlfName,
  breaks: TLFBreak,
}

export type CanonicalTlfName = string

export type ChallengeInfo = {
  now: long,
  challenge: string,
}

export type CheckProofStatus = {
  found: boolean,
  status: ProofStatus,
  proofText: string,
  state: ProofState,
}

export type CheckResult = {
  proofResult: ProofResult,
  time: Time,
  freshness: CheckResultFreshness,
}

export type CheckResultFreshness = 
    0 // FRESH_0
  | 1 // AGED_1
  | 2 // RANCID_2

export type ChooseType = 
    0 // EXISTING_DEVICE_0
  | 1 // NEW_DEVICE_1

export type CiphertextBundle = {
  kid: KID,
  ciphertext: EncryptedBytes32,
  nonce: BoxNonce,
  publicKey: BoxPublicKey,
}

export type ClientDetails = {
  pid: int,
  clientType: ClientType,
  argv?: ?Array<string>,
  desc: string,
  version: string,
}

export type ClientType =  2 // FORCE GUI ONLY

export type ComponentResult = {
  name: string,
  status: Status,
}

export type Config = {
  serverURI: string,
  socketFile: string,
  label: string,
  runMode: string,
  gpgExists: boolean,
  gpgPath: string,
  version: string,
  path: string,
  configPath: string,
  versionShort: string,
  versionFull: string,
  isAutoForked: boolean,
  forkType: ForkType,
}

export type ConfigValue = {
  isNull: boolean,
  b?: ?boolean,
  i?: ?int,
  s?: ?string,
  o?: ?string,
}

export type ConfiguredAccount = {
  username: string,
  hasStoredSecret: boolean,
}

export type ConfirmResult = {
  identityConfirmed: boolean,
  remoteConfirmed: boolean,
  expiringLocal: boolean,
}

export type CryptKey = {
  KeyGeneration: int,
  Key: Bytes32,
}

export type Cryptocurrency = {
  rowId: int,
  pkhash: bytes,
  address: string,
  sigID: SigID,
}

export type CsrfToken = string

export type Device = {
  type: string,
  name: string,
  deviceID: DeviceID,
  cTime: Time,
  mTime: Time,
  lastUsedTime: Time,
  encryptKey: KID,
  verifyKey: KID,
  status: int,
}

export type DeviceDetail = {
  device: Device,
  eldest: boolean,
  provisioner?: ?Device,
  provisionedAt?: ?Time,
  revokedAt?: ?Time,
  revokedBy: KID,
  revokedByDevice?: ?Device,
  currentDevice: boolean,
}

export type DeviceID = string

export type DeviceType = 
    0 // DESKTOP_0
  | 1 // MOBILE_1

export type DismissReason = {
  type: DismissReasonType,
  reason: string,
  resource: string,
}

export type DismissReasonType = 
    0 // NONE_0
  | 1 // HANDLED_ELSEWHERE_1

export type DowngradeReferenceRes = {
  completed?: ?Array<BlockReferenceCount>,
  failed: BlockReference,
}

export type ED25519PublicKey = any

export type ED25519Signature = any

export type ED25519SignatureInfo = {
  sig: ED25519Signature,
  publicKey: ED25519PublicKey,
}

export type EncryptedBytes32 = any

export type ExitCode = 
    0 // OK_0
  | 2 // NOTOK_2
  | 4 // RESTART_4

export type ExtendedStatus = {
  standalone: boolean,
  passphraseStreamCached: boolean,
  tsecCached: boolean,
  deviceSigKeyCached: boolean,
  deviceEncKeyCached: boolean,
  paperSigKeyCached: boolean,
  paperEncKeyCached: boolean,
  storedSecret: boolean,
  secretPromptSkip: boolean,
  device?: ?Device,
  deviceErr?: ?LoadDeviceErr,
  logDir: string,
  session?: ?SessionStatus,
  defaultUsername: string,
  provisionedUsernames?: ?Array<string>,
  Clients?: ?Array<ClientDetails>,
  platformInfo: PlatformInfo,
  defaultDeviceID: DeviceID,
}

export type FSEditListRequest = {
  folder: Folder,
  requestID: int,
}

export type FSErrorType = 
    0 // ACCESS_DENIED_0
  | 1 // USER_NOT_FOUND_1
  | 2 // REVOKED_DATA_DETECTED_2
  | 3 // NOT_LOGGED_IN_3
  | 4 // TIMEOUT_4
  | 5 // REKEY_NEEDED_5
  | 6 // BAD_FOLDER_6
  | 7 // NOT_IMPLEMENTED_7
  | 8 // OLD_VERSION_8
  | 9 // OVER_QUOTA_9
  | 10 // NO_SIG_CHAIN_10
  | 11 // TOO_MANY_FOLDERS_11

export type FSNotification = {
  publicTopLevelFolder: boolean,
  filename: string,
  status: string,
  statusCode: FSStatusCode,
  notificationType: FSNotificationType,
  errorType: FSErrorType,
  params: {[key: string]: string},
  writerUid: UID,
  localTime: Time,
}

export type FSNotificationType = 
    0 // ENCRYPTING_0
  | 1 // DECRYPTING_1
  | 2 // SIGNING_2
  | 3 // VERIFYING_3
  | 4 // REKEYING_4
  | 5 // CONNECTION_5
  | 6 // MD_READ_SUCCESS_6
  | 7 // FILE_CREATED_7
  | 8 // FILE_MODIFIED_8
  | 9 // FILE_DELETED_9
  | 10 // FILE_RENAMED_10

export type FSPathSyncStatus = {
  publicTopLevelFolder: boolean,
  path: string,
  syncingBytes: int64,
  syncingOps: int64,
  syncedBytes: int64,
}

export type FSStatusCode = 
    0 // START_0
  | 1 // FINISH_1
  | 2 // ERROR_2

export type FSSyncStatus = {
  totalSyncingBytes: int64,
  totalSyncingOps: int64,
  pathStatuses?: ?Array<FSPathSyncStatus>,
}

export type FSSyncStatusRequest = {
  requestID: int,
}

export type FavoritesResult = {
  favoriteFolders?: ?Array<Folder>,
  ignoredFolders?: ?Array<Folder>,
  newFolders?: ?Array<Folder>,
}

export type Feature = {
  allow: boolean,
  defaultValue: boolean,
  readonly: boolean,
  label: string,
}

export type File = {
  path: string,
}

export type FileDescriptor = {
  name: string,
  type: FileType,
}

export type FileType = 
    0 // UNKNOWN_0
  | 1 // DIRECTORY_1
  | 2 // FILE_2

export type FirstStepResult = {
  valPlusTwo: int,
}

export type Folder = {
  name: string,
  private: boolean,
  notificationsOn: boolean,
  created: boolean,
}

export type ForkType = 
    0 // NONE_0
  | 1 // AUTO_1
  | 2 // WATCHDOG_2
  | 3 // LAUNCHD_3

export type FuseMountInfo = {
  path: string,
  fstype: string,
  output: string,
}

export type FuseStatus = {
  version: string,
  bundleVersion: string,
  kextID: string,
  path: string,
  kextStarted: boolean,
  installStatus: InstallStatus,
  installAction: InstallAction,
  mountInfos?: ?Array<FuseMountInfo>,
  status: Status,
}

export type GPGKey = {
  algorithm: string,
  keyID: string,
  creation: string,
  expiration: string,
  identities?: ?Array<PGPIdentity>,
}

export type GPGMethod = 
    0 // GPG_NONE_0
  | 1 // GPG_IMPORT_1
  | 2 // GPG_SIGN_2

export type GUIEntryArg = {
  windowTitle: string,
  prompt: string,
  username: string,
  submitLabel: string,
  cancelLabel: string,
  retryLabel: string,
  type: PassphraseType,
  features: GUIEntryFeatures,
}

export type GUIEntryFeatures = {
  showTyping: Feature,
}

export type GetBlockRes = {
  blockKey: string,
  buf: bytes,
}

export type GetCurrentStatusRes = {
  configured: boolean,
  registered: boolean,
  loggedIn: boolean,
  sessionIsValid: boolean,
  user?: ?User,
}

export type GetPassphraseRes = {
  passphrase: string,
  storeSecret: boolean,
}

export type GetTLFCryptKeysRes = {
  nameIDBreaks: CanonicalTLFNameAndIDWithBreaks,
  CryptKeys?: ?Array<CryptKey>,
}

export type HasServerKeysRes = {
  hasServerKeys: bool,
}

export type Hello2Res = {
  encryptionKey: KID,
  sigPayload: HelloRes,
}

export type HelloRes = string

export type Identify2Res = {
  upk: UserPlusKeys,
  trackBreaks?: ?IdentifyTrackBreaks,
}

export type IdentifyKey = {
  pgpFingerprint: bytes,
  KID: KID,
  trackDiff?: ?TrackDiff,
  breaksTracking: boolean,
}

export type IdentifyOutcome = {
  username: string,
  status?: ?Status,
  warnings?: ?Array<string>,
  trackUsed?: ?TrackSummary,
  trackStatus: TrackStatus,
  numTrackFailures: int,
  numTrackChanges: int,
  numProofFailures: int,
  numRevoked: int,
  numProofSuccesses: int,
  revoked?: ?Array<TrackDiff>,
  trackOptions: TrackOptions,
  forPGPPull: boolean,
  reason: IdentifyReason,
}

export type IdentifyProofBreak = {
  remoteProof: RemoteProof,
  lcr: LinkCheckResult,
}

export type IdentifyReason = {
  type: IdentifyReasonType,
  reason: string,
  resource: string,
}

export type IdentifyReasonType = 
    0 // NONE_0
  | 1 // ID_1
  | 2 // TRACK_2
  | 3 // ENCRYPT_3
  | 4 // DECRYPT_4
  | 5 // VERIFY_5
  | 6 // RESOURCE_6

export type IdentifyRes = {
  user?: ?User,
  publicKeys?: ?Array<PublicKey>,
  outcome: IdentifyOutcome,
  trackToken: TrackToken,
}

export type IdentifyRow = {
  rowId: int,
  proof: RemoteProof,
  trackDiff?: ?TrackDiff,
}

export type IdentifyTrackBreaks = {
  keys?: ?Array<IdentifyKey>,
  proofs?: ?Array<IdentifyProofBreak>,
}

export type Identity = {
  status?: ?Status,
  whenLastTracked: Time,
  proofs?: ?Array<IdentifyRow>,
  cryptocurrency?: ?Array<Cryptocurrency>,
  revoked?: ?Array<TrackDiff>,
  revokedDetails?: ?Array<RevokedProof>,
  breaksTracking: boolean,
}

export type InstallAction = 
    0 // UNKNOWN_0
  | 1 // NONE_1
  | 2 // UPGRADE_2
  | 3 // REINSTALL_3
  | 4 // INSTALL_4

export type InstallResult = {
  componentResults?: ?Array<ComponentResult>,
  status: Status,
  fatal: boolean,
}

export type InstallStatus = 
    0 // UNKNOWN_0
  | 1 // ERROR_1
  | 2 // NOT_INSTALLED_2
  | 4 // INSTALLED_4

export type KID = string

export type Kex2Provisionee2DidCounterSign2RpcParam = Exact<{
  sig: bytes,
  ppsEncrypted: string
}>

export type Kex2Provisionee2Hello2RpcParam = Exact<{
  uid: UID,
  token: SessionToken,
  csrf: CsrfToken,
  sigBody: string
}>

export type Kex2ProvisioneeDidCounterSignRpcParam = Exact<{
  sig: bytes
}>

export type Kex2ProvisioneeHelloRpcParam = Exact<{
  uid: UID,
  token: SessionToken,
  csrf: CsrfToken,
  pps: PassphraseStream,
  sigBody: string
}>

export type KeyBundle = {
  version: int,
  bundle: bytes,
}

export type KeyBundleResponse = {
  WriterBundle: KeyBundle,
  ReaderBundle: KeyBundle,
}

export type KeyHalf = {
  user: UID,
  deviceKID: KID,
  key: bytes,
}

export type KeyInfo = {
  fingerprint: string,
  key: string,
  desc: string,
}

export type KeybaseTime = {
  unix: Time,
  chain: int,
}

export type LinkCheckResult = {
  proofId: int,
  proofResult: ProofResult,
  snoozedResult: ProofResult,
  torWarning: boolean,
  tmpTrackExpireTime: Time,
  cached?: ?CheckResult,
  diff?: ?TrackDiff,
  remoteDiff?: ?TrackDiff,
  hint?: ?SigHint,
  breaksTracking: boolean,
}

export type ListResult = {
  files?: ?Array<File>,
}

export type LoadDeviceErr = {
  where: string,
  desc: string,
}

export type LogLevel = 
    0 // NONE_0
  | 1 // DEBUG_1
  | 2 // INFO_2
  | 3 // NOTICE_3
  | 4 // WARN_4
  | 5 // ERROR_5
  | 6 // CRITICAL_6
  | 7 // FATAL_7

export type MDBlock = {
  version: int,
  timestamp: Time,
  block: bytes,
}

export type MerkleRoot = {
  version: int,
  root: bytes,
}

export type MerkleTreeID = 
    0 // MASTER_0
  | 1 // KBFS_PUBLIC_1
  | 2 // KBFS_PRIVATE_2

export type MetadataResponse = {
  folderID: string,
  mdBlocks?: ?Array<MDBlock>,
}

export type NaclDHKeyPrivate = any

export type NaclDHKeyPublic = any

export type NaclSigningKeyPrivate = any

export type NaclSigningKeyPublic = any

export type NotificationChannels = {
  session: boolean,
  users: boolean,
  kbfs: boolean,
  tracking: boolean,
  favorites: boolean,
  paperkeys: boolean,
  keyfamily: boolean,
  service: boolean,
  app: boolean,
  chat: boolean,
  pgp: boolean,
  kbfsrequest: boolean,
}

export type NotifyFSFSActivityRpcParam = Exact<{
  notification: FSNotification
}>

export type NotifyFSFSEditListResponseRpcParam = Exact<{
  edits?: ?Array<FSNotification>,
  requestID: int
}>

export type NotifyFSFSSyncActivityRpcParam = Exact<{
  status: FSPathSyncStatus
}>

export type NotifyFSFSSyncStatusResponseRpcParam = Exact<{
  status: FSSyncStatus,
  requestID: int
}>

export type NotifyFSRequestFSEditListRequestRpcParam = Exact<{
  req: FSEditListRequest
}>

export type NotifyFSRequestFSSyncStatusRequestRpcParam = Exact<{
  req: FSSyncStatusRequest
}>

export type NotifyFavoritesFavoritesChangedRpcParam = Exact<{
  uid: UID
}>

export type NotifyKeyfamilyKeyfamilyChangedRpcParam = Exact<{
  uid: UID
}>

export type NotifyPaperKeyPaperKeyCachedRpcParam = Exact<{
  uid: UID,
  encKID: KID,
  sigKID: KID
}>

export type NotifySessionClientOutOfDateRpcParam = Exact<{
  upgradeTo: string,
  upgradeURI: string,
  upgradeMsg: string
}>

export type NotifySessionLoggedInRpcParam = Exact<{
  username: string
}>

export type NotifyTrackingTrackingChangedRpcParam = Exact<{
  uid: UID,
  username: string
}>

export type NotifyUsersUserChangedRpcParam = Exact<{
  uid: UID
}>

export type OutOfDateInfo = {
  upgradeTo: string,
  upgradeURI: string,
  customMessage: string,
}

export type Outcome = 
    0 // NONE_0
  | 1 // FIXED_1
  | 2 // IGNORED_2

export type PGPCreateUids = {
  useDefault: boolean,
  ids?: ?Array<PGPIdentity>,
}

export type PGPDecryptOptions = {
  assertSigned: boolean,
  signedBy: string,
}

export type PGPEncryptOptions = {
  recipients?: ?Array<string>,
  noSign: boolean,
  noSelf: boolean,
  binaryOut: boolean,
  keyQuery: string,
}

export type PGPIdentity = {
  username: string,
  comment: string,
  email: string,
}

export type PGPPurgeRes = {
  filenames?: ?Array<string>,
}

export type PGPQuery = {
  secret: boolean,
  query: string,
  exactMatch: boolean,
}

export type PGPSigVerification = {
  isSigned: boolean,
  verified: boolean,
  signer: User,
  signKey: PublicKey,
}

export type PGPSignOptions = {
  keyQuery: string,
  mode: SignMode,
  binaryIn: boolean,
  binaryOut: boolean,
}

export type PGPVerifyOptions = {
  signedBy: string,
  signature: bytes,
}

export type PassphraseStream = {
  passphraseStream: bytes,
  generation: int,
}

export type PassphraseType = 
    0 // NONE_0
  | 1 // PAPER_KEY_1
  | 2 // PASS_PHRASE_2
  | 3 // VERIFY_PASS_PHRASE_3

export type PingResponse = {
  timestamp: Time,
}

export type PlatformInfo = {
  os: string,
  osVersion: string,
  arch: string,
  goVersion: string,
}

export type ProblemSet = {
  user: User,
  kid: KID,
  tlfs?: ?Array<ProblemTLF>,
}

export type ProblemSetDevices = {
  problemSet: ProblemSet,
  devices?: ?Array<Device>,
}

export type ProblemTLF = {
  tlf: TLF,
  score: int,
  solution_kids?: ?Array<KID>,
}

export type Process = {
  pid: string,
  command: string,
  fileDescriptors?: ?Array<FileDescriptor>,
}

export type PromptDefault = 
    0 // NONE_0
  | 1 // YES_1
  | 2 // NO_2

export type PromptOverwriteType = 
    0 // SOCIAL_0
  | 1 // SITE_1

export type ProofResult = {
  state: ProofState,
  status: ProofStatus,
  desc: string,
}

export type ProofState = 
    0 // NONE_0
  | 1 // OK_1
  | 2 // TEMP_FAILURE_2
  | 3 // PERM_FAILURE_3
  | 4 // LOOKING_4
  | 5 // SUPERSEDED_5
  | 6 // POSTED_6
  | 7 // REVOKED_7
  | 8 // DELETED_8

export type ProofStatus = 
    0 // NONE_0
  | 1 // OK_1
  | 2 // LOCAL_2
  | 3 // FOUND_3
  | 100 // BASE_ERROR_100
  | 101 // HOST_UNREACHABLE_101
  | 103 // PERMISSION_DENIED_103
  | 106 // FAILED_PARSE_106
  | 107 // DNS_ERROR_107
  | 108 // AUTH_FAILED_108
  | 129 // HTTP_429_129
  | 150 // HTTP_500_150
  | 160 // TIMEOUT_160
  | 170 // INTERNAL_ERROR_170
  | 200 // BASE_HARD_ERROR_200
  | 201 // NOT_FOUND_201
  | 202 // CONTENT_FAILURE_202
  | 203 // BAD_USERNAME_203
  | 204 // BAD_REMOTE_ID_204
  | 205 // TEXT_NOT_FOUND_205
  | 206 // BAD_ARGS_206
  | 207 // CONTENT_MISSING_207
  | 208 // TITLE_NOT_FOUND_208
  | 209 // SERVICE_ERROR_209
  | 210 // TOR_SKIPPED_210
  | 211 // TOR_INCOMPATIBLE_211
  | 230 // HTTP_300_230
  | 240 // HTTP_400_240
  | 260 // HTTP_OTHER_260
  | 270 // EMPTY_JSON_270
  | 301 // DELETED_301
  | 302 // SERVICE_DEAD_302
  | 303 // BAD_SIGNATURE_303
  | 304 // BAD_API_URL_304
  | 305 // UNKNOWN_TYPE_305
  | 306 // NO_HINT_306
  | 307 // BAD_HINT_TEXT_307
  | 308 // INVALID_PVL_308

export type ProofType = 
    0 // NONE_0
  | 1 // KEYBASE_1
  | 2 // TWITTER_2
  | 3 // GITHUB_3
  | 4 // REDDIT_4
  | 5 // COINBASE_5
  | 6 // HACKERNEWS_6
  | 8 // FACEBOOK_8
  | 1000 // GENERIC_WEB_SITE_1000
  | 1001 // DNS_1001
  | 1002 // PGP_1002
  | 100001 // ROOTER_100001

export type Proofs = {
  social?: ?Array<TrackProof>,
  web?: ?Array<WebProof>,
  publicKeys?: ?Array<PublicKey>,
}

export type ProvisionMethod = 
    0 // DEVICE_0
  | 1 // PAPER_KEY_1
  | 2 // PASSPHRASE_2
  | 3 // GPG_IMPORT_3
  | 4 // GPG_SIGN_4

export type PublicKey = {
  KID: KID,
  PGPFingerprint: string,
  PGPIdentities?: ?Array<PGPIdentity>,
  isSibkey: boolean,
  isEldest: boolean,
  parentID: string,
  deviceID: DeviceID,
  deviceDescription: string,
  deviceType: string,
  cTime: Time,
  eTime: Time,
}

export type PushReason = 
    0 // NONE_0
  | 1 // RECONNECTED_1
  | 2 // NEW_DATA_2

export type RekeyEvent = {
  eventType: RekeyEventType,
  interruptType: int,
}

export type RekeyEventType = 
    0 // NONE_0
  | 1 // NOT_LOGGED_IN_1
  | 2 // API_ERROR_2
  | 3 // NO_PROBLEMS_3
  | 4 // LOAD_ME_ERROR_4
  | 5 // CURRENT_DEVICE_CAN_REKEY_5
  | 6 // DEVICE_LOAD_ERROR_6
  | 7 // HARASS_7
  | 8 // NO_GREGOR_MESSAGES_8

export type RemoteProof = {
  proofType: ProofType,
  key: string,
  value: string,
  displayMarkup: string,
  sigID: SigID,
  mTime: Time,
}

export type RevokeWarning = {
  endangeredTLFs?: ?Array<TLF>,
}

export type RevokedKey = {
  key: PublicKey,
  time: KeybaseTime,
  by: KID,
}

export type RevokedProof = {
  proof: RemoteProof,
  diff: TrackDiff,
}

export type SaltpackDecryptOptions = {
  interactive: boolean,
  forceRemoteCheck: boolean,
  usePaperKey: boolean,
}

export type SaltpackEncryptOptions = {
  recipients?: ?Array<string>,
  hideSelf: boolean,
  noSelfEncrypt: boolean,
  binary: boolean,
  hideRecipients: boolean,
}

export type SaltpackEncryptedMessageInfo = {
  devices?: ?Array<Device>,
  numAnonReceivers: int,
  receiverIsAnon: boolean,
  sender: SaltpackSender,
}

export type SaltpackSender = {
  uid: UID,
  username: string,
  senderType: SaltpackSenderType,
}

export type SaltpackSenderType = 
    0 // NOT_TRACKED_0
  | 1 // UNKNOWN_1
  | 2 // ANONYMOUS_2
  | 3 // TRACKING_BROKE_3
  | 4 // TRACKING_OK_4
  | 5 // SELF_5

export type SaltpackSignOptions = {
  detached: boolean,
  binary: boolean,
}

export type SaltpackVerifyOptions = {
  signedBy: string,
  signature: bytes,
}

export type ScanProofsScanProofsRpcParam = Exact<{
  infile: string,
  indices: string,
  sigid: string,
  ratelimit: int,
  cachefile: string,
  ignorefile: string
}>

export type SearchComponent = {
  key: string,
  value: string,
  score: double,
}

export type SearchResult = {
  uid: UID,
  username: string,
  components?: ?Array<SearchComponent>,
  score: double,
}

export type SecretEntryArg = {
  desc: string,
  prompt: string,
  err: string,
  cancel: string,
  ok: string,
  reason: string,
  showTyping: boolean,
}

export type SecretEntryRes = {
  text: string,
  canceled: boolean,
  storeSecret: boolean,
}

export type SecretKeys = {
  signing: NaclSigningKeyPrivate,
  encryption: NaclDHKeyPrivate,
}

export type SecretResponse = {
  secret: bytes,
  phrase: string,
}

export type SelectKeyRes = {
  keyID: string,
  doSecretPush: boolean,
}

export type ServiceStatus = {
  version: string,
  label: string,
  pid: string,
  lastExitStatus: string,
  bundleVersion: string,
  installStatus: InstallStatus,
  installAction: InstallAction,
  status: Status,
}

export type ServicesStatus = {
  service?: ?Array<ServiceStatus>,
  kbfs?: ?Array<ServiceStatus>,
  updater?: ?Array<ServiceStatus>,
}

export type Session = {
  uid: UID,
  username: string,
  token: string,
  deviceSubkeyKid: KID,
  deviceSibkeyKid: KID,
}

export type SessionStatus = {
  SessionFor: string,
  Loaded: boolean,
  Cleared: boolean,
  SaltOnly: boolean,
  Expired: boolean,
}

export type SessionToken = string

export type Sig = {
  seqno: int,
  sigID: SigID,
  sigIDDisplay: string,
  type: string,
  cTime: Time,
  revoked: boolean,
  active: boolean,
  key: string,
  body: string,
}

export type SigHint = {
  remoteId: string,
  humanUrl: string,
  apiUrl: string,
  checkText: string,
}

export type SigID = string

export type SigListArgs = {
  sessionID: int,
  username: string,
  allKeys: boolean,
  types?: ?SigTypes,
  filterx: string,
  verbose: boolean,
  revoked: boolean,
}

export type SigTypes = {
  track: boolean,
  proof: boolean,
  cryptocurrency: boolean,
  isSelf: boolean,
}

export type SignMode = 
    0 // ATTACHED_0
  | 1 // DETACHED_1
  | 2 // CLEAR_2

export type SignupRes = {
  passphraseOk: boolean,
  postOk: boolean,
  writeOk: boolean,
}

export type SocialAssertion = {
  user: string,
  service: SocialAssertionService,
}

export type SocialAssertionService = string

export type StartProofResult = {
  sigID: SigID,
}

export type Status = {
  code: int,
  name: string,
  desc: string,
  fields?: ?Array<StringKVPair>,
}

export type StatusCode = 
    0 // SCOk_0
  | 100 // SCInputError_100
  | 201 // SCLoginRequired_201
  | 202 // SCBadSession_202
  | 203 // SCBadLoginUserNotFound_203
  | 204 // SCBadLoginPassword_204
  | 205 // SCNotFound_205
  | 210 // SCThrottleControl_210
  | 216 // SCDeleted_216
  | 218 // SCGeneric_218
  | 235 // SCAlreadyLoggedIn_235
  | 237 // SCCanceled_237
  | 239 // SCInputCanceled_239
  | 274 // SCReloginRequired_274
  | 275 // SCResolutionFailed_275
  | 276 // SCProfileNotPublic_276
  | 277 // SCIdentifyFailed_277
  | 278 // SCTrackingBroke_278
  | 279 // SCWrongCryptoFormat_279
  | 280 // SCDecryptionError_280
  | 472 // SCBadEmail_472
  | 701 // SCBadSignupUsernameTaken_701
  | 707 // SCBadInvitationCode_707
  | 801 // SCMissingResult_801
  | 901 // SCKeyNotFound_901
  | 907 // SCKeyInUse_907
  | 913 // SCKeyBadGen_913
  | 914 // SCKeyNoSecret_914
  | 915 // SCKeyBadUIDs_915
  | 916 // SCKeyNoActive_916
  | 917 // SCKeyNoSig_917
  | 918 // SCKeyBadSig_918
  | 919 // SCKeyBadEldest_919
  | 920 // SCKeyNoEldest_920
  | 921 // SCKeyDuplicateUpdate_921
  | 922 // SCSibkeyAlreadyExists_922
  | 924 // SCDecryptionKeyNotFound_924
  | 927 // SCKeyNoPGPEncryption_927
  | 928 // SCKeyNoNaClEncryption_928
  | 929 // SCKeySyncedPGPNotFound_929
  | 930 // SCKeyNoMatchingGPG_930
  | 931 // SCKeyRevoked_931
  | 1301 // SCBadTrackSession_1301
  | 1404 // SCDeviceBadName_1404
  | 1408 // SCDeviceNameInUse_1408
  | 1409 // SCDeviceNotFound_1409
  | 1410 // SCDeviceMismatch_1410
  | 1411 // SCDeviceRequired_1411
  | 1413 // SCDevicePrevProvisioned_1413
  | 1414 // SCDeviceNoProvision_1414
  | 1501 // SCStreamExists_1501
  | 1502 // SCStreamNotFound_1502
  | 1503 // SCStreamWrongKind_1503
  | 1504 // SCStreamEOF_1504
  | 1600 // SCGenericAPIError_1600
  | 1601 // SCAPINetworkError_1601
  | 1602 // SCTimeout_1602
  | 1701 // SCProofError_1701
  | 1702 // SCIdentificationExpired_1702
  | 1703 // SCSelfNotFound_1703
  | 1704 // SCBadKexPhrase_1704
  | 1705 // SCNoUIDelegation_1705
  | 1706 // SCNoUI_1706
  | 1707 // SCGPGUnavailable_1707
  | 1800 // SCInvalidVersionError_1800
  | 1801 // SCOldVersionError_1801
  | 1802 // SCInvalidLocationError_1802
  | 1803 // SCServiceStatusError_1803
  | 1804 // SCInstallError_1804
  | 2500 // SCChatInternal_2500
  | 2501 // SCChatRateLimit_2501
  | 2502 // SCChatConvExists_2502
  | 2503 // SCChatUnknownTLFID_2503
  | 2504 // SCChatNotInConv_2504
  | 2505 // SCChatBadMsg_2505
  | 2506 // SCChatBroadcast_2506
  | 2507 // SCChatAlreadySuperseded_2507
  | 2508 // SCChatAlreadyDeleted_2508
  | 2509 // SCChatTLFFinalized_2509

export type Stream = {
  fd: int,
}

export type StringKVPair = {
  key: string,
  value: string,
}

export type TLF = {
  id: TLFID,
  name: string,
  writers?: ?Array<string>,
  readers?: ?Array<string>,
  isPrivate: boolean,
}

export type TLFBreak = {
  breaks?: ?Array<TLFUserBreak>,
}

export type TLFID = string

export type TLFIdentifyBehavior = 
    0 // DEFAULT_KBFS_0
  | 1 // CHAT_CLI_1
  | 2 // CHAT_GUI_2

export type TLFQuery = {
  tlfName: string,
  identifyBehavior: TLFIdentifyBehavior,
}

export type TLFUserBreak = {
  user: User,
  breaks?: ?IdentifyTrackBreaks,
}

export type Test = {
  reply: string,
}

export type Text = {
  data: string,
  markup: boolean,
}

export type Time = long

export type TrackDiff = {
  type: TrackDiffType,
  displayMarkup: string,
}

export type TrackDiffType = 
    0 // NONE_0
  | 1 // ERROR_1
  | 2 // CLASH_2
  | 3 // REVOKED_3
  | 4 // UPGRADED_4
  | 5 // NEW_5
  | 6 // REMOTE_FAIL_6
  | 7 // REMOTE_WORKING_7
  | 8 // REMOTE_CHANGED_8
  | 9 // NEW_ELDEST_9
  | 10 // NONE_VIA_TEMPORARY_10

export type TrackOptions = {
  localOnly: boolean,
  bypassConfirm: boolean,
  forceRetrack: boolean,
  expiringLocal: boolean,
}

export type TrackProof = {
  proofType: string,
  proofName: string,
  idString: string,
}

export type TrackStatus = 
    1 // NEW_OK_1
  | 2 // NEW_ZERO_PROOFS_2
  | 3 // NEW_FAIL_PROOFS_3
  | 4 // UPDATE_BROKEN_FAILED_PROOFS_4
  | 5 // UPDATE_NEW_PROOFS_5
  | 6 // UPDATE_OK_6
  | 7 // UPDATE_BROKEN_REVOKED_7

export type TrackSummary = {
  username: string,
  time: Time,
  isRemote: boolean,
}

export type TrackToken = string

export type Tracker = {
  tracker: UID,
  status: int,
  mTime: Time,
}

export type UID = string

export type UnboxAnyRes = {
  kid: KID,
  plaintext: Bytes32,
  index: int,
}

export type UninstallResult = {
  componentResults?: ?Array<ComponentResult>,
  status: Status,
}

export type User = {
  uid: UID,
  username: string,
}

export type UserCard = {
  following: int,
  followers: int,
  uid: UID,
  fullName: string,
  location: string,
  bio: string,
  website: string,
  twitter: string,
  youFollowThem: boolean,
  theyFollowYou: boolean,
}

export type UserPlusKeys = {
  uid: UID,
  username: string,
  deviceKeys?: ?Array<PublicKey>,
  revokedDeviceKeys?: ?Array<RevokedKey>,
  pgpKeyCount: int,
  uvv: UserVersionVector,
}

export type UserResolution = {
  assertion: SocialAssertion,
  userID: UID,
}

export type UserSummary = {
  uid: UID,
  username: string,
  thumbnail: string,
  idVersion: int,
  fullName: string,
  bio: string,
  proofs: Proofs,
  sigIDDisplay: string,
  trackTime: Time,
}

export type UserSummary2 = {
  uid: UID,
  username: string,
  thumbnail: string,
  fullName: string,
  isFollower: boolean,
  isFollowee: boolean,
}

export type UserSummary2Set = {
  users?: ?Array<UserSummary2>,
  time: Time,
  version: int,
}

export type UserVersionVector = {
  id: long,
  sigHints: int,
  sigChain: long,
  cachedAt: Time,
  lastIdentifiedAt: Time,
}

export type VerifySessionRes = {
  uid: UID,
  sid: string,
  generated: int,
  lifetime: int,
}

export type WebProof = {
  hostname: string,
  protocols?: ?Array<string>,
}

export type accountEmailChangeRpcParam = Exact<{
  newEmail: string
}>

export type accountPassphraseChangeRpcParam = Exact<{
  oldPassphrase: string,
  passphrase: string,
  force: boolean
}>

export type accountPassphrasePromptRpcParam = Exact<{
  guiArg: GUIEntryArg
}>

export type apiserverGetRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverPostJSONRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  JSONPayload?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverPostRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type blockAddReferenceRpcParam = Exact<{
  folder: string,
  ref: BlockReference
}>

export type blockArchiveReferenceRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockArchiveReferenceWithCountRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockAuthenticateSessionRpcParam = Exact<{
  signature: string
}>

export type blockDelReferenceRpcParam = Exact<{
  folder: string,
  ref: BlockReference
}>

export type blockDelReferenceWithCountRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockGetBlockRpcParam = Exact<{
  bid: BlockIdCombo,
  folder: string
}>

export type blockPutBlockRpcParam = Exact<{
  bid: BlockIdCombo,
  folder: string,
  blockKey: string,
  buf: bytes
}>

export type configClearValueRpcParam = Exact<{
  path: string
}>

export type configGetValueRpcParam = Exact<{
  path: string
}>

export type configHelloIAmRpcParam = Exact<{
  details: ClientDetails
}>

export type configSetPathRpcParam = Exact<{
  path: string
}>

export type configSetUserConfigRpcParam = Exact<{
  username: string,
  key: string,
  value: string
}>

export type configSetValueRpcParam = Exact<{
  path: string,
  value: ConfigValue
}>

export type cryptoSignED25519RpcParam = Exact<{
  msg: bytes,
  reason: string
}>

export type cryptoSignToStringRpcParam = Exact<{
  msg: bytes,
  reason: string
}>

export type cryptoUnboxBytes32AnyRpcParam = Exact<{
  bundles?: ?Array<CiphertextBundle>,
  reason: string,
  promptPaper: boolean
}>

export type cryptoUnboxBytes32RpcParam = Exact<{
  encryptedBytes32: EncryptedBytes32,
  nonce: BoxNonce,
  peersPublicKey: BoxPublicKey,
  reason: string
}>

export type ctlStopRpcParam = Exact<{
  exitCode: ExitCode
}>

export type debuggingFirstStepRpcParam = Exact<{
  val: int
}>

export type debuggingIncrementRpcParam = Exact<{
  val: int
}>

export type debuggingSecondStepRpcParam = Exact<{
  val: int
}>

export type deviceCheckDeviceNameForUserRpcParam = Exact<{
  username: string,
  devicename: string
}>

export type deviceCheckDeviceNameFormatRpcParam = Exact<{
  name: string
}>

export type favoriteFavoriteAddRpcParam = Exact<{
  folder: Folder
}>

export type favoriteFavoriteIgnoreRpcParam = Exact<{
  folder: Folder
}>

export type fsListRpcParam = Exact<{
  path: string
}>

export type gpgUiSelectKeyAndPushOptionRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type gpgUiSelectKeyRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type gpgUiSignRpcParam = Exact<{
  msg: bytes,
  fingerprint: bytes
}>

export type gregorUIPushOutOfBandMessagesRpcParam = Exact<{
  oobm?: ?Array<gregor1.OutOfBandMessage>
}>

export type gregorUIPushStateRpcParam = Exact<{
  state: gregor1.State,
  reason: PushReason
}>

export type identifyIdentify2RpcParam = Exact<{
  uid: UID,
  userAssertion: string,
  reason: IdentifyReason,
  useDelegateUI?: boolean,
  alwaysBlock?: boolean,
  noErrorOnTrackFailure?: boolean,
  forceRemoteCheck?: boolean,
  needProofSet?: boolean,
  allowEmptySelfID?: boolean,
  noSkipSelf?: boolean,
  canSuppressUI?: boolean,
  chatGUIMode?: boolean,
  forceDisplay?: boolean
}>

export type identifyIdentifyRpcParam = Exact<{
  userAssertion: string,
  forceRemoteCheck?: boolean,
  useDelegateUI?: boolean,
  reason: IdentifyReason,
  source: ClientType
}>

export type identifyResolve2RpcParam = Exact<{
  assertion: string
}>

export type identifyResolveRpcParam = Exact<{
  assertion: string
}>

export type identifyUiConfirmRpcParam = Exact<{
  outcome: IdentifyOutcome
}>

export type identifyUiDismissRpcParam = Exact<{
  username: string,
  reason: DismissReason
}>

export type identifyUiDisplayCryptocurrencyRpcParam = Exact<{
  c: Cryptocurrency
}>

export type identifyUiDisplayKeyRpcParam = Exact<{
  key: IdentifyKey
}>

export type identifyUiDisplayTLFCreateWithInviteRpcParam = Exact<{
  folderName: string,
  isPrivate: boolean,
  assertion: string,
  socialAssertion: SocialAssertion,
  inviteLink: string,
  throttled: boolean
}>

export type identifyUiDisplayTrackStatementRpcParam = Exact<{
  stmt: string
}>

export type identifyUiDisplayUserCardRpcParam = Exact<{
  card: UserCard
}>

export type identifyUiFinishSocialProofCheckRpcParam = Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export type identifyUiFinishWebProofCheckRpcParam = Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export type identifyUiLaunchNetworkChecksRpcParam = Exact<{
  identity: Identity,
  user: User
}>

export type identifyUiReportLastTrackRpcParam = Exact<{
  track?: ?TrackSummary
}>

export type identifyUiReportTrackTokenRpcParam = Exact<{
  trackToken: TrackToken
}>

export type identifyUiStartRpcParam = Exact<{
  username: string,
  reason: IdentifyReason,
  forceDisplay?: boolean
}>

export type kbfsFSEditListRpcParam = Exact<{
  edits?: ?Array<FSNotification>,
  requestID: int
}>

export type kbfsFSEventRpcParam = Exact<{
  event: FSNotification
}>

export type kbfsFSSyncEventRpcParam = Exact<{
  event: FSPathSyncStatus
}>

export type kbfsFSSyncStatusRpcParam = Exact<{
  status: FSSyncStatus,
  requestID: int
}>

export type logRegisterLoggerRpcParam = Exact<{
  name: string,
  level: LogLevel
}>

export type logUiLogRpcParam = Exact<{
  level: LogLevel,
  text: Text
}>

export type loginClearStoredSecretRpcParam = Exact<{
  username: string
}>

export type loginDeprovisionRpcParam = Exact<{
  username: string,
  doRevoke: boolean
}>

export type loginLoginRpcParam = Exact<{
  deviceType: string,
  usernameOrEmail: string,
  clientType: ClientType
}>

export type loginPaperKeySubmitRpcParam = Exact<{
  paperPhrase: string
}>

export type loginPgpProvisionRpcParam = Exact<{
  username: string,
  passphrase: string,
  deviceName: string
}>

export type loginRecoverAccountFromEmailAddressRpcParam = Exact<{
  email: string
}>

export type loginUiDisplayPaperKeyPhraseRpcParam = Exact<{
  phrase: string
}>

export type loginUiDisplayPrimaryPaperKeyRpcParam = Exact<{
  phrase: string
}>

export type loginUiPromptRevokePaperKeysRpcParam = Exact<{
  device: Device,
  index: int
}>

export type loginUnlockWithPassphraseRpcParam = Exact<{
  passphrase: string
}>

export type metadataAuthenticateRpcParam = Exact<{
  signature: string
}>

export type metadataDeleteKeyRpcParam = Exact<{
  uid: UID,
  deviceKID: KID,
  keyHalfID: bytes,
  logTags: {[key: string]: string}
}>

export type metadataGetFolderHandleRpcParam = Exact<{
  folderID: string,
  signature: string,
  challenge: string
}>

export type metadataGetFoldersForRekeyRpcParam = Exact<{
  deviceKID: KID
}>

export type metadataGetKeyBundlesRpcParam = Exact<{
  folderID: string,
  writerBundleID: string,
  readerBundleID: string
}>

export type metadataGetKeyRpcParam = Exact<{
  keyHalfID: bytes,
  deviceKID: string,
  logTags: {[key: string]: string}
}>

export type metadataGetLatestFolderHandleRpcParam = Exact<{
  folderID: string
}>

export type metadataGetMerkleNodeRpcParam = Exact<{
  hash: string
}>

export type metadataGetMerkleRootLatestRpcParam = Exact<{
  treeID: MerkleTreeID
}>

export type metadataGetMerkleRootRpcParam = Exact<{
  treeID: MerkleTreeID,
  seqNo: long
}>

export type metadataGetMerkleRootSinceRpcParam = Exact<{
  treeID: MerkleTreeID,
  when: Time
}>

export type metadataGetMetadataRpcParam = Exact<{
  folderID: string,
  folderHandle: bytes,
  branchID: string,
  unmerged: boolean,
  startRevision: long,
  stopRevision: long,
  logTags: {[key: string]: string}
}>

export type metadataPruneBranchRpcParam = Exact<{
  folderID: string,
  branchID: string,
  logTags: {[key: string]: string}
}>

export type metadataPutKeysRpcParam = Exact<{
  keyHalves?: ?Array<KeyHalf>,
  logTags: {[key: string]: string}
}>

export type metadataPutMetadataRpcParam = Exact<{
  mdBlock: MDBlock,
  readerKeyBundle: KeyBundle,
  writerKeyBundle: KeyBundle,
  logTags: {[key: string]: string}
}>

export type metadataRegisterForUpdatesRpcParam = Exact<{
  folderID: string,
  currRevision: long,
  logTags: {[key: string]: string}
}>

export type metadataTruncateLockRpcParam = Exact<{
  folderID: string
}>

export type metadataTruncateUnlockRpcParam = Exact<{
  folderID: string
}>

export type metadataUpdateFolderNeedsRekeyRpcParam = Exact<{
  folderID: string,
  revision: long
}>

export type metadataUpdateMetadataUpdateRpcParam = Exact<{
  folderID: string,
  revision: long
}>

export type notifyCtlSetNotificationsRpcParam = Exact<{
  channels: NotificationChannels
}>

export type paperprovisionPaperProvisionRpcParam = Exact<{
  username: string,
  deviceName: string,
  paperKey: string
}>

export type pgpPgpDecryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPDecryptOptions
}>

export type pgpPgpEncryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPEncryptOptions
}>

export type pgpPgpExportByFingerprintRpcParam = Exact<{
  options: PGPQuery
}>

export type pgpPgpExportByKIDRpcParam = Exact<{
  options: PGPQuery
}>

export type pgpPgpExportRpcParam = Exact<{
  options: PGPQuery
}>

export type pgpPgpImportRpcParam = Exact<{
  key: bytes,
  pushSecret: boolean
}>

export type pgpPgpKeyGenDefaultRpcParam = Exact<{
  createUids: PGPCreateUids
}>

export type pgpPgpKeyGenRpcParam = Exact<{
  primaryBits: int,
  subkeyBits: int,
  createUids: PGPCreateUids,
  allowMulti: boolean,
  doExport: boolean,
  pushSecret: boolean
}>

export type pgpPgpPullRpcParam = Exact<{
  userAsserts?: ?Array<string>
}>

export type pgpPgpPurgeRpcParam = Exact<{
  doPurge: boolean
}>

export type pgpPgpSelectRpcParam = Exact<{
  fingerprintQuery: string,
  allowMulti: boolean,
  skipImport: boolean,
  onlyImport: boolean
}>

export type pgpPgpSignRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPSignOptions
}>

export type pgpPgpUpdateRpcParam = Exact<{
  all: boolean,
  fingerprints?: ?Array<string>
}>

export type pgpPgpVerifyRpcParam = Exact<{
  source: Stream,
  opts: PGPVerifyOptions
}>

export type pgpUiKeyGeneratedRpcParam = Exact<{
  kid: KID,
  key: KeyInfo
}>

export type pgpUiOutputSignatureSuccessRpcParam = Exact<{
  fingerprint: string,
  username: string,
  signedAt: Time
}>

export type proveCheckProofRpcParam = Exact<{
  sigID: SigID
}>

export type proveStartProofRpcParam = Exact<{
  service: string,
  username: string,
  force: boolean,
  promptPosted: boolean,
  auto: boolean
}>

export type proveUiDisplayRecheckWarningRpcParam = Exact<{
  text: Text
}>

export type proveUiOkToCheckRpcParam = Exact<{
  name: string,
  attempt: int
}>

export type proveUiOutputInstructionsRpcParam = Exact<{
  instructions: Text,
  proof: string
}>

export type proveUiOutputPrechecksRpcParam = Exact<{
  text: Text
}>

export type proveUiPreProofWarningRpcParam = Exact<{
  text: Text
}>

export type proveUiPromptOverwriteRpcParam = Exact<{
  account: string,
  typ: PromptOverwriteType
}>

export type proveUiPromptUsernameRpcParam = Exact<{
  prompt: string,
  prevError?: ?Status
}>

export type provisionUiChooseDeviceRpcParam = Exact<{
  devices?: ?Array<Device>
}>

export type provisionUiChooseDeviceTypeRpcParam = Exact<{
  kind: ChooseType
}>

export type provisionUiChooseGPGMethodRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type provisionUiChooseProvisioningMethodRpcParam = Exact<{
  gpgOption: boolean
}>

export type provisionUiDisplayAndPromptSecretRpcParam = Exact<{
  secret: bytes,
  phrase: string,
  otherDeviceType: DeviceType
}>

export type provisionUiPromptNewDeviceNameRpcParam = Exact<{
  existingDevices?: ?Array<string>,
  errorMessage: string
}>

export type provisionUiProvisioneeSuccessRpcParam = Exact<{
  username: string,
  deviceName: string
}>

export type provisionUiProvisionerSuccessRpcParam = Exact<{
  deviceName: string,
  deviceType: string
}>

export type provisionUiSwitchToGPGSignOKRpcParam = Exact<{
  key: GPGKey,
  importError: string
}>

export type quotaVerifySessionRpcParam = Exact<{
  session: string
}>

export type rekeyGetRevokeWarningRpcParam = Exact<{
  session: int,
  actingDevice: DeviceID,
  targetDevice: DeviceID
}>

export type rekeyRekeySyncRpcParam = Exact<{
  force: boolean
}>

export type rekeyUIRefreshRpcParam = Exact<{
  problemSetDevices: ProblemSetDevices
}>

export type rekeyUIRekeySendEventRpcParam = Exact<{
  event: RekeyEvent
}>

export type revokeRevokeDeviceRpcParam = Exact<{
  deviceID: DeviceID,
  force: boolean
}>

export type revokeRevokeKeyRpcParam = Exact<{
  keyID: KID
}>

export type revokeRevokeSigsRpcParam = Exact<{
  sigIDQueries?: ?Array<string>
}>

export type saltpackSaltpackDecryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackDecryptOptions
}>

export type saltpackSaltpackEncryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackEncryptOptions
}>

export type saltpackSaltpackSignRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackSignOptions
}>

export type saltpackSaltpackVerifyRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackVerifyOptions
}>

export type saltpackUiSaltpackPromptForDecryptRpcParam = Exact<{
  sender: SaltpackSender,
  usedDelegateUI: boolean
}>

export type saltpackUiSaltpackVerifySuccessRpcParam = Exact<{
  signingKID: KID,
  sender: SaltpackSender
}>

export type secretUiGetPassphraseRpcParam = Exact<{
  pinentry: GUIEntryArg,
  terminal?: ?SecretEntryArg
}>

export type signupCheckInvitationCodeRpcParam = Exact<{
  invitationCode: string
}>

export type signupCheckUsernameAvailableRpcParam = Exact<{
  username: string
}>

export type signupInviteRequestRpcParam = Exact<{
  email: string,
  fullname: string,
  notes: string
}>

export type signupSignupRpcParam = Exact<{
  email: string,
  inviteCode: string,
  passphrase: string,
  username: string,
  deviceName: string,
  deviceType: DeviceType,
  storeSecret: boolean,
  skipMail: boolean,
  genPGPBatch: boolean
}>

export type sigsSigListJSONRpcParam = Exact<{
  arg: SigListArgs
}>

export type sigsSigListRpcParam = Exact<{
  arg: SigListArgs
}>

export type streamUiCloseRpcParam = Exact<{
  s: Stream
}>

export type streamUiReadRpcParam = Exact<{
  s: Stream,
  sz: int
}>

export type streamUiWriteRpcParam = Exact<{
  s: Stream,
  buf: bytes
}>

export type testPanicRpcParam = Exact<{
  message: string
}>

export type testTestCallbackRpcParam = Exact<{
  name: string
}>

export type testTestRpcParam = Exact<{
  name: string
}>

export type tlfCompleteAndCanonicalizePrivateTlfNameRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfCryptKeysRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfKeysGetTLFCryptKeysRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfPublicCanonicalTLFNameAndIDRpcParam = Exact<{
  query: TLFQuery
}>

export type trackDismissWithTokenRpcParam = Exact<{
  trackToken: TrackToken
}>

export type trackFakeTrackingChangedRpcParam = Exact<{
  username: string
}>

export type trackTrackRpcParam = Exact<{
  userAssertion: string,
  options: TrackOptions,
  forceRemoteCheck: boolean
}>

export type trackTrackWithTokenRpcParam = Exact<{
  trackToken: TrackToken,
  options: TrackOptions
}>

export type trackUntrackRpcParam = Exact<{
  username: string
}>

export type uiPromptYesNoRpcParam = Exact<{
  text: Text,
  promptDefault: PromptDefault
}>

export type userListTrackers2RpcParam = Exact<{
  assertion: string,
  reverse: boolean
}>

export type userListTrackersByNameRpcParam = Exact<{
  username: string
}>

export type userListTrackersRpcParam = Exact<{
  uid: UID
}>

export type userListTrackingJSONRpcParam = Exact<{
  filter: string,
  verbose: boolean,
  assertion: string
}>

export type userListTrackingRpcParam = Exact<{
  filter: string,
  assertion: string
}>

export type userLoadAllPublicKeysUnverifiedRpcParam = Exact<{
  uid: UID
}>

export type userLoadPublicKeysRpcParam = Exact<{
  uid: UID
}>

export type userLoadUncheckedUserSummariesRpcParam = Exact<{
  uids?: ?Array<UID>
}>

export type userLoadUserByNameRpcParam = Exact<{
  username: string
}>

export type userLoadUserPlusKeysRpcParam = Exact<{
  uid: UID
}>

export type userLoadUserRpcParam = Exact<{
  uid: UID
}>

export type userSearchRpcParam = Exact<{
  query: string
}>

type Kex2Provisionee2Hello2Result = Hello2Res

type Kex2ProvisioneeHelloResult = HelloRes

type SecretKeysGetSecretKeysResult = SecretKeys

type accountHasServerKeysResult = HasServerKeysRes

type accountPassphrasePromptResult = GetPassphraseRes

type apiserverGetResult = APIRes

type apiserverPostJSONResult = APIRes

type apiserverPostResult = APIRes

type blockArchiveReferenceResult = ?Array<BlockReference>

type blockArchiveReferenceWithCountResult = DowngradeReferenceRes

type blockDelReferenceWithCountResult = DowngradeReferenceRes

type blockGetBlockResult = GetBlockRes

type blockGetSessionChallengeResult = ChallengeInfo

type blockGetUserQuotaInfoResult = bytes

type configCheckAPIServerOutOfDateWarningResult = OutOfDateInfo

type configGetConfigResult = Config

type configGetCurrentStatusResult = GetCurrentStatusRes

type configGetExtendedStatusResult = ExtendedStatus

type configGetValueResult = ConfigValue

type cryptoSignED25519Result = ED25519SignatureInfo

type cryptoSignToStringResult = string

type cryptoUnboxBytes32AnyResult = UnboxAnyRes

type cryptoUnboxBytes32Result = Bytes32

type debuggingFirstStepResult = FirstStepResult

type debuggingIncrementResult = int

type debuggingSecondStepResult = int

type deviceCheckDeviceNameFormatResult = boolean

type deviceDeviceHistoryListResult = ?Array<DeviceDetail>

type deviceDeviceListResult = ?Array<Device>

type favoriteGetFavoritesResult = FavoritesResult

type fsListResult = ListResult

type gpgUiConfirmDuplicateKeyChosenResult = boolean

type gpgUiGetTTYResult = string

type gpgUiSelectKeyAndPushOptionResult = SelectKeyRes

type gpgUiSelectKeyResult = string

type gpgUiSignResult = string

type gpgUiWantToAddGPGKeyResult = boolean

type gregorGetStateResult = gregor1.State

type identifyIdentify2Result = Identify2Res

type identifyIdentifyResult = IdentifyRes

type identifyResolve2Result = User

type identifyResolveResult = UID

type identifyUiConfirmResult = ConfirmResult

type identifyUiDelegateIdentifyUIResult = int

type loginGetConfiguredAccountsResult = ?Array<ConfiguredAccount>

type loginUiGetEmailOrUsernameResult = string

type loginUiPromptRevokePaperKeysResult = boolean

type metadataAuthenticateResult = int

type metadataGetChallengeResult = ChallengeInfo

type metadataGetFolderHandleResult = bytes

type metadataGetKeyBundlesResult = KeyBundleResponse

type metadataGetKeyResult = bytes

type metadataGetLatestFolderHandleResult = bytes

type metadataGetMerkleNodeResult = bytes

type metadataGetMerkleRootLatestResult = MerkleRoot

type metadataGetMerkleRootResult = MerkleRoot

type metadataGetMerkleRootSinceResult = MerkleRoot

type metadataGetMetadataResult = MetadataResponse

type metadataPing2Result = PingResponse

type metadataTruncateLockResult = boolean

type metadataTruncateUnlockResult = boolean

type pgpPgpDecryptResult = PGPSigVerification

type pgpPgpExportByFingerprintResult = ?Array<KeyInfo>

type pgpPgpExportByKIDResult = ?Array<KeyInfo>

type pgpPgpExportResult = ?Array<KeyInfo>

type pgpPgpPurgeResult = PGPPurgeRes

type pgpPgpVerifyResult = PGPSigVerification

type pgpUiShouldPushPrivateResult = boolean

type proveCheckProofResult = CheckProofStatus

type proveStartProofResult = StartProofResult

type proveUiOkToCheckResult = boolean

type proveUiPreProofWarningResult = boolean

type proveUiPromptOverwriteResult = boolean

type proveUiPromptUsernameResult = string

type provisionUiChooseDeviceResult = DeviceID

type provisionUiChooseDeviceTypeResult = DeviceType

type provisionUiChooseGPGMethodResult = GPGMethod

type provisionUiChooseProvisioningMethodResult = ProvisionMethod

type provisionUiDisplayAndPromptSecretResult = SecretResponse

type provisionUiPromptNewDeviceNameResult = string

type provisionUiSwitchToGPGSignOKResult = boolean

type quotaVerifySessionResult = VerifySessionRes

type rekeyGetPendingRekeyStatusResult = ProblemSetDevices

type rekeyGetRevokeWarningResult = RevokeWarning

type rekeyRekeyStatusFinishResult = Outcome

type rekeyUIDelegateRekeyUIResult = int

type saltpackSaltpackDecryptResult = SaltpackEncryptedMessageInfo

type secretUiGetPassphraseResult = GetPassphraseRes

type sessionCurrentSessionResult = Session

type signupSignupResult = SignupRes

type sigsSigListJSONResult = string

type sigsSigListResult = ?Array<Sig>

type streamUiReadResult = bytes

type streamUiWriteResult = int

type testTestCallbackResult = string

type testTestResult = Test

type tlfCompleteAndCanonicalizePrivateTlfNameResult = CanonicalTLFNameAndIDWithBreaks

type tlfCryptKeysResult = GetTLFCryptKeysRes

type tlfKeysGetPublicCanonicalTLFNameAndIDResult = CanonicalTLFNameAndIDWithBreaks

type tlfKeysGetTLFCryptKeysResult = GetTLFCryptKeysRes

type tlfPublicCanonicalTLFNameAndIDResult = CanonicalTLFNameAndIDWithBreaks

type uiPromptYesNoResult = boolean

type userListTrackers2Result = UserSummary2Set

type userListTrackersByNameResult = ?Array<Tracker>

type userListTrackersResult = ?Array<Tracker>

type userListTrackersSelfResult = ?Array<Tracker>

type userListTrackingJSONResult = string

type userListTrackingResult = ?Array<UserSummary>

type userLoadAllPublicKeysUnverifiedResult = ?Array<PublicKey>

type userLoadMyPublicKeysResult = ?Array<PublicKey>

type userLoadPublicKeysResult = ?Array<PublicKey>

type userLoadUncheckedUserSummariesResult = ?Array<UserSummary>

type userLoadUserByNameResult = User

type userLoadUserPlusKeysResult = UserPlusKeys

type userLoadUserResult = User

type userSearchResult = ?Array<SearchResult>

export type rpc =
    BTCRegisterBTCRpc
  | Kex2Provisionee2DidCounterSign2Rpc
  | Kex2Provisionee2Hello2Rpc
  | Kex2ProvisioneeDidCounterSignRpc
  | Kex2ProvisioneeHelloRpc
  | Kex2ProvisionerKexStartRpc
  | ScanProofsScanProofsRpc
  | SecretKeysGetSecretKeysRpc
  | accountEmailChangeRpc
  | accountHasServerKeysRpc
  | accountPassphraseChangeRpc
  | accountPassphrasePromptRpc
  | apiserverGetRpc
  | apiserverPostJSONRpc
  | apiserverPostRpc
  | blockAddReferenceRpc
  | blockArchiveReferenceRpc
  | blockArchiveReferenceWithCountRpc
  | blockAuthenticateSessionRpc
  | blockDelReferenceRpc
  | blockDelReferenceWithCountRpc
  | blockGetBlockRpc
  | blockGetSessionChallengeRpc
  | blockGetUserQuotaInfoRpc
  | blockPutBlockRpc
  | configCheckAPIServerOutOfDateWarningRpc
  | configClearValueRpc
  | configGetConfigRpc
  | configGetCurrentStatusRpc
  | configGetExtendedStatusRpc
  | configGetValueRpc
  | configHelloIAmRpc
  | configSetPathRpc
  | configSetUserConfigRpc
  | configSetValueRpc
  | cryptoSignED25519Rpc
  | cryptoSignToStringRpc
  | cryptoUnboxBytes32AnyRpc
  | cryptoUnboxBytes32Rpc
  | ctlAppExitRpc
  | ctlDbNukeRpc
  | ctlLogRotateRpc
  | ctlReloadRpc
  | ctlStopRpc
  | debuggingFirstStepRpc
  | debuggingIncrementRpc
  | debuggingSecondStepRpc
  | delegateUiCtlRegisterGregorFirehoseRpc
  | delegateUiCtlRegisterIdentifyUIRpc
  | delegateUiCtlRegisterRekeyUIRpc
  | delegateUiCtlRegisterSecretUIRpc
  | delegateUiCtlRegisterUpdateUIRpc
  | deviceCheckDeviceNameForUserRpc
  | deviceCheckDeviceNameFormatRpc
  | deviceDeviceAddRpc
  | deviceDeviceHistoryListRpc
  | deviceDeviceListRpc
  | favoriteFavoriteAddRpc
  | favoriteFavoriteIgnoreRpc
  | favoriteGetFavoritesRpc
  | fsListRpc
  | gregorGetStateRpc
  | identifyIdentify2Rpc
  | identifyIdentifyRpc
  | identifyResolve2Rpc
  | identifyResolveRpc
  | kbfsFSEditListRpc
  | kbfsFSEventRpc
  | kbfsFSSyncEventRpc
  | kbfsFSSyncStatusRpc
  | logRegisterLoggerRpc
  | loginAccountDeleteRpc
  | loginClearStoredSecretRpc
  | loginDeprovisionRpc
  | loginGetConfiguredAccountsRpc
  | loginLoginRpc
  | loginLogoutRpc
  | loginPaperKeyRpc
  | loginPaperKeySubmitRpc
  | loginPgpProvisionRpc
  | loginRecoverAccountFromEmailAddressRpc
  | loginUnlockRpc
  | loginUnlockWithPassphraseRpc
  | metadataAuthenticateRpc
  | metadataDeleteKeyRpc
  | metadataGetChallengeRpc
  | metadataGetFolderHandleRpc
  | metadataGetFoldersForRekeyRpc
  | metadataGetKeyBundlesRpc
  | metadataGetKeyRpc
  | metadataGetLatestFolderHandleRpc
  | metadataGetMerkleNodeRpc
  | metadataGetMerkleRootLatestRpc
  | metadataGetMerkleRootRpc
  | metadataGetMerkleRootSinceRpc
  | metadataGetMetadataRpc
  | metadataPing2Rpc
  | metadataPingRpc
  | metadataPruneBranchRpc
  | metadataPutKeysRpc
  | metadataPutMetadataRpc
  | metadataRegisterForUpdatesRpc
  | metadataTruncateLockRpc
  | metadataTruncateUnlockRpc
  | metadataUpdateFolderNeedsRekeyRpc
  | metadataUpdateMetadataUpdateRpc
  | notifyCtlSetNotificationsRpc
  | paperprovisionPaperProvisionRpc
  | pgpPgpDecryptRpc
  | pgpPgpDeletePrimaryRpc
  | pgpPgpEncryptRpc
  | pgpPgpExportByFingerprintRpc
  | pgpPgpExportByKIDRpc
  | pgpPgpExportRpc
  | pgpPgpImportRpc
  | pgpPgpKeyGenDefaultRpc
  | pgpPgpKeyGenRpc
  | pgpPgpPullRpc
  | pgpPgpPurgeRpc
  | pgpPgpSelectRpc
  | pgpPgpSignRpc
  | pgpPgpStorageDismissRpc
  | pgpPgpUpdateRpc
  | pgpPgpVerifyRpc
  | proveCheckProofRpc
  | proveStartProofRpc
  | quotaVerifySessionRpc
  | rekeyDebugShowRekeyStatusRpc
  | rekeyGetPendingRekeyStatusRpc
  | rekeyGetRevokeWarningRpc
  | rekeyRekeyStatusFinishRpc
  | rekeyRekeySyncRpc
  | rekeyShowPendingRekeyStatusRpc
  | revokeRevokeDeviceRpc
  | revokeRevokeKeyRpc
  | revokeRevokeSigsRpc
  | saltpackSaltpackDecryptRpc
  | saltpackSaltpackEncryptRpc
  | saltpackSaltpackSignRpc
  | saltpackSaltpackVerifyRpc
  | sessionCurrentSessionRpc
  | signupCheckInvitationCodeRpc
  | signupCheckUsernameAvailableRpc
  | signupInviteRequestRpc
  | signupSignupRpc
  | sigsSigListJSONRpc
  | sigsSigListRpc
  | testPanicRpc
  | testTestCallbackRpc
  | testTestRpc
  | tlfCompleteAndCanonicalizePrivateTlfNameRpc
  | tlfCryptKeysRpc
  | tlfKeysGetPublicCanonicalTLFNameAndIDRpc
  | tlfKeysGetTLFCryptKeysRpc
  | tlfPublicCanonicalTLFNameAndIDRpc
  | trackCheckTrackingRpc
  | trackDismissWithTokenRpc
  | trackFakeTrackingChangedRpc
  | trackTrackRpc
  | trackTrackWithTokenRpc
  | trackUntrackRpc
  | userListTrackers2Rpc
  | userListTrackersByNameRpc
  | userListTrackersRpc
  | userListTrackersSelfRpc
  | userListTrackingJSONRpc
  | userListTrackingRpc
  | userLoadAllPublicKeysUnverifiedRpc
  | userLoadMyPublicKeysRpc
  | userLoadPublicKeysRpc
  | userLoadUncheckedUserSummariesRpc
  | userLoadUserByNameRpc
  | userLoadUserPlusKeysRpc
  | userLoadUserRpc
  | userSearchRpc
export type incomingCallMapType = Exact<{
  'keybase.1.gpgUi.wantToAddGPGKey'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiWantToAddGPGKeyResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.confirmDuplicateKeyChosen'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiConfirmDuplicateKeyChosenResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.selectKeyAndPushOption'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSelectKeyAndPushOptionResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.selectKey'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSelectKeyResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.sign'?: (
    params: Exact<{
      msg: bytes,
      fingerprint: bytes
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSignResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.getTTY'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiGetTTYResult) => void,
    }
  ) => void,
  'keybase.1.gregorUI.pushState'?: (
    params: Exact<{
      state: gregor1.State,
      reason: PushReason
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.gregorUI.pushOutOfBandMessages'?: (
    params: Exact<{
      oobm?: ?Array<gregor1.OutOfBandMessage>
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayTLFCreateWithInvite'?: (
    params: Exact<{
      sessionID: int,
      folderName: string,
      isPrivate: boolean,
      assertion: string,
      socialAssertion: SocialAssertion,
      inviteLink: string,
      throttled: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.delegateIdentifyUI'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: identifyUiDelegateIdentifyUIResult) => void,
    }
  ) => void,
  'keybase.1.identifyUi.start'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      reason: IdentifyReason,
      forceDisplay?: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayKey'?: (
    params: Exact<{
      sessionID: int,
      key: IdentifyKey
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.reportLastTrack'?: (
    params: Exact<{
      sessionID: int,
      track?: ?TrackSummary
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.launchNetworkChecks'?: (
    params: Exact<{
      sessionID: int,
      identity: Identity,
      user: User
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayTrackStatement'?: (
    params: Exact<{
      sessionID: int,
      stmt: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finishWebProofCheck'?: (
    params: Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finishSocialProofCheck'?: (
    params: Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayCryptocurrency'?: (
    params: Exact<{
      sessionID: int,
      c: Cryptocurrency
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.reportTrackToken'?: (
    params: Exact<{
      sessionID: int,
      trackToken: TrackToken
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayUserCard'?: (
    params: Exact<{
      sessionID: int,
      card: UserCard
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.confirm'?: (
    params: Exact<{
      sessionID: int,
      outcome: IdentifyOutcome
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: identifyUiConfirmResult) => void,
    }
  ) => void,
  'keybase.1.identifyUi.cancel'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finish'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.dismiss'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      reason: DismissReason
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.logUi.log'?: (
    params: Exact<{
      sessionID: int,
      level: LogLevel,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.loginUi.getEmailOrUsername'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: loginUiGetEmailOrUsernameResult) => void,
    }
  ) => void,
  'keybase.1.loginUi.promptRevokePaperKeys'?: (
    params: Exact<{
      sessionID: int,
      device: Device,
      index: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: loginUiPromptRevokePaperKeysResult) => void,
    }
  ) => void,
  'keybase.1.loginUi.displayPaperKeyPhrase'?: (
    params: Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.loginUi.displayPrimaryPaperKey'?: (
    params: Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyApp.exit'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFavorites.favoritesChanged'?: (
    params: Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFS.FSActivity'?: (
    params: Exact<{
      notification: FSNotification
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFS.FSSyncActivity'?: (
    params: Exact<{
      status: FSPathSyncStatus
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFS.FSEditListResponse'?: (
    params: Exact<{
      edits?: ?Array<FSNotification>,
      requestID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFS.FSSyncStatusResponse'?: (
    params: Exact<{
      status: FSSyncStatus,
      requestID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFSRequest.FSEditListRequest'?: (
    params: Exact<{
      req: FSEditListRequest
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFSRequest.FSSyncStatusRequest'?: (
    params: Exact<{
      req: FSSyncStatusRequest
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyKeyfamily.keyfamilyChanged'?: (
    params: Exact<{
      uid: UID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyPaperKey.paperKeyCached'?: (
    params: Exact<{
      uid: UID,
      encKID: KID,
      sigKID: KID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyPGP.pgpKeyInSecretStoreFile'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyService.shutdown'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifySession.loggedOut'?: (
    params: Exact<{}> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifySession.loggedIn'?: (
    params: Exact<{
      username: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifySession.clientOutOfDate'?: (
    params: Exact<{
      upgradeTo: string,
      upgradeURI: string,
      upgradeMsg: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyTracking.trackingChanged'?: (
    params: Exact<{
      uid: UID,
      username: string
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyUsers.userChanged'?: (
    params: Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.pgpUi.outputSignatureSuccess'?: (
    params: Exact<{
      sessionID: int,
      fingerprint: string,
      username: string,
      signedAt: Time
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.pgpUi.keyGenerated'?: (
    params: Exact<{
      sessionID: int,
      kid: KID,
      key: KeyInfo
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.pgpUi.shouldPushPrivate'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: pgpUiShouldPushPrivateResult) => void,
    }
  ) => void,
  'keybase.1.pgpUi.finished'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.promptOverwrite'?: (
    params: Exact<{
      sessionID: int,
      account: string,
      typ: PromptOverwriteType
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPromptOverwriteResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.promptUsername'?: (
    params: Exact<{
      sessionID: int,
      prompt: string,
      prevError?: ?Status
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPromptUsernameResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.outputPrechecks'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.preProofWarning'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPreProofWarningResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.outputInstructions'?: (
    params: Exact<{
      sessionID: int,
      instructions: Text,
      proof: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.okToCheck'?: (
    params: Exact<{
      sessionID: int,
      name: string,
      attempt: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiOkToCheckResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.displayRecheckWarning'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.chooseProvisioningMethod'?: (
    params: Exact<{
      sessionID: int,
      gpgOption: boolean
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseProvisioningMethodResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseGPGMethod'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseGPGMethodResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.switchToGPGSignOK'?: (
    params: Exact<{
      sessionID: int,
      key: GPGKey,
      importError: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiSwitchToGPGSignOKResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseDevice'?: (
    params: Exact<{
      sessionID: int,
      devices?: ?Array<Device>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseDeviceResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseDeviceType'?: (
    params: Exact<{
      sessionID: int,
      kind: ChooseType
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseDeviceTypeResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.DisplayAndPromptSecret'?: (
    params: Exact<{
      sessionID: int,
      secret: bytes,
      phrase: string,
      otherDeviceType: DeviceType
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiDisplayAndPromptSecretResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.DisplaySecretExchanged'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.PromptNewDeviceName'?: (
    params: Exact<{
      sessionID: int,
      existingDevices?: ?Array<string>,
      errorMessage: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiPromptNewDeviceNameResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.ProvisioneeSuccess'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      deviceName: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.ProvisionerSuccess'?: (
    params: Exact<{
      sessionID: int,
      deviceName: string,
      deviceType: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.rekeyUI.delegateRekeyUI'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: rekeyUIDelegateRekeyUIResult) => void,
    }
  ) => void,
  'keybase.1.rekeyUI.refresh'?: (
    params: Exact<{
      sessionID: int,
      problemSetDevices: ProblemSetDevices
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.rekeyUI.rekeySendEvent'?: (
    params: Exact<{
      sessionID: int,
      event: RekeyEvent
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.saltpackUi.saltpackPromptForDecrypt'?: (
    params: Exact<{
      sessionID: int,
      sender: SaltpackSender,
      usedDelegateUI: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.saltpackUi.saltpackVerifySuccess'?: (
    params: Exact<{
      sessionID: int,
      signingKID: KID,
      sender: SaltpackSender
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.secretUi.getPassphrase'?: (
    params: Exact<{
      sessionID: int,
      pinentry: GUIEntryArg,
      terminal?: ?SecretEntryArg
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: secretUiGetPassphraseResult) => void,
    }
  ) => void,
  'keybase.1.streamUi.close'?: (
    params: Exact<{
      sessionID: int,
      s: Stream
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.streamUi.read'?: (
    params: Exact<{
      sessionID: int,
      s: Stream,
      sz: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: streamUiReadResult) => void,
    }
  ) => void,
  'keybase.1.streamUi.write'?: (
    params: Exact<{
      sessionID: int,
      s: Stream,
      buf: bytes
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: streamUiWriteResult) => void,
    }
  ) => void,
  'keybase.1.ui.promptYesNo'?: (
    params: Exact<{
      sessionID: int,
      text: Text,
      promptDefault: PromptDefault
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: uiPromptYesNoResult) => void,
    }
  ) => void
}>
