  // This file is autogenerated
  #import "KBRObject.h"
  #import "KBRRequest.h"
  #import "KBRRequestParams.h"

@interface KBRFeature : KBRObject
@property BOOL allow;
@property BOOL defaultValue;
@property BOOL readonly;
@property NSString *label;
@end

@interface KBRGUIEntryFeatures : KBRObject
@property KBRFeature *storeSecret;
@property KBRFeature *showTyping;
@end

@interface KBRGUIEntryArg : KBRObject
@property NSString *windowTitle;
@property NSString *prompt;
@property NSString *submitLabel;
@property NSString *cancelLabel;
@property NSString *retryLabel;
@property KBRGUIEntryFeatures *features;
@end

@interface KBRGetPassphraseRes : KBRObject
@property NSString *passphrase;
@property BOOL storeSecret;
@end

@interface KBRStringKVPair : KBRObject
@property NSString *key;
@property NSString *value;
@end

@interface KBRStatus : KBRObject
@property NSInteger code;
@property NSString *name;
@property NSString *desc;
@property NSArray *fields; /*of KBRStringKVPair*/
@end

@interface KBRText : KBRObject
@property NSString *data;
@property BOOL markup;
@end

@interface KBRPGPIdentity : KBRObject
@property NSString *username;
@property NSString *comment;
@property NSString *email;
@end

@interface KBRPublicKey : KBRObject
@property NSString *KID;
@property NSString *PGPFingerprint;
@property NSArray *PGPIdentities; /*of KBRPGPIdentity*/
@property BOOL isSibkey;
@property BOOL isEldest;
@property NSString *parentID;
@property NSString *deviceID;
@property NSString *deviceDescription;
@property NSString *deviceType;
@property long cTime;
@property long eTime;
@end

@interface KBRUser : KBRObject
@property NSString *uid;
@property NSString *username;
@end

@interface KBRDevice : KBRObject
@property NSString *type;
@property NSString *name;
@property NSString *deviceID;
@property long cTime;
@property long mTime;
@property NSString *encryptKey;
@property NSString *verifyKey;
@end

@interface KBRStream : KBRObject
@property NSInteger fd;
@end

typedef NS_ENUM (NSInteger, KBRLogLevel) {
	KBRLogLevelNone = 0,
	KBRLogLevelDebug = 1,
	KBRLogLevelInfo = 2,
	KBRLogLevelNotice = 3,
	KBRLogLevelWarn = 4,
	KBRLogLevelError = 5,
	KBRLogLevelCritical = 6,
	KBRLogLevelFatal = 7,
};

typedef NS_ENUM (NSInteger, KBRClientType) {
	KBRClientTypeCli = 0,
	KBRClientTypeGui = 1,
};

@interface KBRUserVersionVector : KBRObject
@property long id;
@property NSInteger sigHints;
@property long sigChain;
@property long cachedAt;
@property long lastIdentifiedAt;
@end

@interface KBRUserPlusKeys : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSArray *deviceKeys; /*of KBRPublicKey*/
@property NSArray *keys; /*of KBRPublicKey*/
@property KBRUserVersionVector *uvv;
@end

@interface KBRBlockIdCombo : KBRObject
@property NSString *blockHash;
@property NSString *chargedTo;
@end

@interface KBRGetBlockRes : KBRObject
@property NSString *blockKey;
@property NSData *buf;
@end

@interface KBRBlockReference : KBRObject
@property KBRBlockIdCombo *bid;
@property NSData *nonce;
@property NSString *chargedTo;
@end

@interface KBRGetCurrentStatusRes : KBRObject
@property BOOL configured;
@property BOOL registered;
@property BOOL loggedIn;
@property KBRUser *user;
@end

typedef NS_ENUM (NSInteger, KBRForkType) {
	KBRForkTypeNone = 0,
	KBRForkTypeAuto = 1,
	KBRForkTypeWatchdog = 2,
	KBRForkTypeLaunchd = 3,
};

@interface KBRConfig : KBRObject
@property NSString *serverURI;
@property NSString *socketFile;
@property NSString *label;
@property NSString *runMode;
@property BOOL gpgExists;
@property NSString *gpgPath;
@property NSString *version;
@property NSString *path;
@property NSString *configPath;
@property NSString *versionShort;
@property NSString *versionFull;
@property BOOL isAutoForked;
@property KBRForkType forkType;
@end

typedef NS_ENUM (NSInteger, KBRStatusCode) {
	KBRStatusCodeScok = 0,
	KBRStatusCodeScloginrequired = 201,
	KBRStatusCodeScbadsession = 202,
	KBRStatusCodeScbadloginusernotfound = 203,
	KBRStatusCodeScbadloginpassword = 204,
	KBRStatusCodeScnotfound = 205,
	KBRStatusCodeScgeneric = 218,
	KBRStatusCodeScalreadyloggedin = 235,
	KBRStatusCodeSccanceled = 237,
	KBRStatusCodeScinputcanceled = 238,
	KBRStatusCodeScreloginrequired = 274,
	KBRStatusCodeScresolutionfailed = 275,
	KBRStatusCodeScprofilenotpublic = 276,
	KBRStatusCodeScidentifyfailed = 277,
	KBRStatusCodeSctrackingbroke = 278,
	KBRStatusCodeScwrongcryptoformat = 279,
	KBRStatusCodeScbadsignupusernametaken = 701,
	KBRStatusCodeScmissingresult = 801,
	KBRStatusCodeSckeynotfound = 901,
	KBRStatusCodeSckeyinuse = 907,
	KBRStatusCodeSckeybadgen = 913,
	KBRStatusCodeSckeynosecret = 914,
	KBRStatusCodeSckeybaduids = 915,
	KBRStatusCodeSckeynoactive = 916,
	KBRStatusCodeSckeynosig = 917,
	KBRStatusCodeSckeybadsig = 918,
	KBRStatusCodeSckeybadeldest = 919,
	KBRStatusCodeSckeynoeldest = 920,
	KBRStatusCodeSckeyduplicateupdate = 921,
	KBRStatusCodeScsibkeyalreadyexists = 922,
	KBRStatusCodeScdecryptionkeynotfound = 924,
	KBRStatusCodeSckeynopgpencryption = 927,
	KBRStatusCodeSckeynonaclencryption = 928,
	KBRStatusCodeSckeysyncedpgpnotfound = 929,
	KBRStatusCodeScbadtracksession = 1301,
	KBRStatusCodeScdevicenotfound = 1409,
	KBRStatusCodeScdevicemismatch = 1410,
	KBRStatusCodeScdevicerequired = 1411,
	KBRStatusCodeScstreamexists = 1501,
	KBRStatusCodeScstreamnotfound = 1502,
	KBRStatusCodeScstreamwrongkind = 1503,
	KBRStatusCodeScstreameof = 1504,
	KBRStatusCodeScapinetworkerror = 1601,
	KBRStatusCodeSctimeout = 1602,
	KBRStatusCodeScprooferror = 1701,
	KBRStatusCodeScidentificationexpired = 1702,
	KBRStatusCodeScselfnotfound = 1703,
	KBRStatusCodeScbadkexphrase = 1704,
	KBRStatusCodeScnouidelegation = 1705,
	KBRStatusCodeScinvalidversionerror = 1800,
	KBRStatusCodeScoldversionerror = 1801,
	KBRStatusCodeScinvalidlocationerror = 1802,
	KBRStatusCodeScservicestatuserror = 1803,
	KBRStatusCodeScinstallerror = 1804,
};

@interface KBRED25519SignatureInfo : KBRObject
@property NSData *sig;
@property NSData *publicKey;
@end

typedef NS_ENUM (NSInteger, KBRExitCode) {
	KBRExitCodeOk = 0,
	KBRExitCodeNotok = 2,
	KBRExitCodeRestart = 4,
};

@interface KBRFirstStepResult : KBRObject
@property NSInteger valPlusTwo;
@end

@interface KBRFolder : KBRObject
@property NSString *name;
@property BOOL private;
@property BOOL notificationsOn;
@end

@interface KBRGPGKey : KBRObject
@property NSString *algorithm;
@property NSString *keyID;
@property NSString *creation;
@property NSString *expiration;
@property NSArray *identities; /*of KBRPGPIdentity*/
@end

@interface KBRSelectKeyRes : KBRObject
@property NSString *keyID;
@property BOOL doSecretPush;
@end

typedef NS_ENUM (NSInteger, KBRProofState) {
	KBRProofStateNone = 0,
	KBRProofStateOk = 1,
	KBRProofStateTempFailure = 2,
	KBRProofStatePermFailure = 3,
	KBRProofStateLooking = 4,
	KBRProofStateSuperseded = 5,
	KBRProofStatePosted = 6,
	KBRProofStateRevoked = 7,
};

typedef NS_ENUM (NSInteger, KBRProofStatus) {
	KBRProofStatusNone = 0,
	KBRProofStatusOk = 1,
	KBRProofStatusLocal = 2,
	KBRProofStatusFound = 3,
	KBRProofStatusBaseError = 100,
	KBRProofStatusHostUnreachable = 101,
	KBRProofStatusPermissionDenied = 103,
	KBRProofStatusFailedParse = 106,
	KBRProofStatusDnsError = 107,
	KBRProofStatusAuthFailed = 108,
	KBRProofStatusHttp500 = 150,
	KBRProofStatusTimeout = 160,
	KBRProofStatusInternalError = 170,
	KBRProofStatusBaseHardError = 200,
	KBRProofStatusNotFound = 201,
	KBRProofStatusContentFailure = 202,
	KBRProofStatusBadUsername = 203,
	KBRProofStatusBadRemoteId = 204,
	KBRProofStatusTextNotFound = 205,
	KBRProofStatusBadArgs = 206,
	KBRProofStatusContentMissing = 207,
	KBRProofStatusTitleNotFound = 208,
	KBRProofStatusServiceError = 209,
	KBRProofStatusTorSkipped = 210,
	KBRProofStatusTorIncompatible = 211,
	KBRProofStatusHttp300 = 230,
	KBRProofStatusHttp400 = 240,
	KBRProofStatusHttpOther = 260,
	KBRProofStatusEmptyJson = 270,
	KBRProofStatusDeleted = 301,
	KBRProofStatusServiceDead = 302,
	KBRProofStatusBadSignature = 303,
	KBRProofStatusBadApiUrl = 304,
	KBRProofStatusUnknownType = 305,
	KBRProofStatusNoHint = 306,
	KBRProofStatusBadHintText = 307,
};

typedef NS_ENUM (NSInteger, KBRProofType) {
	KBRProofTypeNone = 0,
	KBRProofTypeKeybase = 1,
	KBRProofTypeTwitter = 2,
	KBRProofTypeGithub = 3,
	KBRProofTypeReddit = 4,
	KBRProofTypeCoinbase = 5,
	KBRProofTypeHackernews = 6,
	KBRProofTypeGenericWebSite = 1000,
	KBRProofTypeDns = 1001,
	KBRProofTypeRooter = 100001,
};

typedef NS_ENUM (NSInteger, KBRTrackDiffType) {
	KBRTrackDiffTypeNone = 0,
	KBRTrackDiffTypeError = 1,
	KBRTrackDiffTypeClash = 2,
	KBRTrackDiffTypeRevoked = 3,
	KBRTrackDiffTypeUpgraded = 4,
	KBRTrackDiffTypeNew = 5,
	KBRTrackDiffTypeRemoteFail = 6,
	KBRTrackDiffTypeRemoteWorking = 7,
	KBRTrackDiffTypeRemoteChanged = 8,
	KBRTrackDiffTypeNewEldest = 9,
};

@interface KBRTrackDiff : KBRObject
@property KBRTrackDiffType type;
@property NSString *displayMarkup;
@end

@interface KBRTrackSummary : KBRObject
@property NSString *username;
@property long time;
@property BOOL isRemote;
@end

typedef NS_ENUM (NSInteger, KBRTrackStatus) {
	KBRTrackStatusNewOk = 1,
	KBRTrackStatusNewZeroProofs = 2,
	KBRTrackStatusNewFailProofs = 3,
	KBRTrackStatusUpdateBroken = 4,
	KBRTrackStatusUpdateNewProofs = 5,
	KBRTrackStatusUpdateOk = 6,
};

@interface KBRTrackOptions : KBRObject
@property BOOL localOnly;
@property BOOL bypassConfirm;
@end

typedef NS_ENUM (NSInteger, KBRIdentifyReasonType) {
	KBRIdentifyReasonTypeNone = 0,
	KBRIdentifyReasonTypeId = 1,
	KBRIdentifyReasonTypeTrack = 2,
	KBRIdentifyReasonTypeEncrypt = 3,
	KBRIdentifyReasonTypeDecrypt = 4,
	KBRIdentifyReasonTypeVerify = 5,
	KBRIdentifyReasonTypeResource = 6,
};

@interface KBRIdentifyReason : KBRObject
@property KBRIdentifyReasonType type;
@property NSString *reason;
@property NSString *resource;
@end

@interface KBRIdentifyOutcome : KBRObject
@property NSString *username;
@property KBRStatus *status;
@property NSArray *warnings; /*of string*/
@property KBRTrackSummary *trackUsed;
@property KBRTrackStatus trackStatus;
@property NSInteger numTrackFailures;
@property NSInteger numTrackChanges;
@property NSInteger numProofFailures;
@property NSInteger numRevoked;
@property NSInteger numProofSuccesses;
@property NSArray *revoked; /*of KBRTrackDiff*/
@property KBRTrackOptions *trackOptions;
@property BOOL forPGPPull;
@property KBRIdentifyReason *reason;
@end

@interface KBRIdentifyRes : KBRObject
@property KBRUser *user;
@property NSArray *publicKeys; /*of KBRPublicKey*/
@property KBRIdentifyOutcome *outcome;
@property NSString *trackToken;
@end

@interface KBRRemoteProof : KBRObject
@property KBRProofType proofType;
@property NSString *key;
@property NSString *value;
@property NSString *displayMarkup;
@property NSString *sigID;
@property long mTime;
@end

typedef NS_ENUM (NSInteger, KBRIdentifySource) {
	KBRIdentifySourceCli = 0,
	KBRIdentifySourceKbfs = 1,
};

@interface KBRIdentify2Res : KBRObject
@property KBRUserPlusKeys *upk;
@end

@interface KBRProofResult : KBRObject
@property KBRProofState state;
@property KBRProofStatus status;
@property NSString *desc;
@end

@interface KBRIdentifyRow : KBRObject
@property NSInteger rowId;
@property KBRRemoteProof *proof;
@property KBRTrackDiff *trackDiff;
@end

@interface KBRIdentifyKey : KBRObject
@property NSData *pgpFingerprint;
@property NSString *KID;
@property KBRTrackDiff *trackDiff;
@end

@interface KBRCryptocurrency : KBRObject
@property NSInteger rowId;
@property NSData *pkhash;
@property NSString *address;
@end

@interface KBRIdentity : KBRObject
@property KBRStatus *status;
@property NSInteger whenLastTracked;
@property NSArray *proofs; /*of KBRIdentifyRow*/
@property NSArray *cryptocurrency; /*of KBRCryptocurrency*/
@property NSArray *revoked; /*of KBRTrackDiff*/
@end

@interface KBRSigHint : KBRObject
@property NSString *remoteId;
@property NSString *humanUrl;
@property NSString *apiUrl;
@property NSString *checkText;
@end

@interface KBRCheckResult : KBRObject
@property KBRProofResult *proofResult;
@property long time;
@property NSString *displayMarkup;
@end

@interface KBRLinkCheckResult : KBRObject
@property NSInteger proofId;
@property KBRProofResult *proofResult;
@property BOOL torWarning;
@property KBRCheckResult *cached;
@property KBRTrackDiff *diff;
@property KBRTrackDiff *remoteDiff;
@property KBRSigHint *hint;
@end

@interface KBRUserCard : KBRObject
@property NSInteger following;
@property NSInteger followers;
@property NSString *uid;
@property NSString *fullName;
@property NSString *location;
@property NSString *bio;
@property NSString *website;
@property NSString *twitter;
@property BOOL youFollowThem;
@property BOOL theyFollowYou;
@end

@interface KBRConfirmResult : KBRObject
@property BOOL identityConfirmed;
@property BOOL remoteConfirmed;
@end

typedef NS_ENUM (NSInteger, KBRInstallStatus) {
	KBRInstallStatusUnknown = 0,
	KBRInstallStatusError = 1,
	KBRInstallStatusNotInstalled = 2,
	KBRInstallStatusInstalled = 4,
};

typedef NS_ENUM (NSInteger, KBRInstallAction) {
	KBRInstallActionUnknown = 0,
	KBRInstallActionNone = 1,
	KBRInstallActionUpgrade = 2,
	KBRInstallActionReinstall = 3,
	KBRInstallActionInstall = 4,
};

@interface KBRServiceStatus : KBRObject
@property NSString *version;
@property NSString *label;
@property NSString *pid;
@property NSString *lastExitStatus;
@property NSString *bundleVersion;
@property KBRInstallStatus installStatus;
@property KBRInstallAction installAction;
@property KBRStatus *status;
@end

@interface KBRServicesStatus : KBRObject
@property NSArray *service; /*of KBRServiceStatus*/
@property NSArray *kbfs; /*of KBRServiceStatus*/
@end

@interface KBRFuseMountInfo : KBRObject
@property NSString *path;
@property NSString *fstype;
@property NSString *output;
@end

@interface KBRFuseStatus : KBRObject
@property NSString *version;
@property NSString *bundleVersion;
@property NSString *kextID;
@property NSString *path;
@property BOOL kextStarted;
@property KBRInstallStatus installStatus;
@property KBRInstallAction installAction;
@property NSArray *mountInfos; /*of KBRFuseMountInfo*/
@property KBRStatus *status;
@end

@interface KBRComponentResult : KBRObject
@property NSString *name;
@property KBRStatus *status;
@end

@interface KBRInstallResult : KBRObject
@property NSArray *componentResults; /*of KBRComponentResult*/
@property KBRStatus *status;
@property BOOL fatal;
@end

@interface KBRUninstallResult : KBRObject
@property NSArray *componentResults; /*of KBRComponentResult*/
@property KBRStatus *status;
@end

typedef NS_ENUM (NSInteger, KBRFSStatusCode) {
	KBRFSStatusCodeStart = 0,
	KBRFSStatusCodeFinish = 1,
	KBRFSStatusCodeError = 2,
};

typedef NS_ENUM (NSInteger, KBRFSNotificationType) {
	KBRFSNotificationTypeEncrypting = 0,
	KBRFSNotificationTypeDecrypting = 1,
	KBRFSNotificationTypeSigning = 2,
	KBRFSNotificationTypeVerifying = 3,
	KBRFSNotificationTypeRekeying = 4,
};

@interface KBRFSNotification : KBRObject
@property BOOL publicTopLevelFolder;
@property NSString *filename;
@property NSString *status;
@property KBRFSStatusCode statusCode;
@property KBRFSNotificationType notificationType;
@end

@interface KBRPassphraseStream : KBRObject
@property NSData *passphraseStream;
@property NSInteger generation;
@end

@interface KBRConfiguredAccount : KBRObject
@property NSString *username;
@property BOOL hasStoredSecret;
@end

@interface KBRKeyHalf : KBRObject
@property NSString *user;
@property NSString *deviceKID;
@property NSData *key;
@end

@interface KBRMetadataResponse : KBRObject
@property NSString *folderID;
@property NSArray *mdBlocks; /*of bytes*/
@end

@interface KBRNotificationChannels : KBRObject
@property BOOL session;
@property BOOL users;
@property BOOL kbfs;
@property BOOL tracking;
@end

typedef NS_ENUM (NSInteger, KBRSignMode) {
	KBRSignModeAttached = 0,
	KBRSignModeDetached = 1,
	KBRSignModeClear = 2,
};

@interface KBRPGPSignOptions : KBRObject
@property NSString *keyQuery;
@property KBRSignMode mode;
@property BOOL binaryIn;
@property BOOL binaryOut;
@end

@interface KBRPGPEncryptOptions : KBRObject
@property NSArray *recipients; /*of string*/
@property BOOL noSign;
@property BOOL noSelf;
@property BOOL binaryOut;
@property NSString *keyQuery;
@property BOOL skipTrack;
@property KBRTrackOptions *trackOptions;
@end

@interface KBRPGPSigVerification : KBRObject
@property BOOL isSigned;
@property BOOL verified;
@property KBRUser *signer;
@property KBRPublicKey *signKey;
@end

@interface KBRPGPDecryptOptions : KBRObject
@property BOOL assertSigned;
@property NSString *signedBy;
@end

@interface KBRPGPVerifyOptions : KBRObject
@property NSString *signedBy;
@property NSData *signature;
@end

@interface KBRKeyInfo : KBRObject
@property NSString *fingerprint;
@property NSString *key;
@property NSString *desc;
@end

@interface KBRPGPQuery : KBRObject
@property BOOL secret;
@property NSString *query;
@property BOOL exactMatch;
@end

@interface KBRPGPCreateUids : KBRObject
@property BOOL useDefault;
@property NSArray *ids; /*of KBRPGPIdentity*/
@end

@interface KBRCheckProofStatus : KBRObject
@property BOOL found;
@property KBRProofStatus status;
@property NSString *proofText;
@end

@interface KBRStartProofResult : KBRObject
@property NSString *sigID;
@end

typedef NS_ENUM (NSInteger, KBRPromptOverwriteType) {
	KBRPromptOverwriteTypeSocial = 0,
	KBRPromptOverwriteTypeSite = 1,
};

typedef NS_ENUM (NSInteger, KBRProvisionMethod) {
	KBRProvisionMethodDevice = 0,
	KBRProvisionMethodPaperKey = 1,
	KBRProvisionMethodPassphrase = 2,
	KBRProvisionMethodGpgImport = 3,
	KBRProvisionMethodGpgSign = 4,
};

typedef NS_ENUM (NSInteger, KBRDeviceType) {
	KBRDeviceTypeDesktop = 0,
	KBRDeviceTypeMobile = 1,
};

typedef NS_ENUM (NSInteger, KBRChooseType) {
	KBRChooseTypeExistingDevice = 0,
	KBRChooseTypeNewDevice = 1,
};

@interface KBRSecretResponse : KBRObject
@property NSData *secret;
@property NSString *phrase;
@end

@interface KBRVerifySessionRes : KBRObject
@property NSString *uid;
@property NSString *sid;
@property NSInteger generated;
@property NSInteger lifetime;
@end

@interface KBRSaltPackEncryptOptions : KBRObject
@property NSArray *recipients; /*of string*/
@property BOOL hideSelf;
@property BOOL noSelfEncrypt;
@end

@interface KBRSaltPackDecryptOptions : KBRObject
@property BOOL interactive;
@property BOOL forceRemoteCheck;
@end

@interface KBRSaltPackSignOptions : KBRObject
@property BOOL detached;
@end

@interface KBRSaltPackVerifyOptions : KBRObject
@property NSString *signedBy;
@property NSData *signature;
@end

@interface KBRSaltPackEncryptedMessageInfo : KBRObject
@property NSArray *devices; /*of KBRDevice*/
@property NSInteger numAnonReceivers;
@property BOOL receiverIsAnon;
@end

typedef NS_ENUM (NSInteger, KBRSaltPackSenderType) {
	KBRSaltPackSenderTypeNotTracked = 0,
	KBRSaltPackSenderTypeUnknown = 1,
	KBRSaltPackSenderTypeAnonymous = 2,
	KBRSaltPackSenderTypeTrackingBroke = 3,
	KBRSaltPackSenderTypeTrackingOk = 4,
};

@interface KBRSaltPackSender : KBRObject
@property NSString *uid;
@property NSString *username;
@property KBRSaltPackSenderType senderType;
@end

@interface KBRSecretEntryArg : KBRObject
@property NSString *desc;
@property NSString *prompt;
@property NSString *err;
@property NSString *cancel;
@property NSString *ok;
@property NSString *reason;
@property BOOL useSecretStore;
@end

@interface KBRSecretEntryRes : KBRObject
@property NSString *text;
@property BOOL canceled;
@property BOOL storeSecret;
@end

@interface KBRSecretKeys : KBRObject
@property NSData *signing;
@property NSData *encryption;
@end

@interface KBRSession : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSString *token;
@property NSString *deviceSubkeyKid;
@property NSString *deviceSibkeyKid;
@end

@interface KBRSignupRes : KBRObject
@property BOOL passphraseOk;
@property BOOL postOk;
@property BOOL writeOk;
@end

@interface KBRSig : KBRObject
@property NSInteger seqno;
@property NSString *sigID;
@property NSString *sigIDDisplay;
@property NSString *type;
@property long cTime;
@property BOOL revoked;
@property BOOL active;
@property NSString *key;
@property NSString *body;
@end

@interface KBRSigTypes : KBRObject
@property BOOL track;
@property BOOL proof;
@property BOOL cryptocurrency;
@property BOOL isSelf;
@end

@interface KBRSigListArgs : KBRObject
@property NSInteger sessionID;
@property NSString *username;
@property BOOL allKeys;
@property KBRSigTypes *types;
@property NSString *filterx;
@property BOOL verbose;
@property BOOL revoked;
@end

@interface KBRTest : KBRObject
@property NSString *reply;
@end

typedef NS_ENUM (NSInteger, KBRPromptDefault) {
	KBRPromptDefaultNone = 0,
	KBRPromptDefaultYes = 1,
	KBRPromptDefaultNo = 2,
};

@interface KBRAsset : KBRObject
@property NSString *name;
@property NSString *url;
@property NSString *localPath;
@end

typedef NS_ENUM (NSInteger, KBRUpdateType) {
	KBRUpdateTypeNormal = 0,
	KBRUpdateTypeBugfix = 1,
	KBRUpdateTypeCritical = 2,
};

@interface KBRUpdate : KBRObject
@property NSString *version;
@property NSString *name;
@property NSString *description;
@property KBRUpdateType type;
@property KBRAsset *asset;
@end

@interface KBRUpdateOptions : KBRObject
@property NSString *version;
@property NSString *platform;
@property NSString *destinationPath;
@property NSString *source;
@property NSString *URL;
@property NSString *channel;
@property BOOL force;
@end

@interface KBRUpdateResult : KBRObject
@property KBRUpdate *update;
@end

typedef NS_ENUM (NSInteger, KBRUpdateAction) {
	KBRUpdateActionUpdate = 0,
	KBRUpdateActionSkip = 1,
	KBRUpdateActionSnooze = 2,
	KBRUpdateActionCancel = 3,
};

@interface KBRUpdatePromptRes : KBRObject
@property KBRUpdateAction action;
@property BOOL alwaysAutoInstall;
@property long snoozeUntil;
@end

@interface KBRUpdateQuitRes : KBRObject
@property BOOL quit;
@property NSInteger pid;
@property NSString *applicationPath;
@end

@interface KBRTracker : KBRObject
@property NSString *tracker;
@property NSInteger status;
@property long mTime;
@end

@interface KBRTrackProof : KBRObject
@property NSString *proofType;
@property NSString *proofName;
@property NSString *idString;
@end

@interface KBRWebProof : KBRObject
@property NSString *hostname;
@property NSArray *protocols; /*of string*/
@end

@interface KBRProofs : KBRObject
@property NSArray *social; /*of KBRTrackProof*/
@property NSArray *web; /*of KBRWebProof*/
@property NSArray *publicKeys; /*of KBRPublicKey*/
@end

@interface KBRUserSummary : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSString *thumbnail;
@property NSInteger idVersion;
@property NSString *fullName;
@property NSString *bio;
@property KBRProofs *proofs;
@property NSString *sigIDDisplay;
@property long trackTime;
@end

@interface KBRSearchComponent : KBRObject
@property NSString *key;
@property NSString *value;
@property double score;
@end

@interface KBRSearchResult : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSArray *components; /*of KBRSearchComponent*/
@property double score;
@end
@interface KBRPassphraseChangeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *oldPassphrase;
@property NSString *passphrase;
@property BOOL force;
@end
@interface KBRPassphrasePromptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRGUIEntryArg *guiArg;
@end
@interface KBRAuthenticateSessionRequestParams : KBRRequestParams
@property NSString *signature;
@end
@interface KBRPutBlockRequestParams : KBRRequestParams
@property KBRBlockIdCombo *bid;
@property NSString *folder;
@property NSString *blockKey;
@property NSData *buf;
@end
@interface KBRGetBlockRequestParams : KBRRequestParams
@property KBRBlockIdCombo *bid;
@end
@interface KBRAddReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property KBRBlockReference *ref;
@end
@interface KBRDelReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property KBRBlockReference *ref;
@end
@interface KBRArchiveReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property NSArray *refs;
@end
@interface KBRRegisterBTCRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *address;
@property BOOL force;
@end
@interface KBRGetCurrentStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetConfigRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRSetUserConfigRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *key;
@property NSString *value;
@end
@interface KBRSignED25519RequestParams : KBRRequestParams
@property NSData *msg;
@property NSString *reason;
@end
@interface KBRSignToStringRequestParams : KBRRequestParams
@property NSData *msg;
@property NSString *reason;
@end
@interface KBRUnboxBytes32RequestParams : KBRRequestParams
@property NSData *encryptedBytes32;
@property NSData *nonce;
@property NSData *peersPublicKey;
@property NSString *reason;
@end
@interface KBRStopRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRExitCode exitCode;
@end
@interface KBRLogRotateRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRSetLogLevelRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRLogLevel level;
@end
@interface KBRReloadRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDbNukeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFirstStepRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRSecondStepRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRIncrementRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRDeviceListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDeviceAddRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFavoriteAddRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRFolder *folder;
@end
@interface KBRFavoriteDeleteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRFolder *folder;
@end
@interface KBRFavoriteListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRWantToAddGPGKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRConfirmDuplicateKeyChosenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRSelectKeyAndPushOptionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *keys;
@end
@interface KBRSelectKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *keys;
@end
@interface KBRSignRequestParams : KBRRequestParams
@property NSData *msg;
@property NSData *fingerprint;
@end
@interface KBRResolveRequestParams : KBRRequestParams
@property NSString *assertion;
@end
@interface KBRIdentifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *userAssertion;
@property BOOL trackStatement;
@property BOOL forceRemoteCheck;
@property BOOL useDelegateUI;
@property KBRIdentifyReason *reason;
@property KBRIdentifySource source;
@end
@interface KBRIdentify2RequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@property NSString *userAssertion;
@property KBRIdentifyReason *reason;
@property BOOL useDelegateUI;
@property BOOL alwaysBlock;
@property BOOL noErrorOnTrackFailure;
@property BOOL forceRemoteCheck;
@property BOOL needProofSet;
@end
@interface KBRStartRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property KBRIdentifyReason *reason;
@end
@interface KBRDisplayKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentifyKey *key;
@end
@interface KBRReportLastTrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRTrackSummary *track;
@end
@interface KBRLaunchNetworkChecksRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentity *identity;
@property KBRUser *user;
@end
@interface KBRDisplayTrackStatementRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *stmt;
@end
@interface KBRFinishWebProofCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRRemoteProof *rp;
@property KBRLinkCheckResult *lcr;
@end
@interface KBRFinishSocialProofCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRRemoteProof *rp;
@property KBRLinkCheckResult *lcr;
@end
@interface KBRDisplayCryptocurrencyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRCryptocurrency *c;
@end
@interface KBRReportTrackTokenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *trackToken;
@end
@interface KBRDisplayUserCardRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRUserCard *card;
@end
@interface KBRConfirmRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentifyOutcome *outcome;
@end
@interface KBRFinishRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFSEventRequestParams : KBRRequestParams
@property KBRFSNotification *event;
@end
@interface KBRHelloRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *token;
@property NSString *csrf;
@property KBRPassphraseStream *pps;
@property NSString *sigBody;
@end
@interface KBRDidCounterSignRequestParams : KBRRequestParams
@property NSData *sig;
@end
@interface KBRLogRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRLogLevel level;
@property KBRText *text;
@end
@interface KBRGetConfiguredAccountsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRLoginRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceType;
@property NSString *username;
@property KBRClientType clientType;
@end
@interface KBRClearStoredSecretRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRLogoutRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDeprovisionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRRecoverAccountFromEmailAddressRequestParams : KBRRequestParams
@property NSString *email;
@end
@interface KBRPaperKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRUnlockRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetEmailOrUsernameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPromptRevokePaperKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRDevice *device;
@property NSInteger index;
@end
@interface KBRDisplayPaperKeyPhraseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *phrase;
@end
@interface KBRDisplayPrimaryPaperKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *phrase;
@end
@interface KBRAuthenticateRequestParams : KBRRequestParams
@property NSString *signature;
@end
@interface KBRPutMetadataRequestParams : KBRRequestParams
@property NSData *mdBlock;
@property NSDictionary *logTags;
@end
@interface KBRGetMetadataRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSData *folderHandle;
@property NSString *branchID;
@property BOOL unmerged;
@property long startRevision;
@property long stopRevision;
@property NSDictionary *logTags;
@end
@interface KBRRegisterForUpdatesRequestParams : KBRRequestParams
@property NSString *folderID;
@property long currRevision;
@property NSDictionary *logTags;
@end
@interface KBRPruneBranchRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSString *branchID;
@property NSDictionary *logTags;
@end
@interface KBRPutKeysRequestParams : KBRRequestParams
@property NSArray *keyHalves;
@property NSDictionary *logTags;
@end
@interface KBRGetKeyRequestParams : KBRRequestParams
@property NSData *keyHalfID;
@property NSString *deviceKID;
@property NSDictionary *logTags;
@end
@interface KBRTruncateLockRequestParams : KBRRequestParams
@property NSString *folderID;
@end
@interface KBRTruncateUnlockRequestParams : KBRRequestParams
@property NSString *folderID;
@end
@interface KBRGetFolderHandleRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSString *signature;
@end
@interface KBRGetFoldersForRekeyRequestParams : KBRRequestParams
@property NSString *deviceKID;
@end
@interface KBRMetadataUpdateRequestParams : KBRRequestParams
@property NSString *folderID;
@property long revision;
@end
@interface KBRFolderNeedsRekeyRequestParams : KBRRequestParams
@property NSString *folderID;
@property long revision;
@end
@interface KBRSetNotificationsRequestParams : KBRRequestParams
@property KBRNotificationChannels *channels;
@end
@interface KBRFSActivityRequestParams : KBRRequestParams
@property KBRFSNotification *notification;
@end
@interface KBRTrackingChangedRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *username;
@end
@interface KBRUserChangedRequestParams : KBRRequestParams
@property NSString *uid;
@end
@interface KBRPgpSignRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPSignOptions *opts;
@end
@interface KBRPgpPullRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *userAsserts;
@end
@interface KBRPgpEncryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPEncryptOptions *opts;
@end
@interface KBRPgpDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPDecryptOptions *opts;
@end
@interface KBRPgpVerifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRPGPVerifyOptions *opts;
@end
@interface KBRPgpImportRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *key;
@property BOOL pushSecret;
@end
@interface KBRPgpExportRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpExportByFingerprintRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpExportByKIDRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpKeyGenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger primaryBits;
@property NSInteger subkeyBits;
@property KBRPGPCreateUids *createUids;
@property BOOL allowMulti;
@property BOOL doExport;
@property BOOL pushSecret;
@end
@interface KBRPgpDeletePrimaryRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPgpSelectRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *fingerprintQuery;
@property BOOL allowMulti;
@property BOOL skipImport;
@property BOOL onlyImport;
@end
@interface KBRPgpUpdateRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL all;
@property NSArray *fingerprints;
@end
@interface KBROutputSignatureSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *fingerprint;
@property NSString *username;
@property long signedAt;
@end
@interface KBRStartProofRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *service;
@property NSString *username;
@property BOOL force;
@property BOOL promptPosted;
@end
@interface KBRCheckProofRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *sigID;
@end
@interface KBRPromptOverwriteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *account;
@property KBRPromptOverwriteType typ;
@end
@interface KBRPromptUsernameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *prompt;
@property KBRStatus *prevError;
@end
@interface KBROutputPrechecksRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBRPreProofWarningRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBROutputInstructionsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *instructions;
@property NSString *proof;
@end
@interface KBROkToCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@property NSInteger attempt;
@end
@interface KBRDisplayRecheckWarningRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBRChooseProvisioningMethodRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL gpgOption;
@end
@interface KBRChooseDeviceTypeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRChooseType kind;
@end
@interface KBRDisplayAndPromptSecretRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *secret;
@property NSString *phrase;
@property KBRDeviceType otherDeviceType;
@end
@interface KBRDisplaySecretExchangedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPromptNewDeviceNameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *existingDevices;
@end
@interface KBRProvisioneeSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *deviceName;
@end
@interface KBRProvisionerSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceName;
@property NSString *deviceType;
@end
@interface KBRVerifySessionRequestParams : KBRRequestParams
@property NSString *session;
@end
@interface KBRRevokeKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *keyID;
@end
@interface KBRRevokeDeviceRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceID;
@property BOOL force;
@end
@interface KBRRevokeSigsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *sigIDs;
@end
@interface KBRSaltPackEncryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltPackEncryptOptions *opts;
@end
@interface KBRSaltPackDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltPackDecryptOptions *opts;
@end
@interface KBRSaltPackSignRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltPackSignOptions *opts;
@end
@interface KBRSaltPackVerifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltPackVerifyOptions *opts;
@end
@interface KBRSaltPackPromptForDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSaltPackSender *sender;
@end
@interface KBRSaltPackVerifySuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *signingKID;
@property KBRSaltPackSender *sender;
@end
@interface KBRGetPassphraseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRGUIEntryArg *pinentry;
@property KBRSecretEntryArg *terminal;
@end
@interface KBRGetSecretKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRCurrentSessionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRCheckUsernameAvailableRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRSignupRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *email;
@property NSString *inviteCode;
@property NSString *passphrase;
@property NSString *username;
@property NSString *deviceName;
@property BOOL storeSecret;
@property BOOL skipMail;
@end
@interface KBRInviteRequestRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *email;
@property NSString *fullname;
@property NSString *notes;
@end
@interface KBRSigListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSigListArgs *arg;
@end
@interface KBRSigListJSONRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSigListArgs *arg;
@end
@interface KBRCloseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@end
@interface KBRReadRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@property NSInteger sz;
@end
@interface KBRWriteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@property NSData *buf;
@end
@interface KBRTestRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@end
@interface KBRTestCallbackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@end
@interface KBRPanicRequestParams : KBRRequestParams
@property NSString *message;
@end
@interface KBRTrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *userAssertion;
@property KBRTrackOptions *options;
@property BOOL forceRemoteCheck;
@end
@interface KBRTrackWithTokenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *trackToken;
@property KBRTrackOptions *options;
@end
@interface KBRUntrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRCheckTrackingRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFakeTrackingChangedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRPromptYesNoRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@property KBRPromptDefault promptDefault;
@end
@interface KBRUpdateRequestParams : KBRRequestParams
@property KBRUpdateOptions *options;
@end
@interface KBRUpdateCheckRequestParams : KBRRequestParams
@property BOOL force;
@end
@interface KBRUpdatePromptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRUpdate *update;
@end
@interface KBRListTrackersRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRListTrackersByNameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRListTrackersSelfRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRLoadUncheckedUserSummariesRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *uids;
@end
@interface KBRLoadUserRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRLoadUserPlusKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@property BOOL cacheOK;
@end
@interface KBRLoadPublicKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRListTrackingRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *filter;
@end
@interface KBRListTrackingJSONRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *filter;
@property BOOL verbose;
@end
@interface KBRSearchRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *query;
@end@interface KBRAccountRequest : KBRRequest

/*!
 Change the passphrase from old to new. If old isn't set, and force is false,
 then prompt at the UI for it. If old isn't set and force is true, then we'll
 try to force a passphrase change.
 */
- (void)passphraseChange:(KBRPassphraseChangeRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)passphraseChangeWithOldPassphrase:(NSString *)oldPassphrase passphrase:(NSString *)passphrase force:(BOOL)force completion:(void (^)(NSError *error))completion;

- (void)passphrasePrompt:(KBRPassphrasePromptRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

- (void)passphrasePromptWithGuiArg:(KBRGUIEntryArg *)guiArg completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

@end

@interface KBRBlockRequest : KBRRequest

- (void)authenticateSession:(KBRAuthenticateSessionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)authenticateSessionWithSignature:(NSString *)signature completion:(void (^)(NSError *error))completion;

- (void)putBlock:(KBRPutBlockRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putBlockWithBid:(KBRBlockIdCombo *)bid folder:(NSString *)folder blockKey:(NSString *)blockKey buf:(NSData *)buf completion:(void (^)(NSError *error))completion;

- (void)getBlock:(KBRGetBlockRequestParams *)params completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion;

- (void)getBlockWithBid:(KBRBlockIdCombo *)bid completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion;

- (void)addReference:(KBRAddReferenceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)addReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion;

- (void)delReference:(KBRDelReferenceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)delReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion;

- (void)archiveReference:(KBRArchiveReferenceRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)archiveReferenceWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)getUserQuotaInfo:(void (^)(NSError *error, NSData *bytes))completion;

@end

@interface KBRBTCRequest : KBRRequest

- (void)registerBTC:(KBRRegisterBTCRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)registerBTCWithAddress:(NSString *)address force:(BOOL)force completion:(void (^)(NSError *error))completion;

@end

@interface KBRConfigRequest : KBRRequest

- (void)getCurrentStatus:(void (^)(NSError *error, KBRGetCurrentStatusRes *getCurrentStatusRes))completion;

- (void)getConfig:(void (^)(NSError *error, KBRConfig *config))completion;

/*!
 Change user config.
 For example, to update primary picture source:
 key=picture.source, value=twitter (or github)
 */
- (void)setUserConfig:(KBRSetUserConfigRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setUserConfigWithUsername:(NSString *)username key:(NSString *)key value:(NSString *)value completion:(void (^)(NSError *error))completion;

@end

@interface KBRConstantsRequest : KBRRequest

@end

@interface KBRCryptoRequest : KBRRequest

/*!
 Sign the given message (which should be small) using the device's private
 signing ED25519 key, and return the signature as well as the corresponding
 public key that can be used to verify the signature. The 'reason' parameter
 is used as part of the SecretEntryArg object passed into
 secretUi.getSecret().
 */
- (void)signED25519:(KBRSignED25519RequestParams *)params completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

- (void)signED25519WithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

/*!
 Same as the above except the full marsheled and encoded NaclSigInfo.
 */
- (void)signToString:(KBRSignToStringRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)signToStringWithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 Decrypt exactly 32 bytes using nacl/box with the given nonce, the given
 peer's public key, and the device's private encryption key, and return the
 decrypted data. The 'reason' parameter is used as part of the
 SecretEntryArg object passed into secretUi.getSecret().
 */
- (void)unboxBytes32:(KBRUnboxBytes32RequestParams *)params completion:(void (^)(NSError *error, NSData *bytes32))completion;

- (void)unboxBytes32WithEncryptedBytes32:(NSData *)encryptedBytes32 nonce:(NSData *)nonce peersPublicKey:(NSData *)peersPublicKey reason:(NSString *)reason completion:(void (^)(NSError *error, NSData *bytes32))completion;

@end

@interface KBRCtlRequest : KBRRequest

- (void)stop:(KBRStopRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)stopWithExitCode:(KBRExitCode)exitCode completion:(void (^)(NSError *error))completion;

- (void)logRotate:(void (^)(NSError *error))completion;

- (void)setLogLevel:(KBRSetLogLevelRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setLogLevelWithLevel:(KBRLogLevel)level completion:(void (^)(NSError *error))completion;

- (void)reload:(void (^)(NSError *error))completion;

- (void)dbNuke:(void (^)(NSError *error))completion;

@end

@interface KBRDebuggingRequest : KBRRequest

- (void)firstStep:(KBRFirstStepRequestParams *)params completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion;

- (void)firstStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion;

- (void)secondStep:(KBRSecondStepRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)secondStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)increment:(KBRIncrementRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)incrementWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion;

@end

@interface KBRDelegateUiCtlRequest : KBRRequest

- (void)registerIdentifyUI:(void (^)(NSError *error))completion;

- (void)registerSecretUI:(void (^)(NSError *error))completion;

- (void)registerUpdateUI:(void (^)(NSError *error))completion;

@end

@interface KBRDeviceRequest : KBRRequest

/*!
 List devices for the user.
 */
- (void)deviceList:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Starts the process of adding a new device using an existing
 device. It is called on the existing device. 
 This is for kex2.
 */
- (void)deviceAdd:(void (^)(NSError *error))completion;

@end

@interface KBRFavoriteRequest : KBRRequest

/*!
 Adds a folder to a user's list of favorite folders.
 */
- (void)favoriteAdd:(KBRFavoriteAddRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)favoriteAddWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion;

/*!
 Removes a folder from a user's list of favorite folders.
 */
- (void)favoriteDelete:(KBRFavoriteDeleteRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)favoriteDeleteWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion;

/*!
 Returns all of a user's favorite folders.
 */
- (void)favoriteList:(void (^)(NSError *error, NSArray *items))completion;

@end

@interface KBRGpgUiRequest : KBRRequest

- (void)wantToAddGPGKey:(void (^)(NSError *error, BOOL b))completion;

- (void)confirmDuplicateKeyChosen:(void (^)(NSError *error, BOOL b))completion;

- (void)selectKeyAndPushOption:(KBRSelectKeyAndPushOptionRequestParams *)params completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion;

- (void)selectKeyAndPushOptionWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion;

- (void)selectKey:(KBRSelectKeyRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)selectKeyWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, NSString *str))completion;

- (void)sign:(KBRSignRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)signWithMsg:(NSData *)msg fingerprint:(NSData *)fingerprint completion:(void (^)(NSError *error, NSString *str))completion;

@end

@interface KBRIdentifyRequest : KBRRequest

/*!
 Resolve an assertion to a UID. On failure, resolves to an empty UID and returns
 an error.
 */
- (void)resolve:(KBRResolveRequestParams *)params completion:(void (^)(NSError *error, NSString *uID))completion;

- (void)resolveWithAssertion:(NSString *)assertion completion:(void (^)(NSError *error, NSString *uID))completion;

/*!
 Identify a user from a username or assertion (e.g. kbuser, twuser@twitter).
 If trackStatement is true, we'll return a generated JSON tracking statement.
 If forceRemoteCheck is true, we force all remote proofs to be checked (otherwise a cache is used).
 */
- (void)identify:(KBRIdentifyRequestParams *)params completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion;

- (void)identifyWithUserAssertion:(NSString *)userAssertion trackStatement:(BOOL)trackStatement forceRemoteCheck:(BOOL)forceRemoteCheck useDelegateUI:(BOOL)useDelegateUI reason:(KBRIdentifyReason *)reason source:(KBRIdentifySource)source completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion;

- (void)identify2:(KBRIdentify2RequestParams *)params completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion;

- (void)identify2WithUid:(NSString *)uid userAssertion:(NSString *)userAssertion reason:(KBRIdentifyReason *)reason useDelegateUI:(BOOL)useDelegateUI alwaysBlock:(BOOL)alwaysBlock noErrorOnTrackFailure:(BOOL)noErrorOnTrackFailure forceRemoteCheck:(BOOL)forceRemoteCheck needProofSet:(BOOL)needProofSet completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion;

@end

@interface KBRIdentifyUiRequest : KBRRequest

- (void)delegateIdentifyUI:(void (^)(NSError *error, NSInteger n))completion;

- (void)start:(KBRStartRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)startWithUsername:(NSString *)username reason:(KBRIdentifyReason *)reason completion:(void (^)(NSError *error))completion;

- (void)displayKey:(KBRDisplayKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayKeyWithKey:(KBRIdentifyKey *)key completion:(void (^)(NSError *error))completion;

- (void)reportLastTrack:(KBRReportLastTrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)reportLastTrackWithTrack:(KBRTrackSummary *)track completion:(void (^)(NSError *error))completion;

- (void)launchNetworkChecks:(KBRLaunchNetworkChecksRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)launchNetworkChecksWithIdentity:(KBRIdentity *)identity user:(KBRUser *)user completion:(void (^)(NSError *error))completion;

- (void)displayTrackStatement:(KBRDisplayTrackStatementRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayTrackStatementWithStmt:(NSString *)stmt completion:(void (^)(NSError *error))completion;

- (void)finishWebProofCheck:(KBRFinishWebProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)finishWebProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion;

- (void)finishSocialProofCheck:(KBRFinishSocialProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)finishSocialProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion;

- (void)displayCryptocurrency:(KBRDisplayCryptocurrencyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayCryptocurrencyWithC:(KBRCryptocurrency *)c completion:(void (^)(NSError *error))completion;

- (void)reportTrackToken:(KBRReportTrackTokenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)reportTrackTokenWithTrackToken:(NSString *)trackToken completion:(void (^)(NSError *error))completion;

- (void)displayUserCard:(KBRDisplayUserCardRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayUserCardWithCard:(KBRUserCard *)card completion:(void (^)(NSError *error))completion;

- (void)confirm:(KBRConfirmRequestParams *)params completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion;

- (void)confirmWithOutcome:(KBRIdentifyOutcome *)outcome completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion;

- (void)finish:(void (^)(NSError *error))completion;

@end

@interface KBRInstallRequest : KBRRequest

@end

@interface KBRKbfsRequest : KBRRequest

/*!
 Idea is that kbfs would call the function below whenever these actions are
 performed on a file.

 Note that this list/interface is very temporary and highly likely to change
 significantly.

 It is just a starting point to get kbfs notifications through the daemon to
 the clients.
 */
- (void)fSEvent:(KBRFSEventRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSEventWithEvent:(KBRFSNotification *)event completion:(void (^)(NSError *error))completion;

@end

@interface KBRKex2ProvisioneeRequest : KBRRequest

- (void)hello:(KBRHelloRequestParams *)params completion:(void (^)(NSError *error, NSString *helloRes))completion;

- (void)helloWithUid:(NSString *)uid token:(NSString *)token csrf:(NSString *)csrf pps:(KBRPassphraseStream *)pps sigBody:(NSString *)sigBody completion:(void (^)(NSError *error, NSString *helloRes))completion;

- (void)didCounterSign:(KBRDidCounterSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)didCounterSignWithSig:(NSData *)sig completion:(void (^)(NSError *error))completion;

@end

@interface KBRKex2ProvisionerRequest : KBRRequest

- (void)kexStart:(void (^)(NSError *error))completion;

@end

@interface KBRLogUiRequest : KBRRequest

- (void)log:(KBRLogRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)logWithLevel:(KBRLogLevel)level text:(KBRText *)text completion:(void (^)(NSError *error))completion;

@end

@interface KBRLoginRequest : KBRRequest

/*!
 Returns an array of information about accounts configured on the local
 machine. Currently configured accounts are defined as those that have stored
 secrets, but this definition may be expanded in the future.
 */
- (void)getConfiguredAccounts:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Performs login. deviceType should be libkb.DeviceTypeDesktop
 or libkb.DeviceTypeMobile. username is optional.
 If the current device isn't provisioned, this function will
 provision it.
 */
- (void)login:(KBRLoginRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)loginWithDeviceType:(NSString *)deviceType username:(NSString *)username clientType:(KBRClientType)clientType completion:(void (^)(NSError *error))completion;

/*!
 Removes any existing stored secret for the given username.
 loginWithStoredSecret(_, username) will fail after this is called.
 */
- (void)clearStoredSecret:(KBRClearStoredSecretRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)clearStoredSecretWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)logout:(void (^)(NSError *error))completion;

- (void)deprovision:(KBRDeprovisionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)deprovisionWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)recoverAccountFromEmailAddress:(KBRRecoverAccountFromEmailAddressRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)recoverAccountFromEmailAddressWithEmail:(NSString *)email completion:(void (^)(NSError *error))completion;

/*!
 PaperKey generates paper backup keys for restoring an account.
 It calls login_ui.displayPaperKeyPhrase with the phrase.
 */
- (void)paperKey:(void (^)(NSError *error))completion;

/*!
 Unlock restores access to local key store by priming passphrase stream cache.
 */
- (void)unlock:(void (^)(NSError *error))completion;

@end

@interface KBRLoginUiRequest : KBRRequest

- (void)getEmailOrUsername:(void (^)(NSError *error, NSString *str))completion;

- (void)promptRevokePaperKeys:(KBRPromptRevokePaperKeysRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptRevokePaperKeysWithDevice:(KBRDevice *)device index:(NSInteger)index completion:(void (^)(NSError *error, BOOL b))completion;

- (void)displayPaperKeyPhrase:(KBRDisplayPaperKeyPhraseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayPaperKeyPhraseWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion;

- (void)displayPrimaryPaperKey:(KBRDisplayPrimaryPaperKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayPrimaryPaperKeyWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion;

@end

@interface KBRMetadataRequest : KBRRequest

- (void)authenticate:(KBRAuthenticateRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)authenticateWithSignature:(NSString *)signature completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)putMetadata:(KBRPutMetadataRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putMetadataWithMdBlock:(NSData *)mdBlock logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)getMetadata:(KBRGetMetadataRequestParams *)params completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion;

- (void)getMetadataWithFolderID:(NSString *)folderID folderHandle:(NSData *)folderHandle branchID:(NSString *)branchID unmerged:(BOOL)unmerged startRevision:(long)startRevision stopRevision:(long)stopRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion;

- (void)registerForUpdates:(KBRRegisterForUpdatesRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)registerForUpdatesWithFolderID:(NSString *)folderID currRevision:(long)currRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)pruneBranch:(KBRPruneBranchRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pruneBranchWithFolderID:(NSString *)folderID branchID:(NSString *)branchID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)putKeys:(KBRPutKeysRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putKeysWithKeyHalves:(NSArray *)keyHalves logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)getKey:(KBRGetKeyRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getKeyWithKeyHalfID:(NSData *)keyHalfID deviceKID:(NSString *)deviceKID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)truncateLock:(KBRTruncateLockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateLockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateUnlock:(KBRTruncateUnlockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateUnlockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion;

- (void)getFolderHandle:(KBRGetFolderHandleRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getFolderHandleWithFolderID:(NSString *)folderID signature:(NSString *)signature completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getFoldersForRekey:(KBRGetFoldersForRekeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)getFoldersForRekeyWithDeviceKID:(NSString *)deviceKID completion:(void (^)(NSError *error))completion;

- (void)ping:(void (^)(NSError *error))completion;

@end

@interface KBRMetadataUpdateRequest : KBRRequest

- (void)metadataUpdate:(KBRMetadataUpdateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)metadataUpdateWithFolderID:(NSString *)folderID revision:(long)revision completion:(void (^)(NSError *error))completion;

- (void)folderNeedsRekey:(KBRFolderNeedsRekeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)folderNeedsRekeyWithFolderID:(NSString *)folderID revision:(long)revision completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyCtlRequest : KBRRequest

- (void)setNotifications:(KBRSetNotificationsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setNotificationsWithChannels:(KBRNotificationChannels *)channels completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyFSRequest : KBRRequest

- (void)fSActivity:(KBRFSActivityRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSActivityWithNotification:(KBRFSNotification *)notification completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifySessionRequest : KBRRequest

- (void)loggedOut:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyTrackingRequest : KBRRequest

- (void)trackingChanged:(KBRTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackingChangedWithUid:(NSString *)uid username:(NSString *)username completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyUsersRequest : KBRRequest

- (void)userChanged:(KBRUserChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)userChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion;

@end

@interface KBRPgpRequest : KBRRequest

- (void)pgpSign:(KBRPgpSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPSignOptions *)opts completion:(void (^)(NSError *error))completion;

/*!
 Download PGP keys for tracked users and update the local GPG keyring.
 If usernames is nonempty, update only those users.
 */
- (void)pgpPull:(KBRPgpPullRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpPullWithUserAsserts:(NSArray *)userAsserts completion:(void (^)(NSError *error))completion;

- (void)pgpEncrypt:(KBRPgpEncryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPEncryptOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)pgpDecrypt:(KBRPgpDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPDecryptOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpVerify:(KBRPgpVerifyRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpVerifyWithSource:(KBRStream *)source opts:(KBRPGPVerifyOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpImport:(KBRPgpImportRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpImportWithKey:(NSData *)key pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion;

/*!
 Exports active PGP keys. Only allows armored export.
 */
- (void)pgpExport:(KBRPgpExportRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByFingerprint:(KBRPgpExportByFingerprintRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByFingerprintWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByKID:(KBRPgpExportByKIDRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByKIDWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpKeyGen:(KBRPgpKeyGenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpKeyGenWithPrimaryBits:(NSInteger)primaryBits subkeyBits:(NSInteger)subkeyBits createUids:(KBRPGPCreateUids *)createUids allowMulti:(BOOL)allowMulti doExport:(BOOL)doExport pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion;

- (void)pgpDeletePrimary:(void (^)(NSError *error))completion;

/*!
 Select an existing key and add to Keybase.
 */
- (void)pgpSelect:(KBRPgpSelectRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpSelectWithFingerprintQuery:(NSString *)fingerprintQuery allowMulti:(BOOL)allowMulti skipImport:(BOOL)skipImport onlyImport:(BOOL)onlyImport completion:(void (^)(NSError *error))completion;

/*!
 Push updated key(s) to the server.
 */
- (void)pgpUpdate:(KBRPgpUpdateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpUpdateWithAll:(BOOL)all fingerprints:(NSArray *)fingerprints completion:(void (^)(NSError *error))completion;

@end

@interface KBRPgpUiRequest : KBRRequest

- (void)outputSignatureSuccess:(KBROutputSignatureSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputSignatureSuccessWithFingerprint:(NSString *)fingerprint username:(NSString *)username signedAt:(long)signedAt completion:(void (^)(NSError *error))completion;

@end

@interface KBRProveRequest : KBRRequest

- (void)startProof:(KBRStartProofRequestParams *)params completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion;

- (void)startProofWithService:(NSString *)service username:(NSString *)username force:(BOOL)force promptPosted:(BOOL)promptPosted completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion;

- (void)checkProof:(KBRCheckProofRequestParams *)params completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion;

- (void)checkProofWithSigID:(NSString *)sigID completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion;

@end

@interface KBRProveUiRequest : KBRRequest

- (void)promptOverwrite:(KBRPromptOverwriteRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptOverwriteWithAccount:(NSString *)account typ:(KBRPromptOverwriteType)typ completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptUsername:(KBRPromptUsernameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)promptUsernameWithPrompt:(NSString *)prompt prevError:(KBRStatus *)prevError completion:(void (^)(NSError *error, NSString *str))completion;

- (void)outputPrechecks:(KBROutputPrechecksRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputPrechecksWithText:(KBRText *)text completion:(void (^)(NSError *error))completion;

- (void)preProofWarning:(KBRPreProofWarningRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)preProofWarningWithText:(KBRText *)text completion:(void (^)(NSError *error, BOOL b))completion;

- (void)outputInstructions:(KBROutputInstructionsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputInstructionsWithInstructions:(KBRText *)instructions proof:(NSString *)proof completion:(void (^)(NSError *error))completion;

- (void)okToCheck:(KBROkToCheckRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)okToCheckWithName:(NSString *)name attempt:(NSInteger)attempt completion:(void (^)(NSError *error, BOOL b))completion;

- (void)displayRecheckWarning:(KBRDisplayRecheckWarningRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayRecheckWarningWithText:(KBRText *)text completion:(void (^)(NSError *error))completion;

@end

@interface KBRProvisionUiRequest : KBRRequest

/*!
 Called during device provisioning for the user to select a
 method for provisioning. gpgOption will be true if GPG
 should be offered as an option.
 */
- (void)chooseProvisioningMethod:(KBRChooseProvisioningMethodRequestParams *)params completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion;

- (void)chooseProvisioningMethodWithGpgOption:(BOOL)gpgOption completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion;

/*!
 If provisioning via device, this will be called so user can select the provisioner/provisionee device type: desktop or mobile.
 If selecting the existing device type, set kind to EXISTING_DEVICE_0.
 If selecting the new device type, set kind to NEW_DEVICE_1.
 */
- (void)chooseDeviceType:(KBRChooseDeviceTypeRequestParams *)params completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion;

- (void)chooseDeviceTypeWithKind:(KBRChooseType)kind completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion;

/*!
 DisplayAndPromptSecret displays a secret that the user can enter into the other device.
 It also can return a secret that the user enters into this device (from the other device). 
 If it does not return a secret, it will be canceled when this device receives the secret via kex2.
 */
- (void)displayAndPromptSecret:(KBRDisplayAndPromptSecretRequestParams *)params completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion;

- (void)displayAndPromptSecretWithSecret:(NSData *)secret phrase:(NSString *)phrase otherDeviceType:(KBRDeviceType)otherDeviceType completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion;

/*!
 DisplaySecretExchanged is called when the kex2 secret has successfully been exchanged by the two
 devices.
 */
- (void)displaySecretExchanged:(void (^)(NSError *error))completion;

/*!
 PromptNewDeviceName is called when the device provisioning process needs a name for the new device.
 To help the clients not send a duplicate name, existingDevices is populated with the current device
 names for the user.
 */
- (void)promptNewDeviceName:(KBRPromptNewDeviceNameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)promptNewDeviceNameWithExistingDevices:(NSArray *)existingDevices completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 ProvisioneeSuccess is called on provisionee when it is successfully provisioned.
 */
- (void)provisioneeSuccess:(KBRProvisioneeSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)provisioneeSuccessWithUsername:(NSString *)username deviceName:(NSString *)deviceName completion:(void (^)(NSError *error))completion;

/*!
 ProvisionerSuccess is called on provisioner when it successfully provisions another device.
 */
- (void)provisionerSuccess:(KBRProvisionerSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)provisionerSuccessWithDeviceName:(NSString *)deviceName deviceType:(NSString *)deviceType completion:(void (^)(NSError *error))completion;

@end

@interface KBRQuotaRequest : KBRRequest

- (void)verifySession:(KBRVerifySessionRequestParams *)params completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion;

- (void)verifySessionWithSession:(NSString *)session completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion;

@end

@interface KBRRevokeRequest : KBRRequest

- (void)revokeKey:(KBRRevokeKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeKeyWithKeyID:(NSString *)keyID completion:(void (^)(NSError *error))completion;

- (void)revokeDevice:(KBRRevokeDeviceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeDeviceWithDeviceID:(NSString *)deviceID force:(BOOL)force completion:(void (^)(NSError *error))completion;

- (void)revokeSigs:(KBRRevokeSigsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeSigsWithSigIDs:(NSArray *)sigIDs completion:(void (^)(NSError *error))completion;

@end

@interface KBRSaltPackRequest : KBRRequest

- (void)saltPackEncrypt:(KBRSaltPackEncryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltPackEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltPackEncryptOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)saltPackDecrypt:(KBRSaltPackDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRSaltPackEncryptedMessageInfo *saltPackEncryptedMessageInfo))completion;

- (void)saltPackDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltPackDecryptOptions *)opts completion:(void (^)(NSError *error, KBRSaltPackEncryptedMessageInfo *saltPackEncryptedMessageInfo))completion;

- (void)saltPackSign:(KBRSaltPackSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltPackSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltPackSignOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)saltPackVerify:(KBRSaltPackVerifyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltPackVerifyWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltPackVerifyOptions *)opts completion:(void (^)(NSError *error))completion;

@end

@interface KBRSaltPackUiRequest : KBRRequest

- (void)saltPackPromptForDecrypt:(KBRSaltPackPromptForDecryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltPackPromptForDecryptWithSender:(KBRSaltPackSender *)sender completion:(void (^)(NSError *error))completion;

- (void)saltPackVerifySuccess:(KBRSaltPackVerifySuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltPackVerifySuccessWithSigningKID:(NSString *)signingKID sender:(KBRSaltPackSender *)sender completion:(void (^)(NSError *error))completion;

@end

@interface KBRSecretUiRequest : KBRRequest

- (void)getPassphrase:(KBRGetPassphraseRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

- (void)getPassphraseWithPinentry:(KBRGUIEntryArg *)pinentry terminal:(KBRSecretEntryArg *)terminal completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

@end

@interface KBRSecretKeysRequest : KBRRequest

- (void)getSecretKeys:(void (^)(NSError *error, KBRSecretKeys *secretKeys))completion;

@end

@interface KBRSessionRequest : KBRRequest

- (void)currentSession:(void (^)(NSError *error, KBRSession *session))completion;

@end

@interface KBRSignupRequest : KBRRequest

- (void)checkUsernameAvailable:(KBRCheckUsernameAvailableRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)checkUsernameAvailableWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)signup:(KBRSignupRequestParams *)params completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion;

- (void)signupWithEmail:(NSString *)email inviteCode:(NSString *)inviteCode passphrase:(NSString *)passphrase username:(NSString *)username deviceName:(NSString *)deviceName storeSecret:(BOOL)storeSecret skipMail:(BOOL)skipMail completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion;

- (void)inviteRequest:(KBRInviteRequestRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)inviteRequestWithEmail:(NSString *)email fullname:(NSString *)fullname notes:(NSString *)notes completion:(void (^)(NSError *error))completion;

@end

@interface KBRSigsRequest : KBRRequest

- (void)sigList:(KBRSigListRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)sigListWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)sigListJSON:(KBRSigListJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)sigListJSONWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSString *str))completion;

@end

@interface KBRStreamUiRequest : KBRRequest

- (void)close:(KBRCloseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)closeWithS:(KBRStream *)s completion:(void (^)(NSError *error))completion;

- (void)read:(KBRReadRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)readWithS:(KBRStream *)s sz:(NSInteger)sz completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)write:(KBRWriteRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)writeWithS:(KBRStream *)s buf:(NSData *)buf completion:(void (^)(NSError *error, NSInteger n))completion;

@end

@interface KBRTestRequest : KBRRequest

/*!
 Call test method.
 Will trigger the testCallback method, whose result will be set in the
 returned Test object, reply property.
 */
- (void)test:(KBRTestRequestParams *)params completion:(void (^)(NSError *error, KBRTest *test))completion;

- (void)testWithName:(NSString *)name completion:(void (^)(NSError *error, KBRTest *test))completion;

/*!
 This is a service callback triggered from test(..).
 The name param is what was passed into test.
 */
- (void)testCallback:(KBRTestCallbackRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)testCallbackWithName:(NSString *)name completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 For testing crashes.
 */
- (void)panic:(KBRPanicRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)panicWithMessage:(NSString *)message completion:(void (^)(NSError *error))completion;

@end

@interface KBRTrackRequest : KBRRequest

/*!
 This will perform identify and track.
 If forceRemoteCheck is true, we force all remote proofs to be checked
 (otherwise a cache is used).
 */
- (void)track:(KBRTrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackWithUserAssertion:(NSString *)userAssertion options:(KBRTrackOptions *)options forceRemoteCheck:(BOOL)forceRemoteCheck completion:(void (^)(NSError *error))completion;

/*!
 Track with token returned from identify.
 */
- (void)trackWithToken:(KBRTrackWithTokenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackWithTokenWithTrackToken:(NSString *)trackToken options:(KBRTrackOptions *)options completion:(void (^)(NSError *error))completion;

- (void)untrack:(KBRUntrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)untrackWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)checkTracking:(void (^)(NSError *error))completion;

- (void)fakeTrackingChanged:(KBRFakeTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fakeTrackingChangedWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

@end

@interface KBRUiRequest : KBRRequest

- (void)promptYesNo:(KBRPromptYesNoRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptYesNoWithText:(KBRText *)text promptDefault:(KBRPromptDefault)promptDefault completion:(void (^)(NSError *error, BOOL b))completion;

@end

@interface KBRUpdateRequest : KBRRequest

/*!
 Perform the update with options.
 */
- (void)update:(KBRUpdateRequestParams *)params completion:(void (^)(NSError *error, KBRUpdateResult *updateResult))completion;

- (void)updateWithOptions:(KBRUpdateOptions *)options completion:(void (^)(NSError *error, KBRUpdateResult *updateResult))completion;

/*!
 Perform an update check.
 */
- (void)updateCheck:(KBRUpdateCheckRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)updateCheckWithForce:(BOOL)force completion:(void (^)(NSError *error))completion;

@end

@interface KBRUpdateUiRequest : KBRRequest

- (void)updatePrompt:(KBRUpdatePromptRequestParams *)params completion:(void (^)(NSError *error, KBRUpdatePromptRes *updatePromptRes))completion;

- (void)updatePromptWithUpdate:(KBRUpdate *)update completion:(void (^)(NSError *error, KBRUpdatePromptRes *updatePromptRes))completion;

- (void)updateQuit:(void (^)(NSError *error, KBRUpdateQuitRes *updateQuitRes))completion;

@end

@interface KBRUserRequest : KBRRequest

- (void)listTrackers:(KBRListTrackersRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersByName:(KBRListTrackersByNameRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersByNameWithUsername:(NSString *)username completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersSelf:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load user summaries for the supplied uids.
 They are "unchecked" in that the client is not verifying the info from the server.
 If len(uids) > 500, the first 500 will be returned.
 */
- (void)loadUncheckedUserSummaries:(KBRLoadUncheckedUserSummariesRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)loadUncheckedUserSummariesWithUids:(NSArray *)uids completion:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load a user from the server.
 */
- (void)loadUser:(KBRLoadUserRequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion;

- (void)loadUserWithUid:(NSString *)uid completion:(void (^)(NSError *error, KBRUser *user))completion;

/*!
 Load a user + device keys from the server.
 If cacheOK is true means that a cached value is ok to return.
 */
- (void)loadUserPlusKeys:(KBRLoadUserPlusKeysRequestParams *)params completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion;

- (void)loadUserPlusKeysWithUid:(NSString *)uid cacheOK:(BOOL)cacheOK completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion;

/*!
 Load public keys for a user.
 */
- (void)loadPublicKeys:(KBRLoadPublicKeysRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)loadPublicKeysWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion;

/*!
 The list-tracking function get verified data from the tracking statements
 in the user's own sigchain.
 */
- (void)listTracking:(KBRListTrackingRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackingWithFilter:(NSString *)filter completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackingJSON:(KBRListTrackingJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)listTrackingJSONWithFilter:(NSString *)filter verbose:(BOOL)verbose completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 Search for users who match a given query.
 */
- (void)search:(KBRSearchRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)searchWithQuery:(NSString *)query completion:(void (^)(NSError *error, NSArray *items))completion;

@end
