/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class legacyjobhistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printJob(String trackerHostName, String trackerid, String jobId, String jobName, String user, Path logFile, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td>" + trackerHostName + "</td>");
        out.print("<td>" + new Date(Long.parseLong(trackerid)) + "</td>");
        out.print("<td><a href=\"jobdetailshistory.jsp?logFile=" + logFile.toString() + "\">" + jobId + "</a></td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars(jobName) + "</td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars(user) + "</td>");
        out.print("</tr>");
    }

    private void printNavigation(int pageno, int size, int max, String search, JspWriter out) throws IOException {
        int lastPage;
        int firstPage;
        int numIndexToShow = 5;
        out.print("<center> <");
        if (pageno > 1) {
            out.println("<a href=\"legacyjobhistory.jsp?pageno=" + (pageno - 1) + "&search=" + search + "\">Previous</a>");
        }
        if ((firstPage = pageno - numIndexToShow) < 1) {
            firstPage = 1;
        }
        if ((lastPage = pageno + numIndexToShow) > max) {
            lastPage = max;
        }
        out.println("<!--DEBUG : firstPage : " + firstPage + ", lastPage : " + lastPage + " -->");
        for (int i = firstPage; i <= lastPage; ++i) {
            if (i != pageno) {
                out.println(" <a href=\"legacyjobhistory.jsp?pageno=" + i + "&search=" + search + "\">" + i + "</a> ");
                continue;
            }
            out.println(i);
        }
        if (pageno < max) {
            out.println("<a href=\"legacyjobhistory.jsp?pageno=" + (pageno + 1) + "&search=" + search + "\">Next</a>");
        }
        out.print("></center>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block26: {
            int maxPageNo;
            int size;
            int pageno;
            Path[] jobFiles;
            String jobname;
            String user;
            String search;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block25: {
                block24: {
                    String historyLogDir;
                    FileSystem fs;
                    PathFilter jobLogFileFilter;
                    block23: {
                        String trackerUrl;
                        String trackerName;
                        PageContext pageContext = null;
                        HttpSession session = null;
                        ServletContext application = null;
                        ServletConfig config = null;
                        out = null;
                        legacyjobhistory_jsp page = this;
                        _jspx_out = null;
                        _jspx_page_context = null;
                        response.setContentType("text/html; charset=UTF-8");
                        _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)((Object)this), (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                        application = pageContext.getServletContext();
                        config = pageContext.getServletConfig();
                        session = pageContext.getSession();
                        _jspx_out = out = pageContext.getOut();
                        this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                        out.write(10);
                        JobConf jobConf = (JobConf)application.getAttribute("jobConf");
                        String trackerAddress = jobConf.get("mapred.job.tracker.http.address");
                        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(trackerAddress);
                        if (JobHistoryServer.isEmbedded(jobConf)) {
                            trackerName = StringUtils.simpleHostname(InetAddress.getLocalHost().getCanonicalHostName());
                            trackerName = StringUtils.getHostname();
                            trackerUrl = "";
                        } else {
                            trackerUrl = "http://" + trackerAddress;
                            trackerName = StringUtils.simpleHostname(infoSocAddr.getHostName());
                        }
                        out.write(10);
                        out.write(10);
                        out.write("\n<html>\n<head>\n<script type=\"text/JavaScript\">\n<!--\nfunction showUserHistory(search)\n{\nvar url\nif (search == null || \"\".equals(search)) {\n  url=\"legacyjobhistory.jsp\";\n} else {\n  url=\"legacyjobhistory.jsp?pageno=1&search=\" + search;\n}\nwindow.location.href = url;\n}\n//-->\n</script>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<title>");
                        out.print(trackerName);
                        out.write(" Hadoop Map/Reduce History Viewer</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n</head>\n<body>\n<h1> <a href=\"");
                        out.print(trackerUrl);
                        out.write("/jobtracker.jsp\">");
                        out.print(trackerName);
                        out.write("</a> Hadoop Map/Reduce\n     <a href=\"jobhistoryhome.jsp\">History Viewer</a></h1>\n<hr>\n");
                        search = request.getParameter("search") == null ? "" : request.getParameter("search");
                        String[] parts = search.split(":");
                        user = parts.length >= 1 ? parts[0].toLowerCase() : "";
                        jobname = parts.length >= 2 ? parts[1].toLowerCase() : "";
                        jobLogFileFilter = new PathFilter(){
                            final String uqUser;
                            final String uqJobname;
                            {
                                this.uqUser = JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars(user));
                                this.uqJobname = JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars(jobname));
                            }

                            private boolean matchUser(String fileName) {
                                return "".equals(this.uqUser) || this.uqUser.equals(fileName.split("_")[5]);
                            }

                            private boolean matchJobName(String fileName) {
                                return "".equals(this.uqJobname) || fileName.split("_")[6].toLowerCase().contains(this.uqJobname);
                            }

                            @Override
                            public boolean accept(Path path) {
                                return !path.getName().endsWith(".xml") && this.matchUser(path.getName()) && this.matchJobName(path.getName());
                            }
                        };
                        fs = (FileSystem)application.getAttribute("fileSys");
                        historyLogDir = (String)application.getAttribute("historyLogDir");
                        if (fs != null) break block23;
                        out.println("Null file system. May be namenode is in safemode!");
                        _jspxFactory.releasePageContext(_jspx_page_context);
                        return;
                    }
                    jobFiles = JobHistory.filteredStat2Paths(fs.listStatus(new Path(historyLogDir), jobLogFileFilter), false, null);
                    out.println("<!--  user : " + user + ", jobname : " + jobname + "-->");
                    if (null != jobFiles && jobFiles.length != 0) break block24;
                    out.println("No files found!");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                pageno = request.getParameter("pageno") == null ? 1 : Integer.parseInt(request.getParameter("pageno"));
                size = 100;
                if (pageno == -1 || size > jobFiles.length) {
                    size = jobFiles.length;
                }
                if (pageno == -1) {
                    pageno = 1;
                }
                maxPageNo = (int)Math.ceil((float)jobFiles.length / (float)size);
                if (pageno >= 1 && pageno <= maxPageNo) break block25;
                out.println("Invalid page index");
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                int length = size;
                if (pageno == maxPageNo) {
                    int startOnLast = (pageno - 1) * size + 1;
                    length = jobFiles.length - startOnLast + 1;
                }
                out.println("<form name=search><b> Filter (username:jobname) </b>");
                out.println("<input type=text name=search size=\"20\" value=\"" + search + "\">");
                out.println("<input type=submit value=\"Filter!\" onClick=\"showUserHistory(document.getElementById('search').value)\"></form>");
                out.println("<span class=\"small\">Example: 'smith' will display jobs either submitted by user 'smith'. 'smith:sort' will display jobs from user 'smith' having 'sort' keyword in the jobname.</span>");
                out.println("<hr>");
                int start = (pageno - 1) * size + 1;
                out.println("<!-- pageno : " + pageno + ", size : " + size + ", length : " + length + ", start : " + start + ", maxpg : " + maxPageNo + "-->");
                out.println("<font size=5><b>Available Jobs in History </b></font>");
                out.println("(<i> <span class=\"small\">Displaying <b>" + length + "</b> jobs from <b>" + start + "</b> to <b>" + (start + length - 1) + "</b> out of <b>" + jobFiles.length + "</b> jobs");
                if (!"".equals(user)) {
                    out.println(" for user <b>" + user + "</b>");
                }
                if (!"".equals(jobname)) {
                    out.println(" with jobname having the keyword <b>" + jobname + "</b> in it.");
                }
                out.print("</span></i>)");
                out.println(" [<span class=\"small\"><a href=\"legacyjobhistory.jsp?pageno=-1&search=" + search + "\">show all</a></span>]");
                if (pageno > 1) {
                    out.println(" [<span class=\"small\"><a href=\"legacyjobhistory.jsp?pageno=1&search=" + search + "\">first page</a></span>]");
                } else {
                    out.println("[<span class=\"small\">first page]</span>");
                }
                if (pageno < maxPageNo) {
                    out.println(" [<span class=\"small\"><a href=\"legacyjobhistory.jsp?pageno=" + maxPageNo + "&search=" + search + "\">last page</a></span>]");
                } else {
                    out.println("<span class=\"small\">[last page]</span>");
                }
                Arrays.sort(jobFiles, new Comparator<Path>(){

                    @Override
                    public int compare(Path p1, Path p2) {
                        String dp1 = null;
                        String dp2 = null;
                        try {
                            dp1 = JobHistory.JobInfo.decodeJobHistoryFileName(p1.getName());
                            dp2 = JobHistory.JobInfo.decodeJobHistoryFileName(p2.getName());
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                        String[] split1 = dp1.split("_");
                        String[] split2 = dp2.split("_");
                        int res = new Date(Long.parseLong(split1[1])).compareTo(new Date(Long.parseLong(split2[1])));
                        if (res == 0) {
                            res = new Date(Long.parseLong(split1[3])).compareTo(new Date(Long.parseLong(split2[3])));
                        }
                        if (res == 0) {
                            Long l1 = Long.parseLong(split1[4]);
                            res = l1.compareTo(Long.parseLong(split2[4]));
                        }
                        return res;
                    }
                });
                out.println("<br><br>");
                this.printNavigation(pageno, size, maxPageNo, search, out);
                out.print("<table align=center border=2 cellpadding=\"5\" cellspacing=\"2\">");
                out.print("<tr>");
                out.print("<td>Job tracker Host Name</td><td>Job tracker Start time</td><td>Job Id</td><td>Name</td><td>User</td>");
                out.print("</tr>");
                HashSet<String> displayedJobs = new HashSet<String>();
                for (int i = start - 1; i < start + length - 1; ++i) {
                    Path jobFile = jobFiles[i];
                    String decodedJobFileName = JobHistory.JobInfo.decodeJobHistoryFileName(jobFile.getName());
                    String[] jobDetails = decodedJobFileName.split("_");
                    String trackerHostName = jobDetails[0];
                    String trackerStartTime = jobDetails[1];
                    String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
                    String userName = jobDetails[5];
                    String jobName = jobDetails[6];
                    if (displayedJobs.contains(jobId)) continue;
                    displayedJobs.add(jobId);
                    String encodedJobFileName = JobHistory.JobInfo.encodeJobHistoryFileName(jobFile.getName());
                    out.write("\n<center>\n");
                    this.printJob(trackerHostName, trackerStartTime, jobId, jobName, userName, new Path(jobFile.getParent(), encodedJobFileName), out);
                    out.write("\n</center> \n");
                }
                out.print("</table>");
                this.printNavigation(pageno, size, maxPageNo, search, out);
                out.write(10);
                out.write(" \n</body></html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block26;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

