/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.TestNettyServer;
import org.apache.avro.ipc.Transceiver;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;

public class TestNettyServerWithSSL
extends TestNettyServer {
    public static final String TEST_CERTIFICATE = "servercert.p12";
    public static final String TEST_CERTIFICATE_PASSWORD = "s3cret";

    protected static Server initializeServer(Responder responder) {
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
        return new NettyServer(responder, new InetSocketAddress(0), channelFactory, new SSLChannelPipelineFactory(), null);
    }

    protected static Transceiver initializeTransceiver(int serverPort) throws IOException {
        return new NettyTransceiver(new InetSocketAddress(serverPort), (ChannelFactory)new SSLChannelFactory(), 2000L);
    }

    private static class SSLChannelPipelineFactory
    implements ChannelPipelineFactory {
        private SSLChannelPipelineFactory() {
        }

        private SSLContext createServerSSLContext() {
            try {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(TestNettyServer.class.getResource(TestNettyServerWithSSL.TEST_CERTIFICATE).openStream(), TestNettyServerWithSSL.TEST_CERTIFICATE_PASSWORD.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.getAlgorithm());
                kmf.init(ks, TestNettyServerWithSSL.TEST_CERTIFICATE_PASSWORD.toCharArray());
                SSLContext serverContext = SSLContext.getInstance("TLS");
                serverContext.init(kmf.getKeyManagers(), null, null);
                return serverContext;
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the server-side SSLContext", e);
            }
        }

        private String getAlgorithm() {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            return algorithm;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            SSLEngine sslEngine = this.createServerSSLContext().createSSLEngine();
            sslEngine.setUseClientMode(false);
            pipeline.addLast("ssl", new SslHandler(sslEngine));
            return pipeline;
        }
    }

    private static class BogusTrustManager
    implements X509TrustManager {
        private BogusTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class SSLChannelFactory
    extends NioClientSocketChannelFactory {
        public SSLChannelFactory() {
            super(Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
        }

        @Override
        public SocketChannel newChannel(ChannelPipeline pipeline) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new BogusTrustManager()}, null);
                SSLEngine sslEngine = sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addFirst("ssl", new SslHandler(sslEngine));
                return super.newChannel(pipeline);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create SSL channel", ex);
            }
        }
    }
}

