#!/usr/bin/perl -w
##
## Copyright (c) 2004, Darren L. LaChausse
## ALL RIGHTS RESERVED
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. Neither the name of the Author nor the names of contributors
##    may be used to endorse or promote products derived from this software
##    without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
## ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
## DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
## OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
## LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
## OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
## SUCH DAMAGE.

##
## Include the test module
##
use Test::Simple tests => 46;

##
## Make a directory to contain the test files and chdir to it
##
ok(mkdir('files', 0777), 'Creating test file directory');
ok(chdir('files'), 'Changing to test file directory');

##
## Create some files for testing
##
create_test_files();

##
## Execute the keep script on them to keep a single file
##
ok(system("perl ../bin/keep -f filec") == 0,	"keep: Single file test");

##
## Make sure keep kept the right file
##
ok(!-e 'filea',			"->keep: was 'filea' deleted?");
ok(!-e 'fileb',			"->keep: was 'fileb' deleted?");
ok(-e 'filec',			"->keep: was 'filec' kept?");
ok(!-e 'filed',			"->keep: was 'filed' deleted?");

##
## Create some more files for testing
##
create_test_files();

##
## Execute the keep script on them to keep multiple files
##
ok(system("perl ../bin/keep -f fileb filed") == 0, "keep: Multiple file test");

##
## Make sure keep kept the right files
##
ok(!-e 'filea',			"->keep: was 'filea' deleted?");
ok(-e 'fileb',			"->keep: was 'fileb' kept?");
ok(!-e 'filec',			"->keep: was 'filec' deleted?");
ok(-e 'filed',			"->keep: was 'filed' kept?");

##
## Create some more files for testing
##
create_test_files();

##
## Execute the keep script on them to keep multiple files using wildcards
##
ok(system("perl ../bin/keep -f f*a fil?c") == 0, "keep: Multiple file test");

##
## Make sure keep kept the right files
##
ok(-e 'filea',			"->keep: was 'filea' kept?");
ok(!-e 'fileb',			"->keep: was 'fileb' deleted?");
ok(-e 'filec',			"->keep: was 'filec' kept?");
ok(!-e 'filed',			"->keep: was 'filed' deleted?");

##
## Delete the remaining files using keep
##
ok(system("perl ../bin/keep -f") == 0, "keep: Remaining files test");

##
## Make sure keep really deleted them
##
ok(!-e 'filea',			"->keep: was 'filea' deleted?");
ok(!-e 'filec',			"->keep: was 'filec' deleted?");

##
## Move back up to the original directory
##
ok(chdir('..'),		'Changing to original directory');

##
## Delete the test file directory
##
ok(rmdir('files'), 'Deleting the test file directory');

##
## Utility function that creates some files for testing
##
sub create_test_files
{
	ok(open(FILEA, ">> filea"),		"Creating test file [filea]");
	ok(print(FILEA "Test file [filea]\n"),	" and putting data in it.");
	ok(open(FILEB, ">> fileb"),		"Creating test file [fileb]");
	ok(print(FILEB "Test file [fileb]\n"),	" and putting data in it.");
	ok(open(FILEC, ">> filec"),		"Creating test file [filec]");
	ok(print(FILEC "Test file [filec]\n"),	" and putting data in it.");
	ok(open(FILED, ">> filed"),		"Creating test file [filed]");
	ok(print(FILED "Test file [filed]\n"),	" and putting data in it.");
}
