dnl *****************************************************************
dnl  ncurses Tests for Autoconf
dnl  Version 0.3.0
dnl  (c) 2000, 2002, 2007, 2009 by Kriang Lerdsuwanakij
dnl  lerdsuwa@users.sourceforge.net
dnl
dnl  This program is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU General Public License as published by
dnl  the Free Software Foundation; either version 2 of the License, or
dnl  (at your option) any later version.
dnl
dnl  This program is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU General Public License for more details.
dnl
dnl  As a special exception, the file `configure' generated by
dnl  `autoconf' from this file is not covered by the GNU General Public 
dnl  License.  This exception does not however invalidate any other
dnl  reasons why the generated file might be covered by the GNU General 
dnl  Public License.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this program; if not, write to the Free Software
dnl  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl

dnl *****************************************************************
dnl NCURSESAC_BOOL	Test for size of ncurses bool
dnl
dnl	Results:	ncursesac_cv_c_bool_size and ncursesac_cv_c_bool_equi
dnl			defined
dnl
AC_DEFUN([NCURSESAC_BOOL], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for size of ncurses bool])
  AC_CACHE_VAL(ncursesac_cv_c_bool_size, [
	AC_TRY_RUN([
	#include <$kNCURSES_HEADER>
	#include <stdio.h>
	#include <stdlib.h>
	int main()
	{
		FILE *f1, *f2;
		f1 = fopen("cf_kcd1.out", "w");
		f2 = fopen("cf_kcd2.out", "w");
		if (f1 && f2) {
			fprintf(f1, "%d", sizeof(bool));

			if (sizeof(bool) == sizeof(char))
				fprintf(f2, "char");
			else if (sizeof(bool) == sizeof(int))
				fprintf(f2, "int");
			else if (sizeof(bool) == sizeof(short))
				fprintf(f2, "short");
			else if (sizeof(bool) == sizeof(long))
				fprintf(f2, "long");

			fclose(f1);
			fclose(f2);
			exit(0); 
		}
		else
			exit(1); 
	}
	], [
		ncursesac_cv_c_bool_size=`cat cf_kcd1.out`
		ncursesac_cv_c_bool_equi=`cat cf_kcd2.out`
	], [
		ncursesac_cv_c_bool_size="N/A (error during test)"
		ncursesac_cv_c_bool_equi="N/A"
	], [
		ncursesac_cv_c_bool_size="N/A (due to cross-compilation)"
		ncursesac_cv_c_bool_equi="N/A"
	])
	rm -f cf_kcd1.out cf_kcd2.out
  ])
  AC_MSG_RESULT($ncursesac_cv_c_bool_size)
  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl NCURSESAC_MOUSEMASK	Test if mousemask is available
dnl
dnl	Results:	ncursesac_cv_have_mousemask and NCURSESAC_HAVE_MOUSEMASK
dnl
AC_DEFUN([NCURSESAC_MOUSEMASK], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for mousemask])
  AH_TEMPLATE([NCURSESAC_HAVE_MOUSEMASK],
	      [Define if you have mousemask in <curses.h> header file.])
  AC_CACHE_VAL(ncursesac_cv_have_mousemask, [
	AC_TRY_LINK([
	#include <$kNCURSES_HEADER>
	], [
	mmask_t oldMouseMask;
	mousemask(ALL_MOUSE_EVENTS, &oldMouseMask);
	], [
		ncursesac_cv_have_mousemask=yes
	], [
		ncursesac_cv_have_mousemask=no
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_have_mousemask)
  if test $ncursesac_cv_have_mousemask = yes; then
    AC_DEFINE(NCURSESAC_HAVE_MOUSEMASK)
  fi

  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl NCURSESAC_NEW_ATTR	Test if new attr_get and attr_set is used
dnl			New attr_get has 4 parameters while
dnl			old attr_get only has 1.
dnl
dnl	Results:	ncursesac_cv_new_attr_get_attr_set and
dnl			NCURSESAC_NEW_ATTR_GET_ATTR_SET
dnl
AC_DEFUN([NCURSESAC_NEW_ATTR], [
  AC_LANG_PUSH([C])
  AC_MSG_CHECKING([for new attr_get/attr_set])
  AH_TEMPLATE([NCURSESAC_NEW_ATTR_GET_ATTR_SET],
	      [Define if you have new attr_get/attr_set in <curses.h>
	       header file.])

  AC_CACHE_VAL(ncursesac_cv_new_attr, [
	AC_TRY_LINK([
	#include <$kNCURSES_HEADER>
	], [
	if (wattr_get(stdscr)) return 1;
	], [
		ncursesac_cv_new_attr=no
	], [
		ncursesac_cv_new_attr=yes
		
	])
  ])
  AC_MSG_RESULT($ncursesac_cv_new_attr)
  if test $ncursesac_cv_new_attr = yes; then
    AC_DEFINE(NCURSESAC_NEW_ATTR_GET_ATTR_SET)
  fi

  AC_LANG_POP([C])
])

dnl *****************************************************************
dnl  End of ncurses Tests for Autoconf
dnl *****************************************************************
