# $Id: Katuyou.pm,v 1.2 2006/11/01 11:58:59 kawahara Exp $
package Juman::Katuyou;
require 5.000;
use Juman::Grammar qw/ $FORM /;
use Juman::Hinsi qw/ get_form_id /;
use Encode;
use strict;

=head1 NAME

Juman::Katuyou - ǥ֥Ȥγѷ

=head1 DESCRIPTION

ǥ֥ L<Juman::Morpheme> γѷ᥽åɤɲ
롥

=head1 FILE

ѷ F<JUMAN.katuyou.db> 򻲾Ȥ롥μϡJuman Τ
°Ƥ뼭 F<JUMAN.katuyou> 鵡Ū졤F<Katuyou.pm> 
Ʊǥ쥯ȥ˥󥹥ȡ뤵ƤϤǤ롥

ʤѷ BerkeleyDB Ǻ졤L<DB_File> ⥸塼
̤ƥ롥juman-perl Υ󥹥ȡ L<DB_File> ⥸塼
뤬¸ߤʤȡκϹԤʤΤǡܥ⥸塼󶡤
᥽åɤѤǤʤ

=head1 METHODS

=over 4

=item kihonkei

Ǥδܷ֤

=cut
sub kihonkei {
    my( $this ) = @_;
    $this->change_katuyou2( 'ܷ' );
}

=item change_katuyou2 ( FORM )

ꤵ줿ѷ I<FORM> (ܷ̿ʤ)Ŀʷǥ֥
Ȥ֤ꤵ줿ѷ¸ߤʤ̤֤ͤ

=cut
sub change_katuyou2 {
    my( $this, $org_form ) = @_;
    my $form;
    if( utf8::is_utf8( $org_form ) ){
	$form = encode( 'euc-jp', $org_form ); # euc-jpˤɤ
    }
    else{
	$form = $org_form;
    }

    my $type = $this->katuyou1;
    if( utf8::is_utf8( $type ) ){
	$type = encode( 'euc-jp', $type ); # euc-jpˤɤ
    }

    my $id = &get_form_id( $type, $form );
    if( defined $id and $id > 0 ){
	# ѹѷ¸ߤ
	my $new = &_dup( $this );
	my @oldgobi = @{ $FORM->{$type}->[$this->katuyou2_id] }; # euc-jpǤȤ
	my @newgobi = @{ $FORM->{$type}->[$id] };
	if ( utf8::is_utf8( $this->midasi ) ){
	    map( { $_ = decode( 'euc-jp', $_ ) } @oldgobi ); # encodeƤʤencode
	    map( { $_ = decode( 'euc-jp', $_ ) } @newgobi );
	}
	$new->{midasi} = &_change_gobi( $this->midasi, $oldgobi[1], $newgobi[1] );
	$new->{yomi}   = &_change_gobi( $this->yomi,
					( $oldgobi[2] || $oldgobi[1] ),
					( $newgobi[2] || $newgobi[1] ) );
	$new->{katuyou2} = $org_form; # ȤencodingǳǼ
	$new->{katuyou2_id} = $id;
	$new;
    } else {
	# ѹѷ¸ߤʤ
	undef;
    }
}

# Ѳؿ
sub _change_gobi {
    my( $str, $cut, $add ) = @_;

    unless( $cut eq '*' ){
	$str =~ s/$cut\Z//;
    }
    unless( $add eq '*' ){
	$str .= $add;
    }
    $str;
}

# ǥ֥Ȥʣؿ
sub _dup {
    my( $this ) = @_;
    my $new = {};
    while( my( $key, $value ) = each %$this ){
	$new->{$key} = $value;
    }
    bless $new, ref $this;
}

1;

=back

=head1 SEE ALSO

=over 4

=item *

L<Juman::Morpheme>

=back

=head1 HISTORY

Υ⥸塼ϡL<KULM::Juman::Katuyou> ⥸塼򸶷Ȥƺ
줿

=head1 AUTHORS

=over 4

=item
ƣ  <sato@i.kyoto-u.ac.jp>

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
