// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple aarch64-arm-none-eabi -target-feature +neon -target-feature +bf16 \
// RUN:  -disable-O0-optnone -emit-llvm %s -o - | opt -S -mem2reg -instcombine | FileCheck %s

#include <arm_neon.h>

// CHECK-LABEL: @test_vcreate_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i64 [[A:%.*]] to <4 x bfloat>
// CHECK-NEXT:    ret <4 x bfloat> [[TMP0]]
//
bfloat16x4_t test_vcreate_bf16(uint64_t a) {
  return vcreate_bf16(a);
}

// CHECK-LABEL: @test_vdup_n_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECINIT_I:%.*]] = insertelement <4 x bfloat> undef, bfloat [[V:%.*]], i32 0
// CHECK-NEXT:    [[VECINIT3_I:%.*]] = shufflevector <4 x bfloat> [[VECINIT_I]], <4 x bfloat> undef, <4 x i32> zeroinitializer
// CHECK-NEXT:    ret <4 x bfloat> [[VECINIT3_I]]
//
bfloat16x4_t test_vdup_n_bf16(bfloat16_t v) {
  return vdup_n_bf16(v);
}

// CHECK-LABEL: @test_vdupq_n_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VECINIT_I:%.*]] = insertelement <8 x bfloat> undef, bfloat [[V:%.*]], i32 0
// CHECK-NEXT:    [[VECINIT7_I:%.*]] = shufflevector <8 x bfloat> [[VECINIT_I]], <8 x bfloat> undef, <8 x i32> zeroinitializer
// CHECK-NEXT:    ret <8 x bfloat> [[VECINIT7_I]]
//
bfloat16x8_t test_vdupq_n_bf16(bfloat16_t v) {
  return vdupq_n_bf16(v);
}

// CHECK-LABEL: @test_vdup_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <4 x bfloat> [[V:%.*]], <4 x bfloat> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
// CHECK-NEXT:    ret <4 x bfloat> [[LANE]]
//
bfloat16x4_t test_vdup_lane_bf16(bfloat16x4_t v) {
  return vdup_lane_bf16(v, 1);
}

// CHECK-LABEL: @test_vdupq_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <4 x bfloat> [[V:%.*]], <4 x bfloat> undef, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
// CHECK-NEXT:    ret <8 x bfloat> [[LANE]]
//
bfloat16x8_t test_vdupq_lane_bf16(bfloat16x4_t v) {
  return vdupq_lane_bf16(v, 1);
}

// CHECK-LABEL: @test_vdup_laneq_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <8 x bfloat> [[V:%.*]], <8 x bfloat> undef, <4 x i32> <i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <4 x bfloat> [[LANE]]
//
bfloat16x4_t test_vdup_laneq_bf16(bfloat16x8_t v) {
  return vdup_laneq_bf16(v, 7);
}

// CHECK-LABEL: @test_vdupq_laneq_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <8 x bfloat> [[V:%.*]], <8 x bfloat> undef, <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <8 x bfloat> [[LANE]]
//
bfloat16x8_t test_vdupq_laneq_bf16(bfloat16x8_t v) {
  return vdupq_laneq_bf16(v, 7);
}

// CHECK-LABEL: @test_vcombine_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <4 x bfloat> [[LOW:%.*]], <4 x bfloat> [[HIGH:%.*]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-NEXT:    ret <8 x bfloat> [[SHUFFLE_I]]
//
bfloat16x8_t test_vcombine_bf16(bfloat16x4_t low, bfloat16x4_t high) {
  return vcombine_bf16(low, high);
}

// CHECK-LABEL: @test_vget_high_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
// CHECK-NEXT:    ret <4 x bfloat> [[SHUFFLE_I]]
//
bfloat16x4_t test_vget_high_bf16(bfloat16x8_t a) {
  return vget_high_bf16(a);
}

// CHECK-LABEL: @test_vget_low_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-NEXT:    ret <4 x bfloat> [[SHUFFLE_I]]
//
bfloat16x4_t test_vget_low_bf16(bfloat16x8_t a) {
  return vget_low_bf16(a);
}

// CHECK-LABEL: @test_vget_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTCAST1:%.*]] = extractelement <4 x bfloat> [[V:%.*]], i32 1
// CHECK-NEXT:    ret bfloat [[DOTCAST1]]
//
bfloat16_t test_vget_lane_bf16(bfloat16x4_t v) {
  return vget_lane_bf16(v, 1);
}

// CHECK-LABEL: @test_vgetq_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTCAST1:%.*]] = extractelement <8 x bfloat> [[V:%.*]], i32 7
// CHECK-NEXT:    ret bfloat [[DOTCAST1]]
//
bfloat16_t test_vgetq_lane_bf16(bfloat16x8_t v) {
  return vgetq_lane_bf16(v, 7);
}

// CHECK-LABEL: @test_vset_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = insertelement <4 x bfloat> [[V:%.*]], bfloat [[A:%.*]], i32 1
// CHECK-NEXT:    ret <4 x bfloat> [[TMP0]]
//
bfloat16x4_t test_vset_lane_bf16(bfloat16_t a, bfloat16x4_t v) {
  return vset_lane_bf16(a, v, 1);
}

// CHECK-LABEL: @test_vsetq_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = insertelement <8 x bfloat> [[V:%.*]], bfloat [[A:%.*]], i32 7
// CHECK-NEXT:    ret <8 x bfloat> [[TMP0]]
//
bfloat16x8_t test_vsetq_lane_bf16(bfloat16_t a, bfloat16x8_t v) {
  return vsetq_lane_bf16(a, v, 7);
}

// CHECK-LABEL: @test_vduph_lane_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x bfloat> [[V:%.*]], i32 1
// CHECK-NEXT:    ret bfloat [[VGET_LANE]]
//
bfloat16_t test_vduph_lane_bf16(bfloat16x4_t v) {
  return vduph_lane_bf16(v, 1);
}

// CHECK-LABEL: @test_vduph_laneq_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x bfloat> [[V:%.*]], i32 7
// CHECK-NEXT:    ret bfloat [[VGETQ_LANE]]
//
bfloat16_t test_vduph_laneq_bf16(bfloat16x8_t v) {
  return vduph_laneq_bf16(v, 7);
}
