; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I

@src = global i32 0
@dst = global i32 0

; Tests that the common hi20 value (1) for the constants is used rather than
; redundantly re-materialised.
define void @imm32_cse() nounwind {
; RV32I-LABEL: imm32_cse:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    lui a1, %hi(src)
; RV32I-NEXT:    lw a2, %lo(src)(a1)
; RV32I-NEXT:    add a2, a2, a0
; RV32I-NEXT:    lui a3, %hi(dst)
; RV32I-NEXT:    sw a2, %lo(dst)(a3)
; RV32I-NEXT:    lw a2, %lo(src)(a1)
; RV32I-NEXT:    add a2, a2, a0
; RV32I-NEXT:    addi a2, a2, 1
; RV32I-NEXT:    sw a2, %lo(dst)(a3)
; RV32I-NEXT:    lw a1, %lo(src)(a1)
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    addi a0, a0, 2
; RV32I-NEXT:    sw a0, %lo(dst)(a3)
; RV32I-NEXT:    ret
  %1 = load volatile i32, i32* @src
  %2 = add i32 %1, 4097
  store volatile i32 %2, i32* @dst
  %3 = load volatile i32, i32* @src
  %4 = add i32 %3, 4098
  store volatile i32 %4, i32* @dst
  %5 = load volatile i32, i32* @src
  %6 = add i32 %5, 4099
  store volatile i32 %6, i32* @dst
  ret void
}
