var documenterSearchIndex = {"docs":
[{"location":"index.html#","page":"Home","title":"Home","text":"io = IOBuffer()\nrelease = isempty(VERSION.prerelease)\nv = \"$(VERSION.major).$(VERSION.minor)\"\n!release && (v = v*\"-$(first(VERSION.prerelease))\")\nprint(io, \"\"\"\n    # Julia $(v) Documentation\n\n    Welcome to the documentation for Julia $(v).\n\n    \"\"\")\nif !release\n    print(io,\"\"\"\n        !!! warning \"Work in progress!\"\n            This documentation is for an unreleased, in-development, version of Julia.\n        \"\"\")\nend\nimport Markdown\nMarkdown.parse(String(take!(io)))","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Please read the release notes to see what has changed since the last release.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"release = isempty(VERSION.prerelease)\nfile = release ? \"julia-$(VERSION).pdf\" :\n       \"julia-$(VERSION.major).$(VERSION.minor).$(VERSION.patch)-$(first(VERSION.prerelease)).pdf\"\nurl = \"https://raw.githubusercontent.com/JuliaLang/docs.julialang.org/assets/$(file)\"\nimport Markdown\nMarkdown.parse(\"\"\"\n!!! note\n    The documentation is also available in PDF format: [$file]($url).\n\"\"\")","category":"page"},{"location":"index.html#man-introduction-1","page":"Home","title":"Introduction","text":"","category":"section"},{"location":"index.html#","page":"Home","title":"Home","text":"Scientific computing has traditionally required the highest performance, yet domain experts have largely moved to slower dynamic languages for daily work. We believe there are many good reasons to prefer dynamic languages for these applications, and we do not expect their use to diminish. Fortunately, modern language design and compiler techniques make it possible to mostly eliminate the performance trade-off and provide a single environment productive enough for prototyping and efficient enough for deploying performance-intensive applications. The Julia programming language fills this role: it is a flexible dynamic language, appropriate for scientific and numerical computing, with performance comparable to traditional statically-typed languages.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Because Julia's compiler is different from the interpreters used for languages like Python or R, you may find that Julia's performance is unintuitive at first. If you find that something is slow, we highly recommend reading through the Performance Tips section before trying anything else. Once you understand how Julia works, it's easy to write code that's nearly as fast as C.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Julia features optional typing, multiple dispatch, and good performance, achieved using type inference and just-in-time (JIT) compilation, implemented using LLVM. It is multi-paradigm, combining features of imperative, functional, and object-oriented programming. Julia provides ease and expressiveness for high-level numerical computing, in the same way as languages such as R, MATLAB, and Python, but also supports general programming. To achieve this, Julia builds upon the lineage of mathematical programming languages, but also borrows much from popular dynamic languages, including Lisp, Perl, Python, Lua, and Ruby.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"The most significant departures of Julia from typical dynamic languages are:","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"The core language imposes very little; Julia Base and the standard library is written in Julia itself, including primitive operations like integer arithmetic\nA rich language of types for constructing and describing objects, that can also optionally be used to make type declarations\nThe ability to define function behavior across many combinations of argument types via multiple dispatch\nAutomatic generation of efficient, specialized code for different argument types\nGood performance, approaching that of statically-compiled languages like C","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Although one sometimes speaks of dynamic languages as being \"typeless\", they are definitely not: every object, whether primitive or user-defined, has a type. The lack of type declarations in most dynamic languages, however, means that one cannot instruct the compiler about the types of values, and often cannot explicitly talk about types at all. In static languages, on the other hand, while one can – and usually must – annotate types for the compiler, types exist only at compile time and cannot be manipulated or expressed at run time. In Julia, types are themselves run-time objects, and can also be used to convey information to the compiler.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"While the casual programmer need not explicitly use types or multiple dispatch, they are the core unifying features of Julia: functions are defined on different combinations of argument types, and applied by dispatching to the most specific matching definition. This model is a good fit for mathematical programming, where it is unnatural for the first argument to \"own\" an operation as in traditional object-oriented dispatch. Operators are just functions with special notation – to extend addition to new user-defined data types, you define new methods for the + function. Existing code then seamlessly applies to the new data types.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Partly because of run-time type inference (augmented by optional type annotations), and partly because of a strong focus on performance from the inception of the project, Julia's computational efficiency exceeds that of other dynamic languages, and even rivals that of statically-compiled languages. For large scale numerical problems, speed always has been, continues to be, and probably always will be crucial: the amount of data being processed has easily kept pace with Moore's Law over the past decades.","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Julia aims to create an unprecedented combination of ease-of-use, power, and efficiency in a single language. In addition to the above, some advantages of Julia over comparable systems include:","category":"page"},{"location":"index.html#","page":"Home","title":"Home","text":"Free and open source (MIT licensed)\nUser-defined types are as fast and compact as built-ins\nNo need to vectorize code for performance; devectorized code is fast\nDesigned for parallelism and distributed computation\nLightweight \"green\" threading (coroutines)\nUnobtrusive yet powerful type system\nElegant and extensible conversions and promotions for numeric and other types\nEfficient support for Unicode, including but not limited to UTF-8\nCall C functions directly (no wrappers or special APIs needed)\nPowerful shell-like capabilities for managing other processes\nLisp-like macros and other metaprogramming facilities","category":"page"},{"location":"NEWS.html#Julia-v1.2-Release-Notes-1","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"","category":"section"},{"location":"NEWS.html#New-language-features-1","page":"Julia v1.2 Release Notes","title":"New language features","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Argument splatting (x...) can now be used in calls to the new pseudo-function in constructors (#30577).\nSupport for Unicode 12.0.0 (#31561).\nAdded ⋆ (\\star) as unary operator (#31604).","category":"page"},{"location":"NEWS.html#Language-changes-1","page":"Julia v1.2 Release Notes","title":"Language changes","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Empty entries in JULIA_DEPOT_PATH are now expanded to default depot entries (#31009).","category":"page"},{"location":"NEWS.html#Multi-threading-changes-1","page":"Julia v1.2 Release Notes","title":"Multi-threading changes","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"The Condition type now has a thread-safe replacement, accessed as Threads.Condition. With that addition, task scheduling primitives such as ReentrantLock are now thread-safe (#30061).\nIt is possible to schedule and switch Tasks during @threads loops, and perform limited I/O (#31438).","category":"page"},{"location":"NEWS.html#Build-system-changes-1","page":"Julia v1.2 Release Notes","title":"Build system changes","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"The build system now prefers downloading prebuilt binary tarballs for most dependencies on supported systems, disable by setting USE_BINARYBUILDER=0 at make time (#31441).","category":"page"},{"location":"NEWS.html#New-library-functions-1","page":"Julia v1.2 Release Notes","title":"New library functions","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"getipaddrs() function returns all the IP addresses of the local machine, with IPv4 addresses sorting before IPv6 addresses ([#30349, #30604]).\ngetipaddr(addr_type) and getipaddrs(addr_type) functions returns an IP address(es) of the desired type of the local machine (#30604).\nAdded Base.hasproperty and Base.hasfield (#28850).\nOne argument !=(x), >(x), >=(x), <(x), <=(x) have been added, returning partially-applied versions of the functions, similar to the existing ==(x) and isequal(x) methods (#30915).","category":"page"},{"location":"NEWS.html#Standard-library-changes-1","page":"Julia v1.2 Release Notes","title":"Standard library changes","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Enum now behaves like a scalar when used in broadcasting (#30670).\nIf a pipeline is specified with append=true set, but no redirection, an ArgumentError is thrown, rather than a ErrorException (#27900).\nFunctions that invoke commands (e.g. run(::Cmd)) now throw a ProcessFailedException rather than an ErrorException, if those commands exit with non-zero exit code (#27900).\nThe extrema function now accepts a function argument in the same manner as minimum and maximum (#30323).\nhasmethod can now check for matching keyword argument names (#30712).\nstartswith and endswith now accept a Regex for the second argument (#29790).\nretry supports arbitrary callable objects (#30382).\nA no-argument constructor for Ptr{T} has been added which constructs a null pointer (#30919).\nstrip now accepts a function argument in the same manner as lstrip and rstrip (#31211).\nmktempdir now accepts a prefix keyword argument to customize the file name (#31230, #22922).\nkeytype and valtype now work on AbstractArray, and return the eltype of keys(...) and values(...) respectively (#27749).\nnextfloat(::BigFloat) and prevfloat(::BigFloat) now returns a value with the same precision as their argument, which means that (in particular) nextfloat(prevfloat(x)) == x whereas previously this could result in a completely different value with a different precision (#31310).\nmapreduce now accepts multiple iterators, similar to map (#31532).\nfilter now supports SkipMissing-wrapped arrays (#31235).\nObjects created by calling skipmissing on an array can now be indexed using indices from the parent at non-missing positions. This allows functions such as findall, findfirst, argmin/argmax and findmin/findmax to work with these objects, returning the index of matching non-missing elements in the parent (#31008).\ninv(::Missing) has now been added and returns missing (#31451).\nnextfloat(::BigFloat, n::Integer) and prevfloat(::BigFloat, n::Integer) methods have been added (#31310).","category":"page"},{"location":"NEWS.html#LinearAlgebra-1","page":"Julia v1.2 Release Notes","title":"LinearAlgebra","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Added keyword arguments rtol, atol to pinv and nullspace (#29998).\nUniformScaling instances are now callable such that e.g. I(3) will produce a Diagonal matrix (#30298).\nEigenvalues λ of general matrices are now sorted lexicographically by (Re λ, Im λ) (#21598).\none for structured matrices (Diagonal, Bidiagonal, Tridiagonal, Symtridiagonal) now preserves structure and type (#29777).\ndiagm(v) is now a shorthand for diagm(0 => v) (#31125).","category":"page"},{"location":"NEWS.html#SparseArrays-1","page":"Julia v1.2 Release Notes","title":"SparseArrays","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Performance improvements for sparse matrix-matrix multiplication (#30372).\nSparse vector outer products are more performant and maintain sparsity in products of the form kron(u, v'), u * v', and u .* v' where u and v are sparse vectors or column views (#24980).\nThe sprand function is now 2 to 5 times faster (#30494). As a consequence of this change, the random stream of matrices produced with sprand and sprandn has changed.","category":"page"},{"location":"NEWS.html#Sockets-1","page":"Julia v1.2 Release Notes","title":"Sockets","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"getipaddrs returns IP addresses in the order provided by libuv (#32260).\ngetipaddr prefers to return the first IPv4 interface address provided by libuv (#32260).","category":"page"},{"location":"NEWS.html#Statistics-1","page":"Julia v1.2 Release Notes","title":"Statistics","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"quantile now accepts in all cases collections whose eltype is not a subtype of Number (#30938).","category":"page"},{"location":"NEWS.html#Miscellaneous-1","page":"Julia v1.2 Release Notes","title":"Miscellaneous","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"Since environment variables on Windows are case-insensitive, ENV now converts its keys to uppercase for display, iteration, and copying (#30593).","category":"page"},{"location":"NEWS.html#External-dependencies-1","page":"Julia v1.2 Release Notes","title":"External dependencies","text":"","category":"section"},{"location":"NEWS.html#","page":"Julia v1.2 Release Notes","title":"Julia v1.2 Release Notes","text":"libgit2 has been updated to v0.27.7 (#30584).\nOpenBLAS has been updated to v0.3.5 (#30583).\nMbedTLS has been updated to v2.16.0 (#30618).\nlibunwind has been updated to v1.3.1 (#30724).","category":"page"},{"location":"manual/getting-started.html#man-getting-started-1","page":"Getting Started","title":"Getting Started","text":"","category":"section"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"Julia installation is straightforward, whether using precompiled binaries or compiling from source. Download and install Julia by following the instructions at https://julialang.org/downloads/.","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"The easiest way to learn and experiment with Julia is by starting an interactive session (also known as a read-eval-print loop or \"REPL\") by double-clicking the Julia executable or running julia from the command line:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"io = IOBuffer()\nBase.banner(io)\nbanner = String(take!(io))\nimport Markdown\nMarkdown.parse(\"```\\n\\$ julia\\n\\n$(banner)\\njulia> 1 + 2\\n3\\n\\njulia> ans\\n3\\n```\")","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"To exit the interactive session, type CTRL-D (press the Control/^ key together with the d key), or type exit(). When run in interactive mode, julia displays a banner and prompts the user for input. Once the user has entered a complete expression, such as 1 + 2, and hits enter, the interactive session evaluates the expression and shows its value. If an expression is entered into an interactive session with a trailing semicolon, its value is not shown. The variable ans is bound to the value of the last evaluated expression whether it is shown or not. The ans variable is only bound in interactive sessions, not when Julia code is run in other ways.","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"To evaluate expressions written in a source file file.jl, write include(\"file.jl\").","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"To run code in a file non-interactively, you can give it as the first argument to the julia command:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"$ julia script.jl arg1 arg2...","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"As the example implies, the following command-line arguments to julia are interpreted as command-line arguments to the program script.jl, passed in the global constant ARGS. The name of the script itself is passed in as the global PROGRAM_FILE. Note that ARGS is also set when a Julia expression is given using the -e option on the command line (see the julia help output below) but PROGRAM_FILE will be empty. For example, to just print the arguments given to a script, you could do this:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"$ julia -e 'println(PROGRAM_FILE); for x in ARGS; println(x); end' foo bar\n\nfoo\nbar","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"Or you could put that code into a script and run it:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"$ echo 'println(PROGRAM_FILE); for x in ARGS; println(x); end' > script.jl\n$ julia script.jl foo bar\nscript.jl\nfoo\nbar","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"The -- delimiter can be used to separate command-line arguments intended for the script file from arguments intended for Julia:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"$ julia --color=yes -O -- foo.jl arg1 arg2..","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"See also Scripting for more information on writing Julia scripts.","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"Julia can be started in parallel mode with either the -p or the --machine-file options. -p n will launch an additional n worker processes, while --machine-file file will launch a worker for each line in file file. The machines defined in file must be accessible via a password-less ssh login, with Julia installed at the same location as the current host. Each machine definition takes the form [count*][user@]host[:port] [bind_addr[:port]]. user defaults to current user, port to the standard ssh port. count is the number of workers to spawn on the node, and defaults to 1. The optional bind-to bind_addr[:port] specifies the IP address and port that other workers should use to connect to this worker.","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"If you have code that you want executed whenever Julia is run, you can put it in ~/.julia/config/startup.jl:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"$ echo 'println(\"Greetings! 你好! 안녕하세요?\")' > ~/.julia/config/startup.jl\n$ julia\nGreetings! 你好! 안녕하세요?\n\n...","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"There are various ways to run Julia code and provide options, similar to those available for the perl and ruby programs:","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"julia [switches] -- [programfile] [args...]","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"Switch Description\n-v, --version Display version information\n-h, --help Print this message\n--project[={<dir>|@.}] Set <dir> as the home project/environment. The default @. option will search through parent directories until a Project.toml or JuliaProject.toml file is found.\n-J, --sysimage <file> Start up with the given system image file\n-H, --home <dir> Set location of julia executable\n--startup-file={yes|no} Load ~/.julia/config/startup.jl\n--handle-signals={yes|no} Enable or disable Julia's default signal handlers\n--sysimage-native-code={yes|no} Use native code from system image if available\n--compiled-modules={yes|no} Enable or disable incremental precompilation of modules\n-e, --eval <expr> Evaluate <expr>\n-E, --print <expr> Evaluate <expr> and display the result\n-L, --load <file> Load <file> immediately on all processors\n-p, --procs {N|auto} Integer value N launches N additional local worker processes; auto launches as many workers as the number of local CPU threads (logical cores)\n--machine-file <file> Run processes on hosts listed in <file>\n-i Interactive mode; REPL runs and isinteractive() is true\n-q, --quiet Quiet startup: no banner, suppress REPL warnings\n--banner={yes|no|auto} Enable or disable startup banner\n--color={yes|no|auto} Enable or disable color text\n--history-file={yes|no} Load or save history\n--depwarn={yes|no|error} Enable or disable syntax and method deprecation warnings (error turns warnings into errors)\n--warn-overwrite={yes|no} Enable or disable method overwrite warnings\n-C, --cpu-target <target> Limit usage of CPU features up to <target>; set to help to see the available options\n-O, --optimize={0,1,2,3} Set the optimization level (default level is 2 if unspecified or 3 if used without a level)\n-g, -g <level> Enable / Set the level of debug info generation (default level is 1 if unspecified or 2 if used without a level)\n--inline={yes|no} Control whether inlining is permitted, including overriding @inline declarations\n--check-bounds={yes|no} Emit bounds checks always or never (ignoring declarations)\n--math-mode={ieee,fast} Disallow or enable unsafe floating point optimizations (overrides @fastmath declaration)\n--code-coverage={none|user|all} Count executions of source lines\n--code-coverage equivalent to --code-coverage=user\n--track-allocation={none|user|all} Count bytes allocated by each source line\n--track-allocation equivalent to --track-allocation=user","category":"page"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"compat: Julia 1.1\nIn Julia 1.0, the default --project=@. option did not search up from the root directory of a Git repository for the Project.toml file. From Julia 1.1 forward, it does.","category":"page"},{"location":"manual/getting-started.html#Resources-1","page":"Getting Started","title":"Resources","text":"","category":"section"},{"location":"manual/getting-started.html#","page":"Getting Started","title":"Getting Started","text":"A curated list of useful learning resources to help new users get started can be found on the learning page of the main Julia web site.","category":"page"},{"location":"manual/variables.html#Variables-1","page":"Variables","title":"Variables","text":"","category":"section"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"A variable, in Julia, is a name associated (or bound) to a value. It's useful when you want to store a value (that you obtained after some math, for example) for later use. For example:","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"# Assign the value 10 to the variable x\njulia> x = 10\n10\n\n# Doing math with x's value\njulia> x + 1\n11\n\n# Reassign x's value\njulia> x = 1 + 1\n2\n\n# You can assign values of other types, like strings of text\njulia> x = \"Hello World!\"\n\"Hello World!\"","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Julia provides an extremely flexible system for naming variables. Variable names are case-sensitive, and have no semantic meaning (that is, the language will not treat variables differently based on their names).","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"julia> x = 1.0\n1.0\n\njulia> y = -3\n-3\n\njulia> Z = \"My string\"\n\"My string\"\n\njulia> customary_phrase = \"Hello world!\"\n\"Hello world!\"\n\njulia> UniversalDeclarationOfHumanRightsStart = \"人人生而自由，在尊严和权利上一律平等。\"\n\"人人生而自由，在尊严和权利上一律平等。\"","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Unicode names (in UTF-8 encoding) are allowed:","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"julia> δ = 0.00001\n1.0e-5\n\njulia> 안녕하세요 = \"Hello\"\n\"Hello\"","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"In the Julia REPL and several other Julia editing environments, you can type many Unicode math symbols by typing the backslashed LaTeX symbol name followed by tab. For example, the variable name δ can be entered by typing \\delta-tab, or even α̂₂ by \\alpha-tab-\\hat- tab-\\_2-tab. (If you find a symbol somewhere, e.g. in someone else's code, that you don't know how to type, the REPL help will tell you: just type ? and then paste the symbol.)","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Julia will even let you redefine built-in constants and functions if needed (although this is not recommended to avoid potential confusions):","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"julia> pi = 3\n3\n\njulia> pi\n3\n\njulia> sqrt = 4\n4","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"However, if you try to redefine a built-in constant or function already in use, Julia will give you an error:","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"julia> pi\nπ = 3.1415926535897...\n\njulia> pi = 3\nERROR: cannot assign a value to variable MathConstants.pi from module Main\n\njulia> sqrt(100)\n10.0\n\njulia> sqrt = 4\nERROR: cannot assign a value to variable Base.sqrt from module Main","category":"page"},{"location":"manual/variables.html#Allowed-Variable-Names-1","page":"Variables","title":"Allowed Variable Names","text":"","category":"section"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Variable names must begin with a letter (A-Z or a-z), underscore, or a subset of Unicode code points greater than 00A0; in particular, Unicode character categories Lu/Ll/Lt/Lm/Lo/Nl (letters), Sc/So (currency and other symbols), and a few other letter-like characters (e.g. a subset of the Sm math symbols) are allowed. Subsequent characters may also include ! and digits (0-9 and other characters in categories Nd/No), as well as other Unicode code points: diacritics and other modifying marks (categories Mn/Mc/Me/Sk), some punctuation connectors (category Pc), primes, and a few other characters.","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Operators like + are also valid identifiers, but are parsed specially. In some contexts, operators can be used just like variables; for example (+) refers to the addition function, and (+) = f will reassign it. Most of the Unicode infix operators (in category Sm), such as ⊕, are parsed as infix operators and are available for user-defined methods (e.g. you can use const ⊗ = kron to define ⊗ as an infix Kronecker product).  Operators can also be suffixed with modifying marks, primes, and sub/superscripts, e.g. +̂ₐ″ is parsed as an infix operator with the same precedence as +.","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"The only explicitly disallowed names for variables are the names of built-in statements:","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"julia> else = false\nERROR: syntax: unexpected \"else\"\n\njulia> try = \"No\"\nERROR: syntax: unexpected \"=\"","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Some Unicode characters are considered to be equivalent in identifiers. Different ways of entering Unicode combining characters (e.g., accents) are treated as equivalent (specifically, Julia identifiers are NFC-normalized). The Unicode characters ɛ (U+025B: Latin small letter open e) and µ (U+00B5: micro sign) are treated as equivalent to the corresponding Greek letters, because the former are easily accessible via some input methods.","category":"page"},{"location":"manual/variables.html#Stylistic-Conventions-1","page":"Variables","title":"Stylistic Conventions","text":"","category":"section"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"While Julia imposes few restrictions on valid names, it has become useful to adopt the following conventions:","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"Names of variables are in lower case.\nWord separation can be indicated by underscores ('_'), but use of underscores is discouraged unless the name would be hard to read otherwise.\nNames of Types and Modules begin with a capital letter and word separation is shown with upper camel case instead of underscores.\nNames of functions and macros are in lower case, without underscores.\nFunctions that write to their arguments have names that end in !. These are sometimes called \"mutating\" or \"in-place\" functions because they are intended to produce changes in their arguments after the function is called, not just return a value.","category":"page"},{"location":"manual/variables.html#","page":"Variables","title":"Variables","text":"For more information about stylistic conventions, see the Style Guide.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Integers-and-Floating-Point-Numbers-1","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Integers and floating-point values are the basic building blocks of arithmetic and computation. Built-in representations of such values are called numeric primitives, while representations of integers and floating-point numbers as immediate values in code are known as numeric literals. For example, 1 is an integer literal, while 1.0 is a floating-point literal; their binary in-memory representations as objects are numeric primitives.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Julia provides a broad range of primitive numeric types, and a full complement of arithmetic and bitwise operators as well as standard mathematical functions are defined over them. These map directly onto numeric types and operations that are natively supported on modern computers, thus allowing Julia to take full advantage of computational resources. Additionally, Julia provides software support for Arbitrary Precision Arithmetic, which can handle operations on numeric values that cannot be represented effectively in native hardware representations, but at the cost of relatively slower performance.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The following are Julia's primitive numeric types:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Integer types:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Type Signed? Number of bits Smallest value Largest value\nInt8 ✓ 8 -2^7 2^7 - 1\nUInt8  8 0 2^8 - 1\nInt16 ✓ 16 -2^15 2^15 - 1\nUInt16  16 0 2^16 - 1\nInt32 ✓ 32 -2^31 2^31 - 1\nUInt32  32 0 2^32 - 1\nInt64 ✓ 64 -2^63 2^63 - 1\nUInt64  64 0 2^64 - 1\nInt128 ✓ 128 -2^127 2^127 - 1\nUInt128  128 0 2^128 - 1\nBool N/A 8 false (0) true (1)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Floating-point types:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Type Precision Number of bits\nFloat16 half 16\nFloat32 single 32\nFloat64 double 64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Additionally, full support for Complex and Rational Numbers is built on top of these primitive numeric types. All numeric types interoperate naturally without explicit casting, thanks to a flexible, user-extensible type promotion system.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Integers-1","page":"Integers and Floating-Point Numbers","title":"Integers","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Literal integers are represented in the standard manner:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 1\n1\n\njulia> 1234\n1234","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The default type for an integer literal depends on whether the target system has a 32-bit architecture or a 64-bit architecture:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"# 32-bit system:\njulia> typeof(1)\nInt32\n\n# 64-bit system:\njulia> typeof(1)\nInt64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The Julia internal variable Sys.WORD_SIZE indicates whether the target system is 32-bit or 64-bit:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"# 32-bit system:\njulia> Sys.WORD_SIZE\n32\n\n# 64-bit system:\njulia> Sys.WORD_SIZE\n64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Julia also defines the types Int and UInt, which are aliases for the system's signed and unsigned native integer types respectively:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"# 32-bit system:\njulia> Int\nInt32\njulia> UInt\nUInt32\n\n# 64-bit system:\njulia> Int\nInt64\njulia> UInt\nUInt64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Larger integer literals that cannot be represented using only 32 bits but can be represented in 64 bits always create 64-bit integers, regardless of the system type:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"# 32-bit or 64-bit system:\njulia> typeof(3000000000)\nInt64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Unsigned integers are input and output using the 0x prefix and hexadecimal (base 16) digits 0-9a-f (the capitalized digits A-F also work for input). The size of the unsigned value is determined by the number of hex digits used:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 0x1\n0x01\n\njulia> typeof(ans)\nUInt8\n\njulia> 0x123\n0x0123\n\njulia> typeof(ans)\nUInt16\n\njulia> 0x1234567\n0x01234567\n\njulia> typeof(ans)\nUInt32\n\njulia> 0x123456789abcdef\n0x0123456789abcdef\n\njulia> typeof(ans)\nUInt64\n\njulia> 0x11112222333344445555666677778888\n0x11112222333344445555666677778888\n\njulia> typeof(ans)\nUInt128","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"This behavior is based on the observation that when one uses unsigned hex literals for integer values, one typically is using them to represent a fixed numeric byte sequence, rather than just an integer value.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Recall that the variable ans is set to the value of the last expression evaluated in an interactive session. This does not occur when Julia code is run in other ways.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Binary and octal literals are also supported:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 0b10\n0x02\n\njulia> typeof(ans)\nUInt8\n\njulia> 0o010\n0x08\n\njulia> typeof(ans)\nUInt8\n\njulia> 0x00000000000000001111222233334444\n0x00000000000000001111222233334444\n\njulia> typeof(ans)\nUInt128","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"As for hexadecimal literals, binary and octal literals produce unsigned integer types. The size of the binary data item is the minimal needed size, if the leading digit of the literal is not 0. In the case of leading zeros, the size is determined by the minimal needed size for a literal, which has the same length but leading digit 1. That allows the user to control the size. Values which cannot be stored in UInt128 cannot be written as such literals.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Binary, octal, and hexadecimal literals may be signed by a - immediately preceding the unsigned literal. They produce an unsigned integer of the same size as the unsigned literal would do, with the two's complement of the value:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> -0x2\n0xfe\n\njulia> -0x0002\n0xfffe","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The minimum and maximum representable values of primitive numeric types such as integers are given by the typemin and typemax functions:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> (typemin(Int32), typemax(Int32))\n(-2147483648, 2147483647)\n\njulia> for T in [Int8,Int16,Int32,Int64,Int128,UInt8,UInt16,UInt32,UInt64,UInt128]\n           println(\"$(lpad(T,7)): [$(typemin(T)),$(typemax(T))]\")\n       end\n   Int8: [-128,127]\n  Int16: [-32768,32767]\n  Int32: [-2147483648,2147483647]\n  Int64: [-9223372036854775808,9223372036854775807]\n Int128: [-170141183460469231731687303715884105728,170141183460469231731687303715884105727]\n  UInt8: [0,255]\n UInt16: [0,65535]\n UInt32: [0,4294967295]\n UInt64: [0,18446744073709551615]\nUInt128: [0,340282366920938463463374607431768211455]","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The values returned by typemin and typemax are always of the given argument type. (The above expression uses several features that have yet to be introduced, including for loops, Strings, and Interpolation, but should be easy enough to understand for users with some existing programming experience.)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Overflow-behavior-1","page":"Integers and Floating-Point Numbers","title":"Overflow behavior","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"In Julia, exceeding the maximum representable value of a given type results in a wraparound behavior:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> x = typemax(Int64)\n9223372036854775807\n\njulia> x + 1\n-9223372036854775808\n\njulia> x + 1 == typemin(Int64)\ntrue","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Thus, arithmetic with Julia integers is actually a form of modular arithmetic. This reflects the characteristics of the underlying arithmetic of integers as implemented on modern computers. In applications where overflow is possible, explicit checking for wraparound produced by overflow is essential; otherwise, the BigInt type in Arbitrary Precision Arithmetic is recommended instead.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Division-errors-1","page":"Integers and Floating-Point Numbers","title":"Division errors","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Integer division (the div function) has two exceptional cases: dividing by zero, and dividing the lowest negative number (typemin) by -1. Both of these cases throw a DivideError. The remainder and modulus functions (rem and mod) throw a DivideError when their second argument is zero.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Floating-Point-Numbers-1","page":"Integers and Floating-Point Numbers","title":"Floating-Point Numbers","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Literal floating-point numbers are represented in the standard formats, using E-notation when necessary:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 1.0\n1.0\n\njulia> 1.\n1.0\n\njulia> 0.5\n0.5\n\njulia> .5\n0.5\n\njulia> -1.23\n-1.23\n\njulia> 1e10\n1.0e10\n\njulia> 2.5e-4\n0.00025","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The above results are all Float64 values. Literal Float32 values can be entered by writing an f in place of e:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 0.5f0\n0.5f0\n\njulia> typeof(ans)\nFloat32\n\njulia> 2.5f-4\n0.00025f0","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Values can be converted to Float32 easily:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> Float32(-1.5)\n-1.5f0\n\njulia> typeof(ans)\nFloat32","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Hexadecimal floating-point literals are also valid, but only as Float64 values, with p preceding the base-2 exponent:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 0x1p0\n1.0\n\njulia> 0x1.8p3\n12.0\n\njulia> 0x.4p-1\n0.125\n\njulia> typeof(ans)\nFloat64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Half-precision floating-point numbers are also supported (Float16), but they are implemented in software and use Float32 for calculations.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> sizeof(Float16(4.))\n2\n\njulia> 2*Float16(4.)\nFloat16(8.0)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The underscore _ can be used as digit separator:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 10_000, 0.000_000_005, 0xdead_beef, 0b1011_0010\n(10000, 5.0e-9, 0xdeadbeef, 0xb2)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Floating-point-zero-1","page":"Integers and Floating-Point Numbers","title":"Floating-point zero","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Floating-point numbers have two zeros, positive zero and negative zero. They are equal to each other but have different binary representations, as can be seen using the bitstring function:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 0.0 == -0.0\ntrue\n\njulia> bitstring(0.0)\n\"0000000000000000000000000000000000000000000000000000000000000000\"\n\njulia> bitstring(-0.0)\n\"1000000000000000000000000000000000000000000000000000000000000000\"","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Special-floating-point-values-1","page":"Integers and Floating-Point Numbers","title":"Special floating-point values","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"There are three specified standard floating-point values that do not correspond to any point on the real number line:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Float16 Float32 Float64 Name Description\nInf16 Inf32 Inf positive infinity a value greater than all finite floating-point values\n-Inf16 -Inf32 -Inf negative infinity a value less than all finite floating-point values\nNaN16 NaN32 NaN not a number a value not == to any floating-point value (including itself)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"For further discussion of how these non-finite floating-point values are ordered with respect to each other and other floats, see Numeric Comparisons. By the IEEE 754 standard, these floating-point values are the results of certain arithmetic operations:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 1/Inf\n0.0\n\njulia> 1/0\nInf\n\njulia> -5/0\n-Inf\n\njulia> 0.000001/0\nInf\n\njulia> 0/0\nNaN\n\njulia> 500 + Inf\nInf\n\njulia> 500 - Inf\n-Inf\n\njulia> Inf + Inf\nInf\n\njulia> Inf - Inf\nNaN\n\njulia> Inf * Inf\nInf\n\njulia> Inf / Inf\nNaN\n\njulia> 0 * Inf\nNaN","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The typemin and typemax functions also apply to floating-point types:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> (typemin(Float16),typemax(Float16))\n(-Inf16, Inf16)\n\njulia> (typemin(Float32),typemax(Float32))\n(-Inf32, Inf32)\n\njulia> (typemin(Float64),typemax(Float64))\n(-Inf, Inf)","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Machine-epsilon-1","page":"Integers and Floating-Point Numbers","title":"Machine epsilon","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Most real numbers cannot be represented exactly with floating-point numbers, and so for many purposes it is important to know the distance between two adjacent representable floating-point numbers, which is often known as machine epsilon.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Julia provides eps, which gives the distance between 1.0 and the next larger representable floating-point value:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> eps(Float32)\n1.1920929f-7\n\njulia> eps(Float64)\n2.220446049250313e-16\n\njulia> eps() # same as eps(Float64)\n2.220446049250313e-16","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"These values are 2.0^-23 and 2.0^-52 as Float32 and Float64 values, respectively. The eps function can also take a floating-point value as an argument, and gives the absolute difference between that value and the next representable floating point value. That is, eps(x) yields a value of the same type as x such that x + eps(x) is the next representable floating-point value larger than x:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> eps(1.0)\n2.220446049250313e-16\n\njulia> eps(1000.)\n1.1368683772161603e-13\n\njulia> eps(1e-27)\n1.793662034335766e-43\n\njulia> eps(0.0)\n5.0e-324","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The distance between two adjacent representable floating-point numbers is not constant, but is smaller for smaller values and larger for larger values. In other words, the representable floating-point numbers are densest in the real number line near zero, and grow sparser exponentially as one moves farther away from zero. By definition, eps(1.0) is the same as eps(Float64) since 1.0 is a 64-bit floating-point value.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Julia also provides the nextfloat and prevfloat functions which return the next largest or smallest representable floating-point number to the argument respectively:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> x = 1.25f0\n1.25f0\n\njulia> nextfloat(x)\n1.2500001f0\n\njulia> prevfloat(x)\n1.2499999f0\n\njulia> bitstring(prevfloat(x))\n\"00111111100111111111111111111111\"\n\njulia> bitstring(x)\n\"00111111101000000000000000000000\"\n\njulia> bitstring(nextfloat(x))\n\"00111111101000000000000000000001\"","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"This example highlights the general principle that the adjacent representable floating-point numbers also have adjacent binary integer representations.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Rounding-modes-1","page":"Integers and Floating-Point Numbers","title":"Rounding modes","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"If a number doesn't have an exact floating-point representation, it must be rounded to an appropriate representable value. However, the manner in which this rounding is done can be changed if required according to the rounding modes presented in the IEEE 754 standard.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The default mode used is always RoundNearest, which rounds to the nearest representable value, with ties rounded towards the nearest value with an even least significant bit.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Background-and-References-1","page":"Integers and Floating-Point Numbers","title":"Background and References","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Floating-point arithmetic entails many subtleties which can be surprising to users who are unfamiliar with the low-level implementation details. However, these subtleties are described in detail in most books on scientific computation, and also in the following references:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The definitive guide to floating point arithmetic is the IEEE 754-2008 Standard; however, it is not available for free online.\nFor a brief but lucid presentation of how floating-point numbers are represented, see John D. Cook's article on the subject as well as his introduction to some of the issues arising from how this representation differs in behavior from the idealized abstraction of real numbers.\nAlso recommended is Bruce Dawson's series of blog posts on floating-point numbers.\nFor an excellent, in-depth discussion of floating-point numbers and issues of numerical accuracy encountered when computing with them, see David Goldberg's paper What Every Computer Scientist Should Know About Floating-Point Arithmetic.\nFor even more extensive documentation of the history of, rationale for, and issues with floating-point numbers, as well as discussion of many other topics in numerical computing, see the collected writings of William Kahan, commonly known as the \"Father of Floating-Point\". Of particular interest may be An Interview with the Old Man of Floating-Point.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Arbitrary-Precision-Arithmetic-1","page":"Integers and Floating-Point Numbers","title":"Arbitrary Precision Arithmetic","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"To allow computations with arbitrary-precision integers and floating point numbers, Julia wraps the GNU Multiple Precision Arithmetic Library (GMP) and the GNU MPFR Library, respectively. The BigInt and BigFloat types are available in Julia for arbitrary precision integer and floating point numbers respectively.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Constructors exist to create these types from primitive numerical types, and parse can be used to construct them from AbstractStrings.  Once created, they participate in arithmetic with all other numeric types thanks to Julia's type promotion and conversion mechanism:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> BigInt(typemax(Int64)) + 1\n9223372036854775808\n\njulia> parse(BigInt, \"123456789012345678901234567890\") + 1\n123456789012345678901234567891\n\njulia> parse(BigFloat, \"1.23456789012345678901\")\n1.234567890123456789010000000000000000000000000000000000000000000000000000000004\n\njulia> BigFloat(2.0^66) / 3\n2.459565876494606882133333333333333333333333333333333333333333333333333333333344e+19\n\njulia> factorial(BigInt(40))\n815915283247897734345611269596115894272000000000","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"However, type promotion between the primitive types above and BigInt/BigFloat is not automatic and must be explicitly stated.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> x = typemin(Int64)\n-9223372036854775808\n\njulia> x = x - 1\n9223372036854775807\n\njulia> typeof(x)\nInt64\n\njulia> y = BigInt(typemin(Int64))\n-9223372036854775808\n\njulia> y = y - 1\n-9223372036854775809\n\njulia> typeof(y)\nBigInt","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The default precision (in number of bits of the significand) and rounding mode of BigFloat operations can be changed globally by calling setprecision and setrounding, and all further calculations will take these changes in account.  Alternatively, the precision or the rounding can be changed only within the execution of a particular block of code by using the same functions with a do block:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> setrounding(BigFloat, RoundUp) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.100000000000000000000000000000000000000000000000000000000000000000000000000003\n\njulia> setrounding(BigFloat, RoundDown) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.099999999999999999999999999999999999999999999999999999999999999999999999999986\n\njulia> setprecision(40) do\n           BigFloat(1) + parse(BigFloat, \"0.1\")\n       end\n1.1000000000004","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#man-numeric-literal-coefficients-1","page":"Integers and Floating-Point Numbers","title":"Numeric Literal Coefficients","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"To make common numeric formulae and expressions clearer, Julia allows variables to be immediately preceded by a numeric literal, implying multiplication. This makes writing polynomial expressions much cleaner:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> x = 3\n3\n\njulia> 2x^2 - 3x + 1\n10\n\njulia> 1.5x^2 - .5x + 1\n13.0","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"It also makes writing exponential functions more elegant:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 2^2x\n64","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The precedence of numeric literal coefficients is slightly lower than that of unary operators such as negation. So -2x is parsed as (-2) * x and √2x is parsed as (√2) * x. However, numeric literal coefficients parse similarly to unary operators when combined with exponentiation. For example 2^3x is parsed as 2^(3x), and 2x^3 is parsed as 2*(x^3).","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Numeric literals also work as coefficients to parenthesized expressions:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> 2(x-1)^2 - 3(x-1) + 1\n3","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"note: Note\nThe precedence of numeric literal coefficients used for implicit multiplication is higher than other binary operators such as multiplication (*), and division (/, \\, and //).  This means, for example, that 1 / 2im equals -0.5im and 6 // 2(2 + 1) equals 1 // 1.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Additionally, parenthesized expressions can be used as coefficients to variables, implying multiplication of the expression by the variable:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> (x-1)x\n6","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Neither juxtaposition of two parenthesized expressions, nor placing a variable before a parenthesized expression, however, can be used to imply multiplication:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> (x-1)(x+1)\nERROR: MethodError: objects of type Int64 are not callable\n\njulia> x(x+1)\nERROR: MethodError: objects of type Int64 are not callable","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Both expressions are interpreted as function application: any expression that is not a numeric literal, when immediately followed by a parenthetical, is interpreted as a function applied to the values in parentheses (see Functions for more about functions). Thus, in both of these cases, an error occurs since the left-hand value is not a function.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The above syntactic enhancements significantly reduce the visual noise incurred when writing common mathematical formulae. Note that no whitespace may come between a numeric literal coefficient and the identifier or parenthesized expression which it multiplies.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Syntax-Conflicts-1","page":"Integers and Floating-Point Numbers","title":"Syntax Conflicts","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Juxtaposed literal coefficient syntax may conflict with two numeric literal syntaxes: hexadecimal integer literals and engineering notation for floating-point literals. Here are some situations where syntactic conflicts arise:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"The hexadecimal integer literal expression 0xff could be interpreted as the numeric literal 0 multiplied by the variable xff.\nThe floating-point literal expression 1e10 could be interpreted as the numeric literal 1 multiplied by the variable e10, and similarly with the equivalent E form.\nThe 32-bit floating-point literal expression 1.5f22 could be interpreted as the numeric literal 1.5 multiplied by the variable f22.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"In all cases the ambiguity is resolved in favor of interpretation as numeric literals:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Expressions starting with 0x are always hexadecimal literals.\nExpressions starting with a numeric literal followed by e or E are always floating-point literals.\nExpressions starting with a numeric literal followed by f are always 32-bit floating-point literals.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Unlike E, which is equivalent to e in numeric literals for historical reasons, F is just another letter and does not behave like f in numeric literals. Hence, expressions starting with a numeric literal followed by F are interpreted as the numerical literal multiplied by a variable, which means that, for example, 1.5F22 is equal to 1.5 * F22.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#Literal-zero-and-one-1","page":"Integers and Floating-Point Numbers","title":"Literal zero and one","text":"","category":"section"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Julia provides functions which return literal 0 and 1 corresponding to a specified type or the type of a given variable.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Function Description\nzero(x) Literal zero of type x or type of variable x\none(x) Literal one of type x or type of variable x","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"These functions are useful in Numeric Comparisons to avoid overhead from unnecessary type conversion.","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"Examples:","category":"page"},{"location":"manual/integers-and-floating-point-numbers.html#","page":"Integers and Floating-Point Numbers","title":"Integers and Floating-Point Numbers","text":"julia> zero(Float32)\n0.0f0\n\njulia> zero(1.0)\n0.0\n\njulia> one(Int32)\n1\n\njulia> one(BigFloat)\n1.0","category":"page"},{"location":"manual/mathematical-operations.html#Mathematical-Operations-and-Elementary-Functions-1","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia provides a complete collection of basic arithmetic and bitwise operators across all of its numeric primitive types, as well as providing portable, efficient implementations of a comprehensive collection of standard mathematical functions.","category":"page"},{"location":"manual/mathematical-operations.html#Arithmetic-Operators-1","page":"Mathematical Operations and Elementary Functions","title":"Arithmetic Operators","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The following arithmetic operators are supported on all primitive numeric types:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Expression Name Description\n+x unary plus the identity operation\n-x unary minus maps values to their additive inverses\nx + y binary plus performs addition\nx - y binary minus performs subtraction\nx * y times performs multiplication\nx / y divide performs division\nx ÷ y integer divide x / y, truncated to an integer\nx \\ y inverse divide equivalent to y / x\nx ^ y power raises x to the yth power\nx % y remainder equivalent to rem(x,y)","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"as well as the negation on Bool types:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Expression Name Description\n!x negation changes true to false and vice versa","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia's promotion system makes arithmetic operations on mixtures of argument types \"just work\" naturally and automatically. See Conversion and Promotion for details of the promotion system.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Here are some simple examples using arithmetic operators:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> 1 + 2 + 3\n6\n\njulia> 1 - 2\n-1\n\njulia> 3*2/12\n0.5","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"(By convention, we tend to space operators more tightly if they get applied before other nearby operators. For instance, we would generally write -x + 2 to reflect that first x gets negated, and then 2 is added to that result.)","category":"page"},{"location":"manual/mathematical-operations.html#Bitwise-Operators-1","page":"Mathematical Operations and Elementary Functions","title":"Bitwise Operators","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The following bitwise operators are supported on all primitive integer types:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Expression Name\n~x bitwise not\nx & y bitwise and\nx | y bitwise or\nx ⊻ y bitwise xor (exclusive or)\nx >>> y logical shift right\nx >> y arithmetic shift right\nx << y logical/arithmetic shift left","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Here are some examples with bitwise operators:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> ~123\n-124\n\njulia> 123 & 234\n106\n\njulia> 123 | 234\n251\n\njulia> 123 ⊻ 234\n145\n\njulia> xor(123, 234)\n145\n\njulia> ~UInt32(123)\n0xffffff84\n\njulia> ~UInt8(123)\n0x84","category":"page"},{"location":"manual/mathematical-operations.html#Updating-operators-1","page":"Mathematical Operations and Elementary Functions","title":"Updating operators","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Every binary arithmetic and bitwise operator also has an updating version that assigns the result of the operation back into its left operand. The updating version of the binary operator is formed by placing a = immediately after the operator. For example, writing x += 3 is equivalent to writing x = x + 3:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> x = 1\n1\n\njulia> x += 3\n4\n\njulia> x\n4","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The updating versions of all the binary arithmetic and bitwise operators are:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"+=  -=  *=  /=  \\=  ÷=  %=  ^=  &=  |=  ⊻=  >>>=  >>=  <<=","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"note: Note\nAn updating operator rebinds the variable on the left-hand side. As a result, the type of the variable may change.julia> x = 0x01; typeof(x)\nUInt8\n\njulia> x *= 2 # Same as x = x * 2\n2\n\njulia> typeof(x)\nInt64","category":"page"},{"location":"manual/mathematical-operations.html#man-dot-operators-1","page":"Mathematical Operations and Elementary Functions","title":"Vectorized \"dot\" operators","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"For every binary operation like ^, there is a corresponding \"dot\" operation .^ that is automatically defined to perform ^ element-by-element on arrays. For example, [1,2,3] ^ 3 is not defined, since there is no standard mathematical meaning to \"cubing\" a (non-square) array, but [1,2,3] .^ 3 is defined as computing the elementwise (or \"vectorized\") result [1^3, 2^3, 3^3].  Similarly for unary operators like ! or √, there is a corresponding .√ that applies the operator elementwise.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> [1,2,3] .^ 3\n3-element Array{Int64,1}:\n  1\n  8\n 27","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"More specifically, a .^ b is parsed as the \"dot\" call (^).(a,b), which performs a broadcast operation: it can combine arrays and scalars, arrays of the same size (performing the operation elementwise), and even arrays of different shapes (e.g. combining row and column vectors to produce a matrix). Moreover, like all vectorized \"dot calls,\" these \"dot operators\" are fusing. For example, if you compute 2 .* A.^2 .+ sin.(A) (or equivalently @. 2A^2 + sin(A), using the @. macro) for an array A, it performs a single loop over A, computing 2a^2 + sin(a) for each element of A. In particular, nested dot calls like f.(g.(x)) are fused, and \"adjacent\" binary operators like x .+ 3 .* x.^2 are equivalent to nested dot calls (+).(x, (*).(3, (^).(x, 2))).","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Furthermore, \"dotted\" updating operators like a .+= b (or @. a += b) are parsed as a .= a .+ b, where .= is a fused in-place assignment operation (see the dot syntax documentation).","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Note the dot syntax is also applicable to user-defined operators. For example, if you define ⊗(A,B) = kron(A,B) to give a convenient infix syntax A ⊗ B for Kronecker products (kron), then [A,B] .⊗ [C,D] will compute [A⊗C, B⊗D] with no additional coding.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Combining dot operators with numeric literals can be ambiguous. For example, it is not clear whether 1.+x means 1. + x or 1 .+ x. Therefore this syntax is disallowed, and spaces must be used around the operator in such cases.","category":"page"},{"location":"manual/mathematical-operations.html#Numeric-Comparisons-1","page":"Mathematical Operations and Elementary Functions","title":"Numeric Comparisons","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Standard comparison operations are defined for all the primitive numeric types:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Operator Name\n== equality\n!=, ≠ inequality\n< less than\n<=, ≤ less than or equal to\n> greater than\n>=, ≥ greater than or equal to","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Here are some simple examples:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> 1 == 1\ntrue\n\njulia> 1 == 2\nfalse\n\njulia> 1 != 2\ntrue\n\njulia> 1 == 1.0\ntrue\n\njulia> 1 < 2\ntrue\n\njulia> 1.0 > 3\nfalse\n\njulia> 1 >= 1.0\ntrue\n\njulia> -1 <= 1\ntrue\n\njulia> -1 <= -1\ntrue\n\njulia> -1 <= -2\nfalse\n\njulia> 3 < -0.5\nfalse","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Integers are compared in the standard manner – by comparison of bits. Floating-point numbers are compared according to the IEEE 754 standard:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Finite numbers are ordered in the usual manner.\nPositive zero is equal but not greater than negative zero.\nInf is equal to itself and greater than everything else except NaN.\n-Inf is equal to itself and less then everything else except NaN.\nNaN is not equal to, not less than, and not greater than anything, including itself.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The last point is potentially surprising and thus worth noting:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> NaN == NaN\nfalse\n\njulia> NaN != NaN\ntrue\n\njulia> NaN < NaN\nfalse\n\njulia> NaN > NaN\nfalse","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"and can cause especial headaches with arrays:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> [1 NaN] == [1 NaN]\nfalse","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia provides additional functions to test numbers for special values, which can be useful in situations like hash key comparisons:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Function Tests if\nisequal(x, y) x and y are identical\nisfinite(x) x is a finite number\nisinf(x) x is infinite\nisnan(x) x is not a number","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"isequal considers NaNs equal to each other:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> isequal(NaN, NaN)\ntrue\n\njulia> isequal([1 NaN], [1 NaN])\ntrue\n\njulia> isequal(NaN, NaN32)\ntrue","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"isequal can also be used to distinguish signed zeros:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> -0.0 == 0.0\ntrue\n\njulia> isequal(-0.0, 0.0)\nfalse","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Mixed-type comparisons between signed integers, unsigned integers, and floats can be tricky. A great deal of care has been taken to ensure that Julia does them correctly.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"For other types, isequal defaults to calling ==, so if you want to define equality for your own types then you only need to add a == method.  If you define your own equality function, you should probably define a corresponding hash method to ensure that isequal(x,y) implies hash(x) == hash(y).","category":"page"},{"location":"manual/mathematical-operations.html#Chaining-comparisons-1","page":"Mathematical Operations and Elementary Functions","title":"Chaining comparisons","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Unlike most languages, with the notable exception of Python, comparisons can be arbitrarily chained:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> 1 < 2 <= 2 < 3 == 3 > 2 >= 1 == 1 < 3 != 5\ntrue","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Chaining comparisons is often quite convenient in numerical code. Chained comparisons use the && operator for scalar comparisons, and the & operator for elementwise comparisons, which allows them to work on arrays. For example, 0 .< A .< 1 gives a boolean array whose entries are true where the corresponding elements of A are between 0 and 1.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Note the evaluation behavior of chained comparisons:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> v(x) = (println(x); x)\nv (generic function with 1 method)\n\njulia> v(1) < v(2) <= v(3)\n2\n1\n3\ntrue\n\njulia> v(1) > v(2) <= v(3)\n2\n1\nfalse","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The middle expression is only evaluated once, rather than twice as it would be if the expression were written as v(1) < v(2) && v(2) <= v(3). However, the order of evaluations in a chained comparison is undefined. It is strongly recommended not to use expressions with side effects (such as printing) in chained comparisons. If side effects are required, the short-circuit && operator should be used explicitly (see Short-Circuit Evaluation).","category":"page"},{"location":"manual/mathematical-operations.html#Elementary-Functions-1","page":"Mathematical Operations and Elementary Functions","title":"Elementary Functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia provides a comprehensive collection of mathematical functions and operators. These mathematical operations are defined over as broad a class of numerical values as permit sensible definitions, including integers, floating-point numbers, rationals, and complex numbers, wherever such definitions make sense.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Moreover, these functions (like any Julia function) can be applied in \"vectorized\" fashion to arrays and other collections with the dot syntax f.(A), e.g. sin.(A) will compute the sine of each element of an array A.","category":"page"},{"location":"manual/mathematical-operations.html#Operator-Precedence-and-Associativity-1","page":"Mathematical Operations and Elementary Functions","title":"Operator Precedence and Associativity","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia applies the following order and associativity of operations, from highest precedence to lowest:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Category Operators Associativity\nSyntax . followed by :: Left\nExponentiation ^ Right\nUnary + - √ Right[1]\nBitshifts << >> >>> Left\nFractions // Left\nMultiplication * / % & \\ ÷ Left[2]\nAddition + - | ⊻ Left[2]\nSyntax : .. Left\nSyntax |> Left\nSyntax <| Right\nComparisons > < >= <= == === != !== <: Non-associative\nControl flow && followed by || followed by ? Right\nPair => Right\nAssignments = += -= *= /= //= \\= ^= ÷= %= |= &= ⊻= <<= >>= >>>= Right","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"[1]: The unary operators + and - require explicit parentheses around their argument to disambiguate them from the operator ++, etc. Other compositions of unary operators are parsed with right-associativity, e. g., √√-a as √(√(-a)).","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"[2]: The operators +, ++ and * are non-associative. a + b + c is parsed as +(a, b, c) not +(+(a, b), c). However, the fallback methods for +(a, b, c, d...) and *(a, b, c, d...) both default to left-associative evaluation.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"For a complete list of every Julia operator's precedence, see the top of this file: src/julia-parser.scm","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"You can also find the numerical precedence for any given operator via the built-in function Base.operator_precedence, where higher numbers take precedence:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> Base.operator_precedence(:+), Base.operator_precedence(:*), Base.operator_precedence(:.)\n(11, 13, 17)\n\njulia> Base.operator_precedence(:sin), Base.operator_precedence(:+=), Base.operator_precedence(:(=))  # (Note the necessary parens on `:(=)`)\n(0, 1, 1)","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"A symbol representing the operator associativity can also be found by calling the built-in function Base.operator_associativity:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> Base.operator_associativity(:-), Base.operator_associativity(:+), Base.operator_associativity(:^)\n(:left, :none, :right)\n\njulia> Base.operator_associativity(:⊗), Base.operator_associativity(:sin), Base.operator_associativity(:→)\n(:left, :none, :right)","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Note that symbols such as :sin return precedence 0. This value represents invalid operators and not operators of lowest precedence. Similarly, such operators are assigned associativity :none.","category":"page"},{"location":"manual/mathematical-operations.html#Numerical-Conversions-1","page":"Mathematical Operations and Elementary Functions","title":"Numerical Conversions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Julia supports three forms of numerical conversion, which differ in their handling of inexact conversions.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The notation T(x) or convert(T,x) converts x to a value of type T.\nIf T is a floating-point type, the result is the nearest representable value, which could be positive or negative infinity.\nIf T is an integer type, an InexactError is raised if x is not representable by T.\nx % T converts an integer x to a value of integer type T congruent to x modulo 2^n, where n is the number of bits in T. In other words, the binary representation is truncated to fit.\nThe Rounding functions take a type T as an optional argument. For example, round(Int,x) is a shorthand for Int(round(x)).","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"The following examples show the different forms.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"julia> Int8(127)\n127\n\njulia> Int8(128)\nERROR: InexactError: trunc(Int8, 128)\nStacktrace:\n[...]\n\njulia> Int8(127.0)\n127\n\njulia> Int8(3.14)\nERROR: InexactError: Int8(3.14)\nStacktrace:\n[...]\n\njulia> Int8(128.0)\nERROR: InexactError: Int8(128.0)\nStacktrace:\n[...]\n\njulia> 127 % Int8\n127\n\njulia> 128 % Int8\n-128\n\njulia> round(Int8,127.4)\n127\n\njulia> round(Int8,127.6)\nERROR: InexactError: trunc(Int8, 128.0)\nStacktrace:\n[...]","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"See Conversion and Promotion for how to define your own conversions and promotions.","category":"page"},{"location":"manual/mathematical-operations.html#Rounding-functions-1","page":"Mathematical Operations and Elementary Functions","title":"Rounding functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Function Description Return type\nround(x) round x to the nearest integer typeof(x)\nround(T, x) round x to the nearest integer T\nfloor(x) round x towards -Inf typeof(x)\nfloor(T, x) round x towards -Inf T\nceil(x) round x towards +Inf typeof(x)\nceil(T, x) round x towards +Inf T\ntrunc(x) round x towards zero typeof(x)\ntrunc(T, x) round x towards zero T","category":"page"},{"location":"manual/mathematical-operations.html#Division-functions-1","page":"Mathematical Operations and Elementary Functions","title":"Division functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Function Description\ndiv(x,y), x÷y truncated division; quotient rounded towards zero\nfld(x,y) floored division; quotient rounded towards -Inf\ncld(x,y) ceiling division; quotient rounded towards +Inf\nrem(x,y) remainder; satisfies x == div(x,y)*y + rem(x,y); sign matches x\nmod(x,y) modulus; satisfies x == fld(x,y)*y + mod(x,y); sign matches y\nmod1(x,y) mod with offset 1; returns r∈(0,y] for y>0 or r∈[y,0) for y<0, where mod(r, y) == mod(x, y)\nmod2pi(x) modulus with respect to 2pi;  0 <= mod2pi(x)    < 2pi\ndivrem(x,y) returns (div(x,y),rem(x,y))\nfldmod(x,y) returns (fld(x,y),mod(x,y))\ngcd(x,y...) greatest positive common divisor of x, y,...\nlcm(x,y...) least positive common multiple of x, y,...","category":"page"},{"location":"manual/mathematical-operations.html#Sign-and-absolute-value-functions-1","page":"Mathematical Operations and Elementary Functions","title":"Sign and absolute value functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Function Description\nabs(x) a positive value with the magnitude of x\nabs2(x) the squared magnitude of x\nsign(x) indicates the sign of x, returning -1, 0, or +1\nsignbit(x) indicates whether the sign bit is on (true) or off (false)\ncopysign(x,y) a value with the magnitude of x and the sign of y\nflipsign(x,y) a value with the magnitude of x and the sign of x*y","category":"page"},{"location":"manual/mathematical-operations.html#Powers,-logs-and-roots-1","page":"Mathematical Operations and Elementary Functions","title":"Powers, logs and roots","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Function Description\nsqrt(x), √x square root of x\ncbrt(x), ∛x cube root of x\nhypot(x,y) hypotenuse of right-angled triangle with other sides of length x and y\nexp(x) natural exponential function at x\nexpm1(x) accurate exp(x)-1 for x near zero\nldexp(x,n) x*2^n computed efficiently for integer values of n\nlog(x) natural logarithm of x\nlog(b,x) base b logarithm of x\nlog2(x) base 2 logarithm of x\nlog10(x) base 10 logarithm of x\nlog1p(x) accurate log(1+x) for x near zero\nexponent(x) binary exponent of x\nsignificand(x) binary significand (a.k.a. mantissa) of a floating-point number x","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"For an overview of why functions like hypot, expm1, and log1p are necessary and useful, see John D. Cook's excellent pair of blog posts on the subject: expm1, log1p, erfc, and hypot.","category":"page"},{"location":"manual/mathematical-operations.html#Trigonometric-and-hyperbolic-functions-1","page":"Mathematical Operations and Elementary Functions","title":"Trigonometric and hyperbolic functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"All the standard trigonometric and hyperbolic functions are also defined:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"sin    cos    tan    cot    sec    csc\nsinh   cosh   tanh   coth   sech   csch\nasin   acos   atan   acot   asec   acsc\nasinh  acosh  atanh  acoth  asech  acsch\nsinc   cosc","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"These are all single-argument functions, with atan also accepting two arguments corresponding to a traditional atan2 function.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Additionally, sinpi(x) and cospi(x) are provided for more accurate computations of sin(pi*x) and cos(pi*x) respectively.","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"In order to compute trigonometric functions with degrees instead of radians, suffix the function with d. For example, sind(x) computes the sine of x where x is specified in degrees. The complete list of trigonometric functions with degree variants is:","category":"page"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"sind   cosd   tand   cotd   secd   cscd\nasind  acosd  atand  acotd  asecd  acscd","category":"page"},{"location":"manual/mathematical-operations.html#Special-functions-1","page":"Mathematical Operations and Elementary Functions","title":"Special functions","text":"","category":"section"},{"location":"manual/mathematical-operations.html#","page":"Mathematical Operations and Elementary Functions","title":"Mathematical Operations and Elementary Functions","text":"Many other special mathematical functions are provided by the package SpecialFunctions.jl.","category":"page"},{"location":"manual/complex-and-rational-numbers.html#Complex-and-Rational-Numbers-1","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"","category":"section"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Julia includes predefined types for both complex and rational numbers, and supports all the standard Mathematical Operations and Elementary Functions on them. Conversion and Promotion are defined so that operations on any combination of predefined numeric types, whether primitive or composite, behave as expected.","category":"page"},{"location":"manual/complex-and-rational-numbers.html#Complex-Numbers-1","page":"Complex and Rational Numbers","title":"Complex Numbers","text":"","category":"section"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"The global constant im is bound to the complex number i, representing the principal square root of -1. (Using mathematicians' i or engineers' j for this global constant were rejected since they are such popular index variable names.) Since Julia allows numeric literals to be juxtaposed with identifiers as coefficients, this binding suffices to provide convenient syntax for complex numbers, similar to the traditional mathematical notation:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 1+2im\n1 + 2im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"You can perform all the standard arithmetic operations with complex numbers:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> (1 + 2im)*(2 - 3im)\n8 + 1im\n\njulia> (1 + 2im)/(1 - 2im)\n-0.6 + 0.8im\n\njulia> (1 + 2im) + (1 - 2im)\n2 + 0im\n\njulia> (-3 + 2im) - (5 - 1im)\n-8 + 3im\n\njulia> (-1 + 2im)^2\n-3 - 4im\n\njulia> (-1 + 2im)^2.5\n2.729624464784009 - 6.9606644595719im\n\njulia> (-1 + 2im)^(1 + 1im)\n-0.27910381075826657 + 0.08708053414102428im\n\njulia> 3(2 - 5im)\n6 - 15im\n\njulia> 3(2 - 5im)^2\n-63 - 60im\n\njulia> 3(2 - 5im)^-1.0\n0.20689655172413796 + 0.5172413793103449im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"The promotion mechanism ensures that combinations of operands of different types just work:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 2(1 - 1im)\n2 - 2im\n\njulia> (2 + 3im) - 1\n1 + 3im\n\njulia> (1 + 2im) + 0.5\n1.5 + 2.0im\n\njulia> (2 + 3im) - 0.5im\n2.0 + 2.5im\n\njulia> 0.75(1 + 2im)\n0.75 + 1.5im\n\njulia> (2 + 3im) / 2\n1.0 + 1.5im\n\njulia> (1 - 3im) / (2 + 2im)\n-0.5 - 1.0im\n\njulia> 2im^2\n-2 + 0im\n\njulia> 1 + 3/4im\n1.0 - 0.75im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Note that 3/4im == 3/(4*im) == -(3/4*im), since a literal coefficient binds more tightly than division.","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Standard functions to manipulate complex values are provided:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> z = 1 + 2im\n1 + 2im\n\njulia> real(1 + 2im) # real part of z\n1\n\njulia> imag(1 + 2im) # imaginary part of z\n2\n\njulia> conj(1 + 2im) # complex conjugate of z\n1 - 2im\n\njulia> abs(1 + 2im) # absolute value of z\n2.23606797749979\n\njulia> abs2(1 + 2im) # squared absolute value\n5\n\njulia> angle(1 + 2im) # phase angle in radians\n1.1071487177940904","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"As usual, the absolute value (abs) of a complex number is its distance from zero. abs2 gives the square of the absolute value, and is of particular use for complex numbers since it avoids taking a square root. angle returns the phase angle in radians (also known as the argument or arg function). The full gamut of other Elementary Functions is also defined for complex numbers:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> sqrt(1im)\n0.7071067811865476 + 0.7071067811865475im\n\njulia> sqrt(1 + 2im)\n1.272019649514069 + 0.7861513777574233im\n\njulia> cos(1 + 2im)\n2.0327230070196656 - 3.0518977991518im\n\njulia> exp(1 + 2im)\n-1.1312043837568135 + 2.4717266720048188im\n\njulia> sinh(1 + 2im)\n-0.4890562590412937 + 1.4031192506220405im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Note that mathematical functions typically return real values when applied to real numbers and complex values when applied to complex numbers. For example, sqrt behaves differently when applied to -1 versus -1 + 0im even though -1 == -1 + 0im:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]\n\njulia> sqrt(-1 + 0im)\n0.0 + 1.0im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"The literal numeric coefficient notation does not work when constructing a complex number from variables. Instead, the multiplication must be explicitly written out:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> a = 1; b = 2; a + b*im\n1 + 2im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"However, this is not recommended. Instead, use the more efficient complex function to construct a complex value directly from its real and imaginary parts:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> a = 1; b = 2; complex(a, b)\n1 + 2im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"This construction avoids the multiplication and addition operations.","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Inf and NaN propagate through complex numbers in the real and imaginary parts of a complex number as described in the Special floating-point values section:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 1 + Inf*im\n1.0 + Inf*im\n\njulia> 1 + NaN*im\n1.0 + NaN*im","category":"page"},{"location":"manual/complex-and-rational-numbers.html#Rational-Numbers-1","page":"Complex and Rational Numbers","title":"Rational Numbers","text":"","category":"section"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Julia has a rational number type to represent exact ratios of integers. Rationals are constructed using the // operator:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 2//3\n2//3","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"If the numerator and denominator of a rational have common factors, they are reduced to lowest terms such that the denominator is non-negative:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 6//9\n2//3\n\njulia> -4//8\n-1//2\n\njulia> 5//-15\n-1//3\n\njulia> -4//-12\n1//3","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"This normalized form for a ratio of integers is unique, so equality of rational values can be tested by checking for equality of the numerator and denominator. The standardized numerator and denominator of a rational value can be extracted using the numerator and denominator functions:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> numerator(2//3)\n2\n\njulia> denominator(2//3)\n3","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Direct comparison of the numerator and denominator is generally not necessary, since the standard arithmetic and comparison operations are defined for rational values:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 2//3 == 6//9\ntrue\n\njulia> 2//3 == 9//27\nfalse\n\njulia> 3//7 < 1//2\ntrue\n\njulia> 3//4 > 2//3\ntrue\n\njulia> 2//4 + 1//6\n2//3\n\njulia> 5//12 - 1//4\n1//6\n\njulia> 5//8 * 3//12\n5//32\n\njulia> 6//5 / 10//7\n21//25","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Rationals can easily be converted to floating-point numbers:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> float(3//4)\n0.75","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Conversion from rational to floating-point respects the following identity for any integral values of a and b, with the exception of the case a == 0 and b == 0:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> a = 1; b = 2;\n\njulia> isequal(float(a//b), a/b)\ntrue","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Constructing infinite rational values is acceptable:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 5//0\n1//0\n\njulia> -3//0\n-1//0\n\njulia> typeof(ans)\nRational{Int64}","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"Trying to construct a NaN rational value, however, is invalid:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 0//0\nERROR: ArgumentError: invalid rational: zero(Int64)//zero(Int64)\nStacktrace:\n[...]","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"As usual, the promotion system makes interactions with other numeric types effortless:","category":"page"},{"location":"manual/complex-and-rational-numbers.html#","page":"Complex and Rational Numbers","title":"Complex and Rational Numbers","text":"julia> 3//5 + 1\n8//5\n\njulia> 3//5 - 0.5\n0.09999999999999998\n\njulia> 2//7 * (1 + 2im)\n2//7 + 4//7*im\n\njulia> 2//7 * (1.5 + 2im)\n0.42857142857142855 + 0.5714285714285714im\n\njulia> 3//2 / (1 + 2im)\n3//10 - 3//5*im\n\njulia> 1//2 + 2im\n1//2 + 2//1*im\n\njulia> 1 + 2//3im\n1//1 - 2//3*im\n\njulia> 0.5 == 1//2\ntrue\n\njulia> 0.33 == 1//3\nfalse\n\njulia> 0.33 < 1//3\ntrue\n\njulia> 1//3 - 0.33\n0.0033333333333332993","category":"page"},{"location":"manual/strings.html#man-strings-1","page":"Strings","title":"Strings","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Strings are finite sequences of characters. Of course, the real trouble comes when one asks what a character is. The characters that English speakers are familiar with are the letters A, B, C, etc., together with numerals and common punctuation symbols. These characters are standardized together with a mapping to integer values between 0 and 127 by the ASCII standard. There are, of course, many other characters used in non-English languages, including variants of the ASCII characters with accents and other modifications, related scripts such as Cyrillic and Greek, and scripts completely unrelated to ASCII and English, including Arabic, Chinese, Hebrew, Hindi, Japanese, and Korean. The Unicode standard tackles the complexities of what exactly a character is, and is generally accepted as the definitive standard addressing this problem. Depending on your needs, you can either ignore these complexities entirely and just pretend that only ASCII characters exist, or you can write code that can handle any of the characters or encodings that one may encounter when handling non-ASCII text. Julia makes dealing with plain ASCII text simple and efficient, and handling Unicode is as simple and efficient as possible. In particular, you can write C-style string code to process ASCII strings, and they will work as expected, both in terms of performance and semantics. If such code encounters non-ASCII text, it will gracefully fail with a clear error message, rather than silently introducing corrupt results. When this happens, modifying the code to handle non-ASCII data is straightforward.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"There are a few noteworthy high-level features about Julia's strings:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The built-in concrete type used for strings (and string literals) in Julia is String. This supports the full range of Unicode characters via the UTF-8 encoding. (A transcode function is provided to convert to/from other Unicode encodings.)\nAll string types are subtypes of the abstract type AbstractString, and external packages define additional AbstractString subtypes (e.g. for other encodings).  If you define a function expecting a string argument, you should declare the type as AbstractString in order to accept any string type.\nLike C and Java, but unlike most dynamic languages, Julia has a first-class type for representing a single character, called AbstractChar. The built-in Char subtype of AbstractChar is a 32-bit primitive type that can represent any Unicode character (and which is based on the UTF-8 encoding).\nAs in Java, strings are immutable: the value of an AbstractString object cannot be changed. To construct a different string value, you construct a new string from parts of other strings.\nConceptually, a string is a partial function from indices to characters: for some index values, no character value is returned, and instead an exception is thrown. This allows for efficient indexing into strings by the byte index of an encoded representation rather than by a character index, which cannot be implemented both efficiently and simply for variable-width encodings of Unicode strings.","category":"page"},{"location":"manual/strings.html#man-characters-1","page":"Strings","title":"Characters","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"A Char value represents a single character: it is just a 32-bit primitive type with a special literal representation and appropriate arithmetic behaviors, and which can be converted to a numeric value representing a Unicode code point.  (Julia packages may define other subtypes of AbstractChar, e.g. to optimize operations for other text encodings.) Here is how Char values are input and shown:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> 'x'\n'x': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> typeof(ans)\nChar","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can easily convert a Char to its integer value, i.e. code point:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> Int('x')\n120\n\njulia> typeof(ans)\nInt64","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"On 32-bit architectures, typeof(ans) will be Int32. You can convert an integer value back to a Char just as easily:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> Char(120)\n'x': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Not all integer values are valid Unicode code points, but for performance, the Char conversion does not check that every character value is valid. If you want to check that each converted value is a valid code point, use the isvalid function:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> Char(0x110000)\n'\\U110000': Unicode U+110000 (category In: Invalid, too high)\n\njulia> isvalid(Char, 0x110000)\nfalse","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"As of this writing, the valid Unicode code points are U+00 through U+d7ff and U+e000 through U+10ffff. These have not all been assigned intelligible meanings yet, nor are they necessarily interpretable by applications, but all of these values are considered to be valid Unicode characters.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can input any Unicode character in single quotes using \\u followed by up to four hexadecimal digits or \\U followed by up to eight hexadecimal digits (the longest valid value only requires six):","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> '\\u0'\n'\\0': ASCII/Unicode U+0000 (category Cc: Other, control)\n\njulia> '\\u78'\n'x': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> '\\u2200'\n'∀': Unicode U+2200 (category Sm: Symbol, math)\n\njulia> '\\U10ffff'\n'\\U10ffff': Unicode U+10ffff (category Cn: Other, not assigned)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Julia uses your system's locale and language settings to determine which characters can be printed as-is and which must be output using the generic, escaped \\u or \\U input forms. In addition to these Unicode escape forms, all of C's traditional escaped input forms can also be used:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> Int('\\0')\n0\n\njulia> Int('\\t')\n9\n\njulia> Int('\\n')\n10\n\njulia> Int('\\e')\n27\n\njulia> Int('\\x7f')\n127\n\njulia> Int('\\177')\n127","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can do comparisons and a limited amount of arithmetic with Char values:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> 'A' < 'a'\ntrue\n\njulia> 'A' <= 'a' <= 'Z'\nfalse\n\njulia> 'A' <= 'X' <= 'Z'\ntrue\n\njulia> 'x' - 'a'\n23\n\njulia> 'A' + 1\n'B': ASCII/Unicode U+0042 (category Lu: Letter, uppercase)","category":"page"},{"location":"manual/strings.html#String-Basics-1","page":"Strings","title":"String Basics","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"String literals are delimited by double quotes or triple double quotes:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str = \"Hello, world.\\n\"\n\"Hello, world.\\n\"\n\njulia> \"\"\"Contains \"quote\" characters\"\"\"\n\"Contains \\\"quote\\\" characters\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"If you want to extract a character from a string, you index into it:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str[1]\n'H': ASCII/Unicode U+0048 (category Lu: Letter, uppercase)\n\njulia> str[6]\n',': ASCII/Unicode U+002c (category Po: Punctuation, other)\n\njulia> str[end]\n'\\n': ASCII/Unicode U+000a (category Cc: Other, control)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Many Julia objects, including strings, can be indexed with integers. The index of the first element (the first character of a string) is returned by firstindex(str), and the index of the last element (character) with lastindex(str). The keyword end can be used inside an indexing operation as shorthand for the last index along the given dimension. String indexing, like most indexing in Julia, is 1-based: firstindex always returns 1 for any AbstractString. As we will see below, however, lastindex(str) is not in general the same as length(str) for a string, because some Unicode characters can occupy multiple \"code units\".","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can perform arithmetic and other operations with end, just like a normal value:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str[end-1]\n'.': ASCII/Unicode U+002e (category Po: Punctuation, other)\n\njulia> str[end÷2]\n' ': ASCII/Unicode U+0020 (category Zs: Separator, space)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Using an index less than 1 or greater than end raises an error:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str[0]\nERROR: BoundsError: attempt to access \"Hello, world.\\n\"\n  at index [0]\n[...]\n\njulia> str[end+1]\nERROR: BoundsError: attempt to access \"Hello, world.\\n\"\n  at index [15]\nStacktrace:\n[...]","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can also extract a substring using range indexing:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str[4:9]\n\"lo, wo\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Notice that the expressions str[k] and str[k:k] do not give the same result:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str[6]\n',': ASCII/Unicode U+002c (category Po: Punctuation, other)\n\njulia> str[6:6]\n\",\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The former is a single character value of type Char, while the latter is a string value that happens to contain only a single character. In Julia these are very different things.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Range indexing makes a copy of the selected part of the original string. Alternatively, it is possible to create a view into a string using the type SubString, for example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str = \"long string\"\n\"long string\"\n\njulia> substr = SubString(str, 1, 4)\n\"long\"\n\njulia> typeof(substr)\nSubString{String}","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Several standard functions like chop, chomp or strip return a SubString.","category":"page"},{"location":"manual/strings.html#Unicode-and-UTF-8-1","page":"Strings","title":"Unicode and UTF-8","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Julia fully supports Unicode characters and strings. As discussed above, in character literals, Unicode code points can be represented using Unicode \\u and \\U escape sequences, as well as all the standard C escape sequences. These can likewise be used to write string literals:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> s = \"\\u2200 x \\u2203 y\"\n\"∀ x ∃ y\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Whether these Unicode characters are displayed as escapes or shown as special characters depends on your terminal's locale settings and its support for Unicode. String literals are encoded using the UTF-8 encoding. UTF-8 is a variable-width encoding, meaning that not all characters are encoded in the same number of bytes (\"code units\"). In UTF-8, ASCII characters — i.e. those with code points less than 0x80 (128) – are encoded as they are in ASCII, using a single byte, while code points 0x80 and above are encoded using multiple bytes — up to four per character.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"String indices in Julia refer to code units (= bytes for UTF-8), the fixed-width building blocks that are used to encode arbitrary characters (code points). This means that not every index into a String is necessarily a valid index for a character. If you index into a string at such an invalid byte index, an error is thrown:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> s[1]\n'∀': Unicode U+2200 (category Sm: Symbol, math)\n\njulia> s[2]\nERROR: StringIndexError(\"∀ x ∃ y\", 2)\n[...]\n\njulia> s[3]\nERROR: StringIndexError(\"∀ x ∃ y\", 3)\nStacktrace:\n[...]\n\njulia> s[4]\n' ': ASCII/Unicode U+0020 (category Zs: Separator, space)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"In this case, the character ∀ is a three-byte character, so the indices 2 and 3 are invalid and the next character's index is 4; this next valid index can be computed by nextind(s,1), and the next index after that by nextind(s,4) and so on.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Since end is always the last valid index into a collection, end-1 references an invalid byte index if the second-to-last character is multibyte.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> s[end-1]\n' ': ASCII/Unicode U+0020 (category Zs: Separator, space)\n\njulia> s[end-2]\nERROR: StringIndexError(\"∀ x ∃ y\", 9)\nStacktrace:\n[...]\n\njulia> s[prevind(s, end, 2)]\n'∃': Unicode U+2203 (category Sm: Symbol, math)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The first case works, because the last character y and the space are one-byte characters, whereas end-2 indexes into the middle of the ∃ multibyte representation. The correct way for this case is using prevind(s, lastindex(s), 2) or, if you're using that value to index into s you can write s[prevind(s, end, 2)] and end expands to lastindex(s).","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Extraction of a substring using range indexing also expects valid byte indices or an error is thrown:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> s[1:1]\n\"∀\"\n\njulia> s[1:2]\nERROR: StringIndexError(\"∀ x ∃ y\", 2)\nStacktrace:\n[...]\n\njulia> s[1:4]\n\"∀ \"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Because of variable-length encodings, the number of characters in a string (given by length(s)) is not always the same as the last index. If you iterate through the indices 1 through lastindex(s) and index into s, the sequence of characters returned when errors aren't thrown is the sequence of characters comprising the string s. Thus we have the identity that length(s) <= lastindex(s), since each character in a string must have its own index. The following is an inefficient and verbose way to iterate through the characters of s:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> for i = firstindex(s):lastindex(s)\n           try\n               println(s[i])\n           catch\n               # ignore the index error\n           end\n       end\n∀\n\nx\n\n∃\n\ny","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The blank lines actually have spaces on them. Fortunately, the above awkward idiom is unnecessary for iterating through the characters in a string, since you can just use the string as an iterable object, no exception handling required:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> for c in s\n           println(c)\n       end\n∀\n\nx\n\n∃\n\ny","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"If you need to obtain valid indices for a string, you can use the nextind and prevind functions to increment/decrement to the next/previous valid index, as mentioned above. You can also use the eachindex function to iterate over the valid character indices:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> collect(eachindex(s))\n7-element Array{Int64,1}:\n  1\n  4\n  5\n  6\n  7\n 10\n 11","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"To access the raw code units (bytes for UTF-8) of the encoding, you can use the codeunit(s,i) function, where the index i runs consecutively from 1 to ncodeunits(s).  The codeunits(s) function returns an AbstractVector{UInt8} wrapper that lets you access these raw codeunits (bytes) as an array.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Strings in Julia can contain invalid UTF-8 code unit sequences. This convention allows to treat any byte sequence as a String. In such situations a rule is that when parsing a sequence of code units from left to right characters are formed by the longest sequence of 8-bit code units that matches the start of one of the following bit patterns (each x can be 0 or 1):","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"0xxxxxxx;\n110xxxxx 10xxxxxx;\n1110xxxx 10xxxxxx 10xxxxxx;\n11110xxx 10xxxxxx 10xxxxxx 10xxxxxx;\n10xxxxxx;\n11111xxx.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"In particular this means that overlong and too-high code unit sequences and prefixes thereof are treated as a single invalid character rather than multiple invalid characters. This rule may be best explained with an example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> s = \"\\xc0\\xa0\\xe2\\x88\\xe2|\"\n\"\\xc0\\xa0\\xe2\\x88\\xe2|\"\n\njulia> foreach(display, s)\n'\\xc0\\xa0': [overlong] ASCII/Unicode U+0020 (category Zs: Separator, space)\n'\\xe2\\x88': Malformed UTF-8 (category Ma: Malformed, bad data)\n'\\xe2': Malformed UTF-8 (category Ma: Malformed, bad data)\n'|': ASCII/Unicode U+007c (category Sm: Symbol, math)\n\njulia> isvalid.(collect(s))\n4-element BitArray{1}:\n 0\n 0\n 0\n 1\n\njulia> s2 = \"\\xf7\\xbf\\xbf\\xbf\"\n\"\\U1fffff\"\n\njulia> foreach(display, s2)\n'\\U1fffff': Unicode U+1fffff (category In: Invalid, too high)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"We can see that the first two code units in the string s form an overlong encoding of space character. It is invalid, but is accepted in a string as a single character. The next two code units form a valid start of a three-byte UTF-8 sequence. However, the fifth code unit \\xe2 is not its valid continuation. Therefore code units 3 and 4 are also interpreted as malformed characters in this string. Similarly code unit 5 forms a malformed character because | is not a valid continuation to it. Finally the string s2 contains one too high code point.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Julia uses the UTF-8 encoding by default, and support for new encodings can be added by packages. For example, the LegacyStrings.jl package implements UTF16String and UTF32String types. Additional discussion of other encodings and how to implement support for them is beyond the scope of this document for the time being. For further discussion of UTF-8 encoding issues, see the section below on byte array literals. The transcode function is provided to convert data between the various UTF-xx encodings, primarily for working with external data and libraries.","category":"page"},{"location":"manual/strings.html#man-concatenation-1","page":"Strings","title":"Concatenation","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"One of the most common and useful string operations is concatenation:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> greet = \"Hello\"\n\"Hello\"\n\njulia> whom = \"world\"\n\"world\"\n\njulia> string(greet, \", \", whom, \".\\n\")\n\"Hello, world.\\n\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"It's important to be aware of potentially dangerous situations such as concatenation of invalid UTF-8 strings. The resulting string may contain different characters than the input strings, and its number of characters may be lower than sum of numbers of characters of the concatenated strings, e.g.:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> a, b = \"\\xe2\\x88\", \"\\x80\"\n(\"\\xe2\\x88\", \"\\x80\")\n\njulia> c = a*b\n\"∀\"\n\njulia> collect.([a, b, c])\n3-element Array{Array{Char,1},1}:\n ['\\xe2\\x88']\n ['\\x80']\n ['∀']\n\njulia> length.([a, b, c])\n3-element Array{Int64,1}:\n 1\n 1\n 1","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"This situation can happen only for invalid UTF-8 strings. For valid UTF-8 strings concatenation preserves all characters in strings and additivity of string lengths.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Julia also provides * for string concatenation:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> greet * \", \" * whom * \".\\n\"\n\"Hello, world.\\n\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"While * may seem like a surprising choice to users of languages that provide + for string concatenation, this use of * has precedent in mathematics, particularly in abstract algebra.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"In mathematics, + usually denotes a commutative operation, where the order of the operands does not matter. An example of this is matrix addition, where A + B == B + A for any matrices A and B that have the same shape. In contrast, * typically denotes a noncommutative operation, where the order of the operands does matter. An example of this is matrix multiplication, where in general A * B != B * A. As with matrix multiplication, string concatenation is noncommutative: greet * whom != whom * greet. As such, * is a more natural choice for an infix string concatenation operator, consistent with common mathematical use.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"More precisely, the set of all finite-length strings S together with the string concatenation operator * forms a free monoid (S, *). The identity element of this set is the empty string, \"\". Whenever a free monoid is not commutative, the operation is typically represented as \\cdot, *, or a similar symbol, rather than +, which as stated usually implies commutativity.","category":"page"},{"location":"manual/strings.html#string-interpolation-1","page":"Strings","title":"Interpolation","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Constructing strings using concatenation can become a bit cumbersome, however. To reduce the need for these verbose calls to string or repeated multiplications, Julia allows interpolation into string literals using $, as in Perl:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> \"$greet, $whom.\\n\"\n\"Hello, world.\\n\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"This is more readable and convenient and equivalent to the above string concatenation – the system rewrites this apparent single string literal into the call string(greet, \", \", whom, \".\\n\").","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The shortest complete expression after the $ is taken as the expression whose value is to be interpolated into the string. Thus, you can interpolate any expression into a string using parentheses:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> \"1 + 2 = $(1 + 2)\"\n\"1 + 2 = 3\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Both concatenation and string interpolation call string to convert objects into string form. However, string actually just returns the output of print, so new types should add methods to print or show instead of string.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Most non-AbstractString objects are converted to strings closely corresponding to how they are entered as literal expressions:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> v = [1,2,3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> \"v: $v\"\n\"v: [1, 2, 3]\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"string is the identity for AbstractString and AbstractChar values, so these are interpolated into strings as themselves, unquoted and unescaped:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> c = 'x'\n'x': ASCII/Unicode U+0078 (category Ll: Letter, lowercase)\n\njulia> \"hi, $c\"\n\"hi, x\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"To include a literal $ in a string literal, escape it with a backslash:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> print(\"I have \\$100 in my account.\\n\")\nI have $100 in my account.","category":"page"},{"location":"manual/strings.html#Triple-Quoted-String-Literals-1","page":"Strings","title":"Triple-Quoted String Literals","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"When strings are created using triple-quotes (\"\"\"...\"\"\") they have some special behavior that can be useful for creating longer blocks of text.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"First, triple-quoted strings are also dedented to the level of the least-indented line. This is useful for defining strings within code that is indented. For example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> str = \"\"\"\n           Hello,\n           world.\n         \"\"\"\n\"  Hello,\\n  world.\\n\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"In this case the final (empty) line before the closing \"\"\" sets the indentation level.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The dedentation level is determined as the longest common starting sequence of spaces or tabs in all lines, excluding the line following the opening \"\"\" and lines containing only spaces or tabs (the line containing the closing \"\"\" is always included). Then for all lines, excluding the text following the opening \"\"\", the common starting sequence is removed (including lines containing only spaces and tabs if they start with this sequence), e.g.:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> \"\"\"    This\n         is\n           a test\"\"\"\n\"    This\\nis\\n  a test\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Next, if the opening \"\"\" is followed by a newline, the newline is stripped from the resulting string.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"\"\"\"hello\"\"\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"is equivalent to","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"\"\"\"\nhello\"\"\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"but","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"\"\"\"\n\nhello\"\"\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"will contain a literal newline at the beginning.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Stripping of the newline is performed after the dedentation. For example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> \"\"\"\n         Hello,\n         world.\"\"\"\n\"Hello,\\nworld.\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Trailing whitespace is left unaltered.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Triple-quoted string literals can contain \" symbols without escaping.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Note that line breaks in literal strings, whether single- or triple-quoted, result in a newline (LF) character \\n in the string, even if your editor uses a carriage return \\r (CR) or CRLF combination to end lines. To include a CR in a string, use an explicit escape \\r; for example, you can enter the literal string \"a CRLF line ending\\r\\n\".","category":"page"},{"location":"manual/strings.html#Common-Operations-1","page":"Strings","title":"Common Operations","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can lexicographically compare strings using the standard comparison operators:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> \"abracadabra\" < \"xylophone\"\ntrue\n\njulia> \"abracadabra\" == \"xylophone\"\nfalse\n\njulia> \"Hello, world.\" != \"Goodbye, world.\"\ntrue\n\njulia> \"1 + 2 = 3\" == \"1 + 2 = $(1 + 2)\"\ntrue","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can search for the index of a particular character using the findfirst and findlast functions:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> findfirst(isequal('o'), \"xylophone\")\n4\n\njulia> findlast(isequal('o'), \"xylophone\")\n7\n\njulia> findfirst(isequal('z'), \"xylophone\")","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can start the search for a character at a given offset by using the functions findnext and findprev:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> findnext(isequal('o'), \"xylophone\", 1)\n4\n\njulia> findnext(isequal('o'), \"xylophone\", 5)\n7\n\njulia> findprev(isequal('o'), \"xylophone\", 5)\n4\n\njulia> findnext(isequal('o'), \"xylophone\", 8)","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can use the occursin function to check if a substring is found within a string:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> occursin(\"world\", \"Hello, world.\")\ntrue\n\njulia> occursin(\"o\", \"Xylophon\")\ntrue\n\njulia> occursin(\"a\", \"Xylophon\")\nfalse\n\njulia> occursin('o', \"Xylophon\")\ntrue","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The last example shows that occursin can also look for a character literal.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Two other handy string functions are repeat and join:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> repeat(\".:Z:.\", 10)\n\".:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:..:Z:.\"\n\njulia> join([\"apples\", \"bananas\", \"pineapples\"], \", \", \" and \")\n\"apples, bananas and pineapples\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Some other useful functions include:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"firstindex(str) gives the minimal (byte) index that can be used to index into str (always 1 for strings, not necessarily true for other containers).\nlastindex(str) gives the maximal (byte) index that can be used to index into str.\nlength(str) the number of characters in str.\nlength(str, i, j) the number of valid character indices in str from i to j.\nncodeunits(str) number of code units in a string.\ncodeunit(str, i) gives the code unit value in the string str at index i.\nthisind(str, i) given an arbitrary index into a string find the first index of the character into which the index points.\nnextind(str, i, n=1) find the start of the nth character starting after index i.\nprevind(str, i, n=1) find the start of the nth character starting before index i.","category":"page"},{"location":"manual/strings.html#non-standard-string-literals-1","page":"Strings","title":"Non-Standard String Literals","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"There are situations when you want to construct a string or use string semantics, but the behavior of the standard string construct is not quite what is needed. For these kinds of situations, Julia provides non-standard string literals. A non-standard string literal looks like a regular double-quoted string literal, but is immediately prefixed by an identifier, and doesn't behave quite like a normal string literal.  Regular expressions, byte array literals and version number literals, as described below, are some examples of non-standard string literals. Other examples are given in the Metaprogramming section.","category":"page"},{"location":"manual/strings.html#Regular-Expressions-1","page":"Strings","title":"Regular Expressions","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Julia has Perl-compatible regular expressions (regexes), as provided by the PCRE library (a description of the syntax can be found here). Regular expressions are related to strings in two ways: the obvious connection is that regular expressions are used to find regular patterns in strings; the other connection is that regular expressions are themselves input as strings, which are parsed into a state machine that can be used to efficiently search for patterns in strings. In Julia, regular expressions are input using non-standard string literals prefixed with various identifiers beginning with r. The most basic regular expression literal without any options turned on just uses r\"...\":","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> r\"^\\s*(?:#|$)\"\nr\"^\\s*(?:#|$)\"\n\njulia> typeof(ans)\nRegex","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"To check if a regex matches a string, use occursin:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> occursin(r\"^\\s*(?:#|$)\", \"not a comment\")\nfalse\n\njulia> occursin(r\"^\\s*(?:#|$)\", \"# a comment\")\ntrue","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"As one can see here, occursin simply returns true or false, indicating whether a match for the given regex occurs in the string. Commonly, however, one wants to know not just whether a string matched, but also how it matched. To capture this information about a match, use the match function instead:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> match(r\"^\\s*(?:#|$)\", \"not a comment\")\n\njulia> match(r\"^\\s*(?:#|$)\", \"# a comment\")\nRegexMatch(\"#\")","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"If the regular expression does not match the given string, match returns nothing – a special value that does not print anything at the interactive prompt. Other than not printing, it is a completely normal value and you can test for it programmatically:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"m = match(r\"^\\s*(?:#|$)\", line)\nif m === nothing\n    println(\"not a comment\")\nelse\n    println(\"blank or comment\")\nend","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"If a regular expression does match, the value returned by match is a RegexMatch object. These objects record how the expression matches, including the substring that the pattern matches and any captured substrings, if there are any. This example only captures the portion of the substring that matches, but perhaps we want to capture any non-blank text after the comment character. We could do the following:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> m = match(r\"^\\s*(?:#\\s*(.*?)\\s*$|$)\", \"# a comment \")\nRegexMatch(\"# a comment \", 1=\"a comment\")","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"When calling match, you have the option to specify an index at which to start the search. For example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",1)\nRegexMatch(\"1\")\n\njulia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",6)\nRegexMatch(\"2\")\n\njulia> m = match(r\"[0-9]\",\"aaaa1aaaa2aaaa3\",11)\nRegexMatch(\"3\")","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can extract the following info from a RegexMatch object:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"the entire substring matched: m.match\nthe captured substrings as an array of strings: m.captures\nthe offset at which the whole match begins: m.offset\nthe offsets of the captured substrings as a vector: m.offsets","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"For when a capture doesn't match, instead of a substring, m.captures contains nothing in that position, and m.offsets has a zero offset (recall that indices in Julia are 1-based, so a zero offset into a string is invalid). Here is a pair of somewhat contrived examples:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> m = match(r\"(a|b)(c)?(d)\", \"acd\")\nRegexMatch(\"acd\", 1=\"a\", 2=\"c\", 3=\"d\")\n\njulia> m.match\n\"acd\"\n\njulia> m.captures\n3-element Array{Union{Nothing, SubString{String}},1}:\n \"a\"\n \"c\"\n \"d\"\n\njulia> m.offset\n1\n\njulia> m.offsets\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> m = match(r\"(a|b)(c)?(d)\", \"ad\")\nRegexMatch(\"ad\", 1=\"a\", 2=nothing, 3=\"d\")\n\njulia> m.match\n\"ad\"\n\njulia> m.captures\n3-element Array{Union{Nothing, SubString{String}},1}:\n \"a\"\n nothing\n \"d\"\n\njulia> m.offset\n1\n\njulia> m.offsets\n3-element Array{Int64,1}:\n 1\n 0\n 2","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"It is convenient to have captures returned as an array so that one can use destructuring syntax to bind them to local variables:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> first, second, third = m.captures; first\n\"a\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Captures can also be accessed by indexing the RegexMatch object with the number or name of the capture group:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> m=match(r\"(?<hour>\\d+):(?<minute>\\d+)\",\"12:45\")\nRegexMatch(\"12:45\", hour=\"12\", minute=\"45\")\n\njulia> m[:minute]\n\"45\"\n\njulia> m[2]\n\"45\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Captures can be referenced in a substitution string when using replace by using \\n to refer to the nth capture group and prefixing the substitution string with s. Capture group 0 refers to the entire match object. Named capture groups can be referenced in the substitution with \\g<groupname>. For example:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> replace(\"first second\", r\"(\\w+) (?<agroup>\\w+)\" => s\"\\g<agroup> \\1\")\n\"second first\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Numbered capture groups can also be referenced as \\g<n> for disambiguation, as in:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> replace(\"a\", r\".\" => s\"\\g<0>1\")\n\"a1\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"You can modify the behavior of regular expressions by some combination of the flags i, m, s, and x after the closing double quote mark. These flags have the same meaning as they do in Perl, as explained in this excerpt from the perlre manpage:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"i   Do case-insensitive pattern matching.\n\n    If locale matching rules are in effect, the case map is taken\n    from the current locale for code points less than 255, and\n    from Unicode rules for larger code points. However, matches\n    that would cross the Unicode rules/non-Unicode rules boundary\n    (ords 255/256) will not succeed.\n\nm   Treat string as multiple lines.  That is, change \"^\" and \"$\"\n    from matching the start or end of the string to matching the\n    start or end of any line anywhere within the string.\n\ns   Treat string as single line.  That is, change \".\" to match any\n    character whatsoever, even a newline, which normally it would\n    not match.\n\n    Used together, as r\"\"ms, they let the \".\" match any character\n    whatsoever, while still allowing \"^\" and \"$\" to match,\n    respectively, just after and just before newlines within the\n    string.\n\nx   Tells the regular expression parser to ignore most whitespace\n    that is neither backslashed nor within a character class. You\n    can use this to break up your regular expression into\n    (slightly) more readable parts. The '#' character is also\n    treated as a metacharacter introducing a comment, just as in\n    ordinary code.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"For example, the following regex has all three flags turned on:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> r\"a+.*b+.*?d$\"ism\nr\"a+.*b+.*?d$\"ims\n\njulia> match(r\"a+.*b+.*?d$\"ism, \"Goodbye,\\nOh, angry,\\nBad world\\n\")\nRegexMatch(\"angry,\\nBad world\")","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The r\"...\" literal is constructed without interpolation and unescaping (except for quotation mark \" which still has to be escaped). Here is an example showing the difference from standard string literals:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> x = 10\n10\n\njulia> r\"$x\"\nr\"$x\"\n\njulia> \"$x\"\n\"10\"\n\njulia> r\"\\x\"\nr\"\\x\"\n\njulia> \"\\x\"\nERROR: syntax: invalid escape sequence","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Triple-quoted regex strings, of the form r\"\"\"...\"\"\", are also supported (and may be convenient for regular expressions containing quotation marks or newlines).","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The Regex() constructor may be used to create a valid regex string programmatically.  This permits using the contents of string variables and other string operations when constructing the regex string. Any of the regex codes above can be used within the single string argument to Regex(). Here are some examples:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> using Dates\n\njulia> d = Date(1962,7,10)\n1962-07-10\n\njulia> regex_d = Regex(\"Day \" * string(day(d)))\nr\"Day 10\"\n\njulia> match(regex_d, \"It happened on Day 10\")\nRegexMatch(\"Day 10\")\n\njulia> name = \"Jon\"\n\"Jon\"\n\njulia> regex_name = Regex(\"[\\\"( ]$name[\\\") ]\")  # interpolate value of name\nr\"[\\\"( ]Jon[\\\") ]\"\n\njulia> match(regex_name,\" Jon \")\nRegexMatch(\" Jon \")\n\njulia> match(regex_name,\"[Jon]\") === nothing\ntrue","category":"page"},{"location":"manual/strings.html#man-byte-array-literals-1","page":"Strings","title":"Byte Array Literals","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Another useful non-standard string literal is the byte-array string literal: b\"...\". This form lets you use string notation to express read only literal byte arrays – i.e. arrays of UInt8 values. The type of those objects is CodeUnits{UInt8, String}. The rules for byte array literals are the following:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"ASCII characters and ASCII escapes produce a single byte.\n\\x and octal escape sequences produce the byte corresponding to the escape value.\nUnicode escape sequences produce a sequence of bytes encoding that code point in UTF-8.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"There is some overlap between these rules since the behavior of \\x and octal escapes less than 0x80 (128) are covered by both of the first two rules, but here these rules agree. Together, these rules allow one to easily use ASCII characters, arbitrary byte values, and UTF-8 sequences to produce arrays of bytes. Here is an example using all three:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> b\"DATA\\xff\\u2200\"\n8-element Base.CodeUnits{UInt8,String}:\n 0x44\n 0x41\n 0x54\n 0x41\n 0xff\n 0xe2\n 0x88\n 0x80","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The ASCII string \"DATA\" corresponds to the bytes 68, 65, 84, 65. \\xff produces the single byte 255. The Unicode escape \\u2200 is encoded in UTF-8 as the three bytes 226, 136, 128. Note that the resulting byte array does not correspond to a valid UTF-8 string:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> isvalid(\"DATA\\xff\\u2200\")\nfalse","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"As it was mentioned CodeUnits{UInt8,String} type behaves like read only array of UInt8 and if you need a standard vector you can convert it using Vector{UInt8}:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> x = b\"123\"\n3-element Base.CodeUnits{UInt8,String}:\n 0x31\n 0x32\n 0x33\n\njulia> x[1]\n0x31\n\njulia> x[1] = 0x32\nERROR: setindex! not defined for Base.CodeUnits{UInt8,String}\n[...]\n\njulia> Vector{UInt8}(x)\n3-element Array{UInt8,1}:\n 0x31\n 0x32\n 0x33","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Also observe the significant distinction between \\xff and \\uff: the former escape sequence encodes the byte 255, whereas the latter escape sequence represents the code point 255, which is encoded as two bytes in UTF-8:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> b\"\\xff\"\n1-element Base.CodeUnits{UInt8,String}:\n 0xff\n\njulia> b\"\\uff\"\n2-element Base.CodeUnits{UInt8,String}:\n 0xc3\n 0xbf","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Character literals use the same behavior.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"For code points less than \\u80, it happens that the UTF-8 encoding of each code point is just the single byte produced by the corresponding \\x escape, so the distinction can safely be ignored. For the escapes \\x80 through \\xff as compared to \\u80 through \\uff, however, there is a major difference: the former escapes all encode single bytes, which – unless followed by very specific continuation bytes – do not form valid UTF-8 data, whereas the latter escapes all represent Unicode code points with two-byte encodings.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"If this is all extremely confusing, try reading \"The Absolute Minimum Every Software Developer Absolutely, Positively Must Know About Unicode and Character Sets\". It's an excellent introduction to Unicode and UTF-8, and may help alleviate some confusion regarding the matter.","category":"page"},{"location":"manual/strings.html#man-version-number-literals-1","page":"Strings","title":"Version Number Literals","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Version numbers can easily be expressed with non-standard string literals of the form v\"...\". Version number literals create VersionNumber objects which follow the specifications of semantic versioning, and therefore are composed of major, minor and patch numeric values, followed by pre-release and build alpha-numeric annotations. For example, v\"0.2.1-rc1+win64\" is broken into major version 0, minor version 2, patch version 1, pre-release rc1 and build win64. When entering a version literal, everything except the major version number is optional, therefore e.g.  v\"0.2\" is equivalent to v\"0.2.0\" (with empty pre-release/build annotations), v\"2\" is equivalent to v\"2.0.0\", and so on.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"VersionNumber objects are mostly useful to easily and correctly compare two (or more) versions. For example, the constant VERSION holds Julia version number as a VersionNumber object, and therefore one can define some version-specific behavior using simple statements as:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"if v\"0.2\" <= VERSION < v\"0.3-\"\n    # do something specific to 0.2 release series\nend","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Note that in the above example the non-standard version number v\"0.3-\" is used, with a trailing -: this notation is a Julia extension of the standard, and it's used to indicate a version which is lower than any 0.3 release, including all of its pre-releases. So in the above example the code would only run with stable 0.2 versions, and exclude such versions as v\"0.3.0-rc1\". In order to also allow for unstable (i.e. pre-release) 0.2 versions, the lower bound check should be modified like this: v\"0.2-\" <= VERSION.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Another non-standard version specification extension allows one to use a trailing + to express an upper limit on build versions, e.g.  VERSION > v\"0.2-rc1+\" can be used to mean any version above 0.2-rc1 and any of its builds: it will return false for version v\"0.2-rc1+win64\" and true for v\"0.2-rc2\".","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"It is good practice to use such special versions in comparisons (particularly, the trailing - should always be used on upper bounds unless there's a good reason not to), but they must not be used as the actual version number of anything, as they are invalid in the semantic versioning scheme.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Besides being used for the VERSION constant, VersionNumber objects are widely used in the Pkg module, to specify packages versions and their dependencies.","category":"page"},{"location":"manual/strings.html#man-raw-string-literals-1","page":"Strings","title":"Raw String Literals","text":"","category":"section"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Raw strings without interpolation or unescaping can be expressed with non-standard string literals of the form raw\"...\". Raw string literals create ordinary String objects which contain the enclosed contents exactly as entered with no interpolation or unescaping. This is useful for strings which contain code or markup in other languages which use $ or \\ as special characters.","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"The exception is that quotation marks still must be escaped, e.g. raw\"\\\"\" is equivalent to \"\\\"\". To make it possible to express all strings, backslashes then also must be escaped, but only when appearing right before a quote character:","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"julia> println(raw\"\\\\ \\\\\\\"\")\n\\\\ \\\"","category":"page"},{"location":"manual/strings.html#","page":"Strings","title":"Strings","text":"Notice that the first two backslashes appear verbatim in the output, since they do not precede a quote character. However, the next backslash character escapes the backslash that follows it, and the last backslash escapes a quote, since these backslashes appear before a quote.","category":"page"},{"location":"manual/functions.html#man-functions-1","page":"Functions","title":"Functions","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In Julia, a function is an object that maps a tuple of argument values to a return value. Julia functions are not pure mathematical functions, in the sense that functions can alter and be affected by the global state of the program. The basic syntax for defining functions in Julia is:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> function f(x,y)\n           x + y\n       end\nf (generic function with 1 method)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"There is a second, more terse syntax for defining a function in Julia. The traditional function declaration syntax demonstrated above is equivalent to the following compact \"assignment form\":","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> f(x,y) = x + y\nf (generic function with 1 method)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In the assignment form, the body of the function must be a single expression, although it can be a compound expression (see Compound Expressions). Short, simple function definitions are common in Julia. The short function syntax is accordingly quite idiomatic, considerably reducing both typing and visual noise.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"A function is called using the traditional parenthesis syntax:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> f(2,3)\n5","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Without parentheses, the expression f refers to the function object, and can be passed around like any value:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> g = f;\n\njulia> g(2,3)\n5","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"As with variables, Unicode can also be used for function names:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> ∑(x,y) = x + y\n∑ (generic function with 1 method)\n\njulia> ∑(2, 3)\n5","category":"page"},{"location":"manual/functions.html#Argument-Passing-Behavior-1","page":"Functions","title":"Argument Passing Behavior","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Julia function arguments follow a convention sometimes called \"pass-by-sharing\", which means that values are not copied when they are passed to functions. Function arguments themselves act as new variable bindings (new locations that can refer to values), but the values they refer to are identical to the passed values. Modifications to mutable values (such as Arrays) made within a function will be visible to the caller. This is the same behavior found in Scheme, most Lisps, Python, Ruby and Perl, among other dynamic languages.","category":"page"},{"location":"manual/functions.html#The-return-Keyword-1","page":"Functions","title":"The return Keyword","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The value returned by a function is the value of the last expression evaluated, which, by default, is the last expression in the body of the function definition. In the example function, f, from the previous section this is the value of the expression x + y. As in C and most other imperative or functional languages, the return keyword causes a function to return immediately, providing an expression whose value is returned:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function g(x,y)\n    return x * y\n    x + y\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Since function definitions can be entered into interactive sessions, it is easy to compare these definitions:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> f(x,y) = x + y\nf (generic function with 1 method)\n\njulia> function g(x,y)\n           return x * y\n           x + y\n       end\ng (generic function with 1 method)\n\njulia> f(2,3)\n5\n\njulia> g(2,3)\n6","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Of course, in a purely linear function body like g, the usage of return is pointless since the expression x + y is never evaluated and we could simply make x * y the last expression in the function and omit the return. In conjunction with other control flow, however, return is of real use. Here, for example, is a function that computes the hypotenuse length of a right triangle with sides of length x and y, avoiding overflow:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> function hypot(x,y)\n           x = abs(x)\n           y = abs(y)\n           if x > y\n               r = y/x\n               return x*sqrt(1+r*r)\n           end\n           if y == 0\n               return zero(x)\n           end\n           r = x/y\n           return y*sqrt(1+r*r)\n       end\nhypot (generic function with 1 method)\n\njulia> hypot(3, 4)\n5.0","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"There are three possible points of return from this function, returning the values of three different expressions, depending on the values of x and y. The return on the last line could be omitted since it is the last expression.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"A return type can also be specified in the function declaration using the :: operator. This converts the return value to the specified type.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> function g(x, y)::Int8\n           return x * y\n       end;\n\njulia> typeof(g(1, 2))\nInt8","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This function will always return an Int8 regardless of the types of x and y. See Type Declarations for more on return types.","category":"page"},{"location":"manual/functions.html#Operators-Are-Functions-1","page":"Functions","title":"Operators Are Functions","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In Julia, most operators are just functions with support for special syntax. (The exceptions are operators with special evaluation semantics like && and ||. These operators cannot be functions since Short-Circuit Evaluation requires that their operands are not evaluated before evaluation of the operator.) Accordingly, you can also apply them using parenthesized argument lists, just as you would any other function:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> 1 + 2 + 3\n6\n\njulia> +(1,2,3)\n6","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The infix form is exactly equivalent to the function application form – in fact the former is parsed to produce the function call internally. This also means that you can assign and pass around operators such as + and * just like you would with other function values:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> f = +;\n\njulia> f(1,2,3)\n6","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Under the name f, the function does not support infix notation, however.","category":"page"},{"location":"manual/functions.html#Operators-With-Special-Names-1","page":"Functions","title":"Operators With Special Names","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"A few special expressions correspond to calls to functions with non-obvious names. These are:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Expression Calls\n[A B C ...] hcat\n[A; B; C; ...] vcat\n[A B; C D; ...] hvcat\nA' adjoint\nA[i] getindex\nA[i] = x setindex!\nA.n getproperty\nA.n = x setproperty!","category":"page"},{"location":"manual/functions.html#man-anonymous-functions-1","page":"Functions","title":"Anonymous Functions","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Functions in Julia are first-class objects: they can be assigned to variables, and called using the standard function call syntax from the variable they have been assigned to. They can be used as arguments, and they can be returned as values. They can also be created anonymously, without being given a name, using either of these syntaxes:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x -> x^2 + 2x - 1\n#1 (generic function with 1 method)\n\njulia> function (x)\n           x^2 + 2x - 1\n       end\n#3 (generic function with 1 method)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This creates a function taking one argument x and returning the value of the polynomial x^2 + 2x - 1 at that value. Notice that the result is a generic function, but with a compiler-generated name based on consecutive numbering.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The primary use for anonymous functions is passing them to functions which take other functions as arguments. A classic example is map, which applies a function to each value of an array and returns a new array containing the resulting values:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> map(round, [1.2,3.5,1.7])\n3-element Array{Float64,1}:\n 1.0\n 4.0\n 2.0","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This is fine if a named function effecting the transform already exists to pass as the first argument to map. Often, however, a ready-to-use, named function does not exist. In these situations, the anonymous function construct allows easy creation of a single-use function object without needing a name:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> map(x -> x^2 + 2x - 1, [1,3,-1])\n3-element Array{Int64,1}:\n  2\n 14\n -2","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"An anonymous function accepting multiple arguments can be written using the syntax (x,y,z)->2x+y-z. A zero-argument anonymous function is written as ()->3. The idea of a function with no arguments may seem strange, but is useful for \"delaying\" a computation. In this usage, a block of code is wrapped in a zero-argument function, which is later invoked by calling it as f.","category":"page"},{"location":"manual/functions.html#Tuples-1","page":"Functions","title":"Tuples","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Julia has a built-in data structure called a tuple that is closely related to function arguments and return values. A tuple is a fixed-length container that can hold any values, but cannot be modified (it is immutable). Tuples are constructed with commas and parentheses, and can be accessed via indexing:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> (1, 1+1)\n(1, 2)\n\njulia> (1,)\n(1,)\n\njulia> x = (0.0, \"hello\", 6*7)\n(0.0, \"hello\", 42)\n\njulia> x[2]\n\"hello\"","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Notice that a length-1 tuple must be written with a comma, (1,), since (1) would just be a parenthesized value. () represents the empty (length-0) tuple.","category":"page"},{"location":"manual/functions.html#Named-Tuples-1","page":"Functions","title":"Named Tuples","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The components of tuples can optionally be named, in which case a named tuple is constructed:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x = (a=1, b=1+1)\n(a = 1, b = 2)\n\njulia> x.a\n1","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Named tuples are very similar to tuples, except that fields can additionally be accessed by name using dot syntax (x.a).","category":"page"},{"location":"manual/functions.html#Multiple-Return-Values-1","page":"Functions","title":"Multiple Return Values","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In Julia, one returns a tuple of values to simulate returning multiple values. However, tuples can be created and destructured without needing parentheses, thereby providing an illusion that multiple values are being returned, rather than a single tuple value. For example, the following function returns a pair of values:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> function foo(a,b)\n           a+b, a*b\n       end\nfoo (generic function with 1 method)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"If you call it in an interactive session without assigning the return value anywhere, you will see the tuple returned:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> foo(2,3)\n(5, 6)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"A typical usage of such a pair of return values, however, extracts each value into a variable. Julia supports simple tuple \"destructuring\" that facilitates this:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x, y = foo(2,3)\n(5, 6)\n\njulia> x\n5\n\njulia> y\n6","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"You can also return multiple values via an explicit usage of the return keyword:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function foo(a,b)\n    return a+b, a*b\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This has the exact same effect as the previous definition of foo.","category":"page"},{"location":"manual/functions.html#Argument-destructuring-1","page":"Functions","title":"Argument destructuring","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The destructuring feature can also be used within a function argument. If a function argument name is written as a tuple (e.g. (x, y)) instead of just a symbol, then an assignment (x, y) = argument will be inserted for you:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> minmax(x, y) = (y < x) ? (y, x) : (x, y)\n\njulia> range((min, max)) = max - min\n\njulia> range(minmax(10, 2))\n8","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Notice the extra set of parentheses in the definition of range. Without those, range would be a two-argument function, and this example would not work.","category":"page"},{"location":"manual/functions.html#Varargs-Functions-1","page":"Functions","title":"Varargs Functions","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"It is often convenient to be able to write functions taking an arbitrary number of arguments. Such functions are traditionally known as \"varargs\" functions, which is short for \"variable number of arguments\". You can define a varargs function by following the last argument with an ellipsis:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> bar(a,b,x...) = (a,b,x)\nbar (generic function with 1 method)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The variables a and b are bound to the first two argument values as usual, and the variable x is bound to an iterable collection of the zero or more values passed to bar after its first two arguments:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> bar(1,2)\n(1, 2, ())\n\njulia> bar(1,2,3)\n(1, 2, (3,))\n\njulia> bar(1, 2, 3, 4)\n(1, 2, (3, 4))\n\njulia> bar(1,2,3,4,5,6)\n(1, 2, (3, 4, 5, 6))","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In all these cases, x is bound to a tuple of the trailing values passed to bar.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"It is possible to constrain the number of values passed as a variable argument; this will be discussed later in Parametrically-constrained Varargs methods.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"On the flip side, it is often handy to \"splat\" the values contained in an iterable collection into a function call as individual arguments. To do this, one also uses ... but in the function call instead:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x = (3, 4)\n(3, 4)\n\njulia> bar(1,2,x...)\n(1, 2, (3, 4))","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In this case a tuple of values is spliced into a varargs call precisely where the variable number of arguments go. This need not be the case, however:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x = (2, 3, 4)\n(2, 3, 4)\n\njulia> bar(1,x...)\n(1, 2, (3, 4))\n\njulia> x = (1, 2, 3, 4)\n(1, 2, 3, 4)\n\njulia> bar(x...)\n(1, 2, (3, 4))","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Furthermore, the iterable object splatted into a function call need not be a tuple:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> x = [3,4]\n2-element Array{Int64,1}:\n 3\n 4\n\njulia> bar(1,2,x...)\n(1, 2, (3, 4))\n\njulia> x = [1,2,3,4]\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> bar(x...)\n(1, 2, (3, 4))","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Also, the function that arguments are splatted into need not be a varargs function (although it often is):","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> baz(a,b) = a + b;\n\njulia> args = [1,2]\n2-element Array{Int64,1}:\n 1\n 2\n\njulia> baz(args...)\n3\n\njulia> args = [1,2,3]\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> baz(args...)\nERROR: MethodError: no method matching baz(::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  baz(::Any, ::Any) at none:1","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"As you can see, if the wrong number of elements are in the splatted container, then the function call will fail, just as it would if too many arguments were given explicitly.","category":"page"},{"location":"manual/functions.html#Optional-Arguments-1","page":"Functions","title":"Optional Arguments","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In many cases, function arguments have sensible default values and therefore might not need to be passed explicitly in every call. For example, the function Date(y, [m, d]) from Dates module constructs a Date type for a given year y, month m and day d. However, m and d arguments are optional and their default value is 1. This behavior can be expressed concisely as:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function Date(y::Int64, m::Int64=1, d::Int64=1)\n    err = validargs(Date, y, m, d)\n    err === nothing || throw(err)\n    return Date(UTD(totaldays(y, m, d)))\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Observe, that this definition calls another method of Date function that takes one argument of UTInstant{Day} type.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"With this definition, the function can be called with either one, two or three arguments, and 1 is automatically passed when any of the arguments is not specified:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> using Dates\n\njulia> Date(2000, 12, 12)\n2000-12-12\n\njulia> Date(2000, 12)\n2000-12-01\n\njulia> Date(2000)\n2000-01-01","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Optional arguments are actually just a convenient syntax for writing multiple method definitions with different numbers of arguments (see Note on Optional and keyword Arguments). This can be checked for our Date function example by calling methods function.","category":"page"},{"location":"manual/functions.html#Keyword-Arguments-1","page":"Functions","title":"Keyword Arguments","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Some functions need a large number of arguments, or have a large number of behaviors. Remembering how to call such functions can be difficult. Keyword arguments can make these complex interfaces easier to use and extend by allowing arguments to be identified by name instead of only by position.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"For example, consider a function plot that plots a line. This function might have many options, for controlling line style, width, color, and so on. If it accepts keyword arguments, a possible call might look like plot(x, y, width=2), where we have chosen to specify only line width. Notice that this serves two purposes. The call is easier to read, since we can label an argument with its meaning. It also becomes possible to pass any subset of a large number of arguments, in any order.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Functions with keyword arguments are defined using a semicolon in the signature:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function plot(x, y; style=\"solid\", width=1, color=\"black\")\n    ###\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"When the function is called, the semicolon is optional: one can either call plot(x, y, width=2) or plot(x, y; width=2), but the former style is more common. An explicit semicolon is required only for passing varargs or computed keywords as described below.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Keyword argument default values are evaluated only when necessary (when a corresponding keyword argument is not passed), and in left-to-right order. Therefore default expressions may refer to prior keyword arguments.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The types of keyword arguments can be made explicit as follows:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function f(;x::Int=1)\n    ###\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Extra keyword arguments can be collected using ..., as in varargs functions:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function f(x; y=0, kwargs...)\n    ###\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Inside f, kwargs will be a key-value iterator over a named tuple. Named tuples (as well as dictionaries with keys of Symbol) can be passed as keyword arguments using a semicolon in a call, e.g. f(x, z=1; kwargs...).","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"If a keyword argument is not assigned a default value in the method definition, then it is required: an UndefKeywordError exception will be thrown if the caller does not assign it a value:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function f(x; y)\n    ###\nend\nf(3, y=5) # ok, y is assigned\nf(3)      # throws UndefKeywordError(:y)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"One can also pass key => value expressions after a semicolon. For example, plot(x, y; :width => 2) is equivalent to plot(x, y, width=2). This is useful in situations where the keyword name is computed at runtime.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The nature of keyword arguments makes it possible to specify the same argument more than once. For example, in the call plot(x, y; options..., width=2) it is possible that the options structure also contains a value for width. In such a case the rightmost occurrence takes precedence; in this example, width is certain to have the value 2. However, explicitly specifying the same keyword argument multiple times, for example plot(x, y, width=2, width=3), is not allowed and results in a syntax error.","category":"page"},{"location":"manual/functions.html#Evaluation-Scope-of-Default-Values-1","page":"Functions","title":"Evaluation Scope of Default Values","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"When optional and keyword argument default expressions are evaluated, only previous arguments are in scope. For example, given this definition:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function f(x, a=b, b=1)\n    ###\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"the b in a=b refers to a b in an outer scope, not the subsequent argument b.","category":"page"},{"location":"manual/functions.html#Do-Block-Syntax-for-Function-Arguments-1","page":"Functions","title":"Do-Block Syntax for Function Arguments","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Passing functions as arguments to other functions is a powerful technique, but the syntax for it is not always convenient. Such calls are especially awkward to write when the function argument requires multiple lines. As an example, consider calling map on a function with several cases:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"map(x->begin\n           if x < 0 && iseven(x)\n               return 0\n           elseif x == 0\n               return 1\n           else\n               return x\n           end\n       end,\n    [A, B, C])","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Julia provides a reserved word do for rewriting this code more clearly:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"map([A, B, C]) do x\n    if x < 0 && iseven(x)\n        return 0\n    elseif x == 0\n        return 1\n    else\n        return x\n    end\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The do x syntax creates an anonymous function with argument x and passes it as the first argument to map. Similarly, do a,b would create a two-argument anonymous function, and a plain do would declare that what follows is an anonymous function of the form () -> ....","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"How these arguments are initialized depends on the \"outer\" function; here, map will sequentially set x to A, B, C, calling the anonymous function on each, just as would happen in the syntax map(func, [A, B, C]).","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This syntax makes it easier to use functions to effectively extend the language, since calls look like normal code blocks. There are many possible uses quite different from map, such as managing system state. For example, there is a version of open that runs code ensuring that the opened file is eventually closed:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"open(\"outfile\", \"w\") do io\n    write(io, data)\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This is accomplished by the following definition:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"function open(f::Function, args...)\n    io = open(args...)\n    try\n        f(io)\n    finally\n        close(io)\n    end\nend","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Here, open first opens the file for writing and then passes the resulting output stream to the anonymous function you defined in the do ... end block. After your function exits, open will make sure that the stream is properly closed, regardless of whether your function exited normally or threw an exception. (The try/finally construct will be described in Control Flow.)","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"With the do block syntax, it helps to check the documentation or implementation to know how the arguments of the user function are initialized.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"A do block, like any other inner function, can \"capture\" variables from its enclosing scope. For example, the variable data in the above example of open...do is captured from the outer scope. Captured variables can create performance challenges as discussed in performance tips.","category":"page"},{"location":"manual/functions.html#Function-composition-and-piping-1","page":"Functions","title":"Function composition and piping","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Functions in Julia can be combined by composing or piping (chaining) them together.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Function composition is when you combine functions together and apply the resulting composition to arguments. You use the function composition operator (∘) to compose the functions, so (f ∘ g)(args...) is the same as f(g(args...)).","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"You can type the composition operator at the REPL and suitably-configured editors using \\circ<tab>.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"For example, the sqrt and + functions can be composed like this:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> (sqrt ∘ +)(3, 6)\n3.0","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"This adds the numbers first, then finds the square root of the result.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The next example composes three functions and maps the result over an array of strings:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> map(first ∘ reverse ∘ uppercase, split(\"you can compose functions like this\"))\n6-element Array{Char,1}:\n 'U'\n 'N'\n 'E'\n 'S'\n 'E'\n 'S'","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Function chaining (sometimes called \"piping\" or \"using a pipe\" to send data to a subsequent function) is when you apply a function to the previous function's output:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> 1:10 |> sum |> sqrt\n7.416198487095663","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Here, the total produced by sum is passed to the sqrt function. The equivalent composition would be:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> (sqrt ∘ sum)(1:10)\n7.416198487095663","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"The pipe operator can also be used with broadcasting, as .|>, to provide a useful combination of the chaining/piping and dot vectorization syntax (described next).","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> [\"a\", \"list\", \"of\", \"strings\"] .|> [uppercase, reverse, titlecase, length]\n4-element Array{Any,1}:\n  \"A\"\n  \"tsil\"\n  \"Of\"\n 7","category":"page"},{"location":"manual/functions.html#man-vectorized-1","page":"Functions","title":"Dot Syntax for Vectorizing Functions","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"In technical-computing languages, it is common to have \"vectorized\" versions of functions, which simply apply a given function f(x) to each element of an array A to yield a new array via f(A). This kind of syntax is convenient for data processing, but in other languages vectorization is also often required for performance: if loops are slow, the \"vectorized\" version of a function can call fast library code written in a low-level language. In Julia, vectorized functions are not required for performance, and indeed it is often beneficial to write your own loops (see Performance Tips), but they can still be convenient. Therefore, any Julia function f can be applied elementwise to any array (or other collection) with the syntax f.(A). For example, sin can be applied to all elements in the vector A like so:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> A = [1.0, 2.0, 3.0]\n3-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n\njulia> sin.(A)\n3-element Array{Float64,1}:\n 0.8414709848078965\n 0.9092974268256817\n 0.1411200080598672","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Of course, you can omit the dot if you write a specialized \"vector\" method of f, e.g. via f(A::AbstractArray) = map(f, A), and this is just as efficient as f.(A). But that approach requires you to decide in advance which functions you want to vectorize.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"More generally, f.(args...) is actually equivalent to broadcast(f, args...), which allows you to operate on multiple arrays (even of different shapes), or a mix of arrays and scalars (see Broadcasting). For example, if you have f(x,y) = 3x + 4y, then f.(pi,A) will return a new array consisting of f(pi,a) for each a in A, and f.(vector1,vector2) will return a new vector consisting of f(vector1[i],vector2[i]) for each index i (throwing an exception if the vectors have different length).","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> f(x,y) = 3x + 4y;\n\njulia> A = [1.0, 2.0, 3.0];\n\njulia> B = [4.0, 5.0, 6.0];\n\njulia> f.(pi, A)\n3-element Array{Float64,1}:\n 13.42477796076938\n 17.42477796076938\n 21.42477796076938\n\njulia> f.(A, B)\n3-element Array{Float64,1}:\n 19.0\n 26.0\n 33.0","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Moreover, nested f.(args...) calls are fused into a single broadcast loop. For example, sin.(cos.(X)) is equivalent to broadcast(x -> sin(cos(x)), X), similar to [sin(cos(x)) for x in X]: there is only a single loop over X, and a single array is allocated for the result. [In contrast, sin(cos(X)) in a typical \"vectorized\" language would first allocate one temporary array for tmp=cos(X), and then compute sin(tmp) in a separate loop, allocating a second array.] This loop fusion is not a compiler optimization that may or may not occur, it is a syntactic guarantee whenever nested f.(args...) calls are encountered. Technically, the fusion stops as soon as a \"non-dot\" function call is encountered; for example, in sin.(sort(cos.(X))) the sin and cos loops cannot be merged because of the intervening sort function.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Finally, the maximum efficiency is typically achieved when the output array of a vectorized operation is pre-allocated, so that repeated calls do not allocate new arrays over and over again for the results (see Pre-allocating outputs). A convenient syntax for this is X .= ..., which is equivalent to broadcast!(identity, X, ...) except that, as above, the broadcast! loop is fused with any nested \"dot\" calls. For example, X .= sin.(Y) is equivalent to broadcast!(sin, X, Y), overwriting X with sin.(Y) in-place. If the left-hand side is an array-indexing expression, e.g. X[2:end] .= sin.(Y), then it translates to broadcast! on a view, e.g. broadcast!(sin, view(X, 2:lastindex(X)), Y), so that the left-hand side is updated in-place.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Since adding dots to many operations and function calls in an expression can be tedious and lead to code that is difficult to read, the macro @. is provided to convert every function call, operation, and assignment in an expression into the \"dotted\" version.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> Y = [1.0, 2.0, 3.0, 4.0];\n\njulia> X = similar(Y); # pre-allocate output array\n\njulia> @. X = sin(cos(Y)) # equivalent to X .= sin.(cos.(Y))\n4-element Array{Float64,1}:\n  0.5143952585235492\n -0.4042391538522658\n -0.8360218615377305\n -0.6080830096407656","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"Binary (or unary) operators like .+ are handled with the same mechanism: they are equivalent to broadcast calls and are fused with other nested \"dot\" calls.  X .+= Y etcetera is equivalent to X .= X .+ Y and results in a fused in-place assignment;  see also dot operators.","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"You can also combine dot operations with function chaining using |>, as in this example:","category":"page"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"julia> [1:5;] .|> [x->x^2, inv, x->2*x, -, isodd]\n5-element Array{Real,1}:\n    1\n    0.5\n    6\n   -4\n true","category":"page"},{"location":"manual/functions.html#Further-Reading-1","page":"Functions","title":"Further Reading","text":"","category":"section"},{"location":"manual/functions.html#","page":"Functions","title":"Functions","text":"We should mention here that this is far from a complete picture of defining functions. Julia has a sophisticated type system and allows multiple dispatch on argument types. None of the examples given here provide any type annotations on their arguments, meaning that they are applicable to all types of arguments. The type system is described in Types and defining a function in terms of methods chosen by multiple dispatch on run-time argument types is described in Methods.","category":"page"},{"location":"manual/control-flow.html#Control-Flow-1","page":"Control Flow","title":"Control Flow","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Julia provides a variety of control flow constructs:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Compound Expressions: begin and (;).\nConditional Evaluation: if-elseif-else and ?: (ternary operator).\nShort-Circuit Evaluation: &&, || and chained comparisons.\nRepeated Evaluation: Loops: while and for.\nException Handling: try-catch, error and throw.\nTasks (aka Coroutines): yieldto.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The first five control flow mechanisms are standard to high-level programming languages. Tasks are not so standard: they provide non-local control flow, making it possible to switch between temporarily-suspended computations. This is a powerful construct: both exception handling and cooperative multitasking are implemented in Julia using tasks. Everyday programming requires no direct usage of tasks, but certain problems can be solved much more easily by using tasks.","category":"page"},{"location":"manual/control-flow.html#man-compound-expressions-1","page":"Control Flow","title":"Compound Expressions","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Sometimes it is convenient to have a single expression which evaluates several subexpressions in order, returning the value of the last subexpression as its value. There are two Julia constructs that accomplish this: begin blocks and (;) chains. The value of both compound expression constructs is that of the last subexpression. Here's an example of a begin block:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> z = begin\n           x = 1\n           y = 2\n           x + y\n       end\n3","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Since these are fairly small, simple expressions, they could easily be placed onto a single line, which is where the (;) chain syntax comes in handy:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> z = (x = 1; y = 2; x + y)\n3","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This syntax is particularly useful with the terse single-line function definition form introduced in Functions. Although it is typical, there is no requirement that begin blocks be multiline or that (;) chains be single-line:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> begin x = 1; y = 2; x + y end\n3\n\njulia> (x = 1;\n        y = 2;\n        x + y)\n3","category":"page"},{"location":"manual/control-flow.html#man-conditional-evaluation-1","page":"Control Flow","title":"Conditional Evaluation","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Conditional evaluation allows portions of code to be evaluated or not evaluated depending on the value of a boolean expression. Here is the anatomy of the if-elseif-else conditional syntax:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"if x < y\n    println(\"x is less than y\")\nelseif x > y\n    println(\"x is greater than y\")\nelse\n    println(\"x is equal to y\")\nend","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"If the condition expression x < y is true, then the corresponding block is evaluated; otherwise the condition expression x > y is evaluated, and if it is true, the corresponding block is evaluated; if neither expression is true, the else block is evaluated. Here it is in action:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function test(x, y)\n           if x < y\n               println(\"x is less than y\")\n           elseif x > y\n               println(\"x is greater than y\")\n           else\n               println(\"x is equal to y\")\n           end\n       end\ntest (generic function with 1 method)\n\njulia> test(1, 2)\nx is less than y\n\njulia> test(2, 1)\nx is greater than y\n\njulia> test(1, 1)\nx is equal to y","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The elseif and else blocks are optional, and as many elseif blocks as desired can be used. The condition expressions in the if-elseif-else construct are evaluated until the first one evaluates to true, after which the associated block is evaluated, and no further condition expressions or blocks are evaluated.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"if blocks are \"leaky\", i.e. they do not introduce a local scope. This means that new variables defined inside the if clauses can be used after the if block, even if they weren't defined before. So, we could have defined the test function above as","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function test(x,y)\n           if x < y\n               relation = \"less than\"\n           elseif x == y\n               relation = \"equal to\"\n           else\n               relation = \"greater than\"\n           end\n           println(\"x is \", relation, \" y.\")\n       end\ntest (generic function with 1 method)\n\njulia> test(2, 1)\nx is greater than y.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The variable relation is declared inside the if block, but used outside. However, when depending on this behavior, make sure all possible code paths define a value for the variable. The following change to the above function results in a runtime error","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function test(x,y)\n           if x < y\n               relation = \"less than\"\n           elseif x == y\n               relation = \"equal to\"\n           end\n           println(\"x is \", relation, \" y.\")\n       end\ntest (generic function with 1 method)\n\njulia> test(1,2)\nx is less than y.\n\njulia> test(2,1)\nERROR: UndefVarError: relation not defined\nStacktrace:\n [1] test(::Int64, ::Int64) at ./none:7","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"if blocks also return a value, which may seem unintuitive to users coming from many other languages. This value is simply the return value of the last executed statement in the branch that was chosen, so","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> x = 3\n3\n\njulia> if x > 0\n           \"positive!\"\n       else\n           \"negative...\"\n       end\n\"positive!\"","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Note that very short conditional statements (one-liners) are frequently expressed using Short-Circuit Evaluation in Julia, as outlined in the next section.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Unlike C, MATLAB, Perl, Python, and Ruby – but like Java, and a few other stricter, typed languages – it is an error if the value of a conditional expression is anything but true or false:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> if 1\n           println(\"true\")\n       end\nERROR: TypeError: non-boolean (Int64) used in boolean context","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This error indicates that the conditional was of the wrong type: Int64 rather than the required Bool.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The so-called \"ternary operator\", ?:, is closely related to the if-elseif-else syntax, but is used where a conditional choice between single expression values is required, as opposed to conditional execution of longer blocks of code. It gets its name from being the only operator in most languages taking three operands:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"a ? b : c","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The expression a, before the ?, is a condition expression, and the ternary operation evaluates the expression b, before the :, if the condition a is true or the expression c, after the :, if it is false. Note that the spaces around ? and : are mandatory: an expression like a?b:c is not a valid ternary expression (but a newline is acceptable after both the ? and the :).","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The easiest way to understand this behavior is to see an example. In the previous example, the println call is shared by all three branches: the only real choice is which literal string to print. This could be written more concisely using the ternary operator. For the sake of clarity, let's try a two-way version first:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> x = 1; y = 2;\n\njulia> println(x < y ? \"less than\" : \"not less than\")\nless than\n\njulia> x = 1; y = 0;\n\njulia> println(x < y ? \"less than\" : \"not less than\")\nnot less than","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"If the expression x < y is true, the entire ternary operator expression evaluates to the string \"less than\" and otherwise it evaluates to the string \"not less than\". The original three-way example requires chaining multiple uses of the ternary operator together:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> test(x, y) = println(x < y ? \"x is less than y\"    :\n                            x > y ? \"x is greater than y\" : \"x is equal to y\")\ntest (generic function with 1 method)\n\njulia> test(1, 2)\nx is less than y\n\njulia> test(2, 1)\nx is greater than y\n\njulia> test(1, 1)\nx is equal to y","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"To facilitate chaining, the operator associates from right to left.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"It is significant that like if-elseif-else, the expressions before and after the : are only evaluated if the condition expression evaluates to true or false, respectively:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> v(x) = (println(x); x)\nv (generic function with 1 method)\n\njulia> 1 < 2 ? v(\"yes\") : v(\"no\")\nyes\n\"yes\"\n\njulia> 1 > 2 ? v(\"yes\") : v(\"no\")\nno\n\"no\"","category":"page"},{"location":"manual/control-flow.html#Short-Circuit-Evaluation-1","page":"Control Flow","title":"Short-Circuit Evaluation","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Short-circuit evaluation is quite similar to conditional evaluation. The behavior is found in most imperative programming languages having the && and || boolean operators: in a series of boolean expressions connected by these operators, only the minimum number of expressions are evaluated as are necessary to determine the final boolean value of the entire chain. Explicitly, this means that:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In the expression a && b, the subexpression b is only evaluated if a evaluates to true.\nIn the expression a || b, the subexpression b is only evaluated if a evaluates to false.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The reasoning is that a && b must be false if a is false, regardless of the value of b, and likewise, the value of a || b must be true if a is true, regardless of the value of b. Both && and || associate to the right, but && has higher precedence than || does. It's easy to experiment with this behavior:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> t(x) = (println(x); true)\nt (generic function with 1 method)\n\njulia> f(x) = (println(x); false)\nf (generic function with 1 method)\n\njulia> t(1) && t(2)\n1\n2\ntrue\n\njulia> t(1) && f(2)\n1\n2\nfalse\n\njulia> f(1) && t(2)\n1\nfalse\n\njulia> f(1) && f(2)\n1\nfalse\n\njulia> t(1) || t(2)\n1\ntrue\n\njulia> t(1) || f(2)\n1\ntrue\n\njulia> f(1) || t(2)\n1\n2\ntrue\n\njulia> f(1) || f(2)\n1\n2\nfalse","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"You can easily experiment in the same way with the associativity and precedence of various combinations of && and || operators.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This behavior is frequently used in Julia to form an alternative to very short if statements. Instead of if <cond> <statement> end, one can write <cond> && <statement> (which could be read as: <cond> and then <statement>). Similarly, instead of if ! <cond> <statement> end, one can write <cond> || <statement> (which could be read as: <cond> or else <statement>).","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"For example, a recursive factorial routine could be defined like this:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function fact(n::Int)\n           n >= 0 || error(\"n must be non-negative\")\n           n == 0 && return 1\n           n * fact(n-1)\n       end\nfact (generic function with 1 method)\n\njulia> fact(5)\n120\n\njulia> fact(0)\n1\n\njulia> fact(-1)\nERROR: n must be non-negative\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fact(::Int64) at ./none:2\n [3] top-level scope","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Boolean operations without short-circuit evaluation can be done with the bitwise boolean operators introduced in Mathematical Operations and Elementary Functions: & and |. These are normal functions, which happen to support infix operator syntax, but always evaluate their arguments:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> f(1) & t(2)\n1\n2\nfalse\n\njulia> t(1) | t(2)\n1\n2\ntrue","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Just like condition expressions used in if, elseif or the ternary operator, the operands of && or || must be boolean values (true or false). Using a non-boolean value anywhere except for the last entry in a conditional chain is an error:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> 1 && true\nERROR: TypeError: non-boolean (Int64) used in boolean context","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"On the other hand, any type of expression can be used at the end of a conditional chain. It will be evaluated and returned depending on the preceding conditionals:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> true && (x = (1, 2, 3))\n(1, 2, 3)\n\njulia> false && (x = (1, 2, 3))\nfalse","category":"page"},{"location":"manual/control-flow.html#man-loops-1","page":"Control Flow","title":"Repeated Evaluation: Loops","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"There are two constructs for repeated evaluation of expressions: the while loop and the for loop. Here is an example of a while loop:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> i = 1;\n\njulia> while i <= 5\n           println(i)\n           global i += 1\n       end\n1\n2\n3\n4\n5","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The while loop evaluates the condition expression (i <= 5 in this case), and as long it remains true, keeps also evaluating the body of the while loop. If the condition expression is false when the while loop is first reached, the body is never evaluated.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The for loop makes common repeated evaluation idioms easier to write. Since counting up and down like the above while loop does is so common, it can be expressed more concisely with a for loop:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for i = 1:5\n           println(i)\n       end\n1\n2\n3\n4\n5","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Here the 1:5 is a range object, representing the sequence of numbers 1, 2, 3, 4, 5. The for loop iterates through these values, assigning each one in turn to the variable i. One rather important distinction between the previous while loop form and the for loop form is the scope during which the variable is visible. If the variable i has not been introduced in another scope, in the for loop form, it is visible only inside of the for loop, and not outside/afterwards. You'll either need a new interactive session instance or a different variable name to test this:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for j = 1:5\n           println(j)\n       end\n1\n2\n3\n4\n5\n\njulia> j\nERROR: UndefVarError: j not defined","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"See Scope of Variables for a detailed explanation of variable scope and how it works in Julia.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In general, the for loop construct can iterate over any container. In these cases, the alternative (but fully equivalent) keyword in or ∈ is typically used instead of =, since it makes the code read more clearly:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for i in [1,4,0]\n           println(i)\n       end\n1\n4\n0\n\njulia> for s ∈ [\"foo\",\"bar\",\"baz\"]\n           println(s)\n       end\nfoo\nbar\nbaz","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Various types of iterable containers will be introduced and discussed in later sections of the manual (see, e.g., Multi-dimensional Arrays).","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"It is sometimes convenient to terminate the repetition of a while before the test condition is falsified or stop iterating in a for loop before the end of the iterable object is reached. This can be accomplished with the break keyword:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> i = 1;\n\njulia> while true\n           println(i)\n           if i >= 5\n               break\n           end\n           global i += 1\n       end\n1\n2\n3\n4\n5\n\njulia> for j = 1:1000\n           println(j)\n           if j >= 5\n               break\n           end\n       end\n1\n2\n3\n4\n5","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Without the break keyword, the above while loop would never terminate on its own, and the for loop would iterate up to 1000. These loops are both exited early by using break.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In other circumstances, it is handy to be able to stop an iteration and move on to the next one immediately. The continue keyword accomplishes this:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for i = 1:10\n           if i % 3 != 0\n               continue\n           end\n           println(i)\n       end\n3\n6\n9","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This is a somewhat contrived example since we could produce the same behavior more clearly by negating the condition and placing the println call inside the if block. In realistic usage there is more code to be evaluated after the continue, and often there are multiple points from which one calls continue.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Multiple nested for loops can be combined into a single outer loop, forming the cartesian product of its iterables:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for i = 1:2, j = 3:4\n           println((i, j))\n       end\n(1, 3)\n(1, 4)\n(2, 3)\n(2, 4)","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"With this syntax, iterables may still refer to outer loop variables; e.g. for i = 1:n, j = 1:i is valid. However a break statement inside such a loop exits the entire nest of loops, not just the inner one. Both variables (i and j) are set to their current iteration values each time the inner loop runs. Therefore, assignments to i will not be visible to subsequent iterations:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for i = 1:2, j = 3:4\n           println((i, j))\n           i = 0\n       end\n(1, 3)\n(1, 4)\n(2, 3)\n(2, 4)","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"If this example were rewritten to use a for keyword for each variable, then the output would be different: the second and fourth values would contain 0.","category":"page"},{"location":"manual/control-flow.html#Exception-Handling-1","page":"Control Flow","title":"Exception Handling","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"When an unexpected condition occurs, a function may be unable to return a reasonable value to its caller. In such cases, it may be best for the exceptional condition to either terminate the program while printing a diagnostic error message, or if the programmer has provided code to handle such exceptional circumstances then allow that code to take the appropriate action.","category":"page"},{"location":"manual/control-flow.html#Built-in-Exceptions-1","page":"Control Flow","title":"Built-in Exceptions","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Exceptions are thrown when an unexpected condition has occurred. The built-in Exceptions listed below all interrupt the normal flow of control.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Exception\nArgumentError\nBoundsError\nCompositeException\nDivideError\nDomainError\nEOFError\nErrorException\nInexactError\nInitError\nInterruptException\nInvalidStateException\nKeyError\nLoadError\nOutOfMemoryError\nReadOnlyMemoryError\nRemoteException\nMethodError\nOverflowError\nMeta.ParseError\nSystemError\nTypeError\nUndefRefError\nUndefVarError\nStringIndexError","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"For example, the sqrt function throws a DomainError if applied to a negative real value:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"You may define your own exceptions in the following way:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> struct MyCustomException <: Exception end","category":"page"},{"location":"manual/control-flow.html#The-[throw](@ref)-function-1","page":"Control Flow","title":"The throw function","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Exceptions can be created explicitly with throw. For example, a function defined only for nonnegative numbers could be written to throw a DomainError if the argument is negative:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> f(x) = x>=0 ? exp(-x) : throw(DomainError(x, \"argument must be nonnegative\"))\nf (generic function with 1 method)\n\njulia> f(1)\n0.36787944117144233\n\njulia> f(-1)\nERROR: DomainError with -1:\nargument must be nonnegative\nStacktrace:\n [1] f(::Int64) at ./none:1","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Note that DomainError without parentheses is not an exception, but a type of exception. It needs to be called to obtain an Exception object:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> typeof(DomainError(nothing)) <: Exception\ntrue\n\njulia> typeof(DomainError) <: Exception\nfalse","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Additionally, some exception types take one or more arguments that are used for error reporting:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> throw(UndefVarError(:x))\nERROR: UndefVarError: x not defined","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This mechanism can be implemented easily by custom exception types following the way UndefVarError is written:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> struct MyUndefVarError <: Exception\n           var::Symbol\n       end\n\njulia> Base.showerror(io::IO, e::MyUndefVarError) = print(io, e.var, \" not defined\")","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"note: Note\nWhen writing an error message, it is preferred to make the first word lowercase. For example, size(A) == size(B) || throw(DimensionMismatch(\"size of A not equal to size of B\"))is preferred oversize(A) == size(B) || throw(DimensionMismatch(\"Size of A not equal to size of B\")).However, sometimes it makes sense to keep the uppercase first letter, for instance if an argument to a function is a capital letter: size(A,1) == size(B,2) || throw(DimensionMismatch(\"A has first dimension...\")).","category":"page"},{"location":"manual/control-flow.html#Errors-1","page":"Control Flow","title":"Errors","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The error function is used to produce an ErrorException that interrupts the normal flow of control.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Suppose we want to stop execution immediately if the square root of a negative number is taken. To do this, we can define a fussy version of the sqrt function that raises an error if its argument is negative:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> fussy_sqrt(x) = x >= 0 ? sqrt(x) : error(\"negative x not allowed\")\nfussy_sqrt (generic function with 1 method)\n\njulia> fussy_sqrt(2)\n1.4142135623730951\n\njulia> fussy_sqrt(-1)\nERROR: negative x not allowed\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fussy_sqrt(::Int64) at ./none:1\n [3] top-level scope","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"If fussy_sqrt is called with a negative value from another function, instead of trying to continue execution of the calling function, it returns immediately, displaying the error message in the interactive session:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function verbose_fussy_sqrt(x)\n           println(\"before fussy_sqrt\")\n           r = fussy_sqrt(x)\n           println(\"after fussy_sqrt\")\n           return r\n       end\nverbose_fussy_sqrt (generic function with 1 method)\n\njulia> verbose_fussy_sqrt(2)\nbefore fussy_sqrt\nafter fussy_sqrt\n1.4142135623730951\n\njulia> verbose_fussy_sqrt(-1)\nbefore fussy_sqrt\nERROR: negative x not allowed\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] fussy_sqrt at ./none:1 [inlined]\n [3] verbose_fussy_sqrt(::Int64) at ./none:3\n [4] top-level scope","category":"page"},{"location":"manual/control-flow.html#The-try/catch-statement-1","page":"Control Flow","title":"The try/catch statement","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The try/catch statement allows for Exceptions to be tested for, and for the graceful handling of things that may ordinarily break your application. For example, in the below code the function for square root would normally throw an exception. By placing a try/catch block around it we can mitigate that here. You may choose how you wish to handle this exception, whether logging it, return a placeholder value or as in the case below where we just printed out a statement. One thing to think about when deciding how to handle unexpected situations is that using a try/catch block is much slower than using conditional branching to handle those situations. Below there are more examples of handling exceptions with a try/catch block:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> try\n           sqrt(\"ten\")\n       catch e\n           println(\"You should have entered a numeric value\")\n       end\nYou should have entered a numeric value","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"try/catch statements also allow the Exception to be saved in a variable. The following contrived example calculates the square root of the second element of x if x is indexable, otherwise assumes x is a real number and returns its square root:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> sqrt_second(x) = try\n           sqrt(x[2])\n       catch y\n           if isa(y, DomainError)\n               sqrt(complex(x[2], 0))\n           elseif isa(y, BoundsError)\n               sqrt(x)\n           end\n       end\nsqrt_second (generic function with 1 method)\n\njulia> sqrt_second([1 4])\n2.0\n\njulia> sqrt_second([1 -4])\n0.0 + 2.0im\n\njulia> sqrt_second(9)\n3.0\n\njulia> sqrt_second(-9)\nERROR: DomainError with -9.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Note that the symbol following catch will always be interpreted as a name for the exception, so care is needed when writing try/catch expressions on a single line. The following code will not work to return the value of x in case of an error:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"try bad() catch x end","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Instead, use a semicolon or insert a line break after catch:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"try bad() catch; x end\n\ntry bad()\ncatch\n    x\nend","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The power of the try/catch construct lies in the ability to unwind a deeply nested computation immediately to a much higher level in the stack of calling functions. There are situations where no error has occurred, but the ability to unwind the stack and pass a value to a higher level is desirable. Julia provides the rethrow, backtrace, catch_backtrace and Base.catch_stack functions for more advanced error handling.","category":"page"},{"location":"manual/control-flow.html#finally-Clauses-1","page":"Control Flow","title":"finally Clauses","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In code that performs state changes or uses resources like files, there is typically clean-up work (such as closing files) that needs to be done when the code is finished. Exceptions potentially complicate this task, since they can cause a block of code to exit before reaching its normal end. The finally keyword provides a way to run some code when a given block of code exits, regardless of how it exits.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"For example, here is how we can guarantee that an opened file is closed:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"f = open(\"file\")\ntry\n    # operate on file f\nfinally\n    close(f)\nend","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"When control leaves the try block (for example due to a return, or just finishing normally), close(f) will be executed. If the try block exits due to an exception, the exception will continue propagating. A catch block may be combined with try and finally as well. In this case the finally block will run after catch has handled the error.","category":"page"},{"location":"manual/control-flow.html#man-tasks-1","page":"Control Flow","title":"Tasks (aka Coroutines)","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Tasks are a control flow feature that allows computations to be suspended and resumed in a flexible manner. This feature is sometimes called by other names, such as symmetric coroutines, lightweight threads, cooperative multitasking, or one-shot continuations.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"When a piece of computing work (in practice, executing a particular function) is designated as a Task, it becomes possible to interrupt it by switching to another Task. The original Task can later be resumed, at which point it will pick up right where it left off. At first, this may seem similar to a function call. However there are two key differences. First, switching tasks does not use any space, so any number of task switches can occur without consuming the call stack. Second, switching among tasks can occur in any order, unlike function calls, where the called function must finish executing before control returns to the calling function.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"This kind of control flow can make it much easier to solve certain problems. In some problems, the various pieces of required work are not naturally related by function calls; there is no obvious \"caller\" or \"callee\" among the jobs that need to be done. An example is the producer-consumer problem, where one complex procedure is generating values and another complex procedure is consuming them. The consumer cannot simply call a producer function to get a value, because the producer may have more values to generate and so might not yet be ready to return. With tasks, the producer and consumer can both run as long as they need to, passing values back and forth as necessary.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Julia provides a Channel mechanism for solving this problem. A Channel is a waitable first-in first-out queue which can have multiple tasks reading from and writing to it.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Let's define a producer task, which produces values via the put! call. To consume values, we need to schedule the producer to run in a new task. A special Channel constructor which accepts a 1-arg function as an argument can be used to run a task bound to a channel. We can then take! values repeatedly from the channel object:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> function producer(c::Channel)\n           put!(c, \"start\")\n           for n=1:4\n               put!(c, 2n)\n           end\n           put!(c, \"stop\")\n       end;\n\njulia> chnl = Channel(producer);\n\njulia> take!(chnl)\n\"start\"\n\njulia> take!(chnl)\n2\n\njulia> take!(chnl)\n4\n\njulia> take!(chnl)\n6\n\njulia> take!(chnl)\n8\n\njulia> take!(chnl)\n\"stop\"","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"One way to think of this behavior is that producer was able to return multiple times. Between calls to put!, the producer's execution is suspended and the consumer has control.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The returned Channel can be used as an iterable object in a for loop, in which case the loop variable takes on all the produced values. The loop is terminated when the channel is closed.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"julia> for x in Channel(producer)\n           println(x)\n       end\nstart\n2\n4\n6\n8\nstop","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Note that we did not have to explicitly close the channel in the producer. This is because the act of binding a Channel to a Task associates the open lifetime of a channel with that of the bound task. The channel object is closed automatically when the task terminates. Multiple channels can be bound to a task, and vice-versa.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"While the Task constructor expects a 0-argument function, the Channel method which creates a channel bound task expects a function that accepts a single argument of type Channel. A common pattern is for the producer to be parameterized, in which case a partial function application is needed to create a 0 or 1 argument anonymous function.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"For Task objects this can be done either directly or by use of a convenience macro:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"function mytask(myarg)\n    ...\nend\n\ntaskHdl = Task(() -> mytask(7))\n# or, equivalently\ntaskHdl = @task mytask(7)","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"To orchestrate more advanced work distribution patterns, bind and schedule can be used in conjunction with Task and Channel constructors to explicitly link a set of channels with a set of producer/consumer tasks.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Note that currently Julia tasks are not scheduled to run on separate CPU cores. True kernel threads are discussed under the topic of Parallel Computing.","category":"page"},{"location":"manual/control-flow.html#Core-task-operations-1","page":"Control Flow","title":"Core task operations","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Let us explore the low level construct yieldto to understand how task switching works. yieldto(task,value) suspends the current task, switches to the specified task, and causes that task's last yieldto call to return the specified value. Notice that yieldto is the only operation required to use task-style control flow; instead of calling and returning we are always just switching to a different task. This is why this feature is also called \"symmetric coroutines\"; each task is switched to and from using the same mechanism.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"yieldto is powerful, but most uses of tasks do not invoke it directly. Consider why this might be. If you switch away from the current task, you will probably want to switch back to it at some point, but knowing when to switch back, and knowing which task has the responsibility of switching back, can require considerable coordination. For example, put! and take! are blocking operations, which, when used in the context of channels maintain state to remember who the consumers are. Not needing to manually keep track of the consuming task is what makes put! easier to use than the low-level yieldto.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In addition to yieldto, a few other basic functions are needed to use tasks effectively.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"current_task gets a reference to the currently-running task.\nistaskdone queries whether a task has exited.\nistaskstarted queries whether a task has run yet.\ntask_local_storage manipulates a key-value store specific to the current task.","category":"page"},{"location":"manual/control-flow.html#Tasks-and-events-1","page":"Control Flow","title":"Tasks and events","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Most task switches occur as a result of waiting for events such as I/O requests, and are performed by a scheduler included in Julia Base. The scheduler maintains a queue of runnable tasks, and executes an event loop that restarts tasks based on external events such as message arrival.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"The basic function for waiting for an event is wait. Several objects implement wait; for example, given a Process object, wait will wait for it to exit. wait is often implicit; for example, a wait can happen inside a call to read to wait for data to be available.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"In all of these cases, wait ultimately operates on a Condition object, which is in charge of queueing and restarting tasks. When a task calls wait on a Condition, the task is marked as non-runnable, added to the condition's queue, and switches to the scheduler. The scheduler will then pick another task to run, or block waiting for external events. If all goes well, eventually an event handler will call notify on the condition, which causes tasks waiting for that condition to become runnable again.","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"A task created explicitly by calling Task is initially not known to the scheduler. This allows you to manage tasks manually using yieldto if you wish. However, when such a task waits for an event, it still gets restarted automatically when the event happens, as you would expect. It is also possible to make the scheduler run a task whenever it can, without necessarily waiting for any events. This is done by calling schedule, or using the @async macro (see Parallel Computing for more details).","category":"page"},{"location":"manual/control-flow.html#Task-states-1","page":"Control Flow","title":"Task states","text":"","category":"section"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Tasks have a state field that describes their execution status. A Task state is one of the following symbols:","category":"page"},{"location":"manual/control-flow.html#","page":"Control Flow","title":"Control Flow","text":"Symbol Meaning\n:runnable Currently running, or able to run\n:done Successfully finished executing\n:failed Finished with an uncaught exception","category":"page"},{"location":"manual/variables-and-scoping.html#scope-of-variables-1","page":"Scope of Variables","title":"Scope of Variables","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The scope of a variable is the region of code within which a variable is visible. Variable scoping helps avoid variable naming conflicts. The concept is intuitive: two functions can both have arguments called x without the two x's referring to the same thing. Similarly, there are many other cases where different blocks of code can use the same name without referring to the same thing. The rules for when the same variable name does or doesn't refer to the same thing are called scope rules; this section spells them out in detail.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Certain constructs in the language introduce scope blocks, which are regions of code that are eligible to be the scope of some set of variables. The scope of a variable cannot be an arbitrary set of source lines; instead, it will always line up with one of these blocks. There are two main types of scopes in Julia, global scope and local scope. The latter can be nested. The constructs introducing scope blocks are:","category":"page"},{"location":"manual/variables-and-scoping.html#man-scope-table-1","page":"Scope of Variables","title":"Scope constructs","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Construct Scope type Scope blocks it may be nested in\nmodule, baremodule global global\ninteractive prompt (REPL) global global\n(mutable) struct, macro local global\nfor, while, try-catch-finally, let local global or local\nfunctions (either syntax, anonymous & do-blocks) local global or local\ncomprehensions, broadcast-fusing local global or local","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Notably missing from this table are begin blocks and if blocks which do not introduce new scopes. Both types of scopes follow somewhat different rules which will be explained below.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Julia uses lexical scoping, meaning that a function's scope does not inherit from its caller's scope, but from the scope in which the function was defined. For example, in the following code the x inside foo refers to the x in the global scope of its module Bar:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> module Bar\n           x = 1\n           foo() = x\n       end;","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"and not a x in the scope where foo is used:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> import .Bar\n\njulia> x = -1;\n\njulia> Bar.foo()\n1","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Thus lexical scope means that the scope of variables can be inferred from the source code alone.","category":"page"},{"location":"manual/variables-and-scoping.html#Global-Scope-1","page":"Scope of Variables","title":"Global Scope","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Each module introduces a new global scope, separate from the global scope of all other modules; there is no all-encompassing global scope. Modules can introduce variables of other modules into their scope through the using or import statements or through qualified access using the dot-notation, i.e. each module is a so-called namespace. Note that variable bindings can only be changed within their global scope and not from an outside module.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> module A\n           a = 1 # a global in A's scope\n       end;\n\njulia> module B\n           module C\n               c = 2\n           end\n           b = C.c    # can access the namespace of a nested global scope\n                      # through a qualified access\n           import ..A # makes module A available\n           d = A.a\n       end;\n\njulia> module D\n           b = a # errors as D's global scope is separate from A's\n       end;\nERROR: UndefVarError: a not defined\n\njulia> module E\n           import ..A # make module A available\n           A.a = 2    # throws below error\n       end;\nERROR: cannot assign variables in other modules","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Note that the interactive prompt (aka REPL) is in the global scope of the module Main.","category":"page"},{"location":"manual/variables-and-scoping.html#Local-Scope-1","page":"Scope of Variables","title":"Local Scope","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"A new local scope is introduced by most code blocks (see above table for a complete list). A local scope inherits all the variables from a parent local scope, both for reading and writing. Unlike global scopes, local scopes are not namespaces, thus variables in an inner scope cannot be retrieved from the parent scope through some sort of qualified access.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The following rules and examples pertain to local scopes. A newly introduced variable in a local scope cannot be referenced by a parent scope. For example, here the z is not introduced into the top-level scope:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> for i = 1:10\n           z = i\n       end\n\njulia> z\nERROR: UndefVarError: z not defined","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"note: Note\nIn this and all following examples it is assumed that their top-level is a global scope with a clean workspace, for instance a newly started REPL.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Inner local scopes can, however, update variables in their parent scopes:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> for i = 1:1\n           z = i\n           for j = 1:1\n               z = 0\n           end\n           println(z)\n       end\n0","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Inside a local scope a variable can be forced to be a new local variable using the local keyword:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> for i = 1:1\n           x = i + 1\n           for j = 1:1\n               local x = 0\n           end\n           println(x)\n       end\n2","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Inside a local scope a global variable can be assigned to by using the keyword global:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> for i = 1:10\n           global z\n           z = i\n       end\n\njulia> z\n10","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The location of both the local and global keywords within the scope block is irrelevant. The following is equivalent to the last example (although stylistically worse):","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> for i = 1:10\n           z = i\n           global z\n       end\n\njulia> z\n10","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The local and global keywords can also be applied to destructuring assignments, e.g. local x, y = 1, 2. In this case the keyword affects all listed variables.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"In a local scope, all variables are inherited from its parent global scope block unless:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"an assignment would result in a modified global variable, or\na variable is specifically marked with the keyword local.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Thus global variables are only inherited for reading, not for writing:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> x, y = 1, 2;\n\njulia> function foo()\n           x = 2        # assignment introduces a new local\n           return x + y # y refers to the global\n       end;\n\njulia> foo()\n4\n\njulia> x\n1","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"An explicit global is needed to assign to a global variable:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"sidebar: Avoiding globals\nAvoiding changing the value of global variables is considered by many to be a programming best-practice. Changing the value of a global variable can cause \"action at a distance\", making the behavior of a program harder to reason about. This is why the scope blocks that introduce local scope require the global keyword to declare the intent to modify a global variable.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> x = 1;\n\njulia> function foobar()\n           global x = 2\n       end;\n\njulia> foobar();\n\njulia> x\n2","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Note that nested functions can modify their parent scope's local variables:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> x, y = 1, 2;\n\njulia> function baz()\n           x = 2 # introduces a new local\n           function bar()\n               x = 10       # modifies the parent's x\n               return x + y # y is global\n           end\n           return bar() + x # 12 + 10 (x is modified in call of bar())\n       end;\n\njulia> baz()\n22\n\njulia> x, y # verify that global x and y are unchanged\n(1, 2)","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The reason to allow modifying local variables of parent scopes in nested functions is to allow constructing closures which have private state, for instance the state variable in the following example:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> let state = 0\n           global counter() = (state += 1)\n       end;\n\njulia> counter()\n1\n\njulia> counter()\n2","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"See also the closures in the examples in the next two sections. A variable, such as x in the first example and state in the second, that is inherited from the enclosing scope by the inner function is sometimes called a captured variable. Captured variables can present performance challenges discussed in performance tips.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The distinction between inheriting global scope and nesting local scope can lead to some slight differences between functions defined in local versus global scopes for variable assignments. Consider the modification of the last example by moving bar to the global scope:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> x, y = 1, 2;\n\njulia> function bar()\n           x = 10 # local, no longer a closure variable\n           return x + y\n       end;\n\njulia> function quz()\n           x = 2 # local\n           return bar() + x # 12 + 2 (x is not modified)\n       end;\n\njulia> quz()\n14\n\njulia> x, y # verify that global x and y are unchanged\n(1, 2)","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Note that the above nesting rules do not pertain to type and macro definitions as they can only appear at the global scope. There are special scoping rules concerning the evaluation of default and keyword function arguments which are described in the Function section.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"An assignment introducing a variable used inside a function, type or macro definition need not come before its inner usage:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> f = y -> y + a;\n\njulia> f(3)\nERROR: UndefVarError: a not defined\nStacktrace:\n[...]\n\njulia> a = 1\n1\n\njulia> f(3)\n4","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"This behavior may seem slightly odd for a normal variable, but allows for named functions – which are just normal variables holding function objects – to be used before they are defined. This allows functions to be defined in whatever order is intuitive and convenient, rather than forcing bottom up ordering or requiring forward declarations, as long as they are defined by the time they are actually called. As an example, here is an inefficient, mutually recursive way to test if positive integers are even or odd:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> even(n) = (n == 0) ? true : odd(n - 1);\n\njulia> odd(n) = (n == 0) ? false : even(n - 1);\n\njulia> even(3)\nfalse\n\njulia> odd(3)\ntrue","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Julia provides built-in, efficient functions to test for oddness and evenness called iseven and isodd so the above definitions should only be considered to be examples of scope, not efficient design.","category":"page"},{"location":"manual/variables-and-scoping.html#Let-Blocks-1","page":"Scope of Variables","title":"Let Blocks","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Unlike assignments to local variables, let statements allocate new variable bindings each time they run. An assignment modifies an existing value location, and let creates new locations. This difference is usually not important, and is only detectable in the case of variables that outlive their scope via closures. The let syntax accepts a comma-separated series of assignments and variable names:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> x, y, z = -1, -1, -1;\n\njulia> let x = 1, z\n           println(\"x: $x, y: $y\") # x is local variable, y the global\n           println(\"z: $z\") # errors as z has not been assigned yet but is local\n       end\nx: 1, y: -1\nERROR: UndefVarError: z not defined","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The assignments are evaluated in order, with each right-hand side evaluated in the scope before the new variable on the left-hand side has been introduced. Therefore it makes sense to write something like let x = x since the two x variables are distinct and have separate storage. Here is an example where the behavior of let is needed:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> Fs = Vector{Any}(undef, 2); i = 1;\n\njulia> while i <= 2\n           Fs[i] = ()->i\n           global i += 1\n       end\n\njulia> Fs[1]()\n3\n\njulia> Fs[2]()\n3","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Here we create and store two closures that return variable i. However, it is always the same variable i, so the two closures behave identically. We can use let to create a new binding for i:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> Fs = Vector{Any}(undef, 2); i = 1;\n\njulia> while i <= 2\n           let i = i\n               Fs[i] = ()->i\n           end\n           global i += 1\n       end\n\njulia> Fs[1]()\n1\n\njulia> Fs[2]()\n2","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Since the begin construct does not introduce a new scope, it can be useful to use a zero-argument let to just introduce a new scope block without creating any new bindings:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> let\n           local x = 1\n           let\n               local x = 2\n           end\n           x\n       end\n1","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Since let introduces a new scope block, the inner local x is a different variable than the outer local x.","category":"page"},{"location":"manual/variables-and-scoping.html#For-Loops-and-Comprehensions-1","page":"Scope of Variables","title":"For Loops and Comprehensions","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"for loops, while loops, and Comprehensions have the following behavior: any new variables introduced in their body scopes are freshly allocated for each loop iteration, as if the loop body were surrounded by a let block:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> Fs = Vector{Any}(undef, 2);\n\njulia> for j = 1:2\n           Fs[j] = ()->j\n       end\n\njulia> Fs[1]()\n1\n\njulia> Fs[2]()\n2","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"A for loop or comprehension iteration variable is always a new variable:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> function f()\n           i = 0\n           for i = 1:3\n           end\n           return i\n       end;\n\njulia> f()\n0","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"However, it is occasionally useful to reuse an existing local variable as the iteration variable. This can be done conveniently by adding the keyword outer:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> function f()\n           i = 0\n           for outer i = 1:3\n           end\n           return i\n       end;\n\njulia> f()\n3","category":"page"},{"location":"manual/variables-and-scoping.html#Constants-1","page":"Scope of Variables","title":"Constants","text":"","category":"section"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"A common use of variables is giving names to specific, unchanging values. Such variables are only assigned once. This intent can be conveyed to the compiler using the const keyword:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const e  = 2.71828182845904523536;\n\njulia> const pi = 3.14159265358979323846;","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Multiple variables can be declared in a single const statement:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const a, b = 1, 2\n(1, 2)","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The const declaration should only be used in global scope on globals. It is difficult for the compiler to optimize code involving global variables, since their values (or even their types) might change at almost any time. If a global variable will not change, adding a const declaration solves this performance problem.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Local constants are quite different. The compiler is able to determine automatically when a local variable is constant, so local constant declarations are not necessary, and in fact are currently not supported.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Special top-level assignments, such as those performed by the function and struct keywords, are constant by default.","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Note that const only affects the variable binding; the variable may be bound to a mutable object (such as an array), and that object may still be modified. Additionally when one tries to assign a value to a variable that is declared constant the following scenarios are possible:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"if a new value has a different type than the type of the constant then an error is thrown:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const x = 1.0\n1.0\n\njulia> x = 1\nERROR: invalid redefinition of constant x","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"if a new value has the same type as the constant then a warning is printed:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const y = 1.0\n1.0\n\njulia> y = 2.0\nWARNING: redefining constant y\n2.0","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"if an assignment would not result in the change of variable value no message is given:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const z = 100\n100\n\njulia> z = 100\n100","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"The last rule applies for immutable objects even if the variable binding would change, e.g.:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const s1 = \"1\"\n\"1\"\n\njulia> s2 = \"1\"\n\"1\"\n\njulia> pointer.([s1, s2], 1)\n2-element Array{Ptr{UInt8},1}:\n Ptr{UInt8} @0x00000000132c9638\n Ptr{UInt8} @0x0000000013dd3d18\n\njulia> s1 = s2\n\"1\"\n\njulia> pointer.([s1, s2], 1)\n2-element Array{Ptr{UInt8},1}:\n Ptr{UInt8} @0x0000000013dd3d18\n Ptr{UInt8} @0x0000000013dd3d18","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"However, for mutable objects the warning is printed as expected:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const a = [1]\n1-element Array{Int64,1}:\n 1\n\njulia> a = [1]\nWARNING: redefining constant a\n1-element Array{Int64,1}:\n 1","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"Note that although sometimes possible, changing the value of a const variable is strongly discouraged, and is intended only for convenience during interactive use. Changing constants can cause various problems or unexpected behaviors. For instance, if a method references a constant and is already compiled before the constant is changed then it might keep using the old value:","category":"page"},{"location":"manual/variables-and-scoping.html#","page":"Scope of Variables","title":"Scope of Variables","text":"julia> const x = 1\n1\n\njulia> f() = x\nf (generic function with 1 method)\n\njulia> f()\n1\n\njulia> x = 2\nWARNING: redefining constant x\n2\n\njulia> f()\n1","category":"page"},{"location":"manual/types.html#man-types-1","page":"Types","title":"Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Type systems have traditionally fallen into two quite different camps: static type systems, where every program expression must have a type computable before the execution of the program, and dynamic type systems, where nothing is known about types until run time, when the actual values manipulated by the program are available. Object orientation allows some flexibility in statically typed languages by letting code be written without the precise types of values being known at compile time. The ability to write code that can operate on different types is called polymorphism. All code in classic dynamically typed languages is polymorphic: only by explicitly checking types, or when objects fail to support operations at run-time, are the types of any values ever restricted.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Julia's type system is dynamic, but gains some of the advantages of static type systems by making it possible to indicate that certain values are of specific types. This can be of great assistance in generating efficient code, but even more significantly, it allows method dispatch on the types of function arguments to be deeply integrated with the language. Method dispatch is explored in detail in Methods, but is rooted in the type system presented here.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The default behavior in Julia when types are omitted is to allow values to be of any type. Thus, one can write many useful Julia functions without ever explicitly using types. When additional expressiveness is needed, however, it is easy to gradually introduce explicit type annotations into previously \"untyped\" code. Adding annotations serves three primary purposes: to take advantage of Julia's powerful multiple-dispatch mechanism,  to improve human readability, and to catch programmer errors.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Describing Julia in the lingo of type systems, it is: dynamic, nominative and parametric. Generic types can be parameterized, and the hierarchical relationships between types are explicitly declared, rather than implied by compatible structure. One particularly distinctive feature of Julia's type system is that concrete types may not subtype each other: all concrete types are final and may only have abstract types as their supertypes. While this might at first seem unduly restrictive, it has many beneficial consequences with surprisingly few drawbacks. It turns out that being able to inherit behavior is much more important than being able to inherit structure, and inheriting both causes significant difficulties in traditional object-oriented languages. Other high-level aspects of Julia's type system that should be mentioned up front are:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There is no division between object and non-object values: all values in Julia are true objects having a type that belongs to a single, fully connected type graph, all nodes of which are equally first-class as types.\nThere is no meaningful concept of a \"compile-time type\": the only type a value has is its actual type when the program is running. This is called a \"run-time type\" in object-oriented languages where the combination of static compilation with polymorphism makes this distinction significant.\nOnly values, not variables, have types – variables are simply names bound to values.\nBoth abstract and concrete types can be parameterized by other types. They can also be parameterized by symbols, by values of any type for which isbits returns true (essentially, things like numbers and bools that are stored like C types or structs with no pointers to other objects), and also by tuples thereof. Type parameters may be omitted when they do not need to be referenced or restricted.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Julia's type system is designed to be powerful and expressive, yet clear, intuitive and unobtrusive. Many Julia programmers may never feel the need to write code that explicitly uses types. Some kinds of programming, however, become clearer, simpler, faster and more robust with declared types.","category":"page"},{"location":"manual/types.html#Type-Declarations-1","page":"Types","title":"Type Declarations","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The :: operator can be used to attach type annotations to expressions and variables in programs. There are two primary reasons to do this:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"As an assertion to help confirm that your program works the way you expect,\nTo provide extra type information to the compiler, which can then improve performance in some cases","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"When appended to an expression computing a value, the :: operator is read as \"is an instance of\". It can be used anywhere to assert that the value of the expression on the left is an instance of the type on the right. When the type on the right is concrete, the value on the left must have that type as its implementation – recall that all concrete types are final, so no implementation is a subtype of any other. When the type is abstract, it suffices for the value to be implemented by a concrete type that is a subtype of the abstract type. If the type assertion is not true, an exception is thrown, otherwise, the left-hand value is returned:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> (1+2)::AbstractFloat\nERROR: TypeError: in typeassert, expected AbstractFloat, got Int64\n\njulia> (1+2)::Int\n3","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This allows a type assertion to be attached to any expression in-place.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"When appended to a variable on the left-hand side of an assignment, or as part of a local declaration, the :: operator means something a bit different: it declares the variable to always have the specified type, like a type declaration in a statically-typed language such as C. Every value assigned to the variable will be converted to the declared type using convert:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> function foo()\n           x::Int8 = 100\n           x\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n100\n\njulia> typeof(ans)\nInt8","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This feature is useful for avoiding performance \"gotchas\" that could occur if one of the assignments to a variable changed its type unexpectedly.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This \"declaration\" behavior only occurs in specific contexts:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"local x::Int8  # in a local declaration\nx::Int8 = 10   # as the left-hand side of an assignment","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"and applies to the whole current scope, even before the declaration. Currently, type declarations cannot be used in global scope, e.g. in the REPL, since Julia does not yet have constant-type globals.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Declarations can also be attached to function definitions:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"function sinc(x)::Float64\n    if x == 0\n        return 1\n    end\n    return sin(pi*x)/(pi*x)\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Returning from this function behaves just like an assignment to a variable with a declared type: the value is always converted to Float64.","category":"page"},{"location":"manual/types.html#Abstract-Types-1","page":"Types","title":"Abstract Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Abstract types cannot be instantiated, and serve only as nodes in the type graph, thereby describing sets of related concrete types: those concrete types which are their descendants. We begin with abstract types even though they have no instantiation because they are the backbone of the type system: they form the conceptual hierarchy which makes Julia's type system more than just a collection of object implementations.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Recall that in Integers and Floating-Point Numbers, we introduced a variety of concrete types of numeric values: Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, Float16, Float32, and Float64. Although they have different representation sizes, Int8, Int16, Int32, Int64 and Int128 all have in common that they are signed integer types. Likewise UInt8, UInt16, UInt32, UInt64 and UInt128 are all unsigned integer types, while Float16, Float32 and Float64 are distinct in being floating-point types rather than integers. It is common for a piece of code to make sense, for example, only if its arguments are some kind of integer, but not really depend on what particular kind of integer. For example, the greatest common denominator algorithm works for all kinds of integers, but will not work for floating-point numbers. Abstract types allow the construction of a hierarchy of types, providing a context into which concrete types can fit. This allows you, for example, to easily program to any type that is an integer, without restricting an algorithm to a specific type of integer.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Abstract types are declared using the abstract type keyword. The general syntaxes for declaring an abstract type are:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"abstract type «name» end\nabstract type «name» <: «supertype» end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The abstract type keyword introduces a new abstract type, whose name is given by «name». This name can be optionally followed by <: and an already-existing type, indicating that the newly declared abstract type is a subtype of this \"parent\" type.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"When no supertype is given, the default supertype is Any – a predefined abstract type that all objects are instances of and all types are subtypes of. In type theory, Any is commonly called \"top\" because it is at the apex of the type graph. Julia also has a predefined abstract \"bottom\" type, at the nadir of the type graph, which is written as Union{}. It is the exact opposite of Any: no object is an instance of Union{} and all types are supertypes of Union{}.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Let's consider some of the abstract types that make up Julia's numerical hierarchy:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"abstract type Number end\nabstract type Real     <: Number end\nabstract type AbstractFloat <: Real end\nabstract type Integer  <: Real end\nabstract type Signed   <: Integer end\nabstract type Unsigned <: Integer end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The Number type is a direct child type of Any, and Real is its child. In turn, Real has two children (it has more, but only two are shown here; we'll get to the others later): Integer and AbstractFloat, separating the world into representations of integers and representations of real numbers. Representations of real numbers include, of course, floating-point types, but also include other types, such as rationals. Hence, AbstractFloat is a proper subtype of Real, including only floating-point representations of real numbers. Integers are further subdivided into Signed and Unsigned varieties.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The <: operator in general means \"is a subtype of\", and, used in declarations like this, declares the right-hand type to be an immediate supertype of the newly declared type. It can also be used in expressions as a subtype operator which returns true when its left operand is a subtype of its right operand:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Integer <: Number\ntrue\n\njulia> Integer <: AbstractFloat\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"An important use of abstract types is to provide default implementations for concrete types. To give a simple example, consider:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"function myplus(x,y)\n    x+y\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The first thing to note is that the above argument declarations are equivalent to x::Any and y::Any. When this function is invoked, say as myplus(2,5), the dispatcher chooses the most specific method named myplus that matches the given arguments. (See Methods for more information on multiple dispatch.)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Assuming no method more specific than the above is found, Julia next internally defines and compiles a method called myplus specifically for two Int arguments based on the generic function given above, i.e., it implicitly defines and compiles:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"function myplus(x::Int,y::Int)\n    x+y\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"and finally, it invokes this specific method.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Thus, abstract types allow programmers to write generic functions that can later be used as the default method by many combinations of concrete types. Thanks to multiple dispatch, the programmer has full control over whether the default or more specific method is used.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"An important point to note is that there is no loss in performance if the programmer relies on a function whose arguments are abstract types, because it is recompiled for each tuple of argument concrete types with which it is invoked. (There may be a performance issue, however, in the case of function arguments that are containers of abstract types; see Performance Tips.)","category":"page"},{"location":"manual/types.html#Primitive-Types-1","page":"Types","title":"Primitive Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A primitive type is a concrete type whose data consists of plain old bits. Classic examples of primitive types are integers and floating-point values. Unlike most languages, Julia lets you declare your own primitive types, rather than providing only a fixed set of built-in ones. In fact, the standard primitive types are all defined in the language itself:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"primitive type Float16 <: AbstractFloat 16 end\nprimitive type Float32 <: AbstractFloat 32 end\nprimitive type Float64 <: AbstractFloat 64 end\n\nprimitive type Bool <: Integer 8 end\nprimitive type Char <: AbstractChar 32 end\n\nprimitive type Int8    <: Signed   8 end\nprimitive type UInt8   <: Unsigned 8 end\nprimitive type Int16   <: Signed   16 end\nprimitive type UInt16  <: Unsigned 16 end\nprimitive type Int32   <: Signed   32 end\nprimitive type UInt32  <: Unsigned 32 end\nprimitive type Int64   <: Signed   64 end\nprimitive type UInt64  <: Unsigned 64 end\nprimitive type Int128  <: Signed   128 end\nprimitive type UInt128 <: Unsigned 128 end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The general syntaxes for declaring a primitive type are:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"primitive type «name» «bits» end\nprimitive type «name» <: «supertype» «bits» end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The number of bits indicates how much storage the type requires and the name gives the new type a name. A primitive type can optionally be declared to be a subtype of some supertype. If a supertype is omitted, then the type defaults to having Any as its immediate supertype. The declaration of Bool above therefore means that a boolean value takes eight bits to store, and has Integer as its immediate supertype. Currently, only sizes that are multiples of 8 bits are supported. Therefore, boolean values, although they really need just a single bit, cannot be declared to be any smaller than eight bits.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The types Bool, Int8 and UInt8 all have identical representations: they are eight-bit chunks of memory. Since Julia's type system is nominative, however, they are not interchangeable despite having identical structure. A fundamental difference between them is that they have different supertypes: Bool's direct supertype is Integer, Int8's is Signed, and UInt8's is Unsigned. All other differences between Bool, Int8, and UInt8 are matters of behavior – the way functions are defined to act when given objects of these types as arguments. This is why a nominative type system is necessary: if structure determined type, which in turn dictates behavior, then it would be impossible to make Bool behave any differently than Int8 or UInt8.","category":"page"},{"location":"manual/types.html#Composite-Types-1","page":"Types","title":"Composite Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Composite types are called records, structs, or objects in various languages. A composite type is a collection of named fields, an instance of which can be treated as a single value. In many languages, composite types are the only kind of user-definable type, and they are by far the most commonly used user-defined type in Julia as well.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In mainstream object oriented languages, such as C++, Java, Python and Ruby, composite types also have named functions associated with them, and the combination is called an \"object\". In purer object-oriented languages, such as Ruby or Smalltalk, all values are objects whether they are composites or not. In less pure object oriented languages, including C++ and Java, some values, such as integers and floating-point values, are not objects, while instances of user-defined composite types are true objects with associated methods. In Julia, all values are objects, but functions are not bundled with the objects they operate on. This is necessary since Julia chooses which method of a function to use by multiple dispatch, meaning that the types of all of a function's arguments are considered when selecting a method, rather than just the first one (see Methods for more information on methods and dispatch). Thus, it would be inappropriate for functions to \"belong\" to only their first argument. Organizing methods into function objects rather than having named bags of methods \"inside\" each object ends up being a highly beneficial aspect of the language design.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Composite types are introduced with the struct keyword followed by a block of field names, optionally annotated with types using the :: operator:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct Foo\n           bar\n           baz::Int\n           qux::Float64\n       end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Fields with no type annotation default to Any, and can accordingly hold any type of value.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"New objects of type Foo are created by applying the Foo type object like a function to values for its fields:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> foo = Foo(\"Hello, world.\", 23, 1.5)\nFoo(\"Hello, world.\", 23, 1.5)\n\njulia> typeof(foo)\nFoo","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"When a type is applied like a function it is called a constructor. Two constructors are generated automatically (these are called default constructors). One accepts any arguments and calls convert to convert them to the types of the fields, and the other accepts arguments that match the field types exactly. The reason both of these are generated is that this makes it easier to add new definitions without inadvertently replacing a default constructor.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Since the bar field is unconstrained in type, any value will do. However, the value for baz must be convertible to Int:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Foo((), 23.5, 1)\nERROR: InexactError: Int64(23.5)\nStacktrace:\n[...]","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"You may find a list of field names using the fieldnames function.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> fieldnames(Foo)\n(:bar, :baz, :qux)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"You can access the field values of a composite object using the traditional foo.bar notation:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> foo.bar\n\"Hello, world.\"\n\njulia> foo.baz\n23\n\njulia> foo.qux\n1.5","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Composite objects declared with struct are immutable; they cannot be modified after construction. This may seem odd at first, but it has several advantages:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"It can be more efficient. Some structs can be packed efficiently into arrays, and in some cases the compiler is able to avoid allocating immutable objects entirely.\nIt is not possible to violate the invariants provided by the type's constructors.\nCode using immutable objects can be easier to reason about.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"An immutable object might contain mutable objects, such as arrays, as fields. Those contained objects will remain mutable; only the fields of the immutable object itself cannot be changed to point to different objects.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Where required, mutable composite objects can be declared with the keyword mutable struct, to be discussed in the next section.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Immutable composite types with no fields are singletons; there can be only one instance of such types:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct NoFields\n       end\n\njulia> NoFields() === NoFields()\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The === function confirms that the \"two\" constructed instances of NoFields are actually one and the same. Singleton types are described in further detail below.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There is much more to say about how instances of composite types are created, but that discussion depends on both Parametric Types and on Methods, and is sufficiently important to be addressed in its own section: Constructors.","category":"page"},{"location":"manual/types.html#Mutable-Composite-Types-1","page":"Types","title":"Mutable Composite Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"If a composite type is declared with mutable struct instead of struct, then instances of it can be modified:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> mutable struct Bar\n           baz\n           qux::Float64\n       end\n\njulia> bar = Bar(\"Hello\", 1.5);\n\njulia> bar.qux = 2.0\n2.0\n\njulia> bar.baz = 1//2\n1//2","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In order to support mutation, such objects are generally allocated on the heap, and have stable memory addresses. A mutable object is like a little container that might hold different values over time, and so can only be reliably identified with its address. In contrast, an instance of an immutable type is associated with specific field values –- the field values alone tell you everything about the object. In deciding whether to make a type mutable, ask whether two instances with the same field values would be considered identical, or if they might need to change independently over time. If they would be considered identical, the type should probably be immutable.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"To recap, two essential properties define immutability in Julia:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"It is not permitted to modify the value of an immutable type.\nFor bits types this means that the bit pattern of a value once set will never change and that value is the identity of a bits type.\nFor composite  types, this means that the identity of the values of its fields will never change. When the fields are bits types, that means their bits will never change, for fields whose values are mutable types like arrays, that means the fields will always refer to the same mutable value even though that mutable value's content may itself be modified.\nAn object with an immutable type may be copied freely by the compiler since its immutability makes it impossible to programmatically distinguish between the original object and a copy.\nIn particular, this means that small enough immutable values like integers and floats are typically passed to functions in registers (or stack allocated).\nMutable values, on the other hand are heap-allocated and passed to functions as pointers to heap-allocated values except in cases where the compiler is sure that there's no way to tell that this is not what is happening.","category":"page"},{"location":"manual/types.html#Declared-Types-1","page":"Types","title":"Declared Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The three kinds of types (abstract, primitive, composite) discussed in the previous sections are actually all closely related. They share the same key properties:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"They are explicitly declared.\nThey have names.\nThey have explicitly declared supertypes.\nThey may have parameters.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Because of these shared properties, these types are internally represented as instances of the same concept, DataType, which is the type of any of these types:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> typeof(Real)\nDataType\n\njulia> typeof(Int)\nDataType","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A DataType may be abstract or concrete. If it is concrete, it has a specified size, storage layout, and (optionally) field names. Thus a primitive type is a DataType with nonzero size, but no field names. A composite type is a DataType that has field names or is empty (zero size).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Every concrete value in the system is an instance of some DataType.","category":"page"},{"location":"manual/types.html#Type-Unions-1","page":"Types","title":"Type Unions","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A type union is a special abstract type which includes as objects all instances of any of its argument types, constructed using the special Union keyword:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> IntOrString = Union{Int,AbstractString}\nUnion{Int64, AbstractString}\n\njulia> 1 :: IntOrString\n1\n\njulia> \"Hello!\" :: IntOrString\n\"Hello!\"\n\njulia> 1.0 :: IntOrString\nERROR: TypeError: in typeassert, expected Union{Int64, AbstractString}, got Float64","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The compilers for many languages have an internal union construct for reasoning about types; Julia simply exposes it to the programmer. The Julia compiler is able to generate efficient code in the presence of Union types with a small number of types [1], by generating specialized code in separate branches for each possible type.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A particularly useful case of a Union type is Union{T, Nothing}, where T can be any type and Nothing is the singleton type whose only instance is the object nothing. This pattern is the Julia equivalent of Nullable, Option or Maybe types in other languages. Declaring a function argument or a field as Union{T, Nothing} allows setting it either to a value of type T, or to nothing to indicate that there is no value. See this FAQ entry for more information.","category":"page"},{"location":"manual/types.html#Parametric-Types-1","page":"Types","title":"Parametric Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"An important and powerful feature of Julia's type system is that it is parametric: types can take parameters, so that type declarations actually introduce a whole family of new types – one for each possible combination of parameter values. There are many languages that support some version of generic programming, wherein data structures and algorithms to manipulate them may be specified without specifying the exact types involved. For example, some form of generic programming exists in ML, Haskell, Ada, Eiffel, C++, Java, C#, F#, and Scala, just to name a few. Some of these languages support true parametric polymorphism (e.g. ML, Haskell, Scala), while others support ad-hoc, template-based styles of generic programming (e.g. C++, Java). With so many different varieties of generic programming and parametric types in various languages, we won't even attempt to compare Julia's parametric types to other languages, but will instead focus on explaining Julia's system in its own right. We will note, however, that because Julia is a dynamically typed language and doesn't need to make all type decisions at compile time, many traditional difficulties encountered in static parametric type systems can be relatively easily handled.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"All declared types (the DataType variety) can be parameterized, with the same syntax in each case. We will discuss them in the following order: first, parametric composite types, then parametric abstract types, and finally parametric primitive types.","category":"page"},{"location":"manual/types.html#Parametric-Composite-Types-1","page":"Types","title":"Parametric Composite Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Type parameters are introduced immediately after the type name, surrounded by curly braces:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct Point{T}\n           x::T\n           y::T\n       end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This declaration defines a new parametric type, Point{T}, holding two \"coordinates\" of type T. What, one may ask, is T? Well, that's precisely the point of parametric types: it can be any type at all (or a value of any bits type, actually, although here it's clearly used as a type). Point{Float64} is a concrete type equivalent to the type defined by replacing T in the definition of Point with Float64. Thus, this single declaration actually declares an unlimited number of types: Point{Float64}, Point{AbstractString}, Point{Int64}, etc. Each of these is now a usable concrete type:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64}\nPoint{Float64}\n\njulia> Point{AbstractString}\nPoint{AbstractString}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The type Point{Float64} is a point whose coordinates are 64-bit floating-point values, while the type Point{AbstractString} is a \"point\" whose \"coordinates\" are string objects (see Strings).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Point itself is also a valid type object, containing all instances Point{Float64}, Point{AbstractString}, etc. as subtypes:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64} <: Point\ntrue\n\njulia> Point{AbstractString} <: Point\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Other types, of course, are not subtypes of it:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Float64 <: Point\nfalse\n\njulia> AbstractString <: Point\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Concrete Point types with different values of T are never subtypes of each other:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64} <: Point{Int64}\nfalse\n\njulia> Point{Float64} <: Point{Real}\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"warning: Warning\nThis last point is very important: even though Float64 <: Real we DO NOT have Point{Float64} <: Point{Real}.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In other words, in the parlance of type theory, Julia's type parameters are invariant, rather than being covariant (or even contravariant). This is for practical reasons: while any instance of Point{Float64} may conceptually be like an instance of Point{Real} as well, the two types have different representations in memory:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"An instance of Point{Float64} can be represented compactly and efficiently as an immediate pair of 64-bit values;\nAn instance of Point{Real} must be able to hold any pair of instances of Real. Since objects that are instances of Real can be of arbitrary size and structure, in practice an instance of Point{Real} must be represented as a pair of pointers to individually allocated Real objects.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The efficiency gained by being able to store Point{Float64} objects with immediate values is magnified enormously in the case of arrays: an Array{Float64} can be stored as a contiguous memory block of 64-bit floating-point values, whereas an Array{Real} must be an array of pointers to individually allocated Real objects – which may well be boxed 64-bit floating-point values, but also might be arbitrarily large, complex objects, which are declared to be implementations of the Real abstract type.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Since Point{Float64} is not a subtype of Point{Real}, the following method can't be applied to arguments of type Point{Float64}:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"function norm(p::Point{Real})\n    sqrt(p.x^2 + p.y^2)\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A correct way to define a method that accepts all arguments of type Point{T} where T is a subtype of Real is:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"function norm(p::Point{<:Real})\n    sqrt(p.x^2 + p.y^2)\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"(Equivalently, one could define function norm(p::Point{T} where T<:Real) or function norm(p::Point{T}) where T<:Real; see UnionAll Types.)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"More examples will be discussed later in Methods.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"How does one construct a Point object? It is possible to define custom constructors for composite types, which will be discussed in detail in Constructors, but in the absence of any special constructor declarations, there are two default ways of creating new composite objects, one in which the type parameters are explicitly given and the other in which they are implied by the arguments to the object constructor.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Since the type Point{Float64} is a concrete type equivalent to Point declared with Float64 in place of T, it can be applied as a constructor accordingly:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64}(1.0, 2.0)\nPoint{Float64}(1.0, 2.0)\n\njulia> typeof(ans)\nPoint{Float64}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"For the default constructor, exactly one argument must be supplied for each field:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64}(1.0)\nERROR: MethodError: no method matching Point{Float64}(::Float64)\n[...]\n\njulia> Point{Float64}(1.0,2.0,3.0)\nERROR: MethodError: no method matching Point{Float64}(::Float64, ::Float64, ::Float64)\n[...]","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Only one default constructor is generated for parametric types, since overriding it is not possible. This constructor accepts any arguments and converts them to the field types.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In many cases, it is redundant to provide the type of Point object one wants to construct, since the types of arguments to the constructor call already implicitly provide type information. For that reason, you can also apply Point itself as a constructor, provided that the implied value of the parameter type T is unambiguous:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point(1.0,2.0)\nPoint{Float64}(1.0, 2.0)\n\njulia> typeof(ans)\nPoint{Float64}\n\njulia> Point(1,2)\nPoint{Int64}(1, 2)\n\njulia> typeof(ans)\nPoint{Int64}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In the case of Point, the type of T is unambiguously implied if and only if the two arguments to Point have the same type. When this isn't the case, the constructor will fail with a MethodError:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point(1,2.5)\nERROR: MethodError: no method matching Point(::Int64, ::Float64)\nClosest candidates are:\n  Point(::T, !Matched::T) where T at none:2","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Constructor methods to appropriately handle such mixed cases can be defined, but that will not be discussed until later on in Constructors.","category":"page"},{"location":"manual/types.html#Parametric-Abstract-Types-1","page":"Types","title":"Parametric Abstract Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Parametric abstract type declarations declare a collection of abstract types, in much the same way:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> abstract type Pointy{T} end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"With this declaration, Pointy{T} is a distinct abstract type for each type or integer value of T. As with parametric composite types, each such instance is a subtype of Pointy:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Pointy{Int64} <: Pointy\ntrue\n\njulia> Pointy{1} <: Pointy\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Parametric abstract types are invariant, much as parametric composite types are:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Pointy{Float64} <: Pointy{Real}\nfalse\n\njulia> Pointy{Real} <: Pointy{Float64}\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The notation Pointy{<:Real} can be used to express the Julia analogue of a covariant type, while Pointy{>:Int} the analogue of a contravariant type, but technically these represent sets of types (see UnionAll Types).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Pointy{Float64} <: Pointy{<:Real}\ntrue\n\njulia> Pointy{Real} <: Pointy{>:Int}\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Much as plain old abstract types serve to create a useful hierarchy of types over concrete types, parametric abstract types serve the same purpose with respect to parametric composite types. We could, for example, have declared Point{T} to be a subtype of Pointy{T} as follows:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct Point{T} <: Pointy{T}\n           x::T\n           y::T\n       end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Given such a declaration, for each choice of T, we have Point{T} as a subtype of Pointy{T}:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64} <: Pointy{Float64}\ntrue\n\njulia> Point{Real} <: Pointy{Real}\ntrue\n\njulia> Point{AbstractString} <: Pointy{AbstractString}\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This relationship is also invariant:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Point{Float64} <: Pointy{Real}\nfalse\n\njulia> Point{Float64} <: Pointy{<:Real}\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"What purpose do parametric abstract types like Pointy serve? Consider if we create a point-like implementation that only requires a single coordinate because the point is on the diagonal line x = y:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct DiagPoint{T} <: Pointy{T}\n           x::T\n       end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Now both Point{Float64} and DiagPoint{Float64} are implementations of the Pointy{Float64} abstraction, and similarly for every other possible choice of type T. This allows programming to a common interface shared by all Pointy objects, implemented for both Point and DiagPoint. This cannot be fully demonstrated, however, until we have introduced methods and dispatch in the next section, Methods.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There are situations where it may not make sense for type parameters to range freely over all possible types. In such situations, one can constrain the range of T like so:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> abstract type Pointy{T<:Real} end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"With such a declaration, it is acceptable to use any type that is a subtype of Real in place of T, but not types that are not subtypes of Real:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Pointy{Float64}\nPointy{Float64}\n\njulia> Pointy{Real}\nPointy{Real}\n\njulia> Pointy{AbstractString}\nERROR: TypeError: in Pointy, in T, expected T<:Real, got Type{AbstractString}\n\njulia> Pointy{1}\nERROR: TypeError: in Pointy, in T, expected T<:Real, got Int64","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Type parameters for parametric composite types can be restricted in the same manner:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"struct Point{T<:Real} <: Pointy{T}\n    x::T\n    y::T\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"To give a real-world example of how all this parametric type machinery can be useful, here is the actual definition of Julia's Rational immutable type (except that we omit the constructor here for simplicity), representing an exact ratio of integers:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"struct Rational{T<:Integer} <: Real\n    num::T\n    den::T\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"It only makes sense to take ratios of integer values, so the parameter type T is restricted to being a subtype of Integer, and a ratio of integers represents a value on the real number line, so any Rational is an instance of the Real abstraction.","category":"page"},{"location":"manual/types.html#Tuple-Types-1","page":"Types","title":"Tuple Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Tuples are an abstraction of the arguments of a function – without the function itself. The salient aspects of a function's arguments are their order and their types. Therefore a tuple type is similar to a parameterized immutable type where each parameter is the type of one field. For example, a 2-element tuple type resembles the following immutable type:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"struct Tuple2{A,B}\n    a::A\n    b::B\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"However, there are three key differences:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Tuple types may have any number of parameters.\nTuple types are covariant in their parameters: Tuple{Int} is a subtype of Tuple{Any}. Therefore Tuple{Any} is considered an abstract type, and tuple types are only concrete if their parameters are.\nTuples do not have field names; fields are only accessed by index.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Tuple values are written with parentheses and commas. When a tuple is constructed, an appropriate tuple type is generated on demand:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> typeof((1,\"foo\",2.5))\nTuple{Int64,String,Float64}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Note the implications of covariance:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Tuple{Int,AbstractString} <: Tuple{Real,Any}\ntrue\n\njulia> Tuple{Int,AbstractString} <: Tuple{Real,Real}\nfalse\n\njulia> Tuple{Int,AbstractString} <: Tuple{Real,}\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Intuitively, this corresponds to the type of a function's arguments being a subtype of the function's signature (when the signature matches).","category":"page"},{"location":"manual/types.html#Vararg-Tuple-Types-1","page":"Types","title":"Vararg Tuple Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The last parameter of a tuple type can be the special type Vararg, which denotes any number of trailing elements:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> mytupletype = Tuple{AbstractString,Vararg{Int}}\nTuple{AbstractString,Vararg{Int64,N} where N}\n\njulia> isa((\"1\",), mytupletype)\ntrue\n\njulia> isa((\"1\",1), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2), mytupletype)\ntrue\n\njulia> isa((\"1\",1,2,3.0), mytupletype)\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Notice that Vararg{T} corresponds to zero or more elements of type T. Vararg tuple types are used to represent the arguments accepted by varargs methods (see Varargs Functions).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The type Vararg{T,N} corresponds to exactly N elements of type T.  NTuple{N,T} is a convenient alias for Tuple{Vararg{T,N}}, i.e. a tuple type containing exactly N elements of type T.","category":"page"},{"location":"manual/types.html#Named-Tuple-Types-1","page":"Types","title":"Named Tuple Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Named tuples are instances of the NamedTuple type, which has two parameters: a tuple of symbols giving the field names, and a tuple type giving the field types.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> typeof((a=1,b=\"hello\"))\nNamedTuple{(:a, :b),Tuple{Int64,String}}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A NamedTuple type can be used as a constructor, accepting a single tuple argument. The constructed NamedTuple type can be either a concrete type, with both parameters specified, or a type that specifies only field names:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> NamedTuple{(:a, :b),Tuple{Float32, String}}((1,\"\"))\n(a = 1.0f0, b = \"\")\n\njulia> NamedTuple{(:a, :b)}((1,\"\"))\n(a = 1, b = \"\")","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"If field types are specified, the arguments are converted. Otherwise the types of the arguments are used directly.","category":"page"},{"location":"manual/types.html#man-singleton-types-1","page":"Types","title":"Singleton Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There is a special kind of abstract parametric type that must be mentioned here: singleton types. For each type, T, the \"singleton type\" Type{T} is an abstract type whose only instance is the object T. Since the definition is a little difficult to parse, let's look at some examples:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> isa(Float64, Type{Float64})\ntrue\n\njulia> isa(Real, Type{Float64})\nfalse\n\njulia> isa(Real, Type{Real})\ntrue\n\njulia> isa(Float64, Type{Real})\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In other words, isa(A,Type{B}) is true if and only if A and B are the same object and that object is a type. Without the parameter, Type is simply an abstract type which has all type objects as its instances, including, of course, singleton types:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> isa(Type{Float64}, Type)\ntrue\n\njulia> isa(Float64, Type)\ntrue\n\njulia> isa(Real, Type)\ntrue","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Any object that is not a type is not an instance of Type:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> isa(1, Type)\nfalse\n\njulia> isa(\"foo\", Type)\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Until we discuss Parametric Methods and conversions, it is difficult to explain the utility of the singleton type construct, but in short, it allows one to specialize function behavior on specific type values. This is useful for writing methods (especially parametric ones) whose behavior depends on a type that is given as an explicit argument rather than implied by the type of one of its arguments.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A few popular languages have singleton types, including Haskell, Scala and Ruby. In general usage, the term \"singleton type\" refers to a type whose only instance is a single value. This meaning applies to Julia's singleton types, but with that caveat that only type objects have singleton types.","category":"page"},{"location":"manual/types.html#Parametric-Primitive-Types-1","page":"Types","title":"Parametric Primitive Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Primitive types can also be declared parametrically. For example, pointers are represented as primitive types which would be declared in Julia like this:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"# 32-bit system:\nprimitive type Ptr{T} 32 end\n\n# 64-bit system:\nprimitive type Ptr{T} 64 end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The slightly odd feature of these declarations as compared to typical parametric composite types, is that the type parameter T is not used in the definition of the type itself – it is just an abstract tag, essentially defining an entire family of types with identical structure, differentiated only by their type parameter. Thus, Ptr{Float64} and Ptr{Int64} are distinct types, even though they have identical representations. And of course, all specific pointer types are subtypes of the umbrella Ptr type:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Ptr{Float64} <: Ptr\ntrue\n\njulia> Ptr{Int64} <: Ptr\ntrue","category":"page"},{"location":"manual/types.html#UnionAll-Types-1","page":"Types","title":"UnionAll Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"We have said that a parametric type like Ptr acts as a supertype of all its instances (Ptr{Int64} etc.). How does this work? Ptr itself cannot be a normal data type, since without knowing the type of the referenced data the type clearly cannot be used for memory operations. The answer is that Ptr (or other parametric types like Array) is a different kind of type called a UnionAll type. Such a type expresses the iterated union of types for all values of some parameter.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"UnionAll types are usually written using the keyword where. For example Ptr could be more accurately written as Ptr{T} where T, meaning all values whose type is Ptr{T} for some value of T. In this context, the parameter T is also often called a \"type variable\" since it is like a variable that ranges over types. Each where introduces a single type variable, so these expressions are nested for types with multiple parameters, for example Array{T,N} where N where T.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The type application syntax A{B,C} requires A to be a UnionAll type, and first substitutes B for the outermost type variable in A. The result is expected to be another UnionAll type, into which C is then substituted. So A{B,C} is equivalent to A{B}{C}. This explains why it is possible to partially instantiate a type, as in Array{Float64}: the first parameter value has been fixed, but the second still ranges over all possible values. Using explicit where syntax, any subset of parameters can be fixed. For example, the type of all 1-dimensional arrays can be written as Array{T,1} where T.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Type variables can be restricted with subtype relations. Array{T} where T<:Integer refers to all arrays whose element type is some kind of Integer. The syntax Array{<:Integer} is a convenient shorthand for Array{T} where T<:Integer. Type variables can have both lower and upper bounds. Array{T} where Int<:T<:Number refers to all arrays of Numbers that are able to contain Ints (since T must be at least as big as Int). The syntax where T>:Int also works to specify only the lower bound of a type variable, and Array{>:Int} is equivalent to Array{T} where T>:Int.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Since where expressions nest, type variable bounds can refer to outer type variables. For example Tuple{T,Array{S}} where S<:AbstractArray{T} where T<:Real refers to 2-tuples whose first element is some Real, and whose second element is an Array of any kind of array whose element type contains the type of the first tuple element.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The where keyword itself can be nested inside a more complex declaration. For example, consider the two types created by the following declarations:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> const T1 = Array{Array{T,1} where T, 1}\nArray{Array{T,1} where T,1}\n\njulia> const T2 = Array{Array{T,1}, 1} where T\nArray{Array{T,1},1} where T","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Type T1 defines a 1-dimensional array of 1-dimensional arrays; each of the inner arrays consists of objects of the same type, but this type may vary from one inner array to the next. On the other hand, type T2 defines a 1-dimensional array of 1-dimensional arrays all of whose inner arrays must have the same type.  Note that T2 is an abstract type, e.g., Array{Array{Int,1},1} <: T2, whereas T1 is a concrete type. As a consequence, T1 can be constructed with a zero-argument constructor a=T1() but T2 cannot.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There is a convenient syntax for naming such types, similar to the short form of function definition syntax:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Vector{T} = Array{T,1}","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This is equivalent to const Vector = Array{T,1} where T. Writing Vector{Float64} is equivalent to writing Array{Float64,1}, and the umbrella type Vector has as instances all Array objects where the second parameter – the number of array dimensions – is 1, regardless of what the element type is. In languages where parametric types must always be specified in full, this is not especially helpful, but in Julia, this allows one to write just Vector for the abstract type including all one-dimensional dense arrays of any element type.","category":"page"},{"location":"manual/types.html#Type-Aliases-1","page":"Types","title":"Type Aliases","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Sometimes it is convenient to introduce a new name for an already expressible type. This can be done with a simple assignment statement. For example, UInt is aliased to either UInt32 or UInt64 as is appropriate for the size of pointers on the system:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"# 32-bit system:\njulia> UInt\nUInt32\n\n# 64-bit system:\njulia> UInt\nUInt64","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This is accomplished via the following code in base/boot.jl:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"if Int === Int64\n    const UInt = UInt64\nelse\n    const UInt = UInt32\nend","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Of course, this depends on what Int is aliased to – but that is predefined to be the correct type – either Int32 or Int64.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"(Note that unlike Int, Float does not exist as a type alias for a specific sized AbstractFloat. Unlike with integer registers, where the size of Int reflects the size of a native pointer on that machine, the floating point register sizes are specified by the IEEE-754 standard.)","category":"page"},{"location":"manual/types.html#Operations-on-Types-1","page":"Types","title":"Operations on Types","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Since types in Julia are themselves objects, ordinary functions can operate on them. Some functions that are particularly useful for working with or exploring types have already been introduced, such as the <: operator, which indicates whether its left hand operand is a subtype of its right hand operand.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The isa function tests if an object is of a given type and returns true or false:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> isa(1, Int)\ntrue\n\njulia> isa(1, AbstractFloat)\nfalse","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The typeof function, already used throughout the manual in examples, returns the type of its argument. Since, as noted above, types are objects, they also have types, and we can ask what their types are:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> typeof(Rational{Int})\nDataType\n\njulia> typeof(Union{Real,String})\nUnion","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"What if we repeat the process? What is the type of a type of a type? As it happens, types are all composite values and thus all have a type of DataType:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> typeof(DataType)\nDataType\n\njulia> typeof(Union)\nDataType","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"DataType is its own type.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Another operation that applies to some types is supertype, which reveals a type's supertype. Only declared types (DataType) have unambiguous supertypes:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> supertype(Float64)\nAbstractFloat\n\njulia> supertype(Number)\nAny\n\njulia> supertype(AbstractString)\nAny\n\njulia> supertype(Any)\nAny","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"If you apply supertype to other type objects (or non-type objects), a MethodError is raised:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> supertype(Union{Float64,Int64})\nERROR: MethodError: no method matching supertype(::Type{Union{Float64, Int64}})\nClosest candidates are:\n  supertype(!Matched::DataType) at operators.jl:42\n  supertype(!Matched::UnionAll) at operators.jl:47","category":"page"},{"location":"manual/types.html#man-custom-pretty-printing-1","page":"Types","title":"Custom pretty-printing","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Often, one wants to customize how instances of a type are displayed.  This is accomplished by overloading the show function.  For example, suppose we define a type to represent complex numbers in polar form:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct Polar{T<:Real} <: Number\n           r::T\n           Θ::T\n       end\n\njulia> Polar(r::Real,Θ::Real) = Polar(promote(r,Θ)...)\nPolar","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Here, we've added a custom constructor function so that it can take arguments of different Real types and promote them to a common type (see Constructors and Conversion and Promotion). (Of course, we would have to define lots of other methods, too, to make it act like a Number, e.g. +, *, one, zero, promotion rules and so on.) By default, instances of this type display rather simply, with information about the type name and the field values, as e.g. Polar{Float64}(3.0,4.0).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"If we want it to display instead as 3.0 * exp(4.0im), we would define the following method to print the object to a given output object io (representing a file, terminal, buffer, etcetera; see Networking and Streams):","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Base.show(io::IO, z::Polar) = print(io, z.r, \" * exp(\", z.Θ, \"im)\")","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"More fine-grained control over display of Polar objects is possible. In particular, sometimes one wants both a verbose multi-line printing format, used for displaying a single object in the REPL and other interactive environments, and also a more compact single-line format used for print or for displaying the object as part of another object (e.g. in an array). Although by default the show(io, z) function is called in both cases, you can define a different multi-line format for displaying an object by overloading a three-argument form of show that takes the text/plain MIME type as its second argument (see Multimedia I/O), for example:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Base.show(io::IO, ::MIME\"text/plain\", z::Polar{T}) where{T} =\n           print(io, \"Polar{$T} complex number:\\n   \", z)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"(Note that print(..., z) here will call the 2-argument show(io, z) method.) This results in:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Polar(3, 4.0)\nPolar{Float64} complex number:\n   3.0 * exp(4.0im)\n\njulia> [Polar(3, 4.0), Polar(4.0,5.3)]\n2-element Array{Polar{Float64},1}:\n 3.0 * exp(4.0im)\n 4.0 * exp(5.3im)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"where the single-line show(io, z) form is still used for an array of Polar values.   Technically, the REPL calls display(z) to display the result of executing a line, which defaults to show(stdout, MIME(\"text/plain\"), z), which in turn defaults to show(stdout, z), but you should not define new display methods unless you are defining a new multimedia display handler (see Multimedia I/O).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Moreover, you can also define show methods for other MIME types in order to enable richer display (HTML, images, etcetera) of objects in environments that support this (e.g. IJulia).   For example, we can define formatted HTML display of Polar objects, with superscripts and italics, via:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> Base.show(io::IO, ::MIME\"text/html\", z::Polar{T}) where {T} =\n           println(io, \"<code>Polar{$T}</code> complex number: \",\n                   z.r, \" <i>e</i><sup>\", z.Θ, \" <i>i</i></sup>\")","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"A Polar object will then display automatically using HTML in an environment that supports HTML display, but you can call show manually to get HTML output if you want:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> show(stdout, \"text/html\", Polar(3.0,4.0))\n<code>Polar{Float64}</code> complex number: 3.0 <i>e</i><sup>4.0 <i>i</i></sup>","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"<p>An HTML renderer would display this as: <code>Polar{Float64}</code> complex number: 3.0 <i>e</i><sup>4.0 <i>i</i></sup></p>","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"As a rule of thumb, the single-line show method should print a valid Julia expression for creating the shown object.  When this show method contains infix operators, such as the multiplication operator (*) in our single-line show method for Polar above, it may not parse correctly when printed as part of another object.  To see this, consider the expression object (see Program representation) which takes the square of a specific instance of our Polar type:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> a = Polar(3, 4.0)\nPolar{Float64} complex number:\n   3.0 * exp(4.0im)\n\njulia> print(:($a^2))\n3.0 * exp(4.0im) ^ 2","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Because the operator ^ has higher precedence than * (see Operator Precedence and Associativity), this output does not faithfully represent the expression a ^ 2 which should be equal to (3.0 * exp(4.0im)) ^ 2.  To solve this issue, we must make a custom method for Base.show_unquoted(io::IO, z::Polar, indent::Int, precedence::Int), which is called internally by the expression object when printing:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> function Base.show_unquoted(io::IO, z::Polar, ::Int, precedence::Int)\n           if Base.operator_precedence(:*) <= precedence\n               print(io, \"(\")\n               show(io, z)\n               print(io, \")\")\n           else\n               show(io, z)\n           end\n       end\n\njulia> :($a^2)\n:((3.0 * exp(4.0im)) ^ 2)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"The method defined above adds parentheses around the call to show when the precedence of the calling operator is higher than or equal to the precedence of multiplication.  This check allows expressions which parse correctly without the parentheses (such as :($a + 2) and :($a == 2)) to omit them when printing:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> :($a + 2)\n:(3.0 * exp(4.0im) + 2)\n\njulia> :($a == 2)\n:(3.0 * exp(4.0im) == 2)","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In some cases, it is useful to adjust the behavior of show methods depending on the context. This can be achieved via the IOContext type, which allows passing contextual properties together with a wrapped IO stream. For example, we can build a shorter representation in our show method when the :compact property is set to true, falling back to the long representation if the property is false or absent:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> function Base.show(io::IO, z::Polar)\n           if get(io, :compact, false)\n               print(io, z.r, \"ℯ\", z.Θ, \"im\")\n           else\n               print(io, z.r, \" * exp(\", z.Θ, \"im)\")\n           end\n       end","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"This new compact representation will be used when the passed IO stream is an IOContext object with the :compact property set. In particular, this is the case when printing arrays with multiple columns (where horizontal space is limited):","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> show(IOContext(stdout, :compact=>true), Polar(3, 4.0))\n3.0ℯ4.0im\n\njulia> [Polar(3, 4.0) Polar(4.0,5.3)]\n1×2 Array{Polar{Float64},2}:\n 3.0ℯ4.0im  4.0ℯ5.3im","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"See the IOContext documentation for a list of common properties which can be used to adjust printing.","category":"page"},{"location":"manual/types.html#\"Value-types\"-1","page":"Types","title":"\"Value types\"","text":"","category":"section"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"In Julia, you can't dispatch on a value such as true or false. However, you can dispatch on parametric types, and Julia allows you to include \"plain bits\" values (Types, Symbols, Integers, floating-point numbers, tuples, etc.) as type parameters.  A common example is the dimensionality parameter in Array{T,N}, where T is a type (e.g., Float64) but N is just an Int.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"You can create your own custom types that take values as parameters, and use them to control dispatch of custom types. By way of illustration of this idea, let's introduce a parametric type, Val{x}, and a constructor Val(x) = Val{x}(), which serves as a customary way to exploit this technique for cases where you don't need a more elaborate hierarchy.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"Val is defined as:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> struct Val{x}\n       end\n\njulia> Val(x) = Val{x}()\nVal","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"There is no more to the implementation of Val than this.  Some functions in Julia's standard library accept Val instances as arguments, and you can also use it to write your own functions.  For example:","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"julia> firstlast(::Val{true}) = \"First\"\nfirstlast (generic function with 1 method)\n\njulia> firstlast(::Val{false}) = \"Last\"\nfirstlast (generic function with 2 methods)\n\njulia> firstlast(Val(true))\n\"First\"\n\njulia> firstlast(Val(false))\n\"Last\"","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"For consistency across Julia, the call site should always pass a Valinstance rather than using a type, i.e., use foo(Val(:bar)) rather than foo(Val{:bar}).","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"It's worth noting that it's extremely easy to mis-use parametric \"value\" types, including Val; in unfavorable cases, you can easily end up making the performance of your code much worse.  In particular, you would never want to write actual code as illustrated above.  For more information about the proper (and improper) uses of Val, please read the more extensive discussion in the performance tips.","category":"page"},{"location":"manual/types.html#","page":"Types","title":"Types","text":"[1]: \"Small\" is defined by the MAX_UNION_SPLITTING constant, which is currently set to 4.","category":"page"},{"location":"manual/methods.html#Methods-1","page":"Methods","title":"Methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Recall from Functions that a function is an object that maps a tuple of arguments to a return value, or throws an exception if no appropriate value can be returned. It is common for the same conceptual function or operation to be implemented quite differently for different types of arguments: adding two integers is very different from adding two floating-point numbers, both of which are distinct from adding an integer to a floating-point number. Despite their implementation differences, these operations all fall under the general concept of \"addition\". Accordingly, in Julia, these behaviors all belong to a single object: the + function.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"To facilitate using many different implementations of the same concept smoothly, functions need not be defined all at once, but can rather be defined piecewise by providing specific behaviors for certain combinations of argument types and counts. A definition of one possible behavior for a function is called a method. Thus far, we have presented only examples of functions defined with a single method, applicable to all types of arguments. However, the signatures of method definitions can be annotated to indicate the types of arguments in addition to their number, and more than a single method definition may be provided. When a function is applied to a particular tuple of arguments, the most specific method applicable to those arguments is applied. Thus, the overall behavior of a function is a patchwork of the behaviors of its various method definitions. If the patchwork is well designed, even though the implementations of the methods may be quite different, the outward behavior of the function will appear seamless and consistent.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The choice of which method to execute when a function is applied is called dispatch. Julia allows the dispatch process to choose which of a function's methods to call based on the number of arguments given, and on the types of all of the function's arguments. This is different than traditional object-oriented languages, where dispatch occurs based only on the first argument, which often has a special argument syntax, and is sometimes implied rather than explicitly written as an argument. [1] Using all of a function's arguments to choose which method should be invoked, rather than just the first, is known as multiple dispatch. Multiple dispatch is particularly useful for mathematical code, where it makes little sense to artificially deem the operations to \"belong\" to one argument more than any of the others: does the addition operation in x + y belong to x any more than it does to y? The implementation of a mathematical operator generally depends on the types of all of its arguments. Even beyond mathematical operations, however, multiple dispatch ends up being a powerful and convenient paradigm for structuring and organizing programs.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"[1]: In C++ or Java, for example, in a method call like obj.meth(arg1,arg2), the object obj \"receives\" the method call and is implicitly passed to the method via the this keyword, rather than as an explicit method argument. When the current this object is the receiver of a method call, it can be omitted altogether, writing just meth(arg1,arg2), with this implied as the receiving object.","category":"page"},{"location":"manual/methods.html#Defining-Methods-1","page":"Methods","title":"Defining Methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Until now, we have, in our examples, defined only functions with a single method having unconstrained argument types. Such functions behave just like they would in traditional dynamically typed languages. Nevertheless, we have used multiple dispatch and methods almost continually without being aware of it: all of Julia's standard functions and operators, like the aforementioned + function, have many methods defining their behavior over various possible combinations of argument type and count.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When defining a function, one can optionally constrain the types of parameters it is applicable to, using the :: type-assertion operator, introduced in the section on Composite Types:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(x::Float64, y::Float64) = 2x + y\nf (generic function with 1 method)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This function definition applies only to calls where x and y are both values of type Float64:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(2.0, 3.0)\n7.0","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Applying it to any other types of arguments will result in a MethodError:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(2.0, 3)\nERROR: MethodError: no method matching f(::Float64, ::Int64)\nClosest candidates are:\n  f(::Float64, !Matched::Float64) at none:1\n\njulia> f(Float32(2.0), 3.0)\nERROR: MethodError: no method matching f(::Float32, ::Float64)\nClosest candidates are:\n  f(!Matched::Float64, ::Float64) at none:1\n\njulia> f(2.0, \"3.0\")\nERROR: MethodError: no method matching f(::Float64, ::String)\nClosest candidates are:\n  f(::Float64, !Matched::Float64) at none:1\n\njulia> f(\"2.0\", \"3.0\")\nERROR: MethodError: no method matching f(::String, ::String)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"As you can see, the arguments must be precisely of type Float64. Other numeric types, such as integers or 32-bit floating-point values, are not automatically converted to 64-bit floating-point, nor are strings parsed as numbers. Because Float64 is a concrete type and concrete types cannot be subclassed in Julia, such a definition can only be applied to arguments that are exactly of type Float64. It may often be useful, however, to write more general methods where the declared parameter types are abstract:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(x::Number, y::Number) = 2x - y\nf (generic function with 2 methods)\n\njulia> f(2.0, 3)\n1.0","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This method definition applies to any pair of arguments that are instances of Number. They need not be of the same type, so long as they are each numeric values. The problem of handling disparate numeric types is delegated to the arithmetic operations in the expression 2x - y.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"To define a function with multiple methods, one simply defines the function multiple times, with different numbers and types of arguments. The first method definition for a function creates the function object, and subsequent method definitions add new methods to the existing function object. The most specific method definition matching the number and types of the arguments will be executed when the function is applied. Thus, the two method definitions above, taken together, define the behavior for f over all pairs of instances of the abstract type Number – but with a different behavior specific to pairs of Float64 values. If one of the arguments is a 64-bit float but the other one is not, then the f(Float64,Float64) method cannot be called and the more general f(Number,Number) method must be used:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(2.0, 3.0)\n7.0\n\njulia> f(2, 3.0)\n1.0\n\njulia> f(2.0, 3)\n1.0\n\njulia> f(2, 3)\n1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The 2x + y definition is only used in the first case, while the 2x - y definition is used in the others. No automatic casting or conversion of function arguments is ever performed: all conversion in Julia is non-magical and completely explicit. Conversion and Promotion, however, shows how clever application of sufficiently advanced technology can be indistinguishable from magic. [Clarke61]","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For non-numeric values, and for fewer or more than two arguments, the function f remains undefined, and applying it will still result in a MethodError:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(\"foo\", 3)\nERROR: MethodError: no method matching f(::String, ::Int64)\nClosest candidates are:\n  f(!Matched::Number, ::Number) at none:1\n\njulia> f()\nERROR: MethodError: no method matching f()\nClosest candidates are:\n  f(!Matched::Float64, !Matched::Float64) at none:1\n  f(!Matched::Number, !Matched::Number) at none:1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"You can easily see which methods exist for a function by entering the function object itself in an interactive session:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f\nf (generic function with 2 methods)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This output tells us that f is a function object with two methods. To find out what the signatures of those methods are, use the methods function:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> methods(f)\n# 2 methods for generic function \"f\":\n[1] f(x::Float64, y::Float64) in Main at none:1\n[2] f(x::Number, y::Number) in Main at none:1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"which shows that f has two methods, one taking two Float64 arguments and one taking arguments of type Number. It also indicates the file and line number where the methods were defined: because these methods were defined at the REPL, we get the apparent line number none:1.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"In the absence of a type declaration with ::, the type of a method parameter is Any by default, meaning that it is unconstrained since all values in Julia are instances of the abstract type Any. Thus, we can define a catch-all method for f like so:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(x,y) = println(\"Whoa there, Nelly.\")\nf (generic function with 3 methods)\n\njulia> f(\"foo\", 1)\nWhoa there, Nelly.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This catch-all is less specific than any other possible method definition for a pair of parameter values, so it will only be called on pairs of arguments to which no other method definition applies.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Although it seems a simple concept, multiple dispatch on the types of values is perhaps the single most powerful and central feature of the Julia language. Core operations typically have dozens of methods:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> methods(+)\n# 180 methods for generic function \"+\":\n[1] +(x::Bool, z::Complex{Bool}) in Base at complex.jl:227\n[2] +(x::Bool, y::Bool) in Base at bool.jl:89\n[3] +(x::Bool) in Base at bool.jl:86\n[4] +(x::Bool, y::T) where T<:AbstractFloat in Base at bool.jl:96\n[5] +(x::Bool, z::Complex) in Base at complex.jl:234\n[6] +(a::Float16, b::Float16) in Base at float.jl:373\n[7] +(x::Float32, y::Float32) in Base at float.jl:375\n[8] +(x::Float64, y::Float64) in Base at float.jl:376\n[9] +(z::Complex{Bool}, x::Bool) in Base at complex.jl:228\n[10] +(z::Complex{Bool}, x::Real) in Base at complex.jl:242\n[11] +(x::Char, y::Integer) in Base at char.jl:40\n[12] +(c::BigInt, x::BigFloat) in Base.MPFR at mpfr.jl:307\n[13] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt, e::BigInt) in Base.GMP at gmp.jl:392\n[14] +(a::BigInt, b::BigInt, c::BigInt, d::BigInt) in Base.GMP at gmp.jl:391\n[15] +(a::BigInt, b::BigInt, c::BigInt) in Base.GMP at gmp.jl:390\n[16] +(x::BigInt, y::BigInt) in Base.GMP at gmp.jl:361\n[17] +(x::BigInt, c::Union{UInt16, UInt32, UInt64, UInt8}) in Base.GMP at gmp.jl:398\n...\n[180] +(a, b, c, xs...) in Base at operators.jl:424","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Multiple dispatch together with the flexible parametric type system give Julia its ability to abstractly express high-level algorithms decoupled from implementation details, yet generate efficient, specialized code to handle each case at run time.","category":"page"},{"location":"manual/methods.html#man-ambiguities-1","page":"Methods","title":"Method Ambiguities","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"It is possible to define a set of function methods such that there is no unique most specific method applicable to some combinations of arguments:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> g(x::Float64, y) = 2x + y\ng (generic function with 1 method)\n\njulia> g(x, y::Float64) = x + 2y\ng (generic function with 2 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\nERROR: MethodError: g(::Float64, ::Float64) is ambiguous. Candidates:\n  g(x, y::Float64) in Main at none:1\n  g(x::Float64, y) in Main at none:1\nPossible fix, define\n  g(::Float64, ::Float64)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Here the call g(2.0, 3.0) could be handled by either the g(Float64, Any) or the g(Any, Float64) method, and neither is more specific than the other. In such cases, Julia raises a MethodError rather than arbitrarily picking a method. You can avoid method ambiguities by specifying an appropriate method for the intersection case:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> g(x::Float64, y::Float64) = 2x + 2y\ng (generic function with 3 methods)\n\njulia> g(2.0, 3)\n7.0\n\njulia> g(2, 3.0)\n8.0\n\njulia> g(2.0, 3.0)\n10.0","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"It is recommended that the disambiguating method be defined first, since otherwise the ambiguity exists, if transiently, until the more specific method is defined.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"In more complex cases, resolving method ambiguities involves a certain element of design; this topic is explored further below.","category":"page"},{"location":"manual/methods.html#Parametric-Methods-1","page":"Methods","title":"Parametric Methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Method definitions can optionally have type parameters qualifying the signature:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> same_type(x::T, y::T) where {T} = true\nsame_type (generic function with 1 method)\n\njulia> same_type(x,y) = false\nsame_type (generic function with 2 methods)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The first method applies whenever both arguments are of the same concrete type, regardless of what type that is, while the second method acts as a catch-all, covering all other cases. Thus, overall, this defines a boolean function that checks whether its two arguments are of the same type:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> same_type(1, 2)\ntrue\n\njulia> same_type(1, 2.0)\nfalse\n\njulia> same_type(1.0, 2.0)\ntrue\n\njulia> same_type(\"foo\", 2.0)\nfalse\n\njulia> same_type(\"foo\", \"bar\")\ntrue\n\njulia> same_type(Int32(1), Int64(2))\nfalse","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Such definitions correspond to methods whose type signatures are UnionAll types (see UnionAll Types).","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This kind of definition of function behavior by dispatch is quite common – idiomatic, even – in Julia. Method type parameters are not restricted to being used as the types of arguments: they can be used anywhere a value would be in the signature of the function or body of the function. Here's an example where the method type parameter T is used as the type parameter to the parametric type Vector{T} in the method signature:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> myappend(v::Vector{T}, x::T) where {T} = [v..., x]\nmyappend (generic function with 1 method)\n\njulia> myappend([1,2,3],4)\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> myappend([1,2,3],2.5)\nERROR: MethodError: no method matching myappend(::Array{Int64,1}, ::Float64)\nClosest candidates are:\n  myappend(::Array{T,1}, !Matched::T) where T at none:1\n\njulia> myappend([1.0,2.0,3.0],4.0)\n4-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n 4.0\n\njulia> myappend([1.0,2.0,3.0],4)\nERROR: MethodError: no method matching myappend(::Array{Float64,1}, ::Int64)\nClosest candidates are:\n  myappend(::Array{T,1}, !Matched::T) where T at none:1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"As you can see, the type of the appended element must match the element type of the vector it is appended to, or else a MethodError is raised. In the following example, the method type parameter T is used as the return value:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> mytypeof(x::T) where {T} = T\nmytypeof (generic function with 1 method)\n\njulia> mytypeof(1)\nInt64\n\njulia> mytypeof(1.0)\nFloat64","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Just as you can put subtype constraints on type parameters in type declarations (see Parametric Types), you can also constrain type parameters of methods:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> same_type_numeric(x::T, y::T) where {T<:Number} = true\nsame_type_numeric (generic function with 1 method)\n\njulia> same_type_numeric(x::Number, y::Number) = false\nsame_type_numeric (generic function with 2 methods)\n\njulia> same_type_numeric(1, 2)\ntrue\n\njulia> same_type_numeric(1, 2.0)\nfalse\n\njulia> same_type_numeric(1.0, 2.0)\ntrue\n\njulia> same_type_numeric(\"foo\", 2.0)\nERROR: MethodError: no method matching same_type_numeric(::String, ::Float64)\nClosest candidates are:\n  same_type_numeric(!Matched::T<:Number, ::T<:Number) where T<:Number at none:1\n  same_type_numeric(!Matched::Number, ::Number) at none:1\n\njulia> same_type_numeric(\"foo\", \"bar\")\nERROR: MethodError: no method matching same_type_numeric(::String, ::String)\n\njulia> same_type_numeric(Int32(1), Int64(2))\nfalse","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The same_type_numeric function behaves much like the same_type function defined above, but is only defined for pairs of numbers.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Parametric methods allow the same syntax as where expressions used to write types (see UnionAll Types). If there is only a single parameter, the enclosing curly braces (in where {T}) can be omitted, but are often preferred for clarity. Multiple parameters can be separated with commas, e.g. where {T, S<:Real}, or written using nested where, e.g. where S<:Real where T.","category":"page"},{"location":"manual/methods.html#Redefining-Methods-1","page":"Methods","title":"Redefining Methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When redefining a method or adding new methods, it is important to realize that these changes don't take effect immediately. This is key to Julia's ability to statically infer and compile code to run fast, without the usual JIT tricks and overhead. Indeed, any new method definition won't be visible to the current runtime environment, including Tasks and Threads (and any previously defined @generated functions). Let's start with an example to see what this means:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> function tryeval()\n           @eval newfun() = 1\n           newfun()\n       end\ntryeval (generic function with 1 method)\n\njulia> tryeval()\nERROR: MethodError: no method matching newfun()\nThe applicable method may be too new: running in world age xxxx1, while current world is xxxx2.\nClosest candidates are:\n  newfun() at none:1 (method too new to be called from this world context.)\n in tryeval() at none:1\n ...\n\njulia> newfun()\n1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"In this example, observe that the new definition for newfun has been created, but can't be immediately called. The new global is immediately visible to the tryeval function, so you could write return newfun (without parentheses). But neither you, nor any of your callers, nor the functions they call, or etc. can call this new method definition!","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"But there's an exception: future calls to newfun from the REPL work as expected, being able to both see and call the new definition of newfun.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"However, future calls to tryeval will continue to see the definition of newfun as it was at the previous statement at the REPL, and thus before that call to tryeval.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"You may want to try this for yourself to see how it works.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The implementation of this behavior is a \"world age counter\". This monotonically increasing value tracks each method definition operation. This allows describing \"the set of method definitions visible to a given runtime environment\" as a single number, or \"world age\". It also allows comparing the methods available in two worlds just by comparing their ordinal value. In the example above, we see that the \"current world\" (in which the method newfun exists), is one greater than the task-local \"runtime world\" that was fixed when the execution of tryeval started.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Sometimes it is necessary to get around this (for example, if you are implementing the above REPL). Fortunately, there is an easy solution: call the function using Base.invokelatest:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> function tryeval2()\n           @eval newfun2() = 2\n           Base.invokelatest(newfun2)\n       end\ntryeval2 (generic function with 1 method)\n\njulia> tryeval2()\n2","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Finally, let's take a look at some more complex examples where this rule comes into play. Define a function f(x), which initially has one method:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(x) = \"original definition\"\nf (generic function with 1 method)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Start some other operations that use f(x):","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> g(x) = f(x)\ng (generic function with 1 method)\n\njulia> t = @async f(wait()); yield();","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Now we add some new methods to f(x):","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(x::Int) = \"definition for Int\"\nf (generic function with 2 methods)\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\"\nf (generic function with 3 methods)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Compare how these results differ:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> fetch(schedule(t, 1))\n\"original definition\"\n\njulia> t = @async f(wait()); yield();\n\njulia> fetch(schedule(t, 1))\n\"definition for Int\"","category":"page"},{"location":"manual/methods.html#Design-Patterns-with-Parametric-Methods-1","page":"Methods","title":"Design Patterns with Parametric Methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"While complex dispatch logic is not required for performance or usability, sometimes it can be the best way to express some algorithm. Here are a few common design patterns that come up sometimes when using dispatch in this way.","category":"page"},{"location":"manual/methods.html#Extracting-the-type-parameter-from-a-super-type-1","page":"Methods","title":"Extracting the type parameter from a super-type","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Here is the correct code template for returning the element-type T of any arbitrary subtype of AbstractArray:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"abstract type AbstractArray{T, N} end\neltype(::Type{<:AbstractArray{T}}) where {T} = T","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"using so-called triangular dispatch.  Note that if T is a UnionAll type, as e.g. eltype(Array{T} where T <: Integer), then Any is returned (as does the the version of eltype in Base).","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Another way, which used to be the only correct way before the advent of triangular dispatch in Julia v0.6, is:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"abstract type AbstractArray{T, N} end\neltype(::Type{AbstractArray}) = Any\neltype(::Type{AbstractArray{T}}) where {T} = T\neltype(::Type{AbstractArray{T, N}}) where {T, N} = T\neltype(::Type{A}) where {A<:AbstractArray} = eltype(supertype(A))","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Another possibility is the following, which could useful to adapt to cases where the parameter T would need to be matched more narrowly:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"eltype(::Type{AbstractArray{T, N} where {T<:S, N<:M}}) where {M, S} = Any\neltype(::Type{AbstractArray{T, N} where {T<:S}}) where {N, S} = Any\neltype(::Type{AbstractArray{T, N} where {N<:M}}) where {M, T} = T\neltype(::Type{AbstractArray{T, N}}) where {T, N} = T\neltype(::Type{A}) where {A <: AbstractArray} = eltype(supertype(A))","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"One common mistake is to try and get the element-type by using introspection:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"eltype_wrong(::Type{A}) where {A<:AbstractArray} = A.parameters[1]","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"However, it is not hard to construct cases where this will fail:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"struct BitVector <: AbstractArray{Bool, 1}; end","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Here we have created a type BitVector which has no parameters, but where the element-type is still fully specified, with T equal to Bool!","category":"page"},{"location":"manual/methods.html#Building-a-similar-type-with-a-different-type-parameter-1","page":"Methods","title":"Building a similar type with a different type parameter","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When building generic code, there is often a need for constructing a similar object with some change made to the layout of the type, also necessitating a change of the type parameters. For instance, you might have some sort of abstract array with an arbitrary element type and want to write your computation on it with a specific element type. We must implement a method for each AbstractArray{T} subtype that describes how to compute this type transform. There is no general transform of one subtype into another subtype with a different parameter. (Quick review: do you see why this is?)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The subtypes of AbstractArray typically implement two methods to achieve this: A method to convert the input array to a subtype of a specific AbstractArray{T, N} abstract type; and a method to make a new uninitialized array with a specific element type. Sample implementations of these can be found in Julia Base. Here is a basic example usage of them, guaranteeing that input and output are of the same type:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"input = convert(AbstractArray{Eltype}, input)\noutput = similar(input, Eltype)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"As an extension of this, in cases where the algorithm needs a copy of the input array, convert is insufficient as the return value may alias the original input. Combining similar (to make the output array) and copyto! (to fill it with the input data) is a generic way to express the requirement for a mutable copy of the input argument:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"copy_with_eltype(input, Eltype) = copyto!(similar(input, Eltype), input)","category":"page"},{"location":"manual/methods.html#Iterated-dispatch-1","page":"Methods","title":"Iterated dispatch","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"In order to dispatch a multi-level parametric argument list, often it is best to separate each level of dispatch into distinct functions. This may sound similar in approach to single-dispatch, but as we shall see below, it is still more flexible.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For example, trying to dispatch on the element-type of an array will often run into ambiguous situations. Instead, commonly code will dispatch first on the container type, then recurse down to a more specific method based on eltype. In most cases, the algorithms lend themselves conveniently to this hierarchical approach, while in other cases, this rigor must be resolved manually. This dispatching branching can be observed, for example, in the logic to sum two matrices:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"# First dispatch selects the map algorithm for element-wise summation.\n+(a::Matrix, b::Matrix) = map(+, a, b)\n# Then dispatch handles each element and selects the appropriate\n# common element type for the computation.\n+(a, b) = +(promote(a, b)...)\n# Once the elements have the same type, they can be added.\n# For example, via primitive operations exposed by the processor.\n+(a::Float64, b::Float64) = Core.add(a, b)","category":"page"},{"location":"manual/methods.html#Trait-based-dispatch-1","page":"Methods","title":"Trait-based dispatch","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"A natural extension to the iterated dispatch above is to add a layer to method selection that allows to dispatch on sets of types which are independent from the sets defined by the type hierarchy. We could construct such a set by writing out a Union of the types in question, but then this set would not be extensible as Union-types cannot be altered after creation. However, such an extensible set can be programmed with a design pattern often referred to as a \"Holy-trait\".","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This pattern is implemented by defining a generic function which computes a different singleton value (or type) for each trait-set to which the function arguments may belong to.  If this function is pure there is no impact on performance compared to normal dispatch.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The example in the previous section glossed over the implementation details of map and promote, which both operate in terms of these traits. When iterating over a matrix, such as in the implementation of map, one important question is what order to use to traverse the data. When AbstractArray subtypes implement the Base.IndexStyle trait, other functions such as map can dispatch on this information to pick the best algorithm (see Abstract Array Interface). This means that each subtype does not need to implement a custom version of map, since the generic definitions + trait classes will enable the system to select the fastest version. Here a toy implementation of map illustrating the trait-based dispatch:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"map(f, a::AbstractArray, b::AbstractArray) = map(Base.IndexStyle(a, b), f, a, b)\n# generic implementation:\nmap(::Base.IndexCartesian, f, a::AbstractArray, b::AbstractArray) = ...\n# linear-indexing implementation (faster)\nmap(::Base.IndexLinear, f, a::AbstractArray, b::AbstractArray) = ...","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This trait-based approach is also present in the promote mechanism employed by the scalar +. It uses promote_type, which returns the optimal common type to compute the operation given the two types of the operands. This makes it possible to reduce the problem of implementing every function for every pair of possible type arguments, to the much smaller problem of implementing a conversion operation from each type to a common type, plus a table of preferred pair-wise promotion rules.","category":"page"},{"location":"manual/methods.html#Output-type-computation-1","page":"Methods","title":"Output-type computation","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The discussion of trait-based promotion provides a transition into our next design pattern: computing the output element type for a matrix operation.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For implementing primitive operations, such as addition, we use the promote_type function to compute the desired output type. (As before, we saw this at work in the promote call in the call to +).","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For more complex functions on matrices, it may be necessary to compute the expected return type for a more complex sequence of operations. This is often performed by the following steps:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Write a small function op that expresses the set of operations performed by the kernel of the algorithm.\nCompute the element type R of the result matrix as promote_op(op, argument_types...), where argument_types is computed from eltype applied to each input array.\nBuild the output matrix as similar(R, dims), where dims are the desired dimensions of the output array.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For a more specific example, a generic square-matrix multiply pseudo-code might look like:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"function matmul(a::AbstractMatrix, b::AbstractMatrix)\n    op = (ai, bi) -> ai * bi + ai * bi\n\n    ## this is insufficient because it assumes `one(eltype(a))` is constructable:\n    # R = typeof(op(one(eltype(a)), one(eltype(b))))\n\n    ## this fails because it assumes `a[1]` exists and is representative of all elements of the array\n    # R = typeof(op(a[1], b[1]))\n\n    ## this is incorrect because it assumes that `+` calls `promote_type`\n    ## but this is not true for some types, such as Bool:\n    # R = promote_type(ai, bi)\n\n    # this is wrong, since depending on the return value\n    # of type-inference is very brittle (as well as not being optimizable):\n    # R = Base.return_types(op, (eltype(a), eltype(b)))\n\n    ## but, finally, this works:\n    R = promote_op(op, eltype(a), eltype(b))\n    ## although sometimes it may give a larger type than desired\n    ## it will always give a correct type\n\n    output = similar(b, R, (size(a, 1), size(b, 2)))\n    if size(a, 2) > 0\n        for j in 1:size(b, 2)\n            for i in 1:size(a, 1)\n                ## here we don't use `ab = zero(R)`,\n                ## since `R` might be `Any` and `zero(Any)` is not defined\n                ## we also must declare `ab::R` to make the type of `ab` constant in the loop,\n                ## since it is possible that typeof(a * b) != typeof(a * b + a * b) == R\n                ab::R = a[i, 1] * b[1, j]\n                for k in 2:size(a, 2)\n                    ab += a[i, k] * b[k, j]\n                end\n                output[i, j] = ab\n            end\n        end\n    end\n    return output\nend","category":"page"},{"location":"manual/methods.html#Separate-convert-and-kernel-logic-1","page":"Methods","title":"Separate convert and kernel logic","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"One way to significantly cut down on compile-times and testing complexity is to isolate the logic for converting to the desired type and the computation. This lets the compiler specialize and inline the conversion logic independent from the rest of the body of the larger kernel.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This is a common pattern seen when converting from a larger class of types to the one specific argument type that is actually supported by the algorithm:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"complexfunction(arg::Int) = ...\ncomplexfunction(arg::Any) = complexfunction(convert(Int, arg))\n\nmatmul(a::T, b::T) = ...\nmatmul(a, b) = matmul(promote(a, b)...)","category":"page"},{"location":"manual/methods.html#Parametrically-constrained-Varargs-methods-1","page":"Methods","title":"Parametrically-constrained Varargs methods","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Function parameters can also be used to constrain the number of arguments that may be supplied to a \"varargs\" function (Varargs Functions).  The notation Vararg{T,N} is used to indicate such a constraint.  For example:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> bar(a,b,x::Vararg{Any,2}) = (a,b,x)\nbar (generic function with 1 method)\n\njulia> bar(1,2,3)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, !Matched::Any) at none:1\n\njulia> bar(1,2,3,4)\n(1, 2, (3, 4))\n\njulia> bar(1,2,3,4,5)\nERROR: MethodError: no method matching bar(::Int64, ::Int64, ::Int64, ::Int64, ::Int64)\nClosest candidates are:\n  bar(::Any, ::Any, ::Any, ::Any) at none:1","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"More usefully, it is possible to constrain varargs methods by a parameter. For example:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"function getindex(A::AbstractArray{T,N}, indices::Vararg{Number,N}) where {T,N}","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"would be called only when the number of indices matches the dimensionality of the array.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When only the type of supplied arguments needs to be constrained Vararg{T} can be equivalently written as T.... For instance f(x::Int...) = x is a shorthand for f(x::Vararg{Int}) = x.","category":"page"},{"location":"manual/methods.html#Note-on-Optional-and-keyword-Arguments-1","page":"Methods","title":"Note on Optional and keyword Arguments","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"As mentioned briefly in Functions, optional arguments are implemented as syntax for multiple method definitions. For example, this definition:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(a=1,b=2) = a+2b","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"translates to the following three methods:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(a,b) = a+2b\nf(a) = f(a,2)\nf() = f(1,2)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This means that calling f() is equivalent to calling f(1,2). In this case the result is 5, because f(1,2) invokes the first method of f above. However, this need not always be the case. If you define a fourth method that is more specialized for integers:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(a::Int,b::Int) = a-2b","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"then the result of both f() and f(1,2) is -3. In other words, optional arguments are tied to a function, not to any specific method of that function. It depends on the types of the optional arguments which method is invoked. When optional arguments are defined in terms of a global variable, the type of the optional argument may even change at run-time.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Keyword arguments behave quite differently from ordinary positional arguments. In particular, they do not participate in method dispatch. Methods are dispatched based only on positional arguments, with keyword arguments processed after the matching method is identified.","category":"page"},{"location":"manual/methods.html#Function-like-objects-1","page":"Methods","title":"Function-like objects","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Methods are associated with types, so it is possible to make any arbitrary Julia object \"callable\" by adding methods to its type. (Such \"callable\" objects are sometimes called \"functors.\")","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"For example, you can define a type that stores the coefficients of a polynomial, but behaves like a function evaluating the polynomial:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> struct Polynomial{R}\n           coeffs::Vector{R}\n       end\n\njulia> function (p::Polynomial)(x)\n           v = p.coeffs[end]\n           for i = (length(p.coeffs)-1):-1:1\n               v = v*x + p.coeffs[i]\n           end\n           return v\n       end\n\njulia> (p::Polynomial)() = p(5)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Notice that the function is specified by type instead of by name. As with normal functions there is a terse syntax form. In the function body, p will refer to the object that was called. A Polynomial can be used as follows:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"julia> p = Polynomial([1,10,100])\nPolynomial{Int64}([1, 10, 100])\n\njulia> p(3)\n931\n\njulia> p()\n2551","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This mechanism is also the key to how type constructors and closures (inner functions that refer to their surrounding environment) work in Julia.","category":"page"},{"location":"manual/methods.html#Empty-generic-functions-1","page":"Methods","title":"Empty generic functions","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Occasionally it is useful to introduce a generic function without yet adding methods. This can be used to separate interface definitions from implementations. It might also be done for the purpose of documentation or code readability. The syntax for this is an empty function block without a tuple of arguments:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"function emptyfunc\nend","category":"page"},{"location":"manual/methods.html#man-method-design-ambiguities-1","page":"Methods","title":"Method design and the avoidance of ambiguities","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Julia's method polymorphism is one of its most powerful features, yet exploiting this power can pose design challenges.  In particular, in more complex method hierarchies it is not uncommon for ambiguities to arise.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Above, it was pointed out that one can resolve ambiguities like","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x, y::Int) = 1\nf(x::Int, y) = 2","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"by defining a method","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::Int, y::Int) = 3","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This is often the right strategy; however, there are circumstances where following this advice blindly can be counterproductive. In particular, the more methods a generic function has, the more possibilities there are for ambiguities. When your method hierarchies get more complicated than this simple example, it can be worth your while to think carefully about alternative strategies.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Below we discuss particular challenges and some alternative ways to resolve such issues.","category":"page"},{"location":"manual/methods.html#Tuple-and-NTuple-arguments-1","page":"Methods","title":"Tuple and NTuple arguments","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Tuple (and NTuple) arguments present special challenges. For example,","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::NTuple{N,Int}) where {N} = 1\nf(x::NTuple{N,Float64}) where {N} = 2","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"are ambiguous because of the possibility that N == 0: there are no elements to determine whether the Int or Float64 variant should be called. To resolve the ambiguity, one approach is define a method for the empty tuple:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::Tuple{}) = 3","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Alternatively, for all methods but one you can insist that there is at least one element in the tuple:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::NTuple{N,Int}) where {N} = 1           # this is the fallback\nf(x::Tuple{Float64, Vararg{Float64}}) = 2   # this requires at least one Float64","category":"page"},{"location":"manual/methods.html#man-methods-orthogonalize-1","page":"Methods","title":"Orthogonalize your design","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When you might be tempted to dispatch on two or more arguments, consider whether a \"wrapper\" function might make for a simpler design. For example, instead of writing multiple variants:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::A, y::A) = ...\nf(x::A, y::B) = ...\nf(x::B, y::A) = ...\nf(x::B, y::B) = ...","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"you might consider defining","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::A, y::A) = ...\nf(x, y) = f(g(x), g(y))","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"where g converts the argument to type A. This is a very specific example of the more general principle of orthogonal design, in which separate concepts are assigned to separate methods. Here, g will most likely need a fallback definition","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"g(x::A) = x","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"A related strategy exploits promote to bring x and y to a common type:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::T, y::T) where {T} = ...\nf(x, y) = f(promote(x, y)...)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"One risk with this design is the possibility that if there is no suitable promotion method converting x and y to the same type, the second method will recurse on itself infinitely and trigger a stack overflow. The non-exported function Base.promote_noncircular can be used as an alternative; when promotion fails it will still throw an error, but one that fails faster with a more specific error message.","category":"page"},{"location":"manual/methods.html#Dispatch-on-one-argument-at-a-time-1","page":"Methods","title":"Dispatch on one argument at a time","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"If you need to dispatch on multiple arguments, and there are many fallbacks with too many combinations to make it practical to define all possible variants, then consider introducing a \"name cascade\" where (for example) you dispatch on the first argument and then call an internal method:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"f(x::A, y) = _fA(x, y)\nf(x::B, y) = _fB(x, y)","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Then the internal methods _fA and _fB can dispatch on y without concern about ambiguities with each other with respect to x.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Be aware that this strategy has at least one major disadvantage: in many cases, it is not possible for users to further customize the behavior of f by defining further specializations of your exported function f. Instead, they have to define specializations for your internal methods _fA and _fB, and this blurs the lines between exported and internal methods.","category":"page"},{"location":"manual/methods.html#Abstract-containers-and-element-types-1","page":"Methods","title":"Abstract containers and element types","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Where possible, try to avoid defining methods that dispatch on specific element types of abstract containers. For example,","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"-(A::AbstractArray{T}, b::Date) where {T<:Date}","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"generates ambiguities for anyone who defines a method","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"-(A::MyArrayType{T}, b::T) where {T}","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The best approach is to avoid defining either of these methods: instead, rely on a generic method -(A::AbstractArray, b) and make sure this method is implemented with generic calls (like similar and -) that do the right thing for each container type and element type separately. This is just a more complex variant of the advice to orthogonalize your methods.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"When this approach is not possible, it may be worth starting a discussion with other developers about resolving the ambiguity; just because one method was defined first does not necessarily mean that it can't be modified or eliminated.  As a last resort, one developer can define the \"band-aid\" method","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"-(A::MyArrayType{T}, b::Date) where {T<:Date} = ...","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"that resolves the ambiguity by brute force.","category":"page"},{"location":"manual/methods.html#Complex-method-\"cascades\"-with-default-arguments-1","page":"Methods","title":"Complex method \"cascades\" with default arguments","text":"","category":"section"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"If you are defining a method \"cascade\" that supplies defaults, be careful about dropping any arguments that correspond to potential defaults. For example, suppose you're writing a digital filtering algorithm and you have a method that handles the edges of the signal by applying padding:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"function myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel)  # now perform the \"real\" computation\nend","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"This will run afoul of a method that supplies default padding:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"myfilter(A, kernel) = myfilter(A, kernel, Replicate()) # replicate the edge by default","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"Together, these two methods generate an infinite recursion with A constantly growing bigger.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"The better design would be to define your call hierarchy like this:","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"struct NoPad end  # indicate that no padding is desired, or that it's already applied\n\nmyfilter(A, kernel) = myfilter(A, kernel, Replicate())  # default boundary conditions\n\nfunction myfilter(A, kernel, ::Replicate)\n    Apadded = replicate_edges(A, size(kernel))\n    myfilter(Apadded, kernel, NoPad())  # indicate the new boundary conditions\nend\n\n# other padding methods go here\n\nfunction myfilter(A, kernel, ::NoPad)\n    # Here's the \"real\" implementation of the core computation\nend","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"NoPad is supplied in the same argument position as any other kind of padding, so it keeps the dispatch hierarchy well organized and with reduced likelihood of ambiguities. Moreover, it extends the \"public\" myfilter interface: a user who wants to control the padding explicitly can call the NoPad variant directly.","category":"page"},{"location":"manual/methods.html#","page":"Methods","title":"Methods","text":"[Clarke61]: Arthur C. Clarke, Profiles of the Future (1961): Clarke's Third Law.","category":"page"},{"location":"manual/constructors.html#man-constructors-1","page":"Constructors","title":"Constructors","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Constructors [1] are functions that create new objects – specifically, instances of Composite Types. In Julia, type objects also serve as constructor functions: they create new instances of themselves when applied to an argument tuple as a function. This much was already mentioned briefly when composite types were introduced. For example:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct Foo\n           bar\n           baz\n       end\n\njulia> foo = Foo(1, 2)\nFoo(1, 2)\n\njulia> foo.bar\n1\n\njulia> foo.baz\n2","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"For many types, forming new objects by binding their field values together is all that is ever needed to create instances. However, in some cases more functionality is required when creating composite objects. Sometimes invariants must be enforced, either by checking arguments or by transforming them. Recursive data structures, especially those that may be self-referential, often cannot be constructed cleanly without first being created in an incomplete state and then altered programmatically to be made whole, as a separate step from object creation. Sometimes, it's just convenient to be able to construct objects with fewer or different types of parameters than they have fields. Julia's system for object construction addresses all of these cases and more.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"[1]: Nomenclature: while the term \"constructor\" generally refers to the entire function which constructs objects of a type, it is common to abuse terminology slightly and refer to specific constructor methods as \"constructors\". In such situations, it is generally clear from the context that the term is used to mean \"constructor method\" rather than \"constructor function\", especially as it is often used in the sense of singling out a particular method of the constructor from all of the others.","category":"page"},{"location":"manual/constructors.html#Outer-Constructor-Methods-1","page":"Constructors","title":"Outer Constructor Methods","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"A constructor is just like any other function in Julia in that its overall behavior is defined by the combined behavior of its methods. Accordingly, you can add functionality to a constructor by simply defining new methods. For example, let's say you want to add a constructor method for Foo objects that takes only one argument and uses the given value for both the bar and baz fields. This is simple:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Foo(x) = Foo(x,x)\nFoo\n\njulia> Foo(1)\nFoo(1, 1)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"You could also add a zero-argument Foo constructor method that supplies default values for both of the bar and baz fields:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Foo() = Foo(0)\nFoo\n\njulia> Foo()\nFoo(0, 0)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Here the zero-argument constructor method calls the single-argument constructor method, which in turn calls the automatically provided two-argument constructor method. For reasons that will become clear very shortly, additional constructor methods declared as normal methods like this are called outer constructor methods. Outer constructor methods can only ever create a new instance by calling another constructor method, such as the automatically provided default ones.","category":"page"},{"location":"manual/constructors.html#Inner-Constructor-Methods-1","page":"Constructors","title":"Inner Constructor Methods","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"While outer constructor methods succeed in addressing the problem of providing additional convenience methods for constructing objects, they fail to address the other two use cases mentioned in the introduction of this chapter: enforcing invariants, and allowing construction of self-referential objects. For these problems, one needs inner constructor methods. An inner constructor method is like an outer constructor method, except for two differences:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"It is declared inside the block of a type declaration, rather than outside of it like normal methods.\nIt has access to a special locally existent function called new that creates objects of the block's type.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"For example, suppose one wants to declare a type that holds a pair of real numbers, subject to the constraint that the first number is not greater than the second one. One could declare it like this:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct OrderedPair\n           x::Real\n           y::Real\n           OrderedPair(x,y) = x > y ? error(\"out of order\") : new(x,y)\n       end","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Now OrderedPair objects can only be constructed such that x <= y:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> OrderedPair(1, 2)\nOrderedPair(1, 2)\n\njulia> OrderedPair(2,1)\nERROR: out of order\nStacktrace:\n [1] error at ./error.jl:33 [inlined]\n [2] OrderedPair(::Int64, ::Int64) at ./none:4\n [3] top-level scope","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"If the type were declared mutable, you could reach in and directly change the field values to violate this invariant. Of course, messing around with an object's internals uninvited is bad practice. You (or someone else) can also provide additional outer constructor methods at any later point, but once a type is declared, there is no way to add more inner constructor methods. Since outer constructor methods can only create objects by calling other constructor methods, ultimately, some inner constructor must be called to create an object. This guarantees that all objects of the declared type must come into existence by a call to one of the inner constructor methods provided with the type, thereby giving some degree of enforcement of a type's invariants.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"If any inner constructor method is defined, no default constructor method is provided: it is presumed that you have supplied yourself with all the inner constructors you need. The default constructor is equivalent to writing your own inner constructor method that takes all of the object's fields as parameters (constrained to be of the correct type, if the corresponding field has a type), and passes them to new, returning the resulting object:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct Foo\n           bar\n           baz\n           Foo(bar,baz) = new(bar,baz)\n       end\n","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"This declaration has the same effect as the earlier definition of the Foo type without an explicit inner constructor method. The following two types are equivalent – one with a default constructor, the other with an explicit constructor:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct T1\n           x::Int64\n       end\n\njulia> struct T2\n           x::Int64\n           T2(x) = new(x)\n       end\n\njulia> T1(1)\nT1(1)\n\njulia> T2(1)\nT2(1)\n\njulia> T1(1.0)\nT1(1)\n\njulia> T2(1.0)\nT2(1)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"It is good practice to provide as few inner constructor methods as possible: only those taking all arguments explicitly and enforcing essential error checking and transformation. Additional convenience constructor methods, supplying default values or auxiliary transformations, should be provided as outer constructors that call the inner constructors to do the heavy lifting. This separation is typically quite natural.","category":"page"},{"location":"manual/constructors.html#Incomplete-Initialization-1","page":"Constructors","title":"Incomplete Initialization","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"The final problem which has still not been addressed is construction of self-referential objects, or more generally, recursive data structures. Since the fundamental difficulty may not be immediately obvious, let us briefly explain it. Consider the following recursive type declaration:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> mutable struct SelfReferential\n           obj::SelfReferential\n       end\n","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"This type may appear innocuous enough, until one considers how to construct an instance of it. If a is an instance of SelfReferential, then a second instance can be created by the call:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> b = SelfReferential(a)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"But how does one construct the first instance when no instance exists to provide as a valid value for its obj field? The only solution is to allow creating an incompletely initialized instance of SelfReferential with an unassigned obj field, and using that incomplete instance as a valid value for the obj field of another instance, such as, for example, itself.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"To allow for the creation of incompletely initialized objects, Julia allows the new function to be called with fewer than the number of fields that the type has, returning an object with the unspecified fields uninitialized. The inner constructor method can then use the incomplete object, finishing its initialization before returning it. Here, for example, is another attempt at defining the SelfReferential type, this time using a zero-argument inner constructor returning instances having obj fields pointing to themselves:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> mutable struct SelfReferential\n           obj::SelfReferential\n           SelfReferential() = (x = new(); x.obj = x)\n       end\n","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"We can verify that this constructor works and constructs objects that are, in fact, self-referential:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> x = SelfReferential();\n\njulia> x === x\ntrue\n\njulia> x === x.obj\ntrue\n\njulia> x === x.obj.obj\ntrue","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Although it is generally a good idea to return a fully initialized object from an inner constructor, it is possible to return incompletely initialized objects:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> mutable struct Incomplete\n           data\n           Incomplete() = new()\n       end\n\njulia> z = Incomplete();","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"While you are allowed to create objects with uninitialized fields, any access to an uninitialized reference is an immediate error:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> z.data\nERROR: UndefRefError: access to undefined reference","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"This avoids the need to continually check for null values. However, not all object fields are references. Julia considers some types to be \"plain data\", meaning all of their data is self-contained and does not reference other objects. The plain data types consist of primitive types (e.g. Int) and immutable structs of other plain data types. The initial contents of a plain data type is undefined:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct HasPlain\n           n::Int\n           HasPlain() = new()\n       end\n\njulia> HasPlain()\nHasPlain(438103441441)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Arrays of plain data types exhibit the same behavior.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"You can pass incomplete objects to other functions from inner constructors to delegate their completion:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> mutable struct Lazy\n           data\n           Lazy(v) = complete_me(new(), v)\n       end","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"As with incomplete objects returned from constructors, if complete_me or any of its callees try to access the data field of the Lazy object before it has been initialized, an error will be thrown immediately.","category":"page"},{"location":"manual/constructors.html#Parametric-Constructors-1","page":"Constructors","title":"Parametric Constructors","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Parametric types add a few wrinkles to the constructor story. Recall from Parametric Types that, by default, instances of parametric composite types can be constructed either with explicitly given type parameters or with type parameters implied by the types of the arguments given to the constructor. Here are some examples:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct Point{T<:Real}\n           x::T\n           y::T\n       end\n\njulia> Point(1,2) ## implicit T ##\nPoint{Int64}(1, 2)\n\njulia> Point(1.0,2.5) ## implicit T ##\nPoint{Float64}(1.0, 2.5)\n\njulia> Point(1,2.5) ## implicit T ##\nERROR: MethodError: no method matching Point(::Int64, ::Float64)\nClosest candidates are:\n  Point(::T<:Real, ::T<:Real) where T<:Real at none:2\n\njulia> Point{Int64}(1, 2) ## explicit T ##\nPoint{Int64}(1, 2)\n\njulia> Point{Int64}(1.0,2.5) ## explicit T ##\nERROR: InexactError: Int64(2.5)\nStacktrace:\n[...]\n\njulia> Point{Float64}(1.0, 2.5) ## explicit T ##\nPoint{Float64}(1.0, 2.5)\n\njulia> Point{Float64}(1,2) ## explicit T ##\nPoint{Float64}(1.0, 2.0)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"As you can see, for constructor calls with explicit type parameters, the arguments are converted to the implied field types: Point{Int64}(1,2) works, but Point{Int64}(1.0,2.5) raises an InexactError when converting 2.5 to Int64. When the type is implied by the arguments to the constructor call, as in Point(1,2), then the types of the arguments must agree – otherwise the T cannot be determined – but any pair of real arguments with matching type may be given to the generic Point constructor.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"What's really going on here is that Point, Point{Float64} and Point{Int64} are all different constructor functions. In fact, Point{T} is a distinct constructor function for each type T. Without any explicitly provided inner constructors, the declaration of the composite type Point{T<:Real} automatically provides an inner constructor, Point{T}, for each possible type T<:Real, that behaves just like non-parametric default inner constructors do. It also provides a single general outer Point constructor that takes pairs of real arguments, which must be of the same type. This automatic provision of constructors is equivalent to the following explicit declaration:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct Point{T<:Real}\n           x::T\n           y::T\n           Point{T}(x,y) where {T<:Real} = new(x,y)\n       end\n\njulia> Point(x::T, y::T) where {T<:Real} = Point{T}(x,y);","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Notice that each definition looks like the form of constructor call that it handles. The call Point{Int64}(1,2) will invoke the definition Point{T}(x,y) inside the struct block. The outer constructor declaration, on the other hand, defines a method for the general Point constructor which only applies to pairs of values of the same real type. This declaration makes constructor calls without explicit type parameters, like Point(1,2) and Point(1.0,2.5), work. Since the method declaration restricts the arguments to being of the same type, calls like Point(1,2.5), with arguments of different types, result in \"no method\" errors.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Suppose we wanted to make the constructor call Point(1,2.5) work by \"promoting\" the integer value 1 to the floating-point value 1.0. The simplest way to achieve this is to define the following additional outer constructor method:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Point(x::Int64, y::Float64) = Point(convert(Float64,x),y);","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"This method uses the convert function to explicitly convert x to Float64 and then delegates construction to the general constructor for the case where both arguments are Float64. With this method definition what was previously a MethodError now successfully creates a point of type Point{Float64}:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Point(1,2.5)\nPoint{Float64}(1.0, 2.5)\n\njulia> typeof(ans)\nPoint{Float64}","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"However, other similar calls still don't work:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Point(1.5,2)\nERROR: MethodError: no method matching Point(::Float64, ::Int64)\nClosest candidates are:\n  Point(::T<:Real, !Matched::T<:Real) where T<:Real at none:1","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"For a more general way to make all such calls work sensibly, see Conversion and Promotion. At the risk of spoiling the suspense, we can reveal here that all it takes is the following outer method definition to make all calls to the general Point constructor work as one would expect:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Point(x::Real, y::Real) = Point(promote(x,y)...);","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"The promote function converts all its arguments to a common type – in this case Float64. With this method definition, the Point constructor promotes its arguments the same way that numeric operators like + do, and works for all kinds of real numbers:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> Point(1.5,2)\nPoint{Float64}(1.5, 2.0)\n\njulia> Point(1,1//2)\nPoint{Rational{Int64}}(1//1, 1//2)\n\njulia> Point(1.0,1//2)\nPoint{Float64}(1.0, 0.5)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Thus, while the implicit type parameter constructors provided by default in Julia are fairly strict, it is possible to make them behave in a more relaxed but sensible manner quite easily. Moreover, since constructors can leverage all of the power of the type system, methods, and multiple dispatch, defining sophisticated behavior is typically quite simple.","category":"page"},{"location":"manual/constructors.html#Case-Study:-Rational-1","page":"Constructors","title":"Case Study: Rational","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Perhaps the best way to tie all these pieces together is to present a real world example of a parametric composite type and its constructor methods. To that end, we implement our own rational number type OurRational, similar to Julia's built-in Rational type, defined in rational.jl:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct OurRational{T<:Integer} <: Real\n           num::T\n           den::T\n           function OurRational{T}(num::T, den::T) where T<:Integer\n               if num == 0 && den == 0\n                    error(\"invalid rational: 0//0\")\n               end\n               g = gcd(den, num)\n               num = div(num, g)\n               den = div(den, g)\n               new(num, den)\n           end\n       end\n\njulia> OurRational(n::T, d::T) where {T<:Integer} = OurRational{T}(n,d)\nOurRational\n\njulia> OurRational(n::Integer, d::Integer) = OurRational(promote(n,d)...)\nOurRational\n\njulia> OurRational(n::Integer) = OurRational(n,one(n))\nOurRational\n\njulia> ⊘(n::Integer, d::Integer) = OurRational(n,d)\n⊘ (generic function with 1 method)\n\njulia> ⊘(x::OurRational, y::Integer) = x.num ⊘ (x.den*y)\n⊘ (generic function with 2 methods)\n\njulia> ⊘(x::Integer, y::OurRational) = (x*y.den) ⊘ y.num\n⊘ (generic function with 3 methods)\n\njulia> ⊘(x::Complex, y::Real) = complex(real(x) ⊘ y, imag(x) ⊘ y)\n⊘ (generic function with 4 methods)\n\njulia> ⊘(x::Real, y::Complex) = (x*y') ⊘ real(y*y')\n⊘ (generic function with 5 methods)\n\njulia> function ⊘(x::Complex, y::Complex)\n           xy = x*y'\n           yy = real(y*y')\n           complex(real(xy) ⊘ yy, imag(xy) ⊘ yy)\n       end\n⊘ (generic function with 6 methods)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"The first line – struct OurRational{T<:Integer} <: Real – declares that OurRational takes one type parameter of an integer type, and is itself a real type. The field declarations num::T and den::T indicate that the data held in a OurRational{T} object are a pair of integers of type T, one representing the rational value's numerator and the other representing its denominator.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Now things get interesting. OurRational has a single inner constructor method which checks that both of num and den aren't zero and ensures that every rational is constructed in \"lowest terms\" with a non-negative denominator. This is accomplished by dividing the given numerator and denominator values by their greatest common divisor, computed using the gcd function. Since gcd returns the greatest common divisor of its arguments with sign matching the first argument (den here), after this division the new value of den is guaranteed to be non-negative. Because this is the only inner constructor for OurRational, we can be certain that OurRational objects are always constructed in this normalized form.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"OurRational also provides several outer constructor methods for convenience. The first is the \"standard\" general constructor that infers the type parameter T from the type of the numerator and denominator when they have the same type. The second applies when the given numerator and denominator values have different types: it promotes them to a common type and then delegates construction to the outer constructor for arguments of matching type. The third outer constructor turns integer values into rationals by supplying a value of 1 as the denominator.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Following the outer constructor definitions, we defined a number of methods for the ⊘ operator, which provides a syntax for writing rationals (e.g. 1 ⊘ 2). Julia's Rational type uses the // operator for this purpose. Before these definitions, ⊘ is a completely undefined operator with only syntax and no meaning. Afterwards, it behaves just as described in Rational Numbers – its entire behavior is defined in these few lines. The first and most basic definition just makes a ⊘ b construct a OurRational by applying the OurRational constructor to a and b when they are integers. When one of the operands of ⊘ is already a rational number, we construct a new rational for the resulting ratio slightly differently; this behavior is actually identical to division of a rational with an integer. Finally, applying ⊘ to complex integral values creates an instance of Complex{OurRational} – a complex number whose real and imaginary parts are rationals:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> z = (1 + 2im) ⊘ (1 - 2im);\n\njulia> typeof(z)\nComplex{OurRational{Int64}}\n\njulia> typeof(z) <: Complex{OurRational}\nfalse","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"Thus, although the ⊘ operator usually returns an instance of OurRational, if either of its arguments are complex integers, it will return an instance of Complex{OurRational} instead. The interested reader should consider perusing the rest of rational.jl: it is short, self-contained, and implements an entire basic Julia type.","category":"page"},{"location":"manual/constructors.html#Outer-only-constructors-1","page":"Constructors","title":"Outer-only constructors","text":"","category":"section"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"As we have seen, a typical parametric type has inner constructors that are called when type parameters are known; e.g. they apply to Point{Int} but not to Point. Optionally, outer constructors that determine type parameters automatically can be added, for example constructing a Point{Int} from the call Point(1,2). Outer constructors call inner constructors to actually make instances. However, in some cases one would rather not provide inner constructors, so that specific type parameters cannot be requested manually.","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"For example, say we define a type that stores a vector along with an accurate representation of its sum:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct SummedArray{T<:Number,S<:Number}\n           data::Vector{T}\n           sum::S\n       end\n\njulia> SummedArray(Int32[1; 2; 3], Int32(6))\nSummedArray{Int32,Int32}(Int32[1, 2, 3], 6)","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"The problem is that we want S to be a larger type than T, so that we can sum many elements with less information loss. For example, when T is Int32, we would like S to be Int64. Therefore we want to avoid an interface that allows the user to construct instances of the type SummedArray{Int32,Int32}. One way to do this is to provide a constructor only for SummedArray, but inside the struct definition block to suppress generation of default constructors:","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"julia> struct SummedArray{T<:Number,S<:Number}\n           data::Vector{T}\n           sum::S\n           function SummedArray(a::Vector{T}) where T\n               S = widen(T)\n               new{T,S}(a, sum(S, a))\n           end\n       end\n\njulia> SummedArray(Int32[1; 2; 3], Int32(6))\nERROR: MethodError: no method matching SummedArray(::Array{Int32,1}, ::Int32)\nClosest candidates are:\n  SummedArray(::Array{T,1}) where T at none:5","category":"page"},{"location":"manual/constructors.html#","page":"Constructors","title":"Constructors","text":"This constructor will be invoked by the syntax SummedArray(a). The syntax new{T,S} allows specifying parameters for the type to be constructed, i.e. this call will return a SummedArray{T,S}. new{T,S} can be used in any constructor definition, but for convenience the parameters to new{} are automatically derived from the type being constructed when possible.","category":"page"},{"location":"manual/conversion-and-promotion.html#conversion-and-promotion-1","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Julia has a system for promoting arguments of mathematical operators to a common type, which has been mentioned in various other sections, including Integers and Floating-Point Numbers, Mathematical Operations and Elementary Functions, Types, and Methods. In this section, we explain how this promotion system works, as well as how to extend it to new types and apply it to functions besides built-in mathematical operators. Traditionally, programming languages fall into two camps with respect to promotion of arithmetic arguments:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Automatic promotion for built-in arithmetic types and operators. In most languages, built-in numeric types, when used as operands to arithmetic operators with infix syntax, such as +, -, *, and /, are automatically promoted to a common type to produce the expected results. C, Java, Perl, and Python, to name a few, all correctly compute the sum 1 + 1.5 as the floating-point value 2.5, even though one of the operands to + is an integer. These systems are convenient and designed carefully enough that they are generally all-but-invisible to the programmer: hardly anyone consciously thinks of this promotion taking place when writing such an expression, but compilers and interpreters must perform conversion before addition since integers and floating-point values cannot be added as-is. Complex rules for such automatic conversions are thus inevitably part of specifications and implementations for such languages.\nNo automatic promotion. This camp includes Ada and ML – very \"strict\" statically typed languages. In these languages, every conversion must be explicitly specified by the programmer. Thus, the example expression 1 + 1.5 would be a compilation error in both Ada and ML. Instead one must write real(1) + 1.5, explicitly converting the integer 1 to a floating-point value before performing addition. Explicit conversion everywhere is so inconvenient, however, that even Ada has some degree of automatic conversion: integer literals are promoted to the expected integer type automatically, and floating-point literals are similarly promoted to appropriate floating-point types.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"In a sense, Julia falls into the \"no automatic promotion\" category: mathematical operators are just functions with special syntax, and the arguments of functions are never automatically converted. However, one may observe that applying mathematical operations to a wide variety of mixed argument types is just an extreme case of polymorphic multiple dispatch – something which Julia's dispatch and type systems are particularly well-suited to handle. \"Automatic\" promotion of mathematical operands simply emerges as a special application: Julia comes with pre-defined catch-all dispatch rules for mathematical operators, invoked when no specific implementation exists for some combination of operand types. These catch-all rules first promote all operands to a common type using user-definable promotion rules, and then invoke a specialized implementation of the operator in question for the resulting values, now of the same type. User-defined types can easily participate in this promotion system by defining methods for conversion to and from other types, and providing a handful of promotion rules defining what types they should promote to when mixed with other types.","category":"page"},{"location":"manual/conversion-and-promotion.html#Conversion-1","page":"Conversion and Promotion","title":"Conversion","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The standard way to obtain a value of a certain type T is to call the type's constructor, T(x). However, there are cases where it's convenient to convert a value from one type to another without the programmer asking for it explicitly. One example is assigning a value into an array: if A is a Vector{Float64}, the expression A[1] = 2 should work by automatically converting the 2 from Int to Float64, and storing the result in the array. This is done via the convert function.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The convert function generally takes two arguments: the first is a type object and the second is a value to convert to that type. The returned value is the value converted to an instance of given type. The simplest way to understand this function is to see it in action:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"julia> x = 12\n12\n\njulia> typeof(x)\nInt64\n\njulia> convert(UInt8, x)\n0x0c\n\njulia> typeof(ans)\nUInt8\n\njulia> convert(AbstractFloat, x)\n12.0\n\njulia> typeof(ans)\nFloat64\n\njulia> a = Any[1 2 3; 4 5 6]\n2×3 Array{Any,2}:\n 1  2  3\n 4  5  6\n\njulia> convert(Array{Float64}, a)\n2×3 Array{Float64,2}:\n 1.0  2.0  3.0\n 4.0  5.0  6.0","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Conversion isn't always possible, in which case a no method error is thrown indicating that convert doesn't know how to perform the requested conversion:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"julia> convert(AbstractFloat, \"foo\")\nERROR: MethodError: Cannot `convert` an object of type String to an object of type AbstractFloat\n[...]","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Some languages consider parsing strings as numbers or formatting numbers as strings to be conversions (many dynamic languages will even perform conversion for you automatically), however Julia does not: even though some strings can be parsed as numbers, most strings are not valid representations of numbers, and only a very limited subset of them are. Therefore in Julia the dedicated parse function must be used to perform this operation, making it more explicit.","category":"page"},{"location":"manual/conversion-and-promotion.html#When-is-convert-called?-1","page":"Conversion and Promotion","title":"When is convert called?","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The following language constructs call convert:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Assigning to an array converts to the array's element type.\nAssigning to a field of an object converts to the declared type of the field.\nConstructing an object with new converts to the object's declared field types.\nAssigning to a variable with a declared type (e.g. local x::T) converts to that type.\nA function with a declared return type converts its return value to that type.\nPassing a value to ccall converts it to the corresponding argument type.","category":"page"},{"location":"manual/conversion-and-promotion.html#Conversion-vs.-Construction-1","page":"Conversion and Promotion","title":"Conversion vs. Construction","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Note that the behavior of convert(T, x) appears to be nearly identical to T(x). Indeed, it usually is. However, there is a key semantic difference: since convert can be called implicitly, its methods are restricted to cases that are considered \"safe\" or \"unsurprising\". convert will only convert between types that represent the same basic kind of thing (e.g. different representations of numbers, or different string encodings). It is also usually lossless; converting a value to a different type and back again should result in the exact same value.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"There are four general kinds of cases where constructors differ from convert:","category":"page"},{"location":"manual/conversion-and-promotion.html#Constructors-for-types-unrelated-to-their-arguments-1","page":"Conversion and Promotion","title":"Constructors for types unrelated to their arguments","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Some constructors don't implement the concept of \"conversion\". For example, Timer(2) creates a 2-second timer, which is not really a \"conversion\" from an integer to a timer.","category":"page"},{"location":"manual/conversion-and-promotion.html#Mutable-collections-1","page":"Conversion and Promotion","title":"Mutable collections","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"convert(T, x) is expected to return the original x if x is already of type T. In contrast, if T is a mutable collection type then T(x) should always make a new collection (copying elements from x).","category":"page"},{"location":"manual/conversion-and-promotion.html#Wrapper-types-1","page":"Conversion and Promotion","title":"Wrapper types","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"For some types which \"wrap\" other values, the constructor may wrap its argument inside a new object even if it is already of the requested type. For example Some(x) wraps x to indicate that a value is present (in a context where the result might be a Some or nothing). However, x itself might be the object Some(y), in which case the result is Some(Some(y)), with two levels of wrapping. convert(Some, x), on the other hand, would just return x since it is already a Some.","category":"page"},{"location":"manual/conversion-and-promotion.html#Constructors-that-don't-return-instances-of-their-own-type-1","page":"Conversion and Promotion","title":"Constructors that don't return instances of their own type","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"In very rare cases it might make sense for the constructor T(x) to return an object not of type T. This could happen if a wrapper type is its own inverse (e.g. Flip(Flip(x)) === x), or to support an old calling syntax for backwards compatibility when a library is restructured. But convert(T, x) should always return a value of type T.","category":"page"},{"location":"manual/conversion-and-promotion.html#Defining-New-Conversions-1","page":"Conversion and Promotion","title":"Defining New Conversions","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"When defining a new type, initially all ways of creating it should be defined as constructors. If it becomes clear that implicit conversion would be useful, and that some constructors meet the above \"safety\" criteria, then convert methods can be added. These methods are typically quite simple, as they only need to call the appropriate constructor. Such a definition might look like this:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"convert(::Type{MyType}, x) = MyType(x)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The type of the first argument of this method is a singleton type, Type{MyType}, the only instance of which is MyType. Thus, this method is only invoked when the first argument is the type value MyType. Notice the syntax used for the first argument: the argument name is omitted prior to the :: symbol, and only the type is given. This is the syntax in Julia for a function argument whose type is specified but whose value does not need to be referenced by name. In this example, since the type is a singleton, we already know its value without referring to an argument name.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"All instances of some abstract types are by default considered \"sufficiently similar\" that a universal convert definition is provided in Julia Base. For example, this definition states that it's valid to convert any Number type to any other by calling a 1-argument constructor:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"convert(::Type{T}, x::Number) where {T<:Number} = T(x)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"This means that new Number types only need to define constructors, since this definition will handle convert for them. An identity conversion is also provided to handle the case where the argument is already of the requested type:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"convert(::Type{T}, x::T) where {T<:Number} = x","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Similar definitions exist for AbstractString, AbstractArray, and AbstractDict.","category":"page"},{"location":"manual/conversion-and-promotion.html#Promotion-1","page":"Conversion and Promotion","title":"Promotion","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Promotion refers to converting values of mixed types to a single common type. Although it is not strictly necessary, it is generally implied that the common type to which the values are converted can faithfully represent all of the original values. In this sense, the term \"promotion\" is appropriate since the values are converted to a \"greater\" type – i.e. one which can represent all of the input values in a single common type. It is important, however, not to confuse this with object-oriented (structural) super-typing, or Julia's notion of abstract super-types: promotion has nothing to do with the type hierarchy, and everything to do with converting between alternate representations. For instance, although every Int32 value can also be represented as a Float64 value, Int32 is not a subtype of Float64.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Promotion to a common \"greater\" type is performed in Julia by the promote function, which takes any number of arguments, and returns a tuple of the same number of values, converted to a common type, or throws an exception if promotion is not possible. The most common use case for promotion is to convert numeric arguments to a common type:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"julia> promote(1, 2.5)\n(1.0, 2.5)\n\njulia> promote(1, 2.5, 3)\n(1.0, 2.5, 3.0)\n\njulia> promote(2, 3//4)\n(2//1, 3//4)\n\njulia> promote(1, 2.5, 3, 3//4)\n(1.0, 2.5, 3.0, 0.75)\n\njulia> promote(1.5, im)\n(1.5 + 0.0im, 0.0 + 1.0im)\n\njulia> promote(1 + 2im, 3//4)\n(1//1 + 2//1*im, 3//4 + 0//1*im)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Floating-point values are promoted to the largest of the floating-point argument types. Integer values are promoted to the larger of either the native machine word size or the largest integer argument type. Mixtures of integers and floating-point values are promoted to a floating-point type big enough to hold all the values. Integers mixed with rationals are promoted to rationals. Rationals mixed with floats are promoted to floats. Complex values mixed with real values are promoted to the appropriate kind of complex value.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"That is really all there is to using promotions. The rest is just a matter of clever application, the most typical \"clever\" application being the definition of catch-all methods for numeric operations like the arithmetic operators +, -, * and /. Here are some of the catch-all method definitions given in promotion.jl:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"+(x::Number, y::Number) = +(promote(x,y)...)\n-(x::Number, y::Number) = -(promote(x,y)...)\n*(x::Number, y::Number) = *(promote(x,y)...)\n/(x::Number, y::Number) = /(promote(x,y)...)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"These method definitions say that in the absence of more specific rules for adding, subtracting, multiplying and dividing pairs of numeric values, promote the values to a common type and then try again. That's all there is to it: nowhere else does one ever need to worry about promotion to a common numeric type for arithmetic operations – it just happens automatically. There are definitions of catch-all promotion methods for a number of other arithmetic and mathematical functions in promotion.jl, but beyond that, there are hardly any calls to promote required in Julia Base. The most common usages of promote occur in outer constructors methods, provided for convenience, to allow constructor calls with mixed types to delegate to an inner type with fields promoted to an appropriate common type. For example, recall that rational.jl provides the following outer constructor method:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Rational(n::Integer, d::Integer) = Rational(promote(n,d)...)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"This allows calls like the following to work:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"julia> Rational(Int8(15),Int32(-5))\n-3//1\n\njulia> typeof(ans)\nRational{Int32}","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"For most user-defined types, it is better practice to require programmers to supply the expected types to constructor functions explicitly, but sometimes, especially for numeric problems, it can be convenient to do promotion automatically.","category":"page"},{"location":"manual/conversion-and-promotion.html#Defining-Promotion-Rules-1","page":"Conversion and Promotion","title":"Defining Promotion Rules","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Although one could, in principle, define methods for the promote function directly, this would require many redundant definitions for all possible permutations of argument types. Instead, the behavior of promote is defined in terms of an auxiliary function called promote_rule, which one can provide methods for. The promote_rule function takes a pair of type objects and returns another type object, such that instances of the argument types will be promoted to the returned type. Thus, by defining the rule:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"promote_rule(::Type{Float64}, ::Type{Float32}) = Float64","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"one declares that when 64-bit and 32-bit floating-point values are promoted together, they should be promoted to 64-bit floating-point. The promotion type does not need to be one of the argument types, however; the following promotion rules both occur in Julia Base:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"promote_rule(::Type{BigInt}, ::Type{Float64}) = BigFloat\npromote_rule(::Type{BigInt}, ::Type{Int8}) = BigInt","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"In the latter case, the result type is BigInt since BigInt is the only type large enough to hold integers for arbitrary-precision integer arithmetic. Also note that one does not need to define both promote_rule(::Type{A}, ::Type{B}) and promote_rule(::Type{B}, ::Type{A}) – the symmetry is implied by the way promote_rule is used in the promotion process.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The promote_rule function is used as a building block to define a second function called promote_type, which, given any number of type objects, returns the common type to which those values, as arguments to promote should be promoted. Thus, if one wants to know, in absence of actual values, what type a collection of values of certain types would promote to, one can use promote_type:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"julia> promote_type(Int8, Int64)\nInt64","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Internally, promote_type is used inside of promote to determine what type argument values should be converted to for promotion. It can, however, be useful in its own right. The curious reader can read the code in promotion.jl, which defines the complete promotion mechanism in about 35 lines.","category":"page"},{"location":"manual/conversion-and-promotion.html#Case-Study:-Rational-Promotions-1","page":"Conversion and Promotion","title":"Case Study: Rational Promotions","text":"","category":"section"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"Finally, we finish off our ongoing case study of Julia's rational number type, which makes relatively sophisticated use of the promotion mechanism with the following promotion rules:","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"promote_rule(::Type{Rational{T}}, ::Type{S}) where {T<:Integer,S<:Integer} = Rational{promote_type(T,S)}\npromote_rule(::Type{Rational{T}}, ::Type{Rational{S}}) where {T<:Integer,S<:Integer} = Rational{promote_type(T,S)}\npromote_rule(::Type{Rational{T}}, ::Type{S}) where {T<:Integer,S<:AbstractFloat} = promote_type(T,S)","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"The first rule says that promoting a rational number with any other integer type promotes to a rational type whose numerator/denominator type is the result of promotion of its numerator/denominator type with the other integer type. The second rule applies the same logic to two different types of rational numbers, resulting in a rational of the promotion of their respective numerator/denominator types. The third and final rule dictates that promoting a rational with a float results in the same type as promoting the numerator/denominator type with the float.","category":"page"},{"location":"manual/conversion-and-promotion.html#","page":"Conversion and Promotion","title":"Conversion and Promotion","text":"This small handful of promotion rules, together with the type's constructors and the default convert method for numbers, are sufficient to make rational numbers interoperate completely naturally with all of Julia's other numeric types – integers, floating-point numbers, and complex numbers. By providing appropriate conversion methods and promotion rules in the same manner, any user-defined numeric type can interoperate just as naturally with Julia's predefined numerics.","category":"page"},{"location":"manual/interfaces.html#Interfaces-1","page":"Interfaces","title":"Interfaces","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"A lot of the power and extensibility in Julia comes from a collection of informal interfaces.  By extending a few specific methods to work for a custom type, objects of that type not only receive those functionalities, but they are also able to be used in other methods that are written to generically build upon those behaviors.","category":"page"},{"location":"manual/interfaces.html#man-interface-iteration-1","page":"Interfaces","title":"Iteration","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Required methods  Brief description\niterate(iter)  Returns either a tuple of the first item and initial state or nothing if empty\niterate(iter, state)  Returns either a tuple of the next item and next state or nothing if no items remain\nImportant optional methods Default definition Brief description\nIteratorSize(IterType) HasLength() One of HasLength(), HasShape{N}(), IsInfinite(), or SizeUnknown() as appropriate\nIteratorEltype(IterType) HasEltype() Either EltypeUnknown() or HasEltype() as appropriate\neltype(IterType) Any The type of the first entry of the tuple returned by iterate()\nlength(iter) (undefined) The number of items, if known\nsize(iter, [dim]) (undefined) The number of items in each dimension, if known","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Value returned by IteratorSize(IterType) Required Methods\nHasLength() length(iter)\nHasShape{N}() length(iter)  and size(iter, [dim])\nIsInfinite() (none)\nSizeUnknown() (none)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Value returned by IteratorEltype(IterType) Required Methods\nHasEltype() eltype(IterType)\nEltypeUnknown() (none)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Sequential iteration is implemented by the iterate function. Instead of mutating objects as they are iterated over, Julia iterators may keep track of the iteration state externally from the object. The return value from iterate is always either a tuple of a value and a state, or nothing if no elements remain. The state object will be passed back to the iterate function on the next iteration and is generally considered an implementation detail private to the iterable object.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Any object that defines this function is iterable and can be used in the many functions that rely upon iteration. It can also be used directly in a for loop since the syntax:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"for i in iter   # or  \"for i = iter\"\n    # body\nend","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"is translated into:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"next = iterate(iter)\nwhile next !== nothing\n    (i, state) = next\n    # body\n    next = iterate(iter, state)\nend","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"A simple example is an iterable sequence of square numbers with a defined length:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> struct Squares\n           count::Int\n       end\n\njulia> Base.iterate(S::Squares, state=1) = state > S.count ? nothing : (state*state, state+1)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"With only iterate definition, the Squares type is already pretty powerful. We can iterate over all the elements:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> for i in Squares(7)\n           println(i)\n       end\n1\n4\n9\n16\n25\n36\n49","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"We can use many of the builtin methods that work with iterables, like in, or mean and std from the Statistics standard library module:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> 25 in Squares(10)\ntrue\n\njulia> using Statistics\n\njulia> mean(Squares(100))\n3383.5\n\njulia> std(Squares(100))\n3024.355854282583","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"There are a few more methods we can extend to give Julia more information about this iterable collection.  We know that the elements in a Squares sequence will always be Int. By extending the eltype method, we can give that information to Julia and help it make more specialized code in the more complicated methods. We also know the number of elements in our sequence, so we can extend length, too:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> Base.eltype(::Type{Squares}) = Int # Note that this is defined for the type\n\njulia> Base.length(S::Squares) = S.count","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Now, when we ask Julia to collect all the elements into an array it can preallocate a Vector{Int} of the right size instead of blindly push!ing each element into a Vector{Any}:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> collect(Squares(4))\n4-element Array{Int64,1}:\n  1\n  4\n  9\n 16","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"While we can rely upon generic implementations, we can also extend specific methods where we know there is a simpler algorithm. For example, there's a formula to compute the sum of squares, so we can override the generic iterative version with a more performant solution:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> Base.sum(S::Squares) = (n = S.count; return n*(n+1)*(2n+1)÷6)\n\njulia> sum(Squares(1803))\n1955361914","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"This is a very common pattern throughout Julia Base: a small set of required methods define an informal interface that enable many fancier behaviors. In some cases, types will want to additionally specialize those extra behaviors when they know a more efficient algorithm can be used in their specific case.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"It is also often useful to allow iteration over a collection in reverse order by iterating over Iterators.reverse(iterator).  To actually support reverse-order iteration, however, an iterator type T needs to implement iterate for Iterators.Reverse{T}. (Given r::Iterators.Reverse{T}, the underling iterator of type T is r.itr.) In our Squares example, we would implement Iterators.Reverse{Squares} methods:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> Base.iterate(rS::Iterators.Reverse{Squares}, state=rS.itr.count) = state < 1 ? nothing : (state*state, state-1)\n\njulia> collect(Iterators.reverse(Squares(4)))\n4-element Array{Int64,1}:\n 16\n  9\n  4\n  1","category":"page"},{"location":"manual/interfaces.html#Indexing-1","page":"Interfaces","title":"Indexing","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Methods to implement Brief description\ngetindex(X, i) X[i], indexed element access\nsetindex!(X, v, i) X[i] = v, indexed assignment\nfirstindex(X) The first index\nlastindex(X) The last index, used in X[end]","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"For the Squares iterable above, we can easily compute the ith element of the sequence by squaring it.  We can expose this as an indexing expression S[i]. To opt into this behavior, Squares simply needs to define getindex:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> function Base.getindex(S::Squares, i::Int)\n           1 <= i <= S.count || throw(BoundsError(S, i))\n           return i*i\n       end\n\njulia> Squares(100)[23]\n529","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Additionally, to support the syntax S[end], we must define lastindex to specify the last valid index. It is recommended to also define firstindex to specify the first valid index:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> Base.firstindex(S::Squares) = 1\n\njulia> Base.lastindex(S::Squares) = length(S)\n\njulia> Squares(23)[end]\n529","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Note, though, that the above only defines getindex with one integer index. Indexing with anything other than an Int will throw a MethodError saying that there was no matching method. In order to support indexing with ranges or vectors of Ints, separate methods must be written:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> Base.getindex(S::Squares, i::Number) = S[convert(Int, i)]\n\njulia> Base.getindex(S::Squares, I) = [S[i] for i in I]\n\njulia> Squares(10)[[3,4.,5]]\n3-element Array{Int64,1}:\n  9\n 16\n 25","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"While this is starting to support more of the indexing operations supported by some of the builtin types, there's still quite a number of behaviors missing. This Squares sequence is starting to look more and more like a vector as we've added behaviors to it. Instead of defining all these behaviors ourselves, we can officially define it as a subtype of an AbstractArray.","category":"page"},{"location":"manual/interfaces.html#man-interface-array-1","page":"Interfaces","title":"Abstract Arrays","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Methods to implement  Brief description\nsize(A)  Returns a tuple containing the dimensions of A\ngetindex(A, i::Int)  (if IndexLinear) Linear scalar indexing\ngetindex(A, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexing\nsetindex!(A, v, i::Int)  (if IndexLinear) Scalar indexed assignment\nsetindex!(A, v, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexed assignment\nOptional methods Default definition Brief description\nIndexStyle(::Type) IndexCartesian() Returns either IndexLinear() or IndexCartesian(). See the description below.\ngetindex(A, I...) defined in terms of scalar getindex Multidimensional and nonscalar indexing\nsetindex!(A, I...) defined in terms of scalar setindex! Multidimensional and nonscalar indexed assignment\niterate defined in terms of scalar getindex Iteration\nlength(A) prod(size(A)) Number of elements\nsimilar(A) similar(A, eltype(A), size(A)) Return a mutable array with the same shape and element type\nsimilar(A, ::Type{S}) similar(A, S, size(A)) Return a mutable array with the same shape and the specified element type\nsimilar(A, dims::Dims) similar(A, eltype(A), dims) Return a mutable array with the same element type and size dims\nsimilar(A, ::Type{S}, dims::Dims) Array{S}(undef, dims) Return a mutable array with the specified element type and size\nNon-traditional indices Default definition Brief description\naxes(A) map(OneTo, size(A)) Return the AbstractUnitRange of valid indices\nsimilar(A, ::Type{S}, inds) similar(A, S, Base.to_shape(inds)) Return a mutable array with the specified indices inds (see below)\nsimilar(T::Union{Type,Function}, inds) T(Base.to_shape(inds)) Return an array similar to T with the specified indices inds (see below)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"If a type is defined as a subtype of AbstractArray, it inherits a very large set of rich behaviors including iteration and multidimensional indexing built on top of single-element access.  See the arrays manual page and the Julia Base section for more supported methods.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"A key part in defining an AbstractArray subtype is IndexStyle. Since indexing is such an important part of an array and often occurs in hot loops, it's important to make both indexing and indexed assignment as efficient as possible.  Array data structures are typically defined in one of two ways: either it most efficiently accesses its elements using just one index (linear indexing) or it intrinsically accesses the elements with indices specified for every dimension.  These two modalities are identified by Julia as IndexLinear() and IndexCartesian().  Converting a linear index to multiple indexing subscripts is typically very expensive, so this provides a traits-based mechanism to enable efficient generic code for all array types.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"This distinction determines which scalar indexing methods the type must define. IndexLinear() arrays are simple: just define getindex(A::ArrayType, i::Int).  When the array is subsequently indexed with a multidimensional set of indices, the fallback getindex(A::AbstractArray, I...)() efficiently converts the indices into one linear index and then calls the above method. IndexCartesian() arrays, on the other hand, require methods to be defined for each supported dimensionality with ndims(A) Int indices. For example, SparseMatrixCSC from the SparseArrays standard library module, only supports two dimensions, so it just defines getindex(A::SparseMatrixCSC, i::Int, j::Int). The same holds for setindex!.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Returning to the sequence of squares from above, we could instead define it as a subtype of an AbstractArray{Int, 1}:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> struct SquaresVector <: AbstractArray{Int, 1}\n           count::Int\n       end\n\njulia> Base.size(S::SquaresVector) = (S.count,)\n\njulia> Base.IndexStyle(::Type{<:SquaresVector}) = IndexLinear()\n\njulia> Base.getindex(S::SquaresVector, i::Int) = i*i","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Note that it's very important to specify the two parameters of the AbstractArray; the first defines the eltype, and the second defines the ndims. That supertype and those three methods are all it takes for SquaresVector to be an iterable, indexable, and completely functional array:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> s = SquaresVector(4)\n4-element SquaresVector:\n  1\n  4\n  9\n 16\n\njulia> s[s .> 8]\n2-element Array{Int64,1}:\n  9\n 16\n\njulia> s + s\n4-element Array{Int64,1}:\n  2\n  8\n 18\n 32\n\njulia> sin.(s)\n4-element Array{Float64,1}:\n  0.8414709848078965\n -0.7568024953079282\n  0.4121184852417566\n -0.2879033166650653","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"As a more complicated example, let's define our own toy N-dimensional sparse-like array type built on top of Dict:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> struct SparseArray{T,N} <: AbstractArray{T,N}\n           data::Dict{NTuple{N,Int}, T}\n           dims::NTuple{N,Int}\n       end\n\njulia> SparseArray(::Type{T}, dims::Int...) where {T} = SparseArray(T, dims);\n\njulia> SparseArray(::Type{T}, dims::NTuple{N,Int}) where {T,N} = SparseArray{T,N}(Dict{NTuple{N,Int}, T}(), dims);\n\njulia> Base.size(A::SparseArray) = A.dims\n\njulia> Base.similar(A::SparseArray, ::Type{T}, dims::Dims) where {T} = SparseArray(T, dims)\n\njulia> Base.getindex(A::SparseArray{T,N}, I::Vararg{Int,N}) where {T,N} = get(A.data, I, zero(T))\n\njulia> Base.setindex!(A::SparseArray{T,N}, v, I::Vararg{Int,N}) where {T,N} = (A.data[I] = v)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Notice that this is an IndexCartesian array, so we must manually define getindex and setindex! at the dimensionality of the array. Unlike the SquaresVector, we are able to define setindex!, and so we can mutate the array:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> A = SparseArray(Float64, 3, 3)\n3×3 SparseArray{Float64,2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2)\n3×3 SparseArray{Float64,2}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> A[:] = 1:length(A); A\n3×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"The result of indexing an AbstractArray can itself be an array (for instance when indexing by an AbstractRange). The AbstractArray fallback methods use similar to allocate an Array of the appropriate size and element type, which is filled in using the basic indexing method described above. However, when implementing an array wrapper you often want the result to be wrapped as well:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> A[1:2,:]\n2×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In this example it is accomplished by defining Base.similar{T}(A::SparseArray, ::Type{T}, dims::Dims) to create the appropriate wrapped array. (Note that while similar supports 1- and 2-argument forms, in most case you only need to specialize the 3-argument form.) For this to work it's important that SparseArray is mutable (supports setindex!). Defining similar, getindex and setindex! for SparseArray also makes it possible to copy the array:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> copy(A)\n3×3 SparseArray{Float64,2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In addition to all the iterable and indexable methods from above, these types can also interact with each other and use most of the methods defined in Julia Base for AbstractArrays:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> A[SquaresVector(3)]\n3-element SparseArray{Float64,1}:\n 1.0\n 4.0\n 9.0\n\njulia> sum(A)\n45.0","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"If you are defining an array type that allows non-traditional indexing (indices that start at something other than 1), you should specialize axes. You should also specialize similar so that the dims argument (ordinarily a Dims size-tuple) can accept AbstractUnitRange objects, perhaps range-types Ind of your own design. For more information, see Arrays with custom indices.","category":"page"},{"location":"manual/interfaces.html#man-interface-strided-arrays-1","page":"Interfaces","title":"Strided Arrays","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Methods to implement  Brief description\nstrides(A)  Return the distance in memory (in number of elements) between adjacent elements in each dimension as a tuple. If A is an AbstractArray{T,0}, this should return an empty tuple.\nBase.unsafe_convert(::Type{Ptr{T}}, A)  Return the native address of an array.\nOptional methods Default definition Brief description\nstride(A, i::Int) strides(A)[i] Return the distance in memory (in number of elements) between adjacent elements in dimension k.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"A strided array is a subtype of AbstractArray whose entries are stored in memory with fixed strides. Provided the element type of the array is compatible with BLAS, a strided array can utilize BLAS and LAPACK routines for more efficient linear algebra routines.  A typical example of a user-defined strided array is one that wraps a standard Array with additional structure.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Warning: do not implement these methods if the underlying storage is not actually strided, as it may lead to incorrect results or segmentation faults.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Here are some examples to demonstrate which type of arrays are strided and which are not:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"1:5   # not strided (there is no storage associated with this array.)\nVector(1:5)  # is strided with strides (1,)\nA = [1 5; 2 6; 3 7; 4 8]  # is strided with strides (1,4)\nV = view(A, 1:2, :)   # is strided with strides (1,4)\nV = view(A, 1:2:3, 1:2)   # is strided with strides (2,4)\nV = view(A, [1,2,4], :)   # is not strided, as the spacing between rows is not fixed.","category":"page"},{"location":"manual/interfaces.html#man-interfaces-broadcasting-1","page":"Interfaces","title":"Customizing broadcasting","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Methods to implement Brief description\nBase.BroadcastStyle(::Type{SrcType}) = SrcStyle() Broadcasting behavior of SrcType\nBase.similar(bc::Broadcasted{DestStyle}, ::Type{ElType}) Allocation of output container\nOptional methods \nBase.BroadcastStyle(::Style1, ::Style2) = Style12() Precedence rules for mixing styles\nBase.axes(x) Declaration of the indices of x, as per axes(x).\nBase.broadcastable(x) Convert x to an object that has axes and supports indexing\nBypassing default machinery \nBase.copy(bc::Broadcasted{DestStyle}) Custom implementation of broadcast\nBase.copyto!(dest, bc::Broadcasted{DestStyle}) Custom implementation of broadcast!, specializing on DestStyle\nBase.copyto!(dest::DestType, bc::Broadcasted{Nothing}) Custom implementation of broadcast!, specializing on DestType\nBase.Broadcast.broadcasted(f, args...) Override the default lazy behavior within a fused expression\nBase.Broadcast.instantiate(bc::Broadcasted{DestStyle}) Override the computation of the lazy broadcast's axes","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Broadcasting is triggered by an explicit call to broadcast or broadcast!, or implicitly by \"dot\" operations like A .+ b or f.(x, y). Any object that has axes and supports indexing can participate as an argument in broadcasting, and by default the result is stored in an Array. This basic framework is extensible in three major ways:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Ensuring that all arguments support broadcast\nSelecting an appropriate output array for the given set of arguments\nSelecting an efficient implementation for the given set of arguments","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Not all types support axes and indexing, but many are convenient to allow in broadcast. The Base.broadcastable function is called on each argument to broadcast, allowing it to return something different that supports axes and indexing. By default, this is the identity function for all AbstractArrays and Numbers — they already support axes and indexing. For a handful of other types (including but not limited to types themselves, functions, special singletons like missing and nothing, and dates), Base.broadcastable returns the argument wrapped in a Ref to act as a 0-dimensional \"scalar\" for the purposes of broadcasting. Custom types can similarly specialize Base.broadcastable to define their shape, but they should follow the convention that collect(Base.broadcastable(x)) == collect(x). A notable exception is AbstractString; strings are special-cased to behave as scalars for the purposes of broadcast even though they are iterable collections of their characters (see Strings for more).","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"The next two steps (selecting the output array and implementation) are dependent upon determining a single answer for a given set of arguments. Broadcast must take all the varied types of its arguments and collapse them down to just one output array and one implementation. Broadcast calls this single answer a \"style.\" Every broadcastable object each has its own preferred style, and a promotion-like system is used to combine these styles into a single answer — the \"destination style\".","category":"page"},{"location":"manual/interfaces.html#Broadcast-Styles-1","page":"Interfaces","title":"Broadcast Styles","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.BroadcastStyle is the abstract type from which all broadcast styles are derived. When used as a function it has two possible forms, unary (single-argument) and binary. The unary variant states that you intend to implement specific broadcasting behavior and/or output type, and do not wish to rely on the default fallback Broadcast.DefaultArrayStyle.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"To override these defaults, you can define a custom BroadcastStyle for your object:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"struct MyStyle <: Broadcast.BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyType}) = MyStyle()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In some cases it might be convenient not to have to define MyStyle, in which case you can leverage one of the general broadcast wrappers:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.BroadcastStyle(::Type{<:MyType}) = Broadcast.Style{MyType}() can be used for arbitrary types.\nBase.BroadcastStyle(::Type{<:MyType}) = Broadcast.ArrayStyle{MyType}() is preferred if MyType is an AbstractArray.\nFor AbstractArrays that only support a certain dimensionality, create a subtype of Broadcast.AbstractArrayStyle{N} (see below).","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"When your broadcast operation involves several arguments, individual argument styles get combined to determine a single DestStyle that controls the type of the output container. For more details, see below.","category":"page"},{"location":"manual/interfaces.html#Selecting-an-appropriate-output-array-1","page":"Interfaces","title":"Selecting an appropriate output array","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"The broadcast style is computed for every broadcasting operation to allow for dispatch and specialization. The actual allocation of the result array is handled by similar, using the Broadcasted object as its first argument.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.similar(bc::Broadcasted{DestStyle}, ::Type{ElType})","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"The fallback definition is","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"similar(bc::Broadcasted{DefaultArrayStyle{N}}, ::Type{ElType}) where {N,ElType} =\n    similar(Array{ElType}, axes(bc))","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"However, if needed you can specialize on any or all of these arguments. The final argument bc is a lazy representation of a (potentially fused) broadcast operation, a Broadcasted object.  For these purposes, the most important fields of the wrapper are f and args, describing the function and argument list, respectively.  Note that the argument list can — and often does — include other nested Broadcasted wrappers.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"For a complete example, let's say you have created a type, ArrayAndChar, that stores an array and a single character:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"struct ArrayAndChar{T,N} <: AbstractArray{T,N}\n    data::Array{T,N}\n    char::Char\nend\nBase.size(A::ArrayAndChar) = size(A.data)\nBase.getindex(A::ArrayAndChar{T,N}, inds::Vararg{Int,N}) where {T,N} = A.data[inds...]\nBase.setindex!(A::ArrayAndChar{T,N}, val, inds::Vararg{Int,N}) where {T,N} = A.data[inds...] = val\nBase.showarg(io::IO, A::ArrayAndChar, toplevel) = print(io, typeof(A), \" with char '\", A.char, \"'\")","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"You might want broadcasting to preserve the char \"metadata.\" First we define","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.BroadcastStyle(::Type{<:ArrayAndChar}) = Broadcast.ArrayStyle{ArrayAndChar}()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"This means we must also define a corresponding similar method:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"function Base.similar(bc::Broadcast.Broadcasted{Broadcast.ArrayStyle{ArrayAndChar}}, ::Type{ElType}) where ElType\n    # Scan the inputs for the ArrayAndChar:\n    A = find_aac(bc)\n    # Use the char field of A to create the output\n    ArrayAndChar(similar(Array{ElType}, axes(bc)), A.char)\nend\n\n\"`A = find_aac(As)` returns the first ArrayAndChar among the arguments.\"\nfind_aac(bc::Base.Broadcast.Broadcasted) = find_aac(bc.args)\nfind_aac(args::Tuple) = find_aac(find_aac(args[1]), Base.tail(args))\nfind_aac(x) = x\nfind_aac(a::ArrayAndChar, rest) = a\nfind_aac(::Any, rest) = find_aac(rest)","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"From these definitions, one obtains the following behavior:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"julia> a = ArrayAndChar([1 2; 3 4], 'x')\n2×2 ArrayAndChar{Int64,2} with char 'x':\n 1  2\n 3  4\n\njulia> a .+ 1\n2×2 ArrayAndChar{Int64,2} with char 'x':\n 2  3\n 4  5\n\njulia> a .+ [5,10]\n2×2 ArrayAndChar{Int64,2} with char 'x':\n  6   7\n 13  14","category":"page"},{"location":"manual/interfaces.html#extending-in-place-broadcast-1","page":"Interfaces","title":"Extending broadcast with custom implementations","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In general, a broadcast operation is represented by a lazy Broadcasted container that holds onto the function to be applied alongside its arguments. Those arguments may themselves be more nested Broadcasted containers, forming a large expression tree to be evaluated. A nested tree of Broadcasted containers is directly constructed by the implicit dot syntax; 5 .+ 2.*x is transiently represented by Broadcasted(+, 5, Broadcasted(*, 2, x)), for example. This is invisible to users as it is immediately realized through a call to copy, but it is this container that provides the basis for broadcast's extensibility for authors of custom types. The built-in broadcast machinery will then determine the result type and size based upon the arguments, allocate it, and then finally copy the realization of the Broadcasted object into it with a default copyto!(::AbstractArray, ::Broadcasted) method. The built-in fallback broadcast and broadcast! methods similarly construct a transient Broadcasted representation of the operation so they can follow the same codepath. This allows custom array implementations to provide their own copyto! specialization to customize and optimize broadcasting. This is again determined by the computed broadcast style. This is such an important part of the operation that it is stored as the first type parameter of the Broadcasted type, allowing for dispatch and specialization.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"For some types, the machinery to \"fuse\" operations across nested levels of broadcasting is not available or could be done more efficiently incrementally. In such cases, you may need or want to evaluate x .* (x .+ 1) as if it had been written broadcast(*, x, broadcast(+, x, 1)), where the inner operation is evaluated before tackling the outer operation. This sort of eager operation is directly supported by a bit of indirection; instead of directly constructing Broadcasted objects, Julia lowers the fused expression x .* (x .+ 1) to Broadcast.broadcasted(*, x, Broadcast.broadcasted(+, x, 1)). Now, by default, broadcasted just calls the Broadcasted constructor to create the lazy representation of the fused expression tree, but you can choose to override it for a particular combination of function and arguments.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"As an example, the builtin AbstractRange objects use this machinery to optimize pieces of broadcasted expressions that can be eagerly evaluated purely in terms of the start, step, and length (or stop) instead of computing every single element. Just like all the other machinery, broadcasted also computes and exposes the combined broadcast style of its arguments, so instead of specializing on broadcasted(f, args...), you can specialize on broadcasted(::DestStyle, f, args...) for any combination of style, function, and arguments.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"For example, the following definition supports the negation of ranges:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"broadcasted(::DefaultArrayStyle{1}, ::typeof(-), r::OrdinalRange) = range(-first(r), step=-step(r), length=length(r))","category":"page"},{"location":"manual/interfaces.html#extending-in-place-broadcast-2","page":"Interfaces","title":"Extending in-place broadcasting","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In-place broadcasting can be supported by defining the appropriate copyto!(dest, bc::Broadcasted) method. Because you might want to specialize either on dest or the specific subtype of bc, to avoid ambiguities between packages we recommend the following convention.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"If you wish to specialize on a particular style DestStyle, define a method for","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"copyto!(dest, bc::Broadcasted{DestStyle})","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Optionally, with this form you can also specialize on the type of dest.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"If instead you want to specialize on the destination type DestType without specializing on DestStyle, then you should define a method with the following signature:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"copyto!(dest::DestType, bc::Broadcasted{Nothing})","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"This leverages a fallback implementation of copyto! that converts the wrapper into a Broadcasted{Nothing}. Consequently, specializing on DestType has lower precedence than methods that specialize on DestStyle.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Similarly, you can completely override out-of-place broadcasting with a copy(::Broadcasted) method.","category":"page"},{"location":"manual/interfaces.html#Working-with-Broadcasted-objects-1","page":"Interfaces","title":"Working with Broadcasted objects","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"In order to implement such a copy or copyto!, method, of course, you must work with the Broadcasted wrapper to compute each element. There are two main ways of doing so:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Broadcast.flatten recomputes the potentially nested operation into a single function and flat list of arguments. You are responsible for implementing the broadcasting shape rules yourself, but this may be helpful in limited situations.\nIterating over the CartesianIndices of the axes(::Broadcasted) and using indexing with the resulting CartesianIndex object to compute the result.","category":"page"},{"location":"manual/interfaces.html#writing-binary-broadcasting-rules-1","page":"Interfaces","title":"Writing binary broadcasting rules","text":"","category":"section"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"The precedence rules are defined by binary BroadcastStyle calls:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.BroadcastStyle(::Style1, ::Style2) = Style12()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"where Style12 is the BroadcastStyle you want to choose for outputs involving arguments of Style1 and Style2. For example,","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Base.BroadcastStyle(::Broadcast.Style{Tuple}, ::Broadcast.AbstractArrayStyle{0}) = Broadcast.Style{Tuple}()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"indicates that Tuple \"wins\" over zero-dimensional arrays (the output container will be a tuple). It is worth noting that you do not need to (and should not) define both argument orders of this call; defining one is sufficient no matter what order the user supplies the arguments in.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"For AbstractArray types, defining a BroadcastStyle supersedes the fallback choice, Broadcast.DefaultArrayStyle. DefaultArrayStyle and the abstract supertype, AbstractArrayStyle, store the dimensionality as a type parameter to support specialized array types that have fixed dimensionality requirements.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"DefaultArrayStyle \"loses\" to any other AbstractArrayStyle that has been defined because of the following methods:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"BroadcastStyle(a::AbstractArrayStyle{Any}, ::DefaultArrayStyle) = a\nBroadcastStyle(a::AbstractArrayStyle{N}, ::DefaultArrayStyle{N}) where N = a\nBroadcastStyle(a::AbstractArrayStyle{M}, ::DefaultArrayStyle{N}) where {M,N} =\n    typeof(a)(_max(Val(M),Val(N)))","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"You do not need to write binary BroadcastStyle rules unless you want to establish precedence for two or more non-DefaultArrayStyle types.","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"If your array type does have fixed dimensionality requirements, then you should subtype AbstractArrayStyle. For example, the sparse array code has the following definitions:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"struct SparseVecStyle <: Broadcast.AbstractArrayStyle{1} end\nstruct SparseMatStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseVector}) = SparseVecStyle()\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatStyle()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"Whenever you subtype AbstractArrayStyle, you also need to define rules for combining dimensionalities, by creating a constructor for your style that takes a Val(N) argument. For example:","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"SparseVecStyle(::Val{0}) = SparseVecStyle()\nSparseVecStyle(::Val{1}) = SparseVecStyle()\nSparseVecStyle(::Val{2}) = SparseMatStyle()\nSparseVecStyle(::Val{N}) where N = Broadcast.DefaultArrayStyle{N}()","category":"page"},{"location":"manual/interfaces.html#","page":"Interfaces","title":"Interfaces","text":"These rules indicate that the combination of a SparseVecStyle with 0- or 1-dimensional arrays yields another SparseVecStyle, that its combination with a 2-dimensional array yields a SparseMatStyle, and anything of higher dimensionality falls back to the dense arbitrary-dimensional framework. These rules allow broadcasting to keep the sparse representation for operations that result in one or two dimensional outputs, but produce an Array for any other dimensionality.","category":"page"},{"location":"manual/modules.html#modules-1","page":"Modules","title":"Modules","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Modules in Julia are separate variable workspaces, i.e. they introduce a new global scope. They are delimited syntactically, inside module Name ... end. Modules allow you to create top-level definitions (aka global variables) without worrying about name conflicts when your code is used together with somebody else's. Within a module, you can control which names from other modules are visible (via importing), and specify which of your names are intended to be public (via exporting).","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The following example demonstrates the major features of modules. It is not meant to be run, but is shown for illustrative purposes:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"module MyModule\nusing Lib\n\nusing BigLib: thing1, thing2\n\nimport Base.show\n\nexport MyType, foo\n\nstruct MyType\n    x\nend\n\nbar(x) = 2x\nfoo(a::MyType) = bar(a.x) + 1\n\nshow(io::IO, a::MyType) = print(io, \"MyType $(a.x)\")\nend","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Note that the style is not to indent the body of the module, since that would typically lead to whole files being indented.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"This module defines a type MyType, and two functions. Function foo and type MyType are exported, and so will be available for importing into other modules.  Function bar is private to MyModule.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The statement using Lib means that a module called Lib will be available for resolving names as needed. When a global variable is encountered that has no definition in the current module, the system will search for it among variables exported by Lib and import it if it is found there. This means that all uses of that global within the current module will resolve to the definition of that variable in Lib.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The statement using BigLib: thing1, thing2 brings just the identifiers thing1 and thing2 into scope from module BigLib. If these names refer to functions, adding methods to them will not be allowed (you may only \"use\" them, not extend them).","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The import keyword supports the same syntax as using, but only operates on a single name at a time. It does not add modules to be searched the way using does. import also differs from using in that functions imported using import can be extended with new methods.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"In MyModule above we wanted to add a method to the standard show function, so we had to write import Base.show. Functions whose names are only visible via using cannot be extended.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Once a variable is made visible via using or import, a module may not create its own variable with the same name. Imported variables are read-only; assigning to a global variable always affects a variable owned by the current module, or else raises an error.","category":"page"},{"location":"manual/modules.html#Summary-of-module-usage-1","page":"Modules","title":"Summary of module usage","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"To load a module, two main keywords can be used: using and import. To understand their differences, consider the following example:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"module MyModule\n\nexport x, y\n\nx() = \"x\"\ny() = \"y\"\np() = \"p\"\n\nend","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"In this module we export the x and y functions (with the keyword export), and also have the non-exported function p. There are several different ways to load the Module and its inner functions into the current workspace:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Import Command What is brought into scope Available for method extension\nusing MyModule All exported names (x and y), MyModule.x, MyModule.y and MyModule.p MyModule.x, MyModule.y and MyModule.p\nusing MyModule: x, p x and p \nimport MyModule MyModule.x, MyModule.y and MyModule.p MyModule.x, MyModule.y and MyModule.p\nimport MyModule.x, MyModule.p x and p x and p\nimport MyModule: x, p x and p x and p","category":"page"},{"location":"manual/modules.html#Modules-and-files-1","page":"Modules","title":"Modules and files","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Files and file names are mostly unrelated to modules; modules are associated only with module expressions. One can have multiple files per module, and multiple modules per file:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"module Foo\n\ninclude(\"file1.jl\")\ninclude(\"file2.jl\")\n\nend","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Including the same code in different modules provides mixin-like behavior. One could use this to run the same code with different base definitions, for example testing code by running it with \"safe\" versions of some operators:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"module Normal\ninclude(\"mycode.jl\")\nend\n\nmodule Testing\ninclude(\"safe_operators.jl\")\ninclude(\"mycode.jl\")\nend","category":"page"},{"location":"manual/modules.html#Standard-modules-1","page":"Modules","title":"Standard modules","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"There are three important standard modules:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Core contains all functionality \"built into\" the language.\nBase contains basic functionality that is useful in almost all cases.\nMain is the top-level module and the current module, when Julia is started.","category":"page"},{"location":"manual/modules.html#Default-top-level-definitions-and-bare-modules-1","page":"Modules","title":"Default top-level definitions and bare modules","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"In addition to using Base, modules also automatically contain definitions of the eval and include functions, which evaluate expressions/files within the global scope of that module.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"If these default definitions are not wanted, modules can be defined using the keyword baremodule instead (note: Core is still imported, as per above). In terms of baremodule, a standard module looks like this:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"baremodule Mod\n\nusing Base\n\neval(x) = Core.eval(Mod, x)\ninclude(p) = Base.include(Mod, p)\n\n...\n\nend","category":"page"},{"location":"manual/modules.html#Relative-and-absolute-module-paths-1","page":"Modules","title":"Relative and absolute module paths","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Given the statement using Foo, the system consults an internal table of top-level modules to look for one named Foo. If the module does not exist, the system attempts to require(:Foo), which typically results in loading code from an installed package.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"However, some modules contain submodules, which means you sometimes need to access a non-top-level module. There are two ways to do this. The first is to use an absolute path, for example using Base.Sort. The second is to use a relative path, which makes it easier to import submodules of the current module or any of its enclosing modules:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"module Parent\n\nmodule Utils\n...\nend\n\nusing .Utils\n\n...\nend","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Here module Parent contains a submodule Utils, and code in Parent wants the contents of Utils to be visible. This is done by starting the using path with a period. Adding more leading periods moves up additional levels in the module hierarchy. For example using ..Utils would look for Utils in Parent's enclosing module rather than in Parent itself.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Note that relative-import qualifiers are only valid in using and import statements.","category":"page"},{"location":"manual/modules.html#Namespace-miscellanea-1","page":"Modules","title":"Namespace miscellanea","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"If a name is qualified (e.g. Base.sin), then it can be accessed even if it is not exported. This is often useful when debugging. It can also have methods added to it by using the qualified name as the function name. However, due to syntactic ambiguities that arise, if you wish to add methods to a function in a different module whose name contains only symbols, such as an operator, Base.+ for example, you must use Base.:+ to refer to it. If the operator is more than one character in length you must surround it in brackets, such as: Base.:(==).","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Macro names are written with @ in import and export statements, e.g. import Mod.@mac. Macros in other modules can be invoked as Mod.@mac or @Mod.mac.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The syntax M.x = y does not work to assign a global in another module; global assignment is always module-local.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"A variable name can be \"reserved\" without assigning to it by declaring it as global x. This prevents name conflicts for globals initialized after load time.","category":"page"},{"location":"manual/modules.html#Module-initialization-and-precompilation-1","page":"Modules","title":"Module initialization and precompilation","text":"","category":"section"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Large modules can take several seconds to load because executing all of the statements in a module often involves compiling a large amount of code. Julia creates precompiled caches of the module to reduce this time.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"The incremental precompiled module file are created and used automatically when using import or using to load a module.  This will cause it to be automatically compiled the first time it is imported. Alternatively, you can manually call Base.compilecache(modulename). The resulting cache files will be stored in DEPOT_PATH[1]/compiled/. Subsequently, the module is automatically recompiled upon using or import whenever any of its dependencies change; dependencies are modules it imports, the Julia build, files it includes, or explicit dependencies declared by include_dependency(path) in the module file(s).","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"For file dependencies, a change is determined by examining whether the modification time (mtime) of each file loaded by include or added explicitly by include_dependency is unchanged, or equal to the modification time truncated to the nearest second (to accommodate systems that can't copy mtime with sub-second accuracy). It also takes into account whether the path to the file chosen by the search logic in require matches the path that had created the precompile file. It also takes into account the set of dependencies already loaded into the current process and won't recompile those modules, even if their files change or disappear, in order to avoid creating incompatibilities between the running system and the precompile cache.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"If you know that a module is not safe to precompile your module (for example, for one of the reasons described below), you should put __precompile__(false) in the module file (typically placed at the top). This will cause Base.compilecache to throw an error, and will cause using / import to load it directly into the current process and skip the precompile and caching. This also thereby prevents the module from being imported by any other precompiled module.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"You may need to be aware of certain behaviors inherent in the creation of incremental shared libraries which may require care when writing your module. For example, external state is not preserved. To accommodate this, explicitly separate any initialization steps that must occur at runtime from steps that can occur at compile time. For this purpose, Julia allows you to define an __init__() function in your module that executes any initialization steps that must occur at runtime. This function will not be called during compilation (--output-*). Effectively, you can assume it will be run exactly once in the lifetime of the code. You may, of course, call it manually if necessary, but the default is to assume this function deals with computing state for the local machine, which does not need to be – or even should not be – captured in the compiled image. It will be called after the module is loaded into a process, including if it is being loaded into an incremental compile (--output-incremental=yes), but not if it is being loaded into a full-compilation process.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"In particular, if you define a function __init__() in a module, then Julia will call __init__() immediately after the module is loaded (e.g., by import, using, or require) at runtime for the first time (i.e., __init__ is only called once, and only after all statements in the module have been executed). Because it is called after the module is fully imported, any submodules or other imported modules have their __init__ functions called before the __init__ of the enclosing module.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Two typical uses of __init__ are calling runtime initialization functions of external C libraries and initializing global constants that involve pointers returned by external libraries.  For example, suppose that we are calling a C library libfoo that requires us to call a foo_init() initialization function at runtime. Suppose that we also want to define a global constant foo_data_ptr that holds the return value of a void *foo_data() function defined by libfoo – this constant must be initialized at runtime (not at compile time) because the pointer address will change from run to run.  You could accomplish this by defining the following __init__ function in your module:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"const foo_data_ptr = Ref{Ptr{Cvoid}}(0)\nfunction __init__()\n    ccall((:foo_init, :libfoo), Cvoid, ())\n    foo_data_ptr[] = ccall((:foo_data, :libfoo), Ptr{Cvoid}, ())\n    nothing\nend","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Notice that it is perfectly possible to define a global inside a function like __init__; this is one of the advantages of using a dynamic language. But by making it a constant at global scope, we can ensure that the type is known to the compiler and allow it to generate better optimized code. Obviously, any other globals in your module that depends on foo_data_ptr would also have to be initialized in __init__.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Constants involving most Julia objects that are not produced by ccall do not need to be placed in __init__: their definitions can be precompiled and loaded from the cached module image. This includes complicated heap-allocated objects like arrays. However, any routine that returns a raw pointer value must be called at runtime for precompilation to work (Ptr objects will turn into null pointers unless they are hidden inside an isbits object). This includes the return values of the Julia functions cfunction and pointer.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Dictionary and set types, or in general anything that depends on the output of a hash(key) method, are a trickier case.  In the common case where the keys are numbers, strings, symbols, ranges, Expr, or compositions of these types (via arrays, tuples, sets, pairs, etc.) they are safe to precompile.  However, for a few other key types, such as Function or DataType and generic user-defined types where you haven't defined a hash method, the fallback hash method depends on the memory address of the object (via its objectid) and hence may change from run to run. If you have one of these key types, or if you aren't sure, to be safe you can initialize this dictionary from within your __init__ function. Alternatively, you can use the IdDict dictionary type, which is specially handled by precompilation so that it is safe to initialize at compile-time.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"When using precompilation, it is important to keep a clear sense of the distinction between the compilation phase and the execution phase. In this mode, it will often be much more clearly apparent that Julia is a compiler which allows execution of arbitrary Julia code, not a standalone interpreter that also generates compiled code.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Other known potential failure scenarios include:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Global counters (for example, for attempting to uniquely identify objects). Consider the following code snippet:\nmutable struct UniquedById\n    myid::Int\n    let counter = 0\n        UniquedById() = new(counter += 1)\n    end\nend\nwhile the intent of this code was to give every instance a unique id, the counter value is recorded at the end of compilation. All subsequent usages of this incrementally compiled module will start from that same counter value.\nNote that objectid (which works by hashing the memory pointer) has similar issues (see notes on Dict usage below).\nOne alternative is to use a macro to capture @__MODULE__ and store it alone with the current counter value, however, it may be better to redesign the code to not depend on this global state.\nAssociative collections (such as Dict and Set) need to be re-hashed in __init__. (In the future, a mechanism may be provided to register an initializer function.)\nDepending on compile-time side-effects persisting through load-time. Example include: modifying arrays or other variables in other Julia modules; maintaining handles to open files or devices; storing pointers to other system resources (including memory);\nCreating accidental \"copies\" of global state from another module, by referencing it directly instead of via its lookup path. For example, (in global scope):\n#mystdout = Base.stdout #= will not work correctly, since this will copy Base.stdout into this module =#\n# instead use accessor functions:\ngetstdout() = Base.stdout #= best option =#\n# or move the assignment into the runtime:\n__init__() = global mystdout = Base.stdout #= also works =#","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Several additional restrictions are placed on the operations that can be done while precompiling code to help the user avoid other wrong-behavior situations:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"Calling eval to cause a side-effect in another module. This will also cause a warning to be emitted when the incremental precompile flag is set.\nglobal const statements from local scope after __init__() has been started (see issue #12010 for plans to add an error for this)\nReplacing a module is a runtime error while doing an incremental precompile.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"A few other points to be aware of:","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"No code reload / cache invalidation is performed after changes are made to the source files themselves, (including by Pkg.update), and no cleanup is done after Pkg.rm\nThe memory sharing behavior of a reshaped array is disregarded by precompilation (each view gets its own copy)\nExpecting the filesystem to be unchanged between compile-time and runtime e.g. @__FILE__/source_path() to find resources at runtime, or the BinDeps @checked_lib macro. Sometimes this is unavoidable. However, when possible, it can be good practice to copy resources into the module at compile-time so they won't need to be found at runtime.\nWeakRef objects and finalizers are not currently handled properly by the serializer (this will be fixed in an upcoming release).\nIt is usually best to avoid capturing references to instances of internal metadata objects such as Method, MethodInstance, MethodTable, TypeMapLevel, TypeMapEntry and fields of those objects, as this can confuse the serializer and may not lead to the outcome you desire. It is not necessarily an error to do this, but you simply need to be prepared that the system will try to copy some of these and to create a single unique instance of others.","category":"page"},{"location":"manual/modules.html#","page":"Modules","title":"Modules","text":"It is sometimes helpful during module development to turn off incremental precompilation. The command line flag --compiled-modules={yes|no} enables you to toggle module precompilation on and off. When Julia is started with --compiled-modules=no the serialized modules in the compile cache are ignored when loading modules and module dependencies. Base.compilecache can still be called manually. The state of this command line flag is passed to Pkg.build to disable automatic precompilation triggering when installing, updating, and explicitly building packages.","category":"page"},{"location":"manual/documentation.html#Documentation-1","page":"Documentation","title":"Documentation","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Julia enables package developers and users to document functions, types and other objects easily via a built-in documentation system since Julia 0.4.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"The basic syntax is simple: any string appearing at the top-level right before an object (function, macro, type or instance) will be interpreted as documenting it (these are called docstrings). Note that no blank lines or comments may intervene between a docstring and the documented object. Here is a basic example:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"Tell whether there are too foo items in the array.\"\nfoo(xs::Array) = ...","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Documentation is interpreted as Markdown, so you can use indentation and code fences to delimit code examples from text. Technically, any object can be associated with any other as metadata; Markdown happens to be the default, but one can construct other string macros and pass them to the @doc macro just as well.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"note: Note\nMarkdown support is implemented in the Markdown standard library and for a full list of supported syntax see the documentation.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Here is a more complex example, still using Markdown:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"\"\"\n    bar(x[, y])\n\nCompute the Bar index between `x` and `y`. If `y` is missing, compute\nthe Bar index between all pairs of columns of `x`.\n\n# Examples\n```julia-repl\njulia> bar([1, 2], [1, 2])\n1\n```\n\"\"\"\nfunction bar(x, y) ...","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"As in the example above, we recommend following some simple conventions when writing documentation:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Always show the signature of a function at the top of the documentation, with a four-space indent so that it is printed as Julia code.\nThis can be identical to the signature present in the Julia code (like mean(x::AbstractArray)), or a simplified form. Optional arguments should be represented with their default values (i.e. f(x, y=1)) when possible, following the actual Julia syntax. Optional arguments which do not have a default value should be put in brackets (i.e. f(x[, y]) and f(x[, y[, z]])). An alternative solution is to use several lines: one without optional arguments, the other(s) with them. This solution can also be used to document several related methods of a given function. When a function accepts many keyword arguments, only include a <keyword arguments> placeholder in the signature (i.e. f(x; <keyword arguments>)), and give the complete list under an # Arguments section (see point 4 below).\nInclude a single one-line sentence describing what the function does or what the object represents after the simplified signature block. If needed, provide more details in a second paragraph, after a blank line.\nThe one-line sentence should use the imperative form (\"Do this\", \"Return that\") instead of the third person (do not write \"Returns the length...\") when documenting functions. It should end with a period. If the meaning of a function cannot be summarized easily, splitting it into separate composable parts could be beneficial (this should not be taken as an absolute requirement for every single case though).\nDo not repeat yourself.\nSince the function name is given by the signature, there is no need to start the documentation with \"The function bar...\": go straight to the point. Similarly, if the signature specifies the types of the arguments, mentioning them in the description is redundant.\nOnly provide an argument list when really necessary.\nFor simple functions, it is often clearer to mention the role of the arguments directly in the description of the function's purpose. An argument list would only repeat information already provided elsewhere. However, providing an argument list can be a good idea for complex functions with many arguments (in particular keyword arguments). In that case, insert it after the general description of the function, under an # Arguments header, with one - bullet for each argument. The list should mention the types and default values (if any) of the arguments:\n\"\"\"\n...\n# Arguments\n- `n::Integer`: the number of elements to compute.\n- `dim::Integer=1`: the dimensions along which to perform the computation.\n...\n\"\"\"\nProvide hints to related functions.\nSometimes there are functions of related functionality. To increase discoverability please provide a short list of these in a See also: paragraph.\nSee also: [`bar!`](@ref), [`baz`](@ref), [`baaz`](@ref)\nInclude any code examples in an # Examples section.\nExamples should, whenever possible, be written as doctests. A doctest is a fenced code block (see Code blocks) starting with ```jldoctest and contains any number of julia> prompts together with inputs and expected outputs that mimic the Julia REPL.\nnote: Note\nDoctests are enabled by Documenter.jl. For more detailed documentation see Documenter's manual.\nFor example in the following docstring a variable a is defined and the expected result, as printed in a Julia REPL, appears afterwards:\n\"\"\"\nSome nice documentation here.\n\n# Examples\n```jldoctest\njulia> a = [1 2; 3 4]\n2×2 Array{Int64,2}:\n 1  2\n 3  4\n```\n\"\"\"\nwarning: Warning\nCalling rand and other RNG-related functions should be avoided in doctests since they will not produce consistent outputs during different Julia sessions. If you would like to show some random number generation related functionality, one option is to explicitly construct and seed your own MersenneTwister (or other pseudorandom number generator) and pass it to the functions you are doctesting.Operating system word size (Int32 or Int64) as well as path separator differences (/ or \\) will also affect the reproducibility of some doctests.Note that whitespace in your doctest is significant! The doctest will fail if you misalign the output of pretty-printing an array, for example.\nYou can then run make -C doc doctest=true to run all the doctests in the Julia Manual and API documentation, which will ensure that your example works.\nTo indicate that the output result is truncated, you may write [...] at the line where checking should stop. This is useful to hide a stacktrace (which contains non-permanent references to lines of julia code) when the doctest shows that an exception is thrown, for example:\n```jldoctest\njulia> div(1, 0)\nERROR: DivideError: integer division error\n[...]\n```\nExamples that are untestable should be written within fenced code blocks starting with ```julia so that they are highlighted correctly in the generated documentation.\ntip: Tip\nWherever possible examples should be self-contained and runnable so that readers are able to try them out without having to include any dependencies.\nUse backticks to identify code and equations.\nJulia identifiers and code excerpts should always appear between backticks ` to enable highlighting. Equations in the LaTeX syntax can be inserted between double backticks ``. Use Unicode characters rather than their LaTeX escape sequence, i.e. ``α = 1`` rather than ``\\\\alpha = 1``.\nPlace the starting and ending \"\"\" characters on lines by themselves.\nThat is, write:\n\"\"\"\n...\n\n...\n\"\"\"\nf(x, y) = ...\nrather than:\n\"\"\"...\n\n...\"\"\"\nf(x, y) = ...\nThis makes it more clear where docstrings start and end.\nRespect the line length limit used in the surrounding code.\nDocstrings are edited using the same tools as code. Therefore, the same conventions should apply. It is advised to add line breaks after 92 characters.\nProvide information allowing custom types to implement the function in an # Implementation section. These implementation details intended for developers rather than users, explaining e.g. which functions should be overridden and which functions automatically use appropriate fallbacks, are better kept separate from the main description of the function's behavior.","category":"page"},{"location":"manual/documentation.html#Accessing-Documentation-1","page":"Documentation","title":"Accessing Documentation","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Documentation can be accessed at the REPL or in IJulia by typing ? followed by the name of a function or macro, and pressing Enter. For example,","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"?cos\n?@time\n?r\"\"","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"will bring up docs for the relevant function, macro or string macro respectively. In Juno using Ctrl-J, Ctrl-D will bring up documentation for the object under the cursor.","category":"page"},{"location":"manual/documentation.html#Functions-and-Methods-1","page":"Documentation","title":"Functions & Methods","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Functions in Julia may have multiple implementations, known as methods. While it's good practice for generic functions to have a single purpose, Julia allows methods to be documented individually if necessary. In general, only the most generic method should be documented, or even the function itself (i.e. the object created without any methods by function bar end). Specific methods should only be documented if their behaviour differs from the more generic ones. In any case, they should not repeat the information provided elsewhere. For example:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"\"\"\n    *(x, y, z...)\n\nMultiplication operator. `x * y * z *...` calls this function with multiple\narguments, i.e. `*(x, y, z...)`.\n\"\"\"\nfunction *(x, y, z...)\n    # ... [implementation sold separately] ...\nend\n\n\"\"\"\n    *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\nWhen applied to strings, concatenates them.\n\"\"\"\nfunction *(x::AbstractString, y::AbstractString, z::AbstractString...)\n    # ... [insert secret sauce here] ...\nend\n\nhelp?> *\nsearch: * .*\n\n  *(x, y, z...)\n\n  Multiplication operator. x * y * z *... calls this function with multiple\n  arguments, i.e. *(x,y,z...).\n\n  *(x::AbstractString, y::AbstractString, z::AbstractString...)\n\n  When applied to strings, concatenates them.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"When retrieving documentation for a generic function, the metadata for each method is concatenated with the catdoc function, which can of course be overridden for custom types.","category":"page"},{"location":"manual/documentation.html#Advanced-Usage-1","page":"Documentation","title":"Advanced Usage","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"The @doc macro associates its first argument with its second in a per-module dictionary called META. By default, documentation is expected to be written in Markdown, and the doc\"\" string macro simply creates an object representing the Markdown content. In the future it is likely to do more advanced things such as allowing for relative image or link paths.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"To make it easier to write documentation, the parser treats the macro name @doc specially: if a call to @doc has one argument, but another expression appears after a single line break, then that additional expression is added as an argument to the macro. Therefore the following syntax is parsed as a 2-argument call to @doc:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"@doc raw\"\"\"\n...\n\"\"\"\nf(x) = x","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"This makes it easy to use an arbitrary object (here a raw string) as a docstring.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"When used for retrieving documentation, the @doc macro (or equally, the doc function) will search all META dictionaries for metadata relevant to the given object and return it. The returned object (some Markdown content, for example) will by default display itself intelligently. This design also makes it easy to use the doc system in a programmatic way; for example, to re-use documentation between different versions of a function:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"@doc \"...\" foo!\n@doc (@doc foo!) foo","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Or for use with Julia's metaprogramming functionality:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"for (f, op) in ((:add, :+), (:subtract, :-), (:multiply, :*), (:divide, :/))\n    @eval begin\n        $f(a,b) = $op(a,b)\n    end\nend\n@doc \"`add(a,b)` adds `a` and `b` together\" add\n@doc \"`subtract(a,b)` subtracts `b` from `a`\" subtract","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Documentation written in non-toplevel blocks, such as begin, if, for, and let, is added to the documentation system as blocks are evaluated. For example:","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"if condition()\n    \"...\"\n    f(x) = x\nend","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"will add documentation to f(x) when condition() is true. Note that even if f(x) goes out of scope at the end of the block, its documentation will remain.","category":"page"},{"location":"manual/documentation.html#Dynamic-documentation-1","page":"Documentation","title":"Dynamic documentation","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Sometimes the appropriate documentation for an instance of a type depends on the field values of that instance, rather than just on the type itself. In these cases, you can add a method to Docs.getdoc for your custom type that returns the documentation on a per-instance basis. For instance,","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"struct MyType\n    value::String\nend\n\nDocs.getdoc(t::MyType) = \"Documentation for MyType with value $(t.value)\"\n\nx = MyType(\"x\")\ny = MyType(\"y\")","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"?x will display \"Documentation for MyType with value x\" while ?y will display \"Documentation for MyType with value y\".","category":"page"},{"location":"manual/documentation.html#Syntax-Guide-1","page":"Documentation","title":"Syntax Guide","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"A comprehensive overview of all documentable Julia syntax.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"In the following examples \"...\" is used to illustrate an arbitrary docstring.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"doc\"\" should only be used when the docstring contains $ or \\ characters that should not be parsed by Julia such as LaTeX syntax or Julia source code examples containing interpolation.","category":"page"},{"location":"manual/documentation.html#Functions-and-Methods-2","page":"Documentation","title":"Functions and Methods","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nfunction f end\n\n\"...\"\nf","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the function f. The first version is the preferred syntax, however both are equivalent.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nf(x) = x\n\n\"...\"\nfunction f(x)\n    x\nend\n\n\"...\"\nf(x)","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the method f(::Any).","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nf(x, y = 1) = x + y","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to two Methods, namely f(::Any) and f(::Any, ::Any).","category":"page"},{"location":"manual/documentation.html#Macros-1","page":"Documentation","title":"Macros","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nmacro m(x) end","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the @m(::Any) macro definition.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\n:(@m)","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the macro named @m.","category":"page"},{"location":"manual/documentation.html#Types-1","page":"Documentation","title":"Types","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nabstract type T1 end\n\n\"...\"\nmutable struct T2\n    ...\nend\n\n\"...\"\nstruct T3\n    ...\nend","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds the docstring \"...\" to types T1, T2, and T3.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nstruct T\n    \"x\"\n    x\n    \"y\"\n    y\nend","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to type T, \"x\" to field T.x and \"y\" to field T.y. Also applicable to mutable struct types.","category":"page"},{"location":"manual/documentation.html#Modules-1","page":"Documentation","title":"Modules","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nmodule M end\n\nmodule M\n\n\"...\"\nM\n\nend","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the ModuleM. Adding the docstring above the Module is the preferred syntax, however both are equivalent.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nbaremodule M\n# ...\nend\n\nbaremodule M\n\nimport Base: @doc\n\n\"...\"\nf(x) = x\n\nend","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Documenting a baremodule by placing a docstring above the expression automatically imports @doc into the module. These imports must be done manually when the module expression is not documented. Empty baremodules cannot be documented.","category":"page"},{"location":"manual/documentation.html#Global-Variables-1","page":"Documentation","title":"Global Variables","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nconst a = 1\n\n\"...\"\nb = 2\n\n\"...\"\nglobal c = 3","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the Bindings a, b, and c.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Bindings are used to store a reference to a particular Symbol in a Module without storing the referenced value itself.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"note: Note\nWhen a const definition is only used to define an alias of another definition, such as is the case with the function div and its alias ÷ in Base, do not document the alias and instead document the actual function.If the alias is documented and not the real definition then the docsystem (? mode) will not return the docstring attached to the alias when the real definition is searched for.For example you should write\"...\"\nf(x) = x + 1\nconst alias = frather thanf(x) = x + 1\n\"...\"\nconst alias = f","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\nsym","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to the value associated with sym. Users should prefer documenting sym at its definition.","category":"page"},{"location":"manual/documentation.html#Multiple-Objects-1","page":"Documentation","title":"Multiple Objects","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\na, b","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to a and b each of which should be a documentable expression. This syntax is equivalent to","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\na\n\n\"...\"\nb","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Any number of expressions many be documented together in this way. This syntax can be useful when two functions are related, such as non-mutating and mutating versions f and f!.","category":"page"},{"location":"manual/documentation.html#Macro-generated-code-1","page":"Documentation","title":"Macro-generated code","text":"","category":"section"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"\"...\"\n@m expression","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Adds docstring \"...\" to expression generated by expanding @m expression. This allows for expressions decorated with @inline, @noinline, @generated, or any other macro to be documented in the same way as undecorated expressions.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Macro authors should take note that only macros that generate a single expression will automatically support docstrings. If a macro returns a block containing multiple subexpressions then the subexpression that should be documented must be marked using the @__doc__ macro.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"The @enum macro makes use of @__doc__ to allow for documenting Enums. Examining its definition should serve as an example of how to use @__doc__ correctly.","category":"page"},{"location":"manual/documentation.html#","page":"Documentation","title":"Documentation","text":"Core.@__doc__","category":"page"},{"location":"manual/documentation.html#Core.@__doc__","page":"Documentation","title":"Core.@__doc__","text":"@__doc__(ex)\n\nLow-level macro used to mark expressions returned by a macro that should be documented. If more than one expression is marked then the same docstring is applied to each expression.\n\nmacro example(f)\n    quote\n        $(f)() = 0\n        @__doc__ $(f)(x) = 1\n        $(f)(x, y) = 2\n    end |> esc\nend\n\n@__doc__ has no effect when a macro that uses it is not documented.\n\n\n\n\n\n","category":"macro"},{"location":"manual/metaprogramming.html#Metaprogramming-1","page":"Metaprogramming","title":"Metaprogramming","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The strongest legacy of Lisp in the Julia language is its metaprogramming support. Like Lisp, Julia represents its own code as a data structure of the language itself. Since code is represented by objects that can be created and manipulated from within the language, it is possible for a program to transform and generate its own code. This allows sophisticated code generation without extra build steps, and also allows true Lisp-style macros operating at the level of abstract syntax trees. In contrast, preprocessor \"macro\" systems, like that of C and C++, perform textual manipulation and substitution before any actual parsing or interpretation occurs. Because all data types and code in Julia are represented by Julia data structures, powerful reflection capabilities are available to explore the internals of a program and its types just like any other data.","category":"page"},{"location":"manual/metaprogramming.html#Program-representation-1","page":"Metaprogramming","title":"Program representation","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Every Julia program starts life as a string:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> prog = \"1 + 1\"\n\"1 + 1\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"What happens next?","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The next step is to parse each string into an object called an expression, represented by the Julia type Expr:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1 = Meta.parse(prog)\n:(1 + 1)\n\njulia> typeof(ex1)\nExpr","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Expr objects contain two parts:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"a Symbol identifying the kind of expression. A symbol is an interned string identifier (more discussion below).","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1.head\n:call","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"the expression arguments, which may be symbols, other expressions, or literal values:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1.args\n3-element Array{Any,1}:\n  :+\n 1\n 1","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Expressions may also be constructed directly in prefix notation:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex2 = Expr(:call, :+, 1, 1)\n:(1 + 1)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The two expressions constructed above – by parsing and by direct construction – are equivalent:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex1 == ex2\ntrue","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The key point here is that Julia code is internally represented as a data structure that is accessible from the language itself.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The dump function provides indented and annotated display of Expr objects:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(ex2)\nExpr\n  head: Symbol call\n  args: Array{Any}((3,))\n    1: Symbol +\n    2: Int64 1\n    3: Int64 1","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Expr objects may also be nested:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex3 = Meta.parse(\"(4 + 4) / 2\")\n:((4 + 4) / 2)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Another way to view expressions is with Meta.show_sexpr, which displays the S-expression form of a given Expr, which may look very familiar to users of Lisp. Here's an example illustrating the display on a nested Expr:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> Meta.show_sexpr(ex3)\n(:call, :/, (:call, :+, 4, 4), 2)","category":"page"},{"location":"manual/metaprogramming.html#Symbols-1","page":"Metaprogramming","title":"Symbols","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The : character has two syntactic purposes in Julia. The first form creates a Symbol, an interned string used as one building-block of expressions:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :foo\n:foo\n\njulia> typeof(ans)\nSymbol","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The Symbol constructor takes any number of arguments and creates a new symbol by concatenating their string representations together:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :foo == Symbol(\"foo\")\ntrue\n\njulia> Symbol(\"func\",10)\n:func10\n\njulia> Symbol(:var,'_',\"sym\")\n:var_sym","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In the context of an expression, symbols are used to indicate access to variables; when an expression is evaluated, a symbol is replaced with the value bound to that symbol in the appropriate scope.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Sometimes extra parentheses around the argument to : are needed to avoid ambiguity in parsing:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :(:)\n:(:)\n\njulia> :(::)\n:(::)","category":"page"},{"location":"manual/metaprogramming.html#Expressions-and-evaluation-1","page":"Metaprogramming","title":"Expressions and evaluation","text":"","category":"section"},{"location":"manual/metaprogramming.html#Quoting-1","page":"Metaprogramming","title":"Quoting","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The second syntactic purpose of the : character is to create expression objects without using the explicit Expr constructor. This is referred to as quoting. The : character, followed by paired parentheses around a single statement of Julia code, produces an Expr object based on the enclosed code. Here is example of the short form used to quote an arithmetic expression:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(a+b*c+1)\n:(a + b * c + 1)\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"(to view the structure of this expression, try ex.head and ex.args, or use dump as above or Meta.@dump)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Note that equivalent expressions may be constructed using Meta.parse or the direct Expr form:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia>      :(a + b*c + 1)       ==\n       Meta.parse(\"a + b*c + 1\") ==\n       Expr(:call, :+, :a, Expr(:call, :*, :b, :c), 1)\ntrue","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Expressions provided by the parser generally only have symbols, other expressions, and literal values as their args, whereas expressions constructed by Julia code can have arbitrary run-time values without literal forms as args. In this specific example, + and a are symbols, *(b,c) is a subexpression, and 1 is a literal 64-bit signed integer.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"There is a second syntactic form of quoting for multiple expressions: blocks of code enclosed in quote ... end.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = quote\n           x = 1\n           y = 2\n           x + y\n       end\nquote\n    #= none:2 =#\n    x = 1\n    #= none:3 =#\n    y = 2\n    #= none:4 =#\n    x + y\nend\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html#Interpolation-1","page":"Metaprogramming","title":"Interpolation","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Direct construction of Expr objects with value arguments is powerful, but Expr constructors can be tedious compared to \"normal\" Julia syntax. As an alternative, Julia allows interpolation of literals or expressions into quoted expressions. Interpolation is indicated by a prefix $.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In this example, the value of variable a is interpolated:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> a = 1;\n\njulia> ex = :($a + b)\n:(1 + b)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Interpolating into an unquoted expression is not supported and will cause a compile-time error:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> $a + b\nERROR: syntax: \"$\" expression outside quote","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In this example, the tuple (1,2,3) is interpolated as an expression into a conditional test:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(a in $:((1,2,3)) )\n:(a in (1, 2, 3))","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The use of $ for expression interpolation is intentionally reminiscent of string interpolation and command interpolation. Expression interpolation allows convenient, readable programmatic construction of complex Julia expressions.","category":"page"},{"location":"manual/metaprogramming.html#Splatting-interpolation-1","page":"Metaprogramming","title":"Splatting interpolation","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that the $ interpolation syntax allows inserting only a single expression into an enclosing expression. Occasionally, you have an array of expressions and need them all to become arguments of the surrounding expression. This can be done with the syntax $(xs...). For example, the following code generates a function call where the number of arguments is determined programmatically:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> args = [:x, :y, :z];\n\njulia> :(f(1, $(args...)))\n:(f(1, x, y, z))","category":"page"},{"location":"manual/metaprogramming.html#Nested-quote-1","page":"Metaprogramming","title":"Nested quote","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Naturally, it is possible for quote expressions to contain other quote expressions. Understanding how interpolation works in these cases can be a bit tricky. Consider this example:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = :(1 + 2);\n\njulia> e = quote quote $x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :x))\nend))\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that the result contains Expr(:$, :x), which means that x has not been evaluated yet. In other words, the $ expression \"belongs to\" the inner quote expression, and so its argument is only evaluated when the inner quote expression is:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    1 + 2\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"However, the outer quote expression is able to interpolate values inside the $ in the inner quote. This is done with multiple $s:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> e = quote quote $$x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :(1 + 2)))\nend))\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that :(1 + 2) now appears in the result instead of the symbol :x. Evaluating this expression yields an interpolated 3:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    3\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The intuition behind this behavior is that x is evaluated once for each $: one $ works similarly to eval(:x), giving x's value, while two $s do the equivalent of eval(eval(:x)).","category":"page"},{"location":"manual/metaprogramming.html#QuoteNode-1","page":"Metaprogramming","title":"QuoteNode","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The usual representation of a quote form in an AST is an Expr with head :quote:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(Meta.parse(\":(1+2)\"))\nExpr\n  head: Symbol quote\n  args: Array{Any}((1,))\n    1: Expr\n      head: Symbol call\n      args: Array{Any}((3,))\n        1: Symbol +\n        2: Int64 1\n        3: Int64 2","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"As we have seen, such expressions support interpolation with $. However, in some situations it is necessary to quote code without performing interpolation. This kind of quoting does not yet have syntax, but is represented internally as an object of type QuoteNode. The parser yields QuoteNodes for simple quoted items like symbols:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> dump(Meta.parse(\":x\"))\nQuoteNode\n  value: Symbol x","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"QuoteNode can also be used for certain advanced metaprogramming tasks.","category":"page"},{"location":"manual/metaprogramming.html#[eval](@ref)-and-effects-1","page":"Metaprogramming","title":"eval and effects","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Given an expression object, one can cause Julia to evaluate (execute) it at global scope using eval:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> :(1 + 2)\n:(1 + 2)\n\njulia> eval(ans)\n3\n\njulia> ex = :(a + b)\n:(a + b)\n\njulia> eval(ex)\nERROR: UndefVarError: b not defined\n[...]\n\njulia> a = 1; b = 2;\n\njulia> eval(ex)\n3","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Every module has its own eval function that evaluates expressions in its global scope. Expressions passed to eval are not limited to returning values – they can also have side-effects that alter the state of the enclosing module's environment:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = :(x = 1)\n:(x = 1)\n\njulia> x\nERROR: UndefVarError: x not defined\n\njulia> eval(ex)\n1\n\njulia> x\n1","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Here, the evaluation of an expression object causes a value to be assigned to the global variable x.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Since expressions are just Expr objects which can be constructed programmatically and then evaluated, it is possible to dynamically generate arbitrary code which can then be run using eval. Here is a simple example:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> a = 1;\n\njulia> ex = Expr(:call, :+, a, :b)\n:(1 + b)\n\njulia> a = 0; b = 2;\n\njulia> eval(ex)\n3","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The value of a is used to construct the expression ex which applies the + function to the value 1 and the variable b. Note the important distinction between the way a and b are used:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The value of the variable a at expression construction time is used as an immediate value in the expression. Thus, the value of a when the expression is evaluated no longer matters: the value in the expression is already 1, independent of whatever the value of a might be.\nOn the other hand, the symbol :b is used in the expression construction, so the value of the variable b at that time is irrelevant – :b is just a symbol and the variable b need not even be defined. At expression evaluation time, however, the value of the symbol :b is resolved by looking up the value of the variable b.","category":"page"},{"location":"manual/metaprogramming.html#Functions-on-Expressions-1","page":"Metaprogramming","title":"Functions on Expressions","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"As hinted above, one extremely useful feature of Julia is the capability to generate and manipulate Julia code within Julia itself. We have already seen one example of a function returning Expr objects: the parse function, which takes a string of Julia code and returns the corresponding Expr. A function can also take one or more Expr objects as arguments, and return another Expr. Here is a simple, motivating example:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function math_expr(op, op1, op2)\n           expr = Expr(:call, op, op1, op2)\n           return expr\n       end\nmath_expr (generic function with 1 method)\n\njulia>  ex = math_expr(:+, 1, Expr(:call, :*, 4, 5))\n:(1 + 4 * 5)\n\njulia> eval(ex)\n21","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"As another example, here is a function that doubles any numeric argument, but leaves expressions alone:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function make_expr2(op, opr1, opr2)\n           opr1f, opr2f = map(x -> isa(x, Number) ? 2*x : x, (opr1, opr2))\n           retexpr = Expr(:call, op, opr1f, opr2f)\n           return retexpr\n       end\nmake_expr2 (generic function with 1 method)\n\njulia> make_expr2(:+, 1, 2)\n:(2 + 4)\n\njulia> ex = make_expr2(:+, 1, Expr(:call, :*, 5, 8))\n:(2 + 5 * 8)\n\njulia> eval(ex)\n42","category":"page"},{"location":"manual/metaprogramming.html#man-macros-1","page":"Metaprogramming","title":"Macros","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Macros provide a method to include generated code in the final body of a program. A macro maps a tuple of arguments to a returned expression, and the resulting expression is compiled directly rather than requiring a runtime eval call. Macro arguments may include expressions, literal values, and symbols.","category":"page"},{"location":"manual/metaprogramming.html#Basics-1","page":"Metaprogramming","title":"Basics","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Here is an extraordinarily simple macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro sayhello()\n           return :( println(\"Hello, world!\") )\n       end\n@sayhello (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Macros have a dedicated character in Julia's syntax: the @ (at-sign), followed by the unique name declared in a macro NAME ... end block. In this example, the compiler will replace all instances of @sayhello with:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":":( println(\"Hello, world!\") )","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"When @sayhello is entered in the REPL, the expression executes immediately, thus we only see the evaluation result:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @sayhello()\nHello, world!","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Now, consider a slightly more complex macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro sayhello(name)\n           return :( println(\"Hello, \", $name) )\n       end\n@sayhello (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"This macro takes one argument: name. When @sayhello is encountered, the quoted expression is expanded to interpolate the value of the argument into the final expression:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @sayhello(\"human\")\nHello, human","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"We can view the quoted return expression using the function macroexpand (important note: this is an extremely useful tool for debugging macros):","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> ex = macroexpand(Main, :(@sayhello(\"human\")) )\n:(Main.println(\"Hello, \", \"human\"))\n\njulia> typeof(ex)\nExpr","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"We can see that the \"human\" literal has been interpolated into the expression.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"There also exists a macro @macroexpand that is perhaps a bit more convenient than the macroexpand function:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @macroexpand @sayhello \"human\"\n:(println(\"Hello, \", \"human\"))","category":"page"},{"location":"manual/metaprogramming.html#Hold-up:-why-macros?-1","page":"Metaprogramming","title":"Hold up: why macros?","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"We have already seen a function f(::Expr...) -> Expr in a previous section. In fact, macroexpand is also such a function. So, why do macros exist?","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Macros are necessary because they execute when code is parsed, therefore, macros allow the programmer to generate and include fragments of customized code before the full program is run. To illustrate the difference, consider the following example:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro twostep(arg)\n           println(\"I execute at parse time. The argument is: \", arg)\n           return :(println(\"I execute at runtime. The argument is: \", $arg))\n       end\n@twostep (macro with 1 method)\n\njulia> ex = macroexpand(Main, :(@twostep :(1, 2, 3)) );\nI execute at parse time. The argument is: $(Expr(:quote, :((1, 2, 3))))","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The first call to println is executed when macroexpand is called. The resulting expression contains only the second println:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> typeof(ex)\nExpr\n\njulia> ex\n:(println(\"I execute at runtime. The argument is: \", $(Expr(:copyast, :($(QuoteNode(:((1, 2, 3)))))))))\n\njulia> eval(ex)\nI execute at runtime. The argument is: (1, 2, 3)","category":"page"},{"location":"manual/metaprogramming.html#Macro-invocation-1","page":"Metaprogramming","title":"Macro invocation","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Macros are invoked with the following general syntax:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"@name expr1 expr2 ...\n@name(expr1, expr2, ...)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Note the distinguishing @ before the macro name and the lack of commas between the argument expressions in the first form, and the lack of whitespace after @name in the second form. The two styles should not be mixed. For example, the following syntax is different from the examples above; it passes the tuple (expr1, expr2, ...) as one argument to the macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"@name (expr1, expr2, ...)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"An alternative way to invoke a macro over an array literal (or comprehension) is to juxtapose both without using parentheses. In this case, the array will be the only expression fed to the macro. The following syntax is equivalent (and different from @name [a b] * v):","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"@name[a b] * v\n@name([a b]) * v","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"It is important to emphasize that macros receive their arguments as expressions, literals, or symbols. One way to explore macro arguments is to call the show function within the macro body:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro showarg(x)\n           show(x)\n           # ... remainder of macro, returning an expression\n       end\n@showarg (macro with 1 method)\n\njulia> @showarg(a)\n:a\n\njulia> @showarg(1+1)\n:(1 + 1)\n\njulia> @showarg(println(\"Yo!\"))\n:(println(\"Yo!\"))","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In addition to the given argument list, every macro is passed extra arguments named __source__ and __module__.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The argument __source__ provides information (in the form of a LineNumberNode object) about the parser location of the @ sign from the macro invocation. This allows macros to include better error diagnostic information, and is commonly used by logging, string-parser macros, and docs, for example, as well as to implement the @__LINE__, @__FILE__, and @__DIR__ macros.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The location information can be accessed by referencing __source__.line and __source__.file:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro __LOCATION__(); return QuoteNode(__source__); end\n@__LOCATION__ (macro with 1 method)\n\njulia> dump(\n            @__LOCATION__(\n       ))\nLineNumberNode\n  line: Int64 2\n  file: Symbol none","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The argument __module__ provides information (in the form of a Module object) about the expansion context of the macro invocation. This allows macros to look up contextual information, such as existing bindings, or to insert the value as an extra argument to a runtime function call doing self-reflection in the current module.","category":"page"},{"location":"manual/metaprogramming.html#Building-an-advanced-macro-1","page":"Metaprogramming","title":"Building an advanced macro","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Here is a simplified definition of Julia's @assert macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro assert(ex)\n           return :( $ex ? nothing : throw(AssertionError($(string(ex)))) )\n       end\n@assert (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"This macro can be used like this:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @assert 1 == 1.0\n\njulia> @assert 1 == 0\nERROR: AssertionError: 1 == 0","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In place of the written syntax, the macro call is expanded at parse time to its returned result. This is equivalent to writing:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"1 == 1.0 ? nothing : throw(AssertionError(\"1 == 1.0\"))\n1 == 0 ? nothing : throw(AssertionError(\"1 == 0\"))","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"That is, in the first call, the expression :(1 == 1.0) is spliced into the test condition slot, while the value of string(:(1 == 1.0)) is spliced into the assertion message slot. The entire expression, thus constructed, is placed into the syntax tree where the @assert macro call occurs. Then at execution time, if the test expression evaluates to true, then nothing is returned, whereas if the test is false, an error is raised indicating the asserted expression that was false. Notice that it would not be possible to write this as a function, since only the value of the condition is available and it would be impossible to display the expression that computed it in the error message.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The actual definition of @assert in Julia Base is more complicated. It allows the user to optionally specify their own error message, instead of just printing the failed expression. Just like in functions with a variable number of arguments (Varargs Functions), this is specified with an ellipses following the last argument:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro assert(ex, msgs...)\n           msg_body = isempty(msgs) ? ex : msgs[1]\n           msg = string(msg_body)\n           return :($ex ? nothing : throw(AssertionError($msg)))\n       end\n@assert (macro with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Now @assert has two modes of operation, depending upon the number of arguments it receives! If there's only one argument, the tuple of expressions captured by msgs will be empty and it will behave the same as the simpler definition above. But now if the user specifies a second argument, it is printed in the message body instead of the failing expression. You can inspect the result of a macro expansion with the aptly named @macroexpand macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @macroexpand @assert a == b\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a == b\"))\n    end)\n\njulia> @macroexpand @assert a==b \"a should equal b!\"\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a should equal b!\"))\n    end)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"There is yet another case that the actual @assert macro handles: what if, in addition to printing \"a should equal b,\" we wanted to print their values? One might naively try to use string interpolation in the custom message, e.g., @assert a==b \"a ($a) should equal b ($b)!\", but this won't work as expected with the above macro. Can you see why? Recall from string interpolation that an interpolated string is rewritten to a call to string. Compare:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> typeof(:(\"a should equal b\"))\nString\n\njulia> typeof(:(\"a ($a) should equal b ($b)!\"))\nExpr\n\njulia> dump(:(\"a ($a) should equal b ($b)!\"))\nExpr\n  head: Symbol string\n  args: Array{Any}((5,))\n    1: String \"a (\"\n    2: Symbol a\n    3: String \") should equal b (\"\n    4: Symbol b\n    5: String \")!\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"So now instead of getting a plain string in msg_body, the macro is receiving a full expression that will need to be evaluated in order to display as expected. This can be spliced directly into the returned expression as an argument to the string call; see error.jl for the complete implementation.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The @assert macro makes great use of splicing into quoted expressions to simplify the manipulation of expressions inside the macro body.","category":"page"},{"location":"manual/metaprogramming.html#Hygiene-1","page":"Metaprogramming","title":"Hygiene","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"An issue that arises in more complex macros is that of hygiene. In short, macros must ensure that the variables they introduce in their returned expressions do not accidentally clash with existing variables in the surrounding code they expand into. Conversely, the expressions that are passed into a macro as arguments are often expected to evaluate in the context of the surrounding code, interacting with and modifying the existing variables. Another concern arises from the fact that a macro may be called in a different module from where it was defined. In this case we need to ensure that all global variables are resolved to the correct module. Julia already has a major advantage over languages with textual macro expansion (like C) in that it only needs to consider the returned expression. All the other variables (such as msg in @assert above) follow the normal scoping block behavior.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"To demonstrate these issues, let us consider writing a @time macro that takes an expression as its argument, records the time, evaluates the expression, records the time again, prints the difference between the before and after times, and then has the value of the expression as its final value. The macro might look like this:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(ex)\n    return quote\n        local t0 = time()\n        local val = $ex\n        local t1 = time()\n        println(\"elapsed time: \", t1-t0, \" seconds\")\n        val\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Here, we want t0, t1, and val to be private temporary variables, and we want time to refer to the time function in Julia Base, not to any time variable the user might have (the same applies to println). Imagine the problems that could occur if the user expression ex also contained assignments to a variable called t0, or defined its own time variable. We might get errors, or mysteriously incorrect behavior.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Julia's macro expander solves these problems in the following way. First, variables within a macro result are classified as either local or global. A variable is considered local if it is assigned to (and not declared global), declared local, or used as a function argument name. Otherwise, it is considered global. Local variables are then renamed to be unique (using the gensym function, which generates new symbols), and global variables are resolved within the macro definition environment. Therefore both of the above concerns are handled; the macro's locals will not conflict with any user variables, and time and println will refer to the Julia Base definitions.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"One problem remains however. Consider the following use of this macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"module MyModule\nimport Base.@time\n\ntime() = ... # compute something\n\n@time time()\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Here the user expression ex is a call to time, but not the same time function that the macro uses. It clearly refers to MyModule.time. Therefore we must arrange for the code in ex to be resolved in the macro call environment. This is done by \"escaping\" the expression with esc:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(ex)\n    ...\n    local val = $(esc(ex))\n    ...\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"An expression wrapped in this manner is left alone by the macro expander and simply pasted into the output verbatim. Therefore it will be resolved in the macro call environment.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"This escaping mechanism can be used to \"violate\" hygiene when necessary, in order to introduce or manipulate user variables. For example, the following macro sets x to zero in the call environment:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro zerox()\n           return esc(:(x = 0))\n       end\n@zerox (macro with 1 method)\n\njulia> function foo()\n           x = 1\n           @zerox\n           return x # is zero\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n0","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"This kind of manipulation of variables should be used judiciously, but is occasionally quite handy.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Getting the hygiene rules correct can be a formidable challenge. Before using a macro, you might want to consider whether a function closure would be sufficient. Another useful strategy is to defer as much work as possible to runtime. For example, many macros simply wrap their arguments in a QuoteNode or other similar Expr. Some examples of this include @task body which simply returns schedule(Task(() -> $body)), and @eval expr, which simply returns eval(QuoteNode(expr)).","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"To demonstrate, we might rewrite the @time example above as:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"macro time(expr)\n    return :(timeit(() -> $(esc(expr))))\nend\nfunction timeit(f)\n    t0 = time()\n    val = f()\n    t1 = time()\n    println(\"elapsed time: \", t1-t0, \" seconds\")\n    return val\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"However, we don't do this for a good reason: wrapping the expr in a new scope block (the anonymous function) also slightly changes the meaning of the expression (the scope of any variables in it), while we want @time to be usable with minimum impact on the wrapped code.","category":"page"},{"location":"manual/metaprogramming.html#Macros-and-dispatch-1","page":"Metaprogramming","title":"Macros and dispatch","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Macros, just like Julia functions, are generic. This means they can also have multiple method definitions, thanks to multiple dispatch:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro m end\n@m (macro with 0 methods)\n\njulia> macro m(args...)\n           println(\"$(length(args)) arguments\")\n       end\n@m (macro with 1 method)\n\njulia> macro m(x,y)\n           println(\"Two arguments\")\n       end\n@m (macro with 2 methods)\n\njulia> @m \"asd\"\n1 arguments\n\njulia> @m 1 2\nTwo arguments","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"However one should keep in mind, that macro dispatch is based on the types of AST that are handed to the macro, not the types that the AST evaluates to at runtime:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> macro m(::Int)\n           println(\"An Integer\")\n       end\n@m (macro with 3 methods)\n\njulia> @m 2\nAn Integer\n\njulia> x = 2\n2\n\njulia> @m x\n1 arguments","category":"page"},{"location":"manual/metaprogramming.html#Code-Generation-1","page":"Metaprogramming","title":"Code Generation","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"When a significant amount of repetitive boilerplate code is required, it is common to generate it programmatically to avoid redundancy. In most languages, this requires an extra build step, and a separate program to generate the repetitive code. In Julia, expression interpolation and eval allow such code generation to take place in the normal course of program execution. For example, consider the following custom type","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"struct MyNumber\n    x::Float64\nend\n# output\n","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"for which we want to add a number of methods to. We can do this programmatically in the following loop:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(quote\n        Base.$op(a::MyNumber) = MyNumber($op(a.x))\n    end)\nend\n# output\n","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"and we can now use those functions with our custom type:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = MyNumber(π)\nMyNumber(3.141592653589793)\n\njulia> sin(x)\nMyNumber(1.2246467991473532e-16)\n\njulia> cos(x)\nMyNumber(-1.0)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In this manner, Julia acts as its own preprocessor, and allows code generation from inside the language. The above code could be written slightly more tersely using the : prefix quoting form:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(:(Base.$op(a::MyNumber) = MyNumber($op(a.x))))\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"This sort of in-language code generation, however, using the eval(quote(...)) pattern, is common enough that Julia comes with a macro to abbreviate this pattern:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    @eval Base.$op(a::MyNumber) = MyNumber($op(a.x))\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The @eval macro rewrites this call to be precisely equivalent to the above longer versions. For longer blocks of generated code, the expression argument given to @eval can be a block:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"@eval begin\n    # multiple lines\nend","category":"page"},{"location":"manual/metaprogramming.html#Non-Standard-String-Literals-1","page":"Metaprogramming","title":"Non-Standard String Literals","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Recall from Strings that string literals prefixed by an identifier are called non-standard string literals, and can have different semantics than un-prefixed string literals. For example:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"r\"^\\s*(?:#|$)\" produces a regular expression object rather than a string\nb\"DATA\\xff\\u2200\" is a byte array literal for [68,65,84,65,255,226,136,128].","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Perhaps surprisingly, these behaviors are not hard-coded into the Julia parser or compiler. Instead, they are custom behaviors provided by a general mechanism that anyone can use: prefixed string literals are parsed as calls to specially-named macros. For example, the regular expression macro is just the following:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"macro r_str(p)\n    Regex(p)\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"That's all. This macro says that the literal contents of the string literal r\"^\\s*(?:#|$)\" should be passed to the @r_str macro and the result of that expansion should be placed in the syntax tree where the string literal occurs. In other words, the expression r\"^\\s*(?:#|$)\" is equivalent to placing the following object directly into the syntax tree:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Regex(\"^\\\\s*(?:#|\\$)\")","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Not only is the string literal form shorter and far more convenient, but it is also more efficient: since the regular expression is compiled and the Regex object is actually created when the code is compiled, the compilation occurs only once, rather than every time the code is executed. Consider if the regular expression occurs in a loop:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"for line = lines\n    m = match(r\"^\\s*(?:#|$)\", line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Since the regular expression r\"^\\s*(?:#|$)\" is compiled and inserted into the syntax tree when this code is parsed, the expression is only compiled once instead of each time the loop is executed. In order to accomplish this without macros, one would have to write this loop like this:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"re = Regex(\"^\\\\s*(?:#|\\$)\")\nfor line = lines\n    m = match(re, line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Moreover, if the compiler could not determine that the regex object was constant over all loops, certain optimizations might not be possible, making this version still less efficient than the more convenient literal form above. Of course, there are still situations where the non-literal form is more convenient: if one needs to interpolate a variable into the regular expression, one must take this more verbose approach; in cases where the regular expression pattern itself is dynamic, potentially changing upon each loop iteration, a new regular expression object must be constructed on each iteration. In the vast majority of use cases, however, regular expressions are not constructed based on run-time data. In this majority of cases, the ability to write regular expressions as compile-time values is invaluable.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Like non-standard string literals, non-standard command literals exist using a prefixed variant of the command literal syntax. The command literal custom`literal` is parsed as @custom_cmd \"literal\". Julia itself does not contain any non-standard command literals, but packages can make use of this syntax. Aside from the different syntax and the _cmd suffix instead of the _str suffix, non-standard command literals behave exactly like non-standard string literals.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In the event that two modules provide non-standard string or command literals with the same name, it is possible to qualify the string or command literal with a module name. For instance, if both Foo and Bar provide non-standard string literal @x_str, then one can write Foo.x\"literal\" or Bar.x\"literal\" to disambiguate between the two.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The mechanism for user-defined string literals is deeply, profoundly powerful. Not only are Julia's non-standard literals implemented using it, but also the command literal syntax (`echo \"Hello, $person\"`) is implemented with the following innocuous-looking macro:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"macro cmd(str)\n    :(cmd_gen($(shell_parse(str)[1])))\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Of course, a large amount of complexity is hidden in the functions used in this macro definition, but they are just functions, written entirely in Julia. You can read their source and see precisely what they do – and all they do is construct expression objects to be inserted into your program's syntax tree.","category":"page"},{"location":"manual/metaprogramming.html#Generated-functions-1","page":"Metaprogramming","title":"Generated functions","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"A very special macro is @generated, which allows you to define so-called generated functions. These have the capability to generate specialized code depending on the types of their arguments with more flexibility and/or less code than what can be achieved with multiple dispatch. While macros work with expressions at parse time and cannot access the types of their inputs, a generated function gets expanded at a time when the types of the arguments are known, but the function is not yet compiled.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Instead of performing some calculation or action, a generated function declaration returns a quoted expression which then forms the body for the method corresponding to the types of the arguments. When a generated function is called, the expression it returns is compiled and then run. To make this efficient, the result is usually cached. And to make this inferable, only a limited subset of the language is usable. Thus, generated functions provide a flexible way to move work from run time to compile time, at the expense of greater restrictions on allowed constructs.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"When defining generated functions, there are four main differences to ordinary functions:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"You annotate the function declaration with the @generated macro. This adds some information to the AST that lets the compiler know that this is a generated function.\nIn the body of the generated function you only have access to the types of the arguments – not their values – and any function that was defined before the definition of the generated function.\nInstead of calculating something or performing some action, you return a quoted expression which, when evaluated, does what you want.\nGenerated functions must not mutate or observe any non-constant global state (including, for example, IO, locks, non-local dictionaries, or using hasmethod). This means they can only read global constants, and cannot have any side effects. In other words, they must be completely pure. Due to an implementation limitation, this also means that they currently cannot define a closure or generator.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"It's easiest to illustrate this with an example. We can declare a generated function foo as","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function foo(x)\n           Core.println(x)\n           return :(x * x)\n       end\nfoo (generic function with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Note that the body returns a quoted expression, namely :(x * x), rather than just the value of x * x.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"From the caller's perspective, this is identical to a regular function; in fact, you don't have to know whether you're calling a regular or generated function. Let's see how foo behaves:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> x = foo(2); # note: output is from println() statement in the body\nInt64\n\njulia> x           # now we print x\n4\n\njulia> y = foo(\"bar\");\nString\n\njulia> y\n\"barbar\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"So, we see that in the body of the generated function, x is the type of the passed argument, and the value returned by the generated function, is the result of evaluating the quoted expression we returned from the definition, now with the value of x.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"What happens if we evaluate foo again with a type that we have already used?","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> foo(4)\n16","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Note that there is no printout of Int64. We can see that the body of the generated function was only executed once here, for the specific set of argument types, and the result was cached. After that, for this example, the expression returned from the generated function on the first invocation was re-used as the method body. However, the actual caching behavior is an implementation-defined performance optimization, so it is invalid to depend too closely on this behavior.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The number of times a generated function is generated might be only once, but it might also be more often, or appear to not happen at all. As a consequence, you should never write a generated function with side effects - when, and how often, the side effects occur is undefined. (This is true for macros too - and just like for macros, the use of eval in a generated function is a sign that you're doing something the wrong way.) However, unlike macros, the runtime system cannot correctly handle a call to eval, so it is disallowed.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"It is also important to see how @generated functions interact with method redefinition. Following the principle that a correct @generated function must not observe any mutable state or cause any mutation of global state, we see the following behavior. Observe that the generated function cannot call any method that was not defined prior to the definition of the generated function itself.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Initially f(x) has one definition","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(x) = \"original definition\";","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Define other operations that use f(x):","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> g(x) = f(x);\n\njulia> @generated gen1(x) = f(x);\n\njulia> @generated gen2(x) = :(f(x));","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"We now add some new definitions for f(x):","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(x::Int) = \"definition for Int\";\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\";","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"and compare how these results differ:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> gen1(1)\n\"original definition\"\n\njulia> gen2(1)\n\"definition for Int\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Each method of a generated function has its own view of defined functions:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated gen1(x::Real) = f(x);\n\njulia> gen1(1)\n\"definition for Type{Int}\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The example generated function foo above did not do anything a normal function foo(x) = x * x could not do (except printing the type on the first invocation, and incurring higher overhead). However, the power of a generated function lies in its ability to compute different quoted expressions depending on the types passed to it:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"(although of course this contrived example would be more easily implemented using multiple dispatch...)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Abusing this will corrupt the runtime system and cause undefined behavior:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function baz(x)\n           if rand() < .9\n               return :(x^2)\n           else\n               return :(\"boo!\")\n           end\n       end\nbaz (generic function with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Since the body of the generated function is non-deterministic, its behavior, and the behavior of all subsequent code is undefined.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Don't copy these examples!","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"These examples are hopefully helpful to illustrate how generated functions work, both in the definition end and at the call site; however, don't copy them, for the following reasons:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"the foo function has side-effects (the call to Core.println), and it is undefined exactly when, how often or how many times these side-effects will occur\nthe bar function solves a problem that is better solved with multiple dispatch - defining bar(x) = x and bar(x::Integer) = x ^ 2 will do the same thing, but it is both simpler and faster.\nthe baz function is pathological","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Note that the set of operations that should not be attempted in a generated function is unbounded, and the runtime system can currently only detect a subset of the invalid operations. There are many other operations that will simply corrupt the runtime system without notification, usually in subtle ways not obviously connected to the bad definition. Because the function generator is run during inference, it must respect all of the limitations of that code.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Some operations that should not be attempted include:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Caching of native pointers.\nInteracting with the contents or methods of Core.Compiler in any way.\nObserving any mutable state.\nInference on the generated function may be run at any time, including while your code is attempting to observe or mutate this state.\nTaking any locks: C code you call out to may use locks internally, (for example, it is not problematic to call malloc, even though most implementations require locks internally) but don't attempt to hold or acquire any while executing Julia code.\nCalling any function that is defined after the body of the generated function. This condition is relaxed for incrementally-loaded precompiled modules to allow calling any function in the module.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Alright, now that we have a better understanding of how generated functions work, let's use them to build some more advanced (and valid) functionality...","category":"page"},{"location":"manual/metaprogramming.html#An-advanced-example-1","page":"Metaprogramming","title":"An advanced example","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Julia's base library has a an internal sub2ind function to calculate a linear index into an n-dimensional array, based on a set of n multilinear indices - in other words, to calculate the index i that can be used to index into an array A using A[i], instead of A[x,y,z,...]. One possible implementation is the following:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> function sub2ind_loop(dims::NTuple{N}, I::Integer...) where N\n           ind = I[N] - 1\n           for i = N-1:-1:1\n               ind = I[i]-1 + dims[i]*ind\n           end\n           return ind + 1\n       end\nsub2ind_loop (generic function with 1 method)\n\njulia> sub2ind_loop((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"The same thing can be done using recursion:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> sub2ind_rec(dims::Tuple{}) = 1;\n\njulia> sub2ind_rec(dims::Tuple{}, i1::Integer, I::Integer...) =\n           i1 == 1 ? sub2ind_rec(dims, I...) : throw(BoundsError());\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer) = i1;\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer, I::Integer...) =\n           i1 + dims[1] * (sub2ind_rec(Base.tail(dims), I...) - 1);\n\njulia> sub2ind_rec((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Both these implementations, although different, do essentially the same thing: a runtime loop over the dimensions of the array, collecting the offset in each dimension into the final index.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"However, all the information we need for the loop is embedded in the type information of the arguments. Thus, we can utilize generated functions to move the iteration to compile-time; in compiler parlance, we use generated functions to manually unroll the loop. The body becomes almost identical, but instead of calculating the linear index, we build up an expression that calculates the index:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"What code will this generate?","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"An easy way to find out is to extract the body into another (regular) function:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           return sub2ind_gen_impl(dims, I...)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           length(I) == N || return :(error(\"partial indexing is unsupported\"))\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen_impl (generic function with 1 method)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"We can now execute sub2ind_gen_impl and examine the expression it returns:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"julia> sub2ind_gen_impl(Tuple{Int,Int}, Int, Int)\n:(((I[1] - 1) + dims[1] * (I[2] - 1)) + 1)","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"So, the method body that will be used here doesn't include a loop at all - just indexing into the two tuples, multiplication and addition/subtraction. All the looping is performed compile-time, and we avoid looping during execution entirely. Thus, we only loop once per type, in this case once per N (except in edge cases where the function is generated more than once - see disclaimer above).","category":"page"},{"location":"manual/metaprogramming.html#Optionally-generated-functions-1","page":"Metaprogramming","title":"Optionally-generated functions","text":"","category":"section"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Generated functions can achieve high efficiency at run time, but come with a compile time cost: a new function body must be generated for every combination of concrete argument types. Typically, Julia is able to compile \"generic\" versions of functions that will work for any arguments, but with generated functions this is impossible. This means that programs making heavy use of generated functions might be impossible to statically compile.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"To solve this problem, the language provides syntax for writing normal, non-generated alternative implementations of generated functions. Applied to the sub2ind example above, it would look like this:","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n    if N != length(I)\n        throw(ArgumentError(\"Number of dimensions must match number of indices.\"))\n    end\n    if @generated\n        ex = :(I[$N] - 1)\n        for i = (N - 1):-1:1\n            ex = :(I[$i] - 1 + dims[$i] * $ex)\n        end\n        return :($ex + 1)\n    else\n        ind = I[N] - 1\n        for i = (N - 1):-1:1\n            ind = I[i] - 1 + dims[i]*ind\n        end\n        return ind + 1\n    end\nend","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Internally, this code creates two implementations of the function: a generated one where the first block in if @generated is used, and a normal one where the else block is used. Inside the then part of the if @generated block, code has the same semantics as other generated functions: argument names refer to types, and the code should return an expression. Multiple if @generated blocks may occur, in which case the generated implementation uses all of the then blocks and the alternate implementation uses all of the else blocks.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"Notice that we added an error check to the top of the function. This code will be common to both versions, and is run-time code in both versions (it will be quoted and returned as an expression from the generated version). That means that the values and types of local variables are not available at code generation time –- the code-generation code can only see the types of arguments.","category":"page"},{"location":"manual/metaprogramming.html#","page":"Metaprogramming","title":"Metaprogramming","text":"In this style of definition, the code generation feature is essentially an optional optimization. The compiler will use it if convenient, but otherwise may choose to use the normal implementation instead. This style is preferred, since it allows the compiler to make more decisions and compile programs in more ways, and since normal code is more readable than code-generating code. However, which implementation is used depends on compiler implementation details, so it is essential for the two implementations to behave identically.","category":"page"},{"location":"manual/arrays.html#man-multi-dim-arrays-1","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Julia, like most technical computing languages, provides a first-class array implementation. Most technical computing languages pay a lot of attention to their array implementation at the expense of other containers. Julia does not treat arrays in any special way. The array library is implemented almost completely in Julia itself, and derives its performance from the compiler, just like any other code written in Julia. As such, it's also possible to define custom array types by inheriting from AbstractArray. See the manual section on the AbstractArray interface for more details on implementing a custom array type.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"An array is a collection of objects stored in a multi-dimensional grid. In the most general case, an array may contain objects of type Any. For most computational purposes, arrays should contain objects of a more specific type, such as Float64 or Int32.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In general, unlike many other technical computing languages, Julia does not expect programs to be written in a vectorized style for performance. Julia's compiler uses type inference and generates optimized code for scalar array indexing, allowing programs to be written in a style that is convenient and readable, without sacrificing performance, and using less memory at times.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In Julia, all arguments to functions are passed by sharing (i.e. by pointers). Some technical computing languages pass arrays by value, and while this prevents accidental modification by callees of a value in the caller, it makes avoiding unwanted copying of arrays difficult. By convention, a function name ending with a ! indicates that it will mutate or destroy the value of one or more of its arguments (compare, for example, sort and sort!). Callees must make explicit copies to ensure that they don't modify inputs that they don't intend to change. Many non- mutating functions are implemented by calling a function of the same name with an added ! at the end on an explicit copy of the input, and returning that copy.","category":"page"},{"location":"manual/arrays.html#Basic-Functions-1","page":"Multi-dimensional Arrays","title":"Basic Functions","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Function Description\neltype(A) the type of the elements contained in A\nlength(A) the number of elements in A\nndims(A) the number of dimensions of A\nsize(A) a tuple containing the dimensions of A\nsize(A,n) the size of A along dimension n\naxes(A) a tuple containing the valid indices of A\naxes(A,n) a range expressing the valid indices along dimension n\neachindex(A) an efficient iterator for visiting each position in A\nstride(A,k) the stride (linear index distance between adjacent elements) along dimension k\nstrides(A) a tuple of the strides in each dimension","category":"page"},{"location":"manual/arrays.html#Construction-and-Initialization-1","page":"Multi-dimensional Arrays","title":"Construction and Initialization","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Many functions for constructing and initializing arrays are provided. In the following list of such functions, calls with a dims... argument can either take a single tuple of dimension sizes or a series of dimension sizes passed as a variable number of arguments. Most of these functions also accept a first input T, which is the element type of the array. If the type T is omitted it will default to Float64.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Function Description\nArray{T}(undef, dims...) an uninitialized dense Array\nzeros(T, dims...) an Array of all zeros\nones(T, dims...) an Array of all ones\ntrues(dims...) a BitArray with all values true\nfalses(dims...) a BitArray with all values false\nreshape(A, dims...) an array containing the same data as A, but with different dimensions\ncopy(A) copy A\ndeepcopy(A) copy A, recursively copying its elements\nsimilar(A, T, dims...) an uninitialized array of the same type as A (dense, sparse, etc.), but with the specified element type and dimensions. The second and third arguments are both optional, defaulting to the element type and dimensions of A if omitted.\nreinterpret(T, A) an array with the same binary data as A, but with element type T\nrand(T, dims...) an Array with random, iid [1] and uniformly distributed values in the half-open interval 0 1)\nrandn(T, dims...) an Array with random, iid and standard normally distributed values\nMatrix{T}(I, m, n) m-by-n identity matrix\nrange(start, stop=stop, length=n) range of n linearly spaced elements from start to stop\nfill!(A, x) fill the array A with the value x\nfill(x, dims...) an Array filled with the value x","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"[1]: iid, independently and identically distributed.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The syntax [A, B, C, ...] constructs a 1-d array (i.e., a vector) of its arguments. If all arguments have a common promotion type then they get converted to that type using convert.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"To see the various ways we can pass dimensions to these constructors, consider the following examples:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> zeros(Int8, 2, 3)\n2×3 Array{Int8,2}:\n 0  0  0\n 0  0  0\n\njulia> zeros(Int8, (2, 3))\n2×3 Array{Int8,2}:\n 0  0  0\n 0  0  0\n\njulia> zeros((2, 3))\n2×3 Array{Float64,2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Here, (2, 3) is a Tuple.","category":"page"},{"location":"manual/arrays.html#Concatenation-1","page":"Multi-dimensional Arrays","title":"Concatenation","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Arrays can be constructed and also concatenated using the following functions:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Function Description\ncat(A...; dims=k) concatenate input arrays along dimension(s) k\nvcat(A...) shorthand for cat(A...; dims=1)\nhcat(A...) shorthand for cat(A...; dims=2)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Scalar values passed to these functions are treated as 1-element arrays. For example,","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> vcat([1, 2], 3)\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\njulia> hcat([1 2], 3)\n1×3 Array{Int64,2}:\n 1  2  3","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The concatenation functions are used so often that they have special syntax:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Expression Calls\n[A; B; C; ...] vcat\n[A B C ...] hcat\n[A B; C D; ...] hvcat","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"hvcat concatenates in both dimension 1 (with semicolons) and dimension 2 (with spaces). Consider these examples of this syntax:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> [[1; 2]; [3, 4]]\n4-element Array{Int64,1}:\n 1\n 2\n 3\n 4\n\njulia> [[1 2] [3 4]]\n1×4 Array{Int64,2}:\n 1  2  3  4\n\njulia> [[1 2]; [3 4]]\n2×2 Array{Int64,2}:\n 1  2\n 3  4","category":"page"},{"location":"manual/arrays.html#Typed-array-initializers-1","page":"Multi-dimensional Arrays","title":"Typed array initializers","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"An array with a specific element type can be constructed using the syntax T[A, B, C, ...]. This will construct a 1-d array with element type T, initialized to contain elements A, B, C, etc. For example, Any[x, y, z] constructs a heterogeneous array that can contain any values.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Concatenation syntax can similarly be prefixed with a type to specify the element type of the result.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> [[1 2] [3 4]]\n1×4 Array{Int64,2}:\n 1  2  3  4\n\njulia> Int8[[1 2] [3 4]]\n1×4 Array{Int8,2}:\n 1  2  3  4","category":"page"},{"location":"manual/arrays.html#Comprehensions-1","page":"Multi-dimensional Arrays","title":"Comprehensions","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Comprehensions provide a general and powerful way to construct arrays. Comprehension syntax is similar to set construction notation in mathematics:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A = [ F(x,y,...) for x=rx, y=ry, ... ]","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The meaning of this form is that F(x,y,...) is evaluated with the variables x, y, etc. taking on each value in their given list of values. Values can be specified as any iterable object, but will commonly be ranges like 1:n or 2:(n-1), or explicit arrays of values like [1.2, 3.4, 5.7]. The result is an N-d dense array with dimensions that are the concatenation of the dimensions of the variable ranges rx, ry, etc. and each F(x,y,...) evaluation returns a scalar.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The following example computes a weighted average of the current element and its left and right neighbor along a 1-d grid. :","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> x = rand(8)\n8-element Array{Float64,1}:\n 0.843025\n 0.869052\n 0.365105\n 0.699456\n 0.977653\n 0.994953\n 0.41084\n 0.809411\n\njulia> [ 0.25*x[i-1] + 0.5*x[i] + 0.25*x[i+1] for i=2:length(x)-1 ]\n6-element Array{Float64,1}:\n 0.736559\n 0.57468\n 0.685417\n 0.912429\n 0.8446\n 0.656511","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The resulting array type depends on the types of the computed elements. In order to control the type explicitly, a type can be prepended to the comprehension. For example, we could have requested the result in single precision by writing:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Float32[ 0.25*x[i-1] + 0.5*x[i] + 0.25*x[i+1] for i=2:length(x)-1 ]","category":"page"},{"location":"manual/arrays.html#Generator-Expressions-1","page":"Multi-dimensional Arrays","title":"Generator Expressions","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Comprehensions can also be written without the enclosing square brackets, producing an object known as a generator. This object can be iterated to produce values on demand, instead of allocating an array and storing them in advance (see Iteration). For example, the following expression sums a series without allocating memory:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> sum(1/n^2 for n=1:1000)\n1.6439345666815615","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"When writing a generator expression with multiple dimensions inside an argument list, parentheses are needed to separate the generator from subsequent arguments:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> map(tuple, 1/(i+j) for i=1:2, j=1:2, [1:4;])\nERROR: syntax: invalid iteration specification","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"All comma-separated expressions after for are interpreted as ranges. Adding parentheses lets us add a third argument to map:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> map(tuple, (1/(i+j) for i=1:2, j=1:2), [1 3; 2 4])\n2×2 Array{Tuple{Float64,Int64},2}:\n (0.5, 1)       (0.333333, 3)\n (0.333333, 2)  (0.25, 4)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Generators are implemented via inner functions. Just like inner functions used elsewhere in the language, variables from the enclosing scope can be \"captured\" in the inner function.  For example, sum(p[i] - q[i] for i=1:n) captures the three variables p, q and n from the enclosing scope. Captured variables can present performance challenges; see performance tips.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Ranges in generators and comprehensions can depend on previous ranges by writing multiple for keywords:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> [(i,j) for i=1:3 for j=1:i]\n6-element Array{Tuple{Int64,Int64},1}:\n (1, 1)\n (2, 1)\n (2, 2)\n (3, 1)\n (3, 2)\n (3, 3)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In such cases, the result is always 1-d.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Generated values can be filtered using the if keyword:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> [(i,j) for i=1:3 for j=1:i if i+j == 4]\n2-element Array{Tuple{Int64,Int64},1}:\n (2, 2)\n (3, 1)","category":"page"},{"location":"manual/arrays.html#man-array-indexing-1","page":"Multi-dimensional Arrays","title":"Indexing","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The general syntax for indexing into an n-dimensional array A is:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"X = A[I_1, I_2, ..., I_n]","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"where each I_k may be a scalar integer, an array of integers, or any other supported index. This includes Colon (:) to select all indices within the entire dimension, ranges of the form a:c or a:b:c to select contiguous or strided subsections, and arrays of booleans to select elements at their true indices.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If all the indices are scalars, then the result X is a single element from the array A. Otherwise, X is an array with the same number of dimensions as the sum of the dimensionalities of all the indices.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If all indices I_k are vectors, for example, then the shape of X would be (length(I_1), length(I_2), ..., length(I_n)), with location i_1, i_2, ..., i_n of X containing the value A[I_1[i_1], I_2[i_2], ..., I_n[i_n]].","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = reshape(collect(1:16), (2, 2, 2, 2))\n2×2×2×2 Array{Int64,4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> A[1, 2, 1, 1] # all scalar indices\n3\n\njulia> A[[1, 2], [1], [1, 2], [1]] # all vector indices\n2×1×2×1 Array{Int64,4}:\n[:, :, 1, 1] =\n 1\n 2\n\n[:, :, 2, 1] =\n 5\n 6\n\njulia> A[[1, 2], [1], [1, 2], 1] # a mix of index types\n2×1×2 Array{Int64,3}:\n[:, :, 1] =\n 1\n 2\n\n[:, :, 2] =\n 5\n 6","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Note how the size of the resulting array is different in the last two cases.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If I_1 is changed to a two-dimensional matrix, then X becomes an n+1-dimensional array of shape (size(I_1, 1), size(I_1, 2), length(I_2), ..., length(I_n)). The matrix adds a dimension.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = reshape(collect(1:16), (2, 2, 2, 2));\n\njulia> A[[1 2; 1 2]]\n2×2 Array{Int64,2}:\n 1  2\n 1  2\n\njulia> A[[1 2; 1 2], 1, 2, 1]\n2×2 Array{Int64,2}:\n 5  6\n 5  6","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The location i_1, i_2, i_3, ..., i_{n+1} contains the value at A[I_1[i_1, i_2], I_2[i_3], ..., I_n[i_{n+1}]]. All dimensions indexed with scalars are dropped. For example, if J is an array of indices, then the result of A[2, J, 3] is an array with size size(J). Its jth element is populated by A[2, J[j], 3].","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"As a special part of this syntax, the end keyword may be used to represent the last index of each dimension within the indexing brackets, as determined by the size of the innermost array being indexed. Indexing syntax without the end keyword is equivalent to a call to getindex:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"X = getindex(A, I_1, I_2, ..., I_n)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> x = reshape(1:16, 4, 4)\n4×4 reshape(::UnitRange{Int64}, 4, 4) with eltype Int64:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> x[2:3, 2:end-1]\n2×2 Array{Int64,2}:\n 6  10\n 7  11\n\njulia> x[1, [2 3; 4 1]]\n2×2 Array{Int64,2}:\n  5  9\n 13  1","category":"page"},{"location":"manual/arrays.html#Assignment-1","page":"Multi-dimensional Arrays","title":"Assignment","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The general syntax for assigning values in an n-dimensional array A is:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A[I_1, I_2, ..., I_n] = X","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"where each I_k may be a scalar integer, an array of integers, or any other supported index. This includes Colon (:) to select all indices within the entire dimension, ranges of the form a:c or a:b:c to select contiguous or strided subsections, and arrays of booleans to select elements at their true indices.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If all indices I_k are integers, then the value in location I_1, I_2, ..., I_n of A is overwritten with the value of X, converting to the eltype of A if necessary.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If any index I_k selects more than one location, then the right hand side X must be an array with the same shape as the result of indexing A[I_1, I_2, ..., I_n] or a vector with the same number of elements. The value in location I_1[i_1], I_2[i_2], ..., I_n[i_n] of A is overwritten with the value X[I_1, I_2, ..., I_n], converting if necessary. The element-wise assignment operator .= may be used to broadcast X across the selected locations:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A[I_1, I_2, ..., I_n] .= X","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Just as in Indexing, the end keyword may be used to represent the last index of each dimension within the indexing brackets, as determined by the size of the array being assigned into. Indexed assignment syntax without the end keyword is equivalent to a call to setindex!:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"setindex!(A, X, I_1, I_2, ..., I_n)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> x = collect(reshape(1:9, 3, 3))\n3×3 Array{Int64,2}:\n 1  4  7\n 2  5  8\n 3  6  9\n\njulia> x[3, 3] = -9;\n\njulia> x[1:2, 1:2] = [-1 -4; -2 -5];\n\njulia> x\n3×3 Array{Int64,2}:\n -1  -4   7\n -2  -5   8\n  3   6  -9","category":"page"},{"location":"manual/arrays.html#man-supported-index-types-1","page":"Multi-dimensional Arrays","title":"Supported index types","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In the expression A[I_1, I_2, ..., I_n], each I_k may be a scalar index, an array of scalar indices, or an object that represents an array of scalar indices and can be converted to such by to_indices:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A scalar index. By default this includes:\nNon-boolean integers\nCartesianIndex{N}s, which behave like an N-tuple of integers spanning multiple dimensions (see below for more details)\nAn array of scalar indices. This includes:\nVectors and multidimensional arrays of integers\nEmpty arrays like [], which select no elements\nRanges like a:c or a:b:c, which select contiguous or strided subsections from a to c (inclusive)\nAny custom array of scalar indices that is a subtype of AbstractArray\nArrays of CartesianIndex{N} (see below for more details)\nAn object that represents an array of scalar indices and can be converted to such by to_indices. By default this includes:\nColon() (:), which represents all indices within an entire dimension or across the entire array\nArrays of booleans, which select elements at their true indices (see below for more details)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Some examples:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = reshape(collect(1:2:18), (3, 3))\n3×3 Array{Int64,2}:\n 1   7  13\n 3   9  15\n 5  11  17\n\njulia> A[4]\n7\n\njulia> A[[2, 5, 8]]\n3-element Array{Int64,1}:\n  3\n  9\n 15\n\njulia> A[[1 4; 3 8]]\n2×2 Array{Int64,2}:\n 1   7\n 5  15\n\njulia> A[[]]\n0-element Array{Int64,1}\n\njulia> A[1:2:5]\n3-element Array{Int64,1}:\n 1\n 5\n 9\n\njulia> A[2, :]\n3-element Array{Int64,1}:\n  3\n  9\n 15\n\njulia> A[:, 3]\n3-element Array{Int64,1}:\n 13\n 15\n 17","category":"page"},{"location":"manual/arrays.html#Cartesian-indices-1","page":"Multi-dimensional Arrays","title":"Cartesian indices","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The special CartesianIndex{N} object represents a scalar index that behaves like an N-tuple of integers spanning multiple dimensions.  For example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = reshape(1:32, 4, 4, 2);\n\njulia> A[3, 2, 1]\n7\n\njulia> A[CartesianIndex(3, 2, 1)] == A[3, 2, 1] == 7\ntrue","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Considered alone, this may seem relatively trivial; CartesianIndex simply gathers multiple integers together into one object that represents a single multidimensional index. When combined with other indexing forms and iterators that yield CartesianIndexes, however, this can produce very elegant and efficient code. See Iteration below, and for some more advanced examples, see this blog post on multidimensional algorithms and iteration.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Arrays of CartesianIndex{N} are also supported. They represent a collection of scalar indices that each span N dimensions, enabling a form of indexing that is sometimes referred to as pointwise indexing. For example, it enables accessing the diagonal elements from the first \"page\" of A from above:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> page = A[:,:,1]\n4×4 Array{Int64,2}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> page[[CartesianIndex(1,1),\n             CartesianIndex(2,2),\n             CartesianIndex(3,3),\n             CartesianIndex(4,4)]]\n4-element Array{Int64,1}:\n  1\n  6\n 11\n 16","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"This can be expressed much more simply with dot broadcasting and by combining it with a normal integer index (instead of extracting the first page from A as a separate step). It can even be combined with a : to extract both diagonals from the two pages at the same time:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A[CartesianIndex.(axes(A, 1), axes(A, 2)), 1]\n4-element Array{Int64,1}:\n  1\n  6\n 11\n 16\n\njulia> A[CartesianIndex.(axes(A, 1), axes(A, 2)), :]\n4×2 Array{Int64,2}:\n  1  17\n  6  22\n 11  27\n 16  32","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"warning: Warning\nCartesianIndex and arrays of CartesianIndex are not compatible with the end keyword to represent the last index of a dimension. Do not use end in indexing expressions that may contain either CartesianIndex or arrays thereof.","category":"page"},{"location":"manual/arrays.html#Logical-indexing-1","page":"Multi-dimensional Arrays","title":"Logical indexing","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Often referred to as logical indexing or indexing with a logical mask, indexing by a boolean array selects elements at the indices where its values are true. Indexing by a boolean vector B is effectively the same as indexing by the vector of integers that is returned by findall(B). Similarly, indexing by a N-dimensional boolean array is effectively the same as indexing by the vector of CartesianIndex{N}s where its values are true. A logical index must be a vector of the same length as the dimension it indexes into, or it must be the only index provided and match the size and dimensionality of the array it indexes into. It is generally more efficient to use boolean arrays as indices directly instead of first calling findall.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> x = reshape(1:16, 4, 4)\n4×4 reshape(::UnitRange{Int64}, 4, 4) with eltype Int64:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> x[[false, true, true, false], :]\n2×4 Array{Int64,2}:\n 2  6  10  14\n 3  7  11  15\n\njulia> mask = map(ispow2, x)\n4×4 Array{Bool,2}:\n 1  0  0  0\n 1  0  0  0\n 0  0  0  0\n 1  1  0  1\n\njulia> x[mask]\n5-element Array{Int64,1}:\n  1\n  2\n  4\n  8\n 16","category":"page"},{"location":"manual/arrays.html#Number-of-indices-1","page":"Multi-dimensional Arrays","title":"Number of indices","text":"","category":"section"},{"location":"manual/arrays.html#Cartesian-indexing-1","page":"Multi-dimensional Arrays","title":"Cartesian indexing","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The ordinary way to index into an N-dimensional array is to use exactly N indices; each index selects the position(s) in its particular dimension. For example, in the three-dimensional array A = rand(4, 3, 2), A[2, 3, 1] will select the number in the second row of the third column in the first \"page\" of the array. This is often referred to as cartesian indexing.","category":"page"},{"location":"manual/arrays.html#Linear-indexing-1","page":"Multi-dimensional Arrays","title":"Linear indexing","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"When exactly one index i is provided, that index no longer represents a location in a particular dimension of the array. Instead, it selects the ith element using the column-major iteration order that linearly spans the entire array. This is known as linear indexing. It essentially treats the array as though it had been reshaped into a one-dimensional vector with vec.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = [2 6; 4 7; 3 1]\n3×2 Array{Int64,2}:\n 2  6\n 4  7\n 3  1\n\njulia> A[5]\n7\n\njulia> vec(A)[5]\n7","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A linear index into the array A can be converted to a CartesianIndex for cartesian indexing with CartesianIndices(A)[i] (see CartesianIndices), and a set of N cartesian indices can be converted to a linear index with LinearIndices(A)[i_1, i_2, ..., i_N] (see LinearIndices).","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> CartesianIndices(A)[5]\nCartesianIndex(2, 2)\n\njulia> LinearIndices(A)[2, 2]\n5","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"It's important to note that there's a very large assymmetry in the performance of these conversions. Converting a linear index to a set of cartesian indices requires dividing and taking the remainder, whereas going the other way is just multiplies and adds. In modern processors, integer division can be 10-50 times slower than multiplication. While some arrays — like Array itself — are implemented using a linear chunk of memory and directly use a linear index in their implementations, other arrays — like Diagonal — need the full set of cartesian indices to do their lookup (see IndexStyle to introspect which is which). As such, when iterating over an entire array, it's much better to iterate over eachindex(A) instead of 1:length(A). Not only will the former be much faster in cases where A is IndexCartesian, but it will also support OffsetArrays, too.","category":"page"},{"location":"manual/arrays.html#Omitted-and-extra-indices-1","page":"Multi-dimensional Arrays","title":"Omitted and extra indices","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In addition to linear indexing, an N-dimensional array may be indexed with fewer or more than N indices in certain situations.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Indices may be omitted if the trailing dimensions that are not indexed into are all length one. In other words, trailing indices can be omitted only if there is only one possible value that those omitted indices could be for an in-bounds indexing expression. For example, a four-dimensional array with size (3, 4, 2, 1) may be indexed with only three indices as the dimension that gets skipped (the fourth dimension) has length one. Note that linear indexing takes precedence over this rule.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = reshape(1:24, 3, 4, 2, 1)\n3×4×2×1 reshape(::UnitRange{Int64}, 3, 4, 2, 1) with eltype Int64:\n[:, :, 1, 1] =\n 1  4  7  10\n 2  5  8  11\n 3  6  9  12\n\n[:, :, 2, 1] =\n 13  16  19  22\n 14  17  20  23\n 15  18  21  24\n\njulia> A[1, 3, 2] # Omits the fourth dimension (length 1)\n19\n\njulia> A[1, 3] # Attempts to omit dimensions 3 & 4 (lengths 2 and 1)\nERROR: BoundsError: attempt to access 3×4×2×1 reshape(::UnitRange{Int64}, 3, 4, 2, 1) with eltype Int64 at index [1, 3]\n\njulia> A[19] # Linear indexing\n19","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"When omitting all indices with A[], this semantic provides a simple idiom to retrieve the only element in an array and simultaneously ensure that there was only one element.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Similarly, more than N indices may be provided if all the indices beyond the dimensionality of the array are 1 (or more generally are the first and only element of axes(A, d) where d is that particular dimension number). This allows vectors to be indexed like one-column matrices, for example:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = [8,6,7]\n3-element Array{Int64,1}:\n 8\n 6\n 7\n\njulia> A[2,1]\n6","category":"page"},{"location":"manual/arrays.html#Iteration-1","page":"Multi-dimensional Arrays","title":"Iteration","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The recommended ways to iterate over a whole array are","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"for a in A\n    # Do something with the element a\nend\n\nfor i in eachindex(A)\n    # Do something with i and/or A[i]\nend","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The first construct is used when you need the value, but not index, of each element. In the second construct, i will be an Int if A is an array type with fast linear indexing; otherwise, it will be a CartesianIndex:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> A = rand(4,3);\n\njulia> B = view(A, 1:3, 2:3);\n\njulia> for i in eachindex(B)\n           @show i\n       end\ni = CartesianIndex(1, 1)\ni = CartesianIndex(2, 1)\ni = CartesianIndex(3, 1)\ni = CartesianIndex(1, 2)\ni = CartesianIndex(2, 2)\ni = CartesianIndex(3, 2)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"In contrast with for i = 1:length(A), iterating with eachindex provides an efficient way to iterate over any array type.","category":"page"},{"location":"manual/arrays.html#Array-traits-1","page":"Multi-dimensional Arrays","title":"Array traits","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"If you write a custom AbstractArray type, you can specify that it has fast linear indexing using","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Base.IndexStyle(::Type{<:MyArray}) = IndexLinear()","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"This setting will cause eachindex iteration over a MyArray to use integers. If you don't specify this trait, the default value IndexCartesian() is used.","category":"page"},{"location":"manual/arrays.html#Array-and-Vectorized-Operators-and-Functions-1","page":"Multi-dimensional Arrays","title":"Array and Vectorized Operators and Functions","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The following operators are supported for arrays:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Unary arithmetic – -, +\nBinary arithmetic – -, +, *, /, \\, ^\nComparison – ==, !=, ≈ (isapprox), ≉","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"To enable convenient vectorization of mathematical and other operations, Julia provides the dot syntax f.(args...), e.g. sin.(x) or min.(x,y), for elementwise operations over arrays or mixtures of arrays and scalars (a Broadcasting operation); these have the additional advantage of \"fusing\" into a single loop when combined with other dot calls, e.g. sin.(cos.(x)).","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Also, every binary operator supports a dot version that can be applied to arrays (and combinations of arrays and scalars) in such fused broadcasting operations, e.g. z .== sin.(x .* y).","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Note that comparisons such as == operate on whole arrays, giving a single boolean answer. Use dot operators like .== for elementwise comparisons. (For comparison operations like <, only the elementwise .< version is applicable to arrays.)","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Also notice the difference between max.(a,b), which broadcasts max elementwise over a and b, and maximum(a), which finds the largest value within a. The same relationship holds for min.(a,b) and minimum(a).","category":"page"},{"location":"manual/arrays.html#Broadcasting-1","page":"Multi-dimensional Arrays","title":"Broadcasting","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"It is sometimes useful to perform element-by-element binary operations on arrays of different sizes, such as adding a vector to each column of a matrix. An inefficient way to do this would be to replicate the vector to the size of the matrix:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> a = rand(2,1); A = rand(2,3);\n\njulia> repeat(a,1,3)+A\n2×3 Array{Float64,2}:\n 1.20813  1.82068  1.25387\n 1.56851  1.86401  1.67846","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"This is wasteful when dimensions get large, so Julia provides broadcast, which expands singleton dimensions in array arguments to match the corresponding dimension in the other array without using extra memory, and applies the given function elementwise:","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> broadcast(+, a, A)\n2×3 Array{Float64,2}:\n 1.20813  1.82068  1.25387\n 1.56851  1.86401  1.67846\n\njulia> b = rand(1,2)\n1×2 Array{Float64,2}:\n 0.867535  0.00457906\n\njulia> broadcast(+, a, b)\n2×2 Array{Float64,2}:\n 1.71056  0.847604\n 1.73659  0.873631","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Dotted operators such as .+ and .* are equivalent to broadcast calls (except that they fuse, as described below). There is also a broadcast! function to specify an explicit destination (which can also be accessed in a fusing fashion by .= assignment). In fact, f.(args...) is equivalent to broadcast(f, args...), providing a convenient syntax to broadcast any function (dot syntax). Nested \"dot calls\" f.(...) (including calls to .+ etcetera) automatically fuse into a single broadcast call.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"Additionally, broadcast is not limited to arrays (see the function documentation), it also handles tuples and treats any argument that is not an array, tuple or Ref (except for Ptr) as a \"scalar\".","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> convert.(Float32, [1, 2])\n2-element Array{Float32,1}:\n 1.0\n 2.0\n\njulia> ceil.((UInt8,), [1.2 3.4; 5.6 6.7])\n2×2 Array{UInt8,2}:\n 0x02  0x04\n 0x06  0x07\n\njulia> string.(1:3, \". \", [\"First\", \"Second\", \"Third\"])\n3-element Array{String,1}:\n \"1. First\"\n \"2. Second\"\n \"3. Third\"","category":"page"},{"location":"manual/arrays.html#Implementation-1","page":"Multi-dimensional Arrays","title":"Implementation","text":"","category":"section"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The base array type in Julia is the abstract type AbstractArray{T,N}. It is parameterized by the number of dimensions N and the element type T. AbstractVector and AbstractMatrix are aliases for the 1-d and 2-d cases. Operations on AbstractArray objects are defined using higher level operators and functions, in a way that is independent of the underlying storage. These operations generally work correctly as a fallback for any specific array implementation.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The AbstractArray type includes anything vaguely array-like, and implementations of it might be quite different from conventional arrays. For example, elements might be computed on request rather than stored. However, any concrete AbstractArray{T,N} type should generally implement at least size(A) (returning an Int tuple), getindex(A,i) and getindex(A,i1,...,iN); mutable arrays should also implement setindex!. It is recommended that these operations have nearly constant time complexity, or technically Õ(1) complexity, as otherwise some array functions may be unexpectedly slow. Concrete types should also typically provide a similar(A,T=eltype(A),dims=size(A)) method, which is used to allocate a similar array for copy and other out-of-place operations. No matter how an AbstractArray{T,N} is represented internally, T is the type of object returned by integer indexing (A[1, ..., 1], when A is not empty) and N should be the length of the tuple returned by size. For more details on defining custom AbstractArray implementations, see the array interface guide in the interfaces chapter.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"DenseArray is an abstract subtype of AbstractArray intended to include all arrays where elements are stored contiguously in column-major order (see additional notes in Performance Tips). The Array type is a specific instance of DenseArray;  Vector and Matrix are aliases for the 1-d and 2-d cases. Very few operations are implemented specifically for Array beyond those that are required for all AbstractArrays; much of the array library is implemented in a generic manner that allows all custom arrays to behave similarly.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"SubArray is a specialization of AbstractArray that performs indexing by sharing memory with the original array rather than by copying it. A SubArray is created with the view function, which is called the same way as getindex (with an array and a series of index arguments). The result of view looks the same as the result of getindex, except the data is left in place. view stores the input index vectors in a SubArray object, which can later be used to index the original array indirectly.  By putting the @views macro in front of an expression or block of code, any array[...] slice in that expression will be converted to create a SubArray view instead.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"BitArrays are space-efficient \"packed\" boolean arrays, which store one bit per boolean value. They can be used similarly to Array{Bool} arrays (which store one byte per boolean value), and can be converted to/from the latter via Array(bitarray) and BitArray(array), respectively.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"A \"strided\" array is stored in memory with elements laid out in regular offsets such that an instance with a supported isbits element type can be passed to external C and Fortran functions that expect this memory layout. Strided arrays must define a strides(A) method that returns a tuple of \"strides\" for each dimension; a provided stride(A,k) method accesses the kth element within this tuple. Increasing the index of dimension k by 1 should increase the index i of getindex(A,i) by stride(A,k). If a pointer conversion method Base.unsafe_convert(Ptr{T}, A) is provided, the memory layout must correspond in the same way to these strides. DenseArray is a very specific example of a strided array where the elements are arranged contiguously, thus it provides its subtypes with the appropriate definition of strides. More concrete examples can be found within the interface guide for strided arrays. StridedVector and StridedMatrix are convenient aliases for many of the builtin array types that are considered strided arrays, allowing them to dispatch to select specialized implementations that call highly tuned and optimized BLAS and LAPACK functions using just the pointer and strides.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"The following example computes the QR decomposition of a small section of a larger array, without creating any temporaries, and by calling the appropriate LAPACK function with the right leading dimension size and stride parameters.","category":"page"},{"location":"manual/arrays.html#","page":"Multi-dimensional Arrays","title":"Multi-dimensional Arrays","text":"julia> a = rand(10, 10)\n10×10 Array{Float64,2}:\n 0.517515  0.0348206  0.749042   0.0979679  …  0.75984     0.950481   0.579513\n 0.901092  0.873479   0.134533   0.0697848     0.0586695   0.193254   0.726898\n 0.976808  0.0901881  0.208332   0.920358      0.288535    0.705941   0.337137\n 0.657127  0.0317896  0.772837   0.534457      0.0966037   0.700694   0.675999\n 0.471777  0.144969   0.0718405  0.0827916     0.527233    0.173132   0.694304\n 0.160872  0.455168   0.489254   0.827851   …  0.62226     0.0995456  0.946522\n 0.291857  0.769492   0.68043    0.629461      0.727558    0.910796   0.834837\n 0.775774  0.700731   0.700177   0.0126213     0.00822304  0.327502   0.955181\n 0.9715    0.64354    0.848441   0.241474      0.591611    0.792573   0.194357\n 0.646596  0.575456   0.0995212  0.038517      0.709233    0.477657   0.0507231\n\njulia> b = view(a, 2:2:8,2:2:4)\n4×2 view(::Array{Float64,2}, 2:2:8, 2:2:4) with eltype Float64:\n 0.873479   0.0697848\n 0.0317896  0.534457\n 0.455168   0.827851\n 0.700731   0.0126213\n\njulia> (q, r) = qr(b);\n\njulia> q\n4×4 LinearAlgebra.QRCompactWYQ{Float64,Array{Float64,2}}:\n -0.722358    0.227524  -0.247784    -0.604181\n -0.0262896  -0.575919  -0.804227     0.144377\n -0.376419   -0.75072    0.540177    -0.0541979\n -0.579497    0.230151  -0.00552346   0.781782\n\njulia> r\n2×2 Array{Float64,2}:\n -1.20921  -0.383393\n  0.0      -0.910506","category":"page"},{"location":"manual/missing.html#missing-1","page":"Missing Values","title":"Missing Values","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Julia provides support for representing missing values in the statistical sense, that is for situations where no value is available for a variable in an observation, but a valid value theoretically exists. Missing values are represented via the missing object, which is the singleton instance of the type Missing. missing is equivalent to NULL in SQL and NA in R, and behaves like them in most situations.","category":"page"},{"location":"manual/missing.html#Propagation-of-Missing-Values-1","page":"Missing Values","title":"Propagation of Missing Values","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"The behavior of missing values follows one basic rule: missing values propagate automatically when passed to standard operators and functions, in particular mathematical functions. Uncertainty about the value of one of the operands induces uncertainty about the result. In practice, this means an operation involving a missing value generally returns missing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> missing + 1\nmissing\n\njulia> \"a\" * missing\nmissing\n\njulia> abs(missing)\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"As missing is a normal Julia object, this propagation rule only works for functions which have opted in to implement this behavior. This can be achieved either via a specific method defined for arguments of type Missing, or simply by accepting arguments of this type, and passing them to functions which propagate them (like standard operators). Packages should consider whether it makes sense to propagate missing values when defining new functions, and define methods appropriately if that is the case. Passing a missing value to a function for which no method accepting arguments of type Missing is defined throws a MethodError, just like for any other type.","category":"page"},{"location":"manual/missing.html#Equality-and-Comparison-Operators-1","page":"Missing Values","title":"Equality and Comparison Operators","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Standard equality and comparison operators follow the propagation rule presented above: if any of the operands is missing, the result is missing. Here are a few examples","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> missing == 1\nmissing\n\njulia> missing == missing\nmissing\n\njulia> missing < 1\nmissing\n\njulia> 2 >= missing\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"In particular, note that missing == missing returns missing, so == cannot be used to test whether a value is missing. To test whether x is missing, use ismissing(x).","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Special comparison operators isequal and === are exceptions to the propagation rule: they always return a Bool value, even in the presence of missing values, considering missing as equal to missing and as different from any other value. They can therefore be used to test whether a value is missing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> missing === 1\nfalse\n\njulia> isequal(missing, 1)\nfalse\n\njulia> missing === missing\ntrue\n\njulia> isequal(missing, missing)\ntrue","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"The isless operator is another exception: missing is considered as greater than any other value. This operator is used by sort, which therefore places missing values after all other values.","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> isless(1, missing)\ntrue\n\njulia> isless(missing, Inf)\nfalse\n\njulia> isless(missing, missing)\nfalse","category":"page"},{"location":"manual/missing.html#Logical-operators-1","page":"Missing Values","title":"Logical operators","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Logical (or boolean) operators |, & and xor are another special case, as they only propagate missing values when it is logically required. For these operators, whether or not the result is uncertain depends on the particular operation, following the well-established rules of three-valued logic which are also implemented by NULL in SQL and NA in R. This abstract definition actually corresponds to a relatively natural behavior which is best explained via concrete examples.","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Let us illustrate this principle with the logical \"or\" operator |. Following the rules of boolean logic, if one of the operands is true, the value of the other operand does not have an influence on the result, which will always be true","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> true | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | true\ntrue","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Based on this observation, we can conclude that if one of the operands is true and the other missing, we know that the result is true in spite of the uncertainty about the actual value of one of the operands. If we had been able to observe the actual value of the second operand, it could only be true or false, and in both cases the result would be true. Therefore, in this particular case, missingness does not propagate","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> true | missing\ntrue\n\njulia> missing | true\ntrue","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"On the contrary, if one of the operands is false, the result could be either true or false depending on the value of the other operand. Therefore, if that operand is missing, the result has to be missing too","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> false | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | false\nfalse\n\njulia> false | missing\nmissing\n\njulia> missing | false\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"The behavior of the logical \"and\" operator & is similar to that of the | operator, with the difference that missingness does not propagate when one of the operands is false. For example, when that is the case of the first operand","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> false & false\nfalse\n\njulia> false & true\nfalse\n\njulia> false & missing\nfalse","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"On the other hand, missingness propagates when one of the operands is true, for example the first one","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> true & true\ntrue\n\njulia> true & false\nfalse\n\njulia> true & missing\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Finally, the \"exclusive or\" logical operator xor always propagates missing values, since both operands always have an effect on the result. Also note that the negation operator ! returns missing when the operand is missing just like other unary operators.","category":"page"},{"location":"manual/missing.html#Control-Flow-and-Short-Circuiting-Operators-1","page":"Missing Values","title":"Control Flow and Short-Circuiting Operators","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Control flow operators including if, while and the ternary operator x ? y : z do not allow for missing values. This is because of the uncertainty about whether the actual value would be true or false if we could observe it, which implies that we do not know how the program should behave. A TypeError is thrown as soon as a missing value is encountered in this context","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> if missing\n           println(\"here\")\n       end\nERROR: TypeError: non-boolean (Missing) used in boolean context","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"For the same reason, contrary to logical operators presented above, the short-circuiting boolean operators && and || do not allow for missing values in situations where the value of the operand determines whether the next operand is evaluated or not. For example","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> missing || false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> true && missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"On the other hand, no error is thrown when the result can be determined without the missing values. This is the case when the code short-circuits before evaluating the missing operand, and when the missing operand is the last one","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> true && missing\nmissing\n\njulia> false && missing\nfalse","category":"page"},{"location":"manual/missing.html#Arrays-With-Missing-Values-1","page":"Missing Values","title":"Arrays With Missing Values","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Arrays containing missing values can be created like other arrays","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> [1, missing]\n2-element Array{Union{Missing, Int64},1}:\n 1\n  missing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"As this example shows, the element type of such arrays is Union{Missing, T}, with T the type of the non-missing values. This simply reflects the fact that array entries can be either of type T (here, Int64) or of type Missing. This kind of array uses an efficient memory storage equivalent to an Array{T} holding the actual values combined with an Array{UInt8} indicating the type of the entry (i.e. whether it is Missing or T).","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Arrays allowing for missing values can be constructed with the standard syntax. Use Array{Union{Missing, T}}(missing, dims) to create arrays filled with missing values:","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> Array{Union{Missing, String}}(missing, 2, 3)\n2×3 Array{Union{Missing, String},2}:\n missing  missing  missing\n missing  missing  missing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"An array allowing for missing values but which does not contain any such value can be converted back to an array which does not allow for missing values using convert. If the array contains missing values, a MethodError is thrown during conversion","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> x = Union{Missing, String}[\"a\", \"b\"]\n2-element Array{Union{Missing, String},1}:\n \"a\"\n \"b\"\n\njulia> convert(Array{String}, x)\n2-element Array{String,1}:\n \"a\"\n \"b\"\n\njulia> y = Union{Missing, String}[missing, \"b\"]\n2-element Array{Union{Missing, String},1}:\n missing\n \"b\"\n\njulia> convert(Array{String}, y)\nERROR: MethodError: Cannot `convert` an object of type Missing to an object of type String","category":"page"},{"location":"manual/missing.html#Skipping-Missing-Values-1","page":"Missing Values","title":"Skipping Missing Values","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Since missing values propagate with standard mathematical operators, reduction functions return missing when called on arrays which contain missing values","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> sum([1, missing])\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"In this situation, use the skipmissing function to skip missing values","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> sum(skipmissing([1, missing]))\n1","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"This convenience function returns an iterator which filters out missing values efficiently. It can therefore be used with any function which supports iterators","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> x = skipmissing([3, missing, 2, 1])\nBase.SkipMissing{Array{Union{Missing, Int64},1}}(Union{Missing, Int64}[3, missing, 2, 1])\n\njulia> maximum(x)\n3\n\njulia> mean(x)\n2.0\n\njulia> mapreduce(sqrt, +, x)\n4.146264369941973","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Objects created by calling skipmissing on an array can be indexed using indices from the parent array. Indices corresponding to missing values are not valid for these objects and an error is thrown when trying to use them (they are also skipped by keys and eachindex)","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> x[1]\n3\n\njulia> x[2]\nERROR: MissingException: the value at index (2,) is missing\n[...]","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"This allows functions which operate on indices to work in combination with skipmissing. This is notably the case for search and find functions, which return indices valid for the object returned by skipmissing which are also the indices of the matching entries in the parent array","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> findall(==(1), x)\n1-element Array{Int64,1}:\n 4\n\njulia> findfirst(!iszero, x)\n1\n\njulia> argmax(x)\n1","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Use collect to extract non-missing values and store them in an array","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> collect(x)\n3-element Array{Int64,1}:\n 3\n 2\n 1","category":"page"},{"location":"manual/missing.html#Logical-Operations-on-Arrays-1","page":"Missing Values","title":"Logical Operations on Arrays","text":"","category":"section"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"The three-valued logic described above for logical operators is also used by logical functions applied to arrays. Thus, array equality tests using the == operator return missing whenever the result cannot be determined without knowing the actual value of the missing entry. In practice, this means that missing is returned if all non-missing values of the compared arrays are equal, but one or both arrays contain missing values (possibly at different positions)","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> [1, missing] == [2, missing]\nfalse\n\njulia> [1, missing] == [1, missing]\nmissing\n\njulia> [1, 2, missing] == [1, missing, 2]\nmissing","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"As for single values, use isequal to treat missing values as equal to other missing values but different from non-missing values","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> isequal([1, missing], [1, missing])\ntrue\n\njulia> isequal([1, 2, missing], [1, missing, 2])\nfalse","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"Functions any and all also follow the rules of three-valued logic, returning missing when the result cannot be determined","category":"page"},{"location":"manual/missing.html#","page":"Missing Values","title":"Missing Values","text":"julia> all([true, missing])\nmissing\n\njulia> all([false, missing])\nfalse\n\njulia> any([true, missing])\ntrue\n\njulia> any([false, missing])\nmissing","category":"page"},{"location":"manual/networking-and-streams.html#Networking-and-Streams-1","page":"Networking and Streams","title":"Networking and Streams","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Julia provides a rich interface to deal with streaming I/O objects such as terminals, pipes and TCP sockets. This interface, though asynchronous at the system level, is presented in a synchronous manner to the programmer and it is usually unnecessary to think about the underlying asynchronous operation. This is achieved by making heavy use of Julia cooperative threading (coroutine) functionality.","category":"page"},{"location":"manual/networking-and-streams.html#Basic-Stream-I/O-1","page":"Networking and Streams","title":"Basic Stream I/O","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"All Julia streams expose at least a read and a write method, taking the stream as their first argument, e.g.:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> write(stdout, \"Hello World\");  # suppress return value 11 with ;\nHello World\njulia> read(stdin, Char)\n\n'\\n': ASCII/Unicode U+000a (category Cc: Other, control)","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Note that write returns 11, the number of bytes (in \"Hello World\") written to stdout, but this return value is suppressed with the ;.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Here Enter was pressed again so that Julia would read the newline. Now, as you can see from this example, write takes the data to write as its second argument, while read takes the type of the data to be read as the second argument.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"For example, to read a simple byte array, we could do:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> x = zeros(UInt8, 4)\n4-element Array{UInt8,1}:\n 0x00\n 0x00\n 0x00\n 0x00\n\njulia> read!(stdin, x)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"However, since this is slightly cumbersome, there are several convenience methods provided. For example, we could have written the above as:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> read(stdin, 4)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"or if we had wanted to read the entire line instead:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> readline(stdin)\nabcd\n\"abcd\"","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Note that depending on your terminal settings, your TTY may be line buffered and might thus require an additional enter before the data is sent to Julia.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"To read every line from stdin you can use eachline:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"for line in eachline(stdin)\n    print(\"Found $line\")\nend","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"or read if you wanted to read by character instead:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"while !eof(stdin)\n    x = read(stdin, Char)\n    println(\"Found: $x\")\nend","category":"page"},{"location":"manual/networking-and-streams.html#Text-I/O-1","page":"Networking and Streams","title":"Text I/O","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Note that the write method mentioned above operates on binary streams. In particular, values do not get converted to any canonical text representation but are written out as is:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> write(stdout, 0x61);  # suppress return value 1 with ;\na","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Note that a is written to stdout by the write function and that the returned value is 1 (since 0x61 is one byte).","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"For text I/O, use the print or show methods, depending on your needs (see the documentation for these two methods for a detailed discussion of the difference between them):","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> print(stdout, 0x61)\n97","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"See Custom pretty-printing for more information on how to implement display methods for custom types.","category":"page"},{"location":"manual/networking-and-streams.html#IO-Output-Contextual-Properties-1","page":"Networking and Streams","title":"IO Output Contextual Properties","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Sometimes IO output can benefit from the ability to pass contextual information into show methods. The IOContext object provides this framework for associating arbitrary metadata with an IO object. For example, :compact => true adds a hinting parameter to the IO object that the invoked show method should print a shorter output (if applicable). See the IOContext documentation for a list of common properties.","category":"page"},{"location":"manual/networking-and-streams.html#Working-with-Files-1","page":"Networking and Streams","title":"Working with Files","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Like many other environments, Julia has an open function, which takes a filename and returns an IOStream object that you can use to read and write things from the file. For example, if we have a file, hello.txt, whose contents are Hello, World!:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> f = open(\"hello.txt\")\nIOStream(<file hello.txt>)\n\njulia> readlines(f)\n1-element Array{String,1}:\n \"Hello, World!\"","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"If you want to write to a file, you can open it with the write (\"w\") flag:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> f = open(\"hello.txt\",\"w\")\nIOStream(<file hello.txt>)\n\njulia> write(f,\"Hello again.\")\n12","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"If you examine the contents of hello.txt at this point, you will notice that it is empty; nothing has actually been written to disk yet. This is because the IOStream must be closed before the write is actually flushed to disk:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> close(f)","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Examining hello.txt again will show its contents have been changed.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Opening a file, doing something to its contents, and closing it again is a very common pattern. To make this easier, there exists another invocation of open which takes a function as its first argument and filename as its second, opens the file, calls the function with the file as an argument, and then closes it again. For example, given a function:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"function read_and_capitalize(f::IOStream)\n    return uppercase(read(f, String))\nend","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"You can call:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> open(read_and_capitalize, \"hello.txt\")\n\"HELLO AGAIN.\"","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"to open hello.txt, call read_and_capitalize on it, close hello.txt and return the capitalized contents.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"To avoid even having to define a named function, you can use the do syntax, which creates an anonymous function on the fly:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> open(\"hello.txt\") do f\n           uppercase(read(f, String))\n       end\n\"HELLO AGAIN.\"","category":"page"},{"location":"manual/networking-and-streams.html#A-simple-TCP-example-1","page":"Networking and Streams","title":"A simple TCP example","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Let's jump right in with a simple example involving TCP sockets. This functionality is in a standard library package called Sockets. Let's first create a simple server:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> using Sockets\n\njulia> @async begin\n           server = listen(2000)\n           while true\n               sock = accept(server)\n               println(\"Hello World\\n\")\n           end\n       end\nTask (runnable) @0x00007fd31dc11ae0","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"To those familiar with the Unix socket API, the method names will feel familiar, though their usage is somewhat simpler than the raw Unix socket API. The first call to listen will create a server waiting for incoming connections on the specified port (2000) in this case. The same function may also be used to create various other kinds of servers:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> listen(2000) # Listens on localhost:2000 (IPv4)\nSockets.TCPServer(active)\n\njulia> listen(ip\"127.0.0.1\",2000) # Equivalent to the first\nSockets.TCPServer(active)\n\njulia> listen(ip\"::1\",2000) # Listens on localhost:2000 (IPv6)\nSockets.TCPServer(active)\n\njulia> listen(IPv4(0),2001) # Listens on port 2001 on all IPv4 interfaces\nSockets.TCPServer(active)\n\njulia> listen(IPv6(0),2001) # Listens on port 2001 on all IPv6 interfaces\nSockets.TCPServer(active)\n\njulia> listen(\"testsocket\") # Listens on a UNIX domain socket\nSockets.PipeServer(active)\n\njulia> listen(\"\\\\\\\\.\\\\pipe\\\\testsocket\") # Listens on a Windows named pipe\nSockets.PipeServer(active)","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"Note that the return type of the last invocation is different. This is because this server does not listen on TCP, but rather on a named pipe (Windows) or UNIX domain socket. Also note that Windows named pipe format has to be a specific pattern such that the name prefix (\\\\.\\pipe\\) uniquely identifies the file type. The difference between TCP and named pipes or UNIX domain sockets is subtle and has to do with the accept and connect methods. The accept method retrieves a connection to the client that is connecting on the server we just created, while the connect function connects to a server using the specified method. The connect function takes the same arguments as listen, so, assuming the environment (i.e. host, cwd, etc.) is the same you should be able to pass the same arguments to connect as you did to listen to establish the connection. So let's try that out (after having created the server above):","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> connect(2000)\nTCPSocket(open, 0 bytes waiting)\n\njulia> Hello World","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"As expected we saw \"Hello World\" printed. So, let's actually analyze what happened behind the scenes. When we called connect, we connect to the server we had just created. Meanwhile, the accept function returns a server-side connection to the newly created socket and prints \"Hello World\" to indicate that the connection was successful.","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"A great strength of Julia is that since the API is exposed synchronously even though the I/O is actually happening asynchronously, we didn't have to worry about callbacks or even making sure that the server gets to run. When we called connect the current task waited for the connection to be established and only continued executing after that was done. In this pause, the server task resumed execution (because a connection request was now available), accepted the connection, printed the message and waited for the next client. Reading and writing works in the same way. To see this, consider the following simple echo server:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> @async begin\n           server = listen(2001)\n           while true\n               sock = accept(server)\n               @async while isopen(sock)\n                   write(sock, readline(sock, keep=true))\n               end\n           end\n       end\nTask (runnable) @0x00007fd31dc12e60\n\njulia> clientside = connect(2001)\nTCPSocket(RawFD(28) open, 0 bytes waiting)\n\njulia> @async while isopen(clientside)\n           write(stdout, readline(clientside, keep=true))\n       end\nTask (runnable) @0x00007fd31dc11870\n\njulia> println(clientside,\"Hello World from the Echo Server\")\nHello World from the Echo Server","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"As with other streams, use close to disconnect the socket:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> close(clientside)","category":"page"},{"location":"manual/networking-and-streams.html#Resolving-IP-Addresses-1","page":"Networking and Streams","title":"Resolving IP Addresses","text":"","category":"section"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"One of the connect methods that does not follow the listen methods is connect(host::String,port), which will attempt to connect to the host given by the host parameter on the port given by the port parameter. It allows you to do things like:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> connect(\"google.com\", 80)\nTCPSocket(RawFD(30) open, 0 bytes waiting)","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"At the base of this functionality is getaddrinfo, which will do the appropriate address resolution:","category":"page"},{"location":"manual/networking-and-streams.html#","page":"Networking and Streams","title":"Networking and Streams","text":"julia> getaddrinfo(\"google.com\")\nip\"74.125.226.225\"","category":"page"},{"location":"manual/parallel-computing.html#Parallel-Computing-1","page":"Parallel Computing","title":"Parallel Computing","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For newcomers to multi-threading and parallel computing it can be useful to first appreciate the different levels of parallelism offered by Julia. We can divide them in three main categories :","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia Coroutines (Green Threading)\nMulti-Threading\nMulti-Core or Distributed Processing","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"We will first consider Julia Tasks (aka Coroutines) and other modules that rely on the Julia runtime library, that allow us to suspend and resume computations with full control of inter-Tasks communication without having to manually interface with the operating system's scheduler. Julia also supports communication between Tasks through operations like wait and fetch. Communication and data synchronization is managed through Channels, which are the conduits that provide inter-Tasks communication.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia also supports experimental multi-threading, where execution is forked and an anonymous function is run across all threads. Known as the fork-join approach, parallel threads execute independently, and must ultimately be joined in Julia's main thread to allow serial execution to continue. Multi-threading is supported using the Base.Threads module that is still considered experimental, as Julia is not yet fully thread-safe. In particular segfaults seem to occur during I/O operations and task switching. As an up-to-date reference, keep an eye on the issue tracker. Multi-Threading should only be used if you take into consideration global variables, locks and atomics, all of which are explained later.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In the end we will present Julia's approach to distributed and parallel computing. With scientific computing in mind, Julia natively implements interfaces to distribute a process across multiple cores or machines. Also we will mention useful external packages for distributed programming like MPI.jl and DistributedArrays.jl.","category":"page"},{"location":"manual/parallel-computing.html#Coroutines-1","page":"Parallel Computing","title":"Coroutines","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia's parallel programming platform uses Tasks (aka Coroutines) to switch among multiple computations. To express an order of execution between lightweight threads communication primitives are necessary. Julia offers Channel(func::Function, ctype=Any, csize=0, taskref=nothing) that creates a new task from func, binds it to a new channel of type ctype and size csize and schedule the task. Channels can serve as a way to communicate between tasks, as Channel{T}(sz::Int) creates a buffered channel of type T and size sz. Whenever code performs a communication operation like fetch or wait, the current task is suspended and a scheduler picks another task to run. A task is restarted when the event it is waiting for completes.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For many problems, it is not necessary to think about tasks directly. However, they can be used to wait for multiple events at the same time, which provides for dynamic scheduling. In dynamic scheduling, a program decides what to compute or where to compute it based on when other jobs finish. This is needed for unpredictable or unbalanced workloads, where we want to assign more work to processes only when they finish their current tasks.","category":"page"},{"location":"manual/parallel-computing.html#Channels-1","page":"Parallel Computing","title":"Channels","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The section on Tasks in Control Flow discussed the execution of multiple functions in a co-operative manner. Channels can be quite useful to pass data between running tasks, particularly those involving I/O operations.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Examples of operations involving I/O include reading/writing to files, accessing web services, executing external programs, etc. In all these cases, overall execution time can be improved if other tasks can be run while a file is being read, or while waiting for an external service/program to complete.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A channel can be visualized as a pipe, i.e., it has a write end and a read end :","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Multiple writers in different tasks can write to the same channel concurrently via put! calls.\nMultiple readers in different tasks can read data concurrently via take! calls.\nAs an example:\n# Given Channels c1 and c2,\nc1 = Channel(32)\nc2 = Channel(32)\n\n# and a function `foo` which reads items from c1, processes the item read\n# and writes a result to c2,\nfunction foo()\n    while true\n        data = take!(c1)\n        [...]               # process data\n        put!(c2, result)    # write out result\n    end\nend\n\n# we can schedule `n` instances of `foo` to be active concurrently.\nfor _ in 1:n\n    @async foo()\nend\nChannels are created via the Channel{T}(sz) constructor. The channel will only hold objects of type T. If the type is not specified, the channel can hold objects of any type. sz refers to the maximum number of elements that can be held in the channel at any time. For example, Channel(32) creates a channel that can hold a maximum of 32 objects of any type. A Channel{MyType}(64) can hold up to 64 objects of MyType at any time.\nIf a Channel is empty, readers (on a take! call) will block until data is available.\nIf a Channel is full, writers (on a put! call) will block until space becomes available.\nisready tests for the presence of any object in the channel, while wait waits for an object to become available.\nA Channel is in an open state initially. This means that it can be read from and written to freely via take! and put! calls. close closes a Channel. On a closed Channel, put! will fail. For example:\njulia> c = Channel(2);\n\njulia> put!(c, 1) # `put!` on an open channel succeeds\n1\n\njulia> close(c);\n\njulia> put!(c, 2) # `put!` on a closed channel throws an exception.\nERROR: InvalidStateException(\"Channel is closed.\",:closed)\nStacktrace:\n[...]\ntake! and fetch (which retrieves but does not remove the value) on a closed channel successfully return any existing values until it is emptied. Continuing the above example:\njulia> fetch(c) # Any number of `fetch` calls succeed.\n1\n\njulia> fetch(c)\n1\n\njulia> take!(c) # The first `take!` removes the value.\n1\n\njulia> take!(c) # No more data available on a closed channel.\nERROR: InvalidStateException(\"Channel is closed.\",:closed)\nStacktrace:\n[...]","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A Channel can be used as an iterable object in a for loop, in which case the loop runs as long as the Channel has data or is open. The loop variable takes on all values added to the Channel. The for loop is terminated once the Channel is closed and emptied.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For example, the following would cause the for loop to wait for more data:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> c = Channel{Int}(10);\n\njulia> foreach(i->put!(c, i), 1:3) # add a few entries\n\njulia> data = [i for i in c]","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"while this will return after reading all data:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> c = Channel{Int}(10);\n\njulia> foreach(i->put!(c, i), 1:3); # add a few entries\n\njulia> close(c);                    # `for` loops can exit\n\njulia> data = [i for i in c]\n3-element Array{Int64,1}:\n 1\n 2\n 3","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Consider a simple example using channels for inter-task communication. We start 4 tasks to process data from a single jobs channel. Jobs, identified by an id (job_id), are written to the channel. Each task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id and the simulated time to the results channel. Finally all the results are printed out.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> const jobs = Channel{Int}(32);\n\njulia> const results = Channel{Tuple}(32);\n\njulia> function do_work()\n           for job_id in jobs\n               exec_time = rand()\n               sleep(exec_time)                # simulates elapsed time doing actual work\n                                               # typically performed externally.\n               put!(results, (job_id, exec_time))\n           end\n       end;\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> @async make_jobs(n); # feed the jobs channel with \"n\" jobs\n\njulia> for i in 1:4 # start 4 tasks to process requests in parallel\n           @async do_work()\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds\")\n           global n = n - 1\n       end\n4 finished in 0.22 seconds\n3 finished in 0.45 seconds\n1 finished in 0.5 seconds\n7 finished in 0.14 seconds\n2 finished in 0.78 seconds\n5 finished in 0.9 seconds\n9 finished in 0.36 seconds\n6 finished in 0.87 seconds\n8 finished in 0.79 seconds\n10 finished in 0.64 seconds\n12 finished in 0.5 seconds\n11 finished in 0.97 seconds\n0.029772311","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The current version of Julia multiplexes all tasks onto a single OS thread. Thus, while tasks involving I/O operations benefit from parallel execution, compute bound tasks are effectively executed sequentially on a single OS thread. Future versions of Julia may support scheduling of tasks on multiple threads, in which case compute bound tasks will see benefits of parallel execution too.","category":"page"},{"location":"manual/parallel-computing.html#man-multithreading-1","page":"Parallel Computing","title":"Multi-Threading (Experimental)","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In addition to tasks Julia forwards natively supports multi-threading. Note that this section is experimental and the interfaces may change in the future.","category":"page"},{"location":"manual/parallel-computing.html#Setup-1","page":"Parallel Computing","title":"Setup","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"By default, Julia starts up with a single thread of execution. This can be verified by using the command Threads.nthreads():","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> Threads.nthreads()\n1","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The number of threads Julia starts up with is controlled by an environment variable called JULIA_NUM_THREADS. Now, let's start up Julia with 4 threads:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"export JULIA_NUM_THREADS=4","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"(The above command works on bourne shells on Linux and OSX. Note that if you're using a C shell on these platforms, you should use the keyword set instead of export. If you're on Windows, start up the command line in the location of julia.exe and use set instead of export.)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Let's verify there are 4 threads at our disposal.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> Threads.nthreads()\n4","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"But we are currently on the master thread. To check, we use the function Threads.threadid","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> Threads.threadid()\n1","category":"page"},{"location":"manual/parallel-computing.html#The-@threads-Macro-1","page":"Parallel Computing","title":"The @threads Macro","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Let's work a simple example using our native threads. Let us create an array of zeros:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> a = zeros(10)\n10-element Array{Float64,1}:\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0\n 0.0","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Let us operate on this array simultaneously using 4 threads. We'll have each thread write its thread ID into each location.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia supports parallel loops using the Threads.@threads macro. This macro is affixed in front of a for loop to indicate to Julia that the loop is a multi-threaded region:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> Threads.@threads for i = 1:10\n           a[i] = Threads.threadid()\n       end","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The iteration space is split amongst the threads, after which each thread writes its thread ID to its assigned locations:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> a\n10-element Array{Float64,1}:\n 1.0\n 1.0\n 1.0\n 2.0\n 2.0\n 2.0\n 3.0\n 3.0\n 4.0\n 4.0","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that Threads.@threads does not have an optional reduction parameter like @distributed.","category":"page"},{"location":"manual/parallel-computing.html#Atomic-Operations-1","page":"Parallel Computing","title":"Atomic Operations","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia supports accessing and modifying values atomically, that is, in a thread-safe way to avoid race conditions. A value (which must be of a primitive type) can be wrapped as Threads.Atomic to indicate it must be accessed in this way. Here we can see an example:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> i = Threads.Atomic{Int}(0);\n\njulia> ids = zeros(4);\n\njulia> old_is = zeros(4);\n\njulia> Threads.@threads for id in 1:4\n           old_is[id] = Threads.atomic_add!(i, id)\n           ids[id] = id\n       end\n\njulia> old_is\n4-element Array{Float64,1}:\n 0.0\n 1.0\n 7.0\n 3.0\n\njulia> ids\n4-element Array{Float64,1}:\n 1.0\n 2.0\n 3.0\n 4.0","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Had we tried to do the addition without the atomic tag, we might have gotten the wrong answer due to a race condition. An example of what would happen if we didn't avoid the race:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Base.Threads\n\njulia> nthreads()\n4\n\njulia> acc = Ref(0)\nBase.RefValue{Int64}(0)\n\njulia> @threads for i in 1:1000\n          acc[] += 1\n       end\n\njulia> acc[]\n926\n\njulia> acc = Atomic{Int64}(0)\nAtomic{Int64}(0)\n\njulia> @threads for i in 1:1000\n          atomic_add!(acc, 1)\n       end\n\njulia> acc[]\n1000","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"note: Note\nNot all primitive types can be wrapped in an Atomic tag. Supported types are Int8, Int16, Int32, Int64, Int128, UInt8, UInt16, UInt32, UInt64, UInt128, Float16, Float32, and Float64. Additionally, Int128 and UInt128 are not supported on AAarch32 and ppc64le.","category":"page"},{"location":"manual/parallel-computing.html#Side-effects-and-mutable-function-arguments-1","page":"Parallel Computing","title":"Side effects and mutable function arguments","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"When using multi-threading we have to be careful when using functions that are not pure as we might get a wrong answer. For instance functions that have their name ending with ! by convention modify their arguments and thus are not pure. However, there are functions that have side effects and their name does not end with !. For instance findfirst(regex, str) mutates its regex argument or rand() changes Base.GLOBAL_RNG :","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Base.Threads\n\njulia> nthreads()\n4\n\njulia> function f()\n           s = repeat([\"123\", \"213\", \"231\"], outer=1000)\n           x = similar(s, Int)\n           rx = r\"1\"\n           @threads for i in 1:3000\n               x[i] = findfirst(rx, s[i]).start\n           end\n           count(v -> v == 1, x)\n       end\nf (generic function with 1 method)\n\njulia> f() # the correct result is 1000\n1017\n\njulia> function g()\n           a = zeros(1000)\n           @threads for i in 1:1000\n               a[i] = rand()\n           end\n           length(unique(a))\n       end\ng (generic function with 1 method)\n\njulia> Random.seed!(1); g() # the result for a single thread is 1000\n781","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In such cases one should redesign the code to avoid the possibility of a race condition or use synchronization primitives.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For example in order to fix findfirst example above one needs to have a separate copy of rx variable for each thread:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> function f_fix()\n             s = repeat([\"123\", \"213\", \"231\"], outer=1000)\n             x = similar(s, Int)\n             rx = [Regex(\"1\") for i in 1:nthreads()]\n             @threads for i in 1:3000\n                 x[i] = findfirst(rx[threadid()], s[i]).start\n             end\n             count(v -> v == 1, x)\n         end\nf_fix (generic function with 1 method)\n\njulia> f_fix()\n1000","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"We now use Regex(\"1\") instead of r\"1\" to make sure that Julia creates separate instances of Regex object for each entry of rx vector.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The case of rand is a bit more complex as we have to ensure that each thread uses non-overlapping pseudorandom number sequences. This can be simply ensured by using Future.randjump function:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Random; import Future\n\njulia> function g_fix(r)\n           a = zeros(1000)\n           @threads for i in 1:1000\n               a[i] = rand(r[threadid()])\n           end\n           length(unique(a))\n       end\ng_fix (generic function with 1 method)\n\njulia>  r = let m = MersenneTwister(1)\n                [m; accumulate(Future.randjump, fill(big(10)^20, nthreads()-1), init=m)]\n            end;\n\njulia> g_fix(r)\n1000","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"We pass the r vector to g_fix as generating several RGNs is an expensive operation so we do not want to repeat it every time we run the function.","category":"page"},{"location":"manual/parallel-computing.html#@threadcall-(Experimental)-1","page":"Parallel Computing","title":"@threadcall (Experimental)","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"All I/O tasks, timers, REPL commands, etc are multiplexed onto a single OS thread via an event loop. A patched version of libuv (http://docs.libuv.org/en/v1.x/) provides this functionality. Yield points provide for co-operatively scheduling multiple tasks onto the same OS thread. I/O tasks and timers yield implicitly while waiting for the event to occur. Calling yield explicitly allows for other tasks to be scheduled.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Thus, a task executing a ccall effectively prevents the Julia scheduler from executing any other tasks till the call returns. This is true for all calls into external libraries. Exceptions are calls into custom C code that call back into Julia (which may then yield) or C code that calls jl_yield() (C equivalent of yield).","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that while Julia code runs on a single thread (by default), libraries used by Julia may launch their own internal threads. For example, the BLAS library may start as many threads as there are cores on a machine.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The @threadcall macro addresses scenarios where we do not want a ccall to block the main Julia event loop. It schedules a C function for execution in a separate thread. A threadpool with a default size of 4 is used for this. The size of the threadpool is controlled via environment variable UV_THREADPOOL_SIZE. While waiting for a free thread, and during function execution once a thread is available, the requesting task (on the main Julia event loop) yields to other tasks. Note that @threadcall does not return till the execution is complete. From a user point of view, it is therefore a blocking call like other Julia APIs.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"It is very important that the called function does not call back into Julia, as it will segfault.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"@threadcall may be removed/changed in future versions of Julia.","category":"page"},{"location":"manual/parallel-computing.html#Multi-Core-or-Distributed-Processing-1","page":"Parallel Computing","title":"Multi-Core or Distributed Processing","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"An implementation of distributed memory parallel computing is provided by module Distributed as part of the standard library shipped with Julia.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Most modern computers possess more than one CPU, and several computers can be combined together in a cluster. Harnessing the power of these multiple CPUs allows many computations to be completed more quickly. There are two major factors that influence performance: the speed of the CPUs themselves, and the speed of their access to memory. In a cluster, it's fairly obvious that a given CPU will have fastest access to the RAM within the same computer (node). Perhaps more surprisingly, similar issues are relevant on a typical multicore laptop, due to differences in the speed of main memory and the cache. Consequently, a good multiprocessing environment should allow control over the \"ownership\" of a chunk of memory by a particular CPU. Julia provides a multiprocessing environment based on message passing to allow programs to run on multiple processes in separate memory domains at once.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia's implementation of message passing is different from other environments such as MPI [1]. Communication in Julia is generally \"one-sided\", meaning that the programmer needs to explicitly manage only one process in a two-process operation. Furthermore, these operations typically do not look like \"message send\" and \"message receive\" but rather resemble higher-level operations like calls to user functions.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Distributed programming in Julia is built on two primitives: remote references and remote calls. A remote reference is an object that can be used from any process to refer to an object stored on a particular process. A remote call is a request by one process to call a certain function on certain arguments on another (possibly the same) process.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Remote references come in two flavors: Future and RemoteChannel.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A remote call returns a Future to its result. Remote calls return immediately; the process that made the call proceeds to its next operation while the remote call happens somewhere else. You can wait for a remote call to finish by calling wait on the returned Future, and you can obtain the full value of the result using fetch.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"On the other hand, RemoteChannel s are rewritable. For example, multiple processes can co-ordinate their processing by referencing the same remote Channel.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Each process has an associated identifier. The process providing the interactive Julia prompt always has an id equal to 1. The processes used by default for parallel operations are referred to as \"workers\". When there is only one process, process 1 is considered a worker. Otherwise, workers are considered to be all processes other than process 1.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Let's try this out. Starting with julia -p n provides n worker processes on the local machine. Generally it makes sense for n to equal the number of CPU threads (logical cores) on the machine. Note that the -p argument implicitly loads module Distributed.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"$ ./julia -p 2\n\njulia> r = remotecall(rand, 2, 2, 2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawnat 2 1 .+ fetch(r)\nFuture(2, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.18526  1.50912\n 1.16296  1.60607","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The first argument to remotecall is the function to call. Most parallel programming in Julia does not reference specific processes or the number of processes available, but remotecall is considered a low-level interface providing finer control. The second argument to remotecall is the id of the process that will do the work, and the remaining arguments will be passed to the function being called.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As you can see, in the first line we asked process 2 to construct a 2-by-2 random matrix, and in the second line we asked it to add 1 to it. The result of both calculations is available in the two futures, r and s. The @spawnat macro evaluates the expression in the second argument on the process specified by the first argument.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Occasionally you might want a remotely-computed value immediately. This typically happens when you read from a remote object to obtain data needed by the next local operation. The function remotecall_fetch exists for this purpose. It is equivalent to fetch(remotecall(...)) but is more efficient.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> remotecall_fetch(getindex, 2, r, 1, 1)\n0.18526337335308085","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Remember that getindex(r,1,1) is equivalent to r[1,1], so this call fetches the first element of the future r.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The syntax of remotecall is not especially convenient. The macro @spawn makes things easier. It operates on an expression rather than a function, and picks where to do the operation for you:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> r = @spawn rand(2,2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawn 1 .+ fetch(r)\nFuture(3, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.38854  1.9098\n 1.20939  1.57158","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that we used 1 .+ fetch(r) instead of 1 .+ r. This is because we do not know where the code will run, so in general a fetch might be required to move r to the process doing the addition. In this case, @spawn is smart enough to perform the computation on the process that owns r, so the fetch will be a no-op (no work is done).","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"(It is worth noting that @spawn is not built-in but defined in Julia as a macro. It is possible to define your own such constructs.)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"An important thing to remember is that, once fetched, a Future will cache its value locally. Further fetch calls do not entail a network hop. Once all referencing Futures have fetched, the remote stored value is deleted.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"@async is similar to @spawn, but only runs tasks on the local process. We use it to create a \"feeder\" task for each process. Each task picks the next index that needs to be computed, then waits for its process to finish, then repeats until we run out of indices. Note that the feeder tasks do not begin to execute until the main task reaches the end of the @sync block, at which point it surrenders control and waits for all the local tasks to complete before returning from the function. As for v0.7 and beyond, the feeder tasks are able to share state via nextidx because they all run on the same process. Even if Tasks are scheduled cooperatively, locking may still be required in some contexts, as in asynchronous I/O. This means context switches only occur at well-defined points: in this case, when remotecall_fetch is called. This is the current state of implementation and it may change for future Julia versions, as it is intended to make it possible to run up to N Tasks on M Process, aka M:N Threading. Then a lock acquiring\\releasing model for nextidx will be needed, as it is not safe to let multiple processes read-write a resource at the same time.","category":"page"},{"location":"manual/parallel-computing.html#code-availability-1","page":"Parallel Computing","title":"Code Availability and Loading Packages","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Your code must be available on any process that runs it. For example, type the following into the Julia prompt:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> function rand2(dims...)\n           return 2*rand(dims...)\n       end\n\njulia> rand2(2,2)\n2×2 Array{Float64,2}:\n 0.153756  0.368514\n 1.15119   0.918912\n\njulia> fetch(@spawn rand2(2,2))\nERROR: RemoteException(2, CapturedException(UndefVarError(Symbol(\"#rand2\"))\nStacktrace:\n[...]","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Process 1 knew about the function rand2, but process 2 did not.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Most commonly you'll be loading code from files or packages, and you have a considerable amount of flexibility in controlling which processes load code. Consider a file, DummyModule.jl, containing the following code:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"module DummyModule\n\nexport MyType, f\n\nmutable struct MyType\n    a::Int\nend\n\nf(x) = x^2+1\n\nprintln(\"loaded\")\n\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In order to refer to MyType across all processes, DummyModule.jl needs to be loaded on every process.  Calling include(\"DummyModule.jl\") loads it only on a single process.  To load it on every process, use the @everywhere macro (starting Julia with julia -p 2):","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @everywhere include(\"DummyModule.jl\")\nloaded\n      From worker 3:    loaded\n      From worker 2:    loaded","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As usual, this does not bring DummyModule into scope on any of the process, which requires using or import.  Moreover, when DummyModule is brought into scope on one process, it is not on any other:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using .DummyModule\n\njulia> MyType(7)\nMyType(7)\n\njulia> fetch(@spawnat 2 MyType(7))\nERROR: On worker 2:\nUndefVarError: MyType not defined\n⋮\n\njulia> fetch(@spawnat 2 DummyModule.MyType(7))\nMyType(7)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"However, it's still possible, for instance, to send a MyType to a process which has loaded DummyModule even if it's not in scope:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> put!(RemoteChannel(2), MyType(7))\nRemoteChannel{Channel{Any}}(2, 1, 13)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A file can also be preloaded on multiple processes at startup with the -L flag, and a driver script can be used to drive the computation:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia -p <n> -L file1.jl -L file2.jl driver.jl","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The Julia process running the driver script in the example above has an id equal to 1, just like a process providing an interactive prompt.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Finally, if DummyModule.jl is not a standalone file but a package, then using DummyModule will load DummyModule.jl on all processes, but only bring it into scope on the process where using was called.","category":"page"},{"location":"manual/parallel-computing.html#Starting-and-managing-worker-processes-1","page":"Parallel Computing","title":"Starting and managing worker processes","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The base Julia installation has in-built support for two types of clusters:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A local cluster specified with the -p option as shown above.\nA cluster spanning machines using the --machine-file option. This uses a passwordless ssh login to start Julia worker processes (from the same path as the current host) on the specified machines.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Functions addprocs, rmprocs, workers, and others are available as a programmatic means of adding, removing and querying the processes in a cluster.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Distributed\n\njulia> addprocs(2)\n2-element Array{Int64,1}:\n 2\n 3","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Module Distributed must be explicitly loaded on the master process before invoking addprocs. It is automatically made available on the worker processes.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that workers do not run a ~/.julia/config/startup.jl startup script, nor do they synchronize their global state (such as global variables, new method definitions, and loaded modules) with any of the other running processes.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Other types of clusters can be supported by writing your own custom ClusterManager, as described below in the ClusterManagers section.","category":"page"},{"location":"manual/parallel-computing.html#Data-Movement-1","page":"Parallel Computing","title":"Data Movement","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Sending messages and moving data constitute most of the overhead in a distributed program. Reducing the number of messages and the amount of data sent is critical to achieving performance and scalability. To this end, it is important to understand the data movement performed by Julia's various distributed programming constructs.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"fetch can be considered an explicit data movement operation, since it directly asks that an object be moved to the local machine. @spawn (and a few related constructs) also moves data, but this is not as obvious, hence it can be called an implicit data movement operation. Consider these two approaches to constructing and squaring a random matrix:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Method 1:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> A = rand(1000,1000);\n\njulia> Bref = @spawn A^2;\n\n[...]\n\njulia> fetch(Bref);","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Method 2:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> Bref = @spawn rand(1000,1000)^2;\n\n[...]\n\njulia> fetch(Bref);","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The difference seems trivial, but in fact is quite significant due to the behavior of @spawn. In the first method, a random matrix is constructed locally, then sent to another process where it is squared. In the second method, a random matrix is both constructed and squared on another process. Therefore the second method sends much less data than the first.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In this toy example, the two methods are easy to distinguish and choose from. However, in a real program designing data movement might require more thought and likely some measurement. For example, if the first process needs matrix A then the first method might be better. Or, if computing A is expensive and only the current process has it, then moving it to another process might be unavoidable. Or, if the current process has very little to do between the @spawn and fetch(Bref), it might be better to eliminate the parallelism altogether. Or imagine rand(1000,1000) is replaced with a more expensive operation. Then it might make sense to add another @spawn statement just for this step.","category":"page"},{"location":"manual/parallel-computing.html#Global-variables-1","page":"Parallel Computing","title":"Global variables","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Expressions executed remotely via @spawn, or closures specified for remote execution using remotecall may refer to global variables. Global bindings under module Main are treated a little differently compared to global bindings in other modules. Consider the following code snippet:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A = rand(10,10)\nremotecall_fetch(()->sum(A), 2)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In this case sum MUST be defined in the remote process. Note that A is a global variable defined in the local workspace. Worker 2 does not have a variable called A under Main. The act of shipping the closure ()->sum(A) to worker 2 results in Main.A being defined on 2. Main.A continues to exist on worker 2 even after the call remotecall_fetch returns. Remote calls with embedded global references (under Main module only) manage globals as follows:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"New global bindings are created on destination workers if they are referenced as part of a remote call.\nGlobal constants are declared as constants on remote nodes too.\nGlobals are re-sent to a destination worker only in the context of a remote call, and then only if its value has changed. Also, the cluster does not synchronize global bindings across nodes. For example:\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 2) # worker 2\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 3) # worker 3\nA = nothing\nExecuting the above snippet results in Main.A on worker 2 having a different value from Main.A on worker 3, while the value of Main.A on node 1 is set to nothing.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As you may have realized, while memory associated with globals may be collected when they are reassigned on the master, no such action is taken on the workers as the bindings continue to be valid. clear! can be used to manually reassign specific globals on remote nodes to nothing once they are no longer required. This will release any memory associated with them as part of a regular garbage collection cycle.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Thus programs should be careful referencing globals in remote calls. In fact, it is preferable to avoid them altogether if possible. If you must reference globals, consider using let blocks to localize global variables.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For example:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> A = rand(10,10);\n\njulia> remotecall_fetch(()->A, 2);\n\njulia> B = rand(10,10);\n\njulia> let B = B\n           remotecall_fetch(()->B, 2)\n       end;\n\njulia> @fetchfrom 2 InteractiveUtils.varinfo()\nname           size summary\n––––––––– ––––––––– ––––––––––––––––––––––\nA         800 bytes 10×10 Array{Float64,2}\nBase                Module\nCore                Module\nMain                Module","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As can be seen, global variable A is defined on worker 2, but B is captured as a local variable and hence a binding for B does not exist on worker 2.","category":"page"},{"location":"manual/parallel-computing.html#Parallel-Map-and-Loops-1","page":"Parallel Computing","title":"Parallel Map and Loops","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Fortunately, many useful parallel computations do not require data movement. A common example is a Monte Carlo simulation, where multiple processes can handle independent simulation trials simultaneously. We can use @spawn to flip coins on two processes. First, write the following function in count_heads.jl:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"function count_heads(n)\n    c::Int = 0\n    for i = 1:n\n        c += rand(Bool)\n    end\n    c\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The function count_heads simply adds together n random bits. Here is how we can perform some trials on two machines, and add together the results:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @everywhere include_string(Main, $(read(\"count_heads.jl\", String)), \"count_heads.jl\")\n\njulia> a = @spawn count_heads(100000000)\nFuture(2, 1, 6, nothing)\n\njulia> b = @spawn count_heads(100000000)\nFuture(3, 1, 7, nothing)\n\njulia> fetch(a)+fetch(b)\n100001564","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"This example demonstrates a powerful and often-used parallel programming pattern. Many iterations run independently over several processes, and then their results are combined using some function. The combination process is called a reduction, since it is generally tensor-rank-reducing: a vector of numbers is reduced to a single number, or a matrix is reduced to a single row or column, etc. In code, this typically looks like the pattern x = f(x,v[i]), where x is the accumulator, f is the reduction function, and the v[i] are the elements being reduced. It is desirable for f to be associative, so that it does not matter what order the operations are performed in.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Notice that our use of this pattern with count_heads can be generalized. We used two explicit @spawn statements, which limits the parallelism to two processes. To run on any number of processes, we can use a parallel for loop, running in distributed memory, which can be written in Julia using @distributed like this:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"nheads = @distributed (+) for i = 1:200000000\n    Int(rand(Bool))\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"This construct implements the pattern of assigning iterations to multiple processes, and combining them with a specified reduction (in this case (+)). The result of each iteration is taken as the value of the last expression inside the loop. The whole parallel loop expression itself evaluates to the final answer.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that although parallel for loops look like serial for loops, their behavior is dramatically different. In particular, the iterations do not happen in a specified order, and writes to variables or arrays will not be globally visible since iterations run on different processes. Any variables used inside the parallel loop will be copied and broadcast to each process.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For example, the following code will not work as intended:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"a = zeros(100000)\n@distributed for i = 1:100000\n    a[i] = i\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"This code will not initialize all of a, since each process will have a separate copy of it. Parallel for loops like these must be avoided. Fortunately, Shared Arrays can be used to get around this limitation:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"using SharedArrays\n\na = SharedArray{Float64}(10)\n@distributed for i = 1:10\n    a[i] = i\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Using \"outside\" variables in parallel loops is perfectly reasonable if the variables are read-only:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"a = randn(1000)\n@distributed (+) for i = 1:100000\n    f(a[rand(1:end)])\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Here each iteration applies f to a randomly-chosen sample from a vector a shared by all processes.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As you could see, the reduction operator can be omitted if it is not needed. In that case, the loop executes asynchronously, i.e. it spawns independent tasks on all available workers and returns an array of Future immediately without waiting for completion. The caller can wait for the Future completions at a later point by calling fetch on them, or wait for completion at the end of the loop by prefixing it with @sync, like @sync @distributed for.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In some cases no reduction operator is needed, and we merely wish to apply a function to all integers in some range (or, more generally, to all elements in some collection). This is another useful operation called parallel map, implemented in Julia as the pmap function. For example, we could compute the singular values of several large random matrices in parallel as follows:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> M = Matrix{Float64}[rand(1000,1000) for i = 1:10];\n\njulia> pmap(svdvals, M);","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia's pmap is designed for the case where each function call does a large amount of work. In contrast, @distributed for can handle situations where each iteration is tiny, perhaps merely summing two numbers. Only worker processes are used by both pmap and @distributed for for the parallel computation. In case of @distributed for, the final reduction is done on the calling process.","category":"page"},{"location":"manual/parallel-computing.html#Remote-References-and-AbstractChannels-1","page":"Parallel Computing","title":"Remote References and AbstractChannels","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Remote references always refer to an implementation of an AbstractChannel.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A concrete implementation of an AbstractChannel (like Channel), is required to implement put!, take!, fetch, isready and wait. The remote object referred to by a Future is stored in a Channel{Any}(1), i.e., a Channel of size 1 capable of holding objects of Any type.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"RemoteChannel, which is rewritable, can point to any type and size of channels, or any other implementation of an AbstractChannel.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The constructor RemoteChannel(f::Function, pid)() allows us to construct references to channels holding more than one value of a specific type. f is a function executed on pid and it must return an AbstractChannel.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For example, RemoteChannel(()->Channel{Int}(10), pid), will return a reference to a channel of type Int and size 10. The channel exists on worker pid.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Methods put!, take!, fetch, isready and wait on a RemoteChannel are proxied onto the backing store on the remote process.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"RemoteChannel can thus be used to refer to user implemented AbstractChannel objects. A simple example of this is provided in dictchannel.jl in the Examples repository, which uses a dictionary as its remote store.","category":"page"},{"location":"manual/parallel-computing.html#Channels-and-RemoteChannels-1","page":"Parallel Computing","title":"Channels and RemoteChannels","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A Channel is local to a process. Worker 2 cannot directly refer to a Channel on worker 3 and vice-versa. A RemoteChannel, however, can put and take values across workers.\nA RemoteChannel can be thought of as a handle to a Channel.\nThe process id, pid, associated with a RemoteChannel identifies the process where the backing store, i.e., the backing Channel exists.\nAny process with a reference to a RemoteChannel can put and take items from the channel. Data is automatically sent to (or retrieved from) the process a RemoteChannel is associated with.\nSerializing  a Channel also serializes any data present in the channel. Deserializing it therefore effectively makes a copy of the original object.\nOn the other hand, serializing a RemoteChannel only involves the serialization of an identifier that identifies the location and instance of Channel referred to by the handle. A deserialized RemoteChannel object (on any worker), therefore also points to the same backing store as the original.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The channels example from above can be modified for interprocess communication, as shown below.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"We start 4 workers to process a single jobs remote channel. Jobs, identified by an id (job_id), are written to the channel. Each remotely executing task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id, time taken and its own pid to the results channel. Finally all the results are printed out on the master process.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> addprocs(4); # add worker processes\n\njulia> const jobs = RemoteChannel(()->Channel{Int}(32));\n\njulia> const results = RemoteChannel(()->Channel{Tuple}(32));\n\njulia> @everywhere function do_work(jobs, results) # define work function everywhere\n           while true\n               job_id = take!(jobs)\n               exec_time = rand()\n               sleep(exec_time) # simulates elapsed time doing actual work\n               put!(results, (job_id, exec_time, myid()))\n           end\n       end\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> @async make_jobs(n); # feed the jobs channel with \"n\" jobs\n\njulia> for p in workers() # start tasks on the workers to process requests in parallel\n           remote_do(do_work, p, jobs, results)\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time, where = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds on worker $where\")\n           global n = n - 1\n       end\n1 finished in 0.18 seconds on worker 4\n2 finished in 0.26 seconds on worker 5\n6 finished in 0.12 seconds on worker 4\n7 finished in 0.18 seconds on worker 4\n5 finished in 0.35 seconds on worker 5\n4 finished in 0.68 seconds on worker 2\n3 finished in 0.73 seconds on worker 3\n11 finished in 0.01 seconds on worker 3\n12 finished in 0.02 seconds on worker 3\n9 finished in 0.26 seconds on worker 5\n8 finished in 0.57 seconds on worker 4\n10 finished in 0.58 seconds on worker 2\n0.055971741","category":"page"},{"location":"manual/parallel-computing.html#Remote-References-and-Distributed-Garbage-Collection-1","page":"Parallel Computing","title":"Remote References and Distributed Garbage Collection","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Objects referred to by remote references can be freed only when all held references in the cluster are deleted.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The node where the value is stored keeps track of which of the workers have a reference to it. Every time a RemoteChannel or a (unfetched) Future is serialized to a worker, the node pointed to by the reference is notified. And every time a RemoteChannel or a (unfetched) Future is garbage collected locally, the node owning the value is again notified. This is implemented in an internal cluster aware serializer. Remote references are only valid in the context of a running cluster. Serializing and deserializing references to and from regular IO objects is not supported.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The notifications are done via sending of \"tracking\" messages–an \"add reference\" message when a reference is serialized to a different process and a \"delete reference\" message when a reference is locally garbage collected.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Since Futures are write-once and cached locally, the act of fetching a Future also updates reference tracking information on the node owning the value.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The node which owns the value frees it once all references to it are cleared.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"With Futures, serializing an already fetched Future to a different node also sends the value since the original remote store may have collected the value by this time.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"It is important to note that when an object is locally garbage collected depends on the size of the object and the current memory pressure in the system.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In case of remote references, the size of the local reference object is quite small, while the value stored on the remote node may be quite large. Since the local object may not be collected immediately, it is a good practice to explicitly call finalize on local instances of a RemoteChannel, or on unfetched Futures. Since calling fetch on a Future also removes its reference from the remote store, this is not required on fetched Futures. Explicitly calling finalize results in an immediate message sent to the remote node to go ahead and remove its reference to the value.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Once finalized, a reference becomes invalid and cannot be used in any further calls.","category":"page"},{"location":"manual/parallel-computing.html#Local-invocations(@id-man-distributed-local-invocations)-1","page":"Parallel Computing","title":"Local invocations(@id man-distributed-local-invocations)","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Data is necessarily copied over to the remote node for execution. This is the case for both remotecalls and when data is stored to aRemoteChannel / Future on a different node. As expected, this results in a copy of the serialized objects on the remote node. However, when the destination node is the local node, i.e. the calling process id is the same as the remote node id, it is executed as a local call. It is usually(not always) executed in a different task - but there is no serialization/deserialization of data. Consequently, the call refers to the same object instances as passed - no copies are created. This behavior is highlighted below:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Distributed;\n\njulia> rc = RemoteChannel(()->Channel(3));   # RemoteChannel created on local node\n\njulia> v = [0];\n\njulia> for i in 1:3\n           v[1] = i                          # Reusing `v`\n           put!(rc, v)\n       end;\n\njulia> result = [take!(rc) for _ in 1:3];\n\njulia> println(result);\nArray{Int64,1}[[3], [3], [3]]\n\njulia> println(\"Num Unique objects : \", length(unique(map(objectid, result))));\nNum Unique objects : 1\n\njulia> addprocs(1);\n\njulia> rc = RemoteChannel(()->Channel(3), workers()[1]);   # RemoteChannel created on remote node\n\njulia> v = [0];\n\njulia> for i in 1:3\n           v[1] = i\n           put!(rc, v)\n       end;\n\njulia> result = [take!(rc) for _ in 1:3];\n\njulia> println(result);\nArray{Int64,1}[[1], [2], [3]]\n\njulia> println(\"Num Unique objects : \", length(unique(map(objectid, result))));\nNum Unique objects : 3","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As can be seen, put! on a locally owned RemoteChannel with the same object v modifed between calls results in the same single object instance stored. As opposed to copies of v being created when the node owning rc is a different node.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"It is to be noted that this is generally not an issue. It is something to be factored in only if the object is both being stored locally and modifed post the call. In such cases it may be appropriate to store a deepcopy of the object.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"This is also true for remotecalls on the local node as seen in the following example:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Distributed; addprocs(1);\n\njulia> v = [0];\n\njulia> v2 = remotecall_fetch(x->(x[1] = 1; x), myid(), v);     # Executed on local node\n\njulia> println(\"v=$v, v2=$v2, \", v === v2);\nv=[1], v2=[1], true\n\njulia> v = [0];\n\njulia> v2 = remotecall_fetch(x->(x[1] = 1; x), workers()[1], v); # Executed on remote node\n\njulia> println(\"v=$v, v2=$v2, \", v === v2);\nv=[0], v2=[1], false","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As can be seen once again, a remote call onto the local node behaves just like a direct invocation. The call modifies local objects passed as arguments. In the remote invocation, it operates on a copy of the arguments.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"To repeat, in general this is not an issue. If the local node is also being used as a compute node, and the arguments used post the call, this behavior needs to be factored in and if required deep copies of arguments must be passed to the call invoked on the local node. Calls on remote nodes will always operate on copies of arguments.","category":"page"},{"location":"manual/parallel-computing.html#man-shared-arrays-1","page":"Parallel Computing","title":"Shared Arrays","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Shared Arrays use system shared memory to map the same array across many processes. While there are some similarities to a DArray, the behavior of a SharedArray is quite different. In a DArray, each process has local access to just a chunk of the data, and no two processes share the same chunk; in contrast, in a SharedArray each \"participating\" process has access to the entire array.  A SharedArray is a good choice when you want to have a large amount of data jointly accessible to two or more processes on the same machine.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Shared Array support is available via module SharedArrays which must be explicitly loaded on all participating workers.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"SharedArray indexing (assignment and accessing values) works just as with regular arrays, and is efficient because the underlying memory is available to the local process. Therefore, most algorithms work naturally on SharedArrays, albeit in single-process mode. In cases where an algorithm insists on an Array input, the underlying array can be retrieved from a SharedArray by calling sdata. For other AbstractArray types, sdata just returns the object itself, so it's safe to use sdata on any Array-type object.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The constructor for a shared array is of the form:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"SharedArray{T,N}(dims::NTuple; init=false, pids=Int[])","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"which creates an N-dimensional shared array of a bits type T and size dims across the processes specified by pids. Unlike distributed arrays, a shared array is accessible only from those participating workers specified by the pids named argument (and the creating process too, if it is on the same host).","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"If an init function, of signature initfn(S::SharedArray), is specified, it is called on all the participating workers. You can specify that each worker runs the init function on a distinct portion of the array, thereby parallelizing initialization.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Here's a brief example:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> using Distributed\n\njulia> addprocs(3)\n3-element Array{Int64,1}:\n 2\n 3\n 4\n\njulia> @everywhere using SharedArrays\n\njulia> S = SharedArray{Int,2}((3,4), init = S -> S[localindices(S)] = myid())\n3×4 SharedArray{Int64,2}:\n 2  2  3  4\n 2  3  3  4\n 2  3  4  4\n\njulia> S[3,2] = 7\n7\n\njulia> S\n3×4 SharedArray{Int64,2}:\n 2  2  3  4\n 2  3  3  4\n 2  7  4  4","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"SharedArrays.localindices provides disjoint one-dimensional ranges of indices, and is sometimes convenient for splitting up tasks among processes. You can, of course, divide the work any way you wish:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> S = SharedArray{Int,2}((3,4), init = S -> S[indexpids(S):length(procs(S)):length(S)] = myid())\n3×4 SharedArray{Int64,2}:\n 2  2  2  2\n 3  3  3  3\n 4  4  4  4","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Since all processes have access to the underlying data, you do have to be careful not to set up conflicts. For example:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"@sync begin\n    for p in procs(S)\n        @async begin\n            remotecall_wait(fill!, p, S, p)\n        end\n    end\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"would result in undefined behavior. Because each process fills the entire array with its own pid, whichever process is the last to execute (for any particular element of S) will have its pid retained.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As a more extended and complex example, consider running the following \"kernel\" in parallel:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"q[i,j,t+1] = q[i,j,t] + u[i,j,t]","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In this case, if we try to split up the work using a one-dimensional index, we are likely to run into trouble: if q[i,j,t] is near the end of the block assigned to one worker and q[i,j,t+1] is near the beginning of the block assigned to another, it's very likely that q[i,j,t] will not be ready at the time it's needed for computing q[i,j,t+1]. In such cases, one is better off chunking the array manually. Let's split along the second dimension. Define a function that returns the (irange, jrange) indices assigned to this worker:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @everywhere function myrange(q::SharedArray)\n           idx = indexpids(q)\n           if idx == 0 # This worker is not assigned a piece\n               return 1:0, 1:0\n           end\n           nchunks = length(procs(q))\n           splits = [round(Int, s) for s in range(0, stop=size(q,2), length=nchunks+1)]\n           1:size(q,1), splits[idx]+1:splits[idx+1]\n       end","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Next, define the kernel:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @everywhere function advection_chunk!(q, u, irange, jrange, trange)\n           @show (irange, jrange, trange)  # display so we can see what's happening\n           for t in trange, j in jrange, i in irange\n               q[i,j,t+1] = q[i,j,t] + u[i,j,t]\n           end\n           q\n       end","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"We also define a convenience wrapper for a SharedArray implementation","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @everywhere advection_shared_chunk!(q, u) =\n           advection_chunk!(q, u, myrange(q)..., 1:size(q,3)-1)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Now let's compare three different versions, one that runs in a single process:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> advection_serial!(q, u) = advection_chunk!(q, u, 1:size(q,1), 1:size(q,2), 1:size(q,3)-1);","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"one that uses @distributed:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> function advection_parallel!(q, u)\n           for t = 1:size(q,3)-1\n               @sync @distributed for j = 1:size(q,2)\n                   for i = 1:size(q,1)\n                       q[i,j,t+1]= q[i,j,t] + u[i,j,t]\n                   end\n               end\n           end\n           q\n       end;","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"and one that delegates in chunks:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> function advection_shared!(q, u)\n           @sync begin\n               for p in procs(q)\n                   @async remotecall_wait(advection_shared_chunk!, p, q, u)\n               end\n           end\n           q\n       end;","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"If we create SharedArrays and time these functions, we get the following results (with julia -p 4):","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> q = SharedArray{Float64,3}((500,500,500));\n\njulia> u = SharedArray{Float64,3}((500,500,500));","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Run the functions once to JIT-compile and @time them on the second run:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> @time advection_serial!(q, u);\n(irange,jrange,trange) = (1:500,1:500,1:499)\n 830.220 milliseconds (216 allocations: 13820 bytes)\n\njulia> @time advection_parallel!(q, u);\n   2.495 seconds      (3999 k allocations: 289 MB, 2.09% gc time)\n\njulia> @time advection_shared!(q,u);\n        From worker 2:       (irange,jrange,trange) = (1:500,1:125,1:499)\n        From worker 4:       (irange,jrange,trange) = (1:500,251:375,1:499)\n        From worker 3:       (irange,jrange,trange) = (1:500,126:250,1:499)\n        From worker 5:       (irange,jrange,trange) = (1:500,376:500,1:499)\n 238.119 milliseconds (2264 allocations: 169 KB)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The biggest advantage of advection_shared! is that it minimizes traffic among the workers, allowing each to compute for an extended time on the assigned piece.","category":"page"},{"location":"manual/parallel-computing.html#Shared-Arrays-and-Distributed-Garbage-Collection-1","page":"Parallel Computing","title":"Shared Arrays and Distributed Garbage Collection","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Like remote references, shared arrays are also dependent on garbage collection on the creating node to release references from all participating workers. Code which creates many short lived shared array objects would benefit from explicitly finalizing these objects as soon as possible. This results in both memory and file handles mapping the shared segment being released sooner.","category":"page"},{"location":"manual/parallel-computing.html#ClusterManagers-1","page":"Parallel Computing","title":"ClusterManagers","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The launching, management and networking of Julia processes into a logical cluster is done via cluster managers. A ClusterManager is responsible for","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"launching worker processes in a cluster environment\nmanaging events during the lifetime of each worker\noptionally, providing data transport","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A Julia cluster has the following characteristics:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The initial Julia process, also called the master, is special and has an id of 1.\nOnly the master process can add or remove worker processes.\nAll processes can directly communicate with each other.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Connections between workers (using the in-built TCP/IP transport) is established in the following manner:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"addprocs is called on the master process with a ClusterManager object.\naddprocs calls the appropriate launch method which spawns required number of worker processes on appropriate machines.\nEach worker starts listening on a free port and writes out its host and port information to stdout.\nThe cluster manager captures the stdout of each worker and makes it available to the master process.\nThe master process parses this information and sets up TCP/IP connections to each worker.\nEvery worker is also notified of other workers in the cluster.\nEach worker connects to all workers whose id is less than the worker's own id.\nIn this way a mesh network is established, wherein every worker is directly connected with every other worker.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"While the default transport layer uses plain TCPSocket, it is possible for a Julia cluster to provide its own transport.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia provides two in-built cluster managers:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"LocalManager, used when addprocs() or addprocs(np::Integer) are called\nSSHManager, used when addprocs(hostnames::Array) is called with a list of hostnames","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"LocalManager is used to launch additional workers on the same host, thereby leveraging multi-core and multi-processor hardware.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Thus, a minimal cluster manager would need to:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"be a subtype of the abstract ClusterManager\nimplement launch, a method responsible for launching new workers\nimplement manage, which is called at various events during a worker's lifetime (for example, sending an interrupt signal)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"addprocs(manager::FooManager) requires FooManager to implement:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"function launch(manager::FooManager, params::Dict, launched::Array, c::Condition)\n    [...]\nend\n\nfunction manage(manager::FooManager, id::Integer, config::WorkerConfig, op::Symbol)\n    [...]\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As an example let us see how the LocalManager, the manager responsible for starting workers on the same host, is implemented:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"struct LocalManager <: ClusterManager\n    np::Integer\nend\n\nfunction launch(manager::LocalManager, params::Dict, launched::Array, c::Condition)\n    [...]\nend\n\nfunction manage(manager::LocalManager, id::Integer, config::WorkerConfig, op::Symbol)\n    [...]\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The launch method takes the following arguments:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"manager::ClusterManager: the cluster manager that addprocs is called with\nparams::Dict: all the keyword arguments passed to addprocs\nlaunched::Array: the array to append one or more WorkerConfig objects to\nc::Condition: the condition variable to be notified as and when workers are launched","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The launch method is called asynchronously in a separate task. The termination of this task signals that all requested workers have been launched. Hence the launch function MUST exit as soon as all the requested workers have been launched.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Newly launched workers are connected to each other and the master process in an all-to-all manner. Specifying the command line argument --worker[=<cookie>] results in the launched processes initializing themselves as workers and connections being set up via TCP/IP sockets.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"All workers in a cluster share the same cookie as the master. When the cookie is unspecified, i.e, with the --worker option, the worker tries to read it from its standard input.  LocalManager and SSHManager both pass the cookie to newly launched workers via their  standard inputs.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"By default a worker will listen on a free port at the address returned by a call to getipaddr(). A specific address to listen on may be specified by optional argument --bind-to bind_addr[:port]. This is useful for multi-homed hosts.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"As an example of a non-TCP/IP transport, an implementation may choose to use MPI, in which case --worker must NOT be specified. Instead, newly launched workers should call init_worker(cookie) before using any of the parallel constructs.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"For every worker launched, the launch method must add a WorkerConfig object (with appropriate fields initialized) to launched","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"mutable struct WorkerConfig\n    # Common fields relevant to all cluster managers\n    io::Union{IO, Nothing}\n    host::Union{AbstractString, Nothing}\n    port::Union{Integer, Nothing}\n\n    # Used when launching additional workers at a host\n    count::Union{Int, Symbol, Nothing}\n    exename::Union{AbstractString, Cmd, Nothing}\n    exeflags::Union{Cmd, Nothing}\n\n    # External cluster managers can use this to store information at a per-worker level\n    # Can be a dict if multiple fields need to be stored.\n    userdata::Any\n\n    # SSHManager / SSH tunnel connections to workers\n    tunnel::Union{Bool, Nothing}\n    bind_addr::Union{AbstractString, Nothing}\n    sshflags::Union{Cmd, Nothing}\n    max_parallel::Union{Integer, Nothing}\n\n    # Used by Local/SSH managers\n    connect_at::Any\n\n    [...]\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Most of the fields in WorkerConfig are used by the inbuilt managers. Custom cluster managers would typically specify only io or host / port:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"If io is specified, it is used to read host/port information. A Julia worker prints out its bind address and port at startup. This allows Julia workers to listen on any free port available instead of requiring worker ports to be configured manually.\nIf io is not specified, host and port are used to connect.\ncount, exename and exeflags are relevant for launching additional workers from a worker. For example, a cluster manager may launch a single worker per node, and use that to launch additional workers.\ncount with an integer value n will launch a total of n workers.\ncount with a value of :auto will launch as many workers as the number of CPU threads (logical cores) on that machine.\nexename is the name of the julia executable including the full path.\nexeflags should be set to the required command line arguments for new workers.\ntunnel, bind_addr, sshflags and max_parallel are used when a ssh tunnel is required to connect to the workers from the master process.\nuserdata is provided for custom cluster managers to store their own worker-specific information.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"manage(manager::FooManager, id::Integer, config::WorkerConfig, op::Symbol) is called at different times during the worker's lifetime with appropriate op values:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"with :register/:deregister when a worker is added / removed from the Julia worker pool.\nwith :interrupt when interrupt(workers) is called. The ClusterManager should signal the appropriate worker with an interrupt signal.\nwith :finalize for cleanup purposes.","category":"page"},{"location":"manual/parallel-computing.html#Cluster-Managers-with-Custom-Transports-1","page":"Parallel Computing","title":"Cluster Managers with Custom Transports","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Replacing the default TCP/IP all-to-all socket connections with a custom transport layer is a little more involved. Each Julia process has as many communication tasks as the workers it is connected to. For example, consider a Julia cluster of 32 processes in an all-to-all mesh network:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Each Julia process thus has 31 communication tasks.\nEach task handles all incoming messages from a single remote worker in a message-processing loop.\nThe message-processing loop waits on an IO object (for example, a TCPSocket in the default implementation), reads an entire message, processes it and waits for the next one.\nSending messages to a process is done directly from any Julia task–not just communication tasks–again, via the appropriate IO object.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Replacing the default transport requires the new implementation to set up connections to remote workers and to provide appropriate IO objects that the message-processing loops can wait on. The manager-specific callbacks to be implemented are:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"connect(manager::FooManager, pid::Integer, config::WorkerConfig)\nkill(manager::FooManager, pid::Int, config::WorkerConfig)","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The default implementation (which uses TCP/IP sockets) is implemented as connect(manager::ClusterManager, pid::Integer, config::WorkerConfig).","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"connect should return a pair of IO objects, one for reading data sent from worker pid, and the other to write data that needs to be sent to worker pid. Custom cluster managers can use an in-memory BufferStream as the plumbing to proxy data between the custom, possibly non-IO transport and Julia's in-built parallel infrastructure.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"A BufferStream is an in-memory IOBuffer which behaves like an IO–it is a stream which can be handled asynchronously.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The folder clustermanager/0mq in the Examples repository contains an example of using ZeroMQ to connect Julia workers in a star topology with a 0MQ broker in the middle. Note: The Julia processes are still all logically connected to each other–any worker can message any other worker directly without any awareness of 0MQ being used as the transport layer.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"When using custom transports:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia workers must NOT be started with --worker. Starting with --worker will result in the newly launched workers defaulting to the TCP/IP socket transport implementation.\nFor every incoming logical connection with a worker, Base.process_messages(rd::IO, wr::IO)() must be called. This launches a new task that handles reading and writing of messages from/to the worker represented by the IO objects.\ninit_worker(cookie, manager::FooManager) must be called as part of worker process initialization.\nField connect_at::Any in WorkerConfig can be set by the cluster manager when launch is called. The value of this field is passed in in all connect callbacks. Typically, it carries information on how to connect to a worker. For example, the TCP/IP socket transport uses this field to specify the (host, port) tuple at which to connect to a worker.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"kill(manager, pid, config) is called to remove a worker from the cluster. On the master process, the corresponding IO objects must be closed by the implementation to ensure proper cleanup. The default implementation simply executes an exit() call on the specified remote worker.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The Examples folder clustermanager/simple is an example that shows a simple implementation using UNIX domain sockets for cluster setup.","category":"page"},{"location":"manual/parallel-computing.html#Network-Requirements-for-LocalManager-and-SSHManager-1","page":"Parallel Computing","title":"Network Requirements for LocalManager and SSHManager","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Julia clusters are designed to be executed on already secured environments on infrastructure such as local laptops, departmental clusters, or even the cloud. This section covers network security requirements for the inbuilt LocalManager and SSHManager:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The master process does not listen on any port. It only connects out to the workers.\nEach worker binds to only one of the local interfaces and listens on an ephemeral port number assigned by the OS.\nLocalManager, used by addprocs(N), by default binds only to the loopback interface. This means that workers started later on remote hosts (or by anyone with malicious intentions) are unable to connect to the cluster. An addprocs(4) followed by an addprocs([\"remote_host\"]) will fail. Some users may need to create a cluster comprising their local system and a few remote systems. This can be done by explicitly requesting LocalManager to bind to an external network interface via the restrict keyword argument: addprocs(4; restrict=false).\nSSHManager, used by addprocs(list_of_remote_hosts), launches workers on remote hosts via SSH. By default SSH is only used to launch Julia workers. Subsequent master-worker and worker-worker connections use plain, unencrypted TCP/IP sockets. The remote hosts must have passwordless login enabled. Additional SSH flags or credentials may be specified via keyword argument sshflags.\naddprocs(list_of_remote_hosts; tunnel=true, sshflags=<ssh keys and other flags>) is useful when we wish to use SSH connections for master-worker too. A typical scenario for this is a local laptop running the Julia REPL (i.e., the master) with the rest of the cluster on the cloud, say on Amazon EC2. In this case only port 22 needs to be opened at the remote cluster coupled with SSH client authenticated via public key infrastructure (PKI). Authentication credentials can be supplied via sshflags, for example sshflags=`-i <keyfile>`.\nIn an all-to-all topology (the default), all workers connect to each other via plain TCP sockets. The security policy on the cluster nodes must thus ensure free connectivity between workers for the ephemeral port range (varies by OS).\nSecuring and encrypting all worker-worker traffic (via SSH) or encrypting individual messages can be done via a custom ClusterManager.","category":"page"},{"location":"manual/parallel-computing.html#man-cluster-cookie-1","page":"Parallel Computing","title":"Cluster Cookie","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"All processes in a cluster share the same cookie which, by default, is a randomly generated string on the master process:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"cluster_cookie() returns the cookie, while cluster_cookie(cookie)() sets it and returns the new cookie.\nAll connections are authenticated on both sides to ensure that only workers started by the master are allowed to connect to each other.\nThe cookie may be passed to the workers at startup via argument --worker=<cookie>. If argument --worker is specified without the cookie, the worker tries to read the cookie from its standard input (stdin). The stdin is closed immediately after the cookie is retrieved.\nClusterManagers can retrieve the cookie on the master by calling cluster_cookie(). Cluster managers not using the default TCP/IP transport (and hence not specifying --worker) must call init_worker(cookie, manager) with the same cookie as on the master.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Note that environments requiring higher levels of security can implement this via a custom ClusterManager. For example, cookies can be pre-shared and hence not specified as a startup argument.","category":"page"},{"location":"manual/parallel-computing.html#Specifying-Network-Topology-(Experimental)-1","page":"Parallel Computing","title":"Specifying Network Topology (Experimental)","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"The keyword argument topology passed to addprocs is used to specify how the workers must be connected to each other:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":":all_to_all, the default: all workers are connected to each other.\n:master_worker: only the driver process, i.e. pid 1, has connections to the workers.\n:custom: the launch method of the cluster manager specifies the connection topology via the fields ident and connect_idents in WorkerConfig. A worker with a cluster-manager-provided identity ident will connect to all workers specified in connect_idents.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Keyword argument lazy=true|false only affects topology option :all_to_all. If true, the cluster starts off with the master connected to all workers. Specific worker-worker connections are established at the first remote invocation between two workers. This helps in reducing initial resources allocated for intra-cluster communication. Connections are setup depending on the runtime requirements of a parallel program. Default value for lazy is true.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Currently, sending a message between unconnected workers results in an error. This behaviour, as with the functionality and interface, should be considered experimental in nature and may change in future releases.","category":"page"},{"location":"manual/parallel-computing.html#Noteworthy-external-packages-1","page":"Parallel Computing","title":"Noteworthy external packages","text":"","category":"section"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Outside of Julia parallelism there are plenty of external packages that should be mentioned. For example MPI.jl is a Julia wrapper for the MPI protocol, or DistributedArrays.jl, as presented in Shared Arrays. A mention must be made of Julia's GPU programming ecosystem, which includes:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Low-level (C kernel) based operations OpenCL.jl and CUDAdrv.jl which are respectively an OpenCL interface and a CUDA wrapper.\nLow-level (Julia Kernel) interfaces like CUDAnative.jl which is a Julia native CUDA implementation.\nHigh-level vendor-specific abstractions like CuArrays.jl and CLArrays.jl\nHigh-level libraries like ArrayFire.jl and GPUArrays.jl","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In the following example we will use both DistributedArrays.jl and CuArrays.jl to distribute an array across multiple processes by first casting it through distribute() and CuArray().","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Remember when importing DistributedArrays.jl to import it across all processes using @everywhere","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"$ ./julia -p 4\n\njulia> addprocs()\n\njulia> @everywhere using DistributedArrays\n\njulia> using CuArrays\n\njulia> B = ones(10_000) ./ 2;\n\njulia> A = ones(10_000) .* π;\n\njulia> C = 2 .* A ./ B;\n\njulia> all(C .≈ 4*π)\ntrue\n\njulia> typeof(C)\nArray{Float64,1}\n\njulia> dB = distribute(B);\n\njulia> dA = distribute(A);\n\njulia> dC = 2 .* dA ./ dB;\n\njulia> all(dC .≈ 4*π)\ntrue\n\njulia> typeof(dC)\nDistributedArrays.DArray{Float64,1,Array{Float64,1}}\n\njulia> cuB = CuArray(B);\n\njulia> cuA = CuArray(A);\n\njulia> cuC = 2 .* cuA ./ cuB;\n\njulia> all(cuC .≈ 4*π);\ntrue\n\njulia> typeof(cuC)\nCuArray{Float64,1}","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Keep in mind that some Julia features are not currently supported by CUDAnative.jl [2] , especially some functions like sin will need to be replaced with CUDAnative.sin(cc: @maleadt).","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"In the following example we will use both DistributedArrays.jl and CuArrays.jl to distribute an array across multiple processes and call a generic function on it.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"function power_method(M, v)\n    for i in 1:100\n        v = M*v\n        v /= norm(v)\n    end\n\n    return v, norm(M*v) / norm(v)  # or  (M*v) ./ v\nend","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"power_method repeatedly creates a new vector and normalizes it. We have not specified any type signature in function declaration, let's see if it works with the aforementioned datatypes:","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"julia> M = [2. 1; 1 1];\n\njulia> v = rand(2)\n2-element Array{Float64,1}:\n0.40395\n0.445877\n\njulia> power_method(M,v)\n([0.850651, 0.525731], 2.618033988749895)\n\njulia> cuM = CuArray(M);\n\njulia> cuv = CuArray(v);\n\njulia> curesult = power_method(cuM, cuv);\n\njulia> typeof(curesult)\nCuArray{Float64,1}\n\njulia> dM = distribute(M);\n\njulia> dv = distribute(v);\n\njulia> dC = power_method(dM, dv);\n\njulia> typeof(dC)\nTuple{DistributedArrays.DArray{Float64,1,Array{Float64,1}},Float64}","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"To end this short exposure to external packages, we can consider MPI.jl, a Julia wrapper of the MPI protocol. As it would take too long to consider every inner function, it would be better to simply appreciate the approach used to implement the protocol.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"Consider this toy script which simply calls each subprocess, instantiate its rank and when the master process is reached, performs the ranks' sum","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"import MPI\n\nMPI.Init()\n\ncomm = MPI.COMM_WORLD\nMPI.Barrier(comm)\n\nroot = 0\nr = MPI.Comm_rank(comm)\n\nsr = MPI.Reduce(r, MPI.SUM, root, comm)\n\nif(MPI.Comm_rank(comm) == root)\n   @printf(\"sum of ranks: %s\\n\", sr)\nend\n\nMPI.Finalize()","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"mpirun -np 4 ./julia example.jl","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"[1]: In this context, MPI refers to the MPI-1 standard. Beginning with MPI-2, the MPI standards committee introduced a new set of communication mechanisms, collectively referred to as Remote Memory Access (RMA). The motivation for adding rma to the MPI standard was to facilitate one-sided communication patterns. For additional information on the latest MPI standard, see https://mpi-forum.org/docs.","category":"page"},{"location":"manual/parallel-computing.html#","page":"Parallel Computing","title":"Parallel Computing","text":"[2]: Julia GPU man pages","category":"page"},{"location":"manual/running-external-programs.html#Running-External-Programs-1","page":"Running External Programs","title":"Running External Programs","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Julia borrows backtick notation for commands from the shell, Perl, and Ruby. However, in Julia, writing","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> `echo hello`\n`echo hello`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"differs in several aspects from the behavior in various shells, Perl, or Ruby:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Instead of immediately running the command, backticks create a Cmd object to represent the command. You can use this object to connect the command to others via pipes, run it, and read or write to it.\nWhen the command is run, Julia does not capture its output unless you specifically arrange for it to. Instead, the output of the command by default goes to stdout as it would using libc's system call.\nThe command is never run with a shell. Instead, Julia parses the command syntax directly, appropriately interpolating variables and splitting on words as the shell would, respecting shell quoting syntax. The command is run as julia's immediate child process, using fork and exec calls.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Here's a simple example of running an external program:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> mycommand = `echo hello`\n`echo hello`\n\njulia> typeof(mycommand)\nCmd\n\njulia> run(mycommand);\nhello","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The hello is the output of the echo command, sent to stdout. The run method itself returns nothing, and throws an ErrorException if the external command fails to run successfully.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"If you want to read the output of the external command, read can be used instead:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> a = read(`echo hello`, String)\n\"hello\\n\"\n\njulia> chomp(a) == \"hello\"\ntrue","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"More generally, you can use open to read from or write to an external command.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> open(`less`, \"w\", stdout) do io\n           for i = 1:3\n               println(io, i)\n           end\n       end\n1\n2\n3","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The program name and the individual arguments in a command can be accessed and iterated over as if the command were an array of strings:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> collect(`echo \"foo bar\"`)\n2-element Array{String,1}:\n \"echo\"\n \"foo bar\"\n\njulia> `echo \"foo bar\"`[2]\n\"foo bar\"","category":"page"},{"location":"manual/running-external-programs.html#command-interpolation-1","page":"Running External Programs","title":"Interpolation","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Suppose you want to do something a bit more complicated and use the name of a file in the variable file as an argument to a command. You can use $ for interpolation much as you would in a string literal (see Strings):","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> file = \"/etc/passwd\"\n\"/etc/passwd\"\n\njulia> `sort $file`\n`sort /etc/passwd`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"A common pitfall when running external programs via a shell is that if a file name contains characters that are special to the shell, they may cause undesirable behavior. Suppose, for example, rather than /etc/passwd, we wanted to sort the contents of the file /Volumes/External HD/data.csv. Let's try it:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> file = \"/Volumes/External HD/data.csv\"\n\"/Volumes/External HD/data.csv\"\n\njulia> `sort $file`\n`sort '/Volumes/External HD/data.csv'`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"How did the file name get quoted? Julia knows that file is meant to be interpolated as a single argument, so it quotes the word for you. Actually, that is not quite accurate: the value of file is never interpreted by a shell, so there's no need for actual quoting; the quotes are inserted only for presentation to the user. This will even work if you interpolate a value as part of a shell word:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> path = \"/Volumes/External HD\"\n\"/Volumes/External HD\"\n\njulia> name = \"data\"\n\"data\"\n\njulia> ext = \"csv\"\n\"csv\"\n\njulia> `sort $path/$name.$ext`\n`sort '/Volumes/External HD/data.csv'`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"As you can see, the space in the path variable is appropriately escaped. But what if you want to interpolate multiple words? In that case, just use an array (or any other iterable container):","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> files = [\"/etc/passwd\",\"/Volumes/External HD/data.csv\"]\n2-element Array{String,1}:\n \"/etc/passwd\"\n \"/Volumes/External HD/data.csv\"\n\njulia> `grep foo $files`\n`grep foo /etc/passwd '/Volumes/External HD/data.csv'`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"If you interpolate an array as part of a shell word, Julia emulates the shell's {a,b,c} argument generation:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> names = [\"foo\",\"bar\",\"baz\"]\n3-element Array{String,1}:\n \"foo\"\n \"bar\"\n \"baz\"\n\njulia> `grep xylophone $names.txt`\n`grep xylophone foo.txt bar.txt baz.txt`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Moreover, if you interpolate multiple arrays into the same word, the shell's Cartesian product generation behavior is emulated:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> names = [\"foo\",\"bar\",\"baz\"]\n3-element Array{String,1}:\n \"foo\"\n \"bar\"\n \"baz\"\n\njulia> exts = [\"aux\",\"log\"]\n2-element Array{String,1}:\n \"aux\"\n \"log\"\n\njulia> `rm -f $names.$exts`\n`rm -f foo.aux foo.log bar.aux bar.log baz.aux baz.log`","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Since you can interpolate literal arrays, you can use this generative functionality without needing to create temporary array objects first:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> `rm -rf $[\"foo\",\"bar\",\"baz\",\"qux\"].$[\"aux\",\"log\",\"pdf\"]`\n`rm -rf foo.aux foo.log foo.pdf bar.aux bar.log bar.pdf baz.aux baz.log baz.pdf qux.aux qux.log qux.pdf`","category":"page"},{"location":"manual/running-external-programs.html#Quoting-1","page":"Running External Programs","title":"Quoting","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Inevitably, one wants to write commands that aren't quite so simple, and it becomes necessary to use quotes. Here's a simple example of a Perl one-liner at a shell prompt:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"sh$ perl -le '$|=1; for (0..3) { print }'\n0\n1\n2\n3","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The Perl expression needs to be in single quotes for two reasons: so that spaces don't break the expression into multiple shell words, and so that uses of Perl variables like $| (yes, that's the name of a variable in Perl), don't cause interpolation. In other instances, you may want to use double quotes so that interpolation does occur:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"sh$ first=\"A\"\nsh$ second=\"B\"\nsh$ perl -le '$|=1; print for @ARGV' \"1: $first\" \"2: $second\"\n1: A\n2: B","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"In general, the Julia backtick syntax is carefully designed so that you can just cut-and-paste shell commands as is into backticks and they will work: the escaping, quoting, and interpolation behaviors are the same as the shell's. The only difference is that the interpolation is integrated and aware of Julia's notion of what is a single string value, and what is a container for multiple values. Let's try the above two examples in Julia:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> A = `perl -le '$|=1; for (0..3) { print }'`\n`perl -le '$|=1; for (0..3) { print }'`\n\njulia> run(A);\n0\n1\n2\n3\n\njulia> first = \"A\"; second = \"B\";\n\njulia> B = `perl -le 'print for @ARGV' \"1: $first\" \"2: $second\"`\n`perl -le 'print for @ARGV' '1: A' '2: B'`\n\njulia> run(B);\n1: A\n2: B","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The results are identical, and Julia's interpolation behavior mimics the shell's with some improvements due to the fact that Julia supports first-class iterable objects while most shells use strings split on spaces for this, which introduces ambiguities. When trying to port shell commands to Julia, try cut and pasting first. Since Julia shows commands to you before running them, you can easily and safely just examine its interpretation without doing any damage.","category":"page"},{"location":"manual/running-external-programs.html#Pipelines-1","page":"Running External Programs","title":"Pipelines","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Shell metacharacters, such as |, &, and >, need to be quoted (or escaped) inside of Julia's backticks:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(`echo hello '|' sort`);\nhello | sort\n\njulia> run(`echo hello \\| sort`);\nhello | sort","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"This expression invokes the echo command with three words as arguments: hello, |, and sort. The result is that a single line is printed: hello | sort. How, then, does one construct a pipeline? Instead of using '|' inside of backticks, one uses pipeline:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(pipeline(`echo hello`, `sort`));\nhello","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"This pipes the output of the echo command to the sort command. Of course, this isn't terribly interesting since there's only one line to sort, but we can certainly do much more interesting things:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(pipeline(`cut -d: -f3 /etc/passwd`, `sort -n`, `tail -n5`))\n210\n211\n212\n213\n214","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"This prints the highest five user IDs on a UNIX system. The cut, sort and tail commands are all spawned as immediate children of the current julia process, with no intervening shell process. Julia itself does the work to setup pipes and connect file descriptors that is normally done by the shell. Since Julia does this itself, it retains better control and can do some things that shells cannot.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Julia can run multiple commands in parallel:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(`echo hello` & `echo world`);\nworld\nhello","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The order of the output here is non-deterministic because the two echo processes are started nearly simultaneously, and race to make the first write to the stdout descriptor they share with each other and the julia parent process. Julia lets you pipe the output from both of these processes to another program:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(pipeline(`echo world` & `echo hello`, `sort`));\nhello\nworld","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"In terms of UNIX plumbing, what's happening here is that a single UNIX pipe object is created and written to by both echo processes, and the other end of the pipe is read from by the sort command.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"IO redirection can be accomplished by passing keyword arguments stdin, stdout, and stderr to the pipeline function:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"pipeline(`do_work`, stdout=pipeline(`sort`, \"out.txt\"), stderr=\"errs.txt\")","category":"page"},{"location":"manual/running-external-programs.html#Avoiding-Deadlock-in-Pipelines-1","page":"Running External Programs","title":"Avoiding Deadlock in Pipelines","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"When reading and writing to both ends of a pipeline from a single process, it is important to avoid forcing the kernel to buffer all of the data.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"For example, when reading all of the output from a command, call read(out, String), not wait(process), since the former will actively consume all of the data written by the process, whereas the latter will attempt to store the data in the kernel's buffers while waiting for a reader to be connected.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Another common solution is to separate the reader and writer of the pipeline into separate Tasks:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"writer = @async write(process, \"data\")\nreader = @async do_compute(read(process, String))\nwait(process)\nfetch(reader)","category":"page"},{"location":"manual/running-external-programs.html#Complex-Example-1","page":"Running External Programs","title":"Complex Example","text":"","category":"section"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"The combination of a high-level programming language, a first-class command abstraction, and automatic setup of pipes between processes is a powerful one. To give some sense of the complex pipelines that can be created easily, here are some more sophisticated examples, with apologies for the excessive use of Perl one-liners:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> prefixer(prefix, sleep) = `perl -nle '$|=1; print \"'$prefix' \", $_; sleep '$sleep';'`;\n\njulia> run(pipeline(`perl -le '$|=1; for(0..5){ print; sleep 1 }'`, prefixer(\"A\",2) & prefixer(\"B\",2)));\nB 0\nA 1\nB 2\nA 3\nB 4\nA 5","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"This is a classic example of a single producer feeding two concurrent consumers: one perl process generates lines with the numbers 0 through 5 on them, while two parallel processes consume that output, one prefixing lines with the letter \"A\", the other with the letter \"B\". Which consumer gets the first line is non-deterministic, but once that race has been won, the lines are consumed alternately by one process and then the other. (Setting $|=1 in Perl causes each print statement to flush the stdout handle, which is necessary for this example to work. Otherwise all the output is buffered and printed to the pipe at once, to be read by just one consumer process.)","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"Here is an even more complex multi-stage producer-consumer example:","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"julia> run(pipeline(`perl -le '$|=1; for(0..5){ print; sleep 1 }'`,\n           prefixer(\"X\",3) & prefixer(\"Y\",3) & prefixer(\"Z\",3),\n           prefixer(\"A\",2) & prefixer(\"B\",2)));\nA X 0\nB Y 1\nA Z 2\nB X 3\nA Y 4\nB Z 5","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"This example is similar to the previous one, except there are two stages of consumers, and the stages have different latency so they use a different number of parallel workers, to maintain saturated throughput.","category":"page"},{"location":"manual/running-external-programs.html#","page":"Running External Programs","title":"Running External Programs","text":"We strongly encourage you to try all these examples to see how they work.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Calling-C-and-Fortran-Code-1","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Though most code can be written in Julia, there are many high-quality, mature libraries for numerical computing already written in C and Fortran. To allow easy use of this existing code, Julia makes it simple and efficient to call C and Fortran functions. Julia has a \"no boilerplate\" philosophy: functions can be called directly from Julia without any \"glue\" code, code generation, or compilation – even from the interactive prompt. This is accomplished just by making an appropriate call with ccall syntax, which looks like an ordinary function call.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The code to be called must be available as a shared library. Most C and Fortran libraries ship compiled as shared libraries already, but if you are compiling the code yourself using GCC (or Clang), you will need to use the -shared and -fPIC options. The machine instructions generated by Julia's JIT are the same as a native C call would be, so the resulting overhead is the same as calling a library function from C code. (Non-library function calls in both C and Julia can be inlined and thus may have even less overhead than calls to shared library functions. When both libraries and executables are generated by LLVM, it is possible to perform whole-program optimizations that can even optimize across this boundary, but Julia does not yet support that. In the future, however, it may do so, yielding even greater performance gains.)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Shared libraries and functions are referenced by a tuple of the form (:function, \"library\") or (\"function\", \"library\") where function is the C-exported function name. library refers to the shared library name: shared libraries available in the (platform-specific) load path will be resolved by name, and if necessary a direct path may be specified.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A function name may be used alone in place of the tuple (just :function or \"function\"). In this case the name is resolved within the current process. This form can be used to call C library functions, functions in the Julia runtime, or functions in an application linked to Julia.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"By default, Fortran compilers generate mangled names (for example, converting function names to lowercase or uppercase, often appending an underscore), and so to call a Fortran function via ccall you must pass the mangled identifier corresponding to the rule followed by your Fortran compiler.  Also, when calling a Fortran function, all inputs must be passed as pointers to allocated values on the heap or stack. This applies not only to arrays and other mutable objects which are normally heap-allocated, but also to scalar values such as integers and floats which are normally stack-allocated and commonly passed in registers when using C or Julia calling conventions.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Finally, you can use ccall to actually generate a call to the library function. Arguments to ccall are as follows:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A (:function, \"library\") pair, which must be written as a literal constant,\nOR\na :function name symbol or \"function\" name string, which is resolved in the current process,\nOR\na function pointer (for example, from dlsym).\nReturn type (see below for mapping the declared C type to Julia)\nThis argument will be evaluated at compile-time, when the containing method is defined.\nA tuple of input types. The input types must be written as a literal tuple, not a tuple-valued variable or expression.\nThis argument will be evaluated at compile-time, when the containing method is defined.\nThe following arguments, if any, are the actual argument values passed to the function.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"As a complete but simple example, the following calls the clock function from the standard C library:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> t = ccall((:clock, \"libc\"), Int32, ())\n2292761\n\njulia> t\n2292761\n\njulia> typeof(ans)\nInt32","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"clock takes no arguments and returns an Int32. One common gotcha is that a 1-tuple must be written with a trailing comma. For example, to call the getenv function to get a pointer to the value of an environment variable, one makes a call like this:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> path = ccall((:getenv, \"libc\"), Cstring, (Cstring,), \"SHELL\")\nCstring(@0x00007fff5fbffc45)\n\njulia> unsafe_string(path)\n\"/bin/bash\"","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note that the argument type tuple must be written as (Cstring,), rather than (Cstring). This is because (Cstring) is just the expression Cstring surrounded by parentheses, rather than a 1-tuple containing Cstring:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> (Cstring)\nCstring\n\njulia> (Cstring,)\n(Cstring,)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"In practice, especially when providing reusable functionality, one generally wraps ccall uses in Julia functions that set up arguments and then check for errors in whatever manner the C or Fortran function indicates them, propagating to the Julia caller as exceptions. This is especially important since C and Fortran APIs are notoriously inconsistent about how they indicate error conditions. For example, the getenv C library function is wrapped in the following Julia function, which is a simplified version of the actual definition from env.jl:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"function getenv(var::AbstractString)\n    val = ccall((:getenv, \"libc\"),\n                Cstring, (Cstring,), var)\n    if val == C_NULL\n        error(\"getenv: undefined variable: \", var)\n    end\n    unsafe_string(val)\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The C getenv function indicates an error by returning NULL, but other standard C functions indicate errors in various different ways, including by returning -1, 0, 1 and other special values. This wrapper throws an exception clearly indicating the problem if the caller tries to get a non-existent environment variable:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> getenv(\"SHELL\")\n\"/bin/bash\"\n\njulia> getenv(\"FOOBAR\")\ngetenv: undefined variable: FOOBAR","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Here is a slightly more complex example that discovers the local machine's hostname:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"function gethostname()\n    hostname = Vector{UInt8}(undef, 128)\n    ccall((:gethostname, \"libc\"), Int32,\n          (Ptr{UInt8}, Csize_t),\n          hostname, sizeof(hostname))\n    hostname[end] = 0; # ensure null-termination\n    return unsafe_string(pointer(hostname))\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"This example first allocates an array of bytes, then calls the C library function gethostname to fill the array in with the hostname, takes a pointer to the hostname buffer, and converts the pointer to a Julia string, assuming that it is a NUL-terminated C string. It is common for C libraries to use this pattern of requiring the caller to allocate memory to be passed to the callee and filled in. Allocation of memory from Julia like this is generally accomplished by creating an uninitialized array and passing a pointer to its data to the C function. This is why we don't use the Cstring type here: as the array is uninitialized, it could contain NUL bytes. Converting to a Cstring as part of the ccall checks for contained NUL bytes and could therefore throw a conversion error.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Creating-C-Compatible-Julia-Function-Pointers-1","page":"Calling C and Fortran Code","title":"Creating C-Compatible Julia Function Pointers","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"It is possible to pass Julia functions to native C functions that accept function pointer arguments. For example, to match C prototypes of the form:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"typedef returntype (*functiontype)(argumenttype, ...)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The macro @cfunction generates the C-compatible function pointer for a call to a Julia function. Arguments to @cfunction are as follows:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A Julia Function\nReturn type\nA literal tuple of input types","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Like ccall, all of these arguments will be evaluated at compile-time, when the containing method is defined.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Currently, only the platform-default C calling convention is supported. This means that @cfunction-generated pointers cannot be used in calls where WINAPI expects stdcall function on 32-bit windows, but can be used on WIN64 (where stdcall is unified with the C calling convention).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A classic example is the standard C library qsort function, declared as:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"void qsort(void *base, size_t nmemb, size_t size,\n           int (*compare)(const void*, const void*));","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The base argument is a pointer to an array of length nmemb, with elements of size bytes each. compare is a callback function which takes pointers to two elements a and b and returns an integer less/greater than zero if a should appear before/after b (or zero if any order is permitted). Now, suppose that we have a 1d array A of values in Julia that we want to sort using the qsort function (rather than Julia's built-in sort function). Before we worry about calling qsort and passing arguments, we need to write a comparison function that works for some arbitrary objects (which define <):","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> function mycompare(a, b)::Cint\n           return (a < b) ? -1 : ((a > b) ? +1 : 0)\n       end\nmycompare (generic function with 1 method)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Notice that we have to be careful about the return type: qsort expects a function returning a C int, so we annotate the return type of the function to be sure it returns a Cint.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"In order to pass this function to C, we obtain its address using the macro @cfunction:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> mycompare_c = @cfunction(mycompare, Cint, (Ref{Cdouble}, Ref{Cdouble}));","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"@cfunction requires three arguments: the Julia function (mycompare), the return type (Cint), and a literal tuple of the input argument types, in this case to sort an array of Cdouble (Float64) elements.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The final call to qsort looks like this:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> A = [1.3, -2.7, 4.4, 3.1]\n4-element Array{Float64,1}:\n  1.3\n -2.7\n  4.4\n  3.1\n\njulia> ccall(:qsort, Cvoid, (Ptr{Cdouble}, Csize_t, Csize_t, Ptr{Cvoid}),\n             A, length(A), sizeof(eltype(A)), mycompare_c)\n\njulia> A\n4-element Array{Float64,1}:\n -2.7\n  1.3\n  3.1\n  4.4","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"As can be seen, A is changed to the sorted array [-2.7, 1.3, 3.1, 4.4]. Note that Julia knows how to convert an array into a Ptr{Cdouble}, how to compute the size of a type in bytes (identical to C's sizeof operator), and so on. For fun, try inserting a println(\"mycompare($a, $b)\") line into mycompare, which will allow you to see the comparisons that qsort is performing (and to verify that it is really calling the Julia function that you passed to it).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Mapping-C-Types-to-Julia-1","page":"Calling C and Fortran Code","title":"Mapping C Types to Julia","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"It is critical to exactly match the declared C type with its declaration in Julia. Inconsistencies can cause code that works correctly on one system to fail or produce indeterminate results on a different system.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note that no C header files are used anywhere in the process of calling C functions: you are responsible for making sure that your Julia types and call signatures accurately reflect those in the C header file. (The Clang package can be used to auto-generate Julia code from a C header file.)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Auto-conversion:-1","page":"Calling C and Fortran Code","title":"Auto-conversion:","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Julia automatically inserts calls to the Base.cconvert function to convert each argument to the specified type. For example, the following call:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"ccall((:foo, \"libfoo\"), Cvoid, (Int32, Float64), x, y)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"will behave as if the following were written:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"ccall((:foo, \"libfoo\"), Cvoid, (Int32, Float64),\n      Base.unsafe_convert(Int32, Base.cconvert(Int32, x)),\n      Base.unsafe_convert(Float64, Base.cconvert(Float64, y)))","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Base.cconvert normally just calls convert, but can be defined to return an arbitrary new object more appropriate for passing to C. This should be used to perform all allocations of memory that will be accessed by the C code. For example, this is used to convert an Array of objects (e.g. strings) to an array of pointers.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Base.unsafe_convert handles conversion to Ptr types. It is considered unsafe because converting an object to a native pointer can hide the object from the garbage collector, causing it to be freed prematurely.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Type-Correspondences:-1","page":"Calling C and Fortran Code","title":"Type Correspondences:","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"First, a review of some relevant Julia type terminology:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Syntax / Keyword Example Description\nmutable struct BitSet \"Leaf Type\" :: A group of related data that includes a type-tag, is managed by the Julia GC, and is defined by object-identity. The type parameters of a leaf type must be fully defined (no TypeVars are allowed) in order for the instance to be constructed.\nabstract type Any, AbstractArray{T, N}, Complex{T} \"Super Type\" :: A super-type (not a leaf-type) that cannot be instantiated, but can be used to describe a group of types.\nT{A} Vector{Int} \"Type Parameter\" :: A specialization of a type (typically used for dispatch or storage optimization).\n  \"TypeVar\" :: The T in the type parameter declaration is referred to as a TypeVar (short for type variable).\nprimitive type Int, Float64 \"Primitive Type\" :: A type with no fields, but a size. It is stored and defined by-value.\nstruct Pair{Int, Int} \"Struct\" :: A type with all fields defined to be constant. It is defined by-value, and may be stored with a type-tag.\n ComplexF64 (isbits) \"Is-Bits\"   :: A primitive type, or a struct type where all fields are other isbits types. It is defined by-value, and is stored without a type-tag.\nstruct ...; end nothing \"Singleton\" :: a Leaf Type or Struct with no fields.\n(...) or tuple(...) (1, 2, 3) \"Tuple\" :: an immutable data-structure similar to an anonymous struct type, or a constant array. Represented as either an array or a struct.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#man-bits-types-1","page":"Calling C and Fortran Code","title":"Bits Types","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"There are several special types to be aware of, as no other type can be defined to behave the same:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Float32\nExactly corresponds to the float type in C (or REAL*4 in Fortran).\nFloat64\nExactly corresponds to the double type in C (or REAL*8 in Fortran).\nComplexF32\nExactly corresponds to the complex float type in C (or COMPLEX*8 in Fortran).\nComplexF64\nExactly corresponds to the complex double type in C (or COMPLEX*16 in Fortran).\nSigned\nExactly corresponds to the signed type annotation in C (or any INTEGER type in Fortran). Any Julia type that is not a subtype of Signed is assumed to be unsigned.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Ref{T}\nBehaves like a Ptr{T} that can manage its memory via the Julia GC.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Array{T,N}\nWhen an array is passed to C as a Ptr{T} argument, it is not reinterpret-cast: Julia requires that the element type of the array matches T, and the address of the first element is passed.\nTherefore, if an Array contains data in the wrong format, it will have to be explicitly converted using a call such as trunc(Int32, a).\nTo pass an array A as a pointer of a different type without converting the data beforehand (for example, to pass a Float64 array to a function that operates on uninterpreted bytes), you can declare the argument as Ptr{Cvoid}.\nIf an array of eltype Ptr{T} is passed as a Ptr{Ptr{T}} argument, Base.cconvert will attempt to first make a null-terminated copy of the array with each element replaced by its Base.cconvert version. This allows, for example, passing an argv pointer array of type Vector{String} to an argument of type Ptr{Ptr{Cchar}}.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"On all systems we currently support, basic C/C++ value types may be translated to Julia types as follows. Every C type also has a corresponding Julia type with the same name, prefixed by C. This can help for writing portable code (and remembering that an int in C is not the same as an Int in Julia).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"System Independent:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"C name Fortran name Standard Julia Alias Julia Base Type\nunsigned char CHARACTER Cuchar UInt8\nbool (only in C++)  Cuchar UInt8\nshort INTEGER*2, LOGICAL*2 Cshort Int16\nunsigned short  Cushort UInt16\nint, BOOL (C, typical) INTEGER*4, LOGICAL*4 Cint Int32\nunsigned int  Cuint UInt32\nlong long INTEGER*8, LOGICAL*8 Clonglong Int64\nunsigned long long  Culonglong UInt64\nintmax_t  Cintmax_t Int64\nuintmax_t  Cuintmax_t UInt64\nfloat REAL*4i Cfloat Float32\ndouble REAL*8 Cdouble Float64\ncomplex float COMPLEX*8 ComplexF32 Complex{Float32}\ncomplex double COMPLEX*16 ComplexF64 Complex{Float64}\nptrdiff_t  Cptrdiff_t Int\nssize_t  Cssize_t Int\nsize_t  Csize_t UInt\nvoid   Cvoid\nvoid and [[noreturn]] or _Noreturn   Union{}\nvoid*   Ptr{Cvoid}\nT* (where T represents an appropriately defined type)   Ref{T}\nchar* (or char[], e.g. a string) CHARACTER*N  Cstring if NUL-terminated, or Ptr{UInt8} if not\nchar** (or *char[])   Ptr{Ptr{UInt8}}\njl_value_t* (any Julia Type)   Any\njl_value_t** (a reference to a Julia Type)   Ref{Any}\nva_arg   Not supported\n... (variadic function specification)   T... (where T is one of the above types, variadic functions of different argument types are not supported)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The Cstring type is essentially a synonym for Ptr{UInt8}, except the conversion to Cstring throws an error if the Julia string contains any embedded NUL characters (which would cause the string to be silently truncated if the C routine treats NUL as the terminator).  If you are passing a char* to a C routine that does not assume NUL termination (e.g. because you pass an explicit string length), or if you know for certain that your Julia string does not contain NUL and want to skip the check, you can use Ptr{UInt8} as the argument type. Cstring can also be used as the ccall return type, but in that case it obviously does not introduce any extra checks and is only meant to improve readability of the call.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"System-dependent:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"C name Standard Julia Alias Julia Base Type\nchar Cchar Int8 (x86, x86_64), UInt8 (powerpc, arm)\nlong Clong Int (UNIX), Int32 (Windows)\nunsigned long Culong UInt (UNIX), UInt32 (Windows)\nwchar_t Cwchar_t Int32 (UNIX), UInt16 (Windows)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"note: Note\nWhen calling Fortran, all inputs must be passed by pointers to heap- or stack-allocated values, so all type correspondences above should contain an additional Ptr{..} or Ref{..} wrapper around their type specification.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"warning: Warning\nFor string arguments (char*) the Julia type should be Cstring (if NUL- terminated data is expected) or either Ptr{Cchar} or Ptr{UInt8} otherwise (these two pointer types have the same effect), as described above, not String. Similarly, for array arguments (T[] or T*), the Julia type should again be Ptr{T}, not Vector{T}.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"warning: Warning\nJulia's Char type is 32 bits, which is not the same as the wide character type (wchar_t or wint_t) on all platforms.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"warning: Warning\nA return type of Union{} means the function will not return i.e. C++11 [[noreturn]] or C11 _Noreturn (e.g. jl_throw or longjmp). Do not use this for functions that return no value (void) but do return, use Cvoid instead.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"note: Note\nFor wchar_t* arguments, the Julia type should be Cwstring (if the C routine expects a NUL-terminated string) or Ptr{Cwchar_t} otherwise. Note also that UTF-8 string data in Julia is internally NUL-terminated, so it can be passed to C functions expecting NUL-terminated data without making a copy (but using the Cwstring type will cause an error to be thrown if the string itself contains NUL characters).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"note: Note\nC functions that take an argument of the type char** can be called by using a Ptr{Ptr{UInt8}} type within Julia. For example, C functions of the form:int main(int argc, char **argv);can be called via the following Julia code:argv = [ \"a.out\", \"arg1\", \"arg2\" ]\nccall(:main, Int32, (Int32, Ptr{Ptr{UInt8}}), length(argv), argv)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"note: Note\nFor Fortran functions taking variable length strings of type character(len=*) the string lengths are provided as hidden arguments. Type and position of these arguments in the list are compiler specific, where compiler vendors usually default to using Csize_t as type and append the hidden arguments at the end of the argument list. While this behaviour is fixed for some compilers (GNU), others optionally permit placing hidden arguments directly after the character argument (Intel,PGI). For example, Fortran subroutines of the formsubroutine test(str1, str2)\ncharacter(len=*) :: str1,str2can be called via the following Julia code, where the lengths are appendedstr1 = \"foo\"\nstr2 = \"bar\"\nccall(:test, Void, (Ptr{UInt8}, Ptr{UInt8}, Csize_t, Csize_t),\n                    str1, str2, sizeof(str1), sizeof(str2))","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"warning: Warning\nFortran compilers may also add other hidden arguments for pointers, assumed-shape (:) and assumed-size (*) arrays. Such behaviour can be avoided by using ISO_C_BINDING and including bind(c) in the definition of the subroutine, which is strongly recommended for interoperable code. In this case there will be no hidden arguments, at the cost of some language features (e.g. only character(len=1) will be permitted to pass strings).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"note: Note\nA C function declared to return Cvoid will return the value nothing in Julia.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Struct-Type-correspondences-1","page":"Calling C and Fortran Code","title":"Struct Type correspondences","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Composite types, aka struct in C or TYPE in Fortran90 (or STRUCTURE / RECORD in some variants of F77), can be mirrored in Julia by creating a struct definition with the same field layout.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"When used recursively, isbits types are stored inline. All other types are stored as a pointer to the data. When mirroring a struct used by-value inside another struct in C, it is imperative that you do not attempt to manually copy the fields over, as this will not preserve the correct field alignment. Instead, declare an isbits struct type and use that instead. Unnamed structs are not possible in the translation to Julia.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Packed structs and union declarations are not supported by Julia.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"You can get a near approximation of a union if you know, a priori, the field that will have the greatest size (potentially including padding). When translating your fields to Julia, declare the Julia field to be only of that type.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Arrays of parameters can be expressed with NTuple:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"in C:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"struct B {\n    int A[3];\n};\nb_a_2 = B.A[2];","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"in Julia:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"struct B\n    A::NTuple{3, Cint}\nend\nb_a_2 = B.A[3]  # note the difference in indexing (1-based in Julia, 0-based in C)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Arrays of unknown size (C99-compliant variable length structs specified by [] or [0]) are not directly supported. Often the best way to deal with these is to deal with the byte offsets directly. For example, if a C library declared a proper string type and returned a pointer to it:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"struct String {\n    int strlen;\n    char data[];\n};","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"In Julia, we can access the parts independently to make a copy of that string:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"str = from_c::Ptr{Cvoid}\nlen = unsafe_load(Ptr{Cint}(str))\nunsafe_string(str + Core.sizeof(Cint), len)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Type-Parameters-1","page":"Calling C and Fortran Code","title":"Type Parameters","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The type arguments to ccall and @cfunction are evaluated statically, when the method containing the usage is defined. They therefore must take the form of a literal tuple, not a variable, and cannot reference local variables.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"This may sound like a strange restriction, but remember that since C is not a dynamic language like Julia, its functions can only accept argument types with a statically-known, fixed signature.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"However, while the type layout must be known statically to compute the intended C ABI, the static parameters of the function are considered to be part of this static environment. The static parameters of the function may be used as type parameters in the call signature, as long as they don't affect the layout of the type. For example, f(x::T) where {T} = ccall(:valid, Ptr{T}, (Ptr{T},), x) is valid, since Ptr is always a word-size primitive type. But, g(x::T) where {T} = ccall(:notvalid, T, (T,), x) is not valid, since the type layout of T is not known statically.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#SIMD-Values-1","page":"Calling C and Fortran Code","title":"SIMD Values","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note: This feature is currently implemented on 64-bit x86 and AArch64 platforms only.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"If a C/C++ routine has an argument or return value that is a native SIMD type, the corresponding Julia type is a homogeneous tuple of VecElement that naturally maps to the SIMD type.  Specifically:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The tuple must be the same size as the SIMD type. For example, a tuple representing an __m128 on x86 must have a size of 16 bytes.\nThe element type of the tuple must be an instance of VecElement{T} where T is a primitive type that is 1, 2, 4 or 8 bytes.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For instance, consider this C routine that uses AVX intrinsics:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"#include <immintrin.h>\n\n__m256 dist( __m256 a, __m256 b ) {\n    return _mm256_sqrt_ps(_mm256_add_ps(_mm256_mul_ps(a, a),\n                                        _mm256_mul_ps(b, b)));\n}","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The following Julia code calls dist using ccall:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"const m256 = NTuple{8, VecElement{Float32}}\n\na = m256(ntuple(i -> VecElement(sin(Float32(i))), 8))\nb = m256(ntuple(i -> VecElement(cos(Float32(i))), 8))\n\nfunction call_dist(a::m256, b::m256)\n    ccall((:dist, \"libdist\"), m256, (m256, m256), a, b)\nend\n\nprintln(call_dist(a,b))","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The host machine must have the requisite SIMD registers.  For example, the code above will not work on hosts without AVX support.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Memory-Ownership-1","page":"Calling C and Fortran Code","title":"Memory Ownership","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"malloc/free","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Memory allocation and deallocation of such objects must be handled by calls to the appropriate cleanup routines in the libraries being used, just like in any C program. Do not try to free an object received from a C library with Libc.free in Julia, as this may result in the free function being called via the wrong libc library and cause Julia to crash. The reverse (passing an object allocated in Julia to be freed by an external library) is equally invalid.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#When-to-use-T,-Ptr{T}-and-Ref{T}-1","page":"Calling C and Fortran Code","title":"When to use T, Ptr{T} and Ref{T}","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"In Julia code wrapping calls to external C routines, ordinary (non-pointer) data should be declared to be of type T inside the ccall, as they are passed by value.  For C code accepting pointers, Ref{T} should generally be used for the types of input arguments, allowing the use of pointers to memory managed by either Julia or C through the implicit call to Base.cconvert.  In contrast, pointers returned by the C function called should be declared to be of output type Ptr{T}, reflecting that the memory pointed to is managed by C only. Pointers contained in C structs should be represented as fields of type Ptr{T} within the corresponding Julia struct types designed to mimic the internal structure of corresponding C structs.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"In Julia code wrapping calls to external Fortran routines, all input arguments should be declared as of type Ref{T}, as Fortran passes all variables by pointers to memory locations. The return type should either be Cvoid for Fortran subroutines, or a T for Fortran functions returning the type T.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Mapping-C-Functions-to-Julia-1","page":"Calling C and Fortran Code","title":"Mapping C Functions to Julia","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#ccall-/-@cfunction-argument-translation-guide-1","page":"Calling C and Fortran Code","title":"ccall / @cfunction argument translation guide","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For translating a C argument list to Julia:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"T, where T is one of the primitive types: char, int, long, short, float, double, complex, enum or any of their typedef equivalents\nT, where T is an equivalent Julia Bits Type (per the table above)\nif T is an enum, the argument type should be equivalent to Cint or Cuint\nargument value will be copied (passed by value)\nstruct T (including typedef to a struct)\nT, where T is a Julia leaf type\nargument value will be copied (passed by value)\nvoid*\ndepends on how this parameter is used, first translate this to the intended pointer type, then determine the Julia equivalent using the remaining rules in this list\nthis argument may be declared as Ptr{Cvoid}, if it really is just an unknown pointer\njl_value_t*\nAny\nargument value must be a valid Julia object\njl_value_t**\nRef{Any}\nargument value must be a valid Julia object (or C_NULL)\nT*\nRef{T}, where T is the Julia type corresponding to T\nargument value will be copied if it is an isbits type otherwise, the value must be a valid Julia object\nT (*)(...) (e.g. a pointer to a function)\nPtr{Cvoid} (you may need to use @cfunction explicitly to create this pointer)\n... (e.g. a vararg)\nT..., where T is the Julia type\ncurrently unsupported by @cfunction\nva_arg\nnot supported by ccall or @cfunction","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#ccall-/-@cfunction-return-type-translation-guide-1","page":"Calling C and Fortran Code","title":"ccall / @cfunction return type translation guide","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For translating a C return type to Julia:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"void\nCvoid (this will return the singleton instance nothing::Cvoid)\nT, where T is one of the primitive types: char, int, long, short, float, double, complex, enum or any of their typedef equivalents\nT, where T is an equivalent Julia Bits Type (per the table above)\nif T is an enum, the argument type should be equivalent to Cint or Cuint\nargument value will be copied (returned by-value)\nstruct T (including typedef to a struct)\nT, where T is a Julia Leaf Type\nargument value will be copied (returned by-value)\nvoid*\ndepends on how this parameter is used, first translate this to the intended pointer type, then determine the Julia equivalent using the remaining rules in this list\nthis argument may be declared as Ptr{Cvoid}, if it really is just an unknown pointer\njl_value_t*\nAny\nargument value must be a valid Julia object\njl_value_t**\nPtr{Any} (Ref{Any} is invalid as a return type)\nargument value must be a valid Julia object (or C_NULL)\nT*\nIf the memory is already owned by Julia, or is an isbits type, and is known to be non-null:\nRef{T}, where T is the Julia type corresponding to T\na return type of Ref{Any} is invalid, it should either be Any (corresponding to jl_value_t*) or Ptr{Any} (corresponding to jl_value_t**)\nC MUST NOT modify the memory returned via Ref{T} if T is an isbits type\nIf the memory is owned by C:\nPtr{T}, where T is the Julia type corresponding to T\nT (*)(...) (e.g. a pointer to a function)\nPtr{Cvoid} (you may need to use @cfunction explicitly to create this pointer)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Passing-Pointers-for-Modifying-Inputs-1","page":"Calling C and Fortran Code","title":"Passing Pointers for Modifying Inputs","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Because C doesn't support multiple return values, often C functions will take pointers to data that the function will modify. To accomplish this within a ccall, you need to first encapsulate the value inside a Ref{T} of the appropriate type. When you pass this Ref object as an argument, Julia will automatically pass a C pointer to the encapsulated data:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"width = Ref{Cint}(0)\nrange = Ref{Cfloat}(0)\nccall(:foo, Cvoid, (Ref{Cint}, Ref{Cfloat}), width, range)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Upon return, the contents of width and range can be retrieved (if they were changed by foo) by width[] and range[]; that is, they act like zero-dimensional arrays.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Special-Reference-Syntax-for-ccall-(deprecated):-1","page":"Calling C and Fortran Code","title":"Special Reference Syntax for ccall (deprecated):","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The & syntax is deprecated, use the Ref{T} argument type instead.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A prefix & is used on an argument to ccall to indicate that a pointer to a scalar argument should be passed instead of the scalar value itself (required for all Fortran function arguments, as noted above). The following example computes a dot product using a BLAS function.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"function compute_dot(DX::Vector{Float64}, DY::Vector{Float64})\n    @assert length(DX) == length(DY)\n    n = length(DX)\n    incx = incy = 1\n    product = ccall((:ddot_, \"libLAPACK\"),\n                    Float64,\n                    (Ref{Int32}, Ptr{Float64}, Ref{Int32}, Ptr{Float64}, Ref{Int32}),\n                    n, DX, incx, DY, incy)\n    return product\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The meaning of prefix & is not quite the same as in C. In particular, any changes to the referenced variables will not be visible in Julia unless the type is mutable (declared via mutable struct). However, even for immutable structs it will not cause any harm for called functions to attempt such modifications (that is, writing through the passed pointers). Moreover, & may be used with any expression, such as &0 or &f(x).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"When a scalar value is passed with & as an argument of type Ptr{T}, the value will first be converted to type T.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Some-Examples-of-C-Wrappers-1","page":"Calling C and Fortran Code","title":"Some Examples of C Wrappers","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Here is a simple example of a C wrapper that returns a Ptr type:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"mutable struct gsl_permutation\nend\n\n# The corresponding C signature is\n#     gsl_permutation * gsl_permutation_alloc (size_t n);\nfunction permutation_alloc(n::Integer)\n    output_ptr = ccall(\n        (:gsl_permutation_alloc, :libgsl), # name of C function and library\n        Ptr{gsl_permutation},              # output type\n        (Csize_t,),                        # tuple of input types\n        n                                  # name of Julia variable to pass in\n    )\n    if output_ptr == C_NULL # Could not allocate memory\n        throw(OutOfMemoryError())\n    end\n    return output_ptr\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The GNU Scientific Library (here assumed to be accessible through :libgsl) defines an opaque pointer, gsl_permutation *, as the return type of the C function gsl_permutation_alloc. As user code never has to look inside the gsl_permutation struct, the corresponding Julia wrapper simply needs a new type declaration, gsl_permutation, that has no internal fields and whose sole purpose is to be placed in the type parameter of a Ptr type.  The return type of the ccall is declared as Ptr{gsl_permutation}, since the memory allocated and pointed to by output_ptr is controlled by C (and not Julia).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The input n is passed by value, and so the function's input signature is simply declared as (Csize_t,) without any Ref or Ptr necessary. (If the wrapper was calling a Fortran function instead, the corresponding function input signature should instead be (Ref{Csize_t},), since Fortran variables are passed by pointers.) Furthermore, n can be any type that is convertible to a Csize_t integer; the ccall implicitly calls Base.cconvert(Csize_t, n).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Here is a second example wrapping the corresponding destructor:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"# The corresponding C signature is\n#     void gsl_permutation_free (gsl_permutation * p);\nfunction permutation_free(p::Ref{gsl_permutation})\n    ccall(\n        (:gsl_permutation_free, :libgsl), # name of C function and library\n        Cvoid,                             # output type\n        (Ref{gsl_permutation},),          # tuple of input types\n        p                                 # name of Julia variable to pass in\n    )\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Here, the input p is declared to be of type Ref{gsl_permutation}, meaning that the memory that p points to may be managed by Julia or by C. A pointer to memory allocated by C should be of type Ptr{gsl_permutation}, but it is convertible using Base.cconvert and therefore can be used in the same (covariant) context of the input argument to a ccall. A pointer to memory allocated by Julia must be of type Ref{gsl_permutation}, to ensure that the memory address pointed to is valid and that Julia's garbage collector manages the chunk of memory pointed to correctly. Therefore, the Ref{gsl_permutation} declaration allows pointers managed by C or Julia to be used.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"If the C wrapper never expects the user to pass pointers to memory managed by Julia, then using p::Ptr{gsl_permutation} for the method signature of the wrapper and similarly in the ccall is also acceptable.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Here is a third example passing Julia arrays:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"# The corresponding C signature is\n#    int gsl_sf_bessel_Jn_array (int nmin, int nmax, double x,\n#                                double result_array[])\nfunction sf_bessel_Jn_array(nmin::Integer, nmax::Integer, x::Real)\n    if nmax < nmin\n        throw(DomainError())\n    end\n    result_array = Vector{Cdouble}(undef, nmax - nmin + 1)\n    errorcode = ccall(\n        (:gsl_sf_bessel_Jn_array, :libgsl), # name of C function and library\n        Cint,                               # output type\n        (Cint, Cint, Cdouble, Ref{Cdouble}),# tuple of input types\n        nmin, nmax, x, result_array         # names of Julia variables to pass in\n    )\n    if errorcode != 0\n        error(\"GSL error code $errorcode\")\n    end\n    return result_array\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The C function wrapped returns an integer error code; the results of the actual evaluation of the Bessel J function populate the Julia array result_array. This variable can only be used with corresponding input type declaration Ref{Cdouble}, since its memory is allocated and managed by Julia, not C. The implicit call to Base.cconvert(Ref{Cdouble}, result_array) unpacks the Julia pointer to a Julia array data structure into a form understandable by C.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note that for this code to work correctly, result_array must be declared to be of type Ref{Cdouble} and not Ptr{Cdouble}. The memory is managed by Julia and the Ref signature alerts Julia's garbage collector to keep managing the memory for result_array while the ccall executes. If Ptr{Cdouble} were used instead, the ccall may still work, but Julia's garbage collector would not be aware that the memory declared for result_array is being used by the external C function. As a result, the code may produce a memory leak if result_array never gets freed by the garbage collector, or if the garbage collector prematurely frees result_array, the C function may end up throwing an invalid memory access exception.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Garbage-Collection-Safety-1","page":"Calling C and Fortran Code","title":"Garbage Collection Safety","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"When passing data to a ccall, it is best to avoid using the pointer function. Instead define a convert method and pass the variables directly to the ccall. ccall automatically arranges that all of its arguments will be preserved from garbage collection until the call returns. If a C API will store a reference to memory allocated by Julia, after the ccall returns, you must arrange that the object remains visible to the garbage collector. The suggested way to handle this is to make a global variable of type Array{Ref,1} to hold these values, until the C library notifies you that it is finished with them.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Whenever you have created a pointer to Julia data, you must ensure the original data exists until you are done with using the pointer. Many methods in Julia such as unsafe_load and String make copies of data instead of taking ownership of the buffer, so that it is safe to free (or alter) the original data without affecting Julia. A notable exception is unsafe_wrap which, for performance reasons, shares (or can be told to take ownership of) the underlying buffer.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The garbage collector does not guarantee any order of finalization. That is, if a contained a reference to b and both a and b are due for garbage collection, there is no guarantee that b would be finalized after a. If proper finalization of a depends on b being valid, it must be handled in other ways.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Non-constant-Function-Specifications-1","page":"Calling C and Fortran Code","title":"Non-constant Function Specifications","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"A (name, library) function specification must be a constant expression. However, it is possible to use computed values as function names by staging through eval as follows:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"@eval ccall(($(string(\"a\", \"b\")), \"lib\"), ...","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"This expression constructs a name using string, then substitutes this name into a new ccall expression, which is then evaluated. Keep in mind that eval only operates at the top level, so within this expression local variables will not be available (unless their values are substituted with $). For this reason, eval is typically only used to form top-level definitions, for example when wrapping libraries that contain many similar functions. A similar example can be constructed for @cfunction.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"However, doing this will also be very slow and leak memory, so you should usually avoid this and instead keep reading. The next section discusses how to use indirect calls to efficiently accomplish a similar effect.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Indirect-Calls-1","page":"Calling C and Fortran Code","title":"Indirect Calls","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The first argument to ccall can also be an expression evaluated at run time. In this case, the expression must evaluate to a Ptr, which will be used as the address of the native function to call. This behavior occurs when the first ccall argument contains references to non-constants, such as local variables, function arguments, or non-constant globals.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For example, you might look up the function via dlsym, then cache it in a shared reference for that session. For example:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"macro dlsym(func, lib)\n    z = Ref{Ptr{Cvoid}}(C_NULL)\n    quote\n        let zlocal = $z[]\n            if zlocal == C_NULL\n                zlocal = dlsym($(esc(lib))::Ptr{Cvoid}, $(esc(func)))::Ptr{Cvoid}\n                $z[] = $zlocal\n            end\n            zlocal\n        end\n    end\nend\n\nmylibvar = Libdl.dlopen(\"mylib\")\nccall(@dlsym(\"myfunc\", mylibvar), Cvoid, ())","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Closure-cfunctions-1","page":"Calling C and Fortran Code","title":"Closure cfunctions","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The first argument to @cfunction can be marked with a $, in which case the return value will instead be a struct CFunction which closes over the argument. You must ensure that this return object is kept alive until all uses of it are done. The contents and code at the cfunction pointer will be erased via a finalizer when this reference is dropped and atexit. This is not usually needed, since this functionality is not present in C, but can be useful for dealing with ill-designed APIs which don't provide a separate closure environment parameter.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"function qsort(a::Vector{T}, cmp) where T\n    isbits(T) || throw(ArgumentError(\"this method can only qsort isbits arrays\"))\n    callback = @cfunction $cmp Cint (Ref{T}, Ref{T})\n    # Here, `callback` isa Base.CFunction, which will be converted to Ptr{Cvoid}\n    # (and protected against finalization) by the ccall\n    ccall(:qsort, Cvoid, (Ptr{T}, Csize_t, Csize_t, Ptr{Cvoid}),\n        a, length(a), Base.elsize(a), callback)\n    # We could instead use:\n    #    GC.@preserve callback begin\n    #        use(Base.unsafe_convert(Ptr{Cvoid}, callback))\n    #    end\n    # if we needed to use it outside of a `ccall`\n    return a\nend","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Closing-a-Library-1","page":"Calling C and Fortran Code","title":"Closing a Library","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"It is sometimes useful to close (unload) a library so that it can be reloaded. For instance, when developing C code for use with Julia, one may need to compile, call the C code from Julia, then close the library, make an edit, recompile, and load in the new changes. One can either restart Julia or use the Libdl functions to manage the library explicitly, such as:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"lib = Libdl.dlopen(\"./my_lib.so\") # Open the library explicitly.\nsym = Libdl.dlsym(lib, :my_fcn)   # Get a symbol for the function to call.\nccall(sym, ...) # Use the pointer `sym` instead of the (symbol, library) tuple (remaining arguments are the same).\nLibdl.dlclose(lib) # Close the library explicitly.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note that when using ccall with the tuple input (e.g., ccall((:my_fcn, \"./my_lib.so\"), ...)), the library is opened implicitly and it may not be explicitly closed.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Calling-Convention-1","page":"Calling C and Fortran Code","title":"Calling Convention","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The second argument to ccall can optionally be a calling convention specifier (immediately preceding return type). Without any specifier, the platform-default C calling convention is used. Other supported conventions are: stdcall, cdecl, fastcall, and thiscall (no-op on 64-bit Windows). For example (from base/libc.jl) we see the same gethostnameccall as above, but with the correct signature for Windows:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"hn = Vector{UInt8}(undef, 256)\nerr = ccall(:gethostname, stdcall, Int32, (Ptr{UInt8}, UInt32), hn, length(hn))","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For more information, please see the LLVM Language Reference.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"There is one additional special calling convention llvmcall, which allows inserting calls to LLVM intrinsics directly. This can be especially useful when targeting unusual platforms such as GPGPUs. For example, for CUDA, we need to be able to read the thread index:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"ccall(\"llvm.nvvm.read.ptx.sreg.tid.x\", llvmcall, Int32, ())","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"As with any ccall, it is essential to get the argument signature exactly correct. Also, note that there is no compatibility layer that ensures the intrinsic makes sense and works on the current target, unlike the equivalent Julia functions exposed by Core.Intrinsics.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Accessing-Global-Variables-1","page":"Calling C and Fortran Code","title":"Accessing Global Variables","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Global variables exported by native libraries can be accessed by name using the cglobal function. The arguments to cglobal are a symbol specification identical to that used by ccall, and a type describing the value stored in the variable:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"julia> cglobal((:errno, :libc), Int32)\nPtr{Int32} @0x00007f418d0816b8","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The result is a pointer giving the address of the value. The value can be manipulated through this pointer using unsafe_load and unsafe_store!.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Accessing-Data-through-a-Pointer-1","page":"Calling C and Fortran Code","title":"Accessing Data through a Pointer","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The following methods are described as \"unsafe\" because a bad pointer or type declaration can cause Julia to terminate abruptly.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Given a Ptr{T}, the contents of type T can generally be copied from the referenced memory into a Julia object using unsafe_load(ptr, [index]). The index argument is optional (default is 1), and follows the Julia-convention of 1-based indexing. This function is intentionally similar to the behavior of getindex and setindex! (e.g. [] access syntax).","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The return value will be a new object initialized to contain a copy of the contents of the referenced memory. The referenced memory can safely be freed or released.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"If T is Any, then the memory is assumed to contain a reference to a Julia object (a jl_value_t*), the result will be a reference to this object, and the object will not be copied. You must be careful in this case to ensure that the object was always visible to the garbage collector (pointers do not count, but the new reference does) to ensure the memory is not prematurely freed. Note that if the object was not originally allocated by Julia, the new object will never be finalized by Julia's garbage collector.  If the Ptr itself is actually a jl_value_t*, it can be converted back to a Julia object reference by unsafe_pointer_to_objref(ptr). (Julia values v can be converted to jl_value_t* pointers, as Ptr{Cvoid}, by calling pointer_from_objref(v).)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The reverse operation (writing data to a Ptr{T}), can be performed using unsafe_store!(ptr, value, [index]). Currently, this is only supported for primitive types or other pointer-free (isbits) immutable struct types.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Any operation that throws an error is probably currently unimplemented and should be posted as a bug so that it can be resolved.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"If the pointer of interest is a plain-data array (primitive type or immutable struct), the function unsafe_wrap(Array, ptr,dims, own = false) may be more useful. The final parameter should be true if Julia should \"take ownership\" of the underlying buffer and call free(ptr) when the returned Array object is finalized.  If the own parameter is omitted or false, the caller must ensure the buffer remains in existence until all access is complete.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Arithmetic on the Ptr type in Julia (e.g. using +) does not behave the same as C's pointer arithmetic. Adding an integer to a Ptr in Julia always moves the pointer by some number of bytes, not elements. This way, the address values obtained from pointer arithmetic do not depend on the element types of pointers.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#Thread-safety-1","page":"Calling C and Fortran Code","title":"Thread-safety","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Some C libraries execute their callbacks from a different thread, and since Julia isn't thread-safe you'll need to take some extra precautions. In particular, you'll need to set up a two-layered system: the C callback should only schedule (via Julia's event loop) the execution of your \"real\" callback. To do this, create an AsyncCondition object and wait on it:","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"cond = Base.AsyncCondition()\nwait(cond)","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"The callback you pass to C should only execute a ccall to :uv_async_send, passing cond.handle as the argument, taking care to avoid any allocations or other interactions with the Julia runtime.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"Note that events may be coalesced, so multiple calls to uv_async_send may result in a single wakeup notification to the condition.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#More-About-Callbacks-1","page":"Calling C and Fortran Code","title":"More About Callbacks","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For more details on how to pass callbacks to C libraries, see this blog post.","category":"page"},{"location":"manual/calling-c-and-fortran-code.html#C-1","page":"Calling C and Fortran Code","title":"C++","text":"","category":"section"},{"location":"manual/calling-c-and-fortran-code.html#","page":"Calling C and Fortran Code","title":"Calling C and Fortran Code","text":"For direct C++ interfacing, see the Cxx package. For tools to create C++ bindings, see the CxxWrap package.","category":"page"},{"location":"manual/handling-operating-system-variation.html#Handling-Operating-System-Variation-1","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"","category":"section"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"When writing cross-platform applications or libraries, it is often necessary to allow for differences between operating systems. The variable Sys.KERNEL can be used to handle such cases. There are several functions in the Sys module intended to make this easier, such as isunix, islinux, isapple, isbsd, isfreebsd, and iswindows. These may be used as follows:","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"if Sys.iswindows()\n    windows_specific_thing(a)\nend","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"Note that islinux, isapple, and isfreebsd are mutually exclusive subsets of isunix. Additionally, there is a macro @static which makes it possible to use these functions to conditionally hide invalid code, as demonstrated in the following examples.","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"Simple blocks:","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"ccall((@static Sys.iswindows() ? :_fopen : :fopen), ...)","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"Complex blocks:","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"@static if Sys.islinux()\n    linux_specific_thing(a)\nelse\n    generic_thing(a)\nend","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"When chaining conditionals (including if/elseif/end), the @static must be repeated for each level (parentheses optional, but recommended for readability):","category":"page"},{"location":"manual/handling-operating-system-variation.html#","page":"Handling Operating System Variation","title":"Handling Operating System Variation","text":"@static Sys.iswindows() ? :a : (@static Sys.isapple() ? :b : :c)","category":"page"},{"location":"manual/environment-variables.html#Environment-Variables-1","page":"Environment Variables","title":"Environment Variables","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Julia can be configured with a number of environment variables, set either in the usual way for each operating system, or in a portable way from within Julia. Supposing that you want to set the environment variable JULIA_EDITOR to vim, you can type ENV[\"JULIA_EDITOR\"] = \"vim\" (for instance, in the REPL) to make this change on a case by case basis, or add the same to the user configuration file ~/.julia/config/startup.jl in the user's home directory to have a permanent effect. The current value of the same environment variable can be determined by evaluating ENV[\"JULIA_EDITOR\"].","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The environment variables that Julia uses generally start with JULIA. If InteractiveUtils.versioninfo is called with the keyword verbose=true, then the output will list defined environment variables relevant for Julia, including those for which JULIA appears in the name.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nSome variables, such as JULIA_NUM_THREADS and JULIA_PROJECT, need to be set before Julia starts, therefore adding these to ~/.julia/config/startup.jl is too late in the startup process. In Bash, environment variables can either be set manually by running, e.g., export JULIA_NUM_THREADS=4 before starting Julia, or by adding the same command to -/.bashrc or ~/.bash_profile to set the variable each time Bash is started.","category":"page"},{"location":"manual/environment-variables.html#File-locations-1","page":"Environment Variables","title":"File locations","text":"","category":"section"},{"location":"manual/environment-variables.html#JULIA_BINDIR-1","page":"Environment Variables","title":"JULIA_BINDIR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The absolute path of the directory containing the Julia executable, which sets the global variable Sys.BINDIR. If $JULIA_BINDIR is not set, then Julia determines the value Sys.BINDIR at run-time.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The executable itself is one of","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"$JULIA_BINDIR/julia\n$JULIA_BINDIR/julia-debug","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"by default.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The global variable Base.DATAROOTDIR determines a relative path from Sys.BINDIR to the data directory associated with Julia. Then the path","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"$JULIA_BINDIR/$DATAROOTDIR/julia/base","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"determines the directory in which Julia initially searches for source files (via Base.find_source_file()).","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Likewise, the global variable Base.SYSCONFDIR determines a relative path to the configuration file directory. Then Julia searches for a startup.jl file at","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"$JULIA_BINDIR/$SYSCONFDIR/julia/startup.jl\n$JULIA_BINDIR/../etc/julia/startup.jl","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"by default (via Base.load_julia_startup()).","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"For example, a Linux installation with a Julia executable located at /bin/julia, a DATAROOTDIR of ../share, and a SYSCONFDIR of ../etc will have JULIA_BINDIR set to /bin, a source-file search path of","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"/share/julia/base","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"and a global configuration search path of","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"/etc/julia/startup.jl","category":"page"},{"location":"manual/environment-variables.html#JULIA_PROJECT-1","page":"Environment Variables","title":"JULIA_PROJECT","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"A directory path that indicates which project should be the initial active project. Setting this environment variable has the same effect as specifying the --project start-up option, but --project has higher precedence. If the variable is set to @. then Julia tries to find a project directory that contains Project.toml or JuliaProject.toml file from the current directory and its parents. See also the chapter on Code Loading.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nJULIA_PROJECT must be defined before starting julia; defining it in startup.jl is too late in the startup process.","category":"page"},{"location":"manual/environment-variables.html#JULIA_LOAD_PATH-1","page":"Environment Variables","title":"JULIA_LOAD_PATH","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The JULIA_LOAD_PATH environment variable is used to populate the global Julia LOAD_PATH variable, which determines which packages can be loaded via import and using (see Code Loading).","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Unlike the shell PATH variable, empty entries in JULIA_LOAD_PATH are expanded to the default value of LOAD_PATH, [\"@\", \"@v#.#\", \"@stdlib\"] when populating LOAD_PATH. This allows easy appending, prepending, etc. of the load path value in shell scripts regardless of whether JULIA_LOAD_PATH is already set or not. For example, to prepend the directory /foo/bar to LOAD_PATH just do","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"export JULIA_LOAD_PATH=\"/foo/bar:$JULIA_LOAD_PATH\"","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If the JULIA_LOAD_PATH environment variable is already set, its old value will be prepended with /foo/bar. On the other hand, if JULIA_LOAD_PATH is not set, then it will be set to /foo/bar: which will expand to a LOAD_PATH value of [\"/foo/bar\", \"@\", \"@v#.#\", \"@stdlib\"]. If JULIA_LOAD_PATH is set to the empty string, it expands to an empty LOAD_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty load path via the environment variable. If you want the default load path, either unset the environment variable or if it must have a value, set it to the string :.","category":"page"},{"location":"manual/environment-variables.html#JULIA_DEPOT_PATH-1","page":"Environment Variables","title":"JULIA_DEPOT_PATH","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The JULIA_DEPOT_PATH environment variable is used to populate the global Julia DEPOT_PATH variable, which controls where the package manager, as well as Julia's code loading mechanisms, look for package registries, installed packages, named environments, repo clones, cached compiled package images, and configuration files.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Unlike the shell PATH variable but similar to JULIA_LOAD_PATH, empty entries in JULIA_DEPOT_PATH are expanded to the default value of DEPOT_PATH. This allows easy appending, prepending, etc. of the depot path value in shell scripts regardless of whether JULIA_DEPOT_PATH is already set or not. For example, to prepend the directory /foo/bar to DEPOT_PATH just do","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"export JULIA_DEPOT_PATH=\"/foo/bar:$JULIA_DEPOT_PATH\"","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If the JULIA_DEPOT_PATH environment variable is already set, its old value will be prepended with /foo/bar. On the other hand, if JULIA_DEPOT_PATH is not set, then it will be set to /foo/bar: which will have the effect of prepending /foo/bar to the default depot path. If JULIA_DEPOT_PATH is set to the empty string, it expands to an empty DEPOT_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty depot path via the environment variable. If you want the default depot path, either unset the environment variable or if it must have a value, set it to the string :.","category":"page"},{"location":"manual/environment-variables.html#JULIA_HISTORY-1","page":"Environment Variables","title":"JULIA_HISTORY","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The absolute path REPL.find_hist_file() of the REPL's history file. If $JULIA_HISTORY is not set, then REPL.find_hist_file() defaults to","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"$HOME/.julia/logs/repl_history.jl","category":"page"},{"location":"manual/environment-variables.html#JULIA_PKGRESOLVE_ACCURACY-1","page":"Environment Variables","title":"JULIA_PKGRESOLVE_ACCURACY","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"A positive Int that determines how much time the max-sum subroutine MaxSum.maxsum() of the package dependency resolver will devote to attempting satisfying constraints before giving up: this value is by default 1, and larger values correspond to larger amounts of time.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Suppose the value of $JULIA_PKGRESOLVE_ACCURACY is n. Then","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"the number of pre-decimation iterations is 20*n,\nthe number of iterations between decimation steps is 10*n, and\nat decimation steps, at most one in every 20*n packages is decimated.","category":"page"},{"location":"manual/environment-variables.html#External-applications-1","page":"Environment Variables","title":"External applications","text":"","category":"section"},{"location":"manual/environment-variables.html#JULIA_SHELL-1","page":"Environment Variables","title":"JULIA_SHELL","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The absolute path of the shell with which Julia should execute external commands (via Base.repl_cmd()). Defaults to the environment variable $SHELL, and falls back to /bin/sh if $SHELL is unset.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nOn Windows, this environment variable is ignored, and external commands are executed directly.","category":"page"},{"location":"manual/environment-variables.html#JULIA_EDITOR-1","page":"Environment Variables","title":"JULIA_EDITOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The editor returned by InteractiveUtils.editor() and used in, e.g., InteractiveUtils.edit, referring to the command of the preferred editor, for instance vim.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"$JULIA_EDITOR takes precedence over $VISUAL, which in turn takes precedence over $EDITOR. If none of these environment variables is set, then the editor is taken to be open on Windows and OS X, or /etc/alternatives/editor if it exists, or emacs otherwise.","category":"page"},{"location":"manual/environment-variables.html#Parallelization-1","page":"Environment Variables","title":"Parallelization","text":"","category":"section"},{"location":"manual/environment-variables.html#JULIA_CPU_THREADS-1","page":"Environment Variables","title":"JULIA_CPU_THREADS","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Overrides the global variable Base.Sys.CPU_THREADS, the number of logical CPU cores available.","category":"page"},{"location":"manual/environment-variables.html#JULIA_WORKER_TIMEOUT-1","page":"Environment Variables","title":"JULIA_WORKER_TIMEOUT","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"A Float64 that sets the value of Distributed.worker_timeout() (default: 60.0). This function gives the number of seconds a worker process will wait for a master process to establish a connection before dying.","category":"page"},{"location":"manual/environment-variables.html#JULIA_NUM_THREADS-1","page":"Environment Variables","title":"JULIA_NUM_THREADS","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"An unsigned 64-bit integer (uint64_t) that sets the maximum number of threads available to Julia. If $JULIA_NUM_THREADS exceeds the number of available physical CPU cores, then the number of threads is set to the number of cores. If $JULIA_NUM_THREADS is not positive or is not set, or if the number of CPU cores cannot be determined through system calls, then the number of threads is set to 1.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nJULIA_NUM_THREADS must be defined before starting julia; defining it in startup.jl is too late in the startup process.","category":"page"},{"location":"manual/environment-variables.html#JULIA_THREAD_SLEEP_THRESHOLD-1","page":"Environment Variables","title":"JULIA_THREAD_SLEEP_THRESHOLD","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set to a string that starts with the case-insensitive substring \"infinite\", then spinning threads never sleep. Otherwise, $JULIA_THREAD_SLEEP_THRESHOLD is interpreted as an unsigned 64-bit integer (uint64_t) and gives, in nanoseconds, the amount of time after which spinning threads should sleep.","category":"page"},{"location":"manual/environment-variables.html#JULIA_EXCLUSIVE-1","page":"Environment Variables","title":"JULIA_EXCLUSIVE","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set to anything besides 0, then Julia's thread policy is consistent with running on a dedicated machine: the master thread is on proc 0, and threads are affinitized. Otherwise, Julia lets the operating system handle thread policy.","category":"page"},{"location":"manual/environment-variables.html#REPL-formatting-1","page":"Environment Variables","title":"REPL formatting","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Environment variables that determine how REPL output should be formatted at the terminal. Generally, these variables should be set to ANSI terminal escape sequences. Julia provides a high-level interface with much of the same functionality; see the section on The Julia REPL.","category":"page"},{"location":"manual/environment-variables.html#JULIA_ERROR_COLOR-1","page":"Environment Variables","title":"JULIA_ERROR_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.error_color() (default: light red, \"\\033[91m\") that errors should have at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_WARN_COLOR-1","page":"Environment Variables","title":"JULIA_WARN_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.warn_color() (default: yellow, \"\\033[93m\") that warnings should have at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_INFO_COLOR-1","page":"Environment Variables","title":"JULIA_INFO_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.info_color() (default: cyan, \"\\033[36m\") that info should have at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_INPUT_COLOR-1","page":"Environment Variables","title":"JULIA_INPUT_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.input_color() (default: normal, \"\\033[0m\") that input should have at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_ANSWER_COLOR-1","page":"Environment Variables","title":"JULIA_ANSWER_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.answer_color() (default: normal, \"\\033[0m\") that output should have at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_STACKFRAME_LINEINFO_COLOR-1","page":"Environment Variables","title":"JULIA_STACKFRAME_LINEINFO_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.stackframe_lineinfo_color() (default: bold, \"\\033[1m\") that line info should have during a stack trace at the terminal.","category":"page"},{"location":"manual/environment-variables.html#JULIA_STACKFRAME_FUNCTION_COLOR-1","page":"Environment Variables","title":"JULIA_STACKFRAME_FUNCTION_COLOR","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"The formatting Base.stackframe_function_color() (default: bold, \"\\033[1m\") that function calls should have during a stack trace at the terminal.","category":"page"},{"location":"manual/environment-variables.html#Debugging-and-profiling-1","page":"Environment Variables","title":"Debugging and profiling","text":"","category":"section"},{"location":"manual/environment-variables.html#JULIA_GC_ALLOC_POOL,-JULIA_GC_ALLOC_OTHER,-JULIA_GC_ALLOC_PRINT-1","page":"Environment Variables","title":"JULIA_GC_ALLOC_POOL, JULIA_GC_ALLOC_OTHER, JULIA_GC_ALLOC_PRINT","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set, these environment variables take strings that optionally start with the character 'r', followed by a string interpolation of a colon-separated list of three signed 64-bit integers (int64_t). This triple of integers a:b:c represents the arithmetic sequence a, a + b, a + 2*b, ... c.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If it's the nth time that jl_gc_pool_alloc() has been called, and n   belongs to the arithmetic sequence represented by $JULIA_GC_ALLOC_POOL,   then garbage collection is forced.\nIf it's the nth time that maybe_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_OTHER, then garbage   collection is forced.\nIf it's the nth time that jl_gc_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_PRINT, then counts   for the number of calls to jl_gc_pool_alloc() and maybe_collect() are   printed.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If the value of the environment variable begins with the character 'r', then the interval between garbage collection events is randomized.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nThese environment variables only have an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","category":"page"},{"location":"manual/environment-variables.html#JULIA_GC_NO_GENERATIONAL-1","page":"Environment Variables","title":"JULIA_GC_NO_GENERATIONAL","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set to anything besides 0, then the Julia garbage collector never performs \"quick sweeps\" of memory.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","category":"page"},{"location":"manual/environment-variables.html#JULIA_GC_WAIT_FOR_DEBUGGER-1","page":"Environment Variables","title":"JULIA_GC_WAIT_FOR_DEBUGGER","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set to anything besides 0, then the Julia garbage collector will wait for a debugger to attach instead of aborting whenever there's a critical error.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","category":"page"},{"location":"manual/environment-variables.html#ENABLE_JITPROFILING-1","page":"Environment Variables","title":"ENABLE_JITPROFILING","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set to anything besides 0, then the compiler will create and register an event listener for just-in-time (JIT) profiling.","category":"page"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with JIT profiling support, using eitherIntel's VTune™ Amplifier (USE_INTEL_JITEVENTS set to 1 in the build configuration), or\nOProfile (USE_OPROFILE_JITEVENTS set to 1 in the build configuration).","category":"page"},{"location":"manual/environment-variables.html#JULIA_LLVM_ARGS-1","page":"Environment Variables","title":"JULIA_LLVM_ARGS","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"Arguments to be passed to the LLVM backend.","category":"page"},{"location":"manual/environment-variables.html#JULIA_DEBUG_LOADING-1","page":"Environment Variables","title":"JULIA_DEBUG_LOADING","text":"","category":"section"},{"location":"manual/environment-variables.html#","page":"Environment Variables","title":"Environment Variables","text":"If set, then Julia prints detailed information about the cache in the loading process of Base.require.","category":"page"},{"location":"manual/embedding.html#Embedding-Julia-1","page":"Embedding Julia","title":"Embedding Julia","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"As we have seen in Calling C and Fortran Code, Julia has a simple and efficient way to call functions written in C. But there are situations where the opposite is needed: calling Julia function from C code. This can be used to integrate Julia code into a larger C/C++ project, without the need to rewrite everything in C/C++. Julia has a C API to make this possible. As almost all programming languages have some way to call C functions, the Julia C API can also be used to build further language bridges (e.g. calling Julia from Python or C#).","category":"page"},{"location":"manual/embedding.html#High-Level-Embedding-1","page":"Embedding Julia","title":"High-Level Embedding","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Note: This section covers embedding Julia code in C on Unix-like operating systems. For doing this on Windows, please see the section following this.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"We start with a simple C program that initializes Julia and calls some Julia code:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"#include <julia.h>\nJULIA_DEFINE_FAST_TLS() // only define this once, in an executable (not in a shared library) if you want fast code.\n\nint main(int argc, char *argv[])\n{\n    /* required: setup the Julia context */\n    jl_init();\n\n    /* run Julia commands */\n    jl_eval_string(\"print(sqrt(2.0))\");\n\n    /* strongly recommended: notify Julia that the\n         program is about to terminate. this allows\n         Julia time to cleanup pending write requests\n         and run all finalizers\n    */\n    jl_atexit_hook(0);\n    return 0;\n}","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"In order to build this program you have to put the path to the Julia header into the include path and link against libjulia. For instance, when Julia is installed to $JULIA_DIR, one can compile the above test program test.c with gcc using:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"gcc -o test -fPIC -I$JULIA_DIR/include/julia -L$JULIA_DIR/lib test.c -ljulia $JULIA_DIR/lib/julia/libstdc++.so.6","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Then if the environment variable JULIA_BINDIR is set to $JULIA_DIR/bin, the output test program can be executed.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Alternatively, look at the embedding.c program in the Julia source tree in the test/embedding/ folder. The file ui/repl.c program is another simple example of how to set jl_options options while linking against libjulia.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The first thing that has to be done before calling any other Julia C function is to initialize Julia. This is done by calling jl_init, which tries to automatically determine Julia's install location. If you need to specify a custom location, or specify which system image to load, use jl_init_with_image instead.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The second statement in the test program evaluates a Julia statement using a call to jl_eval_string.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Before the program terminates, it is strongly recommended to call jl_atexit_hook.  The above example program calls this before returning from main.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"note: Note\nCurrently, dynamically linking with the libjulia shared library requires passing the RTLD_GLOBAL option. In Python, this looks like:>>> julia=CDLL('./libjulia.dylib',RTLD_GLOBAL)\n>>> julia.jl_init.argtypes = []\n>>> julia.jl_init()\n250593296","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"note: Note\nIf the julia program needs to access symbols from the main executable, it may be necessary to add -Wl,--export-dynamic linker flag at compile time on Linux in addition to the ones generated by julia-config.jl described below. This is not necessary when compiling a shared library.","category":"page"},{"location":"manual/embedding.html#Using-julia-config-to-automatically-determine-build-parameters-1","page":"Embedding Julia","title":"Using julia-config to automatically determine build parameters","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The script julia-config.jl was created to aid in determining what build parameters are required by a program that uses embedded Julia.  This script uses the build parameters and system configuration of the particular Julia distribution it is invoked by to export the necessary compiler flags for an embedding program to interact with that distribution.  This script is located in the Julia shared data directory.","category":"page"},{"location":"manual/embedding.html#Example-1","page":"Embedding Julia","title":"Example","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"#include <julia.h>\n\nint main(int argc, char *argv[])\n{\n    jl_init();\n    (void)jl_eval_string(\"println(sqrt(2.0))\");\n    jl_atexit_hook(0);\n    return 0;\n}","category":"page"},{"location":"manual/embedding.html#On-the-command-line-1","page":"Embedding Julia","title":"On the command line","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"A simple use of this script is from the command line.  Assuming that julia-config.jl is located in /usr/local/julia/share/julia, it can be invoked on the command line directly and takes any combination of 3 flags:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"/usr/local/julia/share/julia/julia-config.jl\nUsage: julia-config [--cflags|--ldflags|--ldlibs]","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"If the above example source is saved in the file embed_example.c, then the following command will compile it into a running program on Linux and Windows (MSYS2 environment), or if on OS/X, then substitute clang for gcc.:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"/usr/local/julia/share/julia/julia-config.jl --cflags --ldflags --ldlibs | xargs gcc embed_example.c","category":"page"},{"location":"manual/embedding.html#Use-in-Makefiles-1","page":"Embedding Julia","title":"Use in Makefiles","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"But in general, embedding projects will be more complicated than the above, and so the following allows general makefile support as well – assuming GNU make because of the use of the shell macro expansions.  Additionally, though many times julia-config.jl may be found in the directory /usr/local, this is not necessarily the case, but Julia can be used to locate julia-config.jl too, and the makefile can be used to take advantage of that.  The above example is extended to use a Makefile:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"JL_SHARE = $(shell julia -e 'print(joinpath(Sys.BINDIR, Base.DATAROOTDIR, \"julia\"))')\nCFLAGS   += $(shell $(JL_SHARE)/julia-config.jl --cflags)\nCXXFLAGS += $(shell $(JL_SHARE)/julia-config.jl --cflags)\nLDFLAGS  += $(shell $(JL_SHARE)/julia-config.jl --ldflags)\nLDLIBS   += $(shell $(JL_SHARE)/julia-config.jl --ldlibs)\n\nall: embed_example","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Now the build command is simply make.","category":"page"},{"location":"manual/embedding.html#High-Level-Embedding-on-Windows-with-Visual-Studio-1","page":"Embedding Julia","title":"High-Level Embedding on Windows with Visual Studio","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"If the JULIA_DIR environment variable hasn't been setup, add it using the System panel before starting Visual Studio. The bin folder under JULIA_DIR should be on the system PATH.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"We start by opening Visual Studio and creating a new Console Application project. To the 'stdafx.h' header file, add the following lines at the end:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"#define JULIA_ENABLE_THREADING\n#include <julia.h>","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Then, replace the main() function in the project with this code:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"int main(int argc, char *argv[])\n{\n    /* required: setup the Julia context */\n    jl_init();\n\n    /* run Julia commands */\n    jl_eval_string(\"print(sqrt(2.0))\");\n\n    /* strongly recommended: notify Julia that the\n         program is about to terminate. this allows\n         Julia time to cleanup pending write requests\n         and run all finalizers\n    */\n    jl_atexit_hook(0);\n    return 0;\n}","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The next step is to set up the project to find the Julia include files and the libraries. It's important to know whether the Julia installation is 32- or 64-bits. Remove any platform configuration that doesn't correspond to the Julia installation before proceeding.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Using the project Properties dialog, go to C/C++ | General and add $(JULIA_DIR)\\include\\julia\\ to the Additional Include Directories property. Then, go to the Linker | General section and add $(JULIA_DIR)\\lib to the Additional Library Directories property. Finally, under Linker | Input, add libjulia.dll.a;libopenlibm.dll.a; to the list of libraries.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"At this point, the project should build and run.","category":"page"},{"location":"manual/embedding.html#Converting-Types-1","page":"Embedding Julia","title":"Converting Types","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Real applications will not just need to execute expressions, but also return their values to the host program. jl_eval_string returns a jl_value_t*, which is a pointer to a heap-allocated Julia object. Storing simple data types like Float64 in this way is called boxing, and extracting the stored primitive data is called unboxing. Our improved sample program that calculates the square root of 2 in Julia and reads back the result in C looks as follows:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *ret = jl_eval_string(\"sqrt(2.0)\");\n\nif (jl_typeis(ret, jl_float64_type)) {\n    double ret_unboxed = jl_unbox_float64(ret);\n    printf(\"sqrt(2.0) in C: %e \\n\", ret_unboxed);\n}\nelse {\n    printf(\"ERROR: unexpected return type from sqrt(::Float64)\\n\");\n}","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"In order to check whether ret is of a specific Julia type, we can use the jl_isa, jl_typeis, or jl_is_... functions. By typing typeof(sqrt(2.0)) into the Julia shell we can see that the return type is Float64 (double in C). To convert the boxed Julia value into a C double the jl_unbox_float64 function is used in the above code snippet.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Corresponding jl_box_... functions are used to convert the other way:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *a = jl_box_float64(3.0);\njl_value_t *b = jl_box_float32(3.0f);\njl_value_t *c = jl_box_int32(3);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"As we will see next, boxing is required to call Julia functions with specific arguments.","category":"page"},{"location":"manual/embedding.html#Calling-Julia-Functions-1","page":"Embedding Julia","title":"Calling Julia Functions","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"While jl_eval_string allows C to obtain the result of a Julia expression, it does not allow passing arguments computed in C to Julia. For this you will need to invoke Julia functions directly, using jl_call:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_function_t *func = jl_get_function(jl_base_module, \"sqrt\");\njl_value_t *argument = jl_box_float64(2.0);\njl_value_t *ret = jl_call1(func, argument);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"In the first step, a handle to the Julia function sqrt is retrieved by calling jl_get_function. The first argument passed to jl_get_function is a pointer to the Base module in which sqrt is defined. Then, the double value is boxed using jl_box_float64. Finally, in the last step, the function is called using jl_call1. jl_call0, jl_call2, and jl_call3 functions also exist, to conveniently handle different numbers of arguments. To pass more arguments, use jl_call:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *jl_call(jl_function_t *f, jl_value_t **args, int32_t nargs)","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Its second argument args is an array of jl_value_t* arguments and nargs is the number of arguments.","category":"page"},{"location":"manual/embedding.html#Memory-Management-1","page":"Embedding Julia","title":"Memory Management","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"As we have seen, Julia objects are represented in C as pointers. This raises the question of who is responsible for freeing these objects.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Typically, Julia objects are freed by a garbage collector (GC), but the GC does not automatically know that we are holding a reference to a Julia value from C. This means the GC can free objects out from under you, rendering pointers invalid.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The GC can only run when Julia objects are allocated. Calls like jl_box_float64 perform allocation, and allocation might also happen at any point in running Julia code. However, it is generally safe to use pointers in between jl_... calls. But in order to make sure that values can survive jl_... calls, we have to tell Julia that we hold a reference to a Julia value. This can be done using the JL_GC_PUSH macros:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *ret = jl_eval_string(\"sqrt(2.0)\");\nJL_GC_PUSH1(&ret);\n// Do something with ret\nJL_GC_POP();","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The JL_GC_POP call releases the references established by the previous JL_GC_PUSH. Note that JL_GC_PUSH stores references on the C stack, so it must be exactly paired with a JL_GC_POP before the scope is exited. That is, before the function returns, or control flow otherwise leaves the block in which the JL_GC_PUSH was invoked.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Several Julia values can be pushed at once using the JL_GC_PUSH2 , JL_GC_PUSH3 , JL_GC_PUSH4 , JL_GC_PUSH5 , and JL_GC_PUSH6 macros. To push an array of Julia values one can use the JL_GC_PUSHARGS macro, which can be used as follows:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t **args;\nJL_GC_PUSHARGS(args, 2); // args can now hold 2 `jl_value_t*` objects\nargs[0] = some_value;\nargs[1] = some_other_value;\n// Do something with args (e.g. call jl_... functions)\nJL_GC_POP();","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Each scope must have only one call to JL_GC_PUSH*. Hence, if all variables cannot be pushed once by a single call to JL_GC_PUSH*, or if there are more than 6 variables to be pushed and using an array of arguments is not an option, then one can use inner blocks:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *ret1 = jl_eval_string(\"sqrt(2.0)\");\nJL_GC_PUSH1(&ret1);\njl_value_t *ret2 = 0;\n{\n    jl_function_t *func = jl_get_function(jl_base_module, \"exp\");\n    ret2 = jl_call1(func, ret1);\n    JL_GC_PUSH1(&ret2);\n    // Do something with ret2.\n    JL_GC_POP();    // This pops ret2.\n}\nJL_GC_POP();    // This pops ret1.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"If it is required to hold the pointer to a variable between functions (or block scopes), then it is not possible to use JL_GC_PUSH*. In this case, it is necessary to create and keep a reference to the variable in the Julia global scope. One simple way to accomplish this is to use a global IdDict that will hold the references, avoiding deallocation by the GC. However, this method will only work properly with mutable types.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"// This functions shall be executed only once, during the initialization.\njl_value_t* refs = jl_eval_string(\"refs = IdDict()\");\njl_function_t* setindex = jl_get_function(jl_base_module, \"setindex!\");\n\n...\n\n// `var` is the variable we want to protect between function calls.\njl_value_t* var = 0;\n\n...\n\n// `var` is a `Vector{Float64}`, which is mutable.\nvar = jl_eval_string(\"[sqrt(2.0); sqrt(4.0); sqrt(6.0)]\");\n\n// To protect `var`, add its reference to `refs`.\njl_call3(setindex, refs, var, var);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"If the variable is immutable, then it needs to be wrapped in an equivalent mutable container or, preferably, in a RefValue{Any} before it is pushed to IdDict. In this approach, the container has to be created or filled in via C code using, for example, the function jl_new_struct. If the container is created by jl_call*, then you will need to reload the pointer to be used in C code.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"// This functions shall be executed only once, during the initialization.\njl_value_t* refs = jl_eval_string(\"refs = IdDict()\");\njl_function_t* setindex = jl_get_function(jl_base_module, \"setindex!\");\njl_datatype_t* reft = (jl_datatype_t*)jl_eval_string(\"Base.RefValue{Any}\");\n\n...\n\n// `var` is the variable we want to protect between function calls.\njl_value_t* var = 0;\n\n...\n\n// `var` is a `Float64`, which is immutable.\nvar = jl_eval_string(\"sqrt(2.0)\");\n\n// Protect `var` until we add its reference to `refs`.\nJL_GC_PUSH1(&var);\n\n// Wrap `var` in `RefValue{Any}` and push to `refs` to protect it.\njl_value_t* rvar = jl_new_struct(reft, var);\nJL_GC_POP();\n\njl_call3(setindex, refs, rvar, rvar);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The GC can be allowed to deallocate a variable by removing the reference to it from refs using the function delete!, provided that no other reference to the variable is kept anywhere:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_function_t* delete = jl_get_function(jl_base_module, \"delete!\");\njl_call2(delete, refs, rvar);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"As an alternative for very simple cases, it is possible to just create a global container of type Vector{Any} and fetch the elements from that when necessary, or even to create one global variable per pointer using","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_set_global(jl_main_module, jl_symbol(\"var\"), var);","category":"page"},{"location":"manual/embedding.html#Updating-fields-of-GC-managed-objects-1","page":"Embedding Julia","title":"Updating fields of GC-managed objects","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The garbage collector operates under the assumption that it is aware of every old-generation object pointing to a young-generation one. Any time a pointer is updated breaking that assumption, it must be signaled to the collector with the jl_gc_wb (write barrier) function like so:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t *parent = some_old_value, *child = some_young_value;\n((some_specific_type*)parent)->field = child;\njl_gc_wb(parent, child);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"It is in general impossible to predict which values will be old at runtime, so the write barrier must be inserted after all explicit stores. One notable exception is if the parent object was just allocated and garbage collection was not run since then. Remember that most jl_... functions can sometimes invoke garbage collection.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"The write barrier is also necessary for arrays of pointers when updating their data directly. For example:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_array_t *some_array = ...; // e.g. a Vector{Any}\nvoid **data = (void**)jl_array_data(some_array);\njl_value_t *some_value = ...;\ndata[0] = some_value;\njl_gc_wb(some_array, some_value);","category":"page"},{"location":"manual/embedding.html#Manipulating-the-Garbage-Collector-1","page":"Embedding Julia","title":"Manipulating the Garbage Collector","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"There are some functions to control the GC. In normal use cases, these should not be necessary.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Function Description\njl_gc_collect() Force a GC run\njl_gc_enable(0) Disable the GC, return previous state as int\njl_gc_enable(1) Enable the GC,  return previous state as int\njl_gc_is_enabled() Return current state as int","category":"page"},{"location":"manual/embedding.html#Working-with-Arrays-1","page":"Embedding Julia","title":"Working with Arrays","text":"","category":"section"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Julia and C can share array data without copying. The next example will show how this works.","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Julia arrays are represented in C by the datatype jl_array_t*. Basically, jl_array_t is a struct that contains:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Information about the datatype\nA pointer to the data block\nInformation about the sizes of the array","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"To keep things simple, we start with a 1D array. Creating an array containing Float64 elements of length 10 is done by:","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"jl_value_t* array_type = jl_apply_array_type((jl_value_t*)jl_float64_type, 1);\njl_array_t* x          = jl_alloc_array_1d(array_type, 10);","category":"page"},{"location":"manual/embedding.html#","page":"Embedding Julia","title":"Embedding Julia","text":"Alternatively, if you have already allocated the array you can gene