# Julia Documentation

## Manual

  * [Introduction](@ref man-introduction)
  * [Getting Started](@ref)
  * [Variables](@ref)
  * [Integers and Floating-Point Numbers](@ref)
  * [Mathematical Operations and Elementary Functions](@ref)
  * [Complex and Rational Numbers](@ref)
  * [Strings](@ref man-strings)
  * [Functions](@ref man-functions)
  * [Control Flow](@ref)
  * [Scope of Variables](@ref scope-of-variables)
  * [Types](@ref man-types)
  * [Methods](@ref)
  * [Constructors](@ref man-constructors)
  * [Conversion and Promotion](@ref conversion-and-promotion)
  * [Interfaces](@ref)
  * [Modules](@ref modules)
  * [Documentation](@ref)
  * [Metaprogramming](@ref)
  * [Multi-dimensional Arrays](@ref man-multi-dim-arrays)
  * [Linear Algebra](@ref)
  * [Networking and Streams](@ref)
  * [Parallel Computing](@ref)
  * [Date and DateTime](@ref)
  * [Running External Programs](@ref)
  * [Calling C and Fortran Code](@ref)
  * [Handling Operating System Variation](@ref)
  * [Environment Variables](@ref)
  * [Interacting With Julia](@ref)
  * [Embedding Julia](@ref)
  * [Packages](@ref)
  * [Profiling](@ref)
  * [Stack Traces](@ref)
  * [Performance Tips](@ref man-performance-tips)
  * [Workflow Tips](@ref man-workflow-tips)
  * [Style Guide](@ref)
  * [Frequently Asked Questions](@ref)
  * [Noteworthy Differences from other Languages](@ref)
  * [Unicode Input](@ref)

## Standard Library

  * [Essentials](@ref)
  * [Collections and Data Structures](@ref)
  * [Mathematics](@ref)
  * [Numbers](@ref lib-numbers)
  * [Strings](@ref lib-strings)
  * [Arrays](@ref lib-arrays)
  * [Tasks and Parallel Computing](@ref)
  * [Linear Algebra](@ref)
  * [Constants](@ref lib-constants)
  * [Filesystem](@ref)
  * [I/O and Network](@ref)
  * [Punctuation](@ref)
  * [Sorting and Related Functions](@ref)
  * [Package Manager Functions](@ref)
  * [Dates and Time](@ref stdlib-dates)
  * [Iteration utilities](@ref)
  * [Unit Testing](@ref)
  * [C Interface](@ref)
  * [C Standard Library](@ref)
  * [Dynamic Linker](@ref)
  * [Profiling](@ref lib-profiling)
  * [StackTraces](@ref)
  * [SIMD Support](@ref)

## Developer Documentation

  * [Reflection and introspection](@ref)
  * Documentation of Julia's Internals
      * [Initialization of the Julia runtime](@ref)
      * [Julia ASTs](@ref)
      * [More about types](@ref)
      * [Memory layout of Julia Objects](@ref)
      * [Eval of Julia code](@ref)
      * [Calling Conventions](@ref)
      * [High-level Overview of the Native-Code Generation Process](@ref)
      * [Julia Functions](@ref)
      * [Base.Cartesian](@ref)
      * [Talking to the compiler (the `:meta` mechanism)](@ref)
      * [SubArrays](@ref)
      * [System Image Building](@ref)
      * [Working with LLVM](@ref)
      * [printf() and stdio in the Julia runtime](@ref)
      * [Bounds checking](@ref)
      * [Proper maintenance and care of multi-threading locks](@ref)
      * [Arrays with custom indices](@ref)
      * [Base.LibGit2](@ref)
      * [Module loading](@ref)
  * Developing/debugging Julia's C code
      * [Reporting and analyzing crashes (segfaults)](@ref)
      * [gdb debugging tips](@ref)
      * [Using Valgrind with Julia](@ref)
      * [Sanitizer support](@ref)
