# This file is a part of Julia. License is MIT: https://julialang.org/license

# Steps to regenerate this file:
# 1. Remove all `precompile` calls
# 2. Rebuild system image
# 3. Enable TRACE_COMPILE in options.h and rebuild
# 4. Run `./julia 2> precompiles.txt` and do various things.
# 5. Run `grep -v '#[0-9]' precompiles.txt >> base/precompile.jl` (filters out closures, which
#    might have different generated names in different environments)

precompile(Tuple{typeof(Base.pointer), Array{UInt8, 1}, UInt64})
precompile(Tuple{typeof(Base.convert), Type{Ptr{Int32}}, Ptr{UInt8}})
if USE_GPL_LIBS
precompile(Tuple{typeof(Base.SparseArrays.CHOLMOD.set_print_level), Array{UInt8, 1}, Int64})
end
precompile(Tuple{Type{Base.Multimedia.TextDisplay}, Base.TTY})
precompile(Tuple{typeof(Base._start)})
precompile(Tuple{typeof(Base.copy!), Array{String, 1}, Int64, Array{Any, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.empty!), Base.Dict{Int64, Union{Base.Distributed.Worker, Base.Distributed.LocalProcess}}})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Distributed.DefaultClusterManager})
precompile(Tuple{typeof(Base.Distributed.init_worker), String, Base.Distributed.DefaultClusterManager})
precompile(Tuple{typeof(Base.finalizer), Base.TCPServer, typeof(Base.uvfinalize)})
precompile(Tuple{Type{Base.TCPServer}, Ptr{Void}, Int64})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Int32})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Libc.RawFD})
precompile(Tuple{typeof(Base.uv_status_string), Base.TCPServer})
precompile(Tuple{typeof(Base._fd), Base.TCPServer})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Type{Base.TCPServer}, String, Base.Libc.RawFD, String, String, String})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.TCPServer})
precompile(Tuple{typeof(Base.isopen), Base.TCPServer})
precompile(Tuple{typeof(Base.check_open), Base.TCPServer})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.TCPServer})
precompile(Tuple{typeof(Base.stream_wait), Base.TCPServer, Base.Condition})
precompile(Tuple{Type{Base.TCPServer}})
precompile(Tuple{typeof(Base.close), Base.TCPServer})
precompile(Tuple{getfield(Base, Symbol("#kw##listen")), Array{Any, 1}, typeof(Base.listen), Base.TCPServer})
precompile(Tuple{getfield(Base, Symbol("#kw##listen")), Array{Any, 1}, typeof(Base.listen), Base.InetAddr{Base.IPv4}})
precompile(Tuple{typeof(Base.ndigits0z), UInt16})
precompile(Tuple{typeof(Base.dec), UInt16, Int64, Bool})
precompile(Tuple{typeof(Base.Libc.strerror), Int32})
precompile(Tuple{typeof(Base.copy!), Array{Any, 1}, Base.KeyIterator{Base.Dict{Any, Any}}})
precompile(Tuple{typeof(Base.promoteK), Type{Any}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, DataType, Core.Inference.Const, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, DataType, Core.Inference.Const, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.sync_add), Task})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Int64, Tuple{Int64, Tuple{}}}, Int64})
precompile(Tuple{typeof(Base.Distributed.local_remotecall_thunk), typeof(Base.Distributed.set_valid_processes), Tuple{Array{Int64, 1}}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.set_valid_processes), Base.Distributed.Worker, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.set_valid_processes), Base.Distributed.LocalProcess, Array{Int64, 1}})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.set_valid_processes), Base.Distributed.Worker, Array{Int64, 1}})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.set_valid_processes), Base.Distributed.LocalProcess, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Sort.Float.isnan), Base.Order.ForwardOrdering, Float32})
precompile(Tuple{typeof(Base.Sort.Float.isnan), Base.Order.ForwardOrdering, Float64})
precompile(Tuple{typeof(Base.Sort.Float.isnan), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}, Float32})
precompile(Tuple{typeof(Base.Sort.Float.isnan), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}, Float64})
precompile(Tuple{typeof(Base.Sort.Float.issignleft), Base.Order.ForwardOrdering, Float32})
precompile(Tuple{typeof(Base.Sort.Float.issignleft), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}, Float32})
precompile(Tuple{typeof(Base.Sort.Float.issignleft), Base.Order.ForwardOrdering, Float64})
precompile(Tuple{typeof(Base.Sort.Float.issignleft), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}, Float64})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Sort.Float.Left})
precompile(Tuple{typeof(Base.Sort.Float.left), Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.Float.left), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Sort.Float.Right})
precompile(Tuple{typeof(Base.Sort.Float.right), Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.Float.right), Base.Order.ReverseOrdering{Base.Order.ForwardOrdering}})
precompile(Tuple{typeof(Base.stat), Int64})
precompile(Tuple{typeof(Base.readbytes_all!), Base.IOStream, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.read), Base.IOStream})
precompile(Tuple{typeof(Base.open), typeof(Base.readstring), String})
precompile(Tuple{typeof(Base.rstrip), Base.SubString{String}, Array{Char, 1}})
precompile(Tuple{typeof(Base.lstrip), Base.SubString{String}, Array{Char, 1}})
precompile(Tuple{getfield(Base, Symbol("#kw##split")), Array{Any, 1}, typeof(Base.split), String, Char})
precompile(Tuple{getfield(Base, Symbol("#kw##split")), Array{Any, 1}, typeof(Base.split), Base.SubString{String}, Char})
precompile(Tuple{typeof(Base.map!), typeof(Base.strip), Array{Base.SubString{String}, 1}, Array{Base.SubString{String}, 1}})
precompile(Tuple{typeof(Base.UTF8proc.isnumber), Base.SubString{String}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}}, Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Int64})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}, Int64}})
precompile(Tuple{typeof(Core.Inference.indexed_next), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}, Int64}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}, Int64}, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{QuoteNode}, Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}}, Type{QuoteNode}, Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Base.DevNullStream})
precompile(Tuple{typeof(Base.finalizer), Base.Process, typeof(Base.uvfinalize)})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Base.DevNullStream, Bool}})
precompile(Tuple{Type{Ref{Base.Cstring}}, Array{String, 1}})
precompile(Tuple{typeof(Core.Inference.eltype), Type{Array{String, 1}}})
precompile(Tuple{typeof(Base.string), Void, String, DataType})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, String, Char})
precompile(Tuple{typeof(Base.throw_boundserror), Base.UnitRange{Int64}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Core.Inference.convert), Type{DataType}, Type{Bool}})
precompile(Tuple{typeof(Core.Inference.convert), Type{DataType}, Type{Base.OneTo{Int64}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{DataType, DataType, typeof(Type), Core.Inference.Const, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{DataType, DataType, typeof(Type), Core.Inference.Const, Core.Inference.Const}, Int64})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Tuple{}, Tuple{}, Int64}}, Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Tuple{}, Tuple{}, Int64}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Tuple{}, Tuple{}, Int64}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Tuple{}, Tuple{}, Int64}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Tuple{}, Tuple{}, Int64}, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{QuoteNode}, Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}}, Type{QuoteNode}, Tuple{Tuple{}, Tuple{}, Int64}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}, Int64}, Type{QuoteNode}}, Int64})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Tuple{}, Tuple{}}}, Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Tuple{}, Tuple{}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Tuple{}, Tuple{}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Tuple{}, Tuple{}}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Tuple{}, Tuple{}}, Int64})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{QuoteNode}, Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}}, Type{QuoteNode}, Tuple{Tuple{}, Tuple{}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Tuple{}, Tuple{}}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.length), Tuple{DataType, DataType, DataType, Core.Inference.Const, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{DataType, DataType, DataType, Core.Inference.Const, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Core.Inference.length), Tuple{DataType, DataType, typeof(Type), typeof(Type), Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{DataType, DataType, typeof(Type), typeof(Type), Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Core.Inference.length), Tuple{DataType, DataType, DataType, DataType, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{DataType, DataType, DataType, DataType, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.Process})
precompile(Tuple{typeof(Base.stream_wait), Base.Process, Base.Condition})
precompile(Tuple{typeof(Base.kill), Base.Process, Int64})
precompile(Tuple{typeof(Base.banner), Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Dict{Any, Any}})
precompile(Tuple{typeof(Base.answer_color)})
precompile(Tuple{typeof(Base.input_color)})
precompile(Tuple{typeof(Base.show_circular), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Tuple{}})
precompile(Tuple{typeof(Base.show_delim_array), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Tuple{}, Char, Char, Char, Bool, Int64, Int64})
precompile(Tuple{typeof(Base.throw_boundserror), Array{Base.StackTraces.StackFrame, 1}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.splice!), Array{Base.StackTraces.StackFrame, 1}, Base.UnitRange{Int64}, Array{Any, 1}})
precompile(Tuple{typeof(Base.REPL.ip_matches_func), Ptr{Void}, Symbol})
precompile(Tuple{typeof(Base.throw_boundserror), Array{Ptr{Void}, 1}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Ptr{Void}, 1}, Int64, Array{Ptr{Void}, 1}, Int64, Int64})
precompile(Tuple{Type{Base.Channel{Any}}, Int64})
precompile(Tuple{typeof(Base.rsearch), String, UInt8, Int64})
precompile(Tuple{typeof(Base.rsearch), String, Char, Int64})
precompile(Tuple{typeof(Base.rsearch), Array{UInt8, 1}, UInt8, Int64})
precompile(Tuple{typeof(Base._rsearchindex), Array{UInt8, 1}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base._rsearch), Array{UInt8, 1}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.rsearch), Array{Int8, 1}, UInt8, Int64})
precompile(Tuple{typeof(Base._rsearchindex), Array{Int8, 1}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base._rsearch), Array{Int8, 1}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.rsearch), Array{UInt8, 1}, Char, Int64})
precompile(Tuple{typeof(Base.rsearch), Array{Int8, 1}, Char, Int64})
precompile(Tuple{typeof(Base.splice!), Array{Base.Multimedia.Display, 1}, Int64, Array{Any, 1}})
precompile(Tuple{typeof(Core.Inference.isbits), Base.LineEdit.EmptyCompletionProvider})
precompile(Tuple{typeof(Core.Inference.isbits), Base.LineEdit.EmptyHistoryProvider})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Symbol, Any}, Base.LineEdit.Prompt, Symbol, Int64})
precompile(Tuple{typeof(Base.sizehint!), Base.Dict{Symbol, Any}, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Symbol, Any}, Base.LineEdit.Prompt, Symbol})
precompile(Tuple{typeof(Base.copy!), Base.IndexLinear, Array{Symbol, 1}, Base.IndexLinear, Array{UInt8, 1}})
precompile(Tuple{getfield(Base, Symbol("#kw##readline")), Array{Any, 1}, typeof(Base.readline), Base.IOStream})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Void}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Void}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Void}}, Tuple{Void}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Void}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Void}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Void}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Void}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Void}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Void}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Void}, Int64})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{String, 1}, Char})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{String, typeof(Base.info)}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{String, typeof(Base.info)}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{String, typeof(Base.info)}}, Tuple{String, typeof(Base.info)}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{String, typeof(Base.info)}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{String, typeof(Base.info)}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{String, typeof(Base.info)}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{String, typeof(Base.info)}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{String, typeof(Base.info)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{String, typeof(Base.info)}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{String, typeof(Base.info)}, Int64})
precompile(Tuple{typeof(Core.Inference.start), Tuple{String, Int64}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{typeof(Base.info), Int64}})
precompile(Tuple{typeof(Core.Inference.indexed_next), Tuple{typeof(Base.info), Int64}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{typeof(Base.info), Int64}, Int64})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Base.SubString{String}, Char})
precompile(Tuple{typeof(Base.sizehint!), Base.Dict{Any, Any}, Int64})
precompile(Tuple{typeof(Base.LineEdit.getEntry), Base.Dict{Char, Any}, Char})
precompile(Tuple{typeof(Base.LineEdit.getEntry), Base.Dict{Char, Any}, String})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Base.Dict{Any, Any}, 1}, Int64, Array{Base.Dict{Any, Any}, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.copy!), Array{Base.Dict{Any, Any}, 1}, Int64, Array{Base.Dict{Any, Any}, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.promote_type), Type{Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}}, Type{Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}}})
precompile(Tuple{typeof(Base.promote_rule), Type{Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}}, Type{Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}}})
precompile(Tuple{typeof(Base.promote_rule), Type{Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}}, Type{Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}}})
precompile(Tuple{typeof(Base.promote_result), Type{Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}}, Type{Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}}, Type{Union{}}, Type{Union{}}})
precompile(Tuple{typeof(Base.promote_type), Type{Base.LineEdit.Prompt}, Type{Base.LineEdit.TextInterface}})
precompile(Tuple{typeof(Base.promote_rule), Type{Base.LineEdit.Prompt}, Type{Base.LineEdit.TextInterface}})
precompile(Tuple{typeof(Base.promote_rule), Type{Base.LineEdit.TextInterface}, Type{Base.LineEdit.Prompt}})
precompile(Tuple{typeof(Base.promote_result), Type{Base.LineEdit.Prompt}, Type{Base.LineEdit.TextInterface}, Type{Union{}}, Type{Union{}}})
precompile(Tuple{typeof(Base.setindex!), Array{Base.LineEdit.TextInterface, 1}, Base.LineEdit.Prompt, Int64})
precompile(Tuple{typeof(Base.setindex!), Array{Base.LineEdit.TextInterface, 1}, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}, Int64})
precompile(Tuple{typeof(Base.setindex!), Array{Base.LineEdit.TextInterface, 1}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}, Int64})
precompile(Tuple{typeof(Base.copy!), Array{Base.LineEdit.TextInterface, 1}, Tuple{Base.LineEdit.Prompt, Base.LineEdit.Prompt, Base.LineEdit.Prompt, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}}})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Int64, String, Bool})
precompile(Tuple{typeof(Base.uv_status_string), Base.UDPSocket})
precompile(Tuple{typeof(Base.Terminals.cmove_up), Base.Terminals.TerminalBuffer, Int64})
precompile(Tuple{typeof(Base.Terminals.cmove_down), Base.Terminals.TerminalBuffer, Int64})
precompile(Tuple{typeof(Base.readuntil), Base.AbstractIOBuffer{Array{UInt8, 1}}, UInt8})
precompile(Tuple{typeof(Base.Terminals.cmove_right), Base.Terminals.TerminalBuffer, Int64})
precompile(Tuple{typeof(Base.LineEdit._clear_input_area), Base.Terminals.TerminalBuffer, Base.LineEdit.InputAreaState})
precompile(Tuple{typeof(Base.seek), Base.AbstractIOBuffer{Array{UInt8, 1}}, Int64})
precompile(Tuple{getfield(Base, Symbol("#kw##readline")), Array{Any, 1}, typeof(Base.readline), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.endswith), String, String})
precompile(Tuple{getfield(Base, Symbol("#kw##readline")), Array{Any, 1}, typeof(Base.readline), Base.Terminals.TerminalBuffer})
precompile(Tuple{typeof(Base.LineEdit.write_prompt), Base.Terminals.TerminalBuffer, Base.LineEdit.Prompt})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.LineEdit.InputAreaState, String})
precompile(Tuple{typeof(Base.:(==)), Array{Char, 1}, Array{Char, 1}})
precompile(Tuple{typeof(Base.LineEdit.update_key_repeats), Base.LineEdit.MIState, Array{Char, 1}})
precompile(Tuple{typeof(Base.LineEdit.reset_state), Base.LineEdit.MIState})
precompile(Tuple{Type{Base.Dict{Any, Any}}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Distributed.default_addprocs_params)})
precompile(Tuple{typeof(Base.Distributed.topology), Symbol})
precompile(Tuple{typeof(Base.shift!), Array{Base.Distributed.WorkerConfig, 1}})
precompile(Tuple{typeof(Base.sync_end)})
precompile(Tuple{typeof(Base.wait), Task})
precompile(Tuple{typeof(Base.Distributed.workers)})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}})
precompile(Tuple{typeof(Base.lock), Base.ReentrantLock})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##addprocs_locked")), Array{Any, 1}, typeof(Base.Distributed.addprocs_locked), Base.Distributed.SSHManager})
precompile(Tuple{typeof(Base.unlock), Base.ReentrantLock})
precompile(Tuple{typeof(Base.Distributed.check_addprocs_args), Array{Any, 1}})
precompile(Tuple{Type{Base.Distributed.SSHManager}, Array{Any, 1}})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##addprocs")), Array{Any, 1}, typeof(Base.Distributed.addprocs), Base.Distributed.SSHManager})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{}}})
precompile(Tuple{typeof(Base.extrema), Array{Int64, 1}})
precompile(Tuple{typeof(Base.Sort.sort_int_range!), Array{Int64, 1}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Sort.QuickSortAlg})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##addprocs_locked")), Array{Any, 1}, typeof(Base.Distributed.addprocs_locked), Base.Distributed.LocalManager})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Symbol, Symbol, Int64})
precompile(Tuple{Type{Base.Dict{Any, Any}}, Base.Pair{Symbol, Symbol}, Base.Pair{Symbol, String}, Base.Pair{Symbol, String}, Base.Pair{Symbol, Base.Cmd}, Base.Pair{Symbol, Bool}})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##addprocs")), Array{Any, 1}, typeof(Base.Distributed.addprocs), Base.Distributed.LocalManager})
precompile(Tuple{typeof(Base.listenany), Base.IPv4, UInt16})
precompile(Tuple{typeof(Base.Distributed.check_master_connect)})
precompile(Tuple{typeof(Base.load_machine_file), String})
precompile(Tuple{typeof(Base.load_juliarc)})
precompile(Tuple{typeof(Base.shift!), Array{String, 1}})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, String, String, Char})
precompile(Tuple{typeof(Base.read), Base.AbstractIOBuffer{Array{UInt8, 1}}, Type{Char}})
precompile(Tuple{typeof(Base.write), Base.Terminals.TerminalBuffer, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.LineEdit.keymap), Array{Base.Dict{Any, Any}, 1}})
precompile(Tuple{typeof(Base.LineEdit.add_specialisations), Base.Dict{Char, Any}, Base.Dict{Char, Any}, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Char, Any}, Base.Dict{Char, Any}, Char})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Char, Any}, Char})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Char, Any}, Base.Dict{Char, Any}, Char, Int64})
precompile(Tuple{typeof(Base.setdiff), Base.KeyIterator{Base.Dict{Any, Any}}, Base.KeyIterator{Base.Dict{Any, Any}}})
precompile(Tuple{typeof(Base.LineEdit.keymap_merge), Base.Dict{Char, Any}, Base.Dict{Any, Any}})
precompile(Tuple{typeof(Base.LineEdit.postprocess!), Base.Dict{Char, Any}})
precompile(Tuple{typeof(Base.LineEdit.keymap_unify), Array{Base.Dict{Any, Any}, 1}})
precompile(Tuple{typeof(Base.LineEdit.validate_keymap), Base.Dict{Char, Any}})
precompile(Tuple{Type{Expr}, Symbol, GlobalRef, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue, SSAValue})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{String, typeof(Base.info)}})
precompile(Tuple{typeof(Base.:(==)), Void, String})
precompile(Tuple{Type{Symbol}, Void})
precompile(Tuple{Type{Symbol}, Base.SubString{String}})
precompile(Tuple{typeof(Core.Inference.isbits), Base.REPL.REPLCompletionProvider})
precompile(Tuple{getfield(Core, Symbol("#kw#Type")), Array{Any, 1}, Type{Base.LineEdit.Prompt}, String})
precompile(Tuple{typeof(Core.Inference.isbits), Base.REPL.ShellCompletionProvider})
precompile(Tuple{Type{Base.Dict{Symbol, Any}}, Base.Pair{Symbol, Base.LineEdit.Prompt}, Base.Pair{Symbol, Base.LineEdit.Prompt}, Base.Pair{Symbol, Base.LineEdit.Prompt}})
precompile(Tuple{Type{Base.REPL.REPLHistoryProvider}, Base.Dict{Symbol, Any}})
precompile(Tuple{typeof(Base.REPL.find_hist_file)})
precompile(Tuple{typeof(Base.REPL.history_reset_state), Base.REPL.REPLHistoryProvider})
precompile(Tuple{typeof(Base.LineEdit.setup_search_keymap), Base.REPL.REPLHistoryProvider})
precompile(Tuple{typeof(Core.Inference.isbits), Base.REPL.LatexCompletions})
precompile(Tuple{typeof(Base.LineEdit.setup_prefix_keymap), Base.REPL.REPLHistoryProvider, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.getindex), Type{Base.Dict{Any, Any}}, Base.Dict{Any, Any}, Base.Dict{Any, Any}, Base.Dict{Any, Any}, Base.Dict{Any, Any}, Base.Dict{Any, Any}, Base.Dict{Any, Any}})
precompile(Tuple{typeof(Base.prepend!), Array{Base.Dict{Any, Any}, 1}, Array{Base.Dict{Any, Any}, 1}})
precompile(Tuple{typeof(Base.REPL.mode_keymap), Base.LineEdit.Prompt})
precompile(Tuple{typeof(Core.Inference.isbits), Array{Base.Multimedia.Display, 1}})
precompile(Tuple{typeof(Base.Multimedia.popdisplay), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}})
precompile(Tuple{Type{String}, Base.BitArray{1}})
precompile(Tuple{typeof(Base.REPL.ends_with_semicolon), String})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Void, Int64}})
precompile(Tuple{typeof(Base.Multimedia.popdisplay), Base.REPL.REPLDisplay{Base.REPL.BasicREPL}})
precompile(Tuple{typeof(Base.Multimedia.popdisplay), Base.REPL.REPLDisplay{Base.REPL.StreamREPL}})
precompile(Tuple{typeof(Base.REPL.start_repl_backend), Base.Channel{Any}, Base.Channel{Any}})
precompile(Tuple{typeof(Base._collect), Array{Ptr{Void}, 1}, Base.Generator{Array{Ptr{Void}, 1}, typeof(Base.StackTraces.lookup)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.shift!), Array{Base.StackTraces.StackFrame, 1}})
precompile(Tuple{typeof(Base.StackTraces.stacktrace), Array{Ptr{Void}, 1}, Bool})
precompile(Tuple{typeof(Base.success), Base.Process})
precompile(Tuple{typeof(Base.mapreduce_impl), typeof(Base.success), typeof(Base.:(&)), Array{Base.Process, 1}, Int64, Int64, Int64})
precompile(Tuple{typeof(Base.string), Base.Cmd})
precompile(Tuple{typeof(Base.test_success), Base.Process})
precompile(Tuple{typeof(Base._mapreduce), typeof(Base.success), typeof(Base.:(&)), Base.IndexLinear, Array{Base.Process, 1}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{String, String, String}})
precompile(Tuple{getfield(Base, Symbol("#kw##shell_escape")), Array{Any, 1}, typeof(Base.shell_escape), Base.Cmd})
precompile(Tuple{typeof(Base.show), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Cmd})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Cmd})
precompile(Tuple{typeof(Core.Inference.isbits), Ptr{Void}})
precompile(Tuple{typeof(Base.cconvert), Type{Ptr{Base.Cstring}}, Ptr{Void}})
precompile(Tuple{typeof(Base.cconvert), Type{Ptr{Base.Cstring}}, Void})
precompile(Tuple{typeof(Base.cconvert), Type{Base.Cstring}, Ptr{Void}})
precompile(Tuple{typeof(Base.unsafe_convert), Type{Ptr{Base.Cstring}}, Ptr{Void}})
precompile(Tuple{typeof(Base.unsafe_convert), Type{Ptr{Base.Cstring}}, Base.RefArray{Base.Cstring, Array{Base.Cstring, 1}, Any}})
precompile(Tuple{Type{Base.Process}, Base.Cmd, Ptr{Void}, Base.DevNullStream, Base.DevNullStream, Base.DevNullStream})
precompile(Tuple{getfield(Base, Symbol("#kw##spawn")), Array{Any, 1}, typeof(Base.spawn), Base.Cmd, Tuple{Base.DevNullStream, Base.DevNullStream, Base.DevNullStream}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Tuple{String}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{String}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base.append!), Array{String, 1}, Array{Any, 1}})
precompile(Tuple{typeof(Base.process_options), Base.JLOptions})
precompile(Tuple{typeof(Base.Terminals.hascolor), Base.Terminals.TTYTerminal})
precompile(Tuple{Type{Base.REPL.LineEditREPL}, Base.Terminals.TTYTerminal, Bool})
precompile(Tuple{typeof(Base.close), Base.IOStream})
precompile(Tuple{typeof(Base._atexit)})
precompile(Tuple{typeof(Base.Distributed.terminate_all_workers)})
precompile(Tuple{getfield(Base, Symbol("#kw##notify")), Array{Any, 1}, typeof(Base.notify), Base.Condition, Void})
precompile(Tuple{typeof(Base.Distributed.local_remotecall_thunk), typeof(Base.exit), Tuple{}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.Worker})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.LocalProcess})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.Worker})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.LocalProcess})
precompile(Tuple{typeof(Base.Distributed.set_worker_state), Base.Distributed.Worker, Base.Distributed.WorkerState})
precompile(Tuple{typeof(Base.Distributed.set_worker_state), Base.Distributed.LocalProcess, Base.Distributed.WorkerState})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##rmprocs")), Array{Any, 1}, typeof(Base.Distributed.rmprocs), Array{Int64, 1}})
precompile(Tuple{typeof(Base.Distributed.interrupt), Array{Int64, 1}})
precompile(Tuple{typeof(Base.uvfinalize), Base.TTY})
precompile(Tuple{typeof(Base.uv_status_string), Base.TTY})
precompile(Tuple{typeof(Base._fd), Base.TTY})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.TTY})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.TTY})
precompile(Tuple{typeof(Base.isopen), Base.TTY})
precompile(Tuple{typeof(Base.stream_wait), Base.TTY, Base.Condition})
precompile(Tuple{typeof(Base.close), Base.TTY})
precompile(Tuple{typeof(Base.unsafe_store!), Ptr{Int32}, Int64})
precompile(Tuple{Type{Base.Terminals.TTYTerminal}, String, Base.TTY, Base.TTY, Base.IOStream})
precompile(Tuple{typeof(Base.unsafe_write), Base.TTY, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.unpreserve_handle), Task})
precompile(Tuple{typeof(Base.check_open), Base.TTY})
precompile(Tuple{typeof(Base.stream_wait), Task})
precompile(Tuple{typeof(Base.uv_write), Base.TTY, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.flush), Base.TTY})
precompile(Tuple{typeof(Base.Distributed.flush_gc_msgs)})
precompile(Tuple{typeof(Base.__atreplinit), Base.REPL.LineEditREPL})
precompile(Tuple{typeof(Base.:(==)), Base.Multimedia.TextDisplay, Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}})
precompile(Tuple{typeof(Base.:(==)), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}})
precompile(Tuple{typeof(Base.REPL.hist_from_file), Base.REPL.REPLHistoryProvider, Base.IOStream, String})
precompile(Tuple{typeof(Base.REPL.hist_getline), Base.IOStream})
precompile(Tuple{typeof(Base.push!), Array{String, 1}, Base.SubString{String}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Char, Char})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Char, Char, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.LineEdit.KeyAlias, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Int64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.LineEdit.KeyAlias, Int64, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, String, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, String, String, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Void, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Void, String, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.LineEdit.KeyAlias, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.LineEdit.KeyAlias, String, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Char, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Char, String, Int64})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##add_nested_key!")), Array{Any, 1}, typeof(Base.LineEdit.add_nested_key!), Base.Dict{Char, Any}, String, Void})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Char, Any}, Void, Char, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Char, Any}, Void, Char})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##add_nested_key!")), Array{Any, 1}, typeof(Base.LineEdit.add_nested_key!), Base.Dict{Char, Any}, String, Base.LineEdit.KeyAlias})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Char, Any}, Base.LineEdit.KeyAlias, Char, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Char, Any}, Base.LineEdit.KeyAlias, Char})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Void}, Void, String})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Void}, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Void}, Void, String, Int64})
precompile(Tuple{typeof(Base.LineEdit.fixup_keymaps!), Base.Dict{Char, Any}, Int64, Char, Void})
precompile(Tuple{typeof(Base.LineEdit.run_interface), Base.Terminals.TTYTerminal, Base.LineEdit.ModalInterface})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.LineEdit.InputAreaState, Base.LineEdit.PromptState})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.LineEdit.InputAreaState, Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.write), Base.Terminals.TTYTerminal, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.LineEdit.init_state), Base.Terminals.TTYTerminal, Base.LineEdit.ModalInterface})
precompile(Tuple{typeof(Base.LineEdit.prompt!), Base.Terminals.TTYTerminal, Base.LineEdit.ModalInterface, Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.getindex), Array{Base.LineEdit.TextInterface, 1}, Int64})
precompile(Tuple{typeof(Base.start), Array{Base.LineEdit.TextInterface, 1}})
precompile(Tuple{typeof(Base.done), Array{Base.LineEdit.TextInterface, 1}, Int64})
precompile(Tuple{typeof(Base.next), Array{Base.LineEdit.TextInterface, 1}, Int64})
precompile(Tuple{typeof(Base.LineEdit.init_state), Base.Terminals.TTYTerminal, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.LineEdit.PromptState, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.LineEdit.PromptState, Base.LineEdit.Prompt, Int64})
precompile(Tuple{typeof(Base.LineEdit.init_state), Base.Terminals.TTYTerminal, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.LineEdit.SearchState, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.LineEdit.SearchState, Base.LineEdit.HistoryPrompt{Base.REPL.REPLHistoryProvider}, Int64})
precompile(Tuple{typeof(Base.LineEdit.init_state), Base.Terminals.TTYTerminal, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.LineEdit.PrefixSearchState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.LineEdit.PrefixSearchState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Tuple{}, Void}})
precompile(Tuple{typeof(Base.take!), Base.Channel{Any}})
precompile(Tuple{typeof(Base.n_avail), Base.Channel{Any}})
precompile(Tuple{typeof(Base.check_channel_state), Base.Channel{Any}})
precompile(Tuple{typeof(Base.wait_impl), Base.Channel{Any}})
precompile(Tuple{typeof(Base.wait_unbuffered), Base.Channel{Any}})
precompile(Tuple{typeof(Base.wait), Base.Channel{Any}})
precompile(Tuple{typeof(Base.take_unbuffered), Base.Channel{Any}})
precompile(Tuple{typeof(Base.LineEdit.activate), Base.LineEdit.Prompt, Base.LineEdit.MIState, Base.Terminals.TTYTerminal, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.:(==)), Base.LineEdit.Prompt, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.getindex), Base.Dict{Any, Any}, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Any, Any}, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.LineEdit.activate), Base.LineEdit.Prompt, Base.LineEdit.PromptState, Base.Terminals.TTYTerminal, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PromptState})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PromptState})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.displaysize), Base.TTY})
precompile(Tuple{typeof(Base.divrem), Int64, Int64})
precompile(Tuple{typeof(Base.LineEdit.match_input), Base.Dict{Char, Any}, Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.LineEdit.match_input), Base.Dict{Char, Any}, Base.LineEdit.MIState, Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{Char, 1}, Base.Dict{Char, Any}})
precompile(Tuple{typeof(Base.LineEdit.terminal), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.match_input), Base.Dict{Char, Any}, Base.LineEdit.MIState, Base.Terminals.TTYTerminal, Array{Char, 1}, Base.Dict{Char, Any}})
precompile(Tuple{typeof(Base.read), Base.Terminals.TTYTerminal, Type{Char}})
precompile(Tuple{typeof(Base.eof), Base.TTY})
precompile(Tuple{typeof(Base.isreadable), Base.TTY})
precompile(Tuple{typeof(Base.start_reading), Base.TTY})
precompile(Tuple{typeof(Base.wait_readnb), Base.TTY, Int64})
precompile(Tuple{typeof(Base.alloc_buf_hook), Base.TTY, UInt64})
precompile(Tuple{typeof(Base.read), Base.TTY, Type{UInt8}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.deleteat!), Array{UInt8, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.splice!), Array{UInt8, 1}, Base.UnitRange{Int64}, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.LineEdit.splice_buffer!), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.UnitRange{Int64}, String})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.edit_insert), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.LineEdit.edit_insert), Base.LineEdit.PromptState, String})
precompile(Tuple{typeof(Base.Terminals.width), Base.Terminals.TTYTerminal})
precompile(Tuple{Type{Base.Libc.TmStruct}, Float64})
precompile(Tuple{typeof(Base.Libc.strftime), String, Base.Libc.TmStruct})
precompile(Tuple{typeof(Base.replace), String, Base.Regex, String, Int64})
precompile(Tuple{typeof(Base.REPL.mode_idx), Base.REPL.REPLHistoryProvider, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.LineEdit.commit_line), Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.LineEdit.on_enter), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.REPL.return_callback), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TTYTerminal, Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.println), Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.write), Base.Terminals.TTYTerminal, Char})
precompile(Tuple{typeof(Base.write), Base.TTY, UInt8})
precompile(Tuple{typeof(Base.unsafe_write), Base.TTY, Base.RefValue{UInt8}, Int64})
precompile(Tuple{typeof(Base.LineEdit.add_history), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.add_history), Base.REPL.REPLHistoryProvider, Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.start), Base.Pair{Symbol, Any}})
precompile(Tuple{typeof(Base.print), Base.IOStream, String})
precompile(Tuple{typeof(Base.unsafe_write), Base.IOStream, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.flush), Base.IOStream})
precompile(Tuple{typeof(Base.LineEdit.mode), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.REPL.reset), Base.REPL.LineEditREPL})
precompile(Tuple{getfield(Base, Symbol("#kw##parse_input_line")), Array{Any, 1}, typeof(Base.parse_input_line), String})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Tuple{Expr, Int64}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Tuple{Expr, Int64}})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Tuple{Expr, Int64}})
precompile(Tuple{typeof(Base.REPL.eval_user_input), Expr, Base.REPL.REPLBackend})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Tuple{Int64, Void}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Tuple{Int64, Void}})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Tuple{Int64, Void}})
precompile(Tuple{typeof(Base.start), Tuple{Int64, Void}})
precompile(Tuple{typeof(Base.REPL.print_response), Base.REPL.LineEditREPL, Int64, Void, Bool, Bool})
precompile(Tuple{typeof(Base.REPL.print_response), Base.Terminals.TTYTerminal, Int64, Void, Bool, Bool, Void})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, DataType})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, Char})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, String, DataType, String, Char})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, String, Char})
precompile(Tuple{Type{Base.IOContext{Base.Terminals.TTYTerminal}}, Base.Terminals.TTYTerminal, Base.ImmutableDict{Symbol, Any}})
precompile(Tuple{getfield(Base, Symbol("#kw##with_output_color")), Array{Any, 1}, typeof(Base.with_output_color), typeof(Base.print), Symbol, Base.IOContext{Base.Terminals.TTYTerminal}, String})
precompile(Tuple{getfield(Base, Symbol("#kw##with_output_color")), Array{Any, 1}, typeof(Base.with_output_color), typeof(Base.print), Int64, Base.IOContext{Base.Terminals.TTYTerminal}, String})
precompile(Tuple{typeof(Base.write), Base.IOContext{Base.Terminals.TTYTerminal}, Symbol})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.Terminals.TTYTerminal}, Module})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, Module})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.Terminals.TTYTerminal}, Int32})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, Symbol})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, Int32})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.Terminals.TTYTerminal}, Int64})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, Int64})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, Int64, String})
precompile(Tuple{typeof(Base.write), Base.IOContext{Base.Terminals.TTYTerminal}, Char})
precompile(Tuple{typeof(Base.show_circular), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Any, 1}})
precompile(Tuple{typeof(Base.show_delim_array), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Any, 1}, Char, Char, Char, Bool, Int64, Int64})
precompile(Tuple{typeof(Base.join), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Any, 1}, String, String})
precompile(Tuple{typeof(Base.join), Base.IOContext{Base.Terminals.TTYTerminal}, Tuple{}, String, String})
precompile(Tuple{typeof(Base.show_method_params), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Any, 1}})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, Module})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, Symbol, String, Int32})
precompile(Tuple{typeof(Base.show_tuple_as_call), Base.IOContext{Base.Terminals.TTYTerminal}, Symbol, Type})
precompile(Tuple{typeof(Base.print_with_color), Symbol, Base.IOContext{Base.Terminals.TTYTerminal}, String})
precompile(Tuple{typeof(Base.print_with_color), Int64, Base.IOContext{Base.Terminals.TTYTerminal}, String})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.Terminals.TTYTerminal}, Core.MethodInstance})
precompile(Tuple{typeof(Base.StackTraces.show_spec_linfo), Base.IOContext{Base.Terminals.TTYTerminal}, Base.StackTraces.StackFrame})
precompile(Tuple{getfield(Base, Symbol("#kw##show")), Array{Any, 1}, typeof(Base.show), Base.IOContext{Base.Terminals.TTYTerminal}, Base.StackTraces.StackFrame})
precompile(Tuple{getfield(Base, Symbol("#kw##show_trace_entry")), Array{Any, 1}, typeof(Base.show_trace_entry), Base.IOContext{Base.Terminals.TTYTerminal}, Base.StackTraces.StackFrame, Int64})
precompile(Tuple{typeof(Base.show_backtrace), Base.Terminals.TTYTerminal, Array{Ptr{Void}, 1}})
precompile(Tuple{typeof(Base.Multimedia.display), Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Base.MIME{Symbol("text/plain")}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{typeof(Base.Multimedia.display), typeof(Base.show)}})
precompile(Tuple{typeof(Base.Multimedia.display), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Int64})
precompile(Tuple{Type{Base.MIME{Symbol("text/plain")}}})
precompile(Tuple{typeof(Base.Multimedia.display), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Base.MIME{Symbol("text/plain")}, Int64})
precompile(Tuple{typeof(Base.start), Base.Pair{Any, Any}})
precompile(Tuple{typeof(Base.LineEdit.reset_state), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.reset_state), Base.LineEdit.SearchState})
precompile(Tuple{typeof(Base.LineEdit.reset_state), Base.REPL.REPLHistoryProvider})
precompile(Tuple{typeof(Base.LineEdit.reset_state), Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.haskey), Base.Dict{Any, Any}, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.LineEdit.deactivate), Base.LineEdit.Prompt, Base.LineEdit.PromptState, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.activate), Base.LineEdit.Prompt, Base.LineEdit.PromptState, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.commit_changes), Base.Terminals.TTYTerminal, Base.Terminals.TerminalBuffer})
precompile(Tuple{typeof(Base.LineEdit.complete_line), Base.LineEdit.PromptState, Int64})
precompile(Tuple{typeof(Base.LineEdit.input_string_newlines_aftercursor), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.complete_line), Base.REPL.REPLCompletionProvider, Base.LineEdit.PromptState})
precompile(Tuple{getfield(Base, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.parse), String})
precompile(Tuple{typeof(Base.isvalid), Base.RevString{String}, Int64})
precompile(Tuple{typeof(Base.nextind), Base.RevString{String}, Int64})
precompile(Tuple{typeof(Base.search), Base.RevString{String}, Array{Char, 1}, Int64})
precompile(Tuple{typeof(Base.rsearch), String, Array{Char, 1}, Int64})
precompile(Tuple{getfield(Base.REPLCompletions, Symbol("#kw##find_start_brace")), Array{Any, 1}, typeof(Base.REPLCompletions.find_start_brace), String})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Void, Void, Void}})
precompile(Tuple{typeof(Base.isidentifier), Base.SubString{String}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Bool, Void, Void}})
precompile(Tuple{typeof(Base.Filesystem.readdir), String})
precompile(Tuple{typeof(Base.cmp), String, Base.SubString{String}})
precompile(Tuple{typeof(Base.skip_deleted), Base.Dict{String, Void}, Int64})
precompile(Tuple{typeof(Base.PCRE.exec), Ptr{Void}, String, UInt32, UInt32, Ptr{Void}})
precompile(Tuple{typeof(Base.PCRE.exec), Ptr{Void}, String, UInt64, UInt32, Ptr{Void}})
precompile(Tuple{typeof(Base.nextind), String, UInt64})
precompile(Tuple{typeof(Base.matchall), Base.Regex, String, Bool})
precompile(Tuple{typeof(Base.skip_deleted), Base.Dict{String, String}, Int64})
precompile(Tuple{typeof(Base.reverse), String})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Void, Bool}})
precompile(Tuple{typeof(Base._convert), Type{Array{Method, 1}}, Base.BitArray{1}})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Method, 1}, Int64, Array{Method, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.copy!), Array{Method, 1}, Int64, Array{Method, 1}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.PartialTypeVar}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.PartialTypeVar}, Int64})
precompile(Tuple{typeof(Base.show_delim_array), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{Any, 1}, Char, Char, Char, Bool, Int64, Int64})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{Any, 1}, String, String})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Tuple{}, String, String})
precompile(Tuple{typeof(Base.show_method_params), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{Any, 1}})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Module})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Symbol, String, Int32})
precompile(Tuple{typeof(Base.reverseind), String, Int64})
precompile(Tuple{typeof(Base.Pkg.Dir.path)})
precompile(Tuple{typeof(Base.promote_type), Type{String}, Type{Union{}}})
precompile(Tuple{typeof(Base.promote_type), Type{Any}, Type{String}})
precompile(Tuple{typeof(Base.promote_rule), Type{Any}, Type{String}})
precompile(Tuple{typeof(Base.promote_rule), Type{String}, Type{Any}})
precompile(Tuple{typeof(Base.promote_result), Type{Any}, Type{String}, Type{Union{}}, Type{Union{}}})
precompile(Tuple{typeof(Base.promote_type), Type{String}, Type{Any}})
precompile(Tuple{typeof(Base.promote_result), Type{String}, Type{Any}, Type{Union{}}, Type{Union{}}})
precompile(Tuple{typeof(Base.cat_indices), String, Int64})
precompile(Tuple{typeof(Base.cat_size), String, Int64})
precompile(Tuple{typeof(Base.setindex!), Array{Any, 1}, String, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base._cat), Array{Any, 1}, Tuple{Int64}, Tuple{Bool}, String, Array{Any, 1}, String})
precompile(Tuple{typeof(Base.cat_t), Type{Base.Val{1}}, Type{Any}, String, Array{Any, 1}, String})
precompile(Tuple{typeof(Base.Sort.searchsortedfirst), Array{String, 1}, String, Int64, Int64, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.searchsortedlast), Array{String, 1}, String, Int64, Int64, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.searchsorted), Array{String, 1}, String, Int64, Int64, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.searchsorted), Array{String, 1}, String, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.throw_boundserror), Array{String, 1}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Core.Inference.precise_container_type), String, Core.Inference.Const, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Base._rsearchindex), String, String, Int64})
precompile(Tuple{typeof(Base.deleteat!), Array{Symbol, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.copy!), Array{String, 1}, Base.Generator{Array{Symbol, 1}, typeof(Base.string)}})
precompile(Tuple{typeof(Base.deleteat!), Array{String, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{String, Void}, String})
precompile(Tuple{typeof(Base.push!), Base.Set{String}, String})
precompile(Tuple{typeof(Base.isstructtype), DataType})
precompile(Tuple{typeof(Base.start), Array{Int64, 1}})
precompile(Tuple{typeof(Base.to_tuple_type), Type{Tuple}})
precompile(Tuple{typeof(Base.append!), Array{Any, 1}, Array{Any, 1}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{DataType, Bool}})
precompile(Tuple{typeof(Base.is_default_method), Method})
precompile(Tuple{getfield(Base, Symbol("#kw##show")), Array{Any, 1}, typeof(Base.show), Base.AbstractIOBuffer{Array{UInt8, 1}}, Method})
precompile(Tuple{typeof(Base.sort!), Array{String, 1}})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{String, Void}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{String, Void}, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{String, Void}, Void, String, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{String, Void}, Void, String})
precompile(Tuple{typeof(Base.Filesystem.realpath), Base.SubString{String}})
precompile(Tuple{typeof(Base.Filesystem.readdir), Base.SubString{String}})
precompile(Tuple{typeof(Base.REPLCompletions.dict_identifier_key), String, Symbol})
precompile(Tuple{typeof(Base.Filesystem.expanduser), String})
precompile(Tuple{typeof(Base.REPLCompletions.bslash_completions), String, Int64})
precompile(Tuple{typeof(Base.REPLCompletions.should_method_complete), String})
precompile(Tuple{typeof(Base.REPLCompletions.afterusing), String, Int64})
precompile(Tuple{typeof(Base.REPLCompletions.complete_keyword), String})
precompile(Tuple{typeof(Base.in), Char, Array{Any, 1}})
precompile(Tuple{typeof(Base.string), Char, Char})
precompile(Tuple{typeof(Base.unique), Array{String, 1}})
precompile(Tuple{typeof(Base.REPL.beforecursor), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.REPLCompletions.completions), String, Int64})
precompile(Tuple{typeof(Base.incomplete_tag), Symbol})
precompile(Tuple{typeof(Base.rsearchindex), String, String, Int64})
precompile(Tuple{typeof(Base._rsearch), String, String, Int64})
precompile(Tuple{typeof(Base.unshift!), Array{Base.SubString{String}, 1}, Base.SubString{String}})
precompile(Tuple{typeof(Base.startswith), String, Base.SubString{String}})
precompile(Tuple{typeof(Base.rsearch), String, Array{Char, 1}})
precompile(Tuple{getfield(Base, Symbol("#kw##rsplit")), Array{Any, 1}, typeof(Base.rsplit), String, String})
precompile(Tuple{typeof(Base.sort!), Array{String, 1}, Base.Sort.MergeSortAlg, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.sort!), Array{String, 1}, Int64, Int64, Base.Sort.InsertionSortAlg, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.sort!), Array{String, 1}, Int64, Int64, Base.Sort.MergeSortAlg, Base.Order.ForwardOrdering, Array{String, 1}})
precompile(Tuple{typeof(Base.start), Tuple{Array{String, 1}, String, Bool}})
precompile(Tuple{typeof(Base.indexed_next), Tuple{Array{String, 1}, String, Bool}, Int64, Int64})
precompile(Tuple{typeof(Base.LineEdit.common_prefix), Array{String, 1}})
precompile(Tuple{typeof(Base.LineEdit.show_completions), Base.LineEdit.PromptState, Array{String, 1}})
precompile(Tuple{typeof(Base.collect_to!), Array{Int64, 1}, Base.Generator{Array{String, 1}, typeof(Base.length)}, Int64, Int64})
precompile(Tuple{typeof(Base._collect), Array{String, 1}, Base.Generator{Array{String, 1}, typeof(Base.length)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.mapreduce_impl), typeof(Base.identity), typeof(Base.scalarmax), Array{Int64, 1}, Int64, Int64})
precompile(Tuple{typeof(Base._mapreduce), typeof(Base.identity), typeof(Base.scalarmax), Base.IndexLinear, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Terminals.cmove_down), Base.Terminals.TTYTerminal, Int64})
precompile(Tuple{typeof(Base.Terminals.cmove_col), Base.Terminals.TTYTerminal, Int64})
precompile(Tuple{typeof(Base.Terminals.cmove_right), Base.Terminals.TTYTerminal, Int64})
precompile(Tuple{typeof(Base.write), Base.TTY, Char})
precompile(Tuple{typeof(Base.LineEdit.match_input), Base.LineEdit.KeyAlias, Base.LineEdit.MIState, Base.Terminals.TTYTerminal, Array{Char, 1}, Base.Dict{Char, Any}})
precompile(Tuple{typeof(Base.peek), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.char_move_left), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_backspace), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_backspace), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.Terminals.beep), Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.edit_move_down), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, DataType}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, DataType}, Int64})
precompile(Tuple{typeof(Base.LineEdit.replace_line), Base.LineEdit.PrefixSearchState, String})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.copy), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.REPL.history_move), Base.LineEdit.PrefixSearchState, Base.REPL.REPLHistoryProvider, Int64, Int64})
precompile(Tuple{typeof(Base.LineEdit.edit_move_down), Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.LineEdit.enter_prefix_search), Base.LineEdit.MIState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}, Bool})
precompile(Tuple{typeof(Base.haskey), Base.Dict{Any, Any}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Any, Any}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.getindex), Base.Dict{Any, Any}, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.LineEdit.copybuf!), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.activate), Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}, Base.LineEdit.PrefixSearchState, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.LineEdit.history_next_prefix), Base.LineEdit.PrefixSearchState, Base.REPL.REPLHistoryProvider, String})
precompile(Tuple{typeof(Base.REPL.history_move_prefix), Base.LineEdit.PrefixSearchState, Base.REPL.REPLHistoryProvider, String, Bool, Int64})
precompile(Tuple{typeof(Base.LineEdit.keymap), Base.LineEdit.PrefixSearchState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.LineEdit.terminal), Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.LineEdit.keymap_data), Base.LineEdit.PrefixSearchState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Base.LineEdit.history_prev_prefix), Base.LineEdit.PrefixSearchState, Base.REPL.REPLHistoryProvider, String})
precompile(Tuple{typeof(Base.getindex), Base.Dict{Symbol, Any}, Symbol})
precompile(Tuple{typeof(Base.LineEdit.transition), Base.LineEdit.MIState, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.LineEdit.deactivate), Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}, Base.LineEdit.PrefixSearchState, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TTYTerminal, Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PrefixSearchState})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PrefixSearchState})
precompile(Tuple{getfield(Base.LineEdit, Symbol("#kw##refresh_multi_line")), Array{Any, 1}, typeof(Base.LineEdit.refresh_multi_line), Base.Terminals.TerminalBuffer, Base.Terminals.TTYTerminal, Base.LineEdit.PrefixSearchState})
precompile(Tuple{typeof(Base.LineEdit.replace_line), Base.LineEdit.PrefixSearchState, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.accept_result), Base.LineEdit.MIState, Base.LineEdit.PrefixHistoryPrompt{Base.REPL.REPLHistoryProvider}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, Core.Inference.Const, DataType}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, Core.Inference.Const, DataType}, Int64})
precompile(Tuple{typeof(Base.LineEdit.replace_line), Base.LineEdit.PromptState, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.match_input), Base.Dict{Char, Any}, Base.LineEdit.MIState, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_move_left), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_move_left), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.edit_move_right), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_move_right), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.move_line_start), Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.LineEdit.move_line_end), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.move_line_end), Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.LineEdit.edit_move_up), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.LineEdit.edit_move_up), Base.LineEdit.MIState})
precompile(Tuple{typeof(Base.:(==)), Symbol, Base.LineEdit.Prompt})
precompile(Tuple{typeof(Base.isempty), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.LineEdit.default_enter_cb), Base.LineEdit.PromptState})
precompile(Tuple{typeof(Base.Docs.helpmode), String})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Symbol, Base.Docs.DocStr}, Symbol})
precompile(Tuple{typeof(Base.Docs.helpmode), Base.TTY, String})
precompile(Tuple{getfield(Base.Docs, Symbol("#@repl")), Base.TTY, Symbol})
precompile(Tuple{typeof(Base.Docs.repl), Base.TTY, Symbol})
precompile(Tuple{typeof(Base.Docs._repl), Symbol})
precompile(Tuple{getfield(Core, Symbol("#@doc")), Symbol})
precompile(Tuple{typeof(Base.Docs.docm), Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.Markdown.Config, Symbol, Int64})
precompile(Tuple{Type{Base.Markdown.MD}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.Markdown.Config, Symbol})
precompile(Tuple{typeof(Base.Markdown.skipblank), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.vcat), Array{Function, 1}, Array{Function, 1}})
precompile(Tuple{typeof(Base.Docs.formatdoc), Base.Docs.DocStr})
precompile(Tuple{typeof(Base.Docs.parsedoc), Base.Docs.DocStr})
precompile(Tuple{typeof(Base.Docs.repl_latex), Base.TTY, String})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{String, String}, String})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Symbol, Tuple{String, String}}, Symbol})
precompile(Tuple{typeof(Base.print), Base.TTY, Char, Char})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{String, String}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{String, String}, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{String, String}, String, String, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Dict{String, String}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{String, String}, String, String})
precompile(Tuple{typeof(Base.Docs.symbol_latex), String})
precompile(Tuple{typeof(Base.Docs.repl_search), Base.TTY, String})
precompile(Tuple{typeof(Base.print), Base.TTY, String})
precompile(Tuple{typeof(Base.print), Base.TTY, Char})
precompile(Tuple{typeof(Base.print), Base.TTY, String, Char})
precompile(Tuple{typeof(Base.mapreduce_impl), typeof(Base.identity), typeof(Base.:(+)), Array{Int64, 1}, Int64, Int64, Int64})
precompile(Tuple{typeof(Base._mapreduce), typeof(Base.identity), typeof(Base.:(+)), Base.IndexLinear, Array{Int64, 1}})
precompile(Tuple{typeof(Base.shift!), Array{Char, 1}})
precompile(Tuple{typeof(Base.Docs.avgdistance), Array{Int64, 1}})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Array{String, 1}}})
precompile(Tuple{typeof(Base.Docs.accessible), Module})
precompile(Tuple{Type{Base.Generator{I, F} where F where I}, typeof(Base.names), Array{Any, 1}})
precompile(Tuple{typeof(Base.iteratoreltype), Type{Base.Generator{Array{Any, 1}, typeof(Base.names)}}})
precompile(Tuple{typeof(Base.iteratorsize), Type{Base.Generator{Array{Any, 1}, typeof(Base.names)}}})
precompile(Tuple{typeof(Base._collect), Array{Any, 1}, Base.Generator{Array{Any, 1}, typeof(Base.names)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.collect_to!), Array{Array{Symbol, 1}, 1}, Base.Generator{Array{Any, 1}, typeof(Base.names)}, Int64, Int64})
precompile(Tuple{typeof(Base.names), Module})
precompile(Tuple{typeof(Base.vcat), Array{Symbol, 1}, Array{Symbol, 1}, Array{Symbol, 1}, Array{String, 1}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{Symbol, 2}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Symbol, 2}, Int64, Array{Symbol, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.promote_eltype), Array{Symbol, 1}, Array{Symbol, 1}, Array{Symbol, 1}, Array{String, 1}})
precompile(Tuple{typeof(Base.promote_eltype), Array{Symbol, 1}, Array{String, 1}})
precompile(Tuple{typeof(Base.promote_eltype), Array{String, 1}})
precompile(Tuple{typeof(Base.promote_type), Type{Symbol}, Type{String}})
precompile(Tuple{typeof(Base.promote_rule), Type{Symbol}, Type{String}})
precompile(Tuple{typeof(Base.promote_rule), Type{String}, Type{Symbol}})
precompile(Tuple{typeof(Base.promote_result), Type{Symbol}, Type{String}, Type{Union{}}, Type{Union{}}})
precompile(Tuple{typeof(Base.typed_vcat), Type{Any}, Array{Symbol, 1}, Array{Symbol, 1}, Array{Symbol, 1}, Array{String, 1}})
precompile(Tuple{typeof(Base.setindex!), Array{Any, 1}, Array{Symbol, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.setindex!), Array{Any, 1}, Array{String, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.throw_setindex_mismatch), Array{String, 1}, Tuple{Int64}})
precompile(Tuple{typeof(Base.setindex_shape_check), Array{String, 1}, Int64})
precompile(Tuple{typeof(Base.unique), Array{Any, 1}})
precompile(Tuple{typeof(Base.getindex), Type{Symbol}, Symbol})
precompile(Tuple{Type{Base.Set{Symbol}}, Tuple{Symbol}})
precompile(Tuple{typeof(Base.union!), Base.Set{Symbol}, Tuple{Symbol}})
precompile(Tuple{typeof(Base.unique_from), Array{Any, 1}, Array{Symbol, 1}, Base.Set{Symbol}, Int64})
precompile(Tuple{typeof(Base.convert), Type{Base.Set{Any}}, Base.Set{Symbol}})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Void}, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Void}, Void, Symbol, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Void}, Void, Symbol})
precompile(Tuple{typeof(Base.union!), Base.Set{Any}, Base.Set{Symbol}})
precompile(Tuple{typeof(Base.convert), Type{Array{Any, 1}}, Array{Symbol, 1}})
precompile(Tuple{typeof(Base.copy!), Base.IndexLinear, Array{Any, 1}, Base.IndexLinear, Array{Symbol, 1}})
precompile(Tuple{typeof(Base.:(==)), String, Symbol})
precompile(Tuple{typeof(Base.unique_from), Array{Any, 1}, Array{Any, 1}, Base.Set{Any}, Int64})
precompile(Tuple{Type{Base.Generator{I, F} where F where I}, typeof(Base.string), Array{Any, 1}})
precompile(Tuple{typeof(Base.iteratoreltype), Type{Base.Generator{Array{Any, 1}, typeof(Base.string)}}})
precompile(Tuple{typeof(Base.iteratorsize), Type{Base.Generator{Array{Any, 1}, typeof(Base.string)}}})
precompile(Tuple{typeof(Base._collect), Array{Any, 1}, Base.Generator{Array{Any, 1}, typeof(Base.string)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.similar), Array{Any, 1}, Type{String}, Tuple{Base.OneTo{Int64}}})
precompile(Tuple{typeof(Base.collect_to!), Array{String, 1}, Base.Generator{Array{Any, 1}, typeof(Base.string)}, Int64, Int64})
precompile(Tuple{typeof(Base.UTF8proc.isalpha), Char})
precompile(Tuple{getfield(Base.Docs, Symbol("#kw##matchinds")), Array{Any, 1}, typeof(Base.Docs.matchinds), String, String})
precompile(Tuple{typeof(Base.Docs.bestmatch), String, String})
precompile(Tuple{typeof(Base.length), Tuple{DataType, DataType}})
precompile(Tuple{Type{BoundsError}, Array{Int64, 2}, Tuple{Base.UnitRange{Int64}, Int64}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{Int64, 2}, Tuple{Base.UnitRange{Int64}, Int64}})
precompile(Tuple{getfield(Base.Cartesian, Symbol("#@nexprs")), Int64, Expr})
precompile(Tuple{typeof(Base.Cartesian._nexprs), Int64, Expr})
precompile(Tuple{typeof(Core.Inference.findnext), Array{Function, 1}, typeof(===), Int64})
precompile(Tuple{typeof(Core.Inference.builtin_tfunction), typeof(===), Array{Any, 1}, Core.Inference.InferenceState, Core.Inference.InferenceParams})
precompile(Tuple{typeof(Core.Inference.typeinf_frame), Core.MethodInstance, Bool, Bool, Core.Inference.InferenceParams})
precompile(Tuple{typeof(Core.Inference.typeinf), Core.Inference.InferenceState})
precompile(Tuple{typeof(Base.Cartesian.inlineanonymous), Expr, Int64})
precompile(Tuple{typeof(Base.Cartesian.lreplace), Expr, Symbol, Int64})
precompile(Tuple{typeof(Base.copy), Expr})
precompile(Tuple{typeof(Base.copy_exprargs), Array{Any, 1}})
precompile(Tuple{typeof(Base.collect), Type{Any}, Base.Generator{Array{Any, 1}, typeof(Base.copy_exprs)}})
precompile(Tuple{typeof(Base._collect), Type{Any}, Base.Generator{Array{Any, 1}, typeof(Base.copy_exprs)}, Base.HasShape})
precompile(Tuple{typeof(Base.copy!), Array{Any, 1}, Base.Generator{Array{Any, 1}, typeof(Base.copy_exprs)}})
precompile(Tuple{typeof(Base.next), Base.Generator{Array{Any, 1}, typeof(Base.copy_exprs)}, Int64})
precompile(Tuple{typeof(Base.copy_exprs), Expr})
precompile(Tuple{typeof(Base.Cartesian.lreplace!), Expr, Base.Cartesian.LReplace{String}})
precompile(Tuple{typeof(Base.Cartesian.lreplace!), Symbol, Base.Cartesian.LReplace{String}})
precompile(Tuple{typeof(Base.Cartesian.lreplace!), String, Base.Cartesian.LReplace{String}})
precompile(Tuple{typeof(Base.Cartesian.exprresolve), Expr})
precompile(Tuple{Type{BoundsError}, Array{Expr, 1}, Base.UnitRange{Int64}})
precompile(Tuple{getfield(Base.Cartesian, Symbol("#@ncall")), Int64, Symbol, Symbol})
precompile(Tuple{typeof(Base.Cartesian._ncall), Int64, Symbol, Symbol})
precompile(Tuple{typeof(Base.getindex), Tuple{Symbol}, Base.UnitRange{Int64}})
precompile(Tuple{getfield(Base.Cartesian, Symbol("#@ncall")), Int64, Symbol, Symbol, Expr})
precompile(Tuple{typeof(Base.Cartesian._ncall), Int64, Symbol, Symbol, Expr})
precompile(Tuple{typeof(Base.endof), Tuple{Symbol, Expr}})
precompile(Tuple{typeof(Base.getindex), Tuple{Symbol, Expr}, Base.UnitRange{Int64}})
precompile(Tuple{getfield(Base.Cartesian, Symbol("#@nloops")), Int64, Symbol, Expr, Expr})
precompile(Tuple{typeof(Base.Cartesian._nloops), Int64, Symbol, Expr, Expr})
precompile(Tuple{typeof(Base.endof), Tuple{Expr}})
precompile(Tuple{typeof(Base.endof), Tuple{Symbol, Symbol, Symbol}})
precompile(Tuple{typeof(Base.getindex), Tuple{Symbol, Symbol, Symbol}, Base.UnitRange{Int64}})
precompile(Tuple{Type{Expr}, Symbol, Symbol, Symbol, Symbol, Symbol, Symbol})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Tuple{String, String}, Char})
precompile(Tuple{typeof(Base.dims2string), Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.throw_setindex_mismatch), Base.UnitRange{Int64}, Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.setindex_shape_check), Base.UnitRange{Int64}, Int64, Int64})
precompile(Tuple{typeof(Base._unsafe_setindex!), Base.IndexLinear, Array{Int64, 2}, Base.UnitRange{Int64}, Base.UnitRange{Int64}, Int64})
precompile(Tuple{Type{BoundsError}, Array{Int64, 2}, Tuple{Int64, Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{Int64, 2}, Tuple{Int64, Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base._unsafe_setindex!), Base.IndexLinear, Array{Int64, 2}, Base.UnitRange{Int64}, Int64, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.Docs.levenshtein), String, String})
precompile(Tuple{typeof(Base.Docs.fuzzyscore), String, String})
precompile(Tuple{typeof(Core.Inference.copy_exprargs), Array{Any, 1}})
precompile(Tuple{typeof(Core.Inference.copy), Expr})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Array{Any, 1}, typeof(Core.Inference.copy_exprs)}})
precompile(Tuple{typeof(Core.Inference._widen_all_consts!), Expr, Array{Bool, 1}})
precompile(Tuple{typeof(Core.Inference._delete!), Core.Inference.IntSet, Int64})
precompile(Tuple{typeof(Core.Inference.promote_type), Type{Float16}, Type{Int64}})
precompile(Tuple{typeof(Core.Inference.mk_tuplecall), Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.inlining_pass), Expr, Core.Inference.InferenceState, Array{Any, 1}, Int64})
precompile(Tuple{typeof(Core.Inference.annotate_slot_load!), Expr, Array{Any, 1}, Core.Inference.InferenceState, Array{Bool, 1}})
precompile(Tuple{typeof(Core.Inference.record_slot_assign!), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.type_annotate!), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.inlining_pass!), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.alloc_elim_pass!), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.getfield_elim_pass!), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.popmeta!), Array{Any, 1}, Symbol})
precompile(Tuple{typeof(Core.Inference.widen_all_consts!), CodeInfo})
precompile(Tuple{typeof(Core.Inference.stupdate!), Array{Any, 1}, Array{Any, 1}})
precompile(Tuple{typeof(Core.Inference.push!), Core.Inference.IntSet, Int64})
precompile(Tuple{typeof(Core.Inference.abstract_eval_call), Expr, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.return_type_tfunc), Array{Any, 1}, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.abstract_call), typeof(===), Tuple{}, Array{Any, 1}, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.abstract_call), typeof(===), Array{Any, 1}, Array{Any, 1}, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.type_too_complex), TypeVar, Int64})
precompile(Tuple{typeof(Core.Inference.abstract_eval), Expr, Array{Any, 1}, Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference._setint!), Core.Inference.IntSet, Int64, Bool})
precompile(Tuple{typeof(Core.Inference.stupdate1!), Array{Any, 1}, Core.Inference.StateUpdate})
precompile(Tuple{typeof(Core.Inference.optimize), Core.Inference.InferenceState})
precompile(Tuple{typeof(Core.Inference.deleteat!), Core.Inference.BitArray{1}, Core.Inference.UnitRange{Int64}})
precompile(Tuple{typeof(Core.Inference.resize!), Core.Inference.BitArray{1}, Int64})
precompile(Tuple{typeof(Core.Inference.copy_chunks!), Array{UInt64, 1}, Int64, Array{UInt64, 1}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.copy_chunks_rtol!), Array{UInt64, 1}, Int64, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.find_ssavalue_uses), Array{Any, 1}})
precompile(Tuple{typeof(Base.sortperm), Array{Tuple{Float64, Int64}, 1}})
precompile(Tuple{Type{Base.Order.Perm{O, V} where V<:(AbstractArray{T, 1} where T) where O<:Base.Order.Ordering}, Base.Order.ForwardOrdering, Array{Tuple{Float64, Int64}, 1}})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}, Base.Sort.QuickSortAlg, Base.Order.Perm{Base.Order.ForwardOrdering, Array{Tuple{Float64, Int64}, 1}}})
precompile(Tuple{typeof(Base.isequal), Float64, Float64})
precompile(Tuple{typeof(Base.isequal), Int64, Float64})
precompile(Tuple{typeof(Base.isequal), Float64, Int64})
precompile(Tuple{typeof(Base.isless), Int64, Float64})
precompile(Tuple{typeof(Base.isless), Float64, Int64})
precompile(Tuple{typeof(Base.isless), Tuple{Float64, Int64}, Tuple{Float64, Int64}})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}, Int64, Int64, Base.Sort.InsertionSortAlg, Base.Order.Perm{Base.Order.ForwardOrdering, Array{Tuple{Float64, Int64}, 1}}})
precompile(Tuple{typeof(Base.Sort.partition!), Array{Int64, 1}, Int64, Int64, Base.Order.Perm{Base.Order.ForwardOrdering, Array{Tuple{Float64, Int64}, 1}}})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}, Int64, Int64, Base.Sort.QuickSortAlg, Base.Order.Perm{Base.Order.ForwardOrdering, Array{Tuple{Float64, Int64}, 1}}})
precompile(Tuple{typeof(Base.getindex), Array{String, 1}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{String, 1}, Tuple{Array{Int64, 1}}})
precompile(Tuple{typeof(Base.throw_checksize_error), Array{String, 1}, Tuple{Base.OneTo{Int64}}})
precompile(Tuple{typeof(Base._unsafe_getindex), Base.IndexLinear, Array{String, 1}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.reverse), Array{String, 1}})
precompile(Tuple{typeof(Base.reverse), Array{String, 1}, Int64, Int64})
precompile(Tuple{getfield(Base.Docs, Symbol("#kw##printmatches")), Array{Any, 1}, typeof(Base.Docs.printmatches), Base.TTY, String, Array{String, 1}})
precompile(Tuple{typeof(Base.Docs.printmatch), Base.TTY, String, String})
precompile(Tuple{typeof(Base.Markdown.with_output_format), typeof(Base.print), Array{Symbol, 1}, Base.TTY, Char})
precompile(Tuple{typeof(Base.Docs.doc), Base.Docs.Binding})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Base.Docs.Binding, String, String, String, Char})
precompile(Tuple{typeof(Base.show_method_table), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.MethodList, Int64, Bool})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.MethodList})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Base.MethodList, String, Char})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, String, DataType, String, DataType, Char})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, DataType, Char})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, typeof(Type), Char})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Module, String, Char})
precompile(Tuple{typeof(Base.Pkg.dir), String, String})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Array{Base.Docs.DocStr, 1}, Symbol, Int64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.Docs.Binding, Symbol, Int64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Type{Union{}}, Symbol, Int64})
precompile(Tuple{typeof(Base._collect), Array{Base.Docs.DocStr, 1}, Base.Generator{Array{Base.Docs.DocStr, 1}, typeof(Base.Docs.parsedoc)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Union{DataType, typeof(Type)}, Void}, typeof(Type)})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Union{DataType, typeof(Type)}, Void}, Void, typeof(Type), Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Union{DataType, typeof(Type)}, Void}, DataType})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Union{DataType, typeof(Type)}, Void}, Void, DataType, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Union{DataType, typeof(Type)}, Void}, Void, DataType})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Union{DataType, typeof(Type)}, Void}, Void, typeof(Type)})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Union{DataType, typeof(Type)}, Void}, Int64})
precompile(Tuple{typeof(Base._subtypes), Module, DataType, Base.Set{Union{DataType, typeof(Type)}}, Base.Set{Module}})
precompile(Tuple{typeof(Base._subtypes), Module, DataType})
precompile(Tuple{typeof(Base.isempty), Array{Int64, 1}})
precompile(Tuple{typeof(Base.Iterators.zip), Array{Int64, 1}, SimpleVector})
precompile(Tuple{typeof(Base.Iterators.zip), Array{Symbol, 1}, SimpleVector})
precompile(Tuple{typeof(Base.start), Base.Iterators.Zip2{Array{Int64, 1}, SimpleVector}})
precompile(Tuple{typeof(Base.start), Base.Iterators.Zip2{Array{Symbol, 1}, SimpleVector}})
precompile(Tuple{typeof(Base.done), Base.Iterators.Zip2{Array{Int64, 1}, SimpleVector}, Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.done), Base.Iterators.Zip2{Array{Symbol, 1}, SimpleVector}, Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.next), Base.Iterators.Zip2{Array{Int64, 1}, SimpleVector}, Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.next), Base.Iterators.Zip2{Array{Symbol, 1}, SimpleVector}, Tuple{Int64, Int64}})
precompile(Tuple{typeof(Base.println), Base.AbstractIOBuffer{Array{UInt8, 1}}, DataType})
precompile(Tuple{typeof(Base.println), Base.AbstractIOBuffer{Array{UInt8, 1}}, typeof(Type)})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Array{Base.Docs.DocStr, 1}, Symbol})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.Docs.Binding, Symbol})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Type{Union{}}, Symbol})
precompile(Tuple{typeof(Base.Docs.aliasof), Base.Docs.Binding})
precompile(Tuple{typeof(Base.Docs.summarize), Base.Docs.Binding, Type{Union{}}})
precompile(Tuple{typeof(Base.Docs.doc), Base.Docs.Binding, Type{Union{}}})
precompile(Tuple{typeof(Base.haskey), Base.ObjectIdDict, Base.Docs.Binding})
precompile(Tuple{typeof(Base.getindex), Base.ObjectIdDict, Base.Docs.Binding})
precompile(Tuple{typeof(Base.push!), Array{Base.Docs.MultiDoc, 1}, Base.Docs.MultiDoc})
precompile(Tuple{typeof(Base.start), Array{Type{T} where T, 1}})
precompile(Tuple{typeof(Base.done), Array{Type{T} where T, 1}, Int64})
precompile(Tuple{typeof(Base.next), Array{Type{T} where T, 1}, Int64})
precompile(Tuple{typeof(Base.getindex), Base.ObjectIdDict, Type{Tuple{Any}}})
precompile(Tuple{typeof(Base.push!), Array{Base.Docs.DocStr, 1}, Base.Docs.DocStr})
precompile(Tuple{typeof(Base.Docs.formatdoc), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Docs.DocStr, String})
precompile(Tuple{typeof(Base.Markdown.hashheader), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.parseinline), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD, Array{Function, 1}})
precompile(Tuple{typeof(Base.Markdown.config), Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.parseinline), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD, Base.Markdown.Config})
precompile(Tuple{typeof(Base.Markdown.list), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.searchindex), String, String})
precompile(Tuple{typeof(Base._searchindex), Base.SubString{String}, String, Int64})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##skipwhitespace")), Array{Any, 1}, typeof(Base.Markdown.skipwhitespace), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Symbol, Base.Markdown.Config}, Symbol})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.Markdown.parse), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##startswith")), Array{Any, 1}, typeof(Base.Markdown.startswith), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Regex})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Int64, Base.Regex}})
precompile(Tuple{typeof(Base.contains), String, String})
precompile(Tuple{typeof(Base.contains), Base.SubString{String}, String})
precompile(Tuple{typeof(Base.Markdown.pushitem!), Base.Markdown.List, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.Markdown.fencedcode), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##startswith")), Array{Any, 1}, typeof(Base.Markdown.startswith), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.skip), Base.AbstractIOBuffer{Array{UInt8, 1}}, Int64})
precompile(Tuple{typeof(Base.lstrip), String, Char})
precompile(Tuple{typeof(Base.Markdown.blockquote), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.Markdown.parse), String})
precompile(Tuple{typeof(Base.Markdown.admonition), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.UTF8proc.isupper), Char})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##linecontains")), Array{Any, 1}, typeof(Base.Markdown.linecontains), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.ucfirst), Base.SubString{String}})
precompile(Tuple{typeof(Base.Markdown.blocktex), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Core.Inference.length), Tuple{DataType, Core.Inference.Const, DataType}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{DataType, Core.Inference.Const, DataType}, Int64})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##parse_inline_wrapper")), Array{Any, 1}, typeof(Base.Markdown.parse_inline_wrapper), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.Markdown.startswith), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.Markdown.blockinterp), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{getfield(Base, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.parse), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.Markdown.interpinner), Base.AbstractIOBuffer{Array{UInt8, 1}}, Bool})
precompile(Tuple{typeof(Base.Markdown.indentcode), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.footnote), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{Type{Base.Markdown.Footnote}, Void, Array{Any, 1}})
precompile(Tuple{Type{Base.Markdown.Footnote}, Base.SubString{String}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Markdown.github_table), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.replace), String, String, String, Int64})
precompile(Tuple{typeof(Base.pop!), Array{Base.SubString{String}, 1}})
precompile(Tuple{typeof(Base.union!), Base.Set{Char}, String})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Char, Void}, Char})
precompile(Tuple{typeof(Base.issubset), Base.SubString{String}, Base.Set{Char}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, Core.Inference.Const, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.throw_boundserror), Base.SubArray{UInt8, 1, Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}, true}, Tuple{Int64}})
precompile(Tuple{typeof(Base.peek), Base.AbstractIOBuffer{Base.SubArray{UInt8, 1, Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}, true}}})
precompile(Tuple{typeof(Base.Markdown.parseinline), Base.AbstractIOBuffer{Base.SubArray{UInt8, 1, Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}, true}}, Base.Markdown.MD, Array{Function, 1}})
precompile(Tuple{typeof(Base.read), Base.AbstractIOBuffer{Base.SubArray{UInt8, 1, Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}, true}}, Type{Char}})
precompile(Tuple{typeof(Base.Markdown.parseinline), Base.AbstractIOBuffer{Base.SubArray{UInt8, 1, Array{UInt8, 1}, Tuple{Base.UnitRange{Int64}}, true}}, Base.Markdown.MD, Base.Markdown.Config})
precompile(Tuple{typeof(Base.copy!), Base.IndexLinear, Array{Array{Any, 1}, 1}, Base.IndexLinear, Array{Any, 1}})
precompile(Tuple{typeof(Base.Markdown.parsealign), Void})
precompile(Tuple{typeof(Base.Markdown.parsealign), Array{Base.SubString{String}, 1}})
precompile(Tuple{typeof(Base.Markdown.rowlength!), Void, Int64})
precompile(Tuple{typeof(Base.Markdown.rowlength!), Array{Base.SubString{String}, 1}, Int64})
precompile(Tuple{Type{Base.Markdown.Table}, Array{Any, 1}, Void})
precompile(Tuple{Type{Base.Markdown.Table}, Array{Any, 1}, Array{Symbol, 1}})
precompile(Tuple{typeof(Base.Markdown.horizontalrule), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Core.Inference.isbits), Base.Markdown.HorizontalRule})
precompile(Tuple{typeof(Base.Markdown.setextheader), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.paragraph), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.Markdown.parse), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD, Base.Markdown.Config})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##parse")), Array{Any, 1}, typeof(Base.Markdown.parse), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.inline_code), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.Markdown.readuntil), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.Markdown.readuntil), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.SubString{String}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Module, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Module, Symbol, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, String, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, String, Symbol, Int64})
precompile(Tuple{typeof(Base.similar), Array{Base.Docs.DocStr, 1}, Type{Base.Markdown.MD}, Tuple{Base.OneTo{Int64}}})
precompile(Tuple{typeof(Base.setindex!), Array{Base.Markdown.MD, 1}, Base.Markdown.MD, Int64})
precompile(Tuple{typeof(Base.collect_to!), Array{Base.Markdown.MD, 1}, Base.Generator{Array{Base.Docs.DocStr, 1}, typeof(Base.Docs.parsedoc)}, Int64, Int64})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Base.Markdown.MD, 1}, Int64, Array{Base.Markdown.MD, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.Docs.catdoc), Base.Markdown.MD})
precompile(Tuple{typeof(Base.copy!), Base.IndexLinear, Array{Any, 1}, Base.IndexLinear, Array{Base.Markdown.MD, 1}})
precompile(Tuple{Type{Base.Markdown.MD}, Array{Base.Markdown.MD, 1}})
precompile(Tuple{Type{Base.Markdown.MD}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.vcat), Base.Markdown.MD})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Tuple{Base.Markdown.MD, Void}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Tuple{Base.Markdown.MD, Void}})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Tuple{Base.Markdown.MD, Void}})
precompile(Tuple{typeof(Base.start), Tuple{Base.Markdown.MD, Void}})
precompile(Tuple{typeof(Base.indexed_next), Tuple{Base.Markdown.MD, Void}, Int64, Int64})
precompile(Tuple{typeof(Base.Multimedia.display), Base.Markdown.MD})
precompile(Tuple{typeof(Base.Multimedia.display), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Base.Markdown.MD})
precompile(Tuple{typeof(Base.displaysize), Base.Terminals.TTYTerminal})
precompile(Tuple{typeof(Base.Markdown.term), Base.Terminals.TTYTerminal, Array{Any, 1}, Int64})
precompile(Tuple{typeof(Base.Markdown.term), Base.Terminals.TTYTerminal, Base.Markdown.MD, Int64})
precompile(Tuple{typeof(Base.Markdown.term), Base.Terminals.TTYTerminal, Base.Markdown.Code, Int64})
precompile(Tuple{typeof(Base.write), Base.Terminals.TTYTerminal, Base.SubString{String}})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, Base.SubString{String}})
precompile(Tuple{typeof(Base.print), Base.Terminals.TTYTerminal, Base.SubString{String}, Char})
precompile(Tuple{typeof(Base.Markdown.term), Base.Terminals.TTYTerminal, Base.Markdown.Paragraph, Int64})
precompile(Tuple{typeof(Core.Inference.eltype), Type{Array{T, 2} where T}})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##wrapped_lines")), Array{Any, 1}, typeof(Base.Markdown.wrapped_lines), String})
precompile(Tuple{typeof(Base.start), Tuple{Symbol, String}})
precompile(Tuple{typeof(Base.Markdown.terminline), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Markdown.terminline), Base.AbstractIOBuffer{Array{UInt8, 1}}, String})
precompile(Tuple{typeof(Base.Markdown.terminline), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.Markdown.Code})
precompile(Tuple{typeof(Base._search), Base.SubString{String}, String, Int64})
precompile(Tuple{typeof(Base._split), Base.SubString{String}, String, Int64, Bool, Array{Base.SubString{String}, 1}})
precompile(Tuple{getfield(Base.Markdown, Symbol("#kw##wrapped_lines")), Array{Any, 1}, typeof(Base.Markdown.wrapped_lines), Base.SubString{String}})
precompile(Tuple{typeof(Base.endof), Array{AbstractString, 1}})
precompile(Tuple{typeof(Base.getindex), Array{AbstractString, 1}, Base.UnitRange{Int64}})
precompile(Tuple{typeof(Base.throw_boundserror), Array{AbstractString, 1}, Tuple{Base.UnitRange{Int64}}})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{AbstractString, 1}, Int64, Array{AbstractString, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.start), Array{AbstractString, 1}})
precompile(Tuple{typeof(Base.done), Array{AbstractString, 1}, Int64})
precompile(Tuple{typeof(Base.replace), String, Base.Regex, String})
precompile(Tuple{typeof(Base.Distributed.addprocs), Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.Cmd, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.Cmd, Symbol, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Bool, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Bool, Symbol, Int64})
precompile(Tuple{typeof(Base.merge!), Base.Dict{Any, Any}, Base.Dict{Any, Any}, Base.Dict{Any, Any}})
precompile(Tuple{Type{Symbol}, Symbol})
precompile(Tuple{typeof(Core.Inference.mk_getfield), TypedSlot, Int64, Type{String}})
precompile(Tuple{getfield(Core, Symbol("#kw#Type")), Array{Any, 1}, Type{Base.Cmd}, Base.Cmd})
precompile(Tuple{typeof(Base.uv_status_string), Base.PipeEndpoint})
precompile(Tuple{typeof(Base._fd), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.PipeEndpoint})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.isopen), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.stream_wait), Base.PipeEndpoint, Base.Condition})
precompile(Tuple{typeof(Base.close), Base.PipeEndpoint})
precompile(Tuple{getfield(Base, Symbol("#kw##setenv")), Array{Any, 1}, typeof(Base.setenv), Base.Cmd})
precompile(Tuple{Type{Base.Distributed.WorkerConfig}})
precompile(Tuple{typeof(Base.Distributed.launch), Base.Distributed.LocalManager, Base.Dict{Any, Any}, Array{Base.Distributed.WorkerConfig, 1}, Base.Condition})
precompile(Tuple{typeof(Base.julia_cmd), String})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{String}, Tuple{String, String}, Tuple{String, String}, Tuple{String, String}, Tuple{String, String}}})
precompile(Tuple{typeof(Base.arg_gen), String, String})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{Base.Cmd}, Tuple{Base.Cmd}, Tuple{String}, Tuple{Base.Cmd}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base.arg_gen), Base.Cmd})
precompile(Tuple{typeof(Base.promote_type), Type{Bool}, Type{UInt8}})
precompile(Tuple{typeof(Base.promote_rule), Type{UInt8}, Type{Bool}})
precompile(Tuple{typeof(Base.promote_result), Type{Bool}, Type{UInt8}, Type{UInt8}, Type{Union{}}})
precompile(Tuple{typeof(Base.promote_type), Type{UInt8}, Type{Union{}}})
precompile(Tuple{typeof(Base.detach), Base.Cmd})
precompile(Tuple{typeof(Base.open), Base.CmdRedirect, String, Base.DevNullStream})
precompile(Tuple{typeof(Base.spawn), Base.CmdRedirect, Tuple{Base.DevNullStream, Base.Pipe, Base.IOStream}})
precompile(Tuple{getfield(Base, Symbol("#kw##spawn")), Array{Any, 1}, typeof(Base.spawn), Base.Cmd, Tuple{Base.DevNullStream, Base.Pipe, Base.IOStream}})
precompile(Tuple{getfield(Base, Symbol("#kw##init_pipe!")), Array{Any, 1}, typeof(Base.init_pipe!), Base.PipeEndpoint})
precompile(Tuple{typeof(Base._link_pipe), Ptr{Void}, Ptr{Void}})
precompile(Tuple{typeof(Base.link_pipe), Base.PipeEndpoint, Bool, Base.PipeEndpoint, Bool})
precompile(Tuple{typeof(Base.close), Base.Filesystem.File})
precompile(Tuple{typeof(Base.setup_stdio), Base.Pipe, Bool})
precompile(Tuple{typeof(Base.setup_stdio), Base.IOStream, Bool})
precompile(Tuple{Type{Base.Process}, Base.Cmd, Ptr{Void}, Base.DevNullStream, Base.Pipe, Base.IOStream})
precompile(Tuple{typeof(Base._jl_spawn), String, Array{String, 1}, Ptr{Void}, Base.Process, Base.DevNullStream, Base.PipeEndpoint, Base.Filesystem.File})
precompile(Tuple{Type{Base.Timer}, Int64, Float64})
precompile(Tuple{typeof(Base.sleep), Int64})
precompile(Tuple{typeof(Base._uv_hook_close), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{IO}}})
precompile(Tuple{Type{Base.Nullable{IO}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{AbstractString}}})
precompile(Tuple{Type{Base.Nullable{AbstractString}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Integer}}})
precompile(Tuple{Type{Base.Nullable{Integer}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Union{Int64, Symbol}}}})
precompile(Tuple{Type{Base.Nullable{Union{Int64, Symbol}}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Cmd}}})
precompile(Tuple{Type{Base.Nullable{Base.Cmd}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Any}}})
precompile(Tuple{Type{Base.Nullable{Any}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Bool}}})
precompile(Tuple{Type{Base.Nullable{Bool}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Process}}})
precompile(Tuple{Type{Base.Nullable{Base.Process}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Dict{K, V} where V where K}}})
precompile(Tuple{Type{Base.Nullable{Base.Dict{K, V} where V where K}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Array{T, N} where N where T}}})
precompile(Tuple{Type{Base.Nullable{Array{T, N} where N where T}}})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Base.Process}}, Base.Process})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Bool}}, Bool})
precompile(Tuple{typeof(Base.task_done_hook), Task})
precompile(Tuple{typeof(Base.getindex), Tuple{Array{Any, 1}, Tuple{}}, Int64})
precompile(Tuple{Type{Base.TCPSocket}})
precompile(Tuple{typeof(Base.getsockname), Base.TCPSocket})
precompile(Tuple{typeof(Base.unsafe_store!), Ptr{Int32}, Int64})
precompile(Tuple{Type{Base.Multimedia.TextDisplay}, Base.PipeEndpoint})
precompile(Tuple{typeof(Base.Distributed.start_worker), Base.PipeEndpoint, String})
precompile(Tuple{typeof(Core.Inference.isbits), OutOfMemoryError})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64, Int64}})
precompile(Tuple{typeof(Base.getaddrinfo), String})
precompile(Tuple{typeof(Base.uv_status_string), Base.PipeEndpoint})
precompile(Tuple{typeof(Base._fd), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.PipeEndpoint})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, UInt16})
precompile(Tuple{typeof(Base.isopen), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.unpreserve_handle), Task})
precompile(Tuple{typeof(Base.check_open), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.stream_wait), Task})
precompile(Tuple{typeof(Base.uv_write), Base.PipeEndpoint, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.flush), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.unsafe_write), Base.PipeEndpoint, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.unsafe_write), Base.PipeEndpoint, Base.RefValue{UInt8}, Int64})
precompile(Tuple{typeof(Base.uv_status_string), Base.TCPSocket})
precompile(Tuple{typeof(Base._fd), Base.TCPSocket})
precompile(Tuple{typeof(Base.print), Base.PipeEndpoint, String})
precompile(Tuple{typeof(Base.print), Base.PipeEndpoint, Char})
precompile(Tuple{typeof(Base.print), Base.PipeEndpoint, String, Char})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.TCPSocket})
precompile(Tuple{typeof(Base.write), Base.PipeEndpoint, Char})
precompile(Tuple{typeof(Base.isopen), Base.TCPSocket})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.TCPSocket})
precompile(Tuple{typeof(Base.check_open), Base.TCPSocket})
precompile(Tuple{typeof(Base.stream_wait), Base.TCPSocket, Base.Condition})
precompile(Tuple{typeof(Base.wait_connected), Base.TCPSocket})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Base.IPv4, String})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, String, Base.IPv6, String})
precompile(Tuple{typeof(Base.Distributed.socket_reuse_port)})
precompile(Tuple{typeof(Base.promote_type), Type{Int64}, Type{Int16}})
precompile(Tuple{typeof(Base.promote_rule), Type{Int16}, Type{Int64}})
precompile(Tuple{typeof(Base.promote_result), Type{Int64}, Type{Int16}, Type{Int64}, Type{Union{}}})
precompile(Tuple{typeof(Base.Distributed.flush_gc_msgs)})
precompile(Tuple{typeof(Base.show), Base.AbstractIOBuffer{Array{UInt8, 1}}, Int16})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Int16})
precompile(Tuple{typeof(Base.uv_status_string), Base.PipeServer})
precompile(Tuple{typeof(Base._fd), Base.PipeServer})
precompile(Tuple{typeof(Base.convert), Type{Int16}, Int16})
precompile(Tuple{typeof(Base.string), String, Int16, String, String, String, String})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.PipeServer})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.PipeServer})
precompile(Tuple{typeof(Base.isopen), Base.PipeServer})
precompile(Tuple{typeof(Base.accept_nonblock), Base.PipeServer, Base.PipeEndpoint})
precompile(Tuple{typeof(Base.stream_wait), Base.PipeServer, Base.Condition})
precompile(Tuple{getfield(Base, Symbol("#kw##init_pipe!")), Array{Any, 1}, typeof(Base.init_pipe!), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.accept), Base.PipeServer, Base.PipeEndpoint})
precompile(Tuple{typeof(Base.accept_nonblock), Base.TCPServer, Base.TCPSocket})
precompile(Tuple{Type{Base.TCPSocket}})
precompile(Tuple{typeof(Base.accept), Base.TCPServer, Base.TCPSocket})
precompile(Tuple{typeof(Base.accept), Base.TCPServer})
precompile(Tuple{typeof(Base.tryparse_internal), Type{Int16}, Base.SubString{String}, Int64, Int64, Int64, Bool})
precompile(Tuple{typeof(Base.parse), Type{Int16}, Base.SubString{String}})
precompile(Tuple{typeof(Base.write), Base.PipeEndpoint, String})
precompile(Tuple{typeof(Base.Distributed.disable_nagle), Base.TCPServer})
precompile(Tuple{typeof(Base.Distributed.next_tunnel_port)})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base._delete!), Base.Dict{Int64, Union{Base.Distributed.Worker, Base.Distributed.LocalProcess}}, Int64})
precompile(Tuple{typeof(Base.ndigits0z), UInt8})
precompile(Tuple{typeof(Base.dec), UInt8, Int64, Bool})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, typeof(Type), Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, typeof(Type), Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.JoinPGRPMsg, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.JoinPGRPMsg})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Int64, Void}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Int64, Void}, Int64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Int64, Void}, Void, Int64, Int64})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{AbstractString, Base.Semaphore}, Int64})
precompile(Tuple{typeof(Base.resize!), Array{Base.Semaphore, 1}, Int64})
precompile(Tuple{typeof(Base.Distributed.connect_w2w), Int64, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.acquire), Base.Semaphore})
precompile(Tuple{typeof(Base.release), Base.Semaphore})
precompile(Tuple{typeof(Base.Distributed.create_worker), Base.Distributed.LocalManager, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.Distributed.setup_launched_worker), Base.Distributed.LocalManager, Base.Distributed.WorkerConfig, Array{Int64, 1}})
precompile(Tuple{typeof(Base.connect), Base.Distributed.LocalManager, Int64, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.Distributed.read_worker_host_port), Base.Pipe})
precompile(Tuple{typeof(Base.isreadable), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.search), Base.AbstractIOBuffer{Array{UInt8, 1}}, UInt8})
precompile(Tuple{typeof(Base.start_reading), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.wait_readbyte), Base.PipeEndpoint, UInt8})
precompile(Tuple{typeof(Base.readuntil), Base.PipeEndpoint, UInt8})
precompile(Tuple{typeof(Base.alloc_buf_hook), Base.PipeEndpoint, UInt64})
precompile(Tuple{typeof(Base._uv_hook_close), Base.Timer})
precompile(Tuple{typeof(Base.notify), Base.Condition, Base.EOFError, Bool, Bool})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.Timer})
precompile(Tuple{typeof(Base.disassociate_julia_struct), Base.Timer})
precompile(Tuple{typeof(Base.Distributed.parse_connection_info), String})
precompile(Tuple{typeof(Base._uv_hook_close), Base.Timer})
precompile(Tuple{typeof(Base.notify), Base.Condition, Base.EOFError, Bool, Bool})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.Timer})
precompile(Tuple{typeof(Base.disassociate_julia_struct), Base.Timer})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{AbstractString}}, Base.SubString{String}})
precompile(Tuple{typeof(Base.Distributed.connect_to_worker), Base.SubString{String}, Int16})
precompile(Tuple{typeof(Base.connect!), Base.TCPSocket, Base.SubString{String}, UInt16})
precompile(Tuple{typeof(Base.notify), Base.Condition, Base.IPv4, Bool, Bool})
precompile(Tuple{typeof(Base.schedule), Task, Base.IPv4})
precompile(Tuple{typeof(Base.connect!), Base.TCPSocket, Base.IPv4, UInt16})
precompile(Tuple{typeof(Base.Distributed.process_messages), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.uv_status_string), Base.TCPSocket})
precompile(Tuple{typeof(Base._fd), Base.TCPSocket})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.TCPSocket})
precompile(Tuple{typeof(Base.isopen), Base.TCPSocket})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{AbstractString}}, String})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.TCPSocket})
precompile(Tuple{typeof(Base.check_open), Base.TCPSocket})
precompile(Tuple{typeof(Base.stream_wait), Base.TCPSocket, Base.Condition})
precompile(Tuple{getfield(Core, Symbol("#kw#Type")), Array{Any, 1}, Type{Base.Distributed.Worker}, Int64, Base.TCPSocket, Base.TCPSocket, Base.Distributed.LocalManager})
precompile(Tuple{typeof(Base.read_sub), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.isreadable), Base.TCPSocket})
precompile(Tuple{typeof(Base.start_reading), Base.TCPSocket})
precompile(Tuple{typeof(Base.write_sub), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.readbytes!), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.wait_readnb), Base.TCPSocket, Int64})
precompile(Tuple{typeof(Base.write), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.readbytes!), Base.TCPSocket, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.read), Base.TCPSocket, Int64})
precompile(Tuple{typeof(Base.Distributed.worker_id_from_socket), Base.TCPSocket})
precompile(Tuple{Type{Base.Distributed.ClusterSerializer{Base.TCPSocket}}, Base.TCPSocket})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{Int64, 1}})
precompile(Tuple{typeof(Base.read), Base.TCPSocket, Type{UInt8}})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Int64, typeof(Base.Distributed.rmprocs)}}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Int64, typeof(Base.Distributed.rmprocs)}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.start), Tuple{typeof(Base.Distributed.rmprocs), Int64}})
precompile(Tuple{typeof(Core.Inference.indexed_next), Tuple{typeof(Base.Distributed.rmprocs), Int64}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{typeof(Base.Distributed.rmprocs), Int64}, Int64})
precompile(Tuple{typeof(Base.Distributed.register_worker_streams), Base.Distributed.Worker})
precompile(Tuple{typeof(Base.Distributed.register_worker_streams), Base.Distributed.LocalProcess})
precompile(Tuple{typeof(Base.convert), Type{IO}, Base.TCPSocket})
precompile(Tuple{Type{Base.Distributed.ClusterSerializer{Base.TCPSocket}}, Base.TCPSocket})
precompile(Tuple{typeof(Base.Distributed.worker_id_from_socket), Base.TCPSocket})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.ClusterSerializer{I} where I<:IO}, Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.ClusterManager}, Base.Distributed.LocalManager})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.WorkerConfig}, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Base.VersionNumber}}, Base.Nullable{Base.VersionNumber}})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Tuple{Int64}, Char})
precompile(Tuple{typeof(Base.get), Base.Dict{Any, Any}, Base.Distributed.RRID, Bool})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Any, Any}, Base.Distributed.RRID})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{QuoteNode}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}}, Type{QuoteNode}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Base.Distributed.local_remotecall_thunk), typeof(Base.Distributed.rmprocs), Tuple{Int64}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.Worker, Int64})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.LocalProcess, Int64})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.Worker, Int64})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.LocalProcess, Int64})
precompile(Tuple{Type{Base.Distributed.ResultMsg}, Base.Distributed.RemoteException})
precompile(Tuple{Type{Base.Distributed.ResultMsg}, Symbol})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.TCPSocket, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg})
precompile(Tuple{typeof(Base.close), Base.TCPSocket})
precompile(Tuple{typeof(Base._delete!), Base.Dict{Int64, Union{Base.Distributed.Worker, Base.Distributed.LocalProcess}}, Int64})
precompile(Tuple{typeof(Base.Distributed.def_rv_channel)})
precompile(Tuple{typeof(Base.convert), Type{Base.AbstractChannel}, Base.Channel{Any}})
precompile(Tuple{typeof(Base.ndigits0z), UInt8})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Base.Distributed.RemoteValue, Base.Distributed.RRID})
precompile(Tuple{typeof(Base.dec), UInt8, Int64, Bool})
precompile(Tuple{typeof(Core.Inference.mk_getfield), TypedSlot, Int64, Type{Integer}})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Any, Any}, Base.Distributed.RRID})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Base.Distributed.RemoteValue, Base.Distributed.RRID, Int64})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, DataType, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, DataType, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.notify), Base.Condition, Base.Distributed.ProcessExitedException, Bool, Bool})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Int64, Void}, Int64})
precompile(Tuple{typeof(Base.Distributed.process_messages), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Int64, Void}, Int64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Int64, Void}, Void, Int64, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Int64, Void}, Void, Int64})
precompile(Tuple{typeof(Base.pop!), Base.Dict{Int64, Union{Base.Distributed.Worker, Base.Distributed.LocalProcess}}, Int64, Void})
precompile(Tuple{typeof(Base.Distributed.send_connection_hdr), Base.Distributed.Worker, Bool})
precompile(Tuple{typeof(Base.Distributed.deregister_worker), Base.Distributed.ProcessGroup, Int64})
precompile(Tuple{typeof(Base.Distributed.process_hdr), Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.Distributed.deserialize_msg), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Distributed.null_id), Base.Distributed.RRID})
precompile(Tuple{typeof(Base.Distributed.deliver_result), Base.TCPSocket, Symbol, Base.Distributed.RRID, Base.Distributed.RemoteException})
precompile(Tuple{typeof(Base.Distributed.disable_nagle), Base.TCPSocket})
precompile(Tuple{typeof(Base.wait_connected), Base.TCPSocket})
precompile(Tuple{typeof(Base.Distributed.message_handler_loop), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.Distributed.process_tcp_streams), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, String})
precompile(Tuple{typeof(Base.uv_write), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.flush), Base.TCPSocket})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{Type{Base.Distributed.JoinPGRPMsg}, Int64, Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}, Symbol, Bool})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, Int64, Int64, Int64, Int64})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Base.Distributed.JoinPGRPMsg})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Base.RefValue{UInt8}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Core.Inference.Const, DataType, Core.Inference.Const}})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Core.Inference.Const, DataType, Core.Inference.Const}, Int64})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Base.RefValue{Int32}, Int64})
precompile(Tuple{typeof(Base.Serializer.write_as_tag), Base.TCPSocket, Int32})
precompile(Tuple{typeof(Base.copy!), Array{Any, 1}, Base.MethodList})
precompile(Tuple{typeof(Base.Serializer.should_send_whole_type), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Any}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, SimpleVector})
precompile(Tuple{typeof(Base.Serializer.serialize_type_data), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Any}, Bool})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Any}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Tuple{Int64}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{UInt64, UInt64}, UInt64})
precompile(Tuple{typeof(Base.unique), Array{Symbol, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}}})
precompile(Tuple{typeof(Base.Serializer.serialize_type), Base.Distributed.ClusterSerializer{Base.TCPSocket}, DataType})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{UInt64, UInt64}, Int64})
precompile(Tuple{typeof(Base.resize!), Array{UInt64, 1}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{UInt64, UInt64}, UInt64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Bool})
precompile(Tuple{typeof(Base.Distributed.serialize_global_from_main), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Symbol})
precompile(Tuple{typeof(Base.Serializer.serialize_mod_names), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Module})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Symbol})
precompile(Tuple{typeof(Core.Inference.isbits), Symbol})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Module})
precompile(Tuple{typeof(Base.isassigned), Array{Symbol, 1}, Int64})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{UInt64, Void}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{UInt64, Void}, UInt64})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{UInt64, Void}, Void, UInt64, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Array{Any, 1}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{WeakRef, Any}, TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle), Base.Distributed.ClusterSerializer{Base.TCPSocket}, TypeName})
precompile(Tuple{typeof(Base.Serializer.object_number), TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize_typename), Base.Distributed.ClusterSerializer{Base.TCPSocket}, TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Array{Symbol, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle_header), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}}})
precompile(Tuple{typeof(Base.Serializer.serialize_any), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}}})
precompile(Tuple{typeof(Base.isassigned), Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}, Int64})
precompile(Tuple{typeof(Base.uvfinalize), Base.TCPSocket})
precompile(Tuple{typeof(Base.close), Base.TCPSocket})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.wait_readnb), Base.PipeEndpoint, Int64})
precompile(Tuple{typeof(Base.eof), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Base.RefValue{Int32}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.read_sub), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.isreadable), Base.TCPSocket})
precompile(Tuple{typeof(Base.start_reading), Base.TCPSocket})
precompile(Tuple{typeof(Base.write_sub), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.readbytes!), Base.AbstractIOBuffer{Array{UInt8, 1}}, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.wait_readnb), Base.TCPSocket, Int64})
precompile(Tuple{typeof(Base.write), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.readbytes!), Base.TCPSocket, Array{UInt8, 1}, Int64})
precompile(Tuple{typeof(Base.read), Base.TCPSocket, Int64})
precompile(Tuple{typeof(Base.promote_type), Type{Int64}, Type{UInt8}})
precompile(Tuple{typeof(Base.promote_rule), Type{Int64}, Type{UInt8}})
precompile(Tuple{typeof(Base.promote_result), Type{Int64}, Type{UInt8}, Type{Union{}}, Type{Int64}})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{UInt64, 1}})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{Int64, 1}})
precompile(Tuple{typeof(Base.read), Base.TCPSocket, Type{UInt8}})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Int64, typeof(Base.Distributed.rmprocs)}}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Int64, typeof(Base.Distributed.rmprocs)}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Int64})
precompile(Tuple{typeof(Core.Inference.start), Tuple{typeof(Base.Distributed.rmprocs), Int64}})
precompile(Tuple{typeof(Core.Inference.indexed_next), Tuple{typeof(Base.Distributed.rmprocs), Int64}, Int64, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{typeof(Base.Distributed.rmprocs), Int64}, Int64})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_cycle), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Expr})
precompile(Tuple{typeof(Base.Serializer.handle_deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int32})
precompile(Tuple{typeof(Base._array_for), Type{Union{}}, Base.UnitRange{Int64}, Base.HasShape})
precompile(Tuple{typeof(Base.Serializer.deserialize_array), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_datatype), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_expr), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int64})
precompile(Tuple{typeof(Base.join), Base.AbstractIOBuffer{Array{UInt8, 1}}, Tuple{Int64}, Char})
precompile(Tuple{typeof(Core.Inference.isbits), Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{QuoteNode}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}}, Type{QuoteNode}, Tuple{Int64, typeof(Base.Distributed.rmprocs)}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Int64, typeof(Base.Distributed.rmprocs)}, Type{QuoteNode}}, Int64})
precompile(Tuple{typeof(Base.Distributed.local_remotecall_thunk), typeof(Base.Distributed.rmprocs), Tuple{Int64}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.Worker, Int64})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.LocalProcess, Int64})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.Worker, Int64})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.Distributed.rmprocs), Base.Distributed.LocalProcess, Int64})
precompile(Tuple{Type{Base.Distributed.ResultMsg}, Base.Distributed.RemoteException})
precompile(Tuple{Type{Base.Distributed.ResultMsg}, Symbol})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.TCPSocket, Base.Distributed.MsgHeader, Base.Distributed.ResultMsg})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Int64, Void}, Void, Int64})
precompile(Tuple{typeof(Base.notify), Base.Condition, Base.Distributed.ProcessExitedException, Bool, Bool})
precompile(Tuple{typeof(Base.pop!), Base.Dict{Int64, Union{Base.Distributed.Worker, Base.Distributed.LocalProcess}}, Int64, Void})
precompile(Tuple{typeof(Base.Distributed.deregister_worker), Base.Distributed.ProcessGroup, Int64})
precompile(Tuple{typeof(Base.Distributed.process_hdr), Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.Distributed.null_id), Base.Distributed.RRID})
precompile(Tuple{typeof(Base.Distributed.deliver_result), Base.TCPSocket, Symbol, Base.Distributed.RRID, Base.Distributed.RemoteException})
precompile(Tuple{typeof(Base.Distributed.disable_nagle), Base.TCPSocket})
precompile(Tuple{typeof(Base.Distributed.message_handler_loop), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.Distributed.process_tcp_streams), Base.TCPSocket, Base.TCPSocket, Bool})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Union}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Module}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{SimpleVector}})
precompile(Tuple{Type{Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}}, Tuple{Int64}})
precompile(Tuple{typeof(Base.eachindex), Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}})
precompile(Tuple{Type{Base.Distributed.JoinPGRPMsg}, Int64, Array{Union{Tuple{Any, Int64}, Tuple{Tuple{}, Any, Bool}}, 1}, Symbol, Bool})
precompile(Tuple{typeof(Base.Distributed.handle_msg), Base.Distributed.JoinPGRPMsg, Base.Distributed.MsgHeader, Base.TCPSocket, Base.TCPSocket, Base.VersionNumber})
precompile(Tuple{Type{Base.Distributed.WorkerConfig}})
precompile(Tuple{typeof(Base.LinAlg.BLAS.set_num_threads), Int64})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.JoinCompleteMsg, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg_now), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.JoinCompleteMsg})
precompile(Tuple{getfield(Core, Symbol("#kw#Type")), Array{Any, 1}, Type{Base.Distributed.Worker}, Int64, Base.TCPSocket, Base.TCPSocket, Base.Distributed.DefaultClusterManager})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{IO}}})
precompile(Tuple{Type{Base.Nullable{IO}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{AbstractString}}})
precompile(Tuple{Type{Base.Nullable{AbstractString}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Integer}}})
precompile(Tuple{Type{Base.Nullable{Integer}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Union{Int64, Symbol}}}})
precompile(Tuple{Type{Base.Nullable{Union{Int64, Symbol}}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Cmd}}})
precompile(Tuple{Type{Base.Nullable{Base.Cmd}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Any}}})
precompile(Tuple{Type{Base.Nullable{Any}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Bool}}})
precompile(Tuple{Type{Base.Nullable{Bool}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Process}}})
precompile(Tuple{Type{Base.Nullable{Base.Process}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Base.Dict{K, V} where V where K}}})
precompile(Tuple{Type{Base.Nullable{Base.Dict{K, V} where V where K}}})
precompile(Tuple{typeof(Base.eltype), Type{Base.Nullable{Array{T, N} where N where T}}})
precompile(Tuple{Type{Base.Nullable{Array{T, N} where N where T}}})
precompile(Tuple{typeof(Base.Distributed.register_worker_streams), Base.Distributed.Worker})
precompile(Tuple{typeof(Base.Distributed.register_worker_streams), Base.Distributed.LocalProcess})
precompile(Tuple{typeof(Base.convert), Type{IO}, Base.TCPSocket})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.ClusterSerializer{I} where I<:IO}, Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.ClusterManager}, Base.Distributed.DefaultClusterManager})
precompile(Tuple{typeof(Base.convert), Type{Base.Distributed.WorkerConfig}, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Base.VersionNumber}}, Base.VersionNumber})
precompile(Tuple{typeof(Base.Distributed.send_connection_hdr), Base.Distributed.Worker, Bool})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.Distributed.manage), Base.Distributed.LocalManager, Int64, Base.Distributed.WorkerConfig, Symbol})
precompile(Tuple{typeof(Base.uv_write), Base.TCPSocket, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.flush), Base.TCPSocket})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, Int64, Int64, Int64, Int64})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Base.Distributed.JoinCompleteMsg})
precompile(Tuple{typeof(Base.unsafe_write), Base.TCPSocket, Base.RefValue{UInt8}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int64})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Base.RefValue{Int32}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.TCPSocket, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.promote_type), Type{Int64}, Type{UInt8}})
precompile(Tuple{typeof(Base.promote_rule), Type{Int64}, Type{UInt8}})
precompile(Tuple{typeof(Base.promote_result), Type{Int64}, Type{UInt8}, Type{Union{}}, Type{Int64}})
precompile(Tuple{typeof(Base.read!), Base.TCPSocket, Array{UInt64, 1}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_cycle), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Expr})
precompile(Tuple{typeof(Base.Serializer.handle_deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int32})
precompile(Tuple{typeof(Base._array_for), Type{Union{}}, Base.UnitRange{Int64}, Base.HasShape})
precompile(Tuple{typeof(Base.Serializer.deserialize_array), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_datatype), Base.Distributed.ClusterSerializer{Base.TCPSocket}})
precompile(Tuple{typeof(Base.Serializer.deserialize_expr), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Int64})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{Int64}})
precompile(Tuple{typeof(Base.read), Base.TCPSocket, Type{Int64}})
precompile(Tuple{Type{Base.Distributed.JoinCompleteMsg}, Int64, Int64})
precompile(Tuple{typeof(Base.Distributed.handle_msg), Base.Distributed.JoinCompleteMsg, Base.Distributed.MsgHeader, Base.TCPSocket, Base.TCPSocket, Base.VersionNumber})
precompile(Tuple{typeof(Base.hash), Base.Distributed.RemoteChannel{Base.Channel{Any}}, UInt64})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{WeakRef, Void}, Base.Distributed.RemoteChannel{Base.Channel{Any}}})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.Distributed.put_ref), Base.Distributed.Worker, Base.Distributed.RRID, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.Distributed.put_ref), Base.Distributed.LocalProcess, Base.Distributed.RRID, Base.Distributed.WorkerPool})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.Distributed.put_ref), Base.Distributed.Worker, Base.Distributed.RRID, Base.Distributed.WorkerPool})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.Distributed.put_ref), Base.Distributed.LocalProcess, Base.Distributed.RRID, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{WeakRef, Void}, Int64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{WeakRef, Void}, WeakRef})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{WeakRef, Void}, Void, WeakRef, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{WeakRef, Void}, Void, WeakRef})
precompile(Tuple{typeof(Base.finalizer), Base.Distributed.RemoteChannel{Base.Channel{Any}}, typeof(Base.Distributed.finalize_ref)})
precompile(Tuple{typeof(Base.Distributed.test_existing_ref), Base.Distributed.RemoteChannel{Base.Channel{Any}}})
precompile(Tuple{Type{Base.Distributed.RemoteChannel{T} where T<:Base.AbstractChannel}, Int64})
precompile(Tuple{Type{Base.Channel{Int64}}, Int64})
precompile(Tuple{Type{Base.Distributed.WorkerPool}})
precompile(Tuple{typeof(Base.Distributed.default_worker_pool)})
precompile(Tuple{typeof(Base.get), Base.Nullable{Base.Dict{K, V} where V where K}, Base.Dict{Any, Any}})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Any, Any}, Int64, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Any, Any}, Int64, Symbol, Int64})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Base.Dict{K, V} where V where K}}, Base.Dict{Any, Any}})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Integer}}, Int64})
precompile(Tuple{typeof(Base.convert), Type{Base.Nullable{Base.VersionNumber}}, Base.VersionNumber})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Int64})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Int64})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Int64})
precompile(Tuple{typeof(Base.Distributed.call_on_owner), typeof(Base.Distributed.put_ref), Base.Distributed.RemoteChannel{Base.Channel{Any}}, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.Distributed.put_ref), Base.Distributed.RRID, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.put!), Base.Distributed.RemoteValue, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Base.Distributed.WorkerPool})
precompile(Tuple{typeof(Base.push!), Base.Distributed.WorkerPool, Int64})
precompile(Tuple{typeof(Base.check_channel_state), Base.Channel{Int64}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Int64}, Int64})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Int64}, Int64})
precompile(Tuple{typeof(Base.put!), Base.Channel{Int64}, Int64})
precompile(Tuple{typeof(Base._delete!), Base.Dict{Any, Any}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Base.Distributed.RemoteDoMsg})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, typeof(Base.Distributed.set_valid_processes)})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Tuple{Array{Int64, 1}}})
precompile(Tuple{typeof(Base.write), Base.TCPSocket, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize_array_data), Base.TCPSocket, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}, Int64, Int64, Base.Sort.InsertionSortAlg, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Sort.partition!), Array{Int64, 1}, Int64, Int64, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.sort!), Array{Int64, 1}, Int64, Int64, Base.Sort.QuickSortAlg, Base.Order.ForwardOrdering})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{typeof(Base.Distributed.set_valid_processes)}})
precompile(Tuple{typeof(Base.Distributed.handle_msg), Base.Distributed.RemoteDoMsg, Base.Distributed.MsgHeader, Base.TCPSocket, Base.TCPSocket, Base.VersionNumber})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Tuple{Array{Int64, 1}, Void}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Tuple{Array{Int64, 1}, Void}})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Tuple{Array{Int64, 1}, Void}})
precompile(Tuple{typeof(Base.Distributed.set_valid_processes), Array{Int64, 1}})
precompile(Tuple{typeof(Base.promote_type), Type{Int64}, Type{Int64}})
precompile(Tuple{typeof(Base.sizehint!), Base.Dict{Int64, Void}, Int64})
precompile(Tuple{typeof(Base.union!), Base.Set{Int64}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.start), Tuple{Array{Int64, 1}, Void}})
precompile(Tuple{typeof(Base.indexed_next), Tuple{Array{Int64, 1}, Void}, Int64, Int64})
precompile(Tuple{typeof(Base.setdiff), Array{Int64, 1}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Multimedia.display), Array{Int64, 1}})
precompile(Tuple{typeof(Base.isassigned), Array{Int64, 1}, Int64})
precompile(Tuple{typeof(Base.array_eltype_show_how), Array{Int64, 1}})
precompile(Tuple{typeof(Base._summary), Array{Int64, 1}, Tuple{Base.OneTo{Int64}}})
precompile(Tuple{typeof(Base.isassigned), Array{Int64, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.isassigned), Array{Int64, 1}})
precompile(Tuple{typeof(Base.Multimedia.display), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.Multimedia.display), Base.REPL.REPLDisplay{Base.REPL.LineEditREPL}, Base.MIME{Symbol("text/plain")}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.show_delim_array), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, String, String, String, Bool, Int64, Int64})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, Char})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, Char})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, String})
precompile(Tuple{typeof(Base.print), Base.IOContext{Base.Terminals.TTYTerminal}, String, String, Char})
precompile(Tuple{typeof(Base.show_vector), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, String, String})
precompile(Tuple{typeof(Base.print_matrix_repr), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.show_nd), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, typeof(Base.print_matrix_repr), Bool})
precompile(Tuple{typeof(Base.repremptyarray), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}})
precompile(Tuple{typeof(Base.print_matrix), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, String, String, String})
precompile(Tuple{typeof(Base.getindex), Base.ImmutableDict{Symbol, Any}, Symbol})
precompile(Tuple{typeof(Base.vcat), Base.OneTo{Int64}})
precompile(Tuple{typeof(Base.collect_to!), Array{Int64, 1}, Base.Generator{Array{Tuple{Int64, Int64}, 1}, typeof(Base.sum)}, Int64, Int64})
precompile(Tuple{typeof(Base._collect), Array{Tuple{Int64, Int64}, 1}, Base.Generator{Array{Tuple{Int64, Int64}, 1}, typeof(Base.sum)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.pop!), Array{Tuple{Int64, Int64}, 1}})
precompile(Tuple{typeof(Base.reverse), Array{Tuple{Int64, Int64}, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.print_matrix_vdots), Base.IOContext{Base.Terminals.TTYTerminal}, String, Array{Tuple{Int64, Int64}, 1}, String, Int64, Int64})
precompile(Tuple{typeof(Base.print_matrix), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, String, String, String, String, String, String, Int64, Int64})
precompile(Tuple{typeof(Base.alignment), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, Array{Int64, 1}, Array{Int64, 1}, Int64, Int64, Int64})
precompile(Tuple{getfield(Base, Symbol("#kw##sprint")), Array{Any, 1}, typeof(Base.sprint), Int64, typeof(Base.show), Int64})
precompile(Tuple{typeof(Base.sub2ind), Tuple{Int64}, Int64, Int64})
precompile(Tuple{typeof(Base._sub2ind), Tuple{Int64}, Int64, Int64, Int64, Int64})
precompile(Tuple{typeof(Base._sub2ind), Tuple{}, Int64, Int64, Int64})
precompile(Tuple{typeof(Base.first), Array{Int64, 1}})
precompile(Tuple{typeof(Base.print_matrix_row), Base.IOContext{Base.Terminals.TTYTerminal}, Array{Int64, 1}, Array{Tuple{Int64, Int64}, 1}, Int64, Array{Int64, 1}, String})
precompile(Tuple{typeof(Base.print), Base.AbstractIOBuffer{Array{UInt8, 1}}, Base.OneTo{Int64}})
precompile(Tuple{typeof(Base.last), Array{Int64, 1}})
precompile(Tuple{typeof(Base.LineEdit.edit_delete), Base.AbstractIOBuffer{Array{UInt8, 1}}})
precompile(Tuple{typeof(Base.print), String})
precompile(Tuple{typeof(Base.vcat), Array{Int64, 1}})
precompile(Tuple{typeof(Base.Distributed._rmprocs), Array{Int64, 1}, Float64})
precompile(Tuple{typeof(Core.Inference.eltype), Type{Array{Int64, 1}}})
precompile(Tuple{typeof(Base.vcat), Int64})
precompile(Tuple{typeof(Base.kill), Base.Distributed.LocalManager, Int64, Base.Distributed.WorkerConfig})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, typeof(Base.exit)})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Tuple{}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Distributed.ClusterSerializer{Base.TCPSocket}, Type{typeof(Base.exit)}})
precompile(Tuple{typeof(Base.uvfinalize), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.unpreserve_handle), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.stream_wait), Base.PipeEndpoint, Base.Condition})
precompile(Tuple{typeof(Base.close), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.uvfinalize), Base.TCPServer})
precompile(Tuple{typeof(Base.uvfinalize), Base.TCPSocket})
precompile(Tuple{typeof(Base._uv_hook_close), Base.TCPSocket})
precompile(Tuple{typeof(Base.in), Int64, Base.IntSet})
precompile(Tuple{typeof(Base._uv_hook_close), Base.Process})
precompile(Tuple{typeof(Base.Distributed.finalize_ref), Base.Distributed.RemoteChannel{Base.Channel{Any}}})
precompile(Tuple{typeof(Base._delete!), Base.Dict{WeakRef, Void}, Int64})
precompile(Tuple{typeof(Base.Distributed.send_del_client), Base.Distributed.RemoteChannel{Base.Channel{Any}}})
precompile(Tuple{typeof(Base.:(==)), Base.Distributed.RemoteChannel{Base.Channel{Any}}, Base.Distributed.RemoteChannel{Base.Channel{Any}}})
precompile(Tuple{typeof(Base.delete!), Base.IntSet, Int64})
precompile(Tuple{typeof(Base.isempty), Base.IntSet})
precompile(Tuple{typeof(Base.any), Base.BitArray{1}})
precompile(Tuple{typeof(Base.uvfinalize), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.uvfinalize), Base.Process})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.find_in_path), Base.Distributed.LocalProcess, String, Void})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.find_in_path), Base.Distributed.Worker, String, Void})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.open), Base.Distributed.LocalProcess, typeof(Base.read), String})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remotecall_fetch")), Array{Any, 1}, typeof(Base.Distributed.remotecall_fetch), typeof(Base.open), Base.Distributed.Worker, typeof(Base.read), String})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##remote_do")), Array{Any, 1}, typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.Worker})
precompile(Tuple{getfield(Base.Distributed, Symbol("#kw##rmprocs")), Array{Any, 1}, typeof(Base.Distributed.rmprocs), Array{Int64, 1}})
precompile(Tuple{getfield(Base.Filesystem, Symbol("#kw##rm")), Array{Any, 1}, typeof(Base.Filesystem.rm), String})
precompile(Tuple{getfield(Base, Symbol("#kw##info")), Array{Any, 1}, typeof(Base.info), Base.IOStream, String})
precompile(Tuple{getfield(Base, Symbol("#kw##print_with_color")), Array{Any, 1}, typeof(Base.print_with_color), Symbol, Base.IOStream, String})
precompile(Tuple{getfield(Base, Symbol("#kw##readbytes!")), Array{Any, 1}, typeof(Base.readbytes!), Base.IOStream, Array{UInt8, 1}, Int32})
precompile(Tuple{getfield(Base, Symbol("#kw##spawn")), Array{Any, 1}, typeof(Base.spawn), Base.Cmd, Tuple{Base.Pipe, Base.TTY, Base.IOStream}})
precompile(Tuple{getfield(Base, Symbol("#kw##systemerror")), Array{Any, 1}, typeof(Base.systemerror), Symbol, Bool})
precompile(Tuple{getfield(Base, Symbol("#kw##with_output_color")), Array{Any, 1}, typeof(Base.with_output_color), typeof(Base.println), Symbol, Base.IOStream, Base.SubString{String}})
precompile(Tuple{getfield(Base, Symbol("#kw##with_output_color")), Array{Any, 1}, typeof(Base.with_output_color), typeof(Base.print), Symbol, Base.IOStream, String})
precompile(Tuple{Type{Base.Distributed.Future}, Int64})
precompile(Tuple{Type{Base.Process}, Base.Cmd, Ptr{Void}, Base.Pipe, Base.TTY, Base.IOStream})
precompile(Tuple{Type{Base.Set{Tuple{String, Float64}}}, Tuple{Tuple{String, Float64}}})
precompile(Tuple{Type{Base.VersionNumber}, Int64, Int64, Int64, Tuple{String, Int64}, Tuple{}})
precompile(Tuple{Type{Base.VersionNumber}, Int64, Int64, Int64, Tuple{String}, Tuple{Int64}})
precompile(Tuple{Type{Core.Inference.Generator{I, F} where F where I}, Type{Core.Inference.Const}, Tuple{Symbol, Expr}})
precompile(Tuple{Type{Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}}, Type{Core.Inference.Const}, Tuple{Symbol, Expr}})
precompile(Tuple{typeof(Base.cmd_gen), Tuple{Tuple{Base.Cmd}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String}, Tuple{String, String}, Tuple{String}, Tuple{String}}})
precompile(Tuple{typeof(Base._collect), Array{Any, 1}, Base.Generator{Array{Any, 1}, typeof(Base.FastMath.make_fastmath)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base._collect), Array{Base.Process, 1}, Base.Generator{Array{Base.Process, 1}, typeof(Base.kill)}, Base.EltypeUnknown, Base.HasShape})
precompile(Tuple{typeof(Base.collect_to!), Array{Any, 1}, Base.Generator{Array{Any, 1}, typeof(Base.FastMath.make_fastmath)}, Int64, Int64})
precompile(Tuple{typeof(Base.collect_to!), Array{Expr, 1}, Base.Generator{Array{Any, 1}, typeof(Base.FastMath.make_fastmath)}, Int64, Int64})
precompile(Tuple{typeof(Base.collect_to!), Array{Int32, 1}, Base.Generator{Array{Base.Process, 1}, typeof(Base.kill)}, Int64, Int64})
precompile(Tuple{typeof(Base.collect_to!), Array{Symbol, 1}, Base.Generator{Array{Any, 1}, typeof(Base.FastMath.make_fastmath)}, Int64, Int64})
precompile(Tuple{typeof(Base.compilecache), String})
precompile(Tuple{typeof(Base.copy!), Array{Tuple{String, Float64}, 1}, Int64, Array{Tuple{String, Float64}, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.create_expr_cache), String, String, Array{Any, 1}})
precompile(Tuple{typeof(Base._delete!), Base.Dict{Symbol, Base.Condition}, Int64})
precompile(Tuple{typeof(Base.Distributed.flush_gc_msgs), Base.Distributed.Worker})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.find_in_path), Base.Distributed.LocalProcess, String, Void})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.find_in_path), Base.Distributed.Worker, String, Void})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.open), Base.Distributed.LocalProcess, typeof(Base.read), String})
precompile(Tuple{typeof(Base.Distributed.remotecall_fetch), typeof(Base.open), Base.Distributed.Worker, typeof(Base.read), String})
precompile(Tuple{typeof(Base.Distributed.remote_do), typeof(Base.exit), Base.Distributed.Worker})
precompile(Tuple{typeof(Base.Distributed.send_del_client), Base.Distributed.Future})
precompile(Tuple{typeof(Base.Distributed.send_msg), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.CallMsg{:call}})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.CallMsg{:call}, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.CallMsg{:call_fetch}})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.CallMsg{:call_fetch}, Bool})
precompile(Tuple{typeof(Base.Distributed.send_msg), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.RemoteDoMsg})
precompile(Tuple{typeof(Base.Distributed.send_msg_), Base.Distributed.Worker, Base.Distributed.MsgHeader, Base.Distributed.RemoteDoMsg, Bool})
precompile(Tuple{typeof(Base.Distributed.terminate_all_workers)})
precompile(Tuple{typeof(Base.Distributed.test_existing_ref), Base.Distributed.Future})
precompile(Tuple{typeof(Base.Docs.docm), String, Expr})
precompile(Tuple{typeof(Base.Docs.docm), String, Expr, Bool})
precompile(Tuple{typeof(Base.Docs.keyworddoc), String, Base.BaseDocs.Keyword})
precompile(Tuple{typeof(Base.Docs.objectdoc), String, Expr, Expr, Expr})
precompile(Tuple{typeof(Base.FastMath.make_fastmath), Expr})
precompile(Tuple{typeof(Base.Filesystem.lstat), String})
precompile(Tuple{typeof(Base.Filesystem.mkdir), String, UInt16})
precompile(Tuple{typeof(Base.Filesystem.mkpath), String, UInt16})
precompile(Tuple{typeof(Base.Filesystem.samefile), String, String})
precompile(Tuple{typeof(Base.Filesystem.unlink), String})
precompile(Tuple{typeof(Base.finalizer), Base.Distributed.Future, typeof(Base.Distributed.finalize_ref)})
precompile(Tuple{typeof(Base.find_all_in_cache_path), Symbol})
precompile(Tuple{typeof(Base.find_in_node_path), String, Void, Int64})
precompile(Tuple{typeof(Base.find_in_path), String, Void})
precompile(Tuple{typeof(Base.getindex), Base.ObjectIdDict, Symbol})
precompile(Tuple{typeof(Base.getindex), Type{Tuple{String, Float64}}, Tuple{String, Float64}})
precompile(Tuple{typeof(Base.Grisu._show), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Float64, Int64, Int64, Bool, Bool})
precompile(Tuple{typeof(Base.hash), Base.Distributed.Future, UInt64})
precompile(Tuple{typeof(Base.hash), Tuple{String, Float64}, UInt64})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Symbol, Base.Condition}, Symbol})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Symbol, UInt64}, Symbol})
precompile(Tuple{typeof(Base.ht_keyindex2), Base.Dict{Tuple{String, Float64}, Void}, Tuple{String, Float64}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Symbol, Base.Condition}, Symbol})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Symbol, UInt64}, Symbol})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{Tuple{String, Float64}, Void}, Tuple{String, Float64}})
precompile(Tuple{typeof(Base.ht_keyindex), Base.Dict{WeakRef, Void}, Base.Distributed.Future})
precompile(Tuple{typeof(Base.ident_cmp), Tuple{String, String, Int64}, Tuple{String, Int64}})
precompile(Tuple{typeof(Base.include_from_node1), String})
precompile(Tuple{typeof(Base._include_from_serialized), String})
precompile(Tuple{typeof(Base.indexed_next), Tuple{Symbol, UInt64}, Int64, Int64})
precompile(Tuple{typeof(Base.indexed_next), Tuple{Void, Void}, Int64, Int64})
precompile(Tuple{typeof(Base.isassigned), Array{String, 1}, Int64})
precompile(Tuple{typeof(Base.isempty), Tuple{String, Int64}})
precompile(Tuple{typeof(Base.isequal), Float64, String})
precompile(Tuple{typeof(Base.isequal), String, Float64})
precompile(Tuple{typeof(Base.isequal), Tuple{String, Float64}, Tuple{String, Float64}})
precompile(Tuple{typeof(Base._jl_spawn), String, Array{String, 1}, Ptr{Void}, Base.Process, Base.PipeEndpoint, Base.TTY, Base.Filesystem.File})
precompile(Tuple{typeof(Base.julia_cmd)})
precompile(Tuple{typeof(Base.load_hook), String, String, String})
precompile(Tuple{typeof(Base.load_hook), String, String, Void})
precompile(Tuple{typeof(Base.next), Base.Generator{Array{Any, 1}, typeof(Base.FastMath.make_fastmath)}, Int64})
precompile(Tuple{typeof(Base.open), Base.CmdRedirect, String, Base.TTY})
precompile(Tuple{typeof(Base.open), String, String})
precompile(Tuple{typeof(Base.open), typeof(Base.read), String})
precompile(Tuple{typeof(Base.parse_cache_header), Base.IOStream})
precompile(Tuple{typeof(Base.pop!), Base.Dict{Symbol, Base.Condition}, Symbol})
precompile(Tuple{typeof(Base.precompilableerror), Base.LoadError, Bool})
precompile(Tuple{typeof(Base.precompilableerror), Base.PrecompilableError, Bool})
precompile(Tuple{typeof(Base.__precompile__)})
precompile(Tuple{typeof(Base.__precompile__), Bool})
precompile(Tuple{typeof(Base.println_with_color), Symbol, Base.IOStream, Base.SubString{String}})
precompile(Tuple{typeof(Base.push!), Array{Tuple{String, Float64}, 1}, Tuple{String, Float64}})
precompile(Tuple{typeof(Base.put!), Base.Channel{Any}, Tuple{Void, Void}})
precompile(Tuple{typeof(Base.put_buffered), Base.Channel{Any}, Tuple{Void, Void}})
precompile(Tuple{typeof(Base.put_unbuffered), Base.Channel{Any}, Tuple{Void, Void}})
precompile(Tuple{typeof(Base.read), Base.IOStream, Type{Int32}})
precompile(Tuple{typeof(Base.read), Base.IOStream, Type{Int64}})
precompile(Tuple{typeof(Base.read), Base.IOStream, Type{UInt64}})
precompile(Tuple{typeof(Base.read!), Base.PipeEndpoint, Array{UInt64, 1}})
precompile(Tuple{typeof(Base.read!), Base.PipeEndpoint, Array{UInt8, 1}})
precompile(Tuple{typeof(Base.read), Base.PipeEndpoint, Type{Int64}})
precompile(Tuple{typeof(Base.read), Base.PipeEndpoint, Type{UInt64}})
precompile(Tuple{typeof(Base.read), Base.PipeEndpoint, Type{UInt8}})
precompile(Tuple{typeof(Base.readbytes_all!), Base.IOStream, Array{UInt8, 1}, Int32})
precompile(Tuple{typeof(Base.readbytes_some!), Base.IOStream, Array{UInt8, 1}, Int32})
precompile(Tuple{typeof(Base._redirect), Base.IOStream, Base.Dict{Tuple{Union{Module, Void}, Union{Symbol, Void}}, IO}, Base.StackTraces.StackFrame})
precompile(Tuple{typeof(Base._redirect), Base.IOStream, Base.Dict{Tuple{Union{Module, Void}, Union{Symbol, Void}}, IO}, Symbol})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Symbol, Base.Condition}, Int64})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Symbol, UInt64}, Int64})
precompile(Tuple{typeof(Base.rehash!), Base.Dict{Tuple{String, Float64}, Void}, Int64})
precompile(Tuple{typeof(Base.remove_linenums!), Module})
precompile(Tuple{typeof(Base._require_from_serialized), Int64, Symbol, String, Bool})
precompile(Tuple{typeof(Base._require_search_from_serialized), Int64, Symbol, String, Bool})
precompile(Tuple{typeof(Base.require), Symbol})
precompile(Tuple{typeof(Base.resize!), Array{Base.Condition, 1}, Int64})
precompile(Tuple{typeof(Base.resize!), Array{Tuple{String, Float64}, 1}, Int64})
precompile(Tuple{typeof(Base.resize!), Array{UInt8, 1}, Int32})
precompile(Tuple{typeof(Base.Serializer.deserialize_array), Base.Serializer.SerializationState{Base.PipeEndpoint}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.PipeEndpoint})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}, Type{Int64}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}, Type{QuoteNode}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}, Type{String}})
precompile(Tuple{typeof(Base.Serializer.deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}, Type{UInt64}})
precompile(Tuple{typeof(Base.Serializer.deserialize_cycle), Base.Serializer.SerializationState{Base.PipeEndpoint}, Expr})
precompile(Tuple{typeof(Base.Serializer.deserialize_datatype), Base.Serializer.SerializationState{Base.PipeEndpoint}})
precompile(Tuple{typeof(Base.Serializer.deserialize_expr), Base.Serializer.SerializationState{Base.PipeEndpoint}, Int64})
precompile(Tuple{typeof(Base.Serializer.handle_deserialize), Base.Serializer.SerializationState{Base.PipeEndpoint}, Int32})
precompile(Tuple{typeof(Base.Serializer.serialize_any), Base.Serializer.SerializationState{Base.Pipe}, QuoteNode})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Array{Any, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Array{String, 1}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Bool})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Expr})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Int64})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Module})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, QuoteNode})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, SimpleVector})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, String})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Symbol})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Tuple{Int64}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Tuple{Symbol, UInt64}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, Type{Any}})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize), Base.Serializer.SerializationState{Base.Pipe}, UInt64})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle), Base.Serializer.SerializationState{Base.Pipe}, Expr})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle), Base.Serializer.SerializationState{Base.Pipe}, TypeName})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle), Base.Serializer.SerializationState{Base.Pipe}, UInt64})
precompile(Tuple{typeof(Base.Serializer.serialize_cycle_header), Base.Serializer.SerializationState{Base.Pipe}, QuoteNode})
precompile(Tuple{typeof(Base.Serializer.serialize_mod_names), Base.Serializer.SerializationState{Base.Pipe}, Module})
precompile(Tuple{typeof(Base.Serializer.serialize_type), Base.Serializer.SerializationState{Base.Pipe}, DataType})
precompile(Tuple{typeof(Base.Serializer.serialize_type_data), Base.Serializer.SerializationState{Base.Pipe}, Type{Any}, Bool})
precompile(Tuple{typeof(Base.Serializer.serialize_typename), Base.Serializer.SerializationState{Base.Pipe}, TypeName})
precompile(Tuple{typeof(Base.Serializer.should_send_whole_type), Base.Serializer.SerializationState{Base.Pipe}, Type{Any}})
precompile(Tuple{typeof(Base.Serializer.write_as_tag), Base.Pipe, Int32})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Symbol, Base.Condition}, Base.Condition, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Symbol, Base.Condition}, Base.Condition, Symbol, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Symbol, UInt64}, UInt64, Symbol})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Symbol, UInt64}, UInt64, Symbol, Int64})
precompile(Tuple{typeof(Base.setindex!), Base.Dict{Tuple{String, Float64}, Void}, Void, Tuple{String, Float64}})
precompile(Tuple{typeof(Base._setindex!), Base.Dict{Tuple{String, Float64}, Void}, Void, Tuple{String, Float64}, Int64})
precompile(Tuple{typeof(Base.show), Base.IOContext{Base.AbstractIOBuffer{Array{UInt8, 1}}}, Float64})
precompile(Tuple{typeof(Base.show_delim_array), Base.AbstractIOBuffer{Array{UInt8, 1}}, Tuple{String, Float64}, Char, Char, Char, Bool, Int64, Int64})
precompile(Tuple{typeof(Base.show_unquoted), Base.AbstractIOBuffer{Array{UInt8, 1}}, Expr})
precompile(Tuple{typeof(Base.skip_deleted), Base.Dict{Tuple{String, Float64}, Void}, Int64})
precompile(Tuple{typeof(Base.spawn), Base.CmdRedirect, Tuple{Base.Pipe, Base.TTY, Base.IOStream}})
precompile(Tuple{typeof(Base.stale_cachefile), String, String})
precompile(Tuple{typeof(Base.start), Tuple{Symbol, UInt64}})
precompile(Tuple{typeof(Base.start), Tuple{Void, Void}})
precompile(Tuple{typeof(Base.:(>)), String, String})
precompile(Tuple{typeof(Base._str), String})
precompile(Tuple{typeof(Base._str), Void})
precompile(Tuple{typeof(Base.sync_add), Base.Distributed.Future})
precompile(Tuple{typeof(Base.trunc), Float64, Int64, Int64})
precompile(Tuple{typeof(Base.union!), Base.Set{Tuple{String, Float64}}, Tuple{Tuple{String, Float64}}})
precompile(Tuple{typeof(Base.unique_from), Array{Any, 1}, Array{Tuple{String, Float64}, 1}, Base.Set{Tuple{String, Float64}}, Int64})
precompile(Tuple{typeof(Base.unsafe_copy!), Array{Tuple{String, Float64}, 1}, Int64, Array{Tuple{String, Float64}, 1}, Int64, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.IOStream, Base.RefValue{Float64}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.PipeEndpoint, Base.RefValue{Int32}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.PipeEndpoint, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.PipeEndpoint, Base.RefValue{UInt64}, Int64})
precompile(Tuple{typeof(Base.unsafe_read), Base.PipeEndpoint, Ptr{UInt8}, UInt64})
precompile(Tuple{typeof(Base.unsafe_write), Base.Pipe, Base.RefValue{Int32}, Int64})
precompile(Tuple{typeof(Base.unsafe_write), Base.Pipe, Base.RefValue{Int64}, Int64})
precompile(Tuple{typeof(Base.unsafe_write), Base.Pipe, Base.RefValue{UInt64}, Int64})
precompile(Tuple{typeof(Base.write), Base.Pipe, UInt64})
precompile(Tuple{typeof(Core.Inference.collect), Type{Any}, Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference._collect), Type{Any}, Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}, Core.Inference.HasLength})
precompile(Tuple{typeof(Core.Inference.convert), Type{Tuple{Symbol, Expr}}, Tuple{Symbol, Expr}})
precompile(Tuple{typeof(Core.Inference.copy!), Array{Any, 1}, Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.done), Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.done), Tuple{Symbol, Expr}, Int64})
precompile(Tuple{typeof(Core.Inference.getindex), Tuple{Symbol, Expr}, Int64})
precompile(Tuple{typeof(Core.Inference.isbits), Array{Module, 1}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}}})
precompile(Tuple{typeof(Core.Inference.iteratorsize), Type{Tuple{Symbol, Expr}}})
precompile(Tuple{typeof(Core.Inference.length), Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.length), Tuple{Symbol, Expr}})
precompile(Tuple{typeof(Core.Inference.next), Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}, Int64})
precompile(Tuple{typeof(Core.Inference.next), Tuple{Symbol, Expr}, Int64})
precompile(Tuple{typeof(Core.Inference.start), Core.Inference.Generator{Tuple{Symbol, Expr}, Type{Core.Inference.Const}}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Expr, Int64}})
precompile(Tuple{typeof(Core.Inference.start), Tuple{Symbol, Expr}})
precompile(Tuple{Type{Union{}}, Base.Distributed.RRID})
