// Jubatus: Online machine learning framework for distributed environment
// Copyright (C) 2011 Preferred Networks and Nippon Telegraph and Telephone Corporation.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef JUBATUS_CLIENT_HPP_
#define JUBATUS_CLIENT_HPP_

//=============================================================//
//                                                             //
//   _________         ___                                     //
//   \____   _|       | /             ___I_I___                //
//       |  |         | |             \__^ ^__/        ____    //
//       |  |         | | ___    ___  __ | |          / __/    //
//       |  | |-|  |-|| |/   \  /   \| | | | |^|  |^|| (__     //
//       |  | | |  | ||    ^  ||  ^    | | | | |  | | \__ \    //
//       |  | | \_/  ||    O  ||  O    | | |_| \_/  | ___) |   //
//       |  |  \__/|_||_|\___/  \___/|_| |__/ \__/|_| \___/    //
//       | /                                                   //
//      / /                                                    //
//     |/                                                      //
//                                                             //
//=============================================================//

#include <jubatus/client/classifier_client.hpp>
#include <jubatus/client/recommender_client.hpp>
#include <jubatus/client/stat_client.hpp>
#include <jubatus/client/regression_client.hpp>
#include <jubatus/client/graph_client.hpp>
#include <jubatus/client/anomaly_client.hpp>
#include <jubatus/client/burst_client.hpp>
#include <jubatus/client/nearest_neighbor_client.hpp>
#include <jubatus/client/clustering_client.hpp>
#include <jubatus/client/bandit_client.hpp>
#include <jubatus/client/weight_client.hpp>

#endif  // JUBATUS_CLIENT_HPP_
