/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;

@ToNativeConverter.NoContext
@FromNativeConverter.NoContext
public final class EnumMapper {
    private final Class<? extends Enum> enumClass;
    private final int[] intValues;
    private final Map<Number, Enum> reverseLookupMap = new HashMap<Number, Enum>();

    private EnumMapper(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        EnumSet<? extends Enum> enums = EnumSet.allOf(enumClass);
        this.intValues = new int[enums.size()];
        Method intValueMethod = EnumMapper.getNumberValueMethod(enumClass, Integer.TYPE);
        for (Enum enum_ : enums) {
            Integer value2;
            if (intValueMethod != null) {
                Number value22 = EnumMapper.reflectedNumberValue(enum_, intValueMethod);
            } else {
                value2 = enum_.ordinal();
            }
            this.intValues[enum_.ordinal()] = value2;
            this.reverseLookupMap.put(value2, enum_);
        }
    }

    public static EnumMapper getInstance(Class<? extends Enum> enumClass) {
        EnumMapper mapper = (EnumMapper)StaticDataHolder.MAPPERS.get(enumClass);
        if (mapper != null) {
            return mapper;
        }
        return EnumMapper.addMapper(enumClass);
    }

    private static synchronized EnumMapper addMapper(Class<? extends Enum> enumClass) {
        EnumMapper mapper = new EnumMapper(enumClass);
        IdentityHashMap<Class<? extends Enum>, EnumMapper> tmp = new IdentityHashMap<Class<? extends Enum>, EnumMapper>(StaticDataHolder.MAPPERS);
        tmp.put(enumClass, mapper);
        StaticDataHolder.MAPPERS = tmp;
        return mapper;
    }

    private static Method getNumberValueMethod(Class c, Class numberClass) {
        try {
            Method m = c.getDeclaredMethod(numberClass.getSimpleName() + "Value", new Class[0]);
            return m != null && numberClass == m.getReturnType() ? m : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Number reflectedNumberValue(Enum e, Method m) {
        try {
            return (Number)m.invoke((Object)e, new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Integer integerValue(Enum value2) {
        if (value2.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value2.getClass());
        }
        return this.intValues[value2.ordinal()];
    }

    public final int intValue(Enum value2) {
        return this.integerValue(value2);
    }

    public Enum valueOf(int value2) {
        return this.reverseLookup(value2);
    }

    private Enum reverseLookup(int value2) {
        Enum e = this.reverseLookupMap.get(value2);
        return e != null ? e : this.badValue(value2);
    }

    private Enum badValue(int value2) {
        try {
            return Enum.valueOf(this.enumClass, "__UNKNOWN_NATIVE_VALUE");
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("No known Enum mapping for value " + value2 + " of type " + this.enumClass.getName());
        }
    }

    private static final class StaticDataHolder {
        private static volatile Map<Class<? extends Enum>, EnumMapper> MAPPERS = Collections.emptyMap();

        private StaticDataHolder() {
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }
}

