/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.release.BaseReleaser;

public class CodebergReleaser
extends BaseReleaser<org.jreleaser.model.api.release.CodebergReleaser, CodebergReleaser> {
    private static final long serialVersionUID = -3260112972191332390L;
    private Boolean draft;
    @JsonIgnore
    private final org.jreleaser.model.api.release.CodebergReleaser immutable = new org.jreleaser.model.api.release.CodebergReleaser(){
        private static final long serialVersionUID = -4853178830155860635L;

        public boolean isPrerelease() {
            return CodebergReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return CodebergReleaser.this.isDraft();
        }

        public String getServiceName() {
            return CodebergReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return CodebergReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return CodebergReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return CodebergReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return CodebergReleaser.this.isMatch();
        }

        public String getHost() {
            return CodebergReleaser.this.getHost();
        }

        public String getName() {
            return CodebergReleaser.this.getName();
        }

        public String getRepoUrl() {
            return CodebergReleaser.this.getRepoUrl();
        }

        public String getRepoCloneUrl() {
            return CodebergReleaser.this.getRepoCloneUrl();
        }

        public String getCommitUrl() {
            return CodebergReleaser.this.getCommitUrl();
        }

        public String getSrcUrl() {
            return CodebergReleaser.this.getSrcUrl();
        }

        public String getDownloadUrl() {
            return CodebergReleaser.this.getDownloadUrl();
        }

        public String getReleaseNotesUrl() {
            return CodebergReleaser.this.getReleaseNotesUrl();
        }

        public String getLatestReleaseUrl() {
            return CodebergReleaser.this.getLatestReleaseUrl();
        }

        public String getIssueTrackerUrl() {
            return CodebergReleaser.this.getIssueTrackerUrl();
        }

        public String getUsername() {
            return CodebergReleaser.this.getUsername();
        }

        public String getToken() {
            return CodebergReleaser.this.getToken();
        }

        public String getTagName() {
            return CodebergReleaser.this.getTagName();
        }

        public String getPreviousTagName() {
            return CodebergReleaser.this.getPreviousTagName();
        }

        public String getReleaseName() {
            return CodebergReleaser.this.getReleaseName();
        }

        public String getBranch() {
            return CodebergReleaser.this.getBranch();
        }

        public String getBranchPush() {
            return CodebergReleaser.this.getBranchPush();
        }

        public Releaser.Prerelease getPrerelease() {
            return CodebergReleaser.this.getPrerelease().asImmutable();
        }

        public boolean isSign() {
            return CodebergReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return CodebergReleaser.this.getChangelog().asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return CodebergReleaser.this.getMilestone().asImmutable();
        }

        public Releaser.Issues getIssues() {
            return CodebergReleaser.this.getIssues().asImmutable();
        }

        public boolean isSkipTag() {
            return CodebergReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return CodebergReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return CodebergReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return CodebergReleaser.this.getUpdate().asImmutable();
        }

        public String getApiEndpoint() {
            return CodebergReleaser.this.getApiEndpoint();
        }

        public boolean isArtifacts() {
            return CodebergReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return CodebergReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return CodebergReleaser.this.isChecksums();
        }

        public boolean isCatalogs() {
            return CodebergReleaser.this.isCatalogs();
        }

        public boolean isSignatures() {
            return CodebergReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return CodebergReleaser.this.getUploadAssets();
        }

        public CommitAuthor getCommitAuthor() {
            return CodebergReleaser.this.getCommitAuthor().asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(CodebergReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return CodebergReleaser.this.isEnabled();
        }

        public String getOwner() {
            return CodebergReleaser.this.getOwner();
        }

        public Integer getConnectTimeout() {
            return CodebergReleaser.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return CodebergReleaser.this.getReadTimeout();
        }
    };

    public CodebergReleaser() {
        this("codeberg");
    }

    CodebergReleaser(String name) {
        super(name, true);
        this.setHost("codeberg.org");
        this.setApiEndpoint("https://codeberg.org");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/src/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.CodebergReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(CodebergReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
    }

    public boolean isDraft() {
        return null != this.draft && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return null != this.draft;
    }

    @Override
    public String getReverseRepoHost() {
        return null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        return map;
    }
}

