/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.sdk.github.api.GhPackageVersion;

public class GithubMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.GithubMavenDeployer, org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer deployer;

    public GithubMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "github";
    }

    public void deploy(String name) throws DeployException {
        this.deployPackages();
    }

    protected void deleteExistingPackages(String baseUrl, String token, Set<AbstractMavenDeployer.Deployable> deployables) throws DeployException {
        for (AbstractMavenDeployer.Deployable deployable : deployables) {
            if (!deployable.getFilename().endsWith(".pom")) continue;
            this.deletePackage(token, deployable);
        }
    }

    private void deletePackage(String token, AbstractMavenDeployer.Deployable deployable) {
        String packageType = "maven";
        String packageName = deployable.getGroupId() + "." + deployable.getArtifactId();
        String packageVersion = deployable.getVersion();
        try {
            Github api = new Github(this.context.getLogger(), this.context.getModel().getRelease().getGithub().getApiEndpoint(), token, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout());
            List<GhPackageVersion> ghPackageVersions = api.listPackageVersions(packageType, packageName);
            if (ghPackageVersions.isEmpty()) {
                return;
            }
            if (ghPackageVersions.size() == 1) {
                api.deletePackage(packageType, packageName);
            } else {
                Optional<GhPackageVersion> ghPackageVersion = ghPackageVersions.stream().filter(pv -> pv.getName().equals(packageVersion)).findFirst();
                if (ghPackageVersion.isPresent()) {
                    api.deletePackageVersion(packageType, packageType, packageVersion);
                }
            }
        }
        catch (Exception e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_github_delete_package", (Object[])new Object[]{this.deployer.getUsername(), packageType, packageName, packageVersion}));
        }
    }
}

