/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import twitter4j.Configuration;
import twitter4j.TwitterImpl;
import twitter4j.v1.ConnectionLifeCycleListener;
import twitter4j.v1.RawStreamListener;
import twitter4j.v1.Status;
import twitter4j.v1.StatusAdapter;
import twitter4j.v1.StreamListener;
import twitter4j.v1.TwitterV1;

public interface Twitter
extends Serializable {
    public static TwitterBuilder newBuilder() {
        return new TwitterBuilder();
    }

    public static Twitter getInstance() {
        return Twitter.newBuilder().build();
    }

    public TwitterV1 v1();

    public static class TwitterBuilder
    extends Configuration<TwitterBuilder> {
        final List<ConnectionLifeCycleListener> connectionLifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>();
        final List<StreamListener> streamListeners = new ArrayList<StreamListener>();
        final List<RawStreamListener> rawStreamListeners = new ArrayList<RawStreamListener>();

        private TwitterBuilder() {
        }

        public Twitter build() {
            return new TwitterImpl((Configuration)this.buildConfiguration());
        }

        public TwitterBuilder connectionLifeCycleListener(@NotNull ConnectionLifeCycleListener listener) {
            this.connectionLifeCycleListeners.add(listener);
            return this;
        }

        public TwitterBuilder listener(@NotNull StreamListener streamListener) {
            this.streamListeners.add(streamListener);
            return this;
        }

        public TwitterBuilder listener(@NotNull RawStreamListener rawStreamListener) {
            this.rawStreamListeners.add(rawStreamListener);
            return this;
        }

        public TwitterBuilder onStatus(final @NotNull Consumer<Status> onStatus) {
            this.streamListeners.add(new StatusAdapter(){

                @Override
                public void onStatus(Status status) {
                    onStatus.accept(status);
                }
            });
            return this;
        }

        public TwitterBuilder onException(final Consumer<Exception> onException) {
            this.streamListeners.add(new StatusAdapter(){

                @Override
                public void onException(Exception ex) {
                    onException.accept(ex);
                }
            });
            return this;
        }
    }
}

