/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Map;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.SshDelegate;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.model.internal.upload.SshUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public abstract class AbstractSshUploader<A extends org.jreleaser.model.api.upload.SshUploader, S extends AbstractSshUploader<A, S>>
extends AbstractUploader<A, S>
implements SshUploader<A> {
    private static final long serialVersionUID = 9028661488115999432L;
    private final SshDelegate delegate = new SshDelegate();
    private String path;
    private String downloadUrl;

    protected AbstractSshUploader(String type) {
        super(type);
    }

    protected SshDelegate delegate() {
        return this.delegate;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.delegate.merge(((AbstractSshUploader)source).delegate());
        this.path = this.merge(this.path, ((AbstractSshUploader)source).getPath());
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractSshUploader)source).getDownloadUrl());
    }

    @Override
    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        TemplateContext p = this.artifactProps(context.fullProps(), artifact);
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)this.path, (TemplateContext)p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(TemplateContext props, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, (TemplateContext)p);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    @Override
    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public void setHost(String host) {
        this.delegate.setHost(host);
    }

    @Override
    public Integer getPort() {
        return this.delegate.getPort();
    }

    @Override
    public void setPort(Integer port) {
        this.delegate.setPort(port);
    }

    @Override
    public String getKnownHostsFile() {
        return this.delegate.getKnownHostsFile();
    }

    @Override
    public void setKnownHostsFile(String knownHostsFile) {
        this.delegate.setKnownHostsFile(knownHostsFile);
    }

    @Override
    public String getPublicKey() {
        return this.delegate.getPublicKey();
    }

    @Override
    public void setPublicKey(String publicKey) {
        this.delegate.setPublicKey(publicKey);
    }

    @Override
    public String getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.delegate.setPrivateKey(privateKey);
    }

    @Override
    public String getPassphrase() {
        return this.delegate.getPassphrase();
    }

    @Override
    public void setPassphrase(String passphrase) {
        this.delegate.setPassphrase(passphrase);
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public void setFingerprint(String fingerprint) {
        this.delegate.setFingerprint(fingerprint);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        this.delegate.asMap(props);
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }
}

