/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.BrewPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class BrewPackagerValidator {
    private BrewPackagerValidator() {
    }

    public static void validateBrew(JReleaserContext context, Distribution distribution, BrewPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        BrewPackager parentPackager = model.getPackagers().getBrew();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            packager.getCask().disable();
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            packager.getCask().disable();
            return;
        }
        BrewPackager.Cask cask = BrewPackagerValidator.preValidateCask(distribution, packager, parentPackager);
        if (!packager.isMultiPlatformSet() && parentPackager.isMultiPlatformSet()) {
            packager.setMultiPlatform(parentPackager.isMultiPlatform());
        }
        if (packager.isMultiPlatform() && (distribution.getType() == Distribution.DistributionType.SINGLE_JAR || distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE)) {
            packager.setMultiPlatform(false);
        }
        if (packager.isMultiPlatform()) {
            packager.getCask().disable();
        }
        BrewPackagerValidator.validateCask(context, distribution, packager, cask, errors);
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        BrewPackager.HomebrewTap tap = packager.getTap();
        Validator.validateTap(context, distribution, tap, parentPackager.getTap(), "brew.tap");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        ArrayList<BrewPackager.Dependency> dependencies = new ArrayList<BrewPackager.Dependency>(parentPackager.getDependenciesAsList());
        dependencies.addAll(packager.getDependenciesAsList());
        packager.setDependenciesAsList(dependencies);
        if (StringUtils.isBlank((String)packager.getFormulaName())) {
            packager.setFormulaName(distribution.getName());
        }
        if (!cask.isEnabled()) {
            DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        }
    }

    private static BrewPackager.Cask preValidateCask(Distribution distribution, BrewPackager packager, BrewPackager parentPackager) {
        BrewPackager.Cask cask = packager.getCask();
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            packager.getCask().disable();
            return cask;
        }
        BrewPackager.Cask parentCask = parentPackager.getCask();
        if (!cask.isEnabledSet() && parentCask.isEnabledSet()) {
            cask.setEnabled(parentCask.isEnabled());
        }
        return cask;
    }

    private static void validateCask(JReleaserContext context, Distribution distribution, BrewPackager packager, BrewPackager.Cask cask, Errors errors) {
        if (null == cask || cask.isEnabledSet() && !cask.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.brew.cask", new Object[]{distribution.getName()});
        int dmgFound = 0;
        int pkgFound = 0;
        int zipFound = 0;
        String pkgName = "";
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.isActive() || !PlatformUtils.isMac((String)artifact.getPlatform())) continue;
            if (artifact.getPath().endsWith(".dmg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++dmgFound;
                continue;
            }
            if (artifact.getPath().endsWith(".pkg") && !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) {
                ++pkgFound;
                pkgName = artifact.getEffectivePath(context).getFileName().toString();
                continue;
            }
            if (!artifact.getPath().endsWith(".zip") || StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipBrew"))) continue;
            ++zipFound;
        }
        if (dmgFound == 0 && pkgFound == 0 && zipFound == 0) {
            cask.disable();
            return;
        }
        if (dmgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".dmg"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (pkgFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".pkg"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_multiple_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew", ".zip"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (dmgFound + pkgFound + zipFound > 1) {
            errors.configuration(RB.$((String)"validation_brew_single_artifact", (Object[])new Object[]{"distribution." + distribution.getName() + ".brew"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            cask.disable();
            return;
        }
        if (zipFound == 1 && !cask.isEnabled()) {
            return;
        }
        cask.enable();
        if (StringUtils.isBlank((String)cask.getPkgName()) && StringUtils.isNotBlank((String)pkgName)) {
            cask.setPkgName(pkgName);
        }
        if (StringUtils.isNotBlank((String)cask.getPkgName())) {
            if (!cask.getPkgName().endsWith(".pkg")) {
                cask.setPkgName(cask.getPkgName() + ".pkg");
            }
        } else if (StringUtils.isBlank((String)cask.getAppName())) {
            cask.setAppName(packager.getResolvedFormulaName(context) + ".app");
        } else if (!cask.getAppName().endsWith(".app")) {
            cask.setAppName(cask.getAppName() + ".app");
        }
        if (zipFound > 0) {
            cask.setAppName("");
            cask.setPkgName("");
        }
        if (StringUtils.isBlank((String)cask.getName())) {
            cask.setName(packager.getResolvedFormulaName(context).toLowerCase(Locale.ENGLISH));
        }
        if (StringUtils.isBlank((String)cask.getDisplayName())) {
            cask.setDisplayName(packager.getResolvedFormulaName(context));
        }
    }

    public static void postValidateBrew(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getActiveDistributions().stream().filter(d -> d.getBrew().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getResolvedFormulaName(context)));
        map.forEach((formulaName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.formulaName '" + formulaName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
        map = context.getModel().getActiveDistributions().stream().filter(d -> d.getBrew().getCask().isEnabled()).collect(Collectors.groupingBy(d -> d.getBrew().getCask().getResolvedCaskName(context)));
        map.forEach((caskName, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_brew_duplicate_definition", (Object[])new Object[]{"brew.cask.name '" + caskName + "'", distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

