/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;

public final class ArtifactoryUploaderValidator {
    private ArtifactoryUploaderValidator() {
    }

    public static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ArtifactoryUploader> artifactory = context.getModel().getUpload().getArtifactory();
        if (!artifactory.isEmpty()) {
            context.getLogger().debug("upload.artifactory");
        }
        for (Map.Entry<String, ArtifactoryUploader> e : artifactory.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            ArtifactoryUploaderValidator.validateArtifactory(context, e.getValue(), errors);
        }
    }

    private static void validateArtifactory(JReleaserContext context, ArtifactoryUploader artifactory, Errors errors) {
        context.getLogger().debug("upload.artifactory.{}", new Object[]{artifactory.getName()});
        Validator.resolveActivatable(context, (Activatable)artifactory, CollectionUtils.listOf((Object[])new String[]{"upload.artifactory." + artifactory.getName(), "upload.artifactory"}), "NEVER");
        if (!artifactory.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(artifactory.isArtifacts() || artifactory.isFiles() || artifactory.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{artifactory.getType(), artifactory.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            artifactory.disable();
            return;
        }
        if (artifactory.getRepositories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_artifactory_no_repositories", (Object[])new Object[]{"artifactory." + artifactory.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.repositories", (Object[])new Object[0]));
            artifactory.disable();
            return;
        }
        String baseKey1 = "upload.artifactory." + artifactory.getName();
        String baseKey2 = "upload.artifactory";
        String baseKey3 = "artifactory." + artifactory.getName();
        String baseKey4 = "artifactory";
        artifactory.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".host", baseKey2 + ".host", baseKey3 + ".host", baseKey4 + ".host"}), baseKey1 + ".host", artifactory.getHost(), errors));
        switch (artifactory.resolveAuthorization()) {
            case BEARER: {
                artifactory.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".password", baseKey2 + ".password", baseKey3 + ".password", baseKey4 + ".password"}), baseKey1 + ".password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                artifactory.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".username", baseKey2 + ".username", baseKey3 + ".username", baseKey4 + ".username"}), baseKey1 + ".username", artifactory.getUsername(), errors, context.isDryrun()));
                artifactory.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".password", baseKey2 + ".password", baseKey3 + ".password", baseKey4 + ".password"}), baseKey1 + ".password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{baseKey1 + ".authorization", "NONE"}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                artifactory.disable();
            }
        }
        Validator.validateTimeout(artifactory);
        for (ArtifactoryUploader.ArtifactoryRepository repository : artifactory.getRepositories()) {
            Validator.resolveActivatable(context, (Activatable)repository, baseKey1 + ".repository", "");
            if (!repository.isActiveSet()) {
                repository.setActive(artifactory.getActive());
            }
            repository.resolveEnabledWithSnapshot(context.getModel().getProject());
        }
        if (artifactory.getRepositories().stream().noneMatch(AbstractActivatable::isEnabled)) {
            errors.warning(RB.$((String)"validation_artifactory_disabled_repositories", (Object[])new Object[]{baseKey1}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.repositories", (Object[])new Object[0]));
            artifactory.disable();
        }
    }
}

