/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TelegramAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TelegramAnnouncerValidator {
    private static final String DEFAULT_TELEGRAM_TPL = "src/jreleaser/templates/telegram.tpl";

    private TelegramAnnouncerValidator() {
    }

    public static void validateTelegram(JReleaserContext context, TelegramAnnouncer telegram, Errors errors) {
        context.getLogger().debug("announce.telegram");
        Validator.resolveActivatable(context, (Activatable)telegram, "announce.telegram", "NEVER");
        if (!telegram.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        telegram.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.telegram.token", "TELEGRAM_TOKEN"}), "announce.telegram.token", telegram.getToken(), errors, context.isDryrun()));
        telegram.setChatId(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.telegram.chat.id", "TELEGRAM_CHAT_ID"}), "announce.telegram.chatId", telegram.getChatId(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)telegram.getMessage()) && StringUtils.isBlank((String)telegram.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_TELEGRAM_TPL), new LinkOption[0])) {
                telegram.setMessageTemplate(DEFAULT_TELEGRAM_TPL);
            } else {
                telegram.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)telegram.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(telegram.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"telegram.messageTemplate", telegram.getMessageTemplate()}));
        }
        Validator.validateTimeout(telegram);
    }
}

