/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ssh;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.download.SftpDownloader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.sdk.commons.AbstractArtifactDownloader;
import org.jreleaser.sdk.ssh.SshUtils;
import org.jreleaser.util.StringUtils;

public class SftpArtifactDownloader
extends AbstractArtifactDownloader<SftpDownloader, org.jreleaser.model.internal.download.SftpDownloader> {
    private org.jreleaser.model.internal.download.SftpDownloader downloader;

    public SftpArtifactDownloader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.download.SftpDownloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(org.jreleaser.model.internal.download.SftpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getType() {
        return "scp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String name) throws DownloadException {
        SSHClient ssh = SshUtils.createSSHClient(this.context, this.downloader);
        SFTPClient sftp = SshUtils.createSFTPClient(this.context, this.downloader, ssh);
        try {
            try {
                for (Downloader.Asset asset : this.downloader.getAssets()) {
                    this.downloadAsset(name, sftp, asset);
                }
            }
            finally {
                SshUtils.close(this.downloader, sftp);
            }
        }
        finally {
            SshUtils.disconnect(this.downloader, ssh);
        }
    }

    private void downloadAsset(String name, SFTPClient sftp, Downloader.Asset asset) throws DownloadException {
        String input = asset.getResolvedInput(this.context, (Downloader)this.downloader);
        String output = asset.getResolvedOutput(this.context, (Downloader)this.downloader, Paths.get(input, new String[0]).getFileName().toString());
        if (StringUtils.isBlank((String)output)) {
            output = Paths.get(input, new String[0]).getFileName().toString();
        }
        Path outputPath = this.context.getDownloadDirectory().resolve(name).resolve(output);
        this.context.getLogger().info("{} -> {}", new Object[]{input, this.context.relativizeToBasedir(outputPath)});
        if (!this.context.isDryrun()) {
            try {
                Files.createDirectories(outputPath.toAbsolutePath().getParent(), new FileAttribute[0]);
                sftp.get(input, outputPath.toAbsolutePath().toString());
            }
            catch (IOException e) {
                throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
            }
        }
        this.unpack(asset.getUnpack(), outputPath);
    }
}

