/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.ScpUploader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScpUploaderValidator
extends Validator {
    public static void validateScpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ScpUploader> scp = context.getModel().getUpload().getScp();
        if (!scp.isEmpty()) {
            context.getLogger().debug("upload.scp");
        }
        for (Map.Entry<String, ScpUploader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            ScpUploaderValidator.validateScpUploader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateScpUploader(JReleaserContext context, JReleaserContext.Mode mode, ScpUploader scp, Errors errors) {
        context.getLogger().debug("upload.scp.{}", new Object[]{scp.getName()});
        if (!scp.isActiveSet()) {
            scp.setActive(Active.NEVER);
        }
        if (!scp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(scp.isArtifacts() || scp.isFiles() || scp.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{scp.getType(), scp.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            scp.disable();
            return;
        }
        SshValidator.validateSsh(context, scp, scp.getName(), "SCP", "upload." + scp.getType() + "." + scp.getName(), errors);
        if (StringUtils.isBlank((String)scp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"scp." + scp.getName() + ".path"}));
        }
        ScpUploaderValidator.validateTimeout(scp);
    }
}

