/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.GiteaReleaser;
import org.jreleaser.model.internal.validation.release.BaseReleaserValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GiteaReleaserValidator
extends BaseReleaserValidator {
    public static boolean validateGitea(JReleaserContext context, JReleaserContext.Mode mode, GiteaReleaser gitea, Errors errors) {
        if (null == gitea) {
            return false;
        }
        context.getLogger().debug("release.gitea");
        GiteaReleaserValidator.validateGitService(context, mode, gitea, errors);
        if (StringUtils.isBlank((String)gitea.getApiEndpoint())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"gitea.internal.mutableEndpoint"}));
        }
        if (context.getModel().getProject().isSnapshot()) {
            gitea.getPrerelease().setEnabled(true);
        }
        gitea.getPrerelease().setPattern(GiteaReleaserValidator.checkProperty(context, "PRERELEASE_PATTERN", "release.gitea.prerelease.pattern", gitea.getPrerelease().getPattern(), ""));
        gitea.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        if (!gitea.isDraftSet()) {
            gitea.setDraft(GiteaReleaserValidator.checkProperty(context, "DRAFT", "release.gitea.draft", null, false));
        }
        if (gitea.isDraft()) {
            gitea.getMilestone().setClose(false);
        }
        return gitea.isEnabled();
    }
}

