/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Collection;
import java.util.Locale;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.ArtifactoryMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GiteaMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GithubMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.GitlabMavenDeployerValidator;
import org.jreleaser.model.internal.validation.deploy.maven.Nexus2MavenDeployerValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MavenDeployersValidator
extends Validator {
    public static void validateMavenDeployers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Maven maven = context.getModel().getDeploy().getMaven();
        context.getLogger().debug("deploy.maven");
        ArtifactoryMavenDeployerValidator.validateArtifactoryMavenDeployer(context, mode, errors);
        GiteaMavenDeployerValidator.validateGiteaMavenDeployer(context, mode, errors);
        GithubMavenDeployerValidator.validateGithubMavenDeployer(context, mode, errors);
        GitlabMavenDeployerValidator.validateGitlabMavenDeployer(context, mode, errors);
        Nexus2MavenDeployerValidator.validateNexus2MavenDeployer(context, mode, errors);
        if (mode.validateDeploy() || mode.validateConfig()) {
            boolean activeSet = maven.isActiveSet();
            maven.resolveEnabled(context.getModel().getProject());
            if (maven.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = !maven.getActiveArtifactories().isEmpty() || !maven.getActiveGiteas().isEmpty() || !maven.getActiveGithubs().isEmpty() || !maven.getActiveGitlabs().isEmpty() || !maven.getActiveNexus2s().isEmpty();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    maven.disable();
                }
            }
        }
    }

    static void validateMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, MavenDeployer mavenDeployer, Errors errors) {
        context.getLogger().debug("deploy.maven.{}.{}", new Object[]{mavenDeployer.getType(), mavenDeployer.getName()});
        if (!mavenDeployer.isActiveSet()) {
            mavenDeployer.setActive(Active.NEVER);
        }
        if (!mavenDeployer.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        String baseEnvKey = mavenDeployer.getType().toLowerCase(Locale.ENGLISH);
        String deployerPrefix = "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName();
        mavenDeployer.setUrl(MavenDeployersValidator.checkProperty(context, baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_URL", "maven.deploy." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".url", mavenDeployer.getUrl(), errors));
        if (StringUtils.isNotBlank((String)mavenDeployer.getUrl()) && mavenDeployer.getUrl().endsWith("/")) {
            mavenDeployer.setUrl(mavenDeployer.getUrl().substring(0, mavenDeployer.getUrl().length() - 1));
        }
        switch (mavenDeployer.resolveAuthorization()) {
            case BEARER: {
                mavenDeployer.setPassword(MavenDeployersValidator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_PASSWORD", baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_TOKEN", baseEnvKey + "_PASSWORD", baseEnvKey + "_TOKEN"}), "maven.deploy." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                mavenDeployer.setUsername(MavenDeployersValidator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_USERNAME", baseEnvKey + "_USERNAME"}), "maven.deploy." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".username", mavenDeployer.getUsername(), errors, context.isDryrun()));
                mavenDeployer.setPassword(MavenDeployersValidator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_PASSWORD", baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_TOKEN", baseEnvKey + "_PASSWORD", baseEnvKey + "_TOKEN"}), "maven.deploy." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".password", mavenDeployer.getPassword(), errors, context.isDryrun()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{deployerPrefix + ".authorization", "NONE"}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                mavenDeployer.disable();
            }
        }
        MavenDeployersValidator.validateTimeout(mavenDeployer);
        if (mavenDeployer.getStagingRepositories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{deployerPrefix + ".stagingDirectories"}));
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isSignSet()) {
            mavenDeployer.setSign(true);
        }
        if (mavenDeployer.isApplyMavenCentralRules() && !mavenDeployer.isVerifyPomSet()) {
            mavenDeployer.setVerifyPom(true);
        }
        if (mavenDeployer.isSign() && !context.getModel().getSigning().isEnabled() && !context.isDryrun()) {
            errors.configuration(RB.$((String)"validation_maven_deployer_signing", (Object[])new Object[]{deployerPrefix}));
        }
    }
}

