/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Ftp;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class FtpUploader
extends AbstractUploader<org.jreleaser.model.api.upload.FtpUploader, FtpUploader>
implements Ftp {
    private String username;
    private String password;
    private String host;
    private Integer port;
    private String path;
    private String downloadUrl;
    private final org.jreleaser.model.api.upload.FtpUploader immutable = new org.jreleaser.model.api.upload.FtpUploader(){

        public String getPath() {
            return FtpUploader.this.path;
        }

        public String getDownloadUrl() {
            return FtpUploader.this.downloadUrl;
        }

        public String getUsername() {
            return FtpUploader.this.username;
        }

        public String getPassword() {
            return FtpUploader.this.password;
        }

        public String getHost() {
            return FtpUploader.this.host;
        }

        public Integer getPort() {
            return FtpUploader.this.port;
        }

        public String getType() {
            return FtpUploader.this.type;
        }

        public String getName() {
            return FtpUploader.this.name;
        }

        public boolean isSnapshotSupported() {
            return FtpUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return FtpUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return FtpUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return FtpUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return FtpUploader.this.isChecksums();
        }

        public Active getActive() {
            return FtpUploader.this.active;
        }

        public boolean isEnabled() {
            return FtpUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FtpUploader.this.asMap(full));
        }

        public String getPrefix() {
            return FtpUploader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FtpUploader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return FtpUploader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return FtpUploader.this.readTimeout;
        }
    };

    public FtpUploader() {
        super("ftp");
    }

    @Override
    public org.jreleaser.model.api.upload.FtpUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FtpUploader source) {
        super.merge(source);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.host = this.merge(this.host, source.host);
        this.port = this.merge(this.port, source.port);
        this.path = this.merge(this.path, source.path);
        this.downloadUrl = this.merge(this.downloadUrl, source.downloadUrl);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return null != this.port ? this.port : 21;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("port", this.getPort());
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }

    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        Map<String, Object> p = this.artifactProps(context.fullProps(), artifact);
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.path, p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }
}

