/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Icon;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class AppImagePackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.AppImagePackager, AppImagePackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final AppImageRepository repository = new AppImageRepository();
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<org.jreleaser.model.internal.common.Icon> icons = new ArrayList<org.jreleaser.model.internal.common.Icon>();
    private final List<String> categories = new ArrayList<String>();
    private final Set<String> skipReleases = new LinkedHashSet<String>();
    private String componentId;
    private String developerName;
    private Boolean requiresTerminal;
    private final org.jreleaser.model.api.packagers.AppImagePackager immutable = new org.jreleaser.model.api.packagers.AppImagePackager(){
        private List<? extends org.jreleaser.model.api.common.Screenshot> screenshots;
        private List<? extends Icon> icons;

        public String getComponentId() {
            return AppImagePackager.this.componentId;
        }

        public List<String> getCategories() {
            return Collections.unmodifiableList(AppImagePackager.this.categories);
        }

        public String getDeveloperName() {
            return AppImagePackager.this.developerName;
        }

        public boolean isRequiresTerminal() {
            return AppImagePackager.this.isRequiresTerminal();
        }

        public List<? extends org.jreleaser.model.api.common.Screenshot> getScreenshots() {
            if (null == this.screenshots) {
                this.screenshots = AppImagePackager.this.screenshots.stream().map(Screenshot::asImmutable).collect(Collectors.toList());
            }
            return this.screenshots;
        }

        public List<? extends Icon> getIcons() {
            if (null == this.icons) {
                this.icons = AppImagePackager.this.icons.stream().map(org.jreleaser.model.internal.common.Icon::asImmutable).collect(Collectors.toList());
            }
            return this.icons;
        }

        public Set<String> getSkipReleases() {
            return Collections.unmodifiableSet(AppImagePackager.this.skipReleases);
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return AppImagePackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return AppImagePackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return AppImagePackager.this.templateDirectory;
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(AppImagePackager.this.skipTemplates);
        }

        public String getType() {
            return AppImagePackager.this.type;
        }

        public String getDownloadUrl() {
            return AppImagePackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return AppImagePackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return AppImagePackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return AppImagePackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return AppImagePackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return AppImagePackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return AppImagePackager.this.isContinueOnError();
        }

        public Active getActive() {
            return AppImagePackager.this.active;
        }

        public boolean isEnabled() {
            return AppImagePackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(AppImagePackager.this.asMap(full));
        }

        public String getPrefix() {
            return AppImagePackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(AppImagePackager.this.extraProperties);
        }
    };

    public AppImagePackager() {
        super("appimage");
    }

    @Override
    public org.jreleaser.model.api.packagers.AppImagePackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(AppImagePackager source) {
        super.merge(source);
        this.componentId = this.merge(this.componentId, source.componentId);
        this.developerName = this.merge(this.developerName, source.developerName);
        this.requiresTerminal = this.merge(this.requiresTerminal, source.requiresTerminal);
        this.setRepository(source.repository);
        this.setCategories(this.merge(this.categories, source.categories));
        this.setScreenshots(this.merge(this.screenshots, source.screenshots));
        this.setIcons(this.merge(this.icons, source.icons));
        this.setSkipReleases(this.merge(this.skipReleases, source.skipReleases));
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return CollectionUtils.setOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP});
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> tags) {
        this.categories.clear();
        this.categories.addAll(tags);
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public boolean isRequiresTerminal() {
        return this.requiresTerminal != null && this.requiresTerminal != false;
    }

    public void setRequiresTerminal(Boolean requiresTerminal) {
        this.requiresTerminal = requiresTerminal;
    }

    public boolean isRequiresTerminalSet() {
        return this.requiresTerminal != null;
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<org.jreleaser.model.internal.common.Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<org.jreleaser.model.internal.common.Icon> icons) {
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(org.jreleaser.model.internal.common.Icon icon) {
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public Set<String> getSkipReleases() {
        return this.skipReleases;
    }

    public void setSkipReleases(Set<String> tags) {
        this.skipReleases.clear();
        this.skipReleases.addAll(tags);
    }

    public AppImageRepository getRepository() {
        return this.repository;
    }

    public void setRepository(AppImageRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> map) {
        super.asMap(full, map);
        map.put("componentId", this.componentId);
        map.put("categories", this.categories);
        map.put("developerName", this.developerName);
        map.put("requiresTerminal", this.isRequiresTerminal());
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        map.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (org.jreleaser.model.internal.common.Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        map.put("icons", sm);
        map.put("skipReleases", this.skipReleases);
        map.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipAppImage"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class AppImageRepository
    extends PackagerRepository {
        public AppImageRepository() {
            super("appimage", "appimage");
        }
    }
}

