/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.JavaArchiveAssembler;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Executable;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class JavaArchiveAssembler
extends AbstractAssembler<JavaArchiveAssembler, org.jreleaser.model.api.assemble.JavaArchiveAssembler> {
    private final Set<Archive.Format> formats = new LinkedHashSet<Archive.Format>();
    private final List<org.jreleaser.model.internal.common.Glob> jars = new ArrayList<org.jreleaser.model.internal.common.Glob>();
    private final List<org.jreleaser.model.internal.common.Glob> files = new ArrayList<org.jreleaser.model.internal.common.Glob>();
    private final Java java = new Java();
    private final org.jreleaser.model.internal.common.Executable executable = new org.jreleaser.model.internal.common.Executable();
    private final org.jreleaser.model.internal.common.Artifact mainJar = new org.jreleaser.model.internal.common.Artifact();
    private String archiveName;
    private String templateDirectory;
    private final org.jreleaser.model.api.assemble.JavaArchiveAssembler immutable = new org.jreleaser.model.api.assemble.JavaArchiveAssembler(){
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;
        private List<? extends Glob> jars;
        private List<? extends Glob> files;

        public String getArchiveName() {
            return JavaArchiveAssembler.this.archiveName;
        }

        public Set<Archive.Format> getFormats() {
            return Collections.unmodifiableSet(JavaArchiveAssembler.this.formats);
        }

        public Platform getPlatform() {
            return JavaArchiveAssembler.this.platform.asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return JavaArchiveAssembler.this.getDistributionType();
        }

        public String getType() {
            return JavaArchiveAssembler.this.type;
        }

        public Stereotype getStereotype() {
            return JavaArchiveAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return JavaArchiveAssembler.this.isExported();
        }

        public String getName() {
            return JavaArchiveAssembler.this.name;
        }

        public String getTemplateDirectory() {
            return JavaArchiveAssembler.this.templateDirectory;
        }

        public Executable getExecutable() {
            return JavaArchiveAssembler.this.executable.asImmutable();
        }

        public Artifact getMainJar() {
            return JavaArchiveAssembler.this.mainJar.asImmutable();
        }

        public JavaArchiveAssembler.Java getJava() {
            return JavaArchiveAssembler.this.java.asImmutable();
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = JavaArchiveAssembler.this.fileSets.stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = JavaArchiveAssembler.this.outputs.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public List<? extends Glob> getJars() {
            if (null == this.jars) {
                this.jars = JavaArchiveAssembler.this.jars.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = JavaArchiveAssembler.this.files.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Active getActive() {
            return JavaArchiveAssembler.this.active;
        }

        public boolean isEnabled() {
            return JavaArchiveAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JavaArchiveAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return JavaArchiveAssembler.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JavaArchiveAssembler.this.extraProperties);
        }
    };

    public JavaArchiveAssembler() {
        super("java-archive");
    }

    @Override
    public org.jreleaser.model.api.assemble.JavaArchiveAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.JAVA_BINARY;
    }

    @Override
    public void merge(JavaArchiveAssembler source) {
        super.merge(source);
        this.archiveName = this.merge(source.archiveName, source.archiveName);
        this.templateDirectory = this.merge(this.templateDirectory, source.templateDirectory);
        this.setFormats(this.merge(this.formats, source.formats));
        this.setExecutable(source.executable);
        this.setJava(source.java);
        this.setMainJar(source.mainJar);
        this.setJars(this.merge(this.jars, source.jars));
        this.setFiles(this.merge(this.files, source.files));
    }

    public String getResolvedArchiveName(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.archiveName, props);
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.merge(java);
    }

    public org.jreleaser.model.internal.common.Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(org.jreleaser.model.internal.common.Executable executable) {
        this.executable.merge(executable);
    }

    public org.jreleaser.model.internal.common.Artifact getMainJar() {
        return this.mainJar;
    }

    public void setMainJar(org.jreleaser.model.internal.common.Artifact mainJar) {
        this.mainJar.merge(mainJar);
    }

    public Set<Archive.Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<Archive.Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public void addFormat(Archive.Format format) {
        this.formats.add(format);
    }

    public void addFormat(String str) {
        this.formats.add(Archive.Format.of((String)str));
    }

    public List<org.jreleaser.model.internal.common.Glob> getJars() {
        return this.jars;
    }

    public void setJars(List<org.jreleaser.model.internal.common.Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    public void addJars(List<org.jreleaser.model.internal.common.Glob> jars) {
        this.jars.addAll(jars);
    }

    public void addJar(org.jreleaser.model.internal.common.Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    public List<org.jreleaser.model.internal.common.Glob> getFiles() {
        return this.files;
    }

    public void setFiles(List<org.jreleaser.model.internal.common.Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(List<org.jreleaser.model.internal.common.Glob> files) {
        this.files.addAll(files);
    }

    public void addFile(org.jreleaser.model.internal.common.Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("archiveName", this.archiveName);
        props.put("formats", this.formats);
        props.put("templateDirectory", this.templateDirectory);
        props.put("executable", this.executable.asMap(full));
        props.put("mainJar", this.mainJar.asMap(full));
        Map<String, Object> javaMap = this.java.asMap(full);
        if (!javaMap.isEmpty()) {
            props.put("java", javaMap);
        }
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("glob " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
    }

    public static final class Java
    extends AbstractModelObject<Java>
    implements Domain {
        private final List<String> options = new ArrayList<String>();
        private String mainModule;
        private String mainClass;
        private final JavaArchiveAssembler.Java immutable = new JavaArchiveAssembler.Java(){

            public String getMainClass() {
                return mainClass;
            }

            public String getMainModule() {
                return mainModule;
            }

            public List<String> getOptions() {
                return Collections.unmodifiableList(options);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public JavaArchiveAssembler.Java asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Java source) {
            this.mainModule = this.merge(this.mainModule, source.mainModule);
            this.mainClass = this.merge(this.mainClass, source.mainClass);
            this.setOptions(this.merge(this.options, source.options));
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public String getMainModule() {
            return this.mainModule;
        }

        public void setMainModule(String mainModule) {
            this.mainModule = mainModule;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public void setOptions(List<String> options) {
            this.options.clear();
            this.options.addAll(options);
        }

        public void addOptions(List<String> options) {
            this.options.addAll(options);
        }

        public boolean isSet() {
            return StringUtils.isNotBlank((String)this.mainModule) || StringUtils.isNotBlank((String)this.mainClass) || !this.options.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (StringUtils.isNotBlank((String)this.mainModule)) {
                map.put("mainModule", this.mainModule);
            }
            if (StringUtils.isNotBlank((String)this.mainClass)) {
                map.put("mainClass", this.mainClass);
            }
            if (!this.options.isEmpty()) {
                map.put("options", this.options);
            }
            return map;
        }
    }
}

