/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.internal.Previews;

class GitHubRequest {
    private static final List<String> METHODS_WITHOUT_BODY = Arrays.asList("GET", "DELETE");
    private final List<Entry> args;
    private final Map<String, String> headers;
    private final Map<String, Object> injectedMappingValues;
    private final String apiUrl;
    private final String urlPath;
    private final String method;
    private final RateLimitTarget rateLimitTarget;
    private final InputStream body;
    private final boolean forceBody;
    private final URL url;

    private GitHubRequest(@Nonnull List<Entry> args, @Nonnull Map<String, String> headers, @Nonnull Map<String, Object> injectedMappingValues, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @Nonnull RateLimitTarget rateLimitTarget, @CheckForNull InputStream body, boolean forceBody) throws MalformedURLException {
        this.args = Collections.unmodifiableList(new ArrayList<Entry>(args));
        this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, String>(headers));
        this.injectedMappingValues = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(injectedMappingValues));
        this.apiUrl = apiUrl;
        this.urlPath = urlPath;
        this.method = method;
        this.rateLimitTarget = rateLimitTarget;
        this.body = body;
        this.forceBody = forceBody;
        String tailApiUrl = this.buildTailApiUrl();
        this.url = GitHubRequest.getApiURL(apiUrl, tailApiUrl);
    }

    public static Builder<?> newBuilder() {
        return new Builder();
    }

    @Nonnull
    static URL getApiURL(String apiUrl, String tailApiUrl) throws MalformedURLException {
        if (tailApiUrl.startsWith("/")) {
            if ("github.com".equals(apiUrl)) {
                return new URL("https://api.github.com" + tailApiUrl);
            }
            return new URL(apiUrl + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    static String transformEnum(Enum<?> en) {
        return en.toString().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    @Nonnull
    public String method() {
        return this.method;
    }

    @Nonnull
    public RateLimitTarget rateLimitTarget() {
        return this.rateLimitTarget;
    }

    @Nonnull
    public List<Entry> args() {
        return this.args;
    }

    @Nonnull
    public Map<String, String> headers() {
        return this.headers;
    }

    @Nonnull
    public Map<String, Object> injectedMappingValues() {
        return this.injectedMappingValues;
    }

    @Nonnull
    public String apiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public String urlPath() {
        return this.urlPath;
    }

    @Nonnull
    public String contentType() {
        return this.headers.get("Content-type");
    }

    @CheckForNull
    public InputStream body() {
        return this.body;
    }

    @Nonnull
    public URL url() {
        return this.url;
    }

    public boolean inBody() {
        return this.forceBody || !METHODS_WITHOUT_BODY.contains(this.method);
    }

    public Builder<?> toBuilder() {
        return new Builder(this.args, this.headers, this.injectedMappingValues, this.apiUrl, this.urlPath, this.method, this.rateLimitTarget, this.body, this.forceBody);
    }

    private String buildTailApiUrl() {
        String tailApiUrl = this.urlPath;
        if (!this.inBody() && !this.args.isEmpty() && tailApiUrl.startsWith("/")) {
            try {
                StringBuilder argString = new StringBuilder();
                boolean questionMarkFound = tailApiUrl.indexOf(63) != -1;
                argString.append(questionMarkFound ? (char)'&' : '?');
                ListIterator<Entry> it = this.args.listIterator();
                while (it.hasNext()) {
                    Entry arg = (Entry)it.next();
                    argString.append(URLEncoder.encode(arg.key, StandardCharsets.UTF_8.name()));
                    argString.append('=');
                    argString.append(URLEncoder.encode(arg.value.toString(), StandardCharsets.UTF_8.name()));
                    if (!it.hasNext()) continue;
                    argString.append('&');
                }
                tailApiUrl = tailApiUrl + argString;
            }
            catch (UnsupportedEncodingException e) {
                throw new GHException("UTF-8 encoding required", e);
            }
        }
        return tailApiUrl;
    }

    private static String urlPathEncode(String value) {
        try {
            return new URI(null, null, value, null, null).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected static class Entry {
        final String key;
        final Object value;

        protected Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class Builder<B extends Builder<B>> {
        @Nonnull
        private final List<Entry> args;
        @Nonnull
        private final Map<String, String> headers;
        @Nonnull
        private final Map<String, Object> injectedMappingValues;
        @Nonnull
        private String apiUrl;
        @Nonnull
        private String urlPath;
        @Nonnull
        private String method;
        @Nonnull
        private RateLimitTarget rateLimitTarget;
        private InputStream body;
        private boolean forceBody;

        protected Builder() {
            this(new ArrayList<Entry>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), "https://api.github.com", "/", "GET", RateLimitTarget.CORE, null, false);
        }

        private Builder(@Nonnull List<Entry> args, @Nonnull Map<String, String> headers, @Nonnull Map<String, Object> injectedMappingValues, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @Nonnull RateLimitTarget rateLimitTarget, @CheckForNull @WillClose InputStream body, boolean forceBody) {
            this.args = new ArrayList<Entry>(args);
            this.headers = new LinkedHashMap<String, String>(headers);
            this.injectedMappingValues = new LinkedHashMap<String, Object>(injectedMappingValues);
            this.apiUrl = apiUrl;
            this.urlPath = urlPath;
            this.method = method;
            this.rateLimitTarget = rateLimitTarget;
            this.body = body;
            this.forceBody = forceBody;
        }

        public GitHubRequest build() throws MalformedURLException {
            return new GitHubRequest(this.args, this.headers, this.injectedMappingValues, this.apiUrl, this.urlPath, this.method, this.rateLimitTarget, this.body, this.forceBody);
        }

        public B withApiUrl(String url) {
            this.apiUrl = url;
            return (B)this;
        }

        public B setHeader(String name, String value) {
            this.headers.put(name, value);
            return (B)this;
        }

        public B withHeader(String name, String value) {
            String oldValue = this.headers.get(name);
            if (!StringUtils.isBlank((CharSequence)oldValue)) {
                value = oldValue + ", " + value;
            }
            return this.setHeader(name, value);
        }

        public B injectMappingValue(@NonNull Object value) {
            return this.injectMappingValue(value.getClass().getName(), value);
        }

        public B injectMappingValue(@NonNull String name, Object value) {
            this.injectedMappingValues.put(name, value);
            return (B)this;
        }

        public B withPreview(String name) {
            return this.withHeader("Accept", name);
        }

        public B withPreview(Previews preview) {
            return this.withPreview(preview.mediaType());
        }

        public B with(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.with(entry.getKey(), entry.getValue());
            }
            return (B)this;
        }

        public B with(String key, int value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, long value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, boolean value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Enum<?> e) {
            if (e == null) {
                return this.with(key, (Object)null);
            }
            return this.with(key, GitHubRequest.transformEnum(e));
        }

        public B with(String key, String value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Collection<?> value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Map<?, ?> value) {
            return this.with(key, (Object)value);
        }

        public B with(@WillClose InputStream body) {
            this.body = body;
            return (B)this;
        }

        public B withNullable(String key, Object value) {
            this.args.add(new Entry(key, value));
            return (B)this;
        }

        public B with(String key, Object value) {
            if (value != null) {
                this.args.add(new Entry(key, value));
            }
            return (B)this;
        }

        public B set(String key, Object value) {
            this.remove(key);
            return this.with(key, value);
        }

        public B remove(String key) {
            int index = 0;
            while (index < this.args.size()) {
                if (this.args.get((int)index).key.equals(key)) {
                    this.args.remove(index);
                    continue;
                }
                ++index;
            }
            return (B)this;
        }

        public B method(@Nonnull String method) {
            this.method = method;
            return (B)this;
        }

        public B rateLimit(@Nonnull RateLimitTarget rateLimitTarget) {
            this.rateLimitTarget = rateLimitTarget;
            return (B)this;
        }

        public B contentType(String contentType) {
            this.headers.put("Content-type", contentType);
            return (B)this;
        }

        B setRawUrlPath(@Nonnull String rawUrlPath) {
            Objects.requireNonNull(rawUrlPath);
            if (!rawUrlPath.startsWith("http")) {
                throw new GHException("Raw URL must start with 'http'");
            }
            this.urlPath = rawUrlPath;
            return (B)this;
        }

        public B withUrlPath(@Nonnull String urlPath, String ... urlPathItems) {
            if (urlPathItems.length == 0 && !urlPath.startsWith("/")) {
                return this.setRawUrlPath(urlPath);
            }
            if (!this.urlPath.startsWith("/")) {
                throw new GHException("Cannot append to url path after setting a full url");
            }
            String tailUrlPath = urlPath;
            if (urlPathItems.length != 0) {
                tailUrlPath = tailUrlPath + "/" + String.join((CharSequence)"/", urlPathItems);
            }
            tailUrlPath = StringUtils.prependIfMissing((String)tailUrlPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            this.urlPath = GitHubRequest.urlPathEncode(tailUrlPath);
            return (B)this;
        }

        public B inBody() {
            this.forceBody = true;
            return (B)this;
        }
    }
}

