/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.templates;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.templates.TemplateGenerationException;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.templates.VersionDecoratingWriter;
import org.jreleaser.util.StringUtils;

public class TemplateGenerator {
    private final JReleaserLogger logger;
    private final String distributionName;
    private final Distribution.DistributionType distributionType;
    private final String packagerName;
    private final String announcerName;
    private final String assemblerType;
    private final String assemblerName;
    private final Path outputDirectory;
    private final boolean overwrite;
    private final boolean snapshot;

    private TemplateGenerator(JReleaserLogger logger, String distributionName, Distribution.DistributionType distributionType, String assemblerType, String assemblerName, String packagerName, String announcerName, Path outputDirectory, boolean overwrite, boolean snapshot) {
        this.logger = logger;
        this.distributionName = distributionName;
        this.distributionType = distributionType;
        this.assemblerType = assemblerType;
        this.assemblerName = assemblerName;
        this.packagerName = packagerName;
        this.announcerName = announcerName;
        String directory = "distributions";
        if (StringUtils.isNotBlank((String)announcerName)) {
            directory = "templates";
        }
        if (StringUtils.isNotBlank((String)assemblerType)) {
            directory = "assemblers";
        }
        this.outputDirectory = outputDirectory.resolve(directory);
        this.overwrite = overwrite;
        this.snapshot = snapshot;
    }

    public Path generate() throws TemplateGenerationException {
        if (StringUtils.isNotBlank((String)this.announcerName)) {
            return this.generateAnnouncer();
        }
        if (StringUtils.isNotBlank((String)this.assemblerName) && StringUtils.isNotBlank((String)this.assemblerType)) {
            return this.generateAssembler();
        }
        return this.generatePackager();
    }

    private Path generateAnnouncer() throws TemplateGenerationException {
        if (!JReleaserSupport.supportedAnnouncers().contains(this.announcerName)) {
            this.logger.error(RB.$((String)"templates.announcer.not.supported", (Object[])new Object[0]), new Object[]{this.announcerName});
            return null;
        }
        this.logger.info(RB.$((String)"templates.create.directory", (Object[])new Object[0]), new Object[]{this.outputDirectory.toAbsolutePath()});
        try {
            Files.createDirectories(this.outputDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        TemplateResource value = TemplateUtils.resolveTemplate(this.logger, "announcers/" + this.announcerName + ".tpl");
        Path outputFile = this.outputDirectory.resolve(this.announcerName + ".tpl");
        this.logger.info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
        try (BufferedWriter fileWriter = Files.newBufferedWriter(outputFile, this.overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             VersionDecoratingWriter decoratedWriter = new VersionDecoratingWriter(fileWriter);){
            IOUtils.copy((Reader)value.getReader(), (Writer)decoratedWriter);
        }
        catch (FileAlreadyExistsException e) {
            this.logger.error(RB.$((String)"templates.file_exists.error", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
            return null;
        }
        catch (Exception e) {
            throw this.fail(e);
        }
        return outputFile;
    }

    private Path generateAssembler() throws TemplateGenerationException {
        if (!JReleaserSupport.supportedAssemblers().contains(this.assemblerType)) {
            this.logger.error(RB.$((String)"templates.assembler.not.supported", (Object[])new Object[0]), new Object[]{this.assemblerType});
            return null;
        }
        Path output = this.outputDirectory.resolve(this.assemblerName).resolve(this.assemblerType).normalize();
        this.logger.info(RB.$((String)"templates.create.directory", (Object[])new Object[0]), new Object[]{output.toAbsolutePath()});
        try {
            Files.createDirectories(output, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        Map<String, TemplateResource> templates = TemplateUtils.resolveTemplates(this.logger, this.assemblerType, this.assemblerType, false);
        for (Map.Entry<String, TemplateResource> template : templates.entrySet()) {
            Path outputFile = output.resolve(template.getKey());
            this.logger.info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
            try {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw this.fail(e);
            }
            TemplateResource value = template.getValue();
            if (value.isReader()) {
                try {
                    BufferedWriter fileWriter = Files.newBufferedWriter(outputFile, this.overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    try {
                        VersionDecoratingWriter decoratedWriter = new VersionDecoratingWriter(fileWriter);
                        try {
                            IOUtils.copy((Reader)value.getReader(), (Writer)decoratedWriter);
                            continue;
                        }
                        finally {
                            decoratedWriter.close();
                            continue;
                        }
                    }
                    finally {
                        if (fileWriter == null) continue;
                        ((Writer)fileWriter).close();
                        continue;
                    }
                }
                catch (FileAlreadyExistsException e) {
                    this.logger.error(RB.$((String)"templates.file_exists.error", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                    return null;
                }
                catch (Exception e) {
                    throw this.fail(e);
                }
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFile.toFile());){
                IOUtils.copy((InputStream)value.getInputStream(), (OutputStream)outputStream);
            }
            catch (FileAlreadyExistsException e) {
                this.logger.error(RB.$((String)"templates.file_exists.error", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                return null;
            }
            catch (Exception e) {
                throw this.fail(e);
            }
        }
        return output;
    }

    private Path generatePackager() throws TemplateGenerationException {
        if (!JReleaserSupport.supportedPackagers().contains(this.packagerName)) {
            this.logger.error(RB.$((String)"ERROR_packager_not_supported", (Object[])new Object[0]), new Object[]{this.packagerName});
            return null;
        }
        Path output = this.outputDirectory.resolve(this.distributionName).resolve(this.packagerName + (this.snapshot ? "-snapshot" : "")).normalize();
        this.logger.info(RB.$((String)"templates.create.directory", (Object[])new Object[0]), new Object[]{output.toAbsolutePath()});
        try {
            Files.createDirectories(output, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        Map<String, TemplateResource> templates = TemplateUtils.resolveTemplates(this.logger, this.distributionType.name(), this.packagerName, this.snapshot);
        for (Map.Entry<String, TemplateResource> template : templates.entrySet()) {
            Path outputFile = output.resolve(template.getKey());
            this.logger.info(RB.$((String)"templates.writing.file", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
            try {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw this.fail(e);
            }
            TemplateResource value = template.getValue();
            if (value.isReader()) {
                try {
                    BufferedWriter fileWriter = Files.newBufferedWriter(outputFile, this.overwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    try {
                        VersionDecoratingWriter decoratedWriter = new VersionDecoratingWriter(fileWriter);
                        try {
                            IOUtils.copy((Reader)value.getReader(), (Writer)decoratedWriter);
                            continue;
                        }
                        finally {
                            decoratedWriter.close();
                            continue;
                        }
                    }
                    finally {
                        if (fileWriter == null) continue;
                        ((Writer)fileWriter).close();
                        continue;
                    }
                }
                catch (FileAlreadyExistsException e) {
                    this.logger.error(RB.$((String)"templates.file_exists.error", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                    return null;
                }
                catch (Exception e) {
                    throw this.fail(e);
                }
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFile.toFile());){
                IOUtils.copy((InputStream)value.getInputStream(), (OutputStream)outputStream);
            }
            catch (FileAlreadyExistsException e) {
                this.logger.error(RB.$((String)"templates.file_exists.error", (Object[])new Object[0]), new Object[]{outputFile.toAbsolutePath()});
                return null;
            }
            catch (Exception e) {
                throw this.fail(e);
            }
        }
        return output;
    }

    private TemplateGenerationException fail(Exception e) throws TemplateGenerationException {
        throw new TemplateGenerationException(RB.$((String)"ERROR_unexpected_template_fail", (Object[])new Object[]{this.distributionType, this.distributionName, this.packagerName}), e);
    }

    public static TemplateGeneratorBuilder builder() {
        return new TemplateGeneratorBuilder();
    }

    public static class TemplateGeneratorBuilder {
        private JReleaserLogger logger;
        private String distributionName;
        private Distribution.DistributionType distributionType = Distribution.DistributionType.JAVA_BINARY;
        private String packagerName;
        private String announcerName;
        private String assemblerName;
        private String assemblerType;
        private Path outputDirectory;
        private boolean overwrite;
        private boolean snapshot;

        public TemplateGeneratorBuilder logger(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
            return this;
        }

        public TemplateGeneratorBuilder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public TemplateGeneratorBuilder distributionType(Distribution.DistributionType distributionType) {
            this.distributionType = distributionType;
            return this;
        }

        public TemplateGeneratorBuilder packagerName(String packagerName) {
            this.packagerName = packagerName;
            return this;
        }

        public TemplateGeneratorBuilder announcerName(String announcerName) {
            this.announcerName = announcerName;
            return this;
        }

        public TemplateGeneratorBuilder assemblerName(String assemblerName) {
            this.assemblerName = assemblerName;
            return this;
        }

        public TemplateGeneratorBuilder assemblerType(String assemblerType) {
            this.assemblerType = assemblerType;
            return this;
        }

        public TemplateGeneratorBuilder outputDirectory(Path outputDirectory) {
            this.outputDirectory = Objects.requireNonNull(outputDirectory, "'outputDirectory' must not be null");
            return this;
        }

        public TemplateGeneratorBuilder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public TemplateGeneratorBuilder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public TemplateGenerator build() {
            Objects.requireNonNull(this.logger, "'logger' must not be null");
            if (StringUtils.isBlank((String)this.announcerName)) {
                if (StringUtils.isNotBlank((String)this.assemblerType)) {
                    StringUtils.requireNonBlank((String)this.assemblerName, (String)"'assemblerName' must not be blank");
                } else if (StringUtils.isNotBlank((String)this.assemblerName)) {
                    StringUtils.requireNonBlank((String)this.assemblerType, (String)"'assemblerType' must not be blank");
                } else {
                    StringUtils.requireNonBlank((String)this.distributionName, (String)"'distributionName' must not be blank");
                    Objects.requireNonNull(this.distributionType, "'distributionType' must not be null");
                    StringUtils.requireNonBlank((String)this.packagerName, (String)"'packagerName' must not be blank");
                }
            }
            Objects.requireNonNull(this.outputDirectory, "'outputDirectory' must not be null");
            return new TemplateGenerator(this.logger, this.distributionName, this.distributionType, this.assemblerType, this.assemblerName, this.packagerName, this.announcerName, this.outputDirectory, this.overwrite, this.snapshot);
        }
    }
}

