/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.AbstractReleaser;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.gitlab.Gitlab;
import org.jreleaser.sdk.gitlab.api.GlFileUpload;
import org.jreleaser.sdk.gitlab.api.GlIssue;
import org.jreleaser.sdk.gitlab.api.GlLabel;
import org.jreleaser.sdk.gitlab.api.GlLinkRequest;
import org.jreleaser.sdk.gitlab.api.GlMilestone;
import org.jreleaser.sdk.gitlab.api.GlProject;
import org.jreleaser.sdk.gitlab.api.GlRelease;
import org.jreleaser.util.StringUtils;

public class GitlabReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.GitlabReleaser> {
    private final org.jreleaser.model.internal.release.GitlabReleaser gitlab;

    public GitlabReleaser(JReleaserContext context, List<Asset> assets) {
        super(context, assets);
        this.gitlab = context.getModel().getRelease().getGitlab();
    }

    public org.jreleaser.model.api.release.GitlabReleaser getReleaser() {
        return this.gitlab.asImmutable();
    }

    public String generateReleaseNotes() throws IOException {
        try {
            return ChangelogProvider.getChangelog((JReleaserContext)this.context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.gitlab.getResolvedRepoUrl(this.context.getModel())});
        String tagName = this.gitlab.getEffectiveTagName(this.context.getModel());
        try {
            Gitlab api = new Gitlab(this.context.getLogger(), this.gitlab.getApiEndpoint(), this.gitlab.getResolvedToken(), this.gitlab.getConnectTimeout(), this.gitlab.getReadTimeout());
            String branch = this.gitlab.getBranch();
            List<String> branchNames = api.listBranches(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier());
            if (!branchNames.contains(branch)) {
                throw new ReleaseException(RB.$((String)"ERROR_git_release_branch_not_exists", (Object[])new Object[]{branch, branchNames}));
            }
            String changelog = this.context.getChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.gitlab.getCanonicalRepoName()});
            GlRelease release = api.findReleaseByTag(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.gitlab.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), tagName);
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.gitlab.isMatch());
                    return;
                }
                if (this.gitlab.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    boolean update = false;
                    GlRelease updater = new GlRelease();
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.gitlab.getEffectiveReleaseName()});
                        updater.setName(this.gitlab.getEffectiveReleaseName());
                    }
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setDescription(changelog);
                    }
                    if (update) {
                        api.updateRelease(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), updater);
                    }
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        if (!this.assets.isEmpty()) {
                            Collection<GlFileUpload> uploads = api.uploadAssets(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), this.assets);
                            api.linkReleaseAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, this.gitlab.getProjectIdentifier(), uploads);
                        }
                        if (!this.gitlab.getUploadLinks().isEmpty()) {
                            Collection<GlLinkRequest> links = this.collectUploadLinks(this.gitlab);
                            api.linkAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, this.gitlab.getProjectIdentifier(), links);
                        }
                    }
                    this.updateIssues(this.gitlab, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{"GitLab", tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.gitlab.isMatch());
            return;
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + " " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        GlProject project;
        Gitlab api;
        block3: {
            org.jreleaser.model.internal.release.GitlabReleaser gitlab = this.context.getModel().getRelease().getGitlab();
            this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
            api = new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), password, gitlab.getConnectTimeout(), gitlab.getReadTimeout());
            project = null;
            try {
                project = api.findProject(repo, gitlab.getProjectIdentifier());
            }
            catch (RestAPIException e) {
                if (e.isNotFound()) break block3;
                throw e;
            }
        }
        if (null == project) {
            project = api.createProject(owner, repo);
        }
        return new Repository(Repository.Kind.GITLAB, owner, repo, project.getWebUrl(), project.getHttpUrlToRepo());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.internal.release.GitlabReleaser gitlab = this.context.getModel().getRelease().getGitlab();
        try {
            return new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), gitlab.getResolvedToken(), gitlab.getConnectTimeout(), gitlab.getReadTimeout()).findUser(email, name);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        org.jreleaser.model.internal.release.GitlabReleaser gitlab = this.context.getModel().getRelease().getGitlab();
        Gitlab api = new Gitlab(this.context.getLogger(), gitlab.getApiEndpoint(), gitlab.getResolvedToken(), gitlab.getConnectTimeout(), gitlab.getReadTimeout());
        List<Release> releases = api.listReleases(owner, repo, gitlab.getProjectIdentifier());
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Gitlab api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GlMilestone> milestone;
        org.jreleaser.model.internal.release.GitlabReleaser gitlab = this.context.getModel().getRelease().getGitlab();
        Collection<GlLinkRequest> links = this.collectUploadLinks(gitlab);
        if (this.context.isDryrun()) {
            if (!this.assets.isEmpty()) {
                for (Asset asset : this.assets) {
                    if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                }
            }
            if (!links.isEmpty()) {
                for (GlLinkRequest link : links) {
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{link.getName()});
                }
            }
            this.updateIssues(gitlab, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), tagName);
        }
        if (deleteTags || !gitlab.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GlRelease release = new GlRelease();
        release.setName(gitlab.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setRef(gitlab.getBranch());
        release.setDescription(changelog);
        api.createRelease(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), release);
        if (!this.assets.isEmpty()) {
            Collection<GlFileUpload> uploads = api.uploadAssets(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), this.assets);
            api.linkReleaseAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getProjectIdentifier(), uploads);
        }
        if (!links.isEmpty()) {
            api.linkAssets(gitlab.getOwner(), gitlab.getName(), release, gitlab.getProjectIdentifier(), links);
        }
        if (gitlab.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), gitlab.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), milestone.get());
        }
        this.updateIssues(gitlab, api);
    }

    private void updateIssues(org.jreleaser.model.internal.release.GitlabReleaser gitlab, Gitlab api) throws IOException {
        if (!gitlab.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        Integer projectIdentifier = api.findProject(gitlab.getName(), gitlab.getProjectIdentifier()).getId();
        String tagName = gitlab.getEffectiveTagName(this.context.getModel());
        String labelName = gitlab.getIssues().getLabel().getName();
        String labelColor = gitlab.getIssues().getLabel().getColor();
        Map props = gitlab.props(this.context.getModel());
        gitlab.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)gitlab.getIssues().getComment(), (Map)props);
        if (!labelColor.startsWith("#")) {
            try {
                Integer.parseInt(labelColor, 16);
                labelColor = "#" + labelColor;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        GlLabel glLabel = null;
        try {
            glLabel = api.getOrCreateLabel(projectIdentifier, labelName, labelColor, gitlab.getIssues().getLabel().getDescription());
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = gitlab.getIssues().getApplyMilestone();
        if (gitlab.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), gitlab.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(gitlab.getOwner(), gitlab.getName(), gitlab.getProjectIdentifier(), gitlab.getMilestone().getEffectiveName());
        }
        List<GlIssue> issues = api.listIssues(projectIdentifier);
        for (String issueNumber : issueNumbers) {
            GlIssue glIssue;
            Integer in = Integer.parseInt(issueNumber);
            Optional<GlIssue> op = issues.stream().filter(i -> i.getIid().equals(in)).findFirst();
            if (!op.isPresent() || !(glIssue = op.get()).getState().equals("closed") || !glIssue.getLabels().stream().noneMatch(l -> l.equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            api.addLabelToIssue(projectIdentifier, glIssue, glLabel);
            api.commentOnIssue(projectIdentifier, glIssue, comment);
            milestone.ifPresent(glMilestone -> this.applyMilestone(gitlab, api, projectIdentifier, issueNumber, glIssue, applyMilestone, (GlMilestone)glMilestone));
        }
    }

    private void applyMilestone(org.jreleaser.model.internal.release.GitlabReleaser gitlab, Gitlab api, Integer projectIdentifier, String issueNumber, GlIssue glIssue, Apply applyMilestone, GlMilestone targetMilestone) {
        GlMilestone issueMilestone = glIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(projectIdentifier, glIssue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(projectIdentifier, glIssue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private Collection<GlLinkRequest> collectUploadLinks(org.jreleaser.model.internal.release.GitlabReleaser gitlab) {
        ArrayList<GlLinkRequest> links = new ArrayList<GlLinkRequest>();
        for (Map.Entry e : gitlab.getUploadLinks().entrySet()) {
            Optional uploader = this.context.getModel().getUpload().getActiveUploader((String)e.getKey(), (String)e.getValue());
            if (!uploader.isPresent()) continue;
            this.collectUploadLinks((Uploader)uploader.get(), links);
        }
        return links;
    }

    private void collectUploadLinks(Uploader<?> uploader, List<GlLinkRequest> links) {
        List keys = uploader.resolveSkipKeys();
        keys.add("skipGitlabLinks");
        ArrayList<Object> artifacts = new ArrayList<Object>();
        if (uploader.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActive()) continue;
                Path path = artifact.getEffectivePath(this.context);
                if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
            }
        }
        if (uploader.isArtifacts()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (this.isSkip((ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive()) continue;
                    Path path = artifact.getEffectivePath(this.context, distribution);
                    if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    String platform = artifact.getPlatform();
                    String platformReplaced = distribution.getPlatform().applyReplacements(platform);
                    if (StringUtils.isNotBlank((String)platformReplaced)) {
                        artifact.getExtraProperties().put("platformReplaced", platformReplaced);
                    }
                    artifacts.add(artifact);
                }
            }
        }
        if (uploader.isSignatures() && this.context.getModel().getSigning().isEnabled()) {
            String extension = this.context.getModel().getSigning().isArmored() ? ".asc" : ".sig";
            ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                arrayList.add(Artifact.of((Path)signaturePath));
            }
            artifacts.addAll(arrayList);
        }
        for (Artifact artifact : artifacts) {
            links.add(GitlabReleaser.toLinkRequest(artifact.getEffectivePath(), uploader.getResolvedDownloadUrl(this.context, artifact)));
        }
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    private void deleteTags(Gitlab api, String owner, String repo, String projectIdentifier, String tagName) {
        try {
            api.deleteTag(owner, repo, projectIdentifier, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }

    private static GlLinkRequest toLinkRequest(Path path, String url) {
        GlLinkRequest link = new GlLinkRequest();
        link.setName(path.getFileName().toString());
        link.setUrl(url);
        link.setFilepath("/" + link.getName());
        return link;
    }
}

