/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.assemble.Assembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.assemble.AssemblerProcessor;
import org.jreleaser.model.spi.assemble.AssemblerProcessorFactory;

public class AssemblerProcessors {
    public static <A extends Assembler, S extends org.jreleaser.model.internal.assemble.Assembler<A>> AssemblerProcessor<A, S> findProcessor(JReleaserContext context, S assembler) {
        Map<String, AssemblerProcessor> processors = StreamSupport.stream(ServiceLoader.load(AssemblerProcessorFactory.class, AssemblerProcessors.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(AssemblerProcessorFactory::getName, factory -> factory.getAssemblerProcessor(context)));
        if (processors.containsKey(assembler.getType())) {
            AssemblerProcessor assemblerProcessor = processors.get(assembler.getType());
            assemblerProcessor.setAssembler(assembler);
            return assemblerProcessor;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_assembler", (Object[])new Object[]{assembler.getType()}));
    }
}

