/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.artifactory;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;

public class ArtifactoryArtifactUploader
extends AbstractArtifactUploader<ArtifactoryUploader, org.jreleaser.model.internal.upload.ArtifactoryUploader> {
    private org.jreleaser.model.internal.upload.ArtifactoryUploader uploader;

    public ArtifactoryArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.ArtifactoryUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.ArtifactoryUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "artifactory";
    }

    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String username = this.uploader.getResolvedUsername();
        String password = this.uploader.getResolvedPassword();
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            if (this.context.isDryrun()) continue;
            try {
                FormData data = ClientUtils.toFormData((Path)path);
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                switch (this.uploader.resolveAuthorization()) {
                    case BASIC: {
                        String auth = username + ":" + password;
                        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes());
                        auth = new String(encodedAuth);
                        headers.put("Authorization", "Basic " + auth);
                        break;
                    }
                    case BEARER: {
                        headers.put("Authorization", "Bearer " + password);
                        break;
                    }
                }
                headers.put("X-Checksum-Deploy", "false");
                headers.put("X-Checksum-Sha1", ChecksumUtils.checksum((Algorithm)Algorithm.SHA_1, (byte[])data.getData()));
                headers.put("X-Checksum-Sha256", ChecksumUtils.checksum((Algorithm)Algorithm.SHA_256, (byte[])data.getData()));
                headers.put("X-Checksum", ChecksumUtils.checksum((Algorithm)Algorithm.MD5, (byte[])data.getData()));
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
            }
        }
    }
}

