/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.internal.JReleaserModelPrinter;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import picocli.CommandLine;

@CommandLine.Command(name="config")
public class Config
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"-f", "--full"})
    boolean full;
    @CommandLine.ArgGroup
    Exclusive exclusive;

    @Override
    protected void doExecute(JReleaserContext context) {
        ModelValidator.validate((JReleaserContext)context);
        new JReleaserModelPrinter(this.parent.out).print(context.getModel().asMap(this.full));
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download()) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly()) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        if (this.changelog()) {
            return JReleaserContext.Mode.CHANGELOG;
        }
        if (this.announce()) {
            return JReleaserContext.Mode.ANNOUNCE;
        }
        return JReleaserContext.Mode.CONFIG;
    }

    private boolean download() {
        return this.exclusive != null && this.exclusive.download;
    }

    private boolean assembly() {
        return this.exclusive != null && this.exclusive.assembly;
    }

    private boolean changelog() {
        return this.exclusive != null && this.exclusive.changelog;
    }

    private boolean announce() {
        return this.exclusive != null && this.exclusive.announce;
    }

    static class Exclusive {
        @CommandLine.Option(names={"--announce"}, required=true)
        boolean announce;
        @CommandLine.Option(names={"-a", "--assembly"}, required=true)
        boolean assembly;
        @CommandLine.Option(names={"--changelog"}, required=true)
        boolean changelog;
        @CommandLine.Option(names={"-d", "--download"}, required=true)
        boolean download;

        Exclusive() {
        }
    }
}

