/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SdkmanAnnouncer;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SdkmanAnnouncerValidator
extends Validator {
    public static void validateSdkmanAnnouncer(JReleaserContext context, SdkmanAnnouncer sdkman, Errors errors) {
        context.getLogger().debug("announce.sdkman");
        context.getModel().getActiveDistributions().stream().filter(d -> d.getSdkman().isEnabled()).findFirst().ifPresent(distribution -> sdkman.setActive(Active.ALWAYS));
        if (!sdkman.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getModel().getRelease().getReleaser().isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            sdkman.disable();
            return;
        }
        sdkman.setConsumerKey(SdkmanAnnouncerValidator.checkProperty(context, "SDKMAN_CONSUMER_KEY", "sdkman.consumerKey", sdkman.getConsumerKey(), errors, context.isDryrun()));
        sdkman.setConsumerToken(SdkmanAnnouncerValidator.checkProperty(context, "SDKMAN_CONSUMER_TOKEN", "sdkman.consumerToken", sdkman.getConsumerToken(), errors, context.isDryrun()));
        SdkmanPackager sdkmanPackager = context.getModel().getPackagers().getSdkman();
        if (StringUtils.isBlank((String)sdkman.getConsumerKey()) && sdkmanPackager.isEnabled()) {
            sdkman.setConsumerKey(sdkmanPackager.getConsumerKey());
        }
        if (StringUtils.isBlank((String)sdkman.getConsumerToken()) && sdkmanPackager.isEnabled()) {
            sdkman.setConsumerToken(sdkmanPackager.getConsumerToken());
        }
        if (StringUtils.isBlank((String)sdkman.getReleaseNotesUrl())) {
            sdkman.setReleaseNotesUrl(context.getModel().getRelease().getReleaser().getReleaseNotesUrl());
        }
        if (context.getModel().getActiveDistributions().isEmpty()) {
            context.getLogger().warn(RB.$((String)"validation_skdman_disable", (Object[])new Object[0]));
            sdkman.disable();
        }
        if (null == sdkman.getCommand()) {
            sdkman.setCommand(Sdkman.Command.MAJOR);
        }
        SdkmanAnnouncerValidator.validateTimeout(sdkman);
    }
}

