/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.internal.upload.AbstractWebUploader;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class HttpUploader
extends AbstractWebUploader<org.jreleaser.model.api.upload.HttpUploader, HttpUploader> {
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String username;
    private String password;
    private Http.Authorization authorization;
    private Http.Method method;
    private final org.jreleaser.model.api.upload.HttpUploader immutable = new org.jreleaser.model.api.upload.HttpUploader(){

        public Http.Method getMethod() {
            return HttpUploader.this.method;
        }

        public String getUploadUrl() {
            return HttpUploader.this.uploadUrl;
        }

        public String getDownloadUrl() {
            return HttpUploader.this.downloadUrl;
        }

        public String getUsername() {
            return HttpUploader.this.username;
        }

        public String getPassword() {
            return HttpUploader.this.password;
        }

        public Http.Authorization getAuthorization() {
            return HttpUploader.this.authorization;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(HttpUploader.this.headers);
        }

        public String getType() {
            return HttpUploader.this.type;
        }

        public String getName() {
            return HttpUploader.this.name;
        }

        public boolean isSnapshotSupported() {
            return HttpUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return HttpUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return HttpUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return HttpUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return HttpUploader.this.isChecksums();
        }

        public Active getActive() {
            return HttpUploader.this.active;
        }

        public boolean isEnabled() {
            return HttpUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpUploader.this.asMap(full));
        }

        public String getPrefix() {
            return HttpUploader.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpUploader.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return HttpUploader.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return HttpUploader.this.readTimeout;
        }
    };

    public HttpUploader() {
        super("http");
    }

    @Override
    public org.jreleaser.model.api.upload.HttpUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpUploader source) {
        super.merge(source);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.authorization = this.merge(this.authorization, source.authorization);
        this.method = this.merge(this.method, source.method);
        this.setHeaders(this.merge(this.headers, source.headers));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    public Http.Method getMethod() {
        return this.method;
    }

    public void setMethod(Http.Method method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = Http.Method.of((String)method);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("authorization", this.authorization);
        props.put("method", this.method);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("headers", this.headers);
    }

    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.NONE;
        }
        return this.authorization;
    }

    public String getResolvedUsername() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.env((String)("HTTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }
}

