/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy.maven;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public abstract class AbstractMavenDeployer<S extends AbstractMavenDeployer<S, A>, A extends org.jreleaser.model.api.deploy.maven.MavenDeployer>
extends AbstractModelObject<S>
implements MavenDeployer<A>,
ExtraProperties {
    @JsonIgnore
    protected final String type;
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final List<String> stagingRepositories = new ArrayList<String>();
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected int connectTimeout;
    protected int readTimeout;
    protected Boolean sign;
    protected Boolean verifyPom;
    protected Boolean applyMavenCentralRules;
    protected String url;
    protected String username;
    protected String password;
    protected Http.Authorization authorization;

    protected AbstractMavenDeployer(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractMavenDeployer)source).active);
        this.enabled = this.merge(this.enabled, ((AbstractMavenDeployer)source).enabled);
        this.name = this.merge(this.name, ((AbstractMavenDeployer)source).name);
        this.connectTimeout = this.merge(this.connectTimeout, ((AbstractMavenDeployer)source).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((AbstractMavenDeployer)source).readTimeout);
        this.sign = this.merge(this.sign, ((AbstractMavenDeployer)source).sign);
        this.verifyPom = this.merge(this.verifyPom, ((AbstractMavenDeployer)source).verifyPom);
        this.applyMavenCentralRules = this.merge(this.applyMavenCentralRules, ((AbstractMavenDeployer)source).applyMavenCentralRules);
        this.url = this.merge(this.url, ((AbstractMavenDeployer)source).url);
        this.username = this.merge(this.username, ((AbstractMavenDeployer)source).username);
        this.password = this.merge(this.password, ((AbstractMavenDeployer)source).password);
        this.authorization = this.merge(this.authorization, ((AbstractMavenDeployer)source).authorization);
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractMavenDeployer)source).extraProperties));
        this.setStagingRepositories(this.merge(this.stagingRepositories, ((AbstractMavenDeployer)source).stagingRepositories));
    }

    @Override
    public String getPrefix() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    @Override
    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        if (project.isSnapshot()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public boolean isSign() {
        return this.sign != null && this.sign != false;
    }

    @Override
    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    @Override
    public boolean isSignSet() {
        return this.sign != null;
    }

    @Override
    public boolean isVerifyPom() {
        return this.verifyPom != null && this.verifyPom != false;
    }

    @Override
    public void setVerifyPom(Boolean verifyPom) {
        this.verifyPom = verifyPom;
    }

    @Override
    public boolean isVerifyPomSet() {
        return this.verifyPom != null;
    }

    @Override
    public boolean isApplyMavenCentralRules() {
        return this.applyMavenCentralRules != null && this.applyMavenCentralRules != false;
    }

    @Override
    public void setApplyMavenCentralRules(Boolean applyMavenCentralRules) {
        this.applyMavenCentralRules = applyMavenCentralRules;
    }

    @Override
    public boolean isApplyMavenCentralRulesSet() {
        return this.applyMavenCentralRules != null;
    }

    @Override
    public List<String> getStagingRepositories() {
        return this.stagingRepositories;
    }

    @Override
    public void setStagingRepositories(List<String> stagingRepositories) {
        this.stagingRepositories.clear();
        this.stagingRepositories.addAll(stagingRepositories);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    @Override
    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("authorization", this.authorization);
        props.put("url", this.url);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("sign", this.isSign());
        props.put("verifyPom", this.isVerifyPom());
        props.put("applyMavenCentralRules", this.isApplyMavenCentralRules());
        props.put("stagingRepositories", this.stagingRepositories);
        this.asMap(full, props);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);

    public String getResolvedUrl(Map<String, Object> props) {
        props.put("username", this.getResolvedUsername());
        props.put("owner", this.getResolvedUsername());
        props.putAll(this.getExtraProperties());
        return Templates.resolveTemplate((String)this.url, props);
    }

    public String getResolvedUsername() {
        return Env.env((String)(this.getType().toUpperCase(Locale.ENGLISH) + "_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.env((String)(this.getType().toUpperCase(Locale.ENGLISH) + "_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.BASIC;
        }
        return this.authorization;
    }
}

